/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.iso9660;

import com.github.stephenc.javaisotools.iso9660.ISO9660Directory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ISO9660DirectoryIterator
implements Iterator<ISO9660Directory> {
    private List<ISO9660Directory> dirCollection = new ArrayList<ISO9660Directory>();
    private Iterator<ISO9660Directory> dirCollectionIterator;

    public ISO9660DirectoryIterator(ISO9660Directory start, boolean sort) {
        if (sort) {
            this.setupSorted(start);
        } else {
            this.setupUnsorted(start);
        }
        this.reset();
    }

    public ISO9660DirectoryIterator(ISO9660Directory start) {
        this(start, true);
    }

    private void setupSorted(ISO9660Directory start) {
        List<ISO9660Directory> dirs = start.getDirectories();
        if (!dirs.isEmpty()) {
            LinkedList<ISO9660Directory> queue = new LinkedList<ISO9660Directory>();
            this.dirCollection.addAll(dirs);
            queue.addAll(dirs);
            while (!queue.isEmpty()) {
                ISO9660Directory dir = (ISO9660Directory)queue.removeFirst();
                dirs = dir == dir.getRoot().getMovedDirectoriesStore() ? dir.getDirectories() : this.checkMoved(dir.getDirectories());
                this.dirCollection.addAll(dirs);
                queue.addAll(dirs);
            }
        }
    }

    private List<ISO9660Directory> checkMoved(List<ISO9660Directory> dirs) {
        ArrayList<ISO9660Directory> copy = new ArrayList<ISO9660Directory>(dirs);
        for (ISO9660Directory dir : dirs) {
            if (!dir.isMoved()) continue;
            copy.remove(dir);
        }
        return copy;
    }

    private void setupUnsorted(ISO9660Directory start) {
        for (ISO9660Directory iso9660Directory : start.getDirectories()) {
            this.setupUnsorted(iso9660Directory);
        }
        this.dirCollection.add(start);
    }

    @Override
    public boolean hasNext() {
        return this.dirCollectionIterator.hasNext();
    }

    @Override
    public ISO9660Directory next() {
        return this.dirCollectionIterator.next();
    }

    @Override
    public void remove() {
        this.dirCollectionIterator.remove();
    }

    public void reset() {
        this.dirCollectionIterator = this.dirCollection.iterator();
    }
}

