/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.IClassScreener;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassScreener
implements IClassScreener {
    private static final Logger LOG = LoggerFactory.getLogger(ClassScreener.class);
    private static final String SEP = "[/\\\\]";
    private static final String START = "(?:^|[/\\\\])";
    private static final String JAVA_IDENTIFIER_PART = "[^./\\\\]";
    private final LinkedList<Matcher> patternList = new LinkedList();

    private static String dotsToRegex(String dotsName) {
        String tmp = dotsName.replace("$", "\\$");
        return tmp.replace(".", SEP);
    }

    public void addAllowedClass(String className) {
        String classRegex = START + ClassScreener.dotsToRegex(className) + ".class$";
        LOG.debug("Class regex: {}", (Object)classRegex);
        this.patternList.add(Pattern.compile(classRegex).matcher(""));
    }

    public void addAllowedPackage(String packageName) {
        if (packageName.endsWith(".")) {
            packageName = packageName.substring(0, packageName.length() - 1);
        }
        String packageRegex = START + ClassScreener.dotsToRegex(packageName) + SEP + JAVA_IDENTIFIER_PART + "+.class$";
        LOG.debug("Package regex: {}", (Object)packageRegex);
        this.patternList.add(Pattern.compile(packageRegex).matcher(""));
    }

    public void addAllowedPrefix(String prefix) {
        if (prefix.endsWith(".")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        LOG.debug("Allowed prefix: {}", (Object)prefix);
        String packageRegex = START + ClassScreener.dotsToRegex(prefix) + SEP;
        LOG.debug("Prefix regex: {}", (Object)packageRegex);
        this.patternList.add(Pattern.compile(packageRegex).matcher(""));
    }

    @Override
    public boolean matches(String fileName) {
        if (this.patternList.isEmpty()) {
            return true;
        }
        LOG.debug("Matching: {}", (Object)fileName);
        for (Matcher matcher : this.patternList) {
            matcher.reset(fileName);
            if (matcher.find()) {
                LOG.debug("\\tTrying [{}]: yes!", (Object)matcher.pattern());
                return true;
            }
            LOG.debug("\\tTrying [{}]: no", (Object)matcher.pattern());
        }
        return false;
    }

    @Override
    public boolean vacuous() {
        return this.patternList.isEmpty();
    }
}

