/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckBcel {
    private static final Logger LOG = LoggerFactory.getLogger(CheckBcel.class);
    private static final String ORG_APACHE_BCEL_REPOSITORY = "org.apache.bcel.Repository";
    private static final String ORG_APACHE_BCEL_CLASSFILE_EMPTY_VISITOR = "org.apache.bcel.classfile.EmptyVisitor";
    private static final String ORG_APACHE_BCEL_CONSTANTS = "org.apache.bcel.Constants";
    private static final String ORG_APACHE_BCEL_GENERIC_TYPE = "org.apache.bcel.generic.Type";
    private static final String ORG_APACHE_BCEL_GENERIC_OBJECT_TYPE = "org.apache.bcel.generic.ObjectType";

    private static boolean isFinal(Class<?> c) {
        return (c.getModifiers() & 0x10) != 0;
    }

    private static void error(String cname) {
        LOG.error("BCEL class compatibility error.");
        LOG.error("The version of class {} found was not compatible with\nSpotBugs.  Please remove any BCEL libraries that may be interfering.  This may happen\nif you have an old version of BCEL or a library that includes an old version of BCEL\nin an \"endorsed\" directory.", (Object)cname);
    }

    public static boolean check() {
        Class<?> repository;
        Class<?> emptyVis;
        Class<?> constants;
        Class<?> type;
        Class<?> objectType;
        try {
            objectType = Class.forName(ORG_APACHE_BCEL_GENERIC_OBJECT_TYPE);
            type = Class.forName(ORG_APACHE_BCEL_GENERIC_TYPE);
            constants = Class.forName(ORG_APACHE_BCEL_CONSTANTS);
            emptyVis = Class.forName(ORG_APACHE_BCEL_CLASSFILE_EMPTY_VISITOR);
            repository = Class.forName(ORG_APACHE_BCEL_REPOSITORY);
        }
        catch (ClassNotFoundException e) {
            LOG.error("One or more required BCEL classes were missing. Ensure that bcel.jar is placed at the same directory with spotbugs.jar");
            return false;
        }
        if (CheckBcel.isFinal(objectType)) {
            CheckBcel.error(ORG_APACHE_BCEL_GENERIC_OBJECT_TYPE);
            return false;
        }
        if (CheckBcel.isFinal(type)) {
            CheckBcel.error(ORG_APACHE_BCEL_GENERIC_TYPE);
            return false;
        }
        if (CheckBcel.isFinal(constants)) {
            CheckBcel.error(ORG_APACHE_BCEL_CONSTANTS);
            return false;
        }
        if (CheckBcel.isFinal(emptyVis)) {
            CheckBcel.error(ORG_APACHE_BCEL_CLASSFILE_EMPTY_VISITOR);
            return false;
        }
        if (CheckBcel.isFinal(repository)) {
            CheckBcel.error(ORG_APACHE_BCEL_REPOSITORY);
            return false;
        }
        return true;
    }
}

