/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.utils;

import com.power.common.util.CollectionUtil;
import com.power.common.util.StringUtil;
import com.power.doc.model.ApiParam;
import com.power.doc.utils.DocClassUtil;
import com.power.doc.utils.DocUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OpenApiSchemaUtil {
    public static final String NO_BODY_PARAM = "NO_BODY_PARAM";
    static final Pattern p = Pattern.compile("[A-Z]\\w+.*?|[A-Z]");

    public static Map<String, Object> primaryTypeSchema(String primaryType) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", DocUtil.javaTypeToOpenApiTypeConvert(primaryType));
        return map;
    }

    public static Map<String, Object> mapTypeSchema(String primaryType) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("type", "object");
        HashMap<String, String> items = new HashMap<String, String>();
        items.put("type", DocUtil.javaTypeToOpenApiTypeConvert(primaryType));
        map.put("additionalProperties", items);
        return map;
    }

    public static Map<String, Object> arrayTypeSchema(String primaryType) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "array");
        HashMap<String, String> items = new HashMap<String, String>();
        items.put("type", DocUtil.javaTypeToOpenApiTypeConvert(primaryType));
        map.put("items", items);
        return map;
    }

    public static Map<String, Object> returnSchema(String returnGicName) {
        if (StringUtil.isEmpty((String)returnGicName)) {
            return null;
        }
        returnGicName = returnGicName.replace(">", "");
        String[] types = returnGicName.split("<");
        StringBuilder builder = new StringBuilder();
        for (String str : types) {
            builder.append(DocClassUtil.getSimpleName(str).replace(",", ""));
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("$ref", builder.toString());
        return map;
    }

    public static String getClassNameFromParams(List<ApiParam> apiParams) {
        if (CollectionUtil.isNotEmpty(apiParams) && apiParams.size() == 1 && CollectionUtil.isEmpty(apiParams.get(0).getChildren())) {
            return "string";
        }
        for (ApiParam a : apiParams) {
            if (!StringUtil.isNotEmpty((String)a.getClassName())) continue;
            return OpenApiSchemaUtil.delClassName(a.getClassName());
        }
        return NO_BODY_PARAM;
    }

    public static String delClassName(String className) {
        return String.join((CharSequence)"", OpenApiSchemaUtil.getPatternResult(p, className));
    }

    public static List<String> getPatternResult(Pattern p, String content) {
        ArrayList<String> matchers = new ArrayList<String>();
        Matcher m = p.matcher(content);
        while (m.find()) {
            matchers.add(m.group());
        }
        return matchers;
    }

    public static List<String> getPatternResult(String rex, String content) {
        Pattern p = Pattern.compile(rex);
        ArrayList<String> matchers = new ArrayList<String>();
        Matcher m = p.matcher(content);
        while (m.find()) {
            matchers.add(m.group());
        }
        return matchers;
    }
}

