/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.template;

import com.power.common.util.StringUtil;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.RpcJavaMethod;
import com.power.doc.template.IBaseDocBuildTemplate;
import com.power.doc.utils.DocClassUtil;
import com.power.doc.utils.DocUtil;
import com.power.doc.utils.JavaClassUtil;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.JavaType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public interface IRpcDocTemplate
extends IBaseDocBuildTemplate {
    default public RpcJavaMethod convertToRpcJavaMethod(ApiConfig apiConfig, JavaMethod method) {
        JavaClass cls = method.getDeclaringClass();
        RpcJavaMethod rpcJavaMethod = new RpcJavaMethod();
        rpcJavaMethod.setName(method.getName());
        String methodDefine = this.methodDefinition(method);
        String scapeMethod = methodDefine.replaceAll("<", "&lt;");
        scapeMethod = scapeMethod.replaceAll(">", "&gt;");
        rpcJavaMethod.setMethodDefinition(methodDefine);
        rpcJavaMethod.setEscapeMethodDefinition(scapeMethod);
        rpcJavaMethod.setDesc(DocUtil.getEscapeAndCleanComment(method.getComment()));
        String apiNoteValue = DocUtil.getNormalTagComments(method, "apiNote", cls.getName());
        if (StringUtil.isEmpty((String)apiNoteValue)) {
            apiNoteValue = method.getComment();
        }
        rpcJavaMethod.setDetail(apiNoteValue != null ? apiNoteValue : "");
        String authorValue = DocUtil.getNormalTagComments(method, "author", cls.getName());
        if (apiConfig.isShowAuthor() && StringUtil.isNotEmpty((String)authorValue)) {
            rpcJavaMethod.setAuthor(authorValue);
        }
        List annotations = method.getAnnotations();
        for (JavaAnnotation annotation : annotations) {
            String annotationName = annotation.getType().getName();
            if (!"Deprecated".equals(annotationName)) continue;
            rpcJavaMethod.setDeprecated(true);
        }
        if (Objects.nonNull(method.getTagByName("deprecated"))) {
            rpcJavaMethod.setDeprecated(true);
        }
        return rpcJavaMethod;
    }

    default public String methodDefinition(JavaMethod method) {
        String[] arrays;
        StringBuilder methodBuilder = new StringBuilder();
        JavaType returnType = method.getReturnType();
        String simpleReturn = returnType.getCanonicalName();
        String returnClass = returnType.getGenericCanonicalName();
        returnClass = returnClass.replace(simpleReturn, JavaClassUtil.getClassSimpleName(simpleReturn));
        for (String str : arrays = DocClassUtil.getSimpleGicName(returnClass)) {
            String[] generics;
            if (str.contains("[")) {
                str = str.substring(0, str.indexOf("["));
            }
            for (String generic : generics = str.split("[<,]")) {
                if (generic.contains("extends")) {
                    String className = generic.substring(generic.lastIndexOf(" ") + 1);
                    returnClass = returnClass.replace(className, JavaClassUtil.getClassSimpleName(className));
                }
                if (generic.length() == 1 || generic.contains("extends")) continue;
                returnClass = returnClass.replaceAll(generic, JavaClassUtil.getClassSimpleName(generic));
            }
        }
        methodBuilder.append(returnClass).append(" ");
        ArrayList<String> params = new ArrayList<String>();
        List parameters = method.getParameters();
        for (JavaParameter parameter : parameters) {
            params.add(parameter.getType().getGenericValue() + " " + parameter.getName());
        }
        methodBuilder.append(method.getName()).append("(").append(String.join((CharSequence)", ", params)).append(")");
        return methodBuilder.toString();
    }
}

