/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.model;

import com.power.doc.constants.ApiReqParamInTypeEnum;
import com.power.doc.model.ApiParam;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class ApiReqParam {
    private String name;
    private String type;
    private String value;
    private String desc;
    private String paramIn;
    private boolean required;
    private String since = "-";
    private String pathPatterns;
    private String excludePathPatterns;

    public static ApiReqParam builder() {
        return new ApiReqParam();
    }

    public static ApiParam convertToApiParam(ApiReqParam param) {
        return ApiParam.of().setField(param.getName()).setValue(param.getValue()).setRequired(param.isRequired()).setDesc(param.getDesc()).setConfigParam(true).setVersion("-").setType(param.getType());
    }

    public String getName() {
        return this.name;
    }

    public ApiReqParam setName(String name) {
        this.name = name;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public ApiReqParam setType(String type) {
        this.type = type;
        return this;
    }

    public String getDesc() {
        return this.desc;
    }

    public ApiReqParam setDesc(String desc) {
        this.desc = desc;
        return this;
    }

    public boolean isRequired() {
        return this.required;
    }

    public ApiReqParam setRequired(boolean required) {
        this.required = required;
        return this;
    }

    public String getSince() {
        return this.since;
    }

    public ApiReqParam setSince(String since) {
        this.since = since;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public ApiReqParam setValue(String value) {
        this.value = value;
        return this;
    }

    public String getPathPatterns() {
        return this.pathPatterns;
    }

    public ApiReqParam setPathPatterns(String pathPatterns) {
        this.pathPatterns = pathPatterns;
        return this;
    }

    public String getExcludePathPatterns() {
        return this.excludePathPatterns;
    }

    public ApiReqParam setExcludePathPatterns(String excludePathPatterns) {
        this.excludePathPatterns = excludePathPatterns;
        return this;
    }

    public String getParamIn() {
        if (StringUtils.isEmpty((CharSequence)this.paramIn)) {
            return ApiReqParamInTypeEnum.HEADER.getValue();
        }
        return this.paramIn;
    }

    public ApiReqParam setParamIn(String paramIn) {
        this.paramIn = paramIn;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiReqParam that = (ApiReqParam)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("\"name\":\"").append(this.name).append('\"');
        sb.append(",\"type\":\"").append(this.type).append('\"');
        sb.append(",\"value\":\"").append(this.value).append('\"');
        sb.append(",\"desc\":\"").append(this.desc).append('\"');
        sb.append(",\"paramIn\":").append(this.paramIn);
        sb.append(",\"required\":").append(this.required);
        sb.append(",\"since\":\"").append(this.since).append('\"');
        sb.append(",\"pathPatterns\":\"").append(this.pathPatterns).append('\"');
        sb.append(",\"excludePathPatterns\":\"").append(this.excludePathPatterns).append('\"');
        sb.append('}');
        return sb.toString();
    }
}

