/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.handler;

import com.power.doc.builder.ProjectDocConfigBuilder;
import com.power.doc.constants.Methods;
import com.power.doc.function.RequestMappingFunc;
import com.power.doc.handler.IRequestMappingHandler;
import com.power.doc.model.annotation.FrameworkAnnotations;
import com.power.doc.model.request.RequestMapping;
import com.power.doc.utils.DocUtil;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaMethod;
import java.util.List;
import java.util.Objects;

public class SolonRequestMappingHandler
implements IRequestMappingHandler {
    @Override
    public RequestMapping handle(ProjectDocConfigBuilder projectBuilder, String controllerBaseUrl, JavaMethod method, FrameworkAnnotations frameworkAnnotations, RequestMappingFunc requestMappingFunc) {
        if (Objects.nonNull(method.getTagByName("ignore"))) {
            return null;
        }
        List annotations = method.getAnnotations();
        String methodType = "GET";
        String shortUrl = null;
        String mediaType = null;
        boolean deprecated = false;
        for (JavaAnnotation annotation : annotations) {
            String annotationName = annotation.getType().getName();
            if ("Deprecated".equals(annotationName)) {
                deprecated = true;
            }
            if ("Mapping".equals(annotationName) || "org.noear.solon.annotation.Mapping".equals(annotationName)) {
                shortUrl = DocUtil.handleMappingValue(annotation);
                Object produces = annotation.getNamedParameter("produces");
                if (Objects.nonNull(produces)) {
                    mediaType = produces.toString();
                }
            }
            if ("Get".equals(annotationName) || "org.noear.solon.annotation.Get".equals(annotationName)) {
                methodType = Methods.GET.getValue();
                continue;
            }
            if ("Post".equals(annotationName) || "org.noear.solon.annotation.Post".equals(annotationName)) {
                methodType = Methods.POST.getValue();
                continue;
            }
            if ("Put".equals(annotationName) || "org.noear.solon.annotation.Put".equals(annotationName)) {
                methodType = Methods.PUT.getValue();
                continue;
            }
            if ("Patch".equals(annotationName) || "org.noear.solon.annotation.Patch".equals(annotationName)) {
                methodType = Methods.PATCH.getValue();
                continue;
            }
            if (!"Delete".equals(annotationName) && !"org.noear.solon.annotation.Delete".equals(annotationName)) continue;
            methodType = Methods.DELETE.getValue();
        }
        if (Objects.nonNull(method.getTagByName("deprecated"))) {
            deprecated = true;
        }
        RequestMapping requestMapping = RequestMapping.builder().setMediaType(mediaType).setMethodType(methodType).setDeprecated(deprecated).setShortUrl(shortUrl);
        requestMapping = this.formatMappingData(projectBuilder, controllerBaseUrl, requestMapping);
        requestMappingFunc.process(method.getDeclaringClass(), requestMapping);
        return requestMapping;
    }
}

