/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.handler;

import com.power.common.util.StringUtil;
import com.power.common.util.UrlUtil;
import com.power.doc.builder.ProjectDocConfigBuilder;
import com.power.doc.function.RequestMappingFunc;
import com.power.doc.model.annotation.FrameworkAnnotations;
import com.power.doc.model.request.RequestMapping;
import com.power.doc.utils.DocUrlUtil;
import com.power.doc.utils.DocUtil;
import com.thoughtworks.qdox.model.JavaMethod;
import java.util.Objects;

public interface IRequestMappingHandler {
    default public RequestMapping formatMappingData(ProjectDocConfigBuilder projectBuilder, String controllerBaseUrl, RequestMapping requestMapping) {
        String shortUrl = requestMapping.getShortUrl();
        if (Objects.nonNull(shortUrl)) {
            String serverUrl = projectBuilder.getServerUrl();
            String contextPath = projectBuilder.getApiConfig().getPathPrefix();
            shortUrl = StringUtil.removeQuotes((String)shortUrl);
            String url = DocUrlUtil.getMvcUrls(serverUrl, contextPath + "/" + controllerBaseUrl, shortUrl);
            shortUrl = DocUrlUtil.getMvcUrls("", contextPath + "/" + controllerBaseUrl, shortUrl);
            String urlSuffix = projectBuilder.getApiConfig().getUrlSuffix();
            if (StringUtil.isEmpty((String)urlSuffix)) {
                urlSuffix = "";
            }
            url = UrlUtil.simplifyUrl((String)StringUtil.trim((String)url)) + urlSuffix;
            shortUrl = UrlUtil.simplifyUrl((String)StringUtil.trim((String)shortUrl)) + urlSuffix;
            url = DocUtil.formatPathUrl(url);
            requestMapping.setUrl(url).setShortUrl(shortUrl);
            return requestMapping;
        }
        return requestMapping;
    }

    public RequestMapping handle(ProjectDocConfigBuilder var1, String var2, JavaMethod var3, FrameworkAnnotations var4, RequestMappingFunc var5);
}

