/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.influxdb;

import org.influxdb.InfluxDB;
import org.influxdb.InfluxDBFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.influxdb.InfluxDBProperties;
import org.springframework.util.Assert;

public class InfluxDBConnectionFactory
implements InitializingBean {
    private static Logger logger = LoggerFactory.getLogger(InfluxDBConnectionFactory.class);
    private InfluxDB connection;
    private InfluxDBProperties properties;

    public InfluxDBConnectionFactory() {
    }

    public InfluxDBConnectionFactory(InfluxDBProperties properties) {
        this.properties = properties;
    }

    public InfluxDB getConnection() {
        Assert.notNull((Object)this.getProperties(), (String)"InfluxDBProperties are required");
        if (this.connection == null) {
            this.connection = InfluxDBFactory.connect((String)this.properties.getUrl(), (String)this.properties.getUsername(), (String)this.properties.getPassword());
            logger.debug("Using InfluxDB '{}' on '{}'", (Object)this.properties.getDatabase(), (Object)this.properties.getUrl());
        }
        return this.connection;
    }

    public InfluxDBProperties getProperties() {
        return this.properties;
    }

    public void setProperties(InfluxDBProperties properties) {
        this.properties = properties;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.getProperties(), (String)"InfluxDBProperties are required");
    }
}

