/*
 * Decompiled with CFR 0.152.
 */
package org.liveSense.service.gwt;

import com.google.gwt.user.server.rpc.RPCServletUtils;
import com.google.web.bindery.autobean.shared.AutoBean;
import com.google.web.bindery.autobean.shared.AutoBeanCodex;
import com.google.web.bindery.autobean.vm.AutoBeanFactorySource;
import com.google.web.bindery.requestfactory.server.ExceptionHandler;
import com.google.web.bindery.requestfactory.server.Logging;
import com.google.web.bindery.requestfactory.server.ServiceLayer;
import com.google.web.bindery.requestfactory.server.ServiceLayerDecorator;
import com.google.web.bindery.requestfactory.server.SimpleRequestProcessor;
import com.google.web.bindery.requestfactory.shared.ServerFailure;
import com.google.web.bindery.requestfactory.shared.ServiceLocator;
import com.google.web.bindery.requestfactory.shared.messages.MessageFactory;
import com.google.web.bindery.requestfactory.shared.messages.ResponseMessage;
import com.google.web.bindery.requestfactory.shared.messages.ServerFailureMessage;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.auth.core.AuthenticationSupport;
import org.apache.sling.auth.core.spi.AuthenticationInfo;
import org.apache.sling.jcr.api.SlingRepository;
import org.liveSense.core.ClassInstanceCache;
import org.liveSense.core.CompositeClassLoader;
import org.liveSense.core.Configurator;
import org.liveSense.core.service.OSGIClassLoaderManager;
import org.liveSense.core.wrapper.RequestWrapper;
import org.liveSense.service.gwt.DefaultExceptionHandler;
import org.liveSense.service.gwt.OsgiServiceLayerDecorator;
import org.liveSense.service.gwt.exceptions.AccessDeniedException;
import org.liveSense.service.gwt.exceptions.InternalException;
import org.osgi.framework.Bundle;
import org.osgi.service.packageadmin.PackageAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(componentAbstract=true)
public abstract class GWTRequestFactoryServlet
extends HttpServlet {
    private static final long serialVersionUID = 2565545902953291699L;
    private final Logger log = LoggerFactory.getLogger(GWTRequestFactoryServlet.class);
    public static final Logger payloadLogger = LoggerFactory.getLogger((String)"GWTREQUESTFACTORY");
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.DYNAMIC)
    private Configurator config;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.DYNAMIC)
    SlingRepository repository;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.DYNAMIC)
    PackageAdmin packageAdmin;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.DYNAMIC)
    AuthenticationSupport authenticationSupport;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.DYNAMIC)
    ResourceResolverFactory resourceResolverFactory;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.DYNAMIC)
    protected OSGIClassLoaderManager dynamicClassLoaderManager;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.DYNAMIC)
    ServiceLocator serviceLocator;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.DYNAMIC)
    ClassInstanceCache instanceCache;
    private static final String JSON_CHARSET = "UTF-8";
    private static final String JSON_CONTENT_TYPE = "application/json";
    private static final ThreadLocal<ServletContext> perThreadContext = new ThreadLocal();
    private static final ThreadLocal<HttpServletRequest> perThreadRequest = new ThreadLocal();
    private static final ThreadLocal<HttpServletResponse> perThreadResponse = new ThreadLocal();
    protected SimpleRequestProcessor processor;
    private static DefaultExceptionHandler defaultExceptionHandler = new DefaultExceptionHandler();
    private final HashMap<String, ClassLoader> classLoaders = new HashMap();
    static final MessageFactory FACTORY = (MessageFactory)AutoBeanFactorySource.create(MessageFactory.class);

    public static HttpServletRequest getThreadLocalRequest() {
        return perThreadRequest.get();
    }

    public static HttpServletResponse getThreadLocalResponse() {
        return perThreadResponse.get();
    }

    public static ServletContext getThreadLocalServletContext() {
        return perThreadContext.get();
    }

    public static DefaultExceptionHandler getDefaultExceptionHandler() {
        return defaultExceptionHandler;
    }

    public static void setDefaultExceptionHandler(DefaultExceptionHandler defaultExceptionHandler) {
        GWTRequestFactoryServlet.defaultExceptionHandler = defaultExceptionHandler;
    }

    protected void initOsgiProcessor() {
        System.setProperty("gwt.rf.ServiceLayerCache", new Boolean(false).toString());
        GWTRequestFactoryServlet.getDefaultExceptionHandler().setRequestFactoryServlet(this);
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        this.processor = new SimpleRequestProcessor(ServiceLayer.create((ServiceLayerDecorator[])new ServiceLayerDecorator[]{new OsgiServiceLayerDecorator(this.dynamicClassLoaderManager.getPackageAdminClassLoader(null), this.serviceLocator, this.instanceCache)}));
        this.processor.setExceptionHandler((ExceptionHandler)GWTRequestFactoryServlet.getDefaultExceptionHandler());
        Thread.currentThread().setContextClassLoader(old);
    }

    private void ensureConfig() {
        String symbolMapsDirectory = this.getServletConfig().getInitParameter("symbolMapsDirectory");
        if (symbolMapsDirectory != null) {
            Logging.setSymbolMapsDirectory((String)symbolMapsDirectory);
        }
    }

    protected void setClassLoader(ClassLoader classLoader) {
        this.classLoaders.put(classLoader.toString(), classLoader);
    }

    public abstract void callInit() throws Throwable;

    public abstract void callFinal() throws Throwable;

    public abstract ServerFailure failure(Throwable var1);

    private AutoBean<ServerFailureMessage> createFailureMessage(Throwable throwable) {
        ServerFailure failure = defaultExceptionHandler.createServerFailure(throwable);
        AutoBean bean = FACTORY.failure();
        ServerFailureMessage msg = (ServerFailureMessage)bean.as();
        msg.setExceptionType(failure.getExceptionType());
        msg.setMessage(failure.getMessage());
        msg.setStackTrace(failure.getStackTraceString());
        msg.setFatal(failure.isFatal());
        return bean;
    }

    private String processException(String phase, String payload, Throwable e) {
        AutoBean responseBean = FACTORY.response();
        responseBean = FACTORY.response();
        ((ResponseMessage)responseBean.as()).setGeneralFailure((ServerFailureMessage)this.createFailureMessage(e).as());
        String ret = AutoBeanCodex.encode((AutoBean)responseBean).getPayload();
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ClassLoader oldClassLoader = null;
        boolean customClassloader = false;
        perThreadContext.set(this.getServletContext());
        perThreadRequest.set(request);
        perThreadResponse.set(response);
        if (!this.classLoaders.isEmpty()) {
            customClassloader = true;
        }
        if (customClassloader) {
            oldClassLoader = Thread.currentThread().getContextClassLoader();
            CompositeClassLoader cClassLoader = new CompositeClassLoader();
            for (String key : this.classLoaders.keySet()) {
                cClassLoader.add(this.classLoaders.get(key));
            }
            Thread.currentThread().setContextClassLoader((ClassLoader)cClassLoader);
        }
        String payload = null;
        String jsonRequestString = null;
        boolean error = false;
        boolean callInitExecuted = false;
        try {
            try {
                this.ensureConfig();
                jsonRequestString = RPCServletUtils.readContent((HttpServletRequest)request, (String)JSON_CONTENT_TYPE, (String)JSON_CHARSET);
            }
            catch (Throwable e) {
                error = true;
                payload = this.processException("processRuntimeException", payload, e);
                payloadLogger.error("<<< (process) User: " + this.getUser() + " Payload: " + payload);
                this.log.error("Unexpected error on RequestFactory doPost init", e);
            }
            if (this.authenticationSupport != null && !error) {
                try {
                    this.authenticationSupport.handleSecurity(GWTRequestFactoryServlet.getThreadLocalRequest(), GWTRequestFactoryServlet.getThreadLocalResponse());
                }
                catch (Throwable e) {
                    error = true;
                    payload = this.processException("handleSecurity", jsonRequestString, e);
                }
            }
            if (!error) {
                try {
                    this.callInit();
                    callInitExecuted = true;
                }
                catch (Throwable e) {
                    error = true;
                    payload = this.processException("callInit", jsonRequestString, e);
                    payloadLogger.error("<<< (callInit) User: " + this.getUser() + " Payload: " + payload, e);
                }
            }
            if (!error) {
                try {
                    payloadLogger.info(">>> (process) User: " + this.getUser() + " Payload: " + jsonRequestString);
                    payload = this.processor.process(jsonRequestString);
                    response.setStatus(200);
                    response.setContentType("application/json; charset=utf-8");
                    payloadLogger.info("<<< (process) User: " + this.getUser() + " Payload: " + payload);
                }
                catch (Throwable e) {
                    error = true;
                    payload = this.processException("processRuntimeException", payload, e);
                    payloadLogger.error("<<< (process) User: " + this.getUser() + " Payload: " + payload, e);
                    this.log.error("Unexpected error", e);
                }
            }
            if (callInitExecuted) {
                try {
                    this.callFinal();
                }
                catch (Throwable e) {
                    payload = this.processException("callFinal", payload, e);
                    payloadLogger.error("<<< (callFinal) User: " + this.getUser() + " Payload: " + payload, e);
                }
            }
        }
        catch (Throwable e) {
            payload = this.processException("processRuntimeException", payload, e);
            payloadLogger.error("<<< (process) User: " + this.getUser() + " Payload: " + payload, e);
            this.log.error("Unexpected error", e);
        }
        finally {
            if (customClassloader) {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
            perThreadContext.set(null);
            perThreadRequest.set(null);
            perThreadResponse.set(null);
            response.setCharacterEncoding(this.config.getEncoding());
            PrintWriter writer = response.getWriter();
            writer.print(payload);
            writer.flush();
        }
    }

    protected RequestWrapper getRequest() {
        return new RequestWrapper(this.getThreadLocalRequest(), null);
    }

    protected String getUser() {
        return (String)this.getThreadLocalRequest().getAttribute("org.osgi.service.http.authentication.remote.user");
    }

    public Bundle getBundleByName(String name) {
        Bundle[] ret = this.packageAdmin.getBundles(name, null);
        if (ret != null && ret.length > 0) {
            return ret[0];
        }
        return null;
    }

    protected Locale getLocale() {
        if (GWTRequestFactoryServlet.getThreadLocalRequest().getAttribute("locale") == null) {
            RequestWrapper rw = new RequestWrapper(GWTRequestFactoryServlet.getThreadLocalRequest(), this.config.getDefaultLocale());
            GWTRequestFactoryServlet.getThreadLocalRequest().setAttribute("locale", (Object)rw.getLocale());
            return rw.getLocale();
        }
        return GWTRequestFactoryServlet.getThreadLocalRequest().getLocale();
    }

    protected void setLocale(Locale locale) {
        GWTRequestFactoryServlet.getThreadLocalRequest().setAttribute("locale", (Object)locale);
    }

    public String formatMessage(String key, Object[] args) {
        String message = this.getResourceBundle().getString(key);
        return MessageFormat.format(message, args);
    }

    protected Session getUserSession(Repository repository) throws AccessDeniedException, InternalException {
        try {
            AuthenticationInfo info = (AuthenticationInfo)this.getThreadLocalRequest().getAttribute("org.apache.sling.commons.auth.spi.AuthenticationInfo");
            return repository.login((Credentials)new SimpleCredentials(this.getUser(), info.getPassword()));
        }
        catch (LoginException ex) {
            throw new AccessDeniedException(this.formatMessage("accessDeniedForUser", new Object[]{this.getUser(), ex}));
        }
        catch (RepositoryException ex) {
            throw new InternalException(this.formatMessage("repositoryException", new Object[]{ex}));
        }
    }

    public ResourceBundle getResourceBundle() {
        return (ResourceBundle)GWTRequestFactoryServlet.getThreadLocalRequest().getAttribute("resourceBundle");
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        GWTRequestFactoryServlet.getThreadLocalRequest().setAttribute("resourceBundle", (Object)resourceBundle);
    }

    public SlingRepository getRepository() {
        return this.repository;
    }

    public void setRepository(SlingRepository repository) {
        this.repository = repository;
    }

    public Configurator getConfig() {
        return this.config;
    }

    public void setConfig(Configurator config) {
        this.config = config;
    }

    public PackageAdmin getPackageAdmin() {
        return this.packageAdmin;
    }

    public void setPackageAdmin(PackageAdmin packageAdmin) {
        this.packageAdmin = packageAdmin;
    }

    public ResourceResolverFactory getResourceResolverFactory() {
        return this.resourceResolverFactory;
    }

    public void setResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    public AuthenticationSupport getAuthenticationSupport() {
        return this.authenticationSupport;
    }

    public void setAuthenticationSupport(AuthenticationSupport authenticationSupport) {
        this.authenticationSupport = authenticationSupport;
    }

    protected void bindConfig(Configurator configurator) {
        this.config = configurator;
    }

    protected void unbindConfig(Configurator configurator) {
        if (this.config == configurator) {
            this.config = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindPackageAdmin(PackageAdmin packageAdmin) {
        this.packageAdmin = packageAdmin;
    }

    protected void unbindPackageAdmin(PackageAdmin packageAdmin) {
        if (this.packageAdmin == packageAdmin) {
            this.packageAdmin = null;
        }
    }

    protected void bindAuthenticationSupport(AuthenticationSupport authenticationSupport) {
        this.authenticationSupport = authenticationSupport;
    }

    protected void unbindAuthenticationSupport(AuthenticationSupport authenticationSupport) {
        if (this.authenticationSupport == authenticationSupport) {
            this.authenticationSupport = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindDynamicClassLoaderManager(OSGIClassLoaderManager oSGIClassLoaderManager) {
        this.dynamicClassLoaderManager = oSGIClassLoaderManager;
    }

    protected void unbindDynamicClassLoaderManager(OSGIClassLoaderManager oSGIClassLoaderManager) {
        if (this.dynamicClassLoaderManager == oSGIClassLoaderManager) {
            this.dynamicClassLoaderManager = null;
        }
    }

    protected void bindServiceLocator(ServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }

    protected void unbindServiceLocator(ServiceLocator serviceLocator) {
        if (this.serviceLocator == serviceLocator) {
            this.serviceLocator = null;
        }
    }

    protected void bindInstanceCache(ClassInstanceCache classInstanceCache) {
        this.instanceCache = classInstanceCache;
    }

    protected void unbindInstanceCache(ClassInstanceCache classInstanceCache) {
        if (this.instanceCache == classInstanceCache) {
            this.instanceCache = null;
        }
    }
}

