/*
 * Decompiled with CFR 0.152.
 */
package com.github.linyuzai.event.rabbitmq.properties;

import com.github.linyuzai.event.core.codec.EventDecoder;
import com.github.linyuzai.event.core.codec.EventEncoder;
import com.github.linyuzai.event.core.config.AbstractPropertiesConfig;
import com.github.linyuzai.event.core.config.EndpointConfig;
import com.github.linyuzai.event.core.config.EngineConfig;
import com.github.linyuzai.event.core.error.EventErrorHandler;
import com.github.linyuzai.event.core.publisher.EventPublisher;
import com.github.linyuzai.event.core.subscriber.EventSubscriber;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="concept.event.rabbitmq")
public class RabbitEventProperties
extends AbstractPropertiesConfig
implements EngineConfig {
    private boolean enabled;
    private Map<String, ExtendedRabbitProperties> endpoints = new LinkedHashMap<String, ExtendedRabbitProperties>();

    public boolean isEnabled() {
        return this.enabled;
    }

    public Map<String, ExtendedRabbitProperties> getEndpoints() {
        return this.endpoints;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setEndpoints(Map<String, ExtendedRabbitProperties> endpoints) {
        this.endpoints = endpoints;
    }

    public static class ExtendedRabbitProperties
    extends RabbitProperties
    implements EndpointConfig {
        private boolean enabled = true;
        private String inherit;
        private Map<Object, Object> metadata = new LinkedHashMap<Object, Object>();
        private Class<? extends EventEncoder> encoder;
        private Class<? extends EventDecoder> decoder;
        private Class<? extends EventErrorHandler> errorHandler;
        private Class<? extends EventPublisher> publisher;
        private Class<? extends EventSubscriber> subscriber;

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getInherit() {
            return this.inherit;
        }

        public Map<Object, Object> getMetadata() {
            return this.metadata;
        }

        public Class<? extends EventEncoder> getEncoder() {
            return this.encoder;
        }

        public Class<? extends EventDecoder> getDecoder() {
            return this.decoder;
        }

        public Class<? extends EventErrorHandler> getErrorHandler() {
            return this.errorHandler;
        }

        public Class<? extends EventPublisher> getPublisher() {
            return this.publisher;
        }

        public Class<? extends EventSubscriber> getSubscriber() {
            return this.subscriber;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setInherit(String inherit) {
            this.inherit = inherit;
        }

        public void setMetadata(Map<Object, Object> metadata) {
            this.metadata = metadata;
        }

        public void setEncoder(Class<? extends EventEncoder> encoder) {
            this.encoder = encoder;
        }

        public void setDecoder(Class<? extends EventDecoder> decoder) {
            this.decoder = decoder;
        }

        public void setErrorHandler(Class<? extends EventErrorHandler> errorHandler) {
            this.errorHandler = errorHandler;
        }

        public void setPublisher(Class<? extends EventPublisher> publisher) {
            this.publisher = publisher;
        }

        public void setSubscriber(Class<? extends EventSubscriber> subscriber) {
            this.subscriber = subscriber;
        }
    }
}

