/*
 * Decompiled with CFR 0.152.
 */
package com.github.linyuzai.event.rabbitmq.endpoint;

import com.github.linyuzai.event.core.config.InstanceConfig;
import com.github.linyuzai.event.core.engine.EventEngine;
import com.github.linyuzai.event.rabbitmq.endpoint.RabbitEventEndpoint;
import com.github.linyuzai.event.rabbitmq.endpoint.RabbitEventEndpointFactory;
import com.github.linyuzai.event.rabbitmq.engine.RabbitEventEngine;
import com.github.linyuzai.event.rabbitmq.properties.RabbitEventProperties;
import com.rabbitmq.client.ConnectionFactory;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import org.springframework.amqp.rabbit.config.DirectRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.connection.AbstractConnectionFactory;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.RabbitConnectionFactoryBean;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.listener.MessageListenerContainer;
import org.springframework.amqp.rabbit.listener.RabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.retry.MessageRecoverer;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.boot.autoconfigure.amqp.AbstractRabbitListenerContainerFactoryConfigurer;
import org.springframework.boot.autoconfigure.amqp.CachingConnectionFactoryConfigurer;
import org.springframework.boot.autoconfigure.amqp.DirectRabbitListenerContainerFactoryConfigurer;
import org.springframework.boot.autoconfigure.amqp.RabbitConnectionFactoryBeanConfigurer;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.boot.autoconfigure.amqp.RabbitTemplateConfigurer;
import org.springframework.boot.autoconfigure.amqp.SimpleRabbitListenerContainerFactoryConfigurer;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class RabbitEventEndpointFactoryImpl
implements RabbitEventEndpointFactory {
    private ResourceLoader resourceLoader;

    public RabbitEventEndpoint create(String name, RabbitEventProperties.ExtendedRabbitProperties properties, RabbitEventEngine engine) {
        org.springframework.amqp.rabbit.connection.ConnectionFactory connectionFactory = this.createConnectionFactory(properties);
        RabbitListenerContainerFactory<? extends MessageListenerContainer> listenerContainerFactory = this.createRabbitListenerContainerFactory(properties, connectionFactory);
        RabbitTemplate rabbitTemplate = this.createRabbitTemplate(properties, connectionFactory);
        RabbitAdmin rabbitAdmin = this.createRabbitAdmin(connectionFactory);
        RabbitEventEndpoint endpoint = new RabbitEventEndpoint(name, (EventEngine)engine);
        endpoint.setProperties(properties);
        endpoint.setConnectionFactory(connectionFactory);
        endpoint.setListenerContainerFactory(listenerContainerFactory);
        endpoint.setTemplate(rabbitTemplate);
        endpoint.setAdmin(rabbitAdmin);
        properties.apply((InstanceConfig)endpoint);
        return endpoint;
    }

    protected org.springframework.amqp.rabbit.connection.ConnectionFactory createConnectionFactory(RabbitProperties properties) {
        RabbitConnectionFactoryBeanConfigurer rabbitConnectionFactoryBeanConfigurer = new RabbitConnectionFactoryBeanConfigurer(this.resourceLoader, properties);
        CachingConnectionFactoryConfigurer rabbitCachingConnectionFactoryConfigurer = new CachingConnectionFactoryConfigurer(properties);
        RabbitConnectionFactoryBean connectionFactoryBean = new RabbitConnectionFactoryBean();
        rabbitConnectionFactoryBeanConfigurer.configure(connectionFactoryBean);
        connectionFactoryBean.afterPropertiesSet();
        ConnectionFactory connectionFactory = (ConnectionFactory)connectionFactoryBean.getObject();
        CachingConnectionFactory factory = new CachingConnectionFactory(Objects.requireNonNull(connectionFactory));
        rabbitCachingConnectionFactoryConfigurer.configure((AbstractConnectionFactory)factory);
        return factory;
    }

    protected RabbitListenerContainerFactory<? extends MessageListenerContainer> createRabbitListenerContainerFactory(RabbitProperties properties, org.springframework.amqp.rabbit.connection.ConnectionFactory connectionFactory) {
        RabbitProperties.ContainerType type = properties.getListener().getType();
        if (type == RabbitProperties.ContainerType.SIMPLE) {
            SimpleRabbitListenerContainerFactory factory = new SimpleRabbitListenerContainerFactory();
            SimpleRabbitListenerContainerFactoryConfigurer simpleConfigurer = new SimpleRabbitListenerContainerFactoryConfigurer(properties);
            simpleConfigurer.configure(factory, connectionFactory);
            return factory;
        }
        if (type == RabbitProperties.ContainerType.DIRECT) {
            DirectRabbitListenerContainerFactory factory = new DirectRabbitListenerContainerFactory();
            DirectRabbitListenerContainerFactoryConfigurer directConfigurer = new DirectRabbitListenerContainerFactoryConfigurer(properties);
            directConfigurer.configure(factory, connectionFactory);
            return factory;
        }
        return null;
    }

    protected RabbitTemplate createRabbitTemplate(RabbitProperties properties, org.springframework.amqp.rabbit.connection.ConnectionFactory connectionFactory) {
        RabbitTemplate template = new RabbitTemplate();
        RabbitTemplateConfigurer configurer = new RabbitTemplateConfigurer(properties);
        configurer.configure(template, connectionFactory);
        return template;
    }

    protected RabbitAdmin createRabbitAdmin(org.springframework.amqp.rabbit.connection.ConnectionFactory connectionFactory) {
        return new RabbitAdmin(connectionFactory);
    }

    @Deprecated
    protected void configureConfigurer(AbstractRabbitListenerContainerFactoryConfigurer<?> configurer) {
        Method setRetryTemplateCustomizers;
        Method setMessageRecoverer;
        Method setMessageConverter = ClassUtils.getMethodIfAvailable(AbstractRabbitListenerContainerFactoryConfigurer.class, (String)"setMessageConverter", (Class[])new Class[]{MessageConverter.class});
        if (setMessageConverter != null) {
            ReflectionUtils.makeAccessible((Method)setMessageConverter);
        }
        if ((setMessageRecoverer = ClassUtils.getMethodIfAvailable(AbstractRabbitListenerContainerFactoryConfigurer.class, (String)"setMessageRecoverer", (Class[])new Class[]{MessageRecoverer.class})) != null) {
            ReflectionUtils.makeAccessible((Method)setMessageRecoverer);
        }
        if ((setRetryTemplateCustomizers = ClassUtils.getMethodIfAvailable(AbstractRabbitListenerContainerFactoryConfigurer.class, (String)"setRetryTemplateCustomizers", (Class[])new Class[]{List.class})) != null) {
            ReflectionUtils.makeAccessible((Method)setRetryTemplateCustomizers);
        }
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public RabbitEventEndpointFactoryImpl(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }
}

