/*
 * Decompiled with CFR 0.152.
 */
package com.github.linyuzai.event.rabbitmq.binding;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.FanoutExchange;
import org.springframework.amqp.core.HeadersExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.util.Assert;

public class RabbitBinding {
    private RabbitAdmin admin;

    public QueueConfigurer bind(Queue queue) {
        this.admin.declareQueue(queue);
        return new QueueConfigurer(queue.getName());
    }

    private static Map<String, Object> createMapForKeys(String ... keys) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String key : keys) {
            map.put(key, null);
        }
        return map;
    }

    public RabbitAdmin getAdmin() {
        return this.admin;
    }

    public RabbitBinding(RabbitAdmin admin) {
        this.admin = admin;
    }

    public class DirectExchangeConfigurer
    extends AbstractRoutingKeyConfigurer {
        public DirectExchangeConfigurer(QueueConfigurer queue, DirectExchange exchange) {
            super(queue, exchange.getName());
        }

        public void with(String routingKey) {
            Binding binding = new Binding(this.queue.name, Binding.DestinationType.QUEUE, this.exchange, routingKey, Collections.emptyMap());
            RabbitBinding.this.admin.declareBinding(binding);
        }

        public void with(Enum<?> routingKeyEnum) {
            Binding binding = new Binding(this.queue.name, Binding.DestinationType.QUEUE, this.exchange, routingKeyEnum.toString(), Collections.emptyMap());
            RabbitBinding.this.admin.declareBinding(binding);
        }

        public void withQueueName() {
            Binding binding = new Binding(this.queue.name, Binding.DestinationType.QUEUE, this.exchange, this.queue.name, Collections.emptyMap());
            RabbitBinding.this.admin.declareBinding(binding);
        }
    }

    public class ArgumentsConfigurer {
        protected final GenericExchangeConfigurer configurer;
        protected final String routingKey;

        public void and(Map<String, Object> map) {
            Binding binding = new Binding(this.configurer.queue.name, Binding.DestinationType.QUEUE, this.configurer.exchange, this.routingKey, map);
            RabbitBinding.this.admin.declareBinding(binding);
        }

        public void noargs() {
            Binding binding = new Binding(this.configurer.queue.name, Binding.DestinationType.QUEUE, this.configurer.exchange, this.routingKey, Collections.emptyMap());
            RabbitBinding.this.admin.declareBinding(binding);
        }

        public ArgumentsConfigurer(GenericExchangeConfigurer configurer, String routingKey) {
            this.configurer = configurer;
            this.routingKey = routingKey;
        }
    }

    public class GenericExchangeConfigurer
    extends AbstractRoutingKeyConfigurer {
        public GenericExchangeConfigurer(QueueConfigurer queue, Exchange exchange) {
            super(queue, exchange.getName());
        }

        public ArgumentsConfigurer with(String routingKey) {
            return new ArgumentsConfigurer(this, routingKey);
        }

        public ArgumentsConfigurer with(Enum<?> routingKeyEnum) {
            return new ArgumentsConfigurer(this, routingKeyEnum.toString());
        }
    }

    public class TopicExchangeConfigurer
    extends AbstractRoutingKeyConfigurer {
        public TopicExchangeConfigurer(QueueConfigurer queue, TopicExchange exchange) {
            super(queue, exchange.getName());
        }

        public void with(String routingKey) {
            Binding binding = new Binding(this.queue.name, Binding.DestinationType.QUEUE, this.exchange, routingKey, Collections.emptyMap());
            RabbitBinding.this.admin.declareBinding(binding);
        }

        public void with(Enum<?> routingKeyEnum) {
            Binding binding = new Binding(this.queue.name, Binding.DestinationType.QUEUE, this.exchange, routingKeyEnum.toString(), Collections.emptyMap());
            RabbitBinding.this.admin.declareBinding(binding);
        }
    }

    private static abstract class AbstractRoutingKeyConfigurer {
        protected final QueueConfigurer queue;
        protected final String exchange;

        public AbstractRoutingKeyConfigurer(QueueConfigurer queue, String exchange) {
            this.queue = queue;
            this.exchange = exchange;
        }
    }

    public class HeadersExchangeConfigurer {
        protected final QueueConfigurer queue;
        protected final HeadersExchange exchange;

        public SingleValueBindingConfigurer where(String key) {
            return new SingleValueBindingConfigurer(key);
        }

        public KeysBindingConfigurer whereAny(String ... headerKeys) {
            return new KeysBindingConfigurer(headerKeys, false);
        }

        public MapBindingCreator whereAny(Map<String, Object> headerValues) {
            return new MapBindingCreator(headerValues, false);
        }

        public KeysBindingConfigurer whereAll(String ... headerKeys) {
            return new KeysBindingConfigurer(headerKeys, true);
        }

        public MapBindingCreator whereAll(Map<String, Object> headerValues) {
            return new MapBindingCreator(headerValues, true);
        }

        public HeadersExchangeConfigurer(QueueConfigurer queue, HeadersExchange exchange) {
            this.queue = queue;
            this.exchange = exchange;
        }

        public class MapBindingCreator {
            protected final Map<String, Object> headerMap;

            public MapBindingCreator(Map<String, Object> headerMap, boolean matchAll) {
                Assert.notEmpty(headerMap, (String)"header map must not be empty");
                this.headerMap = new HashMap<String, Object>(headerMap);
                this.headerMap.put("x-match", matchAll ? "all" : "any");
            }

            public void match() {
                Binding binding = new Binding(HeadersExchangeConfigurer.this.queue.name, Binding.DestinationType.QUEUE, HeadersExchangeConfigurer.this.exchange.getName(), "", this.headerMap);
                RabbitBinding.this.admin.declareBinding(binding);
            }
        }

        public class KeysBindingConfigurer {
            protected final Map<String, Object> headerMap;

            public KeysBindingConfigurer(String[] headerKeys, boolean matchAll) {
                Assert.notEmpty((Object[])headerKeys, (String)"header key list must not be empty");
                this.headerMap = RabbitBinding.createMapForKeys(headerKeys);
                this.headerMap.put("x-match", matchAll ? "all" : "any");
            }

            public void exist() {
                Binding binding = new Binding(HeadersExchangeConfigurer.this.queue.name, Binding.DestinationType.QUEUE, HeadersExchangeConfigurer.this.exchange.getName(), "", this.headerMap);
                RabbitBinding.this.admin.declareBinding(binding);
            }
        }

        public class SingleValueBindingConfigurer {
            @NonNull
            protected final String key;

            public void exists() {
                Binding binding = new Binding(HeadersExchangeConfigurer.this.queue.name, Binding.DestinationType.QUEUE, HeadersExchangeConfigurer.this.exchange.getName(), "", RabbitBinding.createMapForKeys(new String[]{this.key}));
                RabbitBinding.this.admin.declareBinding(binding);
            }

            public void matches(Object value) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(this.key, value);
                Binding binding = new Binding(HeadersExchangeConfigurer.this.queue.name, Binding.DestinationType.QUEUE, HeadersExchangeConfigurer.this.exchange.getName(), "", map);
                RabbitBinding.this.admin.declareBinding(binding);
            }

            public SingleValueBindingConfigurer(String key) {
                if (key == null) {
                    throw new NullPointerException("key is marked non-null but is null");
                }
                this.key = key;
            }
        }
    }

    public class QueueConfigurer {
        protected final String name;

        public void to(FanoutExchange exchange) {
            RabbitBinding.this.admin.declareExchange((Exchange)exchange);
            Binding binding = new Binding(this.name, Binding.DestinationType.QUEUE, exchange.getName(), "", new HashMap());
            RabbitBinding.this.admin.declareBinding(binding);
        }

        public HeadersExchangeConfigurer to(HeadersExchange exchange) {
            RabbitBinding.this.admin.declareExchange((Exchange)exchange);
            return new HeadersExchangeConfigurer(this, exchange);
        }

        public DirectExchangeConfigurer to(DirectExchange exchange) {
            RabbitBinding.this.admin.declareExchange((Exchange)exchange);
            return new DirectExchangeConfigurer(this, exchange);
        }

        public TopicExchangeConfigurer to(TopicExchange exchange) {
            RabbitBinding.this.admin.declareExchange((Exchange)exchange);
            return new TopicExchangeConfigurer(this, exchange);
        }

        public GenericExchangeConfigurer to(Exchange exchange) {
            RabbitBinding.this.admin.declareExchange(exchange);
            return new GenericExchangeConfigurer(this, exchange);
        }

        public QueueConfigurer(String name) {
            this.name = name;
        }
    }
}

