/*
 * Decompiled with CFR 0.152.
 */
package com.github.linyuzai.event.rabbitmq.autoconfigure;

import com.github.linyuzai.event.core.config.EngineEndpointConfiguration;
import com.github.linyuzai.event.rabbitmq.endpoint.RabbitEventEndpoint;
import com.github.linyuzai.event.rabbitmq.endpoint.RabbitEventEndpointConfigurer;
import com.github.linyuzai.event.rabbitmq.endpoint.RabbitEventEndpointFactory;
import com.github.linyuzai.event.rabbitmq.endpoint.RabbitEventEndpointFactoryImpl;
import com.github.linyuzai.event.rabbitmq.engine.RabbitEventEngine;
import com.github.linyuzai.event.rabbitmq.engine.RabbitEventEngineConfigurer;
import com.github.linyuzai.event.rabbitmq.engine.RabbitEventEngineFactory;
import com.github.linyuzai.event.rabbitmq.engine.RabbitEventEngineFactoryImpl;
import com.github.linyuzai.event.rabbitmq.inherit.RabbitConfigInheritHandler;
import com.github.linyuzai.event.rabbitmq.inherit.ReflectionRabbitConfigInheritHandler;
import com.github.linyuzai.event.rabbitmq.properties.RabbitEventProperties;
import com.rabbitmq.client.ConnectionFactory;
import java.util.List;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.core.ChannelCallback;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.listener.MessageListenerContainer;
import org.springframework.amqp.rabbit.listener.RabbitListenerContainerFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.amqp.CachingConnectionFactoryConfigurer;
import org.springframework.boot.autoconfigure.amqp.DirectRabbitListenerContainerFactoryConfigurer;
import org.springframework.boot.autoconfigure.amqp.RabbitAutoConfiguration;
import org.springframework.boot.autoconfigure.amqp.RabbitConnectionFactoryBeanConfigurer;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.boot.autoconfigure.amqp.RabbitTemplateConfigurer;
import org.springframework.boot.autoconfigure.amqp.SimpleRabbitListenerContainerFactoryConfigurer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.lang.NonNull;

@Configuration
@ConditionalOnProperty(name={"concept.event.rabbitmq.enabled"}, havingValue="true")
@ConditionalOnBean(name={"com.github.linyuzai.event.autoconfigure.EventEnabled"})
@EnableConfigurationProperties(value={RabbitEventProperties.class})
@AutoConfigureBefore(value={RabbitAutoConfiguration.class})
public class RabbitEventAutoConfiguration
extends EngineEndpointConfiguration<RabbitEventProperties, RabbitEventProperties.ExtendedRabbitProperties, RabbitEventEngine, RabbitEventEndpoint> {
    @Bean(name={"rabbitListenerContainerFactory"})
    public RabbitListenerContainerFactory<? extends MessageListenerContainer> rabbitListenerContainerFactory() {
        return new SimpleRabbitListenerContainerFactory();
    }

    @Bean
    public SimpleRabbitListenerContainerFactoryConfigurer simpleRabbitListenerContainerFactoryConfigurer() {
        return new SimpleRabbitListenerContainerFactoryConfigurer(new RabbitProperties());
    }

    @Bean
    public DirectRabbitListenerContainerFactoryConfigurer directRabbitListenerContainerFactoryConfigurer() {
        return new DirectRabbitListenerContainerFactoryConfigurer(new RabbitProperties());
    }

    @Bean
    public RabbitConnectionFactoryBeanConfigurer rabbitConnectionFactoryBeanConfigurer() {
        return new RabbitConnectionFactoryBeanConfigurer(null, null);
    }

    @Bean
    public CachingConnectionFactoryConfigurer rabbitConnectionFactoryConfigurer() {
        return new CachingConnectionFactoryConfigurer(new RabbitProperties());
    }

    @Bean
    public org.springframework.amqp.rabbit.connection.ConnectionFactory rabbitConnectionFactory() {
        ConnectionFactory factory = new ConnectionFactory();
        factory.setAutomaticRecoveryEnabled(false);
        return new CachingConnectionFactory(factory);
    }

    @Bean
    public RabbitTemplateConfigurer rabbitTemplateConfigurer() {
        return new RabbitTemplateConfigurer(new RabbitProperties());
    }

    @Bean
    public RabbitTemplate rabbitTemplate() {
        return new RabbitTemplate(this.rabbitConnectionFactory()){

            public <T> T execute(@NonNull ChannelCallback<T> action) {
                return (T)"";
            }
        };
    }

    @Bean
    public RabbitAdmin rabbitAdmin() {
        return new RabbitAdmin(this.rabbitConnectionFactory());
    }

    @Bean
    @ConditionalOnMissingBean
    public RabbitConfigInheritHandler rabbitInheritHandler(Environment environment) {
        return new ReflectionRabbitConfigInheritHandler(environment);
    }

    @Bean
    @ConditionalOnMissingBean
    public RabbitEventEngineFactory rabbitEventEngineFactory() {
        return new RabbitEventEngineFactoryImpl();
    }

    @Bean
    @ConditionalOnMissingBean
    public RabbitEventEndpointFactory rabbitEventEndpointFactory(ResourceLoader resourceLoader) {
        return new RabbitEventEndpointFactoryImpl(resourceLoader);
    }

    @Bean
    public RabbitEventEngine rabbitEventEngine(ConfigurableBeanFactory beanFactory, RabbitEventProperties properties, RabbitConfigInheritHandler inheritHandler, RabbitEventEngineFactory engineFactory, RabbitEventEndpointFactory endpointFactory, List<RabbitEventEngineConfigurer> engineConfigurers, List<RabbitEventEndpointConfigurer> endpointConfigurers) {
        return (RabbitEventEngine)this.configure(properties, inheritHandler, engineFactory, endpointFactory, engineConfigurers, endpointConfigurers, (name, endpoint) -> this.registerEndpoint((String)name, (RabbitEventEndpoint)((Object)endpoint), beanFactory));
    }

    private void registerEndpoint(String name, RabbitEventEndpoint endpoint, ConfigurableBeanFactory beanFactory) {
        this.register(name + "RabbitConnectionFactory", endpoint.getConnectionFactory(), beanFactory);
        this.register(name + "RabbitListenerContainerFactory", endpoint.getListenerContainerFactory(), beanFactory);
        this.register(name + "RabbitTemplate", endpoint.getTemplate(), beanFactory);
        this.register(name + "RabbitAdmin", endpoint.getAdmin(), beanFactory);
        this.register(name + "RabbitEventEndpoint", (Object)endpoint, beanFactory);
    }

    private void register(String name, Object bean, ConfigurableBeanFactory beanFactory) {
        if (bean == null) {
            return;
        }
        beanFactory.registerSingleton(name, bean);
    }
}

