/*-
 * #%L
 * JSQLParser library
 * %%
 * Copyright (C) 2004 - 2021 JSQLParser
 * %%
 * Dual licensed under GNU LGPL 2.1 or Apache License 2.0
 * #L%
 */
/* CCJSqlParser.java */
/* Generated By:JJTree&JavaCC: Do not edit this line. CCJSqlParser.java */
package net.sf.jsqlparser.parser;

import net.sf.jsqlparser.parser.feature.*;
import net.sf.jsqlparser.expression.*;
import net.sf.jsqlparser.expression.operators.arithmetic.*;
import net.sf.jsqlparser.expression.operators.conditional.*;
import net.sf.jsqlparser.expression.operators.relational.*;
import net.sf.jsqlparser.schema.*;
import net.sf.jsqlparser.statement.*;
import net.sf.jsqlparser.statement.alter.*;
import net.sf.jsqlparser.statement.alter.sequence.*;
import net.sf.jsqlparser.statement.comment.*;
import net.sf.jsqlparser.statement.create.function.*;
import net.sf.jsqlparser.statement.create.index.*;
import net.sf.jsqlparser.statement.create.procedure.*;
import net.sf.jsqlparser.statement.create.schema.*;
import net.sf.jsqlparser.statement.create.synonym.*;
import net.sf.jsqlparser.statement.create.sequence.*;
import net.sf.jsqlparser.statement.create.table.*;
import net.sf.jsqlparser.statement.create.view.*;
import net.sf.jsqlparser.statement.delete.*;
import net.sf.jsqlparser.statement.drop.*;
import net.sf.jsqlparser.statement.insert.*;
import net.sf.jsqlparser.statement.replace.*;
import net.sf.jsqlparser.statement.execute.*;
import net.sf.jsqlparser.statement.select.*;
import net.sf.jsqlparser.statement.show.*;
import net.sf.jsqlparser.statement.truncate.*;
import net.sf.jsqlparser.statement.update.*;
import net.sf.jsqlparser.statement.upsert.*;
import net.sf.jsqlparser.statement.merge.*;
import net.sf.jsqlparser.statement.values.*;
import net.sf.jsqlparser.statement.grant.*;
import java.util.*;

/**
 * The parser generated by JavaCC
 */
public class CCJSqlParser extends AbstractJSqlParser<CCJSqlParser>/*@bgen(jjtree)*/implements CCJSqlParserTreeConstants, CCJSqlParserConstants {/*@bgen(jjtree)*/
  protected JJTCCJSqlParserState jjtree = new JJTCCJSqlParserState();public int bracketsCounter = 0;
    public int caseCounter = 0;

    public CCJSqlParser withConfiguration(FeatureConfiguration configuration) {
        token_source.configuration = configuration;
        return this;
    }

    public FeatureConfiguration getConfiguration() {
        return token_source.configuration;
    }

    public CCJSqlParser me () {
        return this;
    }

    private void linkAST(ASTNodeAccess access, SimpleNode node) {
        access.setASTNode(node);
        node.jjtSetValue(access);
    }

    public Node getASTRoot() {
        return jjtree.rootNode();
    }

  final public Statement Statement() throws ParseException {/*@bgen(jjtree) Statement */
  SimpleNode jjtn000 = new SimpleNode(JJTSTATEMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));Statement stm = null;
    try {
      try {
        stm = SingleStatement();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case ST_SEMICOLON:{
          jj_consume_token(ST_SEMICOLON);
          break;
          }
        default:
          jj_la1[0] = jj_gen;
          ;
        }
        jj_consume_token(0);
      } catch (ParseException e) {
if (errorRecovery) {
            parseErrors.add(e);
            error_skipto(ST_SEMICOLON);
        }
        else
            {if (true) throw e;}
      }
jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          jjtn000.jjtSetLastToken(getToken(0));
return stm;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Statement SingleStatement() throws ParseException {Statement stm = null;
    List<WithItem> with = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_DELETE:
      case K_INSERT:
      case K_MERGE:
      case K_SELECT:
      case K_UPDATE:
      case K_VALUES:
      case K_WITH:
      case 287:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_WITH:{
          with = WithList();

          break;
          }
        default:
          jj_la1[1] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_SELECT:
        case K_VALUES:
        case 287:{
          stm = Select(with);
          break;
          }
        case K_INSERT:{
          stm = Insert(with);
          break;
          }
        case K_UPDATE:{
          stm = Update(with);
          break;
          }
        case K_DELETE:{
          stm = Delete(with);
          break;
          }
        case K_MERGE:{
          stm = Merge(with);
          break;
          }
        default:
          jj_la1[2] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case K_UPSERT:{
        stm = Upsert();
        break;
        }
      default:
        jj_la1[3] = jj_gen;
        if (jj_2_1(3)) {
          stm = Replace();
        } else if (jj_2_2(2)) {
          stm = AlterTable();
        } else if (jj_2_3(2)) {
          stm = AlterSession();
        } else if (jj_2_4(2147483647)) {
          stm = CreateFunctionStatement();
        } else if (jj_2_5(2147483647)) {
          stm = CreateIndex();
        } else if (jj_2_6(2147483647)) {
          stm = CreateSchema();
        } else if (jj_2_7(2147483647)) {
          stm = CreateSequence();
        } else if (jj_2_8(2147483647)) {
          stm = CreateSynonym();
        } else if (jj_2_9(2147483647)) {
          stm = CreateTable();
        } else if (jj_2_10(2147483647)) {
          stm = CreateView();
        } else if (jj_2_11(2147483647)) {
          stm = AlterView();
        } else if (jj_2_12(2147483647)) {
          stm = AlterSequence();
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_DROP:{
            stm = Drop();
            break;
            }
          case K_TRUNCATE:{
            stm = Truncate();
            break;
            }
          case K_CALL:
          case K_EXEC:
          case K_EXECUTE:{
            stm = Execute();
            break;
            }
          case K_SET:{
            stm = Set();
            break;
            }
          case K_RESET:{
            stm = Reset();
            break;
            }
          default:
            jj_la1[4] = jj_gen;
            if (jj_2_13(2147483647)) {
              stm = ShowColumns();
            } else if (jj_2_14(2147483647)) {
              stm = ShowTables();
            } else {
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_SHOW:{
                stm = Show();
                break;
                }
              case K_USE:{
                stm = Use();
                break;
                }
              case K_SAVEPOINT:{
                stm = SavepointStatement();
                break;
                }
              case K_ROLLBACK:{
                stm = RollbackStatement();
                break;
                }
              case K_COMMIT:{
                stm = Commit();
                break;
                }
              case K_COMMENT:{
                stm = Comment();
                break;
                }
              case K_DESCRIBE:{
                stm = Describe();
                break;
                }
              case K_EXPLAIN:{
                stm = Explain();
                break;
                }
              case K_DECLARE:{
                stm = Declare();
                break;
                }
              case K_GRANT:{
                stm = Grant();
                break;
                }
              default:
                jj_la1[5] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
            }
          }
        }
      }
return stm;
    } catch (ParseException e) {
if (errorRecovery) {
            parseErrors.add(e);
            error_skipto(ST_SEMICOLON);
            return null;
        } else
            {if (true) throw e;}
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Block Block() throws ParseException {/*@bgen(jjtree) Block */
    SimpleNode jjtn000 = new SimpleNode(JJTBLOCK);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Statements stmts = new Statements();
    List<Statement> list = new ArrayList<Statement>();
    Statement stm;
    Block block = new Block();
    try {
      jj_consume_token(K_BEGIN);
      label_1:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case ST_SEMICOLON:{
          ;
          break;
          }
        default:
          jj_la1[6] = jj_gen;
          break label_1;
        }
        jj_consume_token(ST_SEMICOLON);
      }
      try {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ALTER:
        case K_CALL:
        case K_COMMIT:
        case K_COMMENT:
        case K_CREATE:
        case K_DECLARE:
        case K_DELETE:
        case K_DESCRIBE:
        case K_DROP:
        case K_EXEC:
        case K_EXECUTE:
        case K_EXPLAIN:
        case K_GRANT:
        case K_INSERT:
        case K_MERGE:
        case K_REPLACE:
        case K_ROLLBACK:
        case K_SAVEPOINT:
        case K_SELECT:
        case K_SET:
        case K_RESET:
        case K_SHOW:
        case K_TRUNCATE:
        case K_UPDATE:
        case K_UPSERT:
        case K_USE:
        case K_VALUES:
        case K_WITH:
        case 287:{
          stm = SingleStatement();
          break;
          }
        case K_BEGIN:{
          stm = Block();
          break;
          }
        default:
          jj_la1[7] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
list.add(stm);
        jj_consume_token(ST_SEMICOLON);
        label_2:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ALTER:
          case K_BEGIN:
          case K_CALL:
          case K_COMMIT:
          case K_COMMENT:
          case K_CREATE:
          case K_DECLARE:
          case K_DELETE:
          case K_DESCRIBE:
          case K_DROP:
          case K_EXEC:
          case K_EXECUTE:
          case K_EXPLAIN:
          case K_GRANT:
          case K_INSERT:
          case K_MERGE:
          case K_REPLACE:
          case K_ROLLBACK:
          case K_SAVEPOINT:
          case K_SELECT:
          case K_SET:
          case K_RESET:
          case K_SHOW:
          case K_TRUNCATE:
          case K_UPDATE:
          case K_UPSERT:
          case K_USE:
          case K_VALUES:
          case K_WITH:
          case 287:{
            ;
            break;
            }
          default:
            jj_la1[8] = jj_gen;
            break label_2;
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ALTER:
          case K_CALL:
          case K_COMMIT:
          case K_COMMENT:
          case K_CREATE:
          case K_DECLARE:
          case K_DELETE:
          case K_DESCRIBE:
          case K_DROP:
          case K_EXEC:
          case K_EXECUTE:
          case K_EXPLAIN:
          case K_GRANT:
          case K_INSERT:
          case K_MERGE:
          case K_REPLACE:
          case K_ROLLBACK:
          case K_SAVEPOINT:
          case K_SELECT:
          case K_SET:
          case K_RESET:
          case K_SHOW:
          case K_TRUNCATE:
          case K_UPDATE:
          case K_UPSERT:
          case K_USE:
          case K_VALUES:
          case K_WITH:
          case 287:{
            stm = SingleStatement();
            break;
            }
          case K_BEGIN:{
            stm = Block();
            break;
            }
          default:
            jj_la1[9] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          jj_consume_token(ST_SEMICOLON);
list.add(stm);
        }
      } catch (ParseException e) {
if (errorRecovery) {
            parseErrors.add(e);
            error_skipto(ST_SEMICOLON);
        } else {
            {if (true) throw e;}
        }
      }
stmts.setStatements(list);
        block.setStatements(stmts);
      jj_consume_token(K_END);
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
return block;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Statements Statements() throws ParseException {/*@bgen(jjtree) Statements */
    SimpleNode jjtn000 = new SimpleNode(JJTSTATEMENTS);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Statements stmts = new Statements();
    List<Statement> list = new ArrayList<Statement>();
    Statement stm;
    try {
      label_3:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case ST_SEMICOLON:{
          ;
          break;
          }
        default:
          jj_la1[10] = jj_gen;
          break label_3;
        }
        jj_consume_token(ST_SEMICOLON);
      }
      try {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ALTER:
        case K_CALL:
        case K_COMMIT:
        case K_COMMENT:
        case K_CREATE:
        case K_DECLARE:
        case K_DELETE:
        case K_DESCRIBE:
        case K_DROP:
        case K_EXEC:
        case K_EXECUTE:
        case K_EXPLAIN:
        case K_GRANT:
        case K_INSERT:
        case K_MERGE:
        case K_REPLACE:
        case K_ROLLBACK:
        case K_SAVEPOINT:
        case K_SELECT:
        case K_SET:
        case K_RESET:
        case K_SHOW:
        case K_TRUNCATE:
        case K_UPDATE:
        case K_UPSERT:
        case K_USE:
        case K_VALUES:
        case K_WITH:
        case 287:{
          stm = SingleStatement();
          break;
          }
        case K_BEGIN:{
          stm = Block();
          break;
          }
        default:
          jj_la1[11] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
list.add(stm);
        label_4:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case ST_SEMICOLON:{
            ;
            break;
            }
          default:
            jj_la1[12] = jj_gen;
            break label_4;
          }
          jj_consume_token(ST_SEMICOLON);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ALTER:
          case K_BEGIN:
          case K_CALL:
          case K_COMMIT:
          case K_COMMENT:
          case K_CREATE:
          case K_DECLARE:
          case K_DELETE:
          case K_DESCRIBE:
          case K_DROP:
          case K_EXEC:
          case K_EXECUTE:
          case K_EXPLAIN:
          case K_GRANT:
          case K_INSERT:
          case K_MERGE:
          case K_REPLACE:
          case K_ROLLBACK:
          case K_SAVEPOINT:
          case K_SELECT:
          case K_SET:
          case K_RESET:
          case K_SHOW:
          case K_TRUNCATE:
          case K_UPDATE:
          case K_UPSERT:
          case K_USE:
          case K_VALUES:
          case K_WITH:
          case 287:{
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_ALTER:
            case K_CALL:
            case K_COMMIT:
            case K_COMMENT:
            case K_CREATE:
            case K_DECLARE:
            case K_DELETE:
            case K_DESCRIBE:
            case K_DROP:
            case K_EXEC:
            case K_EXECUTE:
            case K_EXPLAIN:
            case K_GRANT:
            case K_INSERT:
            case K_MERGE:
            case K_REPLACE:
            case K_ROLLBACK:
            case K_SAVEPOINT:
            case K_SELECT:
            case K_SET:
            case K_RESET:
            case K_SHOW:
            case K_TRUNCATE:
            case K_UPDATE:
            case K_UPSERT:
            case K_USE:
            case K_VALUES:
            case K_WITH:
            case 287:{
              stm = SingleStatement();
              break;
              }
            case K_BEGIN:{
              stm = Block();
              break;
              }
            default:
              jj_la1[13] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
list.add(stm);
            break;
            }
          default:
            jj_la1[14] = jj_gen;
            ;
          }
        }
        jj_consume_token(0);
      } catch (ParseException e) {
if (errorRecovery) {
            parseErrors.add(e);
            error_skipto(ST_SEMICOLON);
        } else {
            {if (true) throw e;}
        }
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
return stmts.withStatements(list);
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  void error_skipto(int kind) throws ParseException {ParseException e = generateParseException();
  Token t;
  do {
    t = getNextToken();
  } while (t.kind != kind && t.kind != EOF);
  }

  final public DeclareStatement Declare() throws ParseException {UserVariable userVariable;
    ColDataType colDataType;
    Expression defaultExpr = null;
    DeclareStatement stmt = new DeclareStatement();
    String typeName;
    String columnName;
    ColumnDefinition colDef;
    jj_consume_token(K_DECLARE);
    userVariable = UserVariable();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_TABLE:{
      jj_consume_token(K_TABLE);
      jj_consume_token(287);
      colDef = ColumnDefinition();
stmt.withUserVariable(userVariable)
        .withDeclareType(DeclareType.TABLE)
        .addColumnDefinition(colDef);
      label_5:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[15] = jj_gen;
          break label_5;
        }
        jj_consume_token(K_COMMA);
        colDef = ColumnDefinition();
stmt.addColumnDefinition(colDef);
      }
      jj_consume_token(288);
      break;
      }
    case K_AS:{
      jj_consume_token(K_AS);
      typeName = RelObjectName();
stmt.withUserVariable(userVariable)
                      .withDeclareType(DeclareType.AS)
                      .withTypeName(typeName);
      break;
      }
    case K_BINARY:
    case K_BIT:
    case K_CHARACTER:
    case K_CHAR:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DOUBLE:
    case K_INTERVAL:
    case K_JSON:
    case K_SET:
    case K_SIGNED:
    case K_UNSIGNED:
    case K_XML:
    case DT_ZONE:
    case S_IDENTIFIER:{
      colDataType = ColDataType();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 289:{
        jj_consume_token(289);
        defaultExpr = Expression();
        break;
        }
      default:
        jj_la1[16] = jj_gen;
        ;
      }
stmt.withDeclareType(DeclareType.TYPE)
                  .addType(userVariable, colDataType, defaultExpr);
      label_6:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[17] = jj_gen;
          break label_6;
        }
        jj_consume_token(K_COMMA);
        userVariable = UserVariable();
        colDataType = ColDataType();
defaultExpr = null;
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 289:{
          jj_consume_token(289);
          defaultExpr = Expression();
          break;
          }
        default:
          jj_la1[18] = jj_gen;
          ;
        }
stmt.addType(userVariable, colDataType, defaultExpr);
      }
      break;
      }
    default:
      jj_la1[19] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return stmt;
}

  final public SetStatement Set() throws ParseException {String name;
    ArrayList<Expression> expList;
    boolean useEqual = false;
    SetStatement set;
    Expression exp = null;
    Token tk = null;
    String effectParameter = null;
    jj_consume_token(K_SET);
    if (jj_2_15(3)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_LOCAL:{
        tk = jj_consume_token(K_LOCAL);
        break;
        }
      case K_SESSION:{
        tk = jj_consume_token(K_SESSION);
        break;
        }
      default:
        jj_la1[20] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
effectParameter = tk.image;
    } else {
      ;
    }
    if (jj_2_16(2)) {
      jj_consume_token(K_DATETIMELITERAL);
      jj_consume_token(K_ZONE);
name = "Time Zone"; useEqual=false;
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ACTION:
      case K_ALGORITHM:
      case K_ALL:
      case K_ANY:
      case K_ARRAY_LITERAL:
      case K_BYTE:
      case K_CASCADE:
      case K_CASE:
      case K_CASEWHEN:
      case K_CAST:
      case K_CHARACTER:
      case K_CHANGE:
      case K_CHAR:
      case K_COLUMN:
      case K_COLUMNS:
      case K_COMMIT:
      case K_COMMENT:
      case K_COSTS:
      case K_CREATE:
      case K_CYCLE:
      case K_DATETIMELITERAL:
      case K_DATE_LITERAL:
      case K_DESC:
      case K_DESCRIBE:
      case K_DISABLE:
      case K_DIV:
      case K_DO:
      case K_DOUBLE:
      case K_DUPLICATE:
      case K_ENABLE:
      case K_END:
      case K_EXCLUDE:
      case K_EXTRACT:
      case K_FIRST:
      case K_FALSE:
      case K_FOLLOWING:
      case K_FORMAT:
      case K_GROUP:
      case K_IF:
      case K_IIF:
      case K_IN:
      case K_INDEX:
      case K_INSERT:
      case K_INTERVAL:
      case K_ISNULL:
      case K_JSON:
      case K_KEY:
      case K_FN:
      case K_LAST:
      case K_LEADING:
      case K_LEFT:
      case K_LIMIT:
      case K_LOCAL:
      case K_MATERIALIZED:
      case K_NEXTVAL:
      case K_NO:
      case K_NOLOCK:
      case K_NULLS:
      case K_OF:
      case K_OFFSET:
      case K_ON:
      case K_OPEN:
      case K_ORDER:
      case K_OVER:
      case K_OPTIMIZE:
      case K_PARALLEL:
      case K_PARTITION:
      case K_PATH:
      case K_PERCENT:
      case K_PRECISION:
      case K_PRIMARY:
      case K_PRIOR:
      case K_PROCEDURE:
      case K_PUBLIC:
      case K_RANGE:
      case K_READ:
      case K_REPLACE:
      case K_RIGHT:
      case K_ROW:
      case K_ROWS:
      case K_SCHEMA:
      case K_SEQUENCE:
      case K_SEPARATOR:
      case K_SESSION:
      case K_SET:
      case K_SIBLINGS:
      case K_SIZE:
      case K_SKIP:
      case K_START:
      case K_SYNONYM:
      case K_TABLE:
      case K_TABLES:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIMEOUT:
      case K_TO:
      case K_TOP:
      case K_TRUNCATE:
      case K_TRUE:
      case K_TYPE:
      case K_SIGNED:
      case K_UNSIGNED:
      case K_VALIDATE:
      case K_VALUE:
      case K_VALUES:
      case K_VIEW:
      case K_XML:
      case K_ZONE:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:{
        name = RelObjectNameExt();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 289:{
          jj_consume_token(289);
useEqual=true;
          break;
          }
        default:
          jj_la1[21] = jj_gen;
          ;
        }
        break;
        }
      default:
        jj_la1[22] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    exp = SimpleExpression();
expList = new ArrayList<Expression>(); expList.add(exp);
set = new SetStatement(name,expList).withUseEqual(useEqual).withEffectParameter(effectParameter);
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[23] = jj_gen;
        break label_7;
      }
useEqual=false;
      jj_consume_token(K_COMMA);
      if (jj_2_18(3)) {
        if (jj_2_17(2)) {
          jj_consume_token(K_DATETIMELITERAL);
          jj_consume_token(K_ZONE);
name = "Time Zone"; useEqual=false;
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ACTION:
          case K_ALGORITHM:
          case K_ALL:
          case K_ANY:
          case K_ARRAY_LITERAL:
          case K_BYTE:
          case K_CASCADE:
          case K_CASE:
          case K_CASEWHEN:
          case K_CAST:
          case K_CHARACTER:
          case K_CHANGE:
          case K_CHAR:
          case K_COLUMN:
          case K_COLUMNS:
          case K_COMMIT:
          case K_COMMENT:
          case K_COSTS:
          case K_CREATE:
          case K_CYCLE:
          case K_DATETIMELITERAL:
          case K_DATE_LITERAL:
          case K_DESC:
          case K_DESCRIBE:
          case K_DISABLE:
          case K_DIV:
          case K_DO:
          case K_DOUBLE:
          case K_DUPLICATE:
          case K_ENABLE:
          case K_END:
          case K_EXCLUDE:
          case K_EXTRACT:
          case K_FIRST:
          case K_FALSE:
          case K_FOLLOWING:
          case K_FORMAT:
          case K_GROUP:
          case K_IF:
          case K_IIF:
          case K_IN:
          case K_INDEX:
          case K_INSERT:
          case K_INTERVAL:
          case K_ISNULL:
          case K_JSON:
          case K_KEY:
          case K_FN:
          case K_LAST:
          case K_LEADING:
          case K_LEFT:
          case K_LIMIT:
          case K_LOCAL:
          case K_MATERIALIZED:
          case K_NEXTVAL:
          case K_NO:
          case K_NOLOCK:
          case K_NULLS:
          case K_OF:
          case K_OFFSET:
          case K_ON:
          case K_OPEN:
          case K_ORDER:
          case K_OVER:
          case K_OPTIMIZE:
          case K_PARALLEL:
          case K_PARTITION:
          case K_PATH:
          case K_PERCENT:
          case K_PRECISION:
          case K_PRIMARY:
          case K_PRIOR:
          case K_PROCEDURE:
          case K_PUBLIC:
          case K_RANGE:
          case K_READ:
          case K_REPLACE:
          case K_RIGHT:
          case K_ROW:
          case K_ROWS:
          case K_SCHEMA:
          case K_SEQUENCE:
          case K_SEPARATOR:
          case K_SESSION:
          case K_SET:
          case K_SIBLINGS:
          case K_SIZE:
          case K_SKIP:
          case K_START:
          case K_SYNONYM:
          case K_TABLE:
          case K_TABLES:
          case K_TEMP:
          case K_TEMPORARY:
          case K_TIMEOUT:
          case K_TO:
          case K_TOP:
          case K_TRUNCATE:
          case K_TRUE:
          case K_TYPE:
          case K_SIGNED:
          case K_UNSIGNED:
          case K_VALIDATE:
          case K_VALUE:
          case K_VALUES:
          case K_VIEW:
          case K_XML:
          case K_ZONE:
          case S_IDENTIFIER:
          case S_QUOTED_IDENTIFIER:{
            name = RelObjectNameExt();
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case 289:{
              jj_consume_token(289);
useEqual=true;
              break;
              }
            default:
              jj_la1[24] = jj_gen;
              ;
            }
            break;
            }
          default:
            jj_la1[25] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        exp = SimpleExpression();
expList = new ArrayList<Expression>();
                expList.add(exp);
                set.add(name, expList, useEqual);
      } else if (jj_2_19(1)) {
        exp = SimpleExpression();
expList.add(exp);
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return set;
}

  final public ResetStatement Reset() throws ParseException {String name;
    ResetStatement reset;
    Token all;
    jj_consume_token(K_RESET);
    if (jj_2_20(2)) {
      jj_consume_token(K_DATETIMELITERAL);
      jj_consume_token(K_ZONE);
name = "Time Zone";
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ACTION:
      case K_ALGORITHM:
      case K_ANY:
      case K_ARRAY_LITERAL:
      case K_BYTE:
      case K_CASCADE:
      case K_CASE:
      case K_CAST:
      case K_CHARACTER:
      case K_CHANGE:
      case K_CHAR:
      case K_COLUMN:
      case K_COLUMNS:
      case K_COMMIT:
      case K_COMMENT:
      case K_COSTS:
      case K_CREATE:
      case K_CYCLE:
      case K_DATETIMELITERAL:
      case K_DATE_LITERAL:
      case K_DESC:
      case K_DESCRIBE:
      case K_DISABLE:
      case K_DIV:
      case K_DO:
      case K_DUPLICATE:
      case K_ENABLE:
      case K_END:
      case K_EXCLUDE:
      case K_EXTRACT:
      case K_FIRST:
      case K_FALSE:
      case K_FOLLOWING:
      case K_FORMAT:
      case K_GROUP:
      case K_INDEX:
      case K_INSERT:
      case K_INTERVAL:
      case K_ISNULL:
      case K_JSON:
      case K_KEY:
      case K_FN:
      case K_LAST:
      case K_LEADING:
      case K_LOCAL:
      case K_MATERIALIZED:
      case K_NEXTVAL:
      case K_NO:
      case K_NOLOCK:
      case K_NULLS:
      case K_OF:
      case K_ON:
      case K_OPEN:
      case K_ORDER:
      case K_OVER:
      case K_PARALLEL:
      case K_PARTITION:
      case K_PATH:
      case K_PERCENT:
      case K_PRECISION:
      case K_PRIMARY:
      case K_PRIOR:
      case K_RANGE:
      case K_READ:
      case K_REPLACE:
      case K_ROW:
      case K_ROWS:
      case K_SCHEMA:
      case K_SEQUENCE:
      case K_SEPARATOR:
      case K_SESSION:
      case K_SIBLINGS:
      case K_SIZE:
      case K_SKIP:
      case K_START:
      case K_SYNONYM:
      case K_TABLE:
      case K_TABLES:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIMEOUT:
      case K_TO:
      case K_TOP:
      case K_TRUNCATE:
      case K_TRUE:
      case K_TYPE:
      case K_SIGNED:
      case K_UNSIGNED:
      case K_VALIDATE:
      case K_VALUE:
      case K_VALUES:
      case K_VIEW:
      case K_XML:
      case K_ZONE:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:{
        name = RelObjectName();
        break;
        }
      case K_ALL:{
        all = jj_consume_token(K_ALL);
name = all.image;
        break;
        }
      default:
        jj_la1[26] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
reset = new ResetStatement(name);
return reset;
}

  final public DescribeStatement Describe() throws ParseException {Table table;
    jj_consume_token(K_DESCRIBE);
    table = Table();
return new DescribeStatement(table);
}

  final public ExplainStatement Explain() throws ParseException {Select select;
    List<ExplainStatement.Option> options = null;
    jj_consume_token(K_EXPLAIN);
    options = ExplainStatementOptions();
    select = SelectWithWithItems();
ExplainStatement es = new ExplainStatement(select);
       if(options != null && !options.isEmpty()) {
         for(ExplainStatement.Option o : options) {
           es.addOption(o);
         }
       }
       return es;
}

/**
 * Postgres supports TRUE,ON,1,FALSE,OFF,0 as values
 */
  final public String ExplainOptionBoolean() throws ParseException {Token tk = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FALSE:
    case K_OFF:
    case K_ON:
    case K_TRUE:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_TRUE:{
        tk = jj_consume_token(K_TRUE);
        break;
        }
      case K_FALSE:{
        tk = jj_consume_token(K_FALSE);
        break;
        }
      case K_ON:{
        tk = jj_consume_token(K_ON);
        break;
        }
      case K_OFF:{
        tk = jj_consume_token(K_OFF);
        break;
        }
      default:
        jj_la1[27] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[28] = jj_gen;
      ;
    }
return tk != null ? tk.image : null;
}

/**
 * The output format, which can be TEXT, XML, JSON, or YAML
 */
  final public String ExplainFormatOption() throws ParseException {Token tk = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_JSON:
    case K_XML:
    case K_YAML:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_XML:{
        tk = jj_consume_token(K_XML);
        break;
        }
      case K_JSON:{
        tk = jj_consume_token(K_JSON);
        break;
        }
      case K_YAML:{
        tk = jj_consume_token(K_YAML);
        break;
        }
      default:
        jj_la1[29] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[30] = jj_gen;
      ;
    }
return tk != null ? tk.image : null;
}

/**
 * Options for explain, see https://www.postgresql.org/docs/9.1/sql-explain.html
 */
  final public List<ExplainStatement.Option> ExplainStatementOptions() throws ParseException {List<ExplainStatement.Option> options = new ArrayList<ExplainStatement.Option>();
  ExplainStatement.Option option = null;
  Token token = null;
  String value = null;
    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ANALYZE:
      case K_BUFFERS:
      case K_COSTS:
      case K_FORMAT:
      case K_VERBOSE:{
        ;
        break;
        }
      default:
        jj_la1[31] = jj_gen;
        break label_8;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ANALYZE:{
        jj_consume_token(K_ANALYZE);
        value = ExplainOptionBoolean();
option = new ExplainStatement.Option(ExplainStatement.OptionType.ANALYZE);
       option.setValue(value);
       options.add(option);
        break;
        }
      case K_BUFFERS:{
        jj_consume_token(K_BUFFERS);
        value = ExplainOptionBoolean();
option = new ExplainStatement.Option(ExplainStatement.OptionType.BUFFERS);
        option.setValue(value);
        options.add(option);
        break;
        }
      case K_COSTS:{
        jj_consume_token(K_COSTS);
        value = ExplainOptionBoolean();
option = new ExplainStatement.Option(ExplainStatement.OptionType.COSTS);
        option.setValue(value);
        options.add(option);
        break;
        }
      case K_VERBOSE:{
        jj_consume_token(K_VERBOSE);
        value = ExplainOptionBoolean();
option = new ExplainStatement.Option(ExplainStatement.OptionType.VERBOSE);
        option.setValue(value);
        options.add(option);
        break;
        }
      case K_FORMAT:{
        jj_consume_token(K_FORMAT);
        value = ExplainFormatOption();
option = new ExplainStatement.Option(ExplainStatement.OptionType.FORMAT);
        option.setValue(value);
        options.add(option);
        break;
        }
      default:
        jj_la1[32] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return options;
}

  final public UseStatement Use() throws ParseException {String name;
    jj_consume_token(K_USE);
    name = RelObjectNameExt();
return new UseStatement(name);
}

  final public ShowColumnsStatement ShowColumns() throws ParseException {String tableName;
    jj_consume_token(K_SHOW);
    jj_consume_token(K_COLUMNS);
    jj_consume_token(K_FROM);
    tableName = RelObjectNameExt();
return new ShowColumnsStatement(tableName);
}

// https://dev.mysql.com/doc/refman/8.0/en/show-tables.html
  final public ShowTablesStatement ShowTables() throws ParseException {ShowTablesStatement showTablesStatement;
    EnumSet<ShowTablesStatement.Modifiers> modifiers =  EnumSet.noneOf(ShowTablesStatement.Modifiers.class);
    ShowTablesStatement.SelectionMode selectionMode = null;
    String dbName = null;
    Expression likeExpression = null;
    Expression whereCondition = null;
    jj_consume_token(K_SHOW);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_EXTENDED:{
      jj_consume_token(K_EXTENDED);
modifiers.add(ShowTablesStatement.Modifiers.EXTENDED);
      break;
      }
    default:
      jj_la1[33] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FULL:{
      jj_consume_token(K_FULL);
modifiers.add(ShowTablesStatement.Modifiers.FULL);
      break;
      }
    default:
      jj_la1[34] = jj_gen;
      ;
    }
    jj_consume_token(K_TABLES);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FROM:
    case K_IN:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_FROM:{
        jj_consume_token(K_FROM);
selectionMode = ShowTablesStatement.SelectionMode.FROM;
        break;
        }
      case K_IN:{
        jj_consume_token(K_IN);
selectionMode = ShowTablesStatement.SelectionMode.IN;
        break;
        }
      default:
        jj_la1[35] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      dbName = RelObjectNameExt();
      break;
      }
    default:
      jj_la1[36] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_LIKE:
    case K_WHERE:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_LIKE:{
        jj_consume_token(K_LIKE);
        likeExpression = SimpleExpression();
        break;
        }
      case K_WHERE:{
        jj_consume_token(K_WHERE);
        whereCondition = Expression();
        break;
        }
      default:
        jj_la1[37] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[38] = jj_gen;
      ;
    }
showTablesStatement = new ShowTablesStatement();
    showTablesStatement.setModifiers(modifiers);
    showTablesStatement.setSelectionMode(selectionMode);
    showTablesStatement.setDbName(dbName);
    showTablesStatement.setLikeExpression(likeExpression);
    showTablesStatement.setWhereCondition(whereCondition);
    return showTablesStatement;
}

  final public ShowStatement Show() throws ParseException {String name;
    jj_consume_token(K_SHOW);
    name = RelObjectNameExt();
return new ShowStatement(name);
}

  final public ValuesStatement Values() throws ParseException {ItemsList itemsList;
    jj_consume_token(K_VALUES);
    itemsList = SimpleExpressionList(false);
return new ValuesStatement(itemsList);
}

  final public Update Update(List<WithItem> with) throws ParseException {Update update = new Update();
    Table table = null;
    List<Join> startJoins = null;
    Expression where = null;
    Column tableColumn = null;
    List<Expression> expList = new ArrayList<Expression>();
    List<Column> columns = new ArrayList<Column>();
    Expression value = null;
    FromItem fromItem = null;
    List<Join> joins = null;
    Select select = null;
    Limit limit = null;
    List<OrderByElement> orderByElements;
    boolean useColumnsBrackets = false;
    List<SelectExpressionItem> returning = null;
    jj_consume_token(K_UPDATE);
update.setOracleHint(getOracleHint());
    table = TableWithAlias();
    startJoins = JoinsList();
    jj_consume_token(K_SET);
    if (jj_2_21(3)) {
      tableColumn = Column();
      jj_consume_token(289);
      value = SimpleExpression();
columns.add(tableColumn); expList.add(value);
      label_9:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[39] = jj_gen;
          break label_9;
        }
        jj_consume_token(K_COMMA);
        tableColumn = Column();
        jj_consume_token(289);
        value = SimpleExpression();
columns.add(tableColumn); expList.add(value);
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ACTION:
      case K_ALGORITHM:
      case K_ALL:
      case K_ANY:
      case K_ARRAY_LITERAL:
      case K_BYTE:
      case K_CASCADE:
      case K_CASE:
      case K_CASEWHEN:
      case K_CAST:
      case K_CHARACTER:
      case K_CHANGE:
      case K_CHAR:
      case K_COLUMN:
      case K_COLUMNS:
      case K_COMMIT:
      case K_COMMENT:
      case K_COSTS:
      case K_CREATE:
      case K_CYCLE:
      case K_DATETIMELITERAL:
      case K_DATE_LITERAL:
      case K_DESC:
      case K_DESCRIBE:
      case K_DISABLE:
      case K_DIV:
      case K_DO:
      case K_DOUBLE:
      case K_DUPLICATE:
      case K_ENABLE:
      case K_END:
      case K_EXCLUDE:
      case K_EXTRACT:
      case K_FIRST:
      case K_FALSE:
      case K_FOLLOWING:
      case K_FORMAT:
      case K_GROUP:
      case K_IF:
      case K_IIF:
      case K_IN:
      case K_INDEX:
      case K_INSERT:
      case K_INTERVAL:
      case K_ISNULL:
      case K_JSON:
      case K_KEY:
      case K_FN:
      case K_LAST:
      case K_LEADING:
      case K_LEFT:
      case K_LIMIT:
      case K_LOCAL:
      case K_MATERIALIZED:
      case K_NEXTVAL:
      case K_NO:
      case K_NOLOCK:
      case K_NULLS:
      case K_OF:
      case K_OFFSET:
      case K_ON:
      case K_OPEN:
      case K_ORDER:
      case K_OVER:
      case K_OPTIMIZE:
      case K_PARALLEL:
      case K_PARTITION:
      case K_PATH:
      case K_PERCENT:
      case K_PRECISION:
      case K_PRIMARY:
      case K_PRIOR:
      case K_PROCEDURE:
      case K_PUBLIC:
      case K_RANGE:
      case K_READ:
      case K_REPLACE:
      case K_RIGHT:
      case K_ROW:
      case K_ROWS:
      case K_SCHEMA:
      case K_SEQUENCE:
      case K_SEPARATOR:
      case K_SESSION:
      case K_SET:
      case K_SIBLINGS:
      case K_SIZE:
      case K_SKIP:
      case K_START:
      case K_SYNONYM:
      case K_TABLE:
      case K_TABLES:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIMEOUT:
      case K_TO:
      case K_TOP:
      case K_TRUNCATE:
      case K_TRUE:
      case K_TYPE:
      case K_SIGNED:
      case K_UNSIGNED:
      case K_VALIDATE:
      case K_VALUE:
      case K_VALUES:
      case K_VIEW:
      case K_XML:
      case K_ZONE:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:
      case 287:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 287:{
          jj_consume_token(287);
useColumnsBrackets = true;
          tableColumn = Column();
columns.add(tableColumn);
          label_10:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_COMMA:{
              ;
              break;
              }
            default:
              jj_la1[40] = jj_gen;
              break label_10;
            }
            jj_consume_token(K_COMMA);
            tableColumn = Column();
columns.add(tableColumn);
          }
          jj_consume_token(288);
          break;
          }
        case K_ACTION:
        case K_ALGORITHM:
        case K_ALL:
        case K_ANY:
        case K_ARRAY_LITERAL:
        case K_BYTE:
        case K_CASCADE:
        case K_CASE:
        case K_CASEWHEN:
        case K_CAST:
        case K_CHARACTER:
        case K_CHANGE:
        case K_CHAR:
        case K_COLUMN:
        case K_COLUMNS:
        case K_COMMIT:
        case K_COMMENT:
        case K_COSTS:
        case K_CREATE:
        case K_CYCLE:
        case K_DATETIMELITERAL:
        case K_DATE_LITERAL:
        case K_DESC:
        case K_DESCRIBE:
        case K_DISABLE:
        case K_DIV:
        case K_DO:
        case K_DOUBLE:
        case K_DUPLICATE:
        case K_ENABLE:
        case K_END:
        case K_EXCLUDE:
        case K_EXTRACT:
        case K_FIRST:
        case K_FALSE:
        case K_FOLLOWING:
        case K_FORMAT:
        case K_GROUP:
        case K_IF:
        case K_IIF:
        case K_IN:
        case K_INDEX:
        case K_INSERT:
        case K_INTERVAL:
        case K_ISNULL:
        case K_JSON:
        case K_KEY:
        case K_FN:
        case K_LAST:
        case K_LEADING:
        case K_LEFT:
        case K_LIMIT:
        case K_LOCAL:
        case K_MATERIALIZED:
        case K_NEXTVAL:
        case K_NO:
        case K_NOLOCK:
        case K_NULLS:
        case K_OF:
        case K_OFFSET:
        case K_ON:
        case K_OPEN:
        case K_ORDER:
        case K_OVER:
        case K_OPTIMIZE:
        case K_PARALLEL:
        case K_PARTITION:
        case K_PATH:
        case K_PERCENT:
        case K_PRECISION:
        case K_PRIMARY:
        case K_PRIOR:
        case K_PROCEDURE:
        case K_PUBLIC:
        case K_RANGE:
        case K_READ:
        case K_REPLACE:
        case K_RIGHT:
        case K_ROW:
        case K_ROWS:
        case K_SCHEMA:
        case K_SEQUENCE:
        case K_SEPARATOR:
        case K_SESSION:
        case K_SET:
        case K_SIBLINGS:
        case K_SIZE:
        case K_SKIP:
        case K_START:
        case K_SYNONYM:
        case K_TABLE:
        case K_TABLES:
        case K_TEMP:
        case K_TEMPORARY:
        case K_TIMEOUT:
        case K_TO:
        case K_TOP:
        case K_TRUNCATE:
        case K_TRUE:
        case K_TYPE:
        case K_SIGNED:
        case K_UNSIGNED:
        case K_VALIDATE:
        case K_VALUE:
        case K_VALUES:
        case K_VIEW:
        case K_XML:
        case K_ZONE:
        case S_IDENTIFIER:
        case S_QUOTED_IDENTIFIER:{
          tableColumn = Column();
columns.add(tableColumn);
          label_11:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_COMMA:{
              ;
              break;
              }
            default:
              jj_la1[41] = jj_gen;
              break label_11;
            }
            jj_consume_token(K_COMMA);
            tableColumn = Column();
columns.add(tableColumn);
          }
          break;
          }
        default:
          jj_la1[42] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(289);
        jj_consume_token(287);
update.setUseSelect(true);
        select = SelectWithWithItems();
        jj_consume_token(288);
        break;
        }
      default:
        jj_la1[43] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FROM:{
      jj_consume_token(K_FROM);
      fromItem = FromItem();
      joins = JoinsList();
      break;
      }
    default:
      jj_la1[44] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_WHERE:{
      where = WhereClause();
update.setWhere(where);
      break;
      }
    default:
      jj_la1[45] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ORDER:{
      orderByElements = OrderByElements();
update.setOrderByElements(orderByElements);
      break;
      }
    default:
      jj_la1[46] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_LIMIT:{
      limit = PlainLimit();
update.setLimit(limit);
      break;
      }
    default:
      jj_la1[47] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_RETURNING:{
      jj_consume_token(K_RETURNING);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 290:{
        jj_consume_token(290);
update.setReturningAllColumns(true);
        break;
        }
      default:
        jj_la1[48] = jj_gen;
        if (jj_2_22(1)) {
          returning = ListExpressionItem();
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[49] = jj_gen;
      ;
    }
return update.withWithItemsList(with)
              .withColumns(columns)
                  .withExpressions(expList)
              .withTable(table)
              .withStartJoins(startJoins)
              .withFromItem(fromItem)
              .withJoins(joins)
              .withSelect(select)
              .withUseColumnsBrackets(useColumnsBrackets)
              .withReturningExpressionList(returning);
}

  final public Replace Replace() throws ParseException {Replace replace = new Replace();
    Table table = null;
    Column tableColumn = null;
    Expression value = null;

    List<Column> columns = new ArrayList<Column>();
    List<Expression> expList = new ArrayList<Expression>();
    MultiExpressionList multiExpr = null;
    ItemsList itemsList = null;
    Expression exp = null;
    jj_consume_token(K_REPLACE);
    if (jj_2_23(2)) {
      jj_consume_token(K_INTO);
replace.setUseIntoTables(true);
    } else {
      ;
    }
    table = Table();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_SET:{
      jj_consume_token(K_SET);
      tableColumn = Column();
      jj_consume_token(289);
      value = SimpleExpression();
columns.add(tableColumn); expList.add(value);
      label_12:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[50] = jj_gen;
          break label_12;
        }
        jj_consume_token(K_COMMA);
        tableColumn = Column();
        jj_consume_token(289);
        value = SimpleExpression();
columns.add(tableColumn); expList.add(value);
      }
replace.setExpressions(expList);
      break;
      }
    case K_SELECT:
    case K_VALUE:
    case K_VALUES:
    case K_WITH:
    case 287:{
      if (jj_2_24(2)) {
        jj_consume_token(287);
        tableColumn = Column();
columns.add(tableColumn);
        label_13:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_COMMA:{
            ;
            break;
            }
          default:
            jj_la1[51] = jj_gen;
            break label_13;
          }
          jj_consume_token(K_COMMA);
          tableColumn = Column();
columns.add(tableColumn);
        }
        jj_consume_token(288);
      } else {
        ;
      }
      if (jj_2_25(2)) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_VALUE:
        case K_VALUES:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_VALUES:{
            jj_consume_token(K_VALUES);
            break;
            }
          case K_VALUE:{
            jj_consume_token(K_VALUE);
            break;
            }
          default:
            jj_la1[52] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        default:
          jj_la1[53] = jj_gen;
          ;
        }
        jj_consume_token(287);
        exp = PrimaryExpression();
expList.add(exp);
        label_14:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_COMMA:{
            ;
            break;
            }
          default:
            jj_la1[54] = jj_gen;
            break label_14;
          }
          jj_consume_token(K_COMMA);
          exp = PrimaryExpression();
expList.add(exp);
        }
        jj_consume_token(288);
itemsList = new ExpressionList(expList);
        label_15:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_COMMA:{
            ;
            break;
            }
          default:
            jj_la1[55] = jj_gen;
            break label_15;
          }
          jj_consume_token(K_COMMA);
          jj_consume_token(287);
          exp = SimpleExpression();
if (multiExpr==null) {
                                multiExpr=new MultiExpressionList();
                                multiExpr.addExpressionList((ExpressionList)itemsList);
                                itemsList = multiExpr;
                            }
                            expList = new ArrayList<Expression>();
                            expList.add(exp);
          label_16:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_COMMA:{
              ;
              break;
              }
            default:
              jj_la1[56] = jj_gen;
              break label_16;
            }
            jj_consume_token(K_COMMA);
            exp = SimpleExpression();
expList.add(exp);
          }
          jj_consume_token(288);
multiExpr.addExpressionList(expList);
        }
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_SELECT:
        case K_VALUES:
        case K_WITH:
        case 287:{
replace.setUseValues(false);
          itemsList = SubSelect();
((SubSelect)itemsList).setUseBrackets(false);
          break;
          }
        default:
          jj_la1[57] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
replace.setItemsList(itemsList);
      break;
      }
    default:
      jj_la1[58] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if (!columns.isEmpty()) {
           replace.withColumns(columns);
        }
        return replace.withTable(table);
}

  final public List<SelectExpressionItem> ListExpressionItem() throws ParseException {List<SelectExpressionItem> retval = new ArrayList<SelectExpressionItem>();
   SelectExpressionItem item;
    item = SelectExpressionItem();
retval.add(item);
    label_17:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[59] = jj_gen;
        break label_17;
      }
      jj_consume_token(K_COMMA);
      item = SelectExpressionItem();
retval.add(item);
    }
return retval;
}

  final public Insert Insert(List<WithItem> with) throws ParseException {Insert insert = new Insert();
    Table table = null;
    Column tableColumn = null;
    List<Column> columns = new ArrayList<Column>();
    List<Expression> primaryExpList = new ArrayList<Expression>();
    ItemsList itemsList = null;
    Expression exp = null;
    MultiExpressionList multiExpr = null;
    List<SelectExpressionItem> returning = null;
    Select select = null;
    boolean useValues = true;
    boolean useSelectBrackets = false;
    boolean useDuplicate = false;
    List<Column> duplicateUpdateColumns = null;
    List<Expression> duplicateUpdateExpressionList = null;
    Token tk = null;
    InsertModifierPriority modifierPriority = null;
    boolean modifierIgnore = false;
    boolean useSet = false;
    List<Column> setColumns = new ArrayList<Column>();
    List<Expression> setExpressionList = new ArrayList<Expression>();
    String name = null;
    boolean useAs = false;
    jj_consume_token(K_INSERT);
insert.setOracleHint(getOracleHint());
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_DELAYED:
    case K_HIGH_PRIORITY:
    case K_LOW_PRIORITY:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_LOW_PRIORITY:{
        tk = jj_consume_token(K_LOW_PRIORITY);
        break;
        }
      case K_DELAYED:{
        tk = jj_consume_token(K_DELAYED);
        break;
        }
      case K_HIGH_PRIORITY:{
        tk = jj_consume_token(K_HIGH_PRIORITY);
        break;
        }
      default:
        jj_la1[60] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
if (tk!=null)
        modifierPriority = InsertModifierPriority.valueOf(tk.image.toUpperCase());
      break;
      }
    default:
      jj_la1[61] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_IGNORE:{
      jj_consume_token(K_IGNORE);
modifierIgnore = true;
      break;
      }
    default:
      jj_la1[62] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_INTO:{
      jj_consume_token(K_INTO);
      break;
      }
    default:
      jj_la1[63] = jj_gen;
      ;
    }
    table = Table();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ALGORITHM:
    case K_ANY:
    case K_ARRAY_LITERAL:
    case K_AS:
    case K_BYTE:
    case K_CASCADE:
    case K_CASE:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHAR:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_COSTS:
    case K_CYCLE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DIV:
    case K_DO:
    case K_DUPLICATE:
    case K_ENABLE:
    case K_END:
    case K_EXCLUDE:
    case K_EXTRACT:
    case K_FIRST:
    case K_FALSE:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_INDEX:
    case K_INSERT:
    case K_ISNULL:
    case K_JSON:
    case K_KEY:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LOCAL:
    case K_MATERIALIZED:
    case K_NEXTVAL:
    case K_NO:
    case K_NOLOCK:
    case K_NULLS:
    case K_OF:
    case K_OPEN:
    case K_OVER:
    case K_PARALLEL:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_RANGE:
    case K_READ:
    case K_REPLACE:
    case K_ROW:
    case K_ROWS:
    case K_SCHEMA:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SIBLINGS:
    case K_SIZE:
    case K_SKIP:
    case K_SYNONYM:
    case K_TABLE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIMEOUT:
    case K_TO:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TYPE:
    case K_SIGNED:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VIEW:
    case K_XML:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_AS:{
        jj_consume_token(K_AS);
useAs = true;
        break;
        }
      default:
        jj_la1[64] = jj_gen;
        ;
      }
      name = RelObjectNameWithoutValue();
table.setAlias(new Alias(name,useAs));
      break;
      }
    default:
      jj_la1[65] = jj_gen;
      ;
    }
    if (jj_2_26(2)) {
      jj_consume_token(287);
      tableColumn = Column();
columns.add(tableColumn);
      label_18:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[66] = jj_gen;
          break label_18;
        }
        jj_consume_token(K_COMMA);
        tableColumn = Column();
columns.add(tableColumn);
      }
      jj_consume_token(288);
    } else {
      ;
    }
    if (jj_2_28(2)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_VALUE:
      case K_VALUES:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_VALUES:{
          jj_consume_token(K_VALUES);
          break;
          }
        case K_VALUE:{
          jj_consume_token(K_VALUE);
          break;
          }
        default:
          jj_la1[67] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[68] = jj_gen;
        ;
      }
      jj_consume_token(287);
      exp = SimpleExpression();
primaryExpList.add(exp);
      label_19:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[69] = jj_gen;
          break label_19;
        }
        jj_consume_token(K_COMMA);
        exp = SimpleExpression();
primaryExpList.add(exp);
      }
      jj_consume_token(288);
itemsList = new ExpressionList(primaryExpList);
      label_20:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[70] = jj_gen;
          break label_20;
        }
        jj_consume_token(K_COMMA);
        jj_consume_token(287);
        exp = SimpleExpression();
if (multiExpr==null) {
                        multiExpr=new MultiExpressionList();
                        multiExpr.addExpressionList((ExpressionList)itemsList);
                        itemsList = multiExpr;
                    }
                    primaryExpList = new ArrayList<Expression>();
                    primaryExpList.add(exp);
        label_21:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_COMMA:{
            ;
            break;
            }
          default:
            jj_la1[71] = jj_gen;
            break label_21;
          }
          jj_consume_token(K_COMMA);
          exp = SimpleExpression();
primaryExpList.add(exp);
        }
        jj_consume_token(288);
multiExpr.addExpressionList(primaryExpList);
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_SELECT:
      case K_VALUES:
      case K_WITH:
      case 287:{
        if (jj_2_27(2)) {
          jj_consume_token(287);
useSelectBrackets = true;
insert.setUseValues(false);
          select = SelectWithWithItems();
          jj_consume_token(288);
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_SELECT:
          case K_VALUES:
          case K_WITH:
          case 287:{
insert.setUseValues(false);
            select = SelectWithWithItems();
            break;
            }
          default:
            jj_la1[72] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
        }
      case K_SET:{
        jj_consume_token(K_SET);
useSet = true;
                insert.setUseValues(false);
        tableColumn = Column();
        jj_consume_token(289);
        exp = SimpleExpression();
setColumns = new ArrayList<Column>();
                setExpressionList = new ArrayList<Expression>();
                setColumns.add(tableColumn);
                setExpressionList.add(exp);
        label_22:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_COMMA:{
            ;
            break;
            }
          default:
            jj_la1[73] = jj_gen;
            break label_22;
          }
          jj_consume_token(K_COMMA);
          tableColumn = Column();
          jj_consume_token(289);
          exp = SimpleExpression();
setColumns.add(tableColumn);
                setExpressionList.add(exp);
        }
        break;
        }
      default:
        jj_la1[74] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ON:{
      jj_consume_token(K_ON);
      jj_consume_token(K_DUPLICATE);
      jj_consume_token(K_KEY);
      jj_consume_token(K_UPDATE);
useDuplicate = true;
      tableColumn = Column();
      jj_consume_token(289);
      exp = SimpleExpression();
duplicateUpdateColumns = new ArrayList<Column>();
            duplicateUpdateExpressionList = new ArrayList<Expression>();
            duplicateUpdateColumns.add(tableColumn);
            duplicateUpdateExpressionList.add(exp);
      label_23:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[75] = jj_gen;
          break label_23;
        }
        jj_consume_token(K_COMMA);
        tableColumn = Column();
        jj_consume_token(289);
        exp = SimpleExpression();
duplicateUpdateColumns.add(tableColumn);
        duplicateUpdateExpressionList.add(exp);
      }
      break;
      }
    default:
      jj_la1[76] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_RETURNING:{
      jj_consume_token(K_RETURNING);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 290:{
        jj_consume_token(290);
insert.setReturningAllColumns(true);
        break;
        }
      default:
        jj_la1[77] = jj_gen;
        if (jj_2_29(1)) {
          returning = ListExpressionItem();
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[78] = jj_gen;
      ;
    }
if (!columns.isEmpty()) {
            insert.setColumns(columns);
        }
        return insert.withWithItemsList(with)
              .withItemsList(itemsList)
              .withUseSelectBrackets(useSelectBrackets)
              .withSelect(select)
              .withTable(table)
              .withUseDuplicate(useDuplicate)
              .withDuplicateUpdateColumns(duplicateUpdateColumns)
              .withDuplicateUpdateExpressionList(duplicateUpdateExpressionList)
              .withReturningExpressionList(returning)
              .withModifierPriority(modifierPriority)
              .withModifierIgnore(modifierIgnore)
              .withUseSet(useSet)
              .withUseSetColumns(setColumns)
              .withSetExpressionList(setExpressionList);
}

  final public Upsert Upsert() throws ParseException {Upsert upsert = new Upsert();
    Table table = null;
    Column tableColumn = null;
    List<Column> columns = new ArrayList<Column>();
    List<Expression> primaryExpList = new ArrayList<Expression>();
    ItemsList itemsList = null;
    Expression exp = null;
    MultiExpressionList multiExpr = null;
    List<SelectExpressionItem> returning = null;
    Select select = null;
    boolean useSelectBrackets = false;
    boolean useDuplicate = false;
    List<Column> duplicateUpdateColumns = null;
    List<Expression> duplicateUpdateExpressionList = null;
    Token tk = null;
    jj_consume_token(K_UPSERT);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_INTO:{
      jj_consume_token(K_INTO);
      break;
      }
    default:
      jj_la1[79] = jj_gen;
      ;
    }
    table = Table();
    if (jj_2_30(2)) {
      jj_consume_token(287);
      tableColumn = Column();
columns.add(tableColumn);
      label_24:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[80] = jj_gen;
          break label_24;
        }
        jj_consume_token(K_COMMA);
        tableColumn = Column();
columns.add(tableColumn);
      }
      jj_consume_token(288);
    } else {
      ;
    }
    if (jj_2_32(2)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_VALUE:
      case K_VALUES:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_VALUES:{
          jj_consume_token(K_VALUES);
          break;
          }
        case K_VALUE:{
          jj_consume_token(K_VALUE);
          break;
          }
        default:
          jj_la1[81] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[82] = jj_gen;
        ;
      }
      jj_consume_token(287);
      exp = SimpleExpression();
primaryExpList.add(exp);
      label_25:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[83] = jj_gen;
          break label_25;
        }
        jj_consume_token(K_COMMA);
        exp = SimpleExpression();
primaryExpList.add(exp);
      }
      jj_consume_token(288);
itemsList = new ExpressionList(primaryExpList);
      label_26:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[84] = jj_gen;
          break label_26;
        }
        jj_consume_token(K_COMMA);
        jj_consume_token(287);
        exp = SimpleExpression();
if (multiExpr==null) {
                        multiExpr=new MultiExpressionList();
                        multiExpr.addExpressionList((ExpressionList)itemsList);
                        itemsList = multiExpr;
                    }
                    primaryExpList = new ArrayList<Expression>();
                    primaryExpList.add(exp);
        label_27:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_COMMA:{
            ;
            break;
            }
          default:
            jj_la1[85] = jj_gen;
            break label_27;
          }
          jj_consume_token(K_COMMA);
          exp = SimpleExpression();
primaryExpList.add(exp);
        }
        jj_consume_token(288);
multiExpr.addExpressionList(primaryExpList);
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_SELECT:
      case K_VALUES:
      case K_WITH:
      case 287:{
        if (jj_2_31(2)) {
          jj_consume_token(287);
useSelectBrackets = true;
upsert.setUseValues(false);
          select = SelectWithWithItems();
          jj_consume_token(288);
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_SELECT:
          case K_VALUES:
          case K_WITH:
          case 287:{
upsert.setUseValues(false);
            select = SelectWithWithItems();
            break;
            }
          default:
            jj_la1[86] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
        }
      default:
        jj_la1[87] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ON:{
      jj_consume_token(K_ON);
      jj_consume_token(K_DUPLICATE);
      jj_consume_token(K_KEY);
      jj_consume_token(K_UPDATE);
useDuplicate = true;
      tableColumn = Column();
      jj_consume_token(289);
      exp = SimpleExpression();
duplicateUpdateColumns = new ArrayList<Column>();
            duplicateUpdateExpressionList = new ArrayList<Expression>();
            duplicateUpdateColumns.add(tableColumn);
            duplicateUpdateExpressionList.add(exp);
      label_28:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[88] = jj_gen;
          break label_28;
        }
        jj_consume_token(K_COMMA);
        tableColumn = Column();
        jj_consume_token(289);
        exp = SimpleExpression();
duplicateUpdateColumns.add(tableColumn);
        duplicateUpdateExpressionList.add(exp);
      }
      break;
      }
    default:
      jj_la1[89] = jj_gen;
      ;
    }
if (columns.size() > 0) {
            upsert.setColumns(columns);
        }
        return upsert.withItemsList(itemsList)
              .withUseSelectBrackets(useSelectBrackets)
              .withSelect(select)
              .withTable(table)
              .withUseDuplicate(useDuplicate)
              .withDuplicateUpdateColumns(duplicateUpdateColumns)
              .withDuplicateUpdateExpressionList(duplicateUpdateExpressionList);
}

  final public Delete Delete(List<WithItem> with) throws ParseException {Delete delete = new Delete();
    Table table = null;
    List<Table> tables = new ArrayList<Table>();
    Table usingTable = null;
    List<Table> usingList = new ArrayList<Table>();
    List<Join> joins = null;
    Expression where = null;
    Limit limit = null;
    List<OrderByElement> orderByElements;
    boolean hasFrom = false;
    jj_consume_token(K_DELETE);
delete.setOracleHint(getOracleHint());
    if (jj_2_33(4)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ACTION:
      case K_ALGORITHM:
      case K_ALL:
      case K_ANY:
      case K_ARRAY_LITERAL:
      case K_BYTE:
      case K_CASCADE:
      case K_CASE:
      case K_CASEWHEN:
      case K_CAST:
      case K_CHARACTER:
      case K_CHANGE:
      case K_CHAR:
      case K_COLUMN:
      case K_COLUMNS:
      case K_COMMIT:
      case K_COMMENT:
      case K_COSTS:
      case K_CREATE:
      case K_CYCLE:
      case K_DATETIMELITERAL:
      case K_DATE_LITERAL:
      case K_DESC:
      case K_DESCRIBE:
      case K_DISABLE:
      case K_DIV:
      case K_DO:
      case K_DOUBLE:
      case K_DUPLICATE:
      case K_ENABLE:
      case K_END:
      case K_EXCLUDE:
      case K_EXTRACT:
      case K_FIRST:
      case K_FALSE:
      case K_FOLLOWING:
      case K_FORMAT:
      case K_GROUP:
      case K_IF:
      case K_IIF:
      case K_IN:
      case K_INDEX:
      case K_INSERT:
      case K_INTERVAL:
      case K_ISNULL:
      case K_JSON:
      case K_KEY:
      case K_FN:
      case K_LAST:
      case K_LEADING:
      case K_LEFT:
      case K_LIMIT:
      case K_LOCAL:
      case K_MATERIALIZED:
      case K_NEXTVAL:
      case K_NO:
      case K_NOLOCK:
      case K_NULLS:
      case K_OF:
      case K_OFFSET:
      case K_ON:
      case K_OPEN:
      case K_ORDER:
      case K_OVER:
      case K_OPTIMIZE:
      case K_PARALLEL:
      case K_PARTITION:
      case K_PATH:
      case K_PERCENT:
      case K_PRECISION:
      case K_PRIMARY:
      case K_PRIOR:
      case K_PROCEDURE:
      case K_PUBLIC:
      case K_RANGE:
      case K_READ:
      case K_REPLACE:
      case K_RIGHT:
      case K_ROW:
      case K_ROWS:
      case K_SCHEMA:
      case K_SEQUENCE:
      case K_SEPARATOR:
      case K_SESSION:
      case K_SET:
      case K_SIBLINGS:
      case K_SIZE:
      case K_SKIP:
      case K_START:
      case K_SYNONYM:
      case K_TABLE:
      case K_TABLES:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIMEOUT:
      case K_TO:
      case K_TOP:
      case K_TRUNCATE:
      case K_TRUE:
      case K_TYPE:
      case K_SIGNED:
      case K_UNSIGNED:
      case K_VALIDATE:
      case K_VALUE:
      case K_VALUES:
      case K_VIEW:
      case K_XML:
      case K_ZONE:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:{
        table = TableWithAlias();
tables.add(table);
        label_29:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_COMMA:{
            ;
            break;
            }
          default:
            jj_la1[90] = jj_gen;
            break label_29;
          }
          jj_consume_token(K_COMMA);
          table = TableWithAlias();
tables.add(table);
        }
        jj_consume_token(K_FROM);
        break;
        }
      case K_FROM:{
        jj_consume_token(K_FROM);
        break;
        }
      default:
        jj_la1[91] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
hasFrom = true;
    } else {
      ;
    }
    if (jj_2_34(3)) {
      table = TableWithAlias();
      joins = JoinsList();
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_USING:{
      jj_consume_token(K_USING);
      usingTable = TableWithAlias();
usingList.add(usingTable);
      label_30:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[92] = jj_gen;
          break label_30;
        }
        jj_consume_token(K_COMMA);
        usingTable = TableWithAlias();
usingList.add(usingTable);
      }
      break;
      }
    default:
      jj_la1[93] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_WHERE:{
      where = WhereClause();
delete.setWhere(where);
      break;
      }
    default:
      jj_la1[94] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ORDER:{
      orderByElements = OrderByElements();
delete.setOrderByElements(orderByElements);
      break;
      }
    default:
      jj_la1[95] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_LIMIT:{
      limit = PlainLimit();
delete.setLimit(limit);
      break;
      }
    default:
      jj_la1[96] = jj_gen;
      ;
    }
if (joins != null && joins.size() > 0) {
            delete.setJoins(joins);
        }
        return delete.withWithItemsList(with)
              .withTables(tables).withTable(table).withHasFrom(hasFrom).withUsingList(usingList);
}

  final public Statement Merge(List<WithItem> with) throws ParseException {Merge merge = new Merge();
    Table table;
    SubSelect select;
    Alias alias;
    Expression condition;
    MergeUpdate update;
    MergeInsert insert;
    jj_consume_token(K_MERGE);
merge.setOracleHint(getOracleHint());
    jj_consume_token(K_INTO);
    table = TableWithAlias();
merge.setTable(table);
    jj_consume_token(K_USING);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ALGORITHM:
    case K_ALL:
    case K_ANY:
    case K_ARRAY_LITERAL:
    case K_BYTE:
    case K_CASCADE:
    case K_CASE:
    case K_CASEWHEN:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHAR:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_COSTS:
    case K_CREATE:
    case K_CYCLE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DIV:
    case K_DO:
    case K_DOUBLE:
    case K_DUPLICATE:
    case K_ENABLE:
    case K_END:
    case K_EXCLUDE:
    case K_EXTRACT:
    case K_FIRST:
    case K_FALSE:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_GROUP:
    case K_IF:
    case K_IIF:
    case K_IN:
    case K_INDEX:
    case K_INSERT:
    case K_INTERVAL:
    case K_ISNULL:
    case K_JSON:
    case K_KEY:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LEFT:
    case K_LIMIT:
    case K_LOCAL:
    case K_MATERIALIZED:
    case K_NEXTVAL:
    case K_NO:
    case K_NOLOCK:
    case K_NULLS:
    case K_OF:
    case K_OFFSET:
    case K_ON:
    case K_OPEN:
    case K_ORDER:
    case K_OVER:
    case K_OPTIMIZE:
    case K_PARALLEL:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_PROCEDURE:
    case K_PUBLIC:
    case K_RANGE:
    case K_READ:
    case K_REPLACE:
    case K_RIGHT:
    case K_ROW:
    case K_ROWS:
    case K_SCHEMA:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SET:
    case K_SIBLINGS:
    case K_SIZE:
    case K_SKIP:
    case K_START:
    case K_SYNONYM:
    case K_TABLE:
    case K_TABLES:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIMEOUT:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TYPE:
    case K_SIGNED:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VIEW:
    case K_XML:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      table = Table();
merge.setUsingTable(table);
      break;
      }
    case 287:{
      jj_consume_token(287);
      select = SubSelect();
merge.setUsingSelect(select);
      jj_consume_token(288);
      break;
      }
    default:
      jj_la1[97] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ALGORITHM:
    case K_ANY:
    case K_ARRAY_LITERAL:
    case K_AS:
    case K_BYTE:
    case K_CASCADE:
    case K_CASE:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHAR:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_COSTS:
    case K_CYCLE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DIV:
    case K_DO:
    case K_DUPLICATE:
    case K_ENABLE:
    case K_END:
    case K_EXCLUDE:
    case K_EXTRACT:
    case K_FIRST:
    case K_FALSE:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_INDEX:
    case K_INSERT:
    case K_INTERVAL:
    case K_ISNULL:
    case K_JSON:
    case K_KEY:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LOCAL:
    case K_MATERIALIZED:
    case K_NEXTVAL:
    case K_NO:
    case K_NOLOCK:
    case K_NULLS:
    case K_OF:
    case K_OPEN:
    case K_OVER:
    case K_PARALLEL:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_RANGE:
    case K_READ:
    case K_REPLACE:
    case K_ROW:
    case K_ROWS:
    case K_SCHEMA:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SIBLINGS:
    case K_SIZE:
    case K_SKIP:
    case K_SYNONYM:
    case K_TABLE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIMEOUT:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TYPE:
    case K_SIGNED:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VIEW:
    case K_XML:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:{
      alias = Alias();
merge.setUsingAlias(alias);
      break;
      }
    default:
      jj_la1[98] = jj_gen;
      ;
    }
    jj_consume_token(K_ON);
    jj_consume_token(287);
    condition = Expression();
merge.setOnCondition(condition);
    jj_consume_token(288);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_WHEN:{
      if (jj_2_35(2)) {
        update = MergeUpdateClause();
merge.setMergeUpdate(update);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_WHEN:{
          insert = MergeInsertClause();
merge.setMergeInsert(insert);
          break;
          }
        default:
          jj_la1[99] = jj_gen;
          ;
        }
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_WHEN:{
          insert = MergeInsertClause();
merge.withMergeInsert(insert).withInsertFirst(true);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_WHEN:{
            update = MergeUpdateClause();
merge.setMergeUpdate(update);
            break;
            }
          default:
            jj_la1[100] = jj_gen;
            ;
          }
          break;
          }
        default:
          jj_la1[101] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[102] = jj_gen;
      ;
    }
return merge.withWithItemsList(with);
}

  final public MergeUpdate MergeUpdateClause() throws ParseException {MergeUpdate mu = new MergeUpdate();
    List<Column> columns = new ArrayList<Column>();
    List<Expression> expList = new ArrayList<Expression>();
    Column col;
    Expression exp;
    Expression condition;
    jj_consume_token(K_WHEN);
    jj_consume_token(K_MATCHED);
    jj_consume_token(K_THEN);
    jj_consume_token(K_UPDATE);
    jj_consume_token(K_SET);
    col = Column();
    jj_consume_token(289);
    exp = SimpleExpression();
columns.add(col); expList.add(exp);
    label_31:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[103] = jj_gen;
        break label_31;
      }
      jj_consume_token(K_COMMA);
      col = Column();
      jj_consume_token(289);
      exp = SimpleExpression();
columns.add(col); expList.add(exp);
    }
mu.withColumns(columns).withValues(expList);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_WHERE:{
      jj_consume_token(K_WHERE);
      condition = Expression();
mu.setWhereCondition(condition);
      break;
      }
    default:
      jj_la1[104] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_DELETE:{
      jj_consume_token(K_DELETE);
      jj_consume_token(K_WHERE);
      condition = Expression();
mu.setDeleteWhereCondition(condition);
      break;
      }
    default:
      jj_la1[105] = jj_gen;
      ;
    }
return mu;
}

  final public MergeInsert MergeInsertClause() throws ParseException {MergeInsert mi = new MergeInsert();
    List<Column> columns = new ArrayList<Column>();
    List<Expression> expList = new ArrayList<Expression>();
    Column col;
    Expression exp;
    Expression condition;
    jj_consume_token(K_WHEN);
    jj_consume_token(K_NOT);
    jj_consume_token(K_MATCHED);
    jj_consume_token(K_THEN);
    jj_consume_token(K_INSERT);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 287:{
      jj_consume_token(287);
      col = Column();
columns.add(col);
      label_32:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[106] = jj_gen;
          break label_32;
        }
        jj_consume_token(K_COMMA);
        col = Column();
columns.add(col);
      }
      jj_consume_token(288);
      break;
      }
    default:
      jj_la1[107] = jj_gen;
      ;
    }
    jj_consume_token(K_VALUES);
    jj_consume_token(287);
    exp = SimpleExpression();
expList.add(exp);
    label_33:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[108] = jj_gen;
        break label_33;
      }
      jj_consume_token(K_COMMA);
      exp = SimpleExpression();
expList.add(exp);
    }
    jj_consume_token(288);
mi.withColumns(columns).withValues(expList);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_WHERE:{
      jj_consume_token(K_WHERE);
      condition = Expression();
mi.setWhereCondition(condition);
      break;
      }
    default:
      jj_la1[109] = jj_gen;
      ;
    }
return mi;
}

  final public List<String> RelObjectNameList() throws ParseException {String token = null;
    List<String> data = new ArrayList<String>();
    token = RelObjectNameExt();
data.add(token);
    label_34:
    while (true) {
      if (jj_2_36(2)) {
        ;
      } else {
        break label_34;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 291:{
        jj_consume_token(291);
        break;
        }
      case 292:{
        jj_consume_token(292);
        break;
        }
      default:
        jj_la1[110] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_35:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 291:{
          ;
          break;
          }
        default:
          jj_la1[111] = jj_gen;
          break label_35;
        }
        jj_consume_token(291);
data.add(null);
      }
      token = RelObjectNameExt2();
data.add(token);
    }
return data;
}

// See: http://technet.microsoft.com/en-us/library/ms187879%28v=sql.105%29.aspx
  final public 
Column Column() throws ParseException {/*@bgen(jjtree) Column */
    SimpleNode jjtn000 = new SimpleNode(JJTCOLUMN);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));List<String> data = new ArrayList<String>();
    try {
      data = RelObjectNameList();
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
Column col = new Column(data);
        linkAST(col,jjtn000);
        return col;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

/*
Not all names should be allowed for aliases.
*/
  final public String RelObjectNameWithoutValue() throws ParseException {Token tk = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_IDENTIFIER:{
      tk = jj_consume_token(S_IDENTIFIER);
      break;
      }
    case S_QUOTED_IDENTIFIER:{
      tk = jj_consume_token(S_QUOTED_IDENTIFIER);
      break;
      }
    case K_ALGORITHM:{
      tk = jj_consume_token(K_ALGORITHM);
      break;
      }
    case K_BYTE:{
      tk = jj_consume_token(K_BYTE);
      break;
      }
    case K_CHAR:{
      tk = jj_consume_token(K_CHAR);
      break;
      }
    case K_CHANGE:{
      tk = jj_consume_token(K_CHANGE);
      break;
      }
    case K_CHARACTER:{
      tk = jj_consume_token(K_CHARACTER);
      break;
      }
    case K_CAST:{
      tk = jj_consume_token(K_CAST);
      break;
      }
    case K_COMMENT:{
      tk = jj_consume_token(K_COMMENT);
      break;
      }
    case K_COSTS:{
      tk = jj_consume_token(K_COSTS);
      break;
      }
    case K_DISABLE:{
      tk = jj_consume_token(K_DISABLE);
      break;
      }
    case K_DESC:{
      tk = jj_consume_token(K_DESC);
      break;
      }
    case K_DO:{
      tk = jj_consume_token(K_DO);
      break;
      }
    case K_EXTRACT:{
      tk = jj_consume_token(K_EXTRACT);
      break;
      }
    case K_FIRST:{
      tk = jj_consume_token(K_FIRST);
      break;
      }
    case K_FOLLOWING:{
      tk = jj_consume_token(K_FOLLOWING);
      break;
      }
    case K_JSON:{
      tk = jj_consume_token(K_JSON);
      break;
      }
    case K_LAST:{
      tk = jj_consume_token(K_LAST);
      break;
      }
    case K_LEADING:{
      tk = jj_consume_token(K_LEADING);
      break;
      }
    case K_MATERIALIZED:{
      tk = jj_consume_token(K_MATERIALIZED);
      break;
      }
    case K_NULLS:{
      tk = jj_consume_token(K_NULLS);
      break;
      }
    case K_PARTITION:{
      tk = jj_consume_token(K_PARTITION);
      break;
      }
    case K_RANGE:{
      tk = jj_consume_token(K_RANGE);
      break;
      }
    case K_ROW:{
      tk = jj_consume_token(K_ROW);
      break;
      }
    case K_ROWS:{
      tk = jj_consume_token(K_ROWS);
      break;
      }
    case K_SIBLINGS:{
      tk = jj_consume_token(K_SIBLINGS);
      break;
      }
    case K_XML:{
      tk = jj_consume_token(K_XML);
      break;
      }
    case K_COLUMN:{
      tk = jj_consume_token(K_COLUMN);
      break;
      }
    case K_REPLACE:{
      tk = jj_consume_token(K_REPLACE);
      break;
      }
    case K_TRUNCATE:{
      tk = jj_consume_token(K_TRUNCATE);
      break;
      }
    case K_KEY:{
      tk = jj_consume_token(K_KEY);
      break;
      }
    case K_ANY:{
      tk = jj_consume_token(K_ANY);
      break;
      }
    case K_OPEN:{
      tk = jj_consume_token(K_OPEN);
      break;
      }
    case K_OVER:{
      tk = jj_consume_token(K_OVER);
      break;
      }
    case K_PERCENT:{
      tk = jj_consume_token(K_PERCENT);
      break;
      }
    case K_PRIOR:{
      tk = jj_consume_token(K_PRIOR);
      break;
      }
    case K_SEPARATOR:{
      tk = jj_consume_token(K_SEPARATOR);
      break;
      }
    case K_NO:{
      tk = jj_consume_token(K_NO);
      break;
      }
    case K_ACTION:{
      tk = jj_consume_token(K_ACTION);
      break;
      }
    case K_CASCADE:{
      tk = jj_consume_token(K_CASCADE);
      break;
      }
    case K_END:{
      tk = jj_consume_token(K_END);
      break;
      }
    case K_TABLE:{
      tk = jj_consume_token(K_TABLE);
      break;
      }
    case K_DATETIMELITERAL:{
      tk = jj_consume_token(K_DATETIMELITERAL);
      break;
      }
    case K_COMMIT:{
      tk = jj_consume_token(K_COMMIT);
      break;
      }
    case K_PRECISION:{
      tk = jj_consume_token(K_PRECISION);
      break;
      }
    case K_INSERT:{
      tk = jj_consume_token(K_INSERT);
      break;
      }
    case K_INDEX:{
      tk = jj_consume_token(K_INDEX);
      break;
      }
    case K_PRIMARY:{
      tk = jj_consume_token(K_PRIMARY);
      break;
      }
    case K_ENABLE:{
      tk = jj_consume_token(K_ENABLE);
      break;
      }
    case K_TEMP:{
      tk = jj_consume_token(K_TEMP);
      break;
      }
    case K_TEMPORARY:{
      tk = jj_consume_token(K_TEMPORARY);
      break;
      }
    case K_TO:{
      tk = jj_consume_token(K_TO);
      break;
      }
    case K_TYPE:{
      tk = jj_consume_token(K_TYPE);
      break;
      }
    case K_ISNULL:{
      tk = jj_consume_token(K_ISNULL);
      break;
      }
    case K_ZONE:{
      tk = jj_consume_token(K_ZONE);
      break;
      }
    case K_COLUMNS:{
      tk = jj_consume_token(K_COLUMNS);
      break;
      }
    case K_DESCRIBE:{
      tk = jj_consume_token(K_DESCRIBE);
      break;
      }
    case K_FN:{
      tk = jj_consume_token(K_FN);
      break;
      }
    case K_PATH:{
      tk = jj_consume_token(K_PATH);
      break;
      }
    case K_DATE_LITERAL:{
      tk = jj_consume_token(K_DATE_LITERAL);
      break;
      }
    case K_NEXTVAL:{
      tk = jj_consume_token(K_NEXTVAL);
      break;
      }
    case K_TRUE:{
      tk = jj_consume_token(K_TRUE);
      break;
      }
    case K_FALSE:{
      tk = jj_consume_token(K_FALSE);
      break;
      }
    case K_DUPLICATE:{
      tk = jj_consume_token(K_DUPLICATE);
      break;
      }
    case K_READ:{
      tk = jj_consume_token(K_READ);
      break;
      }
    case K_SCHEMA:{
      tk = jj_consume_token(K_SCHEMA);
      break;
      }
    case K_SIGNED:{
      tk = jj_consume_token(K_SIGNED);
      break;
      }
    case K_SIZE:{
      tk = jj_consume_token(K_SIZE);
      break;
      }
    case K_SEQUENCE:{
      tk = jj_consume_token(K_SEQUENCE);
      break;
      }
    case K_SESSION:{
      tk = jj_consume_token(K_SESSION);
      break;
      }
    case K_SKIP:{
      tk = jj_consume_token(K_SKIP);
      break;
      }
    case K_SYNONYM:{
      tk = jj_consume_token(K_SYNONYM);
      break;
      }
    case K_VIEW:{
      tk = jj_consume_token(K_VIEW);
      break;
      }
    case K_NOLOCK:{
      tk = jj_consume_token(K_NOLOCK);
      break;
      }
    case K_VALIDATE:{
      tk = jj_consume_token(K_VALIDATE);
      break;
      }
    case K_CYCLE:{
      tk = jj_consume_token(K_CYCLE);
      break;
      }
    case K_OF:{
      tk = jj_consume_token(K_OF);
      break;
      }
    case K_EXCLUDE:{
      tk = jj_consume_token(K_EXCLUDE);
      break;
      }
    case K_FORMAT:{
      tk = jj_consume_token(K_FORMAT);
      break;
      }
    case K_DIV:{
      tk = jj_consume_token(K_DIV);
      break;
      }
    case K_UNSIGNED:{
      tk = jj_consume_token(K_UNSIGNED);
      break;
      }
    case K_CASE:{
      tk = jj_consume_token(K_CASE);
      break;
      }
    case K_LOCAL:{
      tk = jj_consume_token(K_LOCAL);
      break;
      }
    case K_ARRAY_LITERAL:{
      tk = jj_consume_token(K_ARRAY_LITERAL);
      break;
      }
    case K_TIMEOUT:{
      tk = jj_consume_token(K_TIMEOUT);
      break;
      }
    case K_PARALLEL:{
      tk = jj_consume_token(K_PARALLEL);
      break;
      }
    default:
      jj_la1[112] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return tk.image;
}

/*
Normal names.
*/
  final public String RelObjectName() throws ParseException {Token tk = null; String result = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ALGORITHM:
    case K_ANY:
    case K_ARRAY_LITERAL:
    case K_BYTE:
    case K_CASCADE:
    case K_CASE:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHAR:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_COSTS:
    case K_CYCLE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DIV:
    case K_DO:
    case K_DUPLICATE:
    case K_ENABLE:
    case K_END:
    case K_EXCLUDE:
    case K_EXTRACT:
    case K_FIRST:
    case K_FALSE:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_INDEX:
    case K_INSERT:
    case K_ISNULL:
    case K_JSON:
    case K_KEY:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LOCAL:
    case K_MATERIALIZED:
    case K_NEXTVAL:
    case K_NO:
    case K_NOLOCK:
    case K_NULLS:
    case K_OF:
    case K_OPEN:
    case K_OVER:
    case K_PARALLEL:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_RANGE:
    case K_READ:
    case K_REPLACE:
    case K_ROW:
    case K_ROWS:
    case K_SCHEMA:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SIBLINGS:
    case K_SIZE:
    case K_SKIP:
    case K_SYNONYM:
    case K_TABLE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIMEOUT:
    case K_TO:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TYPE:
    case K_SIGNED:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VIEW:
    case K_XML:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      result = RelObjectNameWithoutValue();
      break;
      }
    case K_GROUP:{
      tk = jj_consume_token(K_GROUP);
      break;
      }
    case K_INTERVAL:{
      tk = jj_consume_token(K_INTERVAL);
      break;
      }
    case K_ON:{
      tk = jj_consume_token(K_ON);
      break;
      }
    case K_ORDER:{
      tk = jj_consume_token(K_ORDER);
      break;
      }
    case K_START:{
      tk = jj_consume_token(K_START);
      break;
      }
    case K_TOP:{
      tk = jj_consume_token(K_TOP);
      break;
      }
    case K_VALUE:{
      tk = jj_consume_token(K_VALUE);
      break;
      }
    case K_VALUES:{
      tk = jj_consume_token(K_VALUES);
      break;
      }
    case K_CREATE:{
      tk = jj_consume_token(K_CREATE);
      break;
      }
    case K_TABLES:{
      tk = jj_consume_token(K_TABLES);
      break;
      }
    default:
      jj_la1[113] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if (tk!=null) result=tk.image;
                return result;
}

  final public String RelObjectNameWithoutStart() throws ParseException {Token tk = null; String result = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ALGORITHM:
    case K_ANY:
    case K_ARRAY_LITERAL:
    case K_BYTE:
    case K_CASCADE:
    case K_CASE:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHAR:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_COSTS:
    case K_CYCLE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DIV:
    case K_DO:
    case K_DUPLICATE:
    case K_ENABLE:
    case K_END:
    case K_EXCLUDE:
    case K_EXTRACT:
    case K_FIRST:
    case K_FALSE:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_INDEX:
    case K_INSERT:
    case K_ISNULL:
    case K_JSON:
    case K_KEY:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LOCAL:
    case K_MATERIALIZED:
    case K_NEXTVAL:
    case K_NO:
    case K_NOLOCK:
    case K_NULLS:
    case K_OF:
    case K_OPEN:
    case K_OVER:
    case K_PARALLEL:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_RANGE:
    case K_READ:
    case K_REPLACE:
    case K_ROW:
    case K_ROWS:
    case K_SCHEMA:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SIBLINGS:
    case K_SIZE:
    case K_SKIP:
    case K_SYNONYM:
    case K_TABLE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIMEOUT:
    case K_TO:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TYPE:
    case K_SIGNED:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VIEW:
    case K_XML:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      result = RelObjectNameWithoutValue();
      break;
      }
    case K_TOP:{
      tk = jj_consume_token(K_TOP);
      break;
      }
    case K_VALUE:{
      tk = jj_consume_token(K_VALUE);
      break;
      }
    case K_VALUES:{
      tk = jj_consume_token(K_VALUES);
      break;
      }
    case K_INTERVAL:{
      tk = jj_consume_token(K_INTERVAL);
      break;
      }
    default:
      jj_la1[114] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if (tk!=null) result=tk.image;
                return result;
}

/*
Extended version of object names.
*/
  final public String RelObjectNameExt() throws ParseException {Token tk = null;
  String result=null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ALGORITHM:
    case K_ANY:
    case K_ARRAY_LITERAL:
    case K_BYTE:
    case K_CASCADE:
    case K_CASE:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHAR:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_COSTS:
    case K_CREATE:
    case K_CYCLE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DIV:
    case K_DO:
    case K_DUPLICATE:
    case K_ENABLE:
    case K_END:
    case K_EXCLUDE:
    case K_EXTRACT:
    case K_FIRST:
    case K_FALSE:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_GROUP:
    case K_INDEX:
    case K_INSERT:
    case K_INTERVAL:
    case K_ISNULL:
    case K_JSON:
    case K_KEY:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LOCAL:
    case K_MATERIALIZED:
    case K_NEXTVAL:
    case K_NO:
    case K_NOLOCK:
    case K_NULLS:
    case K_OF:
    case K_ON:
    case K_OPEN:
    case K_ORDER:
    case K_OVER:
    case K_PARALLEL:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_RANGE:
    case K_READ:
    case K_REPLACE:
    case K_ROW:
    case K_ROWS:
    case K_SCHEMA:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SIBLINGS:
    case K_SIZE:
    case K_SKIP:
    case K_START:
    case K_SYNONYM:
    case K_TABLE:
    case K_TABLES:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIMEOUT:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TYPE:
    case K_SIGNED:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VIEW:
    case K_XML:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      result = RelObjectName();
      break;
      }
    case K_ALL:{
      tk = jj_consume_token(K_ALL);
      break;
      }
    case K_LEFT:{
      tk = jj_consume_token(K_LEFT);
      break;
      }
    case K_RIGHT:{
      tk = jj_consume_token(K_RIGHT);
      break;
      }
    case K_SET:{
      tk = jj_consume_token(K_SET);
      break;
      }
    case K_DOUBLE:{
      tk = jj_consume_token(K_DOUBLE);
      break;
      }
    case K_IF:{
      tk = jj_consume_token(K_IF);
      break;
      }
    case K_IIF:{
      tk = jj_consume_token(K_IIF);
      break;
      }
    case K_OPTIMIZE:{
      tk = jj_consume_token(K_OPTIMIZE);
      break;
      }
    case K_LIMIT:{
      tk = jj_consume_token(K_LIMIT);
      break;
      }
    case K_OFFSET:{
      tk = jj_consume_token(K_OFFSET);
      break;
      }
    case K_PROCEDURE:{
      tk = jj_consume_token(K_PROCEDURE);
      break;
      }
    case K_PUBLIC:{
      tk = jj_consume_token(K_PUBLIC);
      break;
      }
    case K_CASEWHEN:{
      tk = jj_consume_token(K_CASEWHEN);
      break;
      }
    case K_IN:{
      tk = jj_consume_token(K_IN);
      break;
      }
    default:
      jj_la1[115] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if (tk!=null) result=tk.image;
        return result;
}

/*
Extended usage of object names - part 2. Using within multipart names as following parts.
*/
  final public String RelObjectNameExt2() throws ParseException {Token tk = null;
  String result=null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ALGORITHM:
    case K_ALL:
    case K_ANY:
    case K_ARRAY_LITERAL:
    case K_BYTE:
    case K_CASCADE:
    case K_CASE:
    case K_CASEWHEN:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHAR:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_COSTS:
    case K_CREATE:
    case K_CYCLE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DIV:
    case K_DO:
    case K_DOUBLE:
    case K_DUPLICATE:
    case K_ENABLE:
    case K_END:
    case K_EXCLUDE:
    case K_EXTRACT:
    case K_FIRST:
    case K_FALSE:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_GROUP:
    case K_IF:
    case K_IIF:
    case K_IN:
    case K_INDEX:
    case K_INSERT:
    case K_INTERVAL:
    case K_ISNULL:
    case K_JSON:
    case K_KEY:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LEFT:
    case K_LIMIT:
    case K_LOCAL:
    case K_MATERIALIZED:
    case K_NEXTVAL:
    case K_NO:
    case K_NOLOCK:
    case K_NULLS:
    case K_OF:
    case K_OFFSET:
    case K_ON:
    case K_OPEN:
    case K_ORDER:
    case K_OVER:
    case K_OPTIMIZE:
    case K_PARALLEL:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_PROCEDURE:
    case K_PUBLIC:
    case K_RANGE:
    case K_READ:
    case K_REPLACE:
    case K_RIGHT:
    case K_ROW:
    case K_ROWS:
    case K_SCHEMA:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SET:
    case K_SIBLINGS:
    case K_SIZE:
    case K_SKIP:
    case K_START:
    case K_SYNONYM:
    case K_TABLE:
    case K_TABLES:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIMEOUT:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TYPE:
    case K_SIGNED:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VIEW:
    case K_XML:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      result = RelObjectNameExt();
      break;
      }
    case K_FROM:{
      tk = jj_consume_token(K_FROM);
      break;
      }
    case K_SELECT:{
      tk = jj_consume_token(K_SELECT);
      break;
      }
    case K_CURRENT:{
      tk = jj_consume_token(K_CURRENT);
      break;
      }
    default:
      jj_la1[116] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if (tk!=null) result=tk.image;
        return result;
}

  final public Table Table() throws ParseException {/*@bgen(jjtree) Table */
    SimpleNode jjtn000 = new SimpleNode(JJTTABLE);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));//String serverName = null, databaseName = null, schemaName = null, tableName = null;
    List<String> data = new ArrayList<String>();
    try {
      data = RelObjectNameList();
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
Table table = new Table(data);
                linkAST(table,jjtn000);
        return table;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Table TableWithAlias() throws ParseException {Table table = null;
    Alias alias = null;
    table = Table();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ALGORITHM:
    case K_ANY:
    case K_ARRAY_LITERAL:
    case K_AS:
    case K_BYTE:
    case K_CASCADE:
    case K_CASE:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHAR:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_COSTS:
    case K_CYCLE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DIV:
    case K_DO:
    case K_DUPLICATE:
    case K_ENABLE:
    case K_END:
    case K_EXCLUDE:
    case K_EXTRACT:
    case K_FIRST:
    case K_FALSE:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_INDEX:
    case K_INSERT:
    case K_INTERVAL:
    case K_ISNULL:
    case K_JSON:
    case K_KEY:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LOCAL:
    case K_MATERIALIZED:
    case K_NEXTVAL:
    case K_NO:
    case K_NOLOCK:
    case K_NULLS:
    case K_OF:
    case K_OPEN:
    case K_OVER:
    case K_PARALLEL:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_RANGE:
    case K_READ:
    case K_REPLACE:
    case K_ROW:
    case K_ROWS:
    case K_SCHEMA:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SIBLINGS:
    case K_SIZE:
    case K_SKIP:
    case K_SYNONYM:
    case K_TABLE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIMEOUT:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TYPE:
    case K_SIGNED:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VIEW:
    case K_XML:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:{
      alias = Alias();
table.setAlias(alias);
      break;
      }
    default:
      jj_la1[117] = jj_gen;
      ;
    }
return table;
}

  final public Select SelectWithWithItems() throws ParseException {Select select;
    List<WithItem> with = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_WITH:{
      with = WithList();

      break;
      }
    default:
      jj_la1[118] = jj_gen;
      ;
    }
    select = Select(with);
return select;
}

  final public Select Select(List<WithItem> with) throws ParseException {Select select = new Select();
    SelectBody selectBody = null;
    selectBody = SelectBody();
return select.withWithItemsList(with).withSelectBody(selectBody);
}

  final public SelectBody SelectBody() throws ParseException {SelectBody selectBody = null;
    selectBody = SetOperationList();
return selectBody;
}

  final public PlainSelect PlainSelect() throws ParseException {/*@bgen(jjtree) PlainSelect */
    SimpleNode jjtn000 = new SimpleNode(JJTPLAINSELECT);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));PlainSelect plainSelect = new PlainSelect();
    List<SelectItem> selectItems = null;
    FromItem fromItem = null;
    List<Join> joins = null;
    List<SelectItem> distinctOn = null;
    Expression where = null;
    List<OrderByElement> orderByElements;
    GroupByElement groupBy = null;
    Expression having = null;
    Limit limit = null;
    Offset offset = null;
    Fetch fetch = null;
    OptimizeFor optimize = null;
    Top top = null;
        Skip skip = null;
        First first = null;
    OracleHierarchicalExpression oracleHierarchicalQueryClause = null;
    List<Table> intoTables = null;
    Table updateTable = null;
    Wait wait = null;
    boolean mySqlSqlCalcFoundRows = false;
    Token token;
    KSQLWindow ksqlWindow = null;
    boolean noWait = false;
    try {
      jj_consume_token(K_SELECT);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_STRAIGHT:{
        jj_consume_token(K_STRAIGHT);
plainSelect.setMySqlHintStraightJoin(true);
        break;
        }
      default:
        jj_la1[119] = jj_gen;
        ;
      }
plainSelect.setOracleHint(getOracleHint());
      if (jj_2_37(2)) {
        skip = Skip();
plainSelect.setSkip(skip);
      } else {
        ;
      }
      if (jj_2_38(2)) {
        first = First();
plainSelect.setFirst(first);
      } else {
        ;
      }
      if (jj_2_40(2)) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ALL:{
          jj_consume_token(K_ALL);
          break;
          }
        case K_DISTINCT:{
          jj_consume_token(K_DISTINCT);
Distinct distinct = new Distinct(); plainSelect.setDistinct(distinct);
          if (jj_2_39(2)) {
            jj_consume_token(K_ON);
            jj_consume_token(287);
            distinctOn = SelectItemsList();
plainSelect.getDistinct().setOnSelectItems(distinctOn);
            jj_consume_token(288);
          } else {
            ;
          }
          break;
          }
        case K_UNIQUE:{
          jj_consume_token(K_UNIQUE);
Distinct distinct = new Distinct(true); plainSelect.setDistinct(distinct);
          break;
          }
        case K_SQL_CALC_FOUND_ROWS:{
          jj_consume_token(K_SQL_CALC_FOUND_ROWS);
plainSelect.setMySqlSqlCalcFoundRows(true);
          break;
          }
        case K_SQL_NO_CACHE:{
          jj_consume_token(K_SQL_NO_CACHE);
plainSelect.setMySqlSqlNoCache(true);
          break;
          }
        default:
          jj_la1[120] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else {
        ;
      }
      if (jj_2_41(2)) {
        top = Top();
plainSelect.setTop(top);
      } else {
        ;
      }
      selectItems = SelectItemsList();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_INTO:{
        intoTables = IntoClause();
plainSelect.setIntoTables(intoTables);
        break;
        }
      default:
        jj_la1[121] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_FROM:{
        jj_consume_token(K_FROM);
        fromItem = FromItem();
        joins = JoinsList();
        break;
        }
      default:
        jj_la1[122] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_WINDOW:{
        ksqlWindow = KSQLWindowClause();
plainSelect.setKsqlWindow(ksqlWindow);
        break;
        }
      default:
        jj_la1[123] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_WHERE:{
        where = WhereClause();
plainSelect.setWhere(where);
        break;
        }
      default:
        jj_la1[124] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_CONNECT:
      case K_START:{
        oracleHierarchicalQueryClause = OracleHierarchicalQueryClause();
plainSelect.setOracleHierarchical(oracleHierarchicalQueryClause);
        break;
        }
      default:
        jj_la1[125] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_GROUP:{
        groupBy = GroupByColumnReferences();
plainSelect.setGroupByElement(groupBy);
        break;
        }
      default:
        jj_la1[126] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_HAVING:{
        having = Having();
plainSelect.setHaving(having);
        break;
        }
      default:
        jj_la1[127] = jj_gen;
        ;
      }
      if (jj_2_42(2147483647)) {
        orderByElements = OrderByElements();
plainSelect.setOracleSiblings(true); plainSelect.setOrderByElements(orderByElements);
      } else {
        ;
      }
      if (jj_2_43(2147483647)) {
        orderByElements = OrderByElements();
plainSelect.setOrderByElements(orderByElements);
      } else {
        ;
      }
      if (jj_2_44(2147483647)) {
        limit = LimitWithOffset();
plainSelect.setLimit(limit);
      } else {
        ;
      }
      if (jj_2_45(2147483647)) {
        offset = Offset();
plainSelect.setOffset(offset);
      } else {
        ;
      }
      if (jj_2_46(2147483647) && (limit==null)) {
        limit = LimitWithOffset();
plainSelect.setLimit(limit);
      } else {
        ;
      }
      if (jj_2_47(2147483647)) {
        fetch = Fetch();
plainSelect.setFetch(fetch);
      } else {
        ;
      }
      if (jj_2_49(2)) {
        jj_consume_token(K_FOR);
        jj_consume_token(K_UPDATE);
plainSelect.setForUpdate(true);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_OF:{
          jj_consume_token(K_OF);
          updateTable = Table();
plainSelect.setForUpdateTable(updateTable);
          break;
          }
        default:
          jj_la1[128] = jj_gen;
          ;
        }
        if (jj_2_48(2147483647)) {
          wait = Wait();
plainSelect.setWait(wait);
        } else {
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_NOWAIT:{
          jj_consume_token(K_NOWAIT);
plainSelect.setNoWait(true);
          break;
          }
        default:
          jj_la1[129] = jj_gen;
          ;
        }
      } else {
        ;
      }
      if (jj_2_50(2147483647)) {
        optimize = OptimizeFor();
plainSelect.setOptimizeFor(optimize);
      } else {
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_FOR:{
        jj_consume_token(K_FOR);
        jj_consume_token(K_XML);
        jj_consume_token(K_PATH);
        jj_consume_token(287);
        token = jj_consume_token(S_CHAR_LITERAL);
        jj_consume_token(288);
plainSelect.setForXmlPath(token.image);
        break;
        }
      default:
        jj_la1[130] = jj_gen;
        ;
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
plainSelect.setSelectItems(selectItems);
        plainSelect.setFromItem(fromItem);
        if (joins != null && joins.size() > 0)
            plainSelect.setJoins(joins);
        linkAST(plainSelect,jjtn000);
        return plainSelect;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public SelectBody SetOperationList() throws ParseException {/*@bgen(jjtree) SetOperationList */
    SimpleNode jjtn000 = new SimpleNode(JJTSETOPERATIONLIST);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));SetOperationList list = new SetOperationList();
    List<OrderByElement> orderByElements = null;
    Limit limit = null;
    Offset offset = null;
    Fetch fetch = null;
    SelectBody select = null;
    List<SelectBody> selects = new ArrayList<SelectBody>();
    List<SetOperation> operations = new ArrayList<SetOperation>();
    List<Boolean> brackets = new ArrayList<Boolean>();
    boolean bracket = false;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 287:{
        jj_consume_token(287);
        select = SelectBody();
        jj_consume_token(288);
bracket=true;
        break;
        }
      case K_SELECT:
      case K_VALUES:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_SELECT:{
          select = PlainSelect();
          break;
          }
        case K_VALUES:{
          select = Values();
          break;
          }
        default:
          jj_la1[131] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
bracket=false;
        break;
        }
      default:
        jj_la1[132] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
selects.add(select);brackets.add(bracket);
      label_36:
      while (true) {
        if (jj_2_51(2)) {
          ;
        } else {
          break label_36;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_UNION:{
          jj_consume_token(K_UNION);
UnionOp union = new UnionOp();linkAST(union,jjtn000);operations.add(union);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ALL:
          case K_DISTINCT:{
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_ALL:{
              jj_consume_token(K_ALL);
union.setAll(true);
              break;
              }
            case K_DISTINCT:{
              jj_consume_token(K_DISTINCT);
union.setDistinct(true);
              break;
              }
            default:
              jj_la1[133] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            break;
            }
          default:
            jj_la1[134] = jj_gen;
            ;
          }
          break;
          }
        case K_INTERSECT:{
          jj_consume_token(K_INTERSECT);
operations.add(new IntersectOp());
          break;
          }
        case K_MINUS:{
          jj_consume_token(K_MINUS);
operations.add(new MinusOp());
          break;
          }
        case K_EXCEPT:{
          jj_consume_token(K_EXCEPT);
operations.add(new ExceptOp());
          break;
          }
        default:
          jj_la1[135] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 287:{
          jj_consume_token(287);
          select = SelectBody();
          jj_consume_token(288);
bracket=true;
          break;
          }
        case K_SELECT:
        case K_VALUES:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_SELECT:{
            select = PlainSelect();
            break;
            }
          case K_VALUES:{
            select = Values();
            break;
            }
          default:
            jj_la1[136] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
bracket=false;
          break;
          }
        default:
          jj_la1[137] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
selects.add(select);brackets.add(bracket);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ORDER:{
        orderByElements = OrderByElements();
list.setOrderByElements(orderByElements);
        break;
        }
      default:
        jj_la1[138] = jj_gen;
        ;
      }
      if (jj_2_52(2147483647)) {
        limit = LimitWithOffset();
list.setLimit(limit);
      } else {
        ;
      }
      if (jj_2_53(2147483647)) {
        offset = Offset();
list.setOffset(offset);
      } else {
        ;
      }
      if (jj_2_54(2147483647)) {
        fetch = Fetch();
list.setFetch(fetch);
      } else {
        ;
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
if (selects.size()==1 && selects.get(0) instanceof PlainSelect && orderByElements==null) {
            if (brackets.get(0))
                ((PlainSelect)selects.get(0)).setUseBrackets(true);
            return selects.get(0);
        } else {
            if (selects.size()>1 && selects.get(selects.size()-1) instanceof PlainSelect) {
                PlainSelect ps = (PlainSelect)selects.get(selects.size()-1);
                if (ps.getOrderByElements() != null && !brackets.get(brackets.size() - 1)) {
                    list.setOrderByElements(ps.getOrderByElements());
                    list.setLimit(ps.getLimit());
                    list.setOffset(ps.getOffset());
                    ps.setOrderByElements(null);
                    ps.setLimit(null);
                    ps.setOffset(null);
                }
            }
            list.setBracketsOpsAndSelects(brackets,selects,operations);
            return list;
        }
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public SelectBody SetOperationListWithoutIntialSelect(FromItem fromItem) throws ParseException {/*@bgen(jjtree) SetOperationList */
    SimpleNode jjtn000 = new SimpleNode(JJTSETOPERATIONLIST);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));SetOperationList list = new SetOperationList();
    List<OrderByElement> orderByElements = null;
    Limit limit = null;
    Offset offset = null;
    Fetch fetch = null;
    SelectBody select;
    List<SelectBody> selects = new ArrayList<SelectBody>();
    List<SetOperation> operations = new ArrayList<SetOperation>();
    List<Boolean> brackets = new ArrayList<Boolean>();
    boolean bracket = false;
    try {
while (fromItem instanceof ParenthesisFromItem) {
            fromItem = ((ParenthesisFromItem)fromItem).getFromItem();
        }

        if (fromItem instanceof SubSelect) {
            select = ((SubSelect)fromItem).getSelectBody();
        } else {
            {if (true) throw new IllegalArgumentException("this type of set operation is not allowed");}
        }

        selects.add(select);
        brackets.add(true);
      label_37:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_UNION:{
          jj_consume_token(K_UNION);
UnionOp union = new UnionOp();linkAST(union,jjtn000);operations.add(union);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ALL:
          case K_DISTINCT:{
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_ALL:{
              jj_consume_token(K_ALL);
union.setAll(true);
              break;
              }
            case K_DISTINCT:{
              jj_consume_token(K_DISTINCT);
union.setDistinct(true);
              break;
              }
            default:
              jj_la1[139] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            break;
            }
          default:
            jj_la1[140] = jj_gen;
            ;
          }
          break;
          }
        case K_INTERSECT:{
          jj_consume_token(K_INTERSECT);
operations.add(new IntersectOp());
          break;
          }
        case K_MINUS:{
          jj_consume_token(K_MINUS);
operations.add(new MinusOp());
          break;
          }
        case K_EXCEPT:{
          jj_consume_token(K_EXCEPT);
operations.add(new ExceptOp());
          break;
          }
        default:
          jj_la1[141] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(287);
        select = SelectBody();
        jj_consume_token(288);
bracket=true;
selects.add(select);brackets.add(bracket);
        if (jj_2_55(2)) {
          ;
        } else {
          break label_37;
        }
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
list.setBracketsOpsAndSelects(brackets,selects,operations);
        return list;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public List<WithItem> WithList() throws ParseException {List<WithItem> withItemsList = new ArrayList<WithItem>();
    WithItem with = null;
    jj_consume_token(K_WITH);
    with = WithItem();
withItemsList.add(with);
    label_38:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[142] = jj_gen;
        break label_38;
      }
      jj_consume_token(K_COMMA);
      with = WithItem();
withItemsList.add(with);
    }
return withItemsList;
}

  final public WithItem WithItem() throws ParseException {/*@bgen(jjtree) WithItem */
    SimpleNode jjtn000 = new SimpleNode(JJTWITHITEM);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));WithItem with = new WithItem();
    String name = null;
    List<SelectItem> selectItems = null;
    SubSelect select = null;

    ExpressionList simpleExpressionList;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_RECURSIVE:{
        jj_consume_token(K_RECURSIVE);
with.setRecursive(true);
        break;
        }
      default:
        jj_la1[143] = jj_gen;
        ;
      }
      name = RelObjectName();
with.setName(name);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 287:{
        jj_consume_token(287);
        selectItems = SelectItemsList();
        jj_consume_token(288);
with.setWithItemList(selectItems);
        break;
        }
      default:
        jj_la1[144] = jj_gen;
        ;
      }
      jj_consume_token(K_AS);
      if (jj_2_56(2147483647)) {
        jj_consume_token(287);
        jj_consume_token(K_VALUES);
        simpleExpressionList = SimpleExpressionList(true);
with.withUseBracketsForValues(false).setItemsList(simpleExpressionList);
        jj_consume_token(288);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 287:{
          jj_consume_token(287);
          select = SubSelect();
with.setSubSelect(select.withUseBrackets(false)); with.setUseValues(false);
          jj_consume_token(288);
          break;
          }
        default:
          jj_la1[145] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
jjtree.closeNodeScope(jjtn000, true);
       jjtc000 = false;
       jjtn000.jjtSetLastToken(getToken(0));
return with;
    } catch (Throwable jjte000) {
if (jjtc000) {
         jjtree.clearNodeScope(jjtn000);
         jjtc000 = false;
       } else {
         jjtree.popNode();
       }
       if (jjte000 instanceof RuntimeException) {
         {if (true) throw (RuntimeException)jjte000;}
       }
       if (jjte000 instanceof ParseException) {
         {if (true) throw (ParseException)jjte000;}
       }
       {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
         jjtree.closeNodeScope(jjtn000, true);
         jjtn000.jjtSetLastToken(getToken(0));
       }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public List<SelectItem> SelectItemsList() throws ParseException {List<SelectItem> selectItemsList = new ArrayList<SelectItem>();
    SelectItem selectItem = null;
    selectItem = SelectItem();
selectItemsList.add(selectItem);
    label_39:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[146] = jj_gen;
        break label_39;
      }
      jj_consume_token(K_COMMA);
      selectItem = SelectItem();
selectItemsList.add(selectItem);
    }
return selectItemsList;
}

  final public SelectExpressionItem SelectExpressionItem() throws ParseException {SelectExpressionItem selectExpressionItem = null;
    Expression expression = null;
    Alias alias = null;
    expression = Condition();
selectExpressionItem = new SelectExpressionItem(); selectExpressionItem.setExpression(expression);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ALGORITHM:
    case K_ANY:
    case K_ARRAY_LITERAL:
    case K_AS:
    case K_BYTE:
    case K_CASCADE:
    case K_CASE:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHAR:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_COSTS:
    case K_CYCLE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DIV:
    case K_DO:
    case K_DUPLICATE:
    case K_ENABLE:
    case K_END:
    case K_EXCLUDE:
    case K_EXTRACT:
    case K_FIRST:
    case K_FALSE:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_INDEX:
    case K_INSERT:
    case K_INTERVAL:
    case K_ISNULL:
    case K_JSON:
    case K_KEY:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LOCAL:
    case K_MATERIALIZED:
    case K_NEXTVAL:
    case K_NO:
    case K_NOLOCK:
    case K_NULLS:
    case K_OF:
    case K_OPEN:
    case K_OVER:
    case K_PARALLEL:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_RANGE:
    case K_READ:
    case K_REPLACE:
    case K_ROW:
    case K_ROWS:
    case K_SCHEMA:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SIBLINGS:
    case K_SIZE:
    case K_SKIP:
    case K_SYNONYM:
    case K_TABLE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIMEOUT:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TYPE:
    case K_SIGNED:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VIEW:
    case K_XML:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:{
      alias = Alias();
selectExpressionItem.setAlias(alias);
      break;
      }
    default:
      jj_la1[147] = jj_gen;
      ;
    }
return selectExpressionItem;
}

  final public SelectItem SelectItem() throws ParseException {/*@bgen(jjtree) SelectItem */
    SimpleNode jjtn000 = new SimpleNode(JJTSELECTITEM);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));SelectItem selectItem = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 290:{
        jj_consume_token(290);
selectItem = new AllColumns();
        break;
        }
      default:
        jj_la1[148] = jj_gen;
        if (jj_2_57(2147483647)) {
          selectItem = AllTableColumns();
        } else if (jj_2_58(1)) {
          selectItem = SelectExpressionItem();
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
linkAST(selectItem,jjtn000);
        return selectItem;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public AllTableColumns AllTableColumns() throws ParseException {Table table = null;
    table = Table();
    jj_consume_token(291);
    jj_consume_token(290);
return new AllTableColumns(table);
}

  final public Alias Alias() throws ParseException {String name = null;
  Token token = null;
  boolean useAs = false;
  Alias alias;
  String colname;
  ColDataType colDataType = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_AS:{
      jj_consume_token(K_AS);
useAs = true;
      break;
      }
    default:
      jj_la1[149] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ALGORITHM:
    case K_ANY:
    case K_ARRAY_LITERAL:
    case K_BYTE:
    case K_CASCADE:
    case K_CASE:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHAR:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_COSTS:
    case K_CYCLE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DIV:
    case K_DO:
    case K_DUPLICATE:
    case K_ENABLE:
    case K_END:
    case K_EXCLUDE:
    case K_EXTRACT:
    case K_FIRST:
    case K_FALSE:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_INDEX:
    case K_INSERT:
    case K_INTERVAL:
    case K_ISNULL:
    case K_JSON:
    case K_KEY:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LOCAL:
    case K_MATERIALIZED:
    case K_NEXTVAL:
    case K_NO:
    case K_NOLOCK:
    case K_NULLS:
    case K_OF:
    case K_OPEN:
    case K_OVER:
    case K_PARALLEL:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_RANGE:
    case K_READ:
    case K_REPLACE:
    case K_ROW:
    case K_ROWS:
    case K_SCHEMA:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SIBLINGS:
    case K_SIZE:
    case K_SKIP:
    case K_SYNONYM:
    case K_TABLE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIMEOUT:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TYPE:
    case K_SIGNED:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VIEW:
    case K_XML:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      name = RelObjectNameWithoutStart();
      break;
      }
    case S_CHAR_LITERAL:{
      token = jj_consume_token(S_CHAR_LITERAL);
name=token.image;
      break;
      }
    default:
      jj_la1[150] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
alias = new Alias(name,useAs);
    if (jj_2_59(2)) {
      jj_consume_token(287);
List<Alias.AliasColumn> list = new ArrayList<Alias.AliasColumn>();
      colname = RelObjectName();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_BINARY:
      case K_BIT:
      case K_CHARACTER:
      case K_CHAR:
      case K_DATETIMELITERAL:
      case K_DATE_LITERAL:
      case K_DOUBLE:
      case K_INTERVAL:
      case K_JSON:
      case K_SET:
      case K_SIGNED:
      case K_UNSIGNED:
      case K_XML:
      case DT_ZONE:
      case S_IDENTIFIER:{
        colDataType = ColDataType();
        break;
        }
      default:
        jj_la1[151] = jj_gen;
        ;
      }
list.add(new Alias.AliasColumn(colname, colDataType));
      label_40:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[152] = jj_gen;
          break label_40;
        }
        jj_consume_token(K_COMMA);
colDataType=null;
        colname = RelObjectName();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_BINARY:
        case K_BIT:
        case K_CHARACTER:
        case K_CHAR:
        case K_DATETIMELITERAL:
        case K_DATE_LITERAL:
        case K_DOUBLE:
        case K_INTERVAL:
        case K_JSON:
        case K_SET:
        case K_SIGNED:
        case K_UNSIGNED:
        case K_XML:
        case DT_ZONE:
        case S_IDENTIFIER:{
          colDataType = ColDataType();
          break;
          }
        default:
          jj_la1[153] = jj_gen;
          ;
        }
list.add(new Alias.AliasColumn(colname, colDataType));
      }
      jj_consume_token(288);
alias.setAliasColumns(list);
    } else {
      ;
    }
return alias;
}

  final public void SQLServerHint(SQLServerHints hints) throws ParseException {String str;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_INDEX:{
      jj_consume_token(K_INDEX);
      jj_consume_token(287);
      str = RelObjectName();
      jj_consume_token(288);
hints.setIndexName(str);
      break;
      }
    case K_NOLOCK:{
      jj_consume_token(K_NOLOCK);
hints.withNoLock();
      break;
      }
    default:
      jj_la1[154] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public SQLServerHints SQLServerHints() throws ParseException {SQLServerHints hints = new SQLServerHints();
    jj_consume_token(K_WITH);
    jj_consume_token(287);
    SQLServerHint(hints);
    label_41:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[155] = jj_gen;
        break label_41;
      }
      jj_consume_token(K_COMMA);
      SQLServerHint(hints);
    }
    jj_consume_token(288);
return hints;
}

  final public MySQLIndexHint MySQLIndexHint() throws ParseException {Token actionToken = null;
        Token indexToken = null;
        String indexName = null;
        List<String> indexNameList = new ArrayList<String>();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_USE:{
      actionToken = jj_consume_token(K_USE);
      break;
      }
    case K_SHOW:{
      actionToken = jj_consume_token(K_SHOW);
      break;
      }
    case K_IGNORE:{
      actionToken = jj_consume_token(K_IGNORE);
      break;
      }
    case K_FORCE:{
      actionToken = jj_consume_token(K_FORCE);
      break;
      }
    default:
      jj_la1[156] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_INDEX:{
      indexToken = jj_consume_token(K_INDEX);
      break;
      }
    case K_KEY:{
      indexToken = jj_consume_token(K_KEY);
      break;
      }
    default:
      jj_la1[157] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(287);
    indexName = Identifier();
indexNameList.add(indexName);
    label_42:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[158] = jj_gen;
        break label_42;
      }
      jj_consume_token(K_COMMA);
      indexName = Identifier();
indexNameList.add(indexName);
    }
    jj_consume_token(288);
return new MySQLIndexHint(actionToken.image, indexToken.image, indexNameList);
}

  final public String Identifier() throws ParseException {Token tk = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_IDENTIFIER:{
      tk = jj_consume_token(S_IDENTIFIER);
      break;
      }
    case S_QUOTED_IDENTIFIER:{
      tk = jj_consume_token(S_QUOTED_IDENTIFIER);
      break;
      }
    default:
      jj_la1[159] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return tk.image;
}

  final public FunctionItem FunctionItem() throws ParseException {Alias alias = null;
    Function function;
     FunctionItem functionItem;
    function = Function();
functionItem = new FunctionItem(); functionItem.setFunction(function);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ALGORITHM:
    case K_ANY:
    case K_ARRAY_LITERAL:
    case K_AS:
    case K_BYTE:
    case K_CASCADE:
    case K_CASE:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHAR:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_COSTS:
    case K_CYCLE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DIV:
    case K_DO:
    case K_DUPLICATE:
    case K_ENABLE:
    case K_END:
    case K_EXCLUDE:
    case K_EXTRACT:
    case K_FIRST:
    case K_FALSE:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_INDEX:
    case K_INSERT:
    case K_INTERVAL:
    case K_ISNULL:
    case K_JSON:
    case K_KEY:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LOCAL:
    case K_MATERIALIZED:
    case K_NEXTVAL:
    case K_NO:
    case K_NOLOCK:
    case K_NULLS:
    case K_OF:
    case K_OPEN:
    case K_OVER:
    case K_PARALLEL:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_RANGE:
    case K_READ:
    case K_REPLACE:
    case K_ROW:
    case K_ROWS:
    case K_SCHEMA:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SIBLINGS:
    case K_SIZE:
    case K_SKIP:
    case K_SYNONYM:
    case K_TABLE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIMEOUT:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TYPE:
    case K_SIGNED:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VIEW:
    case K_XML:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:{
      alias = Alias();
functionItem.setAlias(alias);
      break;
      }
    default:
      jj_la1[160] = jj_gen;
      ;
    }
return functionItem;
}

  final public List<Column> PivotForColumns() throws ParseException {List<Column> columns = new ArrayList<Column>();
    Column column;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 287:{
      jj_consume_token(287);
      column = Column();
columns.add(column);
      label_43:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[161] = jj_gen;
          break label_43;
        }
        jj_consume_token(K_COMMA);
        column = Column();
columns.add(column);
      }
      jj_consume_token(288);
      break;
      }
    case K_ACTION:
    case K_ALGORITHM:
    case K_ALL:
    case K_ANY:
    case K_ARRAY_LITERAL:
    case K_BYTE:
    case K_CASCADE:
    case K_CASE:
    case K_CASEWHEN:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHAR:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_COSTS:
    case K_CREATE:
    case K_CYCLE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DIV:
    case K_DO:
    case K_DOUBLE:
    case K_DUPLICATE:
    case K_ENABLE:
    case K_END:
    case K_EXCLUDE:
    case K_EXTRACT:
    case K_FIRST:
    case K_FALSE:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_GROUP:
    case K_IF:
    case K_IIF:
    case K_IN:
    case K_INDEX:
    case K_INSERT:
    case K_INTERVAL:
    case K_ISNULL:
    case K_JSON:
    case K_KEY:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LEFT:
    case K_LIMIT:
    case K_LOCAL:
    case K_MATERIALIZED:
    case K_NEXTVAL:
    case K_NO:
    case K_NOLOCK:
    case K_NULLS:
    case K_OF:
    case K_OFFSET:
    case K_ON:
    case K_OPEN:
    case K_ORDER:
    case K_OVER:
    case K_OPTIMIZE:
    case K_PARALLEL:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_PROCEDURE:
    case K_PUBLIC:
    case K_RANGE:
    case K_READ:
    case K_REPLACE:
    case K_RIGHT:
    case K_ROW:
    case K_ROWS:
    case K_SCHEMA:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SET:
    case K_SIBLINGS:
    case K_SIZE:
    case K_SKIP:
    case K_START:
    case K_SYNONYM:
    case K_TABLE:
    case K_TABLES:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIMEOUT:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TYPE:
    case K_SIGNED:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VIEW:
    case K_XML:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      column = Column();
columns.add(column);
      break;
      }
    default:
      jj_la1[162] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return columns;
}

  final public List<FunctionItem> PivotFunctionItems() throws ParseException {List< FunctionItem> functionItems = new ArrayList< FunctionItem>();
    FunctionItem item;
    item = FunctionItem();
functionItems.add(item);
    label_44:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[163] = jj_gen;
        break label_44;
      }
      jj_consume_token(K_COMMA);
      item = FunctionItem();
functionItems.add(item);
    }
return functionItems;
}

  final public List<SelectExpressionItem> PivotSingleInItems() throws ParseException {List<SelectExpressionItem> retval = new ArrayList<SelectExpressionItem>();
   SelectExpressionItem item;
    item = PivotSelectExprItem();
retval.add(item);
    label_45:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[164] = jj_gen;
        break label_45;
      }
      jj_consume_token(K_COMMA);
      item = PivotSelectExprItem();
retval.add(item);
    }
return retval;
}

  final public SelectExpressionItem PivotSelectExprItem() throws ParseException {SelectExpressionItem selectExpressionItem = null;
    Expression expression = null;
    Alias alias = null;
    expression = SimpleExpression();
selectExpressionItem = new SelectExpressionItem(); selectExpressionItem.setExpression(expression);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ALGORITHM:
    case K_ANY:
    case K_ARRAY_LITERAL:
    case K_AS:
    case K_BYTE:
    case K_CASCADE:
    case K_CASE:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHAR:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_COSTS:
    case K_CYCLE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DIV:
    case K_DO:
    case K_DUPLICATE:
    case K_ENABLE:
    case K_END:
    case K_EXCLUDE:
    case K_EXTRACT:
    case K_FIRST:
    case K_FALSE:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_INDEX:
    case K_INSERT:
    case K_INTERVAL:
    case K_ISNULL:
    case K_JSON:
    case K_KEY:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LOCAL:
    case K_MATERIALIZED:
    case K_NEXTVAL:
    case K_NO:
    case K_NOLOCK:
    case K_NULLS:
    case K_OF:
    case K_OPEN:
    case K_OVER:
    case K_PARALLEL:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_RANGE:
    case K_READ:
    case K_REPLACE:
    case K_ROW:
    case K_ROWS:
    case K_SCHEMA:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SIBLINGS:
    case K_SIZE:
    case K_SKIP:
    case K_SYNONYM:
    case K_TABLE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIMEOUT:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TYPE:
    case K_SIGNED:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VIEW:
    case K_XML:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:{
      alias = Alias();
selectExpressionItem.setAlias(alias);
      break;
      }
    default:
      jj_la1[165] = jj_gen;
      ;
    }
return selectExpressionItem;
}

  final public ExpressionListItem ExpressionListItem() throws ParseException {ExpressionListItem expressionListItem = null;
    ExpressionList expressionList = null;
    Alias alias = null;
    jj_consume_token(287);
    expressionList = SimpleExpressionList(true);
expressionListItem = new ExpressionListItem(); expressionListItem.setExpressionList(expressionList);
    jj_consume_token(288);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ALGORITHM:
    case K_ANY:
    case K_ARRAY_LITERAL:
    case K_AS:
    case K_BYTE:
    case K_CASCADE:
    case K_CASE:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHAR:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_COSTS:
    case K_CYCLE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DIV:
    case K_DO:
    case K_DUPLICATE:
    case K_ENABLE:
    case K_END:
    case K_EXCLUDE:
    case K_EXTRACT:
    case K_FIRST:
    case K_FALSE:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_INDEX:
    case K_INSERT:
    case K_INTERVAL:
    case K_ISNULL:
    case K_JSON:
    case K_KEY:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LOCAL:
    case K_MATERIALIZED:
    case K_NEXTVAL:
    case K_NO:
    case K_NOLOCK:
    case K_NULLS:
    case K_OF:
    case K_OPEN:
    case K_OVER:
    case K_PARALLEL:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_RANGE:
    case K_READ:
    case K_REPLACE:
    case K_ROW:
    case K_ROWS:
    case K_SCHEMA:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SIBLINGS:
    case K_SIZE:
    case K_SKIP:
    case K_SYNONYM:
    case K_TABLE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIMEOUT:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TYPE:
    case K_SIGNED:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VIEW:
    case K_XML:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:{
      alias = Alias();
expressionListItem.setAlias(alias);
      break;
      }
    default:
      jj_la1[166] = jj_gen;
      ;
    }
return expressionListItem;
}

  final public List<ExpressionListItem> PivotMultiInItems() throws ParseException {List<ExpressionListItem> retval = new ArrayList<ExpressionListItem>();
   ExpressionListItem item;
    item = ExpressionListItem();
retval.add(item);
    label_46:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[167] = jj_gen;
        break label_46;
      }
      jj_consume_token(K_COMMA);
      item = ExpressionListItem();
retval.add(item);
    }
return retval;
}

  final public Pivot Pivot() throws ParseException {Pivot retval = new Pivot();
    List<FunctionItem> functionItems;
    List<Column> forColumns;
    List<SelectExpressionItem> singleInItems = null;
    List<ExpressionListItem> multiInItems = null;
    Alias alias = null;
    jj_consume_token(K_PIVOT);
    jj_consume_token(287);
    functionItems = PivotFunctionItems();
    jj_consume_token(K_FOR);
    forColumns = PivotForColumns();
    jj_consume_token(K_IN);
    jj_consume_token(287);
    if (jj_2_60(3)) {
      singleInItems = PivotSingleInItems();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 287:{
        multiInItems = PivotMultiInItems();
        break;
        }
      default:
        jj_la1[168] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(288);
    jj_consume_token(288);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ALGORITHM:
    case K_ANY:
    case K_ARRAY_LITERAL:
    case K_AS:
    case K_BYTE:
    case K_CASCADE:
    case K_CASE:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHAR:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_COSTS:
    case K_CYCLE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DIV:
    case K_DO:
    case K_DUPLICATE:
    case K_ENABLE:
    case K_END:
    case K_EXCLUDE:
    case K_EXTRACT:
    case K_FIRST:
    case K_FALSE:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_INDEX:
    case K_INSERT:
    case K_INTERVAL:
    case K_ISNULL:
    case K_JSON:
    case K_KEY:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LOCAL:
    case K_MATERIALIZED:
    case K_NEXTVAL:
    case K_NO:
    case K_NOLOCK:
    case K_NULLS:
    case K_OF:
    case K_OPEN:
    case K_OVER:
    case K_PARALLEL:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_RANGE:
    case K_READ:
    case K_REPLACE:
    case K_ROW:
    case K_ROWS:
    case K_SCHEMA:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SIBLINGS:
    case K_SIZE:
    case K_SKIP:
    case K_SYNONYM:
    case K_TABLE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIMEOUT:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TYPE:
    case K_SIGNED:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VIEW:
    case K_XML:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:{
      alias = Alias();
      break;
      }
    default:
      jj_la1[169] = jj_gen;
      ;
    }
retval.setFunctionItems(functionItems);
        retval.setForColumns(forColumns);
        retval.setSingleInItems(singleInItems);
        retval.setMultiInItems(multiInItems);
        retval.setAlias(alias);
        return retval;
}

  final public PivotXml PivotXml() throws ParseException {PivotXml retval = new PivotXml();
    List<FunctionItem> functionItems;
    List<Column> forColumns;
    List<SelectExpressionItem> singleInItems = null;
    List<ExpressionListItem> multiInItems = null;
    SelectBody inSelect = null;
    jj_consume_token(K_PIVOT);
    jj_consume_token(K_XML);
    jj_consume_token(287);
    functionItems = PivotFunctionItems();
    jj_consume_token(K_FOR);
    forColumns = PivotForColumns();
    jj_consume_token(K_IN);
    jj_consume_token(287);
    if (jj_2_61(2)) {
      jj_consume_token(K_ANY);
retval.setInAny(true);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_SELECT:
      case K_VALUES:
      case 287:{
        inSelect = SelectBody();
        break;
        }
      default:
        jj_la1[170] = jj_gen;
        if (jj_2_62(2)) {
          singleInItems = PivotSingleInItems();
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 287:{
            multiInItems = PivotMultiInItems();
            break;
            }
          default:
            jj_la1[171] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
    }
    jj_consume_token(288);
    jj_consume_token(288);
retval.setFunctionItems(functionItems);
        retval.setForColumns(forColumns);
        retval.setSingleInItems(singleInItems);
        retval.setMultiInItems(multiInItems);
        retval.setInSelect(inSelect);
        return retval;
}

  final public UnPivot UnPivot() throws ParseException {UnPivot retval = new UnPivot();
    Column unpivotClause;
    List<Column> unpivotForClause;
    List<SelectExpressionItem> unpivotInClause;
    jj_consume_token(K_UNPIVOT);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_EXCLUDE:
    case K_INCLUDE:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_INCLUDE:{
        jj_consume_token(K_INCLUDE);
        jj_consume_token(K_NULLS);
retval.setIncludeNulls(true);
        break;
        }
      case K_EXCLUDE:{
        jj_consume_token(K_EXCLUDE);
        jj_consume_token(K_NULLS);
retval.setIncludeNulls(false);
        break;
        }
      default:
        jj_la1[172] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[173] = jj_gen;
      ;
    }
    jj_consume_token(287);
    unpivotClause = Column();
    jj_consume_token(K_FOR);
    unpivotForClause = PivotForColumns();
    jj_consume_token(K_IN);
    jj_consume_token(287);
    unpivotInClause = PivotSingleInItems();
    jj_consume_token(288);
    jj_consume_token(288);
retval.setUnPivotClause(unpivotClause);
        retval.setUnPivotForClause(unpivotForClause);
        retval.setUnPivotInClause(unpivotInClause);
        return retval;
}

  final public List<Table> IntoClause() throws ParseException {List<Table> tables = new ArrayList<Table>();
    Table table;
    jj_consume_token(K_INTO);
    table = Table();
tables.add(table);
    label_47:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[174] = jj_gen;
        break label_47;
      }
      jj_consume_token(K_COMMA);
      table = Table();
tables.add(table);
    }
return tables;
}

  final public FromItem FromItem() throws ParseException {FromItem fromItem = null;
    FromItem fromItem2 = null;
    Pivot pivot = null;
    UnPivot unpivot = null;
    Alias alias = null;
    MySQLIndexHint indexHint = null;
    SQLServerHints sqlServerHints = null;
    SelectBody selectBody;
    if (jj_2_69(2147483647)) {
      fromItem = ValuesList();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ACTION:
      case K_ALGORITHM:
      case K_ALL:
      case K_ANY:
      case K_ARRAY_LITERAL:
      case K_BYTE:
      case K_CASCADE:
      case K_CASE:
      case K_CASEWHEN:
      case K_CAST:
      case K_CHARACTER:
      case K_CHANGE:
      case K_CHAR:
      case K_COLUMN:
      case K_COLUMNS:
      case K_COMMIT:
      case K_COMMENT:
      case K_COSTS:
      case K_CREATE:
      case K_CYCLE:
      case K_DATETIMELITERAL:
      case K_DATE_LITERAL:
      case K_DESC:
      case K_DESCRIBE:
      case K_DISABLE:
      case K_DIV:
      case K_DO:
      case K_DOUBLE:
      case K_DUPLICATE:
      case K_ENABLE:
      case K_END:
      case K_EXCLUDE:
      case K_EXTRACT:
      case K_FIRST:
      case K_FALSE:
      case K_FOLLOWING:
      case K_FORMAT:
      case K_GROUP:
      case K_IF:
      case K_IIF:
      case K_IN:
      case K_INDEX:
      case K_INSERT:
      case K_INTERVAL:
      case K_ISNULL:
      case K_JSON:
      case K_KEY:
      case K_FN:
      case K_LAST:
      case K_LATERAL:
      case K_LEADING:
      case K_LEFT:
      case K_LIMIT:
      case K_LOCAL:
      case K_MATERIALIZED:
      case K_NEXTVAL:
      case K_NO:
      case K_NOLOCK:
      case K_NULLS:
      case K_OF:
      case K_OFFSET:
      case K_ON:
      case K_OPEN:
      case K_ORDER:
      case K_OVER:
      case K_OPTIMIZE:
      case K_PARALLEL:
      case K_PARTITION:
      case K_PATH:
      case K_PERCENT:
      case K_PRECISION:
      case K_PRIMARY:
      case K_PRIOR:
      case K_PROCEDURE:
      case K_PUBLIC:
      case K_RANGE:
      case K_READ:
      case K_REPLACE:
      case K_RIGHT:
      case K_ROW:
      case K_ROWS:
      case K_SCHEMA:
      case K_SEQUENCE:
      case K_SEPARATOR:
      case K_SESSION:
      case K_SET:
      case K_SIBLINGS:
      case K_SIZE:
      case K_SKIP:
      case K_START:
      case K_SYNONYM:
      case K_TABLE:
      case K_TABLES:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIMEOUT:
      case K_TO:
      case K_TOP:
      case K_TRUNCATE:
      case K_TRUE:
      case K_TYPE:
      case K_SIGNED:
      case K_UNSIGNED:
      case K_VALIDATE:
      case K_VALUE:
      case K_VALUES:
      case K_VIEW:
      case K_XML:
      case K_ZONE:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:
      case 287:
      case 333:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 287:{
          jj_consume_token(287);
          if (jj_2_63(3)) {
            fromItem2 = FromItem();
fromItem = new ParenthesisFromItem(fromItem2);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_APPLY:
            case K_COMMA:
            case K_CROSS:
            case K_FULL:
            case K_INNER:
            case K_STRAIGHT:
            case K_JOIN:
            case K_LEFT:
            case K_NATURAL:
            case K_OUTER:
            case K_RIGHT:{
              fromItem = SubJoin(fromItem2);
              break;
              }
            default:
              jj_la1[175] = jj_gen;
              ;
            }
          } else {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_SELECT:
            case K_VALUES:
            case K_WITH:
            case 287:{
              fromItem = SubSelect();
              break;
              }
            default:
              jj_la1[176] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_EXCEPT:
          case K_INTERSECT:
          case K_MINUS:
          case K_UNION:{
            selectBody = SetOperationListWithoutIntialSelect(fromItem);
if (!(selectBody instanceof PlainSelect)) {
                                    fromItem = new SubSelect().withSelectBody(selectBody);
                                }
            break;
            }
          default:
            jj_la1[177] = jj_gen;
            ;
          }
          jj_consume_token(288);
          if (jj_2_64(2)) {
            unpivot = UnPivot();
fromItem.setUnPivot(unpivot);
          } else {
            ;
          }
          break;
          }
        default:
          jj_la1[178] = jj_gen;
          if (jj_2_65(2147483647)) {
            fromItem = TableFunction();
          } else {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_ACTION:
            case K_ALGORITHM:
            case K_ALL:
            case K_ANY:
            case K_ARRAY_LITERAL:
            case K_BYTE:
            case K_CASCADE:
            case K_CASE:
            case K_CASEWHEN:
            case K_CAST:
            case K_CHARACTER:
            case K_CHANGE:
            case K_CHAR:
            case K_COLUMN:
            case K_COLUMNS:
            case K_COMMIT:
            case K_COMMENT:
            case K_COSTS:
            case K_CREATE:
            case K_CYCLE:
            case K_DATETIMELITERAL:
            case K_DATE_LITERAL:
            case K_DESC:
            case K_DESCRIBE:
            case K_DISABLE:
            case K_DIV:
            case K_DO:
            case K_DOUBLE:
            case K_DUPLICATE:
            case K_ENABLE:
            case K_END:
            case K_EXCLUDE:
            case K_EXTRACT:
            case K_FIRST:
            case K_FALSE:
            case K_FOLLOWING:
            case K_FORMAT:
            case K_GROUP:
            case K_IF:
            case K_IIF:
            case K_IN:
            case K_INDEX:
            case K_INSERT:
            case K_INTERVAL:
            case K_ISNULL:
            case K_JSON:
            case K_KEY:
            case K_FN:
            case K_LAST:
            case K_LEADING:
            case K_LEFT:
            case K_LIMIT:
            case K_LOCAL:
            case K_MATERIALIZED:
            case K_NEXTVAL:
            case K_NO:
            case K_NOLOCK:
            case K_NULLS:
            case K_OF:
            case K_OFFSET:
            case K_ON:
            case K_OPEN:
            case K_ORDER:
            case K_OVER:
            case K_OPTIMIZE:
            case K_PARALLEL:
            case K_PARTITION:
            case K_PATH:
            case K_PERCENT:
            case K_PRECISION:
            case K_PRIMARY:
            case K_PRIOR:
            case K_PROCEDURE:
            case K_PUBLIC:
            case K_RANGE:
            case K_READ:
            case K_REPLACE:
            case K_RIGHT:
            case K_ROW:
            case K_ROWS:
            case K_SCHEMA:
            case K_SEQUENCE:
            case K_SEPARATOR:
            case K_SESSION:
            case K_SET:
            case K_SIBLINGS:
            case K_SIZE:
            case K_SKIP:
            case K_START:
            case K_SYNONYM:
            case K_TABLE:
            case K_TABLES:
            case K_TEMP:
            case K_TEMPORARY:
            case K_TIMEOUT:
            case K_TO:
            case K_TOP:
            case K_TRUNCATE:
            case K_TRUE:
            case K_TYPE:
            case K_SIGNED:
            case K_UNSIGNED:
            case K_VALIDATE:
            case K_VALUE:
            case K_VALUES:
            case K_VIEW:
            case K_XML:
            case K_ZONE:
            case S_IDENTIFIER:
            case S_QUOTED_IDENTIFIER:{
              fromItem = Table();
              break;
              }
            case K_LATERAL:{
              fromItem = LateralSubSelect();
              break;
              }
            default:
              jj_la1[179] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ACTION:
        case K_ALGORITHM:
        case K_ANY:
        case K_ARRAY_LITERAL:
        case K_AS:
        case K_BYTE:
        case K_CASCADE:
        case K_CASE:
        case K_CAST:
        case K_CHARACTER:
        case K_CHANGE:
        case K_CHAR:
        case K_COLUMN:
        case K_COLUMNS:
        case K_COMMIT:
        case K_COMMENT:
        case K_COSTS:
        case K_CYCLE:
        case K_DATETIMELITERAL:
        case K_DATE_LITERAL:
        case K_DESC:
        case K_DESCRIBE:
        case K_DISABLE:
        case K_DIV:
        case K_DO:
        case K_DUPLICATE:
        case K_ENABLE:
        case K_END:
        case K_EXCLUDE:
        case K_EXTRACT:
        case K_FIRST:
        case K_FALSE:
        case K_FOLLOWING:
        case K_FORMAT:
        case K_INDEX:
        case K_INSERT:
        case K_INTERVAL:
        case K_ISNULL:
        case K_JSON:
        case K_KEY:
        case K_FN:
        case K_LAST:
        case K_LEADING:
        case K_LOCAL:
        case K_MATERIALIZED:
        case K_NEXTVAL:
        case K_NO:
        case K_NOLOCK:
        case K_NULLS:
        case K_OF:
        case K_OPEN:
        case K_OVER:
        case K_PARALLEL:
        case K_PARTITION:
        case K_PATH:
        case K_PERCENT:
        case K_PRECISION:
        case K_PRIMARY:
        case K_PRIOR:
        case K_RANGE:
        case K_READ:
        case K_REPLACE:
        case K_ROW:
        case K_ROWS:
        case K_SCHEMA:
        case K_SEQUENCE:
        case K_SEPARATOR:
        case K_SESSION:
        case K_SIBLINGS:
        case K_SIZE:
        case K_SKIP:
        case K_SYNONYM:
        case K_TABLE:
        case K_TEMP:
        case K_TEMPORARY:
        case K_TIMEOUT:
        case K_TO:
        case K_TOP:
        case K_TRUNCATE:
        case K_TRUE:
        case K_TYPE:
        case K_SIGNED:
        case K_UNSIGNED:
        case K_VALIDATE:
        case K_VALUE:
        case K_VALUES:
        case K_VIEW:
        case K_XML:
        case K_ZONE:
        case S_IDENTIFIER:
        case S_CHAR_LITERAL:
        case S_QUOTED_IDENTIFIER:{
          alias = Alias();
fromItem.setAlias(alias);
          break;
          }
        default:
          jj_la1[180] = jj_gen;
          ;
        }
        if (jj_2_66(2)) {
          unpivot = UnPivot();
fromItem.setUnPivot(unpivot);
        } else {
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_PIVOT:{
          if (jj_2_67(2)) {
            pivot = PivotXml();
          } else {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_PIVOT:{
              pivot = Pivot();
              break;
              }
            default:
              jj_la1[181] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
fromItem.setPivot(pivot);
          break;
          }
        default:
          jj_la1[182] = jj_gen;
          ;
        }
        if (jj_2_68(2)) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_FORCE:
          case K_IGNORE:
          case K_SHOW:
          case K_USE:{
            indexHint = MySQLIndexHint();
if (fromItem instanceof Table)
                            ((Table) fromItem).setHint(indexHint);
            break;
            }
          case K_WITH:{
            sqlServerHints = SQLServerHints();
if (fromItem instanceof Table)
                            ((Table) fromItem).setSqlServerHints(sqlServerHints);
            break;
            }
          default:
            jj_la1[183] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        } else {
          ;
        }
        break;
        }
      default:
        jj_la1[184] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return fromItem;
}

  final public FromItem ValuesList() throws ParseException {MultiExpressionList exprList = new MultiExpressionList();
    List<Expression> primaryExpList = new ArrayList<Expression>();
    ValuesList valuesList = new ValuesList();
    Expression exp = null;
    List<String> colNames = null;
    String colName;
    Alias alias;
    jj_consume_token(287);
    jj_consume_token(K_VALUES);
    if (jj_2_70(3)) {
      jj_consume_token(287);
      exp = SimpleExpression();
primaryExpList.add(exp);
      label_48:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[185] = jj_gen;
          break label_48;
        }
        jj_consume_token(K_COMMA);
        exp = SimpleExpression();
primaryExpList.add(exp);
      }
      jj_consume_token(288);
exprList.addExpressionList(primaryExpList);
      label_49:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[186] = jj_gen;
          break label_49;
        }
        jj_consume_token(K_COMMA);
        jj_consume_token(287);
        exp = SimpleExpression();
primaryExpList = new ArrayList<Expression>();
                    primaryExpList.add(exp);
        label_50:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_COMMA:{
            ;
            break;
            }
          default:
            jj_la1[187] = jj_gen;
            break label_50;
          }
          jj_consume_token(K_COMMA);
          exp = SimpleExpression();
primaryExpList.add(exp);
        }
        jj_consume_token(288);
exprList.addExpressionList(primaryExpList);
      }
    } else if (jj_2_71(1)) {
      exp = SimpleExpression();
exprList.addExpressionList(exp); valuesList.setNoBrackets(true);
      label_51:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[188] = jj_gen;
          break label_51;
        }
        jj_consume_token(K_COMMA);
        exp = SimpleExpression();
exprList.addExpressionList(exp);
      }
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(288);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ALGORITHM:
    case K_ANY:
    case K_ARRAY_LITERAL:
    case K_AS:
    case K_BYTE:
    case K_CASCADE:
    case K_CASE:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHAR:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_COSTS:
    case K_CYCLE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DIV:
    case K_DO:
    case K_DUPLICATE:
    case K_ENABLE:
    case K_END:
    case K_EXCLUDE:
    case K_EXTRACT:
    case K_FIRST:
    case K_FALSE:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_INDEX:
    case K_INSERT:
    case K_INTERVAL:
    case K_ISNULL:
    case K_JSON:
    case K_KEY:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LOCAL:
    case K_MATERIALIZED:
    case K_NEXTVAL:
    case K_NO:
    case K_NOLOCK:
    case K_NULLS:
    case K_OF:
    case K_OPEN:
    case K_OVER:
    case K_PARALLEL:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_RANGE:
    case K_READ:
    case K_REPLACE:
    case K_ROW:
    case K_ROWS:
    case K_SCHEMA:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SIBLINGS:
    case K_SIZE:
    case K_SKIP:
    case K_SYNONYM:
    case K_TABLE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIMEOUT:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TYPE:
    case K_SIGNED:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VIEW:
    case K_XML:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:{
      alias = Alias();
valuesList.setAlias(alias);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 287:{
        jj_consume_token(287);
        colName = RelObjectName();
colNames = new ArrayList<String>(); colNames.add(colName);
        label_52:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_COMMA:{
            ;
            break;
            }
          default:
            jj_la1[189] = jj_gen;
            break label_52;
          }
          jj_consume_token(K_COMMA);
          colName = RelObjectName();
colNames.add(colName);
        }
        jj_consume_token(288);
valuesList.setColumnNames(colNames);
        break;
        }
      default:
        jj_la1[190] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[191] = jj_gen;
      ;
    }
valuesList.setMultiExpressionList(exprList);
        return valuesList;
}

  final public LateralSubSelect LateralSubSelect() throws ParseException {LateralSubSelect specialSubSelect;
    SubSelect subSelect = null;
    jj_consume_token(K_LATERAL);
specialSubSelect = new LateralSubSelect();
    jj_consume_token(287);
    subSelect = SubSelect();
    jj_consume_token(288);
specialSubSelect.setSubSelect(subSelect);
        return specialSubSelect;
}

  final public FromItem SubJoin(FromItem fromItem) throws ParseException {Join join = null;
    List<Join> joinList = null;
    joinList = SubJoinsList();
SubJoin subJoin = new SubJoin();
        subJoin.setLeft(fromItem);
        subJoin.setJoinList(joinList);
        return subJoin;
}

  final public List<Join> JoinsList() throws ParseException {List<Join> joinsList = new ArrayList<Join>();
    Join join = null;
    label_53:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_APPLY:
      case K_COMMA:
      case K_CROSS:
      case K_FULL:
      case K_INNER:
      case K_STRAIGHT:
      case K_JOIN:
      case K_LEFT:
      case K_NATURAL:
      case K_OUTER:
      case K_RIGHT:{
        ;
        break;
        }
      default:
        jj_la1[192] = jj_gen;
        break label_53;
      }
      join = JoinerExpression();
joinsList.add(join);
    }
return joinsList;
}

  final public List<Join> SubJoinsList() throws ParseException {List<Join> joinsList = new ArrayList<Join>();
    Join join = null;
    label_54:
    while (true) {
      join = JoinerExpression();
joinsList.add(join);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_APPLY:
      case K_COMMA:
      case K_CROSS:
      case K_FULL:
      case K_INNER:
      case K_STRAIGHT:
      case K_JOIN:
      case K_LEFT:
      case K_NATURAL:
      case K_OUTER:
      case K_RIGHT:{
        ;
        break;
        }
      default:
        jj_la1[193] = jj_gen;
        break label_54;
      }
    }
return joinsList;
}

  final public Join JoinerExpression() throws ParseException {/*@bgen(jjtree) JoinerExpression */
    SimpleNode jjtn000 = new SimpleNode(JJTJOINEREXPRESSION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Join join = new Join();
    FromItem right = null;
    Expression onExpression = null;
    Column tableColumn;
    List<Column> columns = null;
    KSQLJoinWindow joinWindow = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_CROSS:
      case K_FULL:
      case K_INNER:
      case K_LEFT:
      case K_NATURAL:
      case K_OUTER:
      case K_RIGHT:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_LEFT:{
          jj_consume_token(K_LEFT);
join.setLeft(true);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_OUTER:
          case K_SEMI:{
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_SEMI:{
              jj_consume_token(K_SEMI);
join.setSemi(true);
              break;
              }
            case K_OUTER:{
              jj_consume_token(K_OUTER);
join.setOuter(true);
              break;
              }
            default:
              jj_la1[194] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            break;
            }
          default:
            jj_la1[195] = jj_gen;
            ;
          }
          break;
          }
        case K_FULL:
        case K_RIGHT:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_RIGHT:{
            jj_consume_token(K_RIGHT);
join.setRight(true);
            break;
            }
          case K_FULL:{
            jj_consume_token(K_FULL);
join.setFull(true);
            break;
            }
          default:
            jj_la1[196] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_OUTER:{
            jj_consume_token(K_OUTER);
join.setOuter(true);
            break;
            }
          default:
            jj_la1[197] = jj_gen;
            ;
          }
          break;
          }
        case K_INNER:{
          jj_consume_token(K_INNER);
join.setInner(true);
          break;
          }
        case K_NATURAL:{
          jj_consume_token(K_NATURAL);
join.setNatural(true);
          break;
          }
        case K_CROSS:{
          jj_consume_token(K_CROSS);
join.setCross(true);
          break;
          }
        case K_OUTER:{
          jj_consume_token(K_OUTER);
join.setOuter(true);
          break;
          }
        default:
          jj_la1[198] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[199] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_JOIN:{
        jj_consume_token(K_JOIN);
        break;
        }
      case K_COMMA:{
        jj_consume_token(K_COMMA);
join.setSimple(true);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_OUTER:{
          jj_consume_token(K_OUTER);
join.setOuter(true);
          break;
          }
        default:
          jj_la1[200] = jj_gen;
          ;
        }
        break;
        }
      case K_STRAIGHT:{
        jj_consume_token(K_STRAIGHT);
join.setStraight(true);
        break;
        }
      case K_APPLY:{
        jj_consume_token(K_APPLY);
join.setApply(true);
        break;
        }
      default:
        jj_la1[201] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      right = FromItem();
      if (jj_2_72(2)) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ON:
        case K_WITHIN:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_WITHIN:{
            jj_consume_token(K_WITHIN);
            jj_consume_token(287);
            joinWindow = JoinWindow();
            jj_consume_token(288);
join.setJoinWindow(joinWindow);
            break;
            }
          default:
            jj_la1[202] = jj_gen;
            ;
          }
          jj_consume_token(K_ON);
          onExpression = Expression();
join.setOnExpression(onExpression);
          break;
          }
        case K_USING:{
          jj_consume_token(K_USING);
          jj_consume_token(287);
          tableColumn = Column();
columns = new ArrayList<Column>(); columns.add(tableColumn);
          label_55:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_COMMA:{
              ;
              break;
              }
            default:
              jj_la1[203] = jj_gen;
              break label_55;
            }
            jj_consume_token(K_COMMA);
            tableColumn = Column();
columns.add(tableColumn);
          }
          jj_consume_token(288);
join.setUsingColumns(columns);
          break;
          }
        default:
          jj_la1[204] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else {
        ;
      }
jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.jjtSetLastToken(getToken(0));
linkAST(join,jjtn000);
      join.setRightItem(right);
    return join;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public KSQLJoinWindow JoinWindow() throws ParseException {KSQLJoinWindow retval = new KSQLJoinWindow();
    boolean beforeAfter;
    Token beforeDurationToken = null;
    Token beforeTimeUnitToken = null;
    Token afterDurationToken = null;
    Token afterTimeUnitToken = null;
    beforeDurationToken = jj_consume_token(S_LONG);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_IDENTIFIER:{
      beforeTimeUnitToken = jj_consume_token(S_IDENTIFIER);
      break;
      }
    case K_DATE_LITERAL:{
      beforeTimeUnitToken = jj_consume_token(K_DATE_LITERAL);
      break;
      }
    default:
      jj_la1[205] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_COMMA:{
      jj_consume_token(K_COMMA);
      afterDurationToken = jj_consume_token(S_LONG);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        afterTimeUnitToken = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case K_DATE_LITERAL:{
        afterTimeUnitToken = jj_consume_token(K_DATE_LITERAL);
        break;
        }
      default:
        jj_la1[206] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[207] = jj_gen;
      ;
    }
if (afterDurationToken == null) {
            retval.setDuration(Long.parseLong(beforeDurationToken.image));
            retval.setTimeUnit(KSQLJoinWindow.TimeUnit.valueOf(beforeTimeUnitToken.image));
            retval.setBeforeAfterWindow(false);
            return retval;
        }
        retval.setBeforeDuration(Long.parseLong(beforeDurationToken.image));
        retval.setBeforeTimeUnit(KSQLJoinWindow.TimeUnit.valueOf(beforeTimeUnitToken.image));
        retval.setAfterDuration(Long.parseLong(afterDurationToken.image));
        retval.setAfterTimeUnit(KSQLJoinWindow.TimeUnit.valueOf(afterTimeUnitToken.image));
        retval.setBeforeAfterWindow(true);
        return retval;
}

  final public KSQLWindow KSQLWindowClause() throws ParseException {KSQLWindow retval = null;
    Token sizeDurationToken = null;
    Token sizeTimeUnitToken = null;
    Token advanceDurationToken = null;
    Token advanceTimeUnitToken = null;
    jj_consume_token(K_WINDOW);
retval=new KSQLWindow();
        retval.setHoppingWindow(false);
        retval.setSessionWindow(false);
        retval.setTumblingWindow(false);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_HOPPING:{
      jj_consume_token(K_HOPPING);
      jj_consume_token(287);
      jj_consume_token(K_SIZE);
      sizeDurationToken = jj_consume_token(S_LONG);
      sizeTimeUnitToken = jj_consume_token(S_IDENTIFIER);
      jj_consume_token(K_COMMA);
      jj_consume_token(K_ADVANCE);
      jj_consume_token(K_BY);
      advanceDurationToken = jj_consume_token(S_LONG);
      advanceTimeUnitToken = jj_consume_token(S_IDENTIFIER);
      jj_consume_token(288);
retval.setHoppingWindow(true);
      break;
      }
    case K_SESSION:{
      jj_consume_token(K_SESSION);
      jj_consume_token(287);
      sizeDurationToken = jj_consume_token(S_LONG);
      sizeTimeUnitToken = jj_consume_token(S_IDENTIFIER);
      jj_consume_token(288);
retval.setSessionWindow(true);
      break;
      }
    case K_TUMBLING:{
      jj_consume_token(K_TUMBLING);
      jj_consume_token(287);
      jj_consume_token(K_SIZE);
      sizeDurationToken = jj_consume_token(S_LONG);
      sizeTimeUnitToken = jj_consume_token(S_IDENTIFIER);
      jj_consume_token(288);
retval.setTumblingWindow(true);
      break;
      }
    default:
      jj_la1[208] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
retval.setSizeDuration(Long.parseLong(sizeDurationToken.image));
            retval.setSizeTimeUnit(KSQLWindow.TimeUnit.valueOf(sizeTimeUnitToken.image));
            if (advanceDurationToken != null) {
                retval.setAdvanceDuration(Long.parseLong(advanceDurationToken.image));
                retval.setAdvanceTimeUnit(KSQLWindow.TimeUnit.valueOf(advanceTimeUnitToken.image));
            }
            return retval;
}

  final public Expression WhereClause() throws ParseException {Expression retval = null;
    jj_consume_token(K_WHERE);
    retval = Expression();
return retval;
}

  final public OracleHierarchicalExpression OracleHierarchicalQueryClause() throws ParseException {OracleHierarchicalExpression result = new OracleHierarchicalExpression();
    Expression expr;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_START:{
      jj_consume_token(K_START);
      jj_consume_token(K_WITH);
      expr = AndExpression();
result.setStartExpression(expr);
      jj_consume_token(K_CONNECT);
      jj_consume_token(K_BY);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOCYCLE:{
        jj_consume_token(K_NOCYCLE);
result.setNoCycle(true);
        break;
        }
      default:
        jj_la1[209] = jj_gen;
        ;
      }
      expr = AndExpression();
result.setConnectExpression(expr);
      break;
      }
    case K_CONNECT:{
      jj_consume_token(K_CONNECT);
      jj_consume_token(K_BY);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOCYCLE:{
        jj_consume_token(K_NOCYCLE);
result.setNoCycle(true);
        break;
        }
      default:
        jj_la1[210] = jj_gen;
        ;
      }
      expr = AndExpression();
result.setConnectExpression(expr);
                    result.setConnectFirst(true);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_START:{
        jj_consume_token(K_START);
        jj_consume_token(K_WITH);
        expr = AndExpression();
result.setStartExpression(expr);
        break;
        }
      default:
        jj_la1[211] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[212] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return result;
}

  final public GroupByElement GroupByColumnReferences() throws ParseException {Expression columnReference;
    GroupByElement groupBy = new GroupByElement();
    Expression expr;
    ExpressionList list;
    jj_consume_token(K_GROUP);
    jj_consume_token(K_BY);
    if (jj_2_79(2)) {
      jj_consume_token(287);
      jj_consume_token(288);
groupBy.withUsingBrackets(true);
    } else if (jj_2_80(3)) {
      jj_consume_token(287);
      list = SimpleExpressionList(true);
      jj_consume_token(288);
groupBy.setGroupByExpressionList(list);
    } else if (jj_2_81(1)) {
      list = SimpleExpressionList(false);
groupBy.setGroupByExpressionList(list);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_GROUPING:{
        jj_consume_token(K_GROUPING);
        jj_consume_token(K_SETS);
        jj_consume_token(287);
        if (jj_2_73(2)) {
          jj_consume_token(287);
          jj_consume_token(288);
groupBy.addGroupingSet(new ExpressionList());
        } else if (jj_2_74(3)) {
          jj_consume_token(287);
          list = SimpleExpressionList(true);
          jj_consume_token(288);
groupBy.addGroupingSet(list);
        } else if (jj_2_75(1)) {
          expr = SimpleExpression();
groupBy.addGroupingSet(expr);
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
        label_56:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_COMMA:{
            ;
            break;
            }
          default:
            jj_la1[213] = jj_gen;
            break label_56;
          }
          jj_consume_token(K_COMMA);
          if (jj_2_76(2)) {
            jj_consume_token(287);
            jj_consume_token(288);
groupBy.addGroupingSet(new ExpressionList());
          } else if (jj_2_77(3)) {
            jj_consume_token(287);
            list = SimpleExpressionList(true);
            jj_consume_token(288);
groupBy.addGroupingSet(list);
          } else if (jj_2_78(1)) {
            expr = SimpleExpression();
groupBy.addGroupingSet(expr);
          } else {
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        jj_consume_token(288);
        break;
        }
      default:
        jj_la1[214] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return groupBy;
}

  final public Expression Having() throws ParseException {Expression having = null;
    jj_consume_token(K_HAVING);
    having = Expression();
return having;
}

  final public List<OrderByElement> OrderByElements() throws ParseException {List<OrderByElement> orderByList = new ArrayList<OrderByElement>();
    OrderByElement orderByElement = null;
    jj_consume_token(K_ORDER);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_SIBLINGS:{
      jj_consume_token(K_SIBLINGS);
      break;
      }
    default:
      jj_la1[215] = jj_gen;
      ;
    }
    jj_consume_token(K_BY);
    orderByElement = OrderByElement();
orderByList.add(orderByElement);
    label_57:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[216] = jj_gen;
        break label_57;
      }
      jj_consume_token(K_COMMA);
      orderByElement = OrderByElement();
orderByList.add(orderByElement);
    }
return orderByList;
}

  final public OrderByElement OrderByElement() throws ParseException {OrderByElement orderByElement = new OrderByElement();
    Expression columnReference = null;
    columnReference = Expression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ASC:
    case K_DESC:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ASC:{
        jj_consume_token(K_ASC);
        break;
        }
      case K_DESC:{
        jj_consume_token(K_DESC);
orderByElement.setAsc(false);
        break;
        }
      default:
        jj_la1[217] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
orderByElement.setAscDescPresent(true);
      break;
      }
    default:
      jj_la1[218] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_NULLS:{
      jj_consume_token(K_NULLS);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_FIRST:
      case K_LAST:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_FIRST:{
          jj_consume_token(K_FIRST);
orderByElement.setNullOrdering(OrderByElement.NullOrdering.NULLS_FIRST);
          break;
          }
        case K_LAST:{
          jj_consume_token(K_LAST);
orderByElement.setNullOrdering(OrderByElement.NullOrdering.NULLS_LAST);
          break;
          }
        default:
          jj_la1[219] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[220] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[221] = jj_gen;
      ;
    }
orderByElement.setExpression(columnReference);
        return orderByElement;
}

  final public JdbcParameter SimpleJdbcParameter() throws ParseException {JdbcParameter retval;
    jj_consume_token(293);
retval = new JdbcParameter(++jdbcParameterIndex, false);
    if (jj_2_82(2)) {
      token = jj_consume_token(S_LONG);
retval.setUseFixedIndex(true); retval.setIndex(Integer.valueOf(token.image));
    } else {
      ;
    }
return retval;
}

  final public JdbcNamedParameter SimpleJdbcNamedParameter() throws ParseException {String name;
    jj_consume_token(292);
    name = RelObjectNameExt();
return new JdbcNamedParameter(token.image);
}

  final public Limit LimitWithOffset() throws ParseException {/*@bgen(jjtree) LimitWithOffset */
    SimpleNode jjtn000 = new SimpleNode(JJTLIMITWITHOFFSET);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Limit limit = new Limit();
    Token token = null;
    String name;
    JdbcParameter jdbc = null;
    try {
      if (jj_2_85(5)) {
        jj_consume_token(K_LIMIT);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_LONG:{
          token = jj_consume_token(S_LONG);
limit.setOffset(new LongValue(token.image));
          break;
          }
        case 293:{
          jdbc = SimpleJdbcParameter();
limit.setOffset(jdbc);
          break;
          }
        case 292:{
          jj_consume_token(292);
limit.setOffset(new JdbcNamedParameter());
          if (jj_2_83(2)) {
            name = RelObjectNameExt();
((JdbcNamedParameter)limit.getOffset()).setName(name);
          } else {
            ;
          }
          break;
          }
        default:
          jj_la1[222] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(K_COMMA);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_LONG:{
          token = jj_consume_token(S_LONG);
limit.setRowCount(new LongValue(token.image));
          break;
          }
        case 293:{
          jdbc = SimpleJdbcParameter();
limit.setRowCount(jdbc);
          break;
          }
        case 292:{
          jj_consume_token(292);
limit.setRowCount(new JdbcNamedParameter());
          if (jj_2_84(2)) {
            name = RelObjectNameExt();
((JdbcNamedParameter)limit.getRowCount()).setName(name);
          } else {
            ;
          }
          break;
          }
        default:
          jj_la1[223] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_LIMIT:{
          limit = PlainLimit();
          break;
          }
        default:
          jj_la1[224] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
linkAST(limit,jjtn000);
        return limit;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Limit PlainLimit() throws ParseException {/*@bgen(jjtree) PlainLimit */
    SimpleNode jjtn000 = new SimpleNode(JJTPLAINLIMIT);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Limit limit = new Limit();
    Token token = null;
    JdbcParameter jdbc;
    String name;
    try {
      jj_consume_token(K_LIMIT);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_LONG:{
        token = jj_consume_token(S_LONG);
limit.setRowCount(new LongValue(token.image));
        break;
        }
      case 293:{
        jdbc = SimpleJdbcParameter();
limit.setRowCount(jdbc);
        break;
        }
      case 292:{
        jj_consume_token(292);
limit.setRowCount(new JdbcNamedParameter());
        if (jj_2_86(2)) {
          name = RelObjectNameExt();
((JdbcNamedParameter)limit.getRowCount()).setName(name);
        } else {
          ;
        }
        break;
        }
      case K_ALL:{
        jj_consume_token(K_ALL);
limit.setLimitAll(true);
        break;
        }
      case K_NULL:{
        jj_consume_token(K_NULL);
limit.setLimitNull(true);
        break;
        }
      default:
        jj_la1[225] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
linkAST(limit,jjtn000);
        return limit;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Offset Offset() throws ParseException {Offset offset = new Offset();
    Token token = null;
    JdbcParameter jdbc;
    JdbcNamedParameter jdbcNamed;
    jj_consume_token(K_OFFSET);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_LONG:{
      token = jj_consume_token(S_LONG);
offset.setOffset(Long.parseLong(token.image));
      break;
      }
    case 293:{
      jdbc = SimpleJdbcParameter();
offset.setOffsetJdbcParameter(jdbc);
      break;
      }
    case 292:{
      jdbcNamed = SimpleJdbcNamedParameter();
offset.setOffsetJdbcParameter(jdbcNamed);
      break;
      }
    default:
      jj_la1[226] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ROW:
    case K_ROWS:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ROWS:{
        jj_consume_token(K_ROWS);
offset.setOffsetParam("ROWS");
        break;
        }
      case K_ROW:{
        jj_consume_token(K_ROW);
offset.setOffsetParam("ROW");
        break;
        }
      default:
        jj_la1[227] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[228] = jj_gen;
      ;
    }
return offset;
}

  final public Fetch Fetch() throws ParseException {Fetch fetch = new Fetch();
    Token token = null;
    JdbcParameter jdbc;
    jj_consume_token(K_FETCH);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FIRST:{
      jj_consume_token(K_FIRST);
fetch.setFetchParamFirst(true);
      break;
      }
    case K_NEXT:{
      jj_consume_token(K_NEXT);
      break;
      }
    default:
      jj_la1[229] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_LONG:{
      token = jj_consume_token(S_LONG);
fetch.setRowCount(Long.parseLong(token.image));
      break;
      }
    case 293:{
      jdbc = SimpleJdbcParameter();
fetch.setFetchJdbcParameter(jdbc);
      break;
      }
    default:
      jj_la1[230] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ROWS:{
      jj_consume_token(K_ROWS);
fetch.setFetchParam("ROWS");
      break;
      }
    case K_ROW:{
      jj_consume_token(K_ROW);
      break;
      }
    default:
      jj_la1[231] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(K_ONLY);
return fetch;
}

  final public OptimizeFor OptimizeFor() throws ParseException {Token token;
    LongValue value;
    jj_consume_token(K_OPTIMIZE);
    jj_consume_token(K_FOR);
    token = jj_consume_token(S_LONG);
    jj_consume_token(K_ROWS);
value = new LongValue(token.image);
return new OptimizeFor(value.getValue());
}

// according to http://technet.microsoft.com/en-us/library/ms189463.aspx
  final public Top Top() throws ParseException {Top top = new Top();
    Token token = null;
    Expression expr = null;
    JdbcParameter jdbc = null;
    jj_consume_token(K_TOP);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_LONG:{
      token = jj_consume_token(S_LONG);
top.setExpression(new LongValue(token.image));
      break;
      }
    case 293:{
      jdbc = SimpleJdbcParameter();
top.setExpression(jdbc);
      break;
      }
    case 292:{
      jj_consume_token(292);
top.setExpression(new JdbcNamedParameter());
      if (jj_2_87(2)) {
        token = jj_consume_token(S_IDENTIFIER);
((JdbcNamedParameter)top.getExpression()).setName(token.image);
      } else {
        ;
      }
      break;
      }
    case 287:{
      jj_consume_token(287);
      expr = AdditiveExpression();
top.setExpression(expr);
top.setParenthesis(true);
      jj_consume_token(288);
      break;
      }
    default:
      jj_la1[232] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    if (jj_2_88(2)) {
      jj_consume_token(K_PERCENT);
top.setPercentage(true);
    } else {
      ;
    }
return top;
}

// according to http://www-01.ibm.com/support/knowledgecenter/SSGU8G_12.1.0/com.ibm.sqls.doc/ids_sqs_0156.htm
  final public Skip Skip() throws ParseException {Skip skip = new Skip();
    Token token = null;
    JdbcParameter jdbc;
    jj_consume_token(K_SKIP);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_LONG:{
      token = jj_consume_token(S_LONG);
skip.setRowCount(Long.parseLong(token.image));
      break;
      }
    case S_IDENTIFIER:{
      token = jj_consume_token(S_IDENTIFIER);
skip.setVariable(token.image);
      break;
      }
    case 293:{
      jdbc = SimpleJdbcParameter();
skip.setJdbcParameter(jdbc);
      break;
      }
    default:
      jj_la1[233] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return skip;
}

  OracleHint getOracleHint() throws ParseException {OracleHint hint = null;
  Token tok = getToken(1);
  // Retrieve first comment (if any) prior next token
  if (tok.specialToken != null) {
    tok = tok.specialToken;
    while (tok.specialToken != null) tok = tok.specialToken;
    // Check if it matches Hint pattern?
    if (OracleHint.isHintMatch(tok.image)) {
      hint = new OracleHint();
      hint.setComment(tok.image);
    }
  }
  return hint;
  }

  final public First First() throws ParseException {First first = new First();
    Token token = null;
    JdbcParameter jdbc;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FIRST:{
      jj_consume_token(K_FIRST);
first.setKeyword(First.Keyword.FIRST);
      break;
      }
    case K_LIMIT:{
      jj_consume_token(K_LIMIT);
first.setKeyword(First.Keyword.LIMIT);
      break;
      }
    default:
      jj_la1[234] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_LONG:{
      token = jj_consume_token(S_LONG);
first.setRowCount(Long.parseLong(token.image));
      break;
      }
    case S_IDENTIFIER:{
      token = jj_consume_token(S_IDENTIFIER);
first.setVariable(token.image);
      break;
      }
    case 293:{
      jdbc = SimpleJdbcParameter();
first.setJdbcParameter(jdbc);
      break;
      }
    default:
      jj_la1[235] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return first;
}

  final public Expression Expression() throws ParseException {/*@bgen(jjtree) Expression */
    SimpleNode jjtn000 = new SimpleNode(JJTEXPRESSION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Expression retval = null;
    try {
      retval = XorExpression();
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
return retval;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Expression XorExpression() throws ParseException {Expression left, right, result;
    left = OrExpression();
result = left;
    label_58:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_XOR:{
        ;
        break;
        }
      default:
        jj_la1[236] = jj_gen;
        break label_58;
      }
      jj_consume_token(K_XOR);
      right = OrExpression();
result = new XorExpression(left, right);
            left = result;
    }
return result;
}

  final public Expression OrExpression() throws ParseException {Expression left, right, result;
    left = AndExpression();
result = left;
    label_59:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_OR:{
        ;
        break;
        }
      default:
        jj_la1[237] = jj_gen;
        break label_59;
      }
      jj_consume_token(K_OR);
      right = AndExpression();
result = new OrExpression(left, right);
            left = result;
    }
return result;
}

  final public Expression AndExpression() throws ParseException {Expression left, right, result;
    boolean not = false;
        boolean exclamationMarkNot=false;
    if (jj_2_89(2147483647)) {
      left = Condition();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOT:
      case 287:
      case 294:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_NOT:
        case 294:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_NOT:{
            jj_consume_token(K_NOT);
not=true;
            break;
            }
          case 294:{
            jj_consume_token(294);
not=true; exclamationMarkNot=true;
            break;
            }
          default:
            jj_la1[238] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        default:
          jj_la1[239] = jj_gen;
          ;
        }
        jj_consume_token(287);
        left = XorExpression();
        jj_consume_token(288);
left = new Parenthesis(left); if (not) { left = new NotExpression(left, exclamationMarkNot); not = false; }
        break;
        }
      default:
        jj_la1[240] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
result = left;
    label_60:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_AND:
      case K_AND_OPERATOR:{
        ;
        break;
        }
      default:
        jj_la1[241] = jj_gen;
        break label_60;
      }
boolean useOperator = false;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_AND:{
        jj_consume_token(K_AND);
        break;
        }
      case K_AND_OPERATOR:{
        jj_consume_token(K_AND_OPERATOR);
useOperator=true;
        break;
        }
      default:
        jj_la1[242] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      if (jj_2_90(2147483647)) {
        right = Condition();
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_NOT:
        case 287:
        case 294:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_NOT:
          case 294:{
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_NOT:{
              jj_consume_token(K_NOT);
not=true;
              break;
              }
            case 294:{
              jj_consume_token(294);
not=true; exclamationMarkNot=true;
              break;
              }
            default:
              jj_la1[243] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            break;
            }
          default:
            jj_la1[244] = jj_gen;
            ;
          }
          jj_consume_token(287);
          right = XorExpression();
          jj_consume_token(288);
right = new Parenthesis(right); if (not) { right = new NotExpression(right, exclamationMarkNot); not = false; }
          break;
          }
        default:
          jj_la1[245] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
result = new AndExpression(left, right);
            ((AndExpression)result).setUseOperator(useOperator);
            left = result;
    }
return result;
}

  final public Expression Condition() throws ParseException {Expression result;
    Token token;
    boolean not = false;
        boolean exclamationMarkNot = false;
    if (jj_2_91(2)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOT:{
        jj_consume_token(K_NOT);
not=true;
        break;
        }
      case 294:{
        jj_consume_token(294);
not=true; exclamationMarkNot=true;
        break;
        }
      default:
        jj_la1[246] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      ;
    }
    if (jj_2_92(2147483647)) {
      result = RegularCondition();
    } else if (jj_2_93(1)) {
      result = SQLCondition();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
return not?new NotExpression(result, exclamationMarkNot):result;
}

  final public Expression RegularCondition() throws ParseException {/*@bgen(jjtree) RegularCondition */
    SimpleNode jjtn000 = new SimpleNode(JJTREGULARCONDITION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Expression result = null;
    Expression leftExpression;
    Expression rightExpression;
    int oracleJoin=EqualsTo.NO_ORACLE_JOIN;
    int oraclePrior=EqualsTo.NO_ORACLE_PRIOR;
    boolean binary = false;
    boolean not = false;
    try {
      if (jj_2_94(2)) {
        jj_consume_token(K_PRIOR);
oraclePrior = EqualsTo.ORACLE_PRIOR_START;
      } else {
        ;
      }
      leftExpression = ComparisonItem();
result = leftExpression;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 287:{
        jj_consume_token(287);
        jj_consume_token(295);
        jj_consume_token(288);
oracleJoin=EqualsTo.ORACLE_JOIN_RIGHT;
        break;
        }
      default:
        jj_la1[247] = jj_gen;
        ;
      }
      if (jj_2_95(2)) {
        jj_consume_token(296);
result = new GreaterThan();
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 297:{
          jj_consume_token(297);
result = new MinorThan();
          break;
          }
        case 289:{
          jj_consume_token(289);
result = new EqualsTo();
          break;
          }
        case OP_GREATERTHANEQUALS:{
          token = jj_consume_token(OP_GREATERTHANEQUALS);
result = new GreaterThanEquals(token.image);
          break;
          }
        case OP_MINORTHANEQUALS:{
          token = jj_consume_token(OP_MINORTHANEQUALS);
result = new MinorThanEquals(token.image);
          break;
          }
        case OP_NOTEQUALSSTANDARD:{
          token = jj_consume_token(OP_NOTEQUALSSTANDARD);
result = new NotEqualsTo(token.image);
          break;
          }
        case OP_NOTEQUALSBANG:{
          token = jj_consume_token(OP_NOTEQUALSBANG);
result = new NotEqualsTo(token.image);
          break;
          }
        case 298:{
          jj_consume_token(298);
result = new Matches();
          break;
          }
        case 299:{
          jj_consume_token(299);
result = new RegExpMatchOperator(RegExpMatchOperatorType.MATCH_CASESENSITIVE);
          break;
          }
        case K_NOT:
        case K_REGEXP:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_NOT:{
            jj_consume_token(K_NOT);
not=true;
            break;
            }
          default:
            jj_la1[248] = jj_gen;
            ;
          }
          jj_consume_token(K_REGEXP);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_BINARY:{
            jj_consume_token(K_BINARY);
binary=true;
            break;
            }
          default:
            jj_la1[249] = jj_gen;
            ;
          }
result = new RegExpMySQLOperator(not, binary?RegExpMatchOperatorType.MATCH_CASESENSITIVE:RegExpMatchOperatorType.MATCH_CASEINSENSITIVE);
          break;
          }
        case K_RLIKE:{
          jj_consume_token(K_RLIKE);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_BINARY:{
            jj_consume_token(K_BINARY);
binary=true;
            break;
            }
          default:
            jj_la1[250] = jj_gen;
            ;
          }
result = new RegExpMySQLOperator(binary?RegExpMatchOperatorType.MATCH_CASESENSITIVE:RegExpMatchOperatorType.MATCH_CASEINSENSITIVE).useRLike();
          break;
          }
        case 300:{
          jj_consume_token(300);
result = new RegExpMatchOperator(RegExpMatchOperatorType.MATCH_CASEINSENSITIVE);
          break;
          }
        case 301:{
          jj_consume_token(301);
result = new RegExpMatchOperator(RegExpMatchOperatorType.NOT_MATCH_CASESENSITIVE);
          break;
          }
        case 302:{
          jj_consume_token(302);
result = new RegExpMatchOperator(RegExpMatchOperatorType.NOT_MATCH_CASEINSENSITIVE);
          break;
          }
        case 303:{
          jj_consume_token(303);
result = new JsonOperator("@>");
          break;
          }
        case 304:{
          jj_consume_token(304);
result = new JsonOperator("<@");
          break;
          }
        case 293:{
          jj_consume_token(293);
result = new JsonOperator("?");
          break;
          }
        case 305:{
          jj_consume_token(305);
result = new JsonOperator("?|");
          break;
          }
        case 306:{
          jj_consume_token(306);
result = new JsonOperator("?&");
          break;
          }
        case OP_CONCAT:{
          jj_consume_token(OP_CONCAT);
result = new JsonOperator("||");
          break;
          }
        case 307:{
          jj_consume_token(307);
result = new JsonOperator("-");
          break;
          }
        case 308:{
          jj_consume_token(308);
result = new JsonOperator("-#");
          break;
          }
        default:
          jj_la1[251] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      if (jj_2_96(2)) {
        jj_consume_token(K_PRIOR);
        rightExpression = ComparisonItem();
oraclePrior = EqualsTo.ORACLE_PRIOR_END;
      } else if (jj_2_97(1)) {
        rightExpression = ComparisonItem();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
      if (jj_2_98(2)) {
        jj_consume_token(287);
        jj_consume_token(295);
        jj_consume_token(288);
oracleJoin=EqualsTo.ORACLE_JOIN_LEFT;
      } else {
        ;
      }
BinaryExpression regCond = (BinaryExpression) result;
        regCond.setLeftExpression(leftExpression);
        regCond.setRightExpression(rightExpression);

        if (oracleJoin>0)
            ((SupportsOldOracleJoinSyntax)result).setOldOracleJoinSyntax(oracleJoin);

        if (oraclePrior!=EqualsTo.NO_ORACLE_PRIOR)
            ((SupportsOldOracleJoinSyntax)result).setOraclePriorPosition(oraclePrior);
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
linkAST(result,jjtn000);
        return result;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Expression SQLCondition() throws ParseException {Expression result;
    Expression left;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_EXISTS:{
      result = ExistsExpression();
      break;
      }
    default:
      jj_la1[253] = jj_gen;
      if (jj_2_104(2147483647)) {
        result = InExpression();
      } else if (jj_2_105(1)) {
        left = SimpleExpression();
result = left;
        if (jj_2_103(2)) {
          if (jj_2_99(2)) {
            result = Between(left);
          } else if (jj_2_100(2147483647)) {
            result = IsNullExpression(left);
          } else if (jj_2_101(2147483647)) {
            result = IsBooleanExpression(left);
          } else if (jj_2_102(2)) {
            result = LikeExpression(left);
          } else {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_NOT:
            case K_SIMILAR:{
              result = SimilarToExpression(left);
              break;
              }
            default:
              jj_la1[252] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
        } else {
          ;
        }
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return result;
}

  final public Expression InExpression() throws ParseException {/*@bgen(jjtree) InExpression */
    SimpleNode jjtn000 = new SimpleNode(JJTINEXPRESSION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));InExpression result = new InExpression();
    ItemsList leftItemsList = null;
    ItemsList rightItemsList = null;
    Expression leftExpression = null;
    Expression rightExpression = null;
    Token token;
    MultiExpressionList multiExpressionList = null;
    ExpressionList expressionList = null;
    try {
      leftExpression = SimpleExpression();
result.setLeftExpression(leftExpression);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 287:{
        jj_consume_token(287);
        jj_consume_token(295);
        jj_consume_token(288);
result.setOldOracleJoinSyntax(EqualsTo.ORACLE_JOIN_RIGHT);
        break;
        }
      default:
        jj_la1[254] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOT:{
        jj_consume_token(K_NOT);
result.setNot(true);
        break;
        }
      default:
        jj_la1[255] = jj_gen;
        ;
      }
      jj_consume_token(K_IN);
      if (jj_2_108(3)) {
        multiExpressionList = MultiInExpressions();
      } else if (jj_2_109(3)) {
        rightExpression = Function();
      } else if (jj_2_110(2)) {
        token = jj_consume_token(S_CHAR_LITERAL);
rightExpression = new StringValue(token.image);
      } else if (jj_2_111(3)) {
        jj_consume_token(287);
        if (jj_2_106(3)) {
          rightItemsList = SubSelect();
        } else if (jj_2_107(1)) {
          rightItemsList = SimpleExpressionList(true);
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(288);
      } else if (jj_2_112(1)) {
        rightExpression = SimpleExpression();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
result.setRightItemsList(rightItemsList);
        result.setRightExpression(rightExpression);
        result.setMultiExpressionList(multiExpressionList);
        linkAST(result,jjtn000);
        return result;
    } catch (Throwable jjte000) {
if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
            jjtn000.jjtSetLastToken(getToken(0));
          }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public MultiExpressionList MultiInExpressions() throws ParseException {MultiExpressionList multiExpressionList = null;
   ExpressionList expressionList = null;
    jj_consume_token(287);
    jj_consume_token(287);
    expressionList = SimpleExpressionList(true);
if(multiExpressionList == null) {
         multiExpressionList = new MultiExpressionList();
       }
       multiExpressionList.addExpressionList(expressionList);
    label_61:
    while (true) {
      if (jj_2_113(3)) {
        ;
      } else {
        break label_61;
      }
      jj_consume_token(288);
      jj_consume_token(K_COMMA);
      jj_consume_token(287);
      expressionList = SimpleExpressionList(true);
if(multiExpressionList == null) {
          multiExpressionList = new MultiExpressionList();
       }
       multiExpressionList.addExpressionList(expressionList);
    }
    jj_consume_token(288);
    jj_consume_token(288);
return multiExpressionList;
}

  final public Expression Between(Expression leftExpression) throws ParseException {Between result = new Between();
    Expression betweenExpressionStart = null;
    Expression betweenExpressionEnd = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_NOT:{
      jj_consume_token(K_NOT);
result.setNot(true);
      break;
      }
    default:
      jj_la1[256] = jj_gen;
      ;
    }
    jj_consume_token(K_BETWEEN);
    betweenExpressionStart = SimpleExpression();
    jj_consume_token(K_AND);
    betweenExpressionEnd = SimpleExpression();
result.setLeftExpression(leftExpression);
        result.setBetweenExpressionStart(betweenExpressionStart);
        result.setBetweenExpressionEnd(betweenExpressionEnd);
        return result;
}

  final public Expression LikeExpression(Expression leftExpression) throws ParseException {/*@bgen(jjtree) LikeExpression */
    SimpleNode jjtn000 = new SimpleNode(JJTLIKEEXPRESSION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));LikeExpression result = new LikeExpression();
    Expression rightExpression = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOT:{
        jj_consume_token(K_NOT);
result.setNot(true);
        break;
        }
      default:
        jj_la1[257] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_LIKE:{
        jj_consume_token(K_LIKE);
        break;
        }
      case K_ILIKE:{
        jj_consume_token(K_ILIKE);
result.setCaseInsensitive(true);
        break;
        }
      default:
        jj_la1[258] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      rightExpression = SimpleExpression();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ESCAPE:{
        jj_consume_token(K_ESCAPE);
        token = jj_consume_token(S_CHAR_LITERAL);
result.setEscape((new StringValue(token.image)).getValue());
        break;
        }
      default:
        jj_la1[259] = jj_gen;
        ;
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
result.setLeftExpression(leftExpression);
        result.setRightExpression(rightExpression);
        linkAST(result,jjtn000);
        return result;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Expression SimilarToExpression(Expression leftExpression) throws ParseException {/*@bgen(jjtree) SimilarToExpression */
    SimpleNode jjtn000 = new SimpleNode(JJTSIMILARTOEXPRESSION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));SimilarToExpression result = new SimilarToExpression();
    Expression rightExpression = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOT:{
        jj_consume_token(K_NOT);
result.setNot(true);
        break;
        }
      default:
        jj_la1[260] = jj_gen;
        ;
      }
      jj_consume_token(K_SIMILAR);
      jj_consume_token(K_TO);
      rightExpression = SimpleExpression();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ESCAPE:{
        jj_consume_token(K_ESCAPE);
        token = jj_consume_token(S_CHAR_LITERAL);
result.setEscape((new StringValue(token.image)).getValue());
        break;
        }
      default:
        jj_la1[261] = jj_gen;
        ;
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
result.setLeftExpression(leftExpression);
        result.setRightExpression(rightExpression);
        linkAST(result,jjtn000);
        return result;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Expression IsNullExpression(Expression leftExpression) throws ParseException {IsNullExpression result = new IsNullExpression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ISNULL:{
      jj_consume_token(K_ISNULL);
result.setUseIsNull(true);
      break;
      }
    case K_IS:{
      jj_consume_token(K_IS);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOT:{
        jj_consume_token(K_NOT);
result.setNot(true);
        break;
        }
      default:
        jj_la1[262] = jj_gen;
        ;
      }
      jj_consume_token(K_NULL);
      break;
      }
    default:
      jj_la1[263] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
result.setLeftExpression(leftExpression);
        return result;
}

  final public Expression IsBooleanExpression(Expression leftExpression) throws ParseException {IsBooleanExpression result = new IsBooleanExpression();
    jj_consume_token(K_IS);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_NOT:{
      jj_consume_token(K_NOT);
result.setNot(true);
      break;
      }
    default:
      jj_la1[264] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_TRUE:{
      jj_consume_token(K_TRUE);
result.setIsTrue(true);
      break;
      }
    case K_FALSE:{
      jj_consume_token(K_FALSE);
result.setIsTrue(false);
      break;
      }
    default:
      jj_la1[265] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
result.setLeftExpression(leftExpression);
        return result;
}

  final public Expression ExistsExpression() throws ParseException {ExistsExpression result = new ExistsExpression();
    Expression rightExpression = null;
    jj_consume_token(K_EXISTS);
    rightExpression = SimpleExpression();
result.setRightExpression(rightExpression);
        return result;
}

  final public ExpressionList SQLExpressionList() throws ParseException {ExpressionList retval = new ExpressionList();
    List<Expression> expressions = new ArrayList<Expression>();
    Expression expr = null;
    expr = Expression();
expressions.add(expr);
    label_62:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[266] = jj_gen;
        break label_62;
      }
      jj_consume_token(K_COMMA);
      expr = Expression();
expressions.add(expr);
    }
retval.setExpressions(expressions);
        return retval;
}

  final public ExpressionList SimpleExpressionList(boolean outerBrackets) throws ParseException {/*@bgen(jjtree) ExpressionList */
    SimpleNode jjtn000 = new SimpleNode(JJTEXPRESSIONLIST);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));ExpressionList retval = new ExpressionList().withBrackets(outerBrackets);
    List<Expression> expressions = new ArrayList<Expression>();
    Expression expr = null;
    try {
      expr = SimpleExpression();
expressions.add(expr);
      label_63:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[267] = jj_gen;
          break label_63;
        }
        jj_consume_token(K_COMMA);
        expr = SimpleExpression();
expressions.add(expr);
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
retval.setExpressions(expressions);
        return retval;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public ExpressionList ComplexExpressionList() throws ParseException {/*@bgen(jjtree) ExpressionList */
    SimpleNode jjtn000 = new SimpleNode(JJTEXPRESSIONLIST);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));ExpressionList retval = new ExpressionList();
    List<Expression> expressions = new ArrayList<Expression>();
    Expression expr = null;
    try {
      expr = Expression();
expressions.add(expr);
      label_64:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[268] = jj_gen;
          break label_64;
        }
        jj_consume_token(K_COMMA);
        expr = Expression();
expressions.add(expr);
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
retval.setExpressions(expressions);
        return retval;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

// trim( [leading|trailing|both] expr from expr)
// The [leading|trailing|both] token has already been consumed
  final public NamedExpressionList NamedExpressionList1() throws ParseException {NamedExpressionList retval = new NamedExpressionList();
    List<Expression> expressions = new ArrayList<Expression>();
    List<String> names = new ArrayList<String>();
    Expression expr1 = null;
    Expression expr2 = null;
        String name = "";
    Token tk1 = null;
    Token tk2 = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_BOTH:{
      tk1 = jj_consume_token(K_BOTH);
      break;
      }
    case K_LEADING:{
      tk1 = jj_consume_token(K_LEADING);
      break;
      }
    case K_TRAILING:{
      tk1 = jj_consume_token(K_TRAILING);
      break;
      }
    default:
      jj_la1[269] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
names.add(tk1.image);
    expr1 = SimpleExpression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FROM:{
      tk2 = jj_consume_token(K_FROM);
      break;
      }
    case K_IN:{
      tk2 = jj_consume_token(K_IN);
      break;
      }
    case K_PLACING:{
      tk2 = jj_consume_token(K_PLACING);
      break;
      }
    default:
      jj_la1[270] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    expr2 = SimpleExpression();
expressions.add(expr1); names.add(tk2.image); expressions.add(expr2);
retval.setNames(names);
        retval.setExpressions(expressions);
        return retval;
}

// substring(expr1 from expr2)
// substring(expr1 from expr2 for expr3)
// trim(expr1 from expr2)
// position(expr1 in expr2)
// overlay(expr1 placing expr2 from expr3)
// overlay(expr1 placing expr2 from expr3 for expr4)
// expr1 has already been consumed
  final public NamedExpressionList NamedExpressionListExprFirst() throws ParseException {NamedExpressionList retval = new NamedExpressionList();
    List<Expression> expressions = new ArrayList<Expression>();
    List<String> names = new ArrayList<String>();
    Expression expr1 = null;
    Expression expr2 = null;
    Expression expr3 = null;
    Expression expr4 = null;
    Token tk2 = null;
    Token tk3 = null;
    Token tk4 = null;
    expr1 = SimpleExpression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FROM:{
      tk2 = jj_consume_token(K_FROM);
      break;
      }
    case K_IN:{
      tk2 = jj_consume_token(K_IN);
      break;
      }
    case K_PLACING:{
      tk2 = jj_consume_token(K_PLACING);
      break;
      }
    default:
      jj_la1[271] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
names.add("");
                expressions.add(expr1);
                names.add(tk2.image);
    expr2 = SimpleExpression();
expressions.add(expr2);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FOR:
    case K_FROM:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_FOR:{
        tk3 = jj_consume_token(K_FOR);
        break;
        }
      case K_FROM:{
        tk3 = jj_consume_token(K_FROM);
        break;
        }
      default:
        jj_la1[272] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      expr3 = SimpleExpression();
names.add(tk3.image); expressions.add(expr3);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_FOR:{
        tk4 = jj_consume_token(K_FOR);
        expr4 = SimpleExpression();
names.add(tk4.image); expressions.add(expr4);
        break;
        }
      default:
        jj_la1[273] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[274] = jj_gen;
      ;
    }
retval.setNames(names);
        retval.setExpressions(expressions);
        return retval;
}

  final public ExpressionList SimpleExpressionListAtLeastTwoItems() throws ParseException {ExpressionList retval = new ExpressionList();
    List<Expression> expressions = new ArrayList<Expression>();
    Expression expr = null;
    expr = SimpleExpression();
expressions.add(expr);
    label_65:
    while (true) {
      jj_consume_token(K_COMMA);
      expr = SimpleExpression();
expressions.add(expr);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[275] = jj_gen;
        break label_65;
      }
    }
retval.setExpressions(expressions);
        return retval;
}

  final public Expression ComparisonItem() throws ParseException {Expression retval = null;
    if (jj_2_114(3)) {
      retval = AllComparisonExpression();
    } else if (jj_2_115(3)) {
      retval = AnyComparisonExpression();
    } else if (jj_2_116(2147483647)) {
      retval = ValueListExpression();
    } else if (jj_2_117(3)) {
      retval = SimpleExpression();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ROW:
      case 287:{
        retval = RowConstructor();
        break;
        }
      default:
        jj_la1[276] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return retval;
}

  final public Expression AllComparisonExpression() throws ParseException {AllComparisonExpression retval = null;
    SubSelect subselect = null;
    jj_consume_token(K_ALL);
    jj_consume_token(287);
    subselect = SubSelect();
    jj_consume_token(288);
retval = new AllComparisonExpression(subselect);
return retval;
}

  final public Expression AnyComparisonExpression() throws ParseException {AnyComparisonExpression retval = null;
    AnyType anyType;
    SubSelect subselect = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ANY:{
      jj_consume_token(K_ANY);
anyType = AnyType.ANY;
      break;
      }
    case K_SOME:{
      jj_consume_token(K_SOME);
anyType = AnyType.SOME;
      break;
      }
    default:
      jj_la1[277] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(287);
    subselect = SubSelect();
    jj_consume_token(288);
retval = new AnyComparisonExpression(anyType, subselect);
return retval;
}

  final public Expression SimpleExpression() throws ParseException {Expression retval = null;
    UserVariable user = null;
    Token operation = null;
    if (jj_2_118(2147483647)) {
      user = UserVariable();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 289:{
        operation = jj_consume_token(289);
        break;
        }
      case 309:{
        operation = jj_consume_token(309);
        break;
        }
      default:
        jj_la1[278] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      ;
    }
    retval = ConcatExpression();
if (user != null) {
            VariableAssignment assignment = new VariableAssignment();
            assignment.setVariable(user);
            assignment.setOperation(operation.image);
            assignment.setExpression(retval);
            return assignment;
        } else
            return retval;
}

  final public Expression ConcatExpression() throws ParseException {Expression result = null;
    Expression leftExpression = null;
    Expression rightExpression = null;
    leftExpression = BitwiseAndOr();
result = leftExpression;
    label_66:
    while (true) {
      if (jj_2_119(3)) {
        ;
      } else {
        break label_66;
      }
      jj_consume_token(OP_CONCAT);
      /* Oracle allows space between the bars. */
              rightExpression = BitwiseAndOr();
Concat binExp = new Concat();
            binExp.setLeftExpression(leftExpression);
            binExp.setRightExpression(rightExpression);
            result = binExp;
            leftExpression = result;
    }
return result;
}

  final public Expression BitwiseAndOr() throws ParseException {Expression result = null;
    Expression leftExpression = null;
    Expression rightExpression = null;
    leftExpression = AdditiveExpression();
result = leftExpression;
    label_67:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 310:
      case 311:
      case 312:
      case 313:{
        ;
        break;
        }
      default:
        jj_la1[279] = jj_gen;
        break label_67;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 310:{
        jj_consume_token(310);
result = new BitwiseOr();
        break;
        }
      case 311:{
        jj_consume_token(311);
result = new BitwiseAnd();
        break;
        }
      case 312:{
        jj_consume_token(312);
result = new BitwiseLeftShift();
        break;
        }
      case 313:{
        jj_consume_token(313);
result = new BitwiseRightShift();
        break;
        }
      default:
        jj_la1[280] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      rightExpression = AdditiveExpression();
BinaryExpression binExp = (BinaryExpression) result;
            binExp.setLeftExpression(leftExpression);
            binExp.setRightExpression(rightExpression);
            leftExpression = result;
    }
return result;
}

  final public Expression AdditiveExpression() throws ParseException {Expression result = null;
    Expression leftExpression = null;
    Expression rightExpression = null;
    leftExpression = MultiplicativeExpression();
result = leftExpression;
    label_68:
    while (true) {
      if (jj_2_120(2)) {
        ;
      } else {
        break label_68;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 295:{
        jj_consume_token(295);
result = new Addition();
        break;
        }
      case 307:{
        jj_consume_token(307);
result = new Subtraction();
        break;
        }
      default:
        jj_la1[281] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      rightExpression = MultiplicativeExpression();
BinaryExpression binExp = (BinaryExpression) result;
            binExp.setLeftExpression(leftExpression);
            binExp.setRightExpression(rightExpression);
            leftExpression = result;
    }
return result;
}

  final public Expression MultiplicativeExpression() throws ParseException {Expression result = null;
    Expression leftExpression = null;
    Expression rightExpression = null;
    leftExpression = BitwiseXor();
result = leftExpression;
    label_69:
    while (true) {
      if (jj_2_121(2)) {
        ;
      } else {
        break label_69;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 290:{
        jj_consume_token(290);
result = new Multiplication();
        break;
        }
      case 314:{
        jj_consume_token(314);
result = new Division();
        break;
        }
      case K_DIV:{
        jj_consume_token(K_DIV);
result = new IntegerDivision();
        break;
        }
      case 315:{
        jj_consume_token(315);
result = new Modulo();
        break;
        }
      default:
        jj_la1[282] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      rightExpression = BitwiseXor();
BinaryExpression binExp = (BinaryExpression) result;
            binExp.setLeftExpression(leftExpression);
            binExp.setRightExpression(rightExpression);
            leftExpression = result;
    }
return result;
}

  final public Expression BitwiseXor() throws ParseException {Expression result = null;
    Expression leftExpression = null;
    Expression rightExpression = null;
    leftExpression = PrimaryExpression();
result = leftExpression;
    label_70:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 316:{
        ;
        break;
        }
      default:
        jj_la1[283] = jj_gen;
        break label_70;
      }
      jj_consume_token(316);
      rightExpression = PrimaryExpression();
BitwiseXor binExp = new BitwiseXor();
            binExp.setLeftExpression(leftExpression);
            binExp.setRightExpression(rightExpression);
            result = binExp;
            leftExpression = result;
    }
return result;
}

  final public Expression ArrayExpression(Expression obj) throws ParseException {Expression idxExpr = null;
    Expression startExpr = null;
    Expression stopExpr = null;
    jj_consume_token(317);
    if (jj_2_122(3)) {
      idxExpr = SimpleExpression();
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 292:{
      jj_consume_token(292);
startExpr=idxExpr; idxExpr=null;
      if (jj_2_123(1)) {
        stopExpr = SimpleExpression();
      } else {
        ;
      }
      break;
      }
    default:
      jj_la1[284] = jj_gen;
      ;
    }
    jj_consume_token(318);
return new ArrayExpression(obj, idxExpr, startExpr, stopExpr);
}

  final public Expression PrimaryExpression() throws ParseException {/*@bgen(jjtree) PrimaryExpression */
    SimpleNode jjtn000 = new SimpleNode(JJTPRIMARYEXPRESSION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Expression retval = null;
    CastExpression castExpr = null;
    TimezoneExpression timezoneExpr = null;
    Token token = null;
    Token sign = null;
    String tmp = "";
    ColDataType type = null;
    boolean not = false;
    boolean exclamationMarkNot = false;
    boolean dateExpressionAllowed = true;
    ExpressionList list;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOT:
      case 294:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_NOT:{
          jj_consume_token(K_NOT);
not=true;
          break;
          }
        case 294:{
          jj_consume_token(294);
not=true; exclamationMarkNot=true;
          break;
          }
        default:
          jj_la1[285] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[286] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 295:
      case 299:
      case 307:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 295:{
          sign = jj_consume_token(295);
          break;
          }
        case 307:{
          sign = jj_consume_token(307);
          break;
          }
        case 299:{
          sign = jj_consume_token(299);
          break;
          }
        default:
          jj_la1[287] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[288] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NULL:{
        jj_consume_token(K_NULL);
retval = new NullValue();
        break;
        }
      default:
        jj_la1[292] = jj_gen;
        if (jj_2_126(3)) {
          retval = CaseWhenExpression();
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 293:{
            retval = SimpleJdbcParameter();
            break;
            }
          default:
            jj_la1[293] = jj_gen;
            if (jj_2_127(2)) {
              retval = JdbcNamedParameter();
            } else {
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case 298:
              case 324:{
                retval = UserVariable();
                break;
                }
              default:
                jj_la1[294] = jj_gen;
                if (jj_2_128(2)) {
                  retval = NumericBind();
                } else if (jj_2_129(3)) {
                  retval = ExtractExpression();
                } else {
                  switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                  case K_GROUP_CONCAT:{
                    retval = MySQLGroupConcat();
                    break;
                    }
                  case K_XMLSERIALIZE:{
                    retval = XMLSerializeExpr();
                    break;
                    }
                  default:
                    jj_la1[295] = jj_gen;
                    if (jj_2_130(2147483647)) {
                      retval = JsonExpression();
                    } else if (jj_2_131(2147483647)) {
                      retval = FullTextSearch();
                    } else if (jj_2_132(2147483647)) {
                      retval = Function();
                      if (jj_2_124(2)) {
                        retval = AnalyticExpression((Function)retval);
                      } else {
                        ;
                      }
                    } else if (jj_2_133(2)) {
                      retval = IntervalExpression();
dateExpressionAllowed = false;
                    } else {
                      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                      case S_DOUBLE:{
                        token = jj_consume_token(S_DOUBLE);
retval = new DoubleValue(token.image);
                        break;
                        }
                      case S_LONG:{
                        token = jj_consume_token(S_LONG);
retval = new LongValue(token.image);
                        break;
                        }
                      case S_HEX:{
                        token = jj_consume_token(S_HEX);
retval = new HexValue(token.image);
                        break;
                        }
                      default:
                        jj_la1[296] = jj_gen;
                        if (jj_2_134(2)) {
                          retval = CastExpression();
                        } else {
                          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                          case K_CURRENT:
                          case K_TIME_KEY_EXPR:{
                            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                            case K_TIME_KEY_EXPR:{
                              token = jj_consume_token(K_TIME_KEY_EXPR);
                              break;
                              }
                            case K_CURRENT:{
                              token = jj_consume_token(K_CURRENT);
                              break;
                              }
                            default:
                              jj_la1[289] = jj_gen;
                              jj_consume_token(-1);
                              throw new ParseException();
                            }
retval = new TimeKeyExpression(token.image);
                            break;
                            }
                          default:
                            jj_la1[297] = jj_gen;
                            if (jj_2_135(2)) {
                              retval = DateTimeLiteralExpression();
                            } else if (jj_2_136(2)) {
                              jj_consume_token(K_ARRAY_LITERAL);
                              retval = ArrayConstructor(true);
                            } else if (jj_2_137(2)) {
                              retval = NextValExpression();
                            } else {
                              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                              case K_ACTION:
                              case K_ALGORITHM:
                              case K_ALL:
                              case K_ANY:
                              case K_ARRAY_LITERAL:
                              case K_BYTE:
                              case K_CASCADE:
                              case K_CASE:
                              case K_CASEWHEN:
                              case K_CAST:
                              case K_CHARACTER:
                              case K_CHANGE:
                              case K_CHAR:
                              case K_COLUMN:
                              case K_COLUMNS:
                              case K_COMMIT:
                              case K_COMMENT:
                              case K_COSTS:
                              case K_CREATE:
                              case K_CYCLE:
                              case K_DATETIMELITERAL:
                              case K_DATE_LITERAL:
                              case K_DESC:
                              case K_DESCRIBE:
                              case K_DISABLE:
                              case K_DIV:
                              case K_DO:
                              case K_DOUBLE:
                              case K_DUPLICATE:
                              case K_ENABLE:
                              case K_END:
                              case K_EXCLUDE:
                              case K_EXTRACT:
                              case K_FIRST:
                              case K_FALSE:
                              case K_FOLLOWING:
                              case K_FORMAT:
                              case K_GROUP:
                              case K_IF:
                              case K_IIF:
                              case K_IN:
                              case K_INDEX:
                              case K_INSERT:
                              case K_INTERVAL:
                              case K_ISNULL:
                              case K_JSON:
                              case K_KEY:
                              case K_FN:
                              case K_LAST:
                              case K_LEADING:
                              case K_LEFT:
                              case K_LIMIT:
                              case K_LOCAL:
                              case K_MATERIALIZED:
                              case K_NEXTVAL:
                              case K_NO:
                              case K_NOLOCK:
                              case K_NULLS:
                              case K_OF:
                              case K_OFFSET:
                              case K_ON:
                              case K_OPEN:
                              case K_ORDER:
                              case K_OVER:
                              case K_OPTIMIZE:
                              case K_PARALLEL:
                              case K_PARTITION:
                              case K_PATH:
                              case K_PERCENT:
                              case K_PRECISION:
                              case K_PRIMARY:
                              case K_PRIOR:
                              case K_PROCEDURE:
                              case K_PUBLIC:
                              case K_RANGE:
                              case K_READ:
                              case K_REPLACE:
                              case K_RIGHT:
                              case K_ROW:
                              case K_ROWS:
                              case K_SCHEMA:
                              case K_SEQUENCE:
                              case K_SEPARATOR:
                              case K_SESSION:
                              case K_SET:
                              case K_SIBLINGS:
                              case K_SIZE:
                              case K_SKIP:
                              case K_START:
                              case K_SYNONYM:
                              case K_TABLE:
                              case K_TABLES:
                              case K_TEMP:
                              case K_TEMPORARY:
                              case K_TIMEOUT:
                              case K_TO:
                              case K_TOP:
                              case K_TRUNCATE:
                              case K_TRUE:
                              case K_TYPE:
                              case K_SIGNED:
                              case K_UNSIGNED:
                              case K_VALIDATE:
                              case K_VALUE:
                              case K_VALUES:
                              case K_VIEW:
                              case K_XML:
                              case K_ZONE:
                              case S_IDENTIFIER:
                              case S_QUOTED_IDENTIFIER:{
                                retval = Column();
                                break;
                                }
                              case S_CHAR_LITERAL:{
                                token = jj_consume_token(S_CHAR_LITERAL);
retval = new StringValue(token.image); linkAST(retval,jjtn000);
                                break;
                                }
                              case 319:{
                                jj_consume_token(319);
                                token = jj_consume_token(S_CHAR_LITERAL);
                                jj_consume_token(320);
retval = new DateValue(token.image);
                                break;
                                }
                              case 321:{
                                jj_consume_token(321);
                                token = jj_consume_token(S_CHAR_LITERAL);
                                jj_consume_token(320);
retval = new TimeValue(token.image);
                                break;
                                }
                              case 322:{
                                jj_consume_token(322);
                                token = jj_consume_token(S_CHAR_LITERAL);
                                jj_consume_token(320);
retval = new TimestampValue(token.image);
                                break;
                                }
                              default:
                                jj_la1[298] = jj_gen;
                                if (jj_2_138(2147483647)) {
                                  jj_consume_token(287);
                                  retval = SubSelect();
                                  jj_consume_token(288);
                                } else if (jj_2_139(1)) {
                                  if (jj_2_125(1)) {
                                    if (getAsBoolean(Feature.allowComplexParsing)) {

                                    } else {
                                      jj_consume_token(-1);
                                      throw new ParseException();
                                    }
                                    jj_consume_token(287);
                                    list = ComplexExpressionList();
                                    jj_consume_token(288);
if (list.getExpressions().size() == 1) {
                          retval = new Parenthesis(list.getExpressions().get(0));
                      } else {
                          retval = new RowConstructor().withExprList(list);
                      }
                                  } else {
                                    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                                    case 287:{
                                      jj_consume_token(287);
                                      list = SimpleExpressionList(true);
                                      jj_consume_token(288);
if (list.getExpressions().size() == 1) {
                              retval = new Parenthesis(list.getExpressions().get(0));
                          } else {
                              retval = new RowConstructor().withExprList(list);
                          }
                                      break;
                                      }
                                    default:
                                      jj_la1[290] = jj_gen;
                                      jj_consume_token(-1);
                                      throw new ParseException();
                                    }
                                  }
                                  switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                                  case 291:{
                                    jj_consume_token(291);
                                    tmp = RelObjectNameExt();
retval = new RowGetExpression(retval, tmp);
                                    break;
                                    }
                                  default:
                                    jj_la1[291] = jj_gen;
                                    ;
                                  }
                                } else {
                                  jj_consume_token(-1);
                                  throw new ParseException();
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COLLATE:{
        jj_consume_token(K_COLLATE);
        token = jj_consume_token(S_IDENTIFIER);
retval = new CollateExpression(retval, token.image);
        break;
        }
      default:
        jj_la1[299] = jj_gen;
        ;
      }
      if (jj_2_140(2) && (dateExpressionAllowed)) {
        retval = IntervalExpressionWithoutInterval(retval);
      } else {
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 317:{
        retval = ArrayExpression(retval);
        break;
        }
      default:
        jj_la1[300] = jj_gen;
        ;
      }
      label_71:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 323:{
          ;
          break;
          }
        default:
          jj_la1[301] = jj_gen;
          break label_71;
        }
        jj_consume_token(323);
        type = ColDataType();
castExpr = new CastExpression();
        castExpr.setUseCastKeyword(false);
        castExpr.setLeftExpression(retval);
        castExpr.setType(type);
        retval=castExpr;
      }
      label_72:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_AT:{
          ;
          break;
          }
        default:
          jj_la1[302] = jj_gen;
          break label_72;
        }
        jj_consume_token(K_AT);
        jj_consume_token(K_DATETIMELITERAL);
        jj_consume_token(K_ZONE);
        token = jj_consume_token(S_CHAR_LITERAL);
if (timezoneExpr == null)
            timezoneExpr = new TimezoneExpression();

        timezoneExpr.addTimezoneExpression(token.image);
      }
if (timezoneExpr != null && !timezoneExpr.getTimezoneExpressions().isEmpty()) {
            timezoneExpr.setLeftExpression(retval);
            retval=timezoneExpr;
        }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
if (sign != null) {
            retval = new SignedExpression(sign.image.charAt(0), retval);
        }
        if (not) {
            retval = new NotExpression(retval, exclamationMarkNot);
        }
        return retval;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public NextValExpression NextValExpression() throws ParseException {List<String> data = new ArrayList<String>();
    Token token;
    token = jj_consume_token(K_NEXTVAL);
    data = RelObjectNameList();
return new NextValExpression(data, token.image);
}

  final public JdbcNamedParameter JdbcNamedParameter() throws ParseException {JdbcNamedParameter parameter = new JdbcNamedParameter();
    String name;
    jj_consume_token(292);
    name = RelObjectNameExt2();
parameter.setName(name);
return parameter;
}

  final public UserVariable UserVariable() throws ParseException {UserVariable var = new UserVariable();
    String varName;
    String var2;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 324:{
      jj_consume_token(324);
      break;
      }
    case 298:{
      jj_consume_token(298);
var.setDoubleAdd(true);
      break;
      }
    default:
      jj_la1[303] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    varName = RelObjectNameExt2();
    label_73:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 291:{
        ;
        break;
        }
      default:
        jj_la1[304] = jj_gen;
        break label_73;
      }
      jj_consume_token(291);
      var2 = RelObjectNameExt2();
varName+="." + var2;
    }
var.setName(varName);
        return var;
}

  final public NumericBind NumericBind() throws ParseException {NumericBind var = new NumericBind();
    Token token;
    jj_consume_token(292);
    token = jj_consume_token(S_LONG);
var.setBindId(Integer.valueOf(token.image));
        return var;
}

  final public DateTimeLiteralExpression DateTimeLiteralExpression() throws ParseException {DateTimeLiteralExpression expr = new DateTimeLiteralExpression();
    Token t;
    t = jj_consume_token(K_DATETIMELITERAL);
expr.setType(DateTimeLiteralExpression.DateTime.valueOf(t.image.toUpperCase()));
    t = jj_consume_token(S_CHAR_LITERAL);
expr.setValue(t.image); return expr;
}

  final public ArrayConstructor ArrayConstructor(final boolean arrayKeyword) throws ParseException {ArrayList<Expression> expList = new ArrayList();
    ArrayConstructor array = new ArrayConstructor(expList, arrayKeyword);
    Expression exp = null;
    jj_consume_token(317);
    if (jj_2_143(1)) {
      if (jj_2_141(3)) {
        exp = SimpleExpression();
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 317:{
          exp = ArrayConstructor(false);
          break;
          }
        default:
          jj_la1[305] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
expList.add(exp);
      label_74:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[306] = jj_gen;
          break label_74;
        }
        jj_consume_token(K_COMMA);
        if (jj_2_142(1)) {
          exp = SimpleExpression();
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 317:{
            exp = ArrayConstructor(false);
            break;
            }
          default:
            jj_la1[307] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
expList.add(exp);
      }
    } else {
      ;
    }
    jj_consume_token(318);
return array;
}

  final public JsonExpression JsonExpression() throws ParseException {JsonExpression result = new JsonExpression();
  Expression expr;
  Token token;
  ColDataType type = null;
  CastExpression castExpr = null;
    expr = Column();
    label_75:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 323:{
        ;
        break;
        }
      default:
        jj_la1[308] = jj_gen;
        break label_75;
      }
      jj_consume_token(323);
      type = ColDataType();
castExpr = new CastExpression();
            castExpr.setUseCastKeyword(false);
            castExpr.setLeftExpression(expr);
            castExpr.setType(type);
            expr=castExpr;
    }
    label_76:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 325:{
        jj_consume_token(325);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_CHAR_LITERAL:{
          token = jj_consume_token(S_CHAR_LITERAL);
          break;
          }
        case S_LONG:{
          token = jj_consume_token(S_LONG);
          break;
          }
        default:
          jj_la1[309] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
result.addIdent(token.image,"->");
        break;
        }
      case 326:{
        jj_consume_token(326);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_CHAR_LITERAL:{
          token = jj_consume_token(S_CHAR_LITERAL);
          break;
          }
        case S_LONG:{
          token = jj_consume_token(S_LONG);
          break;
          }
        default:
          jj_la1[310] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
result.addIdent(token.image,"->>");
        break;
        }
      case 327:{
        jj_consume_token(327);
        token = jj_consume_token(S_CHAR_LITERAL);
result.addIdent(token.image,"#>");
        break;
        }
      case 328:{
        jj_consume_token(328);
        token = jj_consume_token(S_CHAR_LITERAL);
result.addIdent(token.image,"#>>");
        break;
        }
      default:
        jj_la1[311] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 325:
      case 326:
      case 327:
      case 328:{
        ;
        break;
        }
      default:
        jj_la1[312] = jj_gen;
        break label_76;
      }
    }
result.setExpression(expr);
        return result;
}

  final public IntervalExpression IntervalExpression() throws ParseException {IntervalExpression interval;
    Token token = null;
    Expression expr = null;
    boolean signed = false;
interval = new IntervalExpression();
    jj_consume_token(K_INTERVAL);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 307:{
      jj_consume_token(307);
signed=true;
      break;
      }
    default:
      jj_la1[313] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_LONG:{
      token = jj_consume_token(S_LONG);
      break;
      }
    case S_DOUBLE:{
      token = jj_consume_token(S_DOUBLE);
      break;
      }
    case S_CHAR_LITERAL:{
      token = jj_consume_token(S_CHAR_LITERAL);
      break;
      }
    default:
      jj_la1[314] = jj_gen;
      if (jj_2_144(2147483647)) {
        expr = SimpleJdbcParameter();
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 292:{
          expr = JdbcNamedParameter();
          break;
          }
        default:
          jj_la1[315] = jj_gen;
          if (jj_2_145(2147483647)) {
            expr = Function();
          } else {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_ACTION:
            case K_ALGORITHM:
            case K_ALL:
            case K_ANY:
            case K_ARRAY_LITERAL:
            case K_BYTE:
            case K_CASCADE:
            case K_CASE:
            case K_CASEWHEN:
            case K_CAST:
            case K_CHARACTER:
            case K_CHANGE:
            case K_CHAR:
            case K_COLUMN:
            case K_COLUMNS:
            case K_COMMIT:
            case K_COMMENT:
            case K_COSTS:
            case K_CREATE:
            case K_CYCLE:
            case K_DATETIMELITERAL:
            case K_DATE_LITERAL:
            case K_DESC:
            case K_DESCRIBE:
            case K_DISABLE:
            case K_DIV:
            case K_DO:
            case K_DOUBLE:
            case K_DUPLICATE:
            case K_ENABLE:
            case K_END:
            case K_EXCLUDE:
            case K_EXTRACT:
            case K_FIRST:
            case K_FALSE:
            case K_FOLLOWING:
            case K_FORMAT:
            case K_GROUP:
            case K_IF:
            case K_IIF:
            case K_IN:
            case K_INDEX:
            case K_INSERT:
            case K_INTERVAL:
            case K_ISNULL:
            case K_JSON:
            case K_KEY:
            case K_FN:
            case K_LAST:
            case K_LEADING:
            case K_LEFT:
            case K_LIMIT:
            case K_LOCAL:
            case K_MATERIALIZED:
            case K_NEXTVAL:
            case K_NO:
            case K_NOLOCK:
            case K_NULLS:
            case K_OF:
            case K_OFFSET:
            case K_ON:
            case K_OPEN:
            case K_ORDER:
            case K_OVER:
            case K_OPTIMIZE:
            case K_PARALLEL:
            case K_PARTITION:
            case K_PATH:
            case K_PERCENT:
            case K_PRECISION:
            case K_PRIMARY:
            case K_PRIOR:
            case K_PROCEDURE:
            case K_PUBLIC:
            case K_RANGE:
            case K_READ:
            case K_REPLACE:
            case K_RIGHT:
            case K_ROW:
            case K_ROWS:
            case K_SCHEMA:
            case K_SEQUENCE:
            case K_SEPARATOR:
            case K_SESSION:
            case K_SET:
            case K_SIBLINGS:
            case K_SIZE:
            case K_SKIP:
            case K_START:
            case K_SYNONYM:
            case K_TABLE:
            case K_TABLES:
            case K_TEMP:
            case K_TEMPORARY:
            case K_TIMEOUT:
            case K_TO:
            case K_TOP:
            case K_TRUNCATE:
            case K_TRUE:
            case K_TYPE:
            case K_SIGNED:
            case K_UNSIGNED:
            case K_VALIDATE:
            case K_VALUE:
            case K_VALUES:
            case K_VIEW:
            case K_XML:
            case K_ZONE:
            case S_IDENTIFIER:
            case S_QUOTED_IDENTIFIER:{
              expr = Column();
              break;
              }
            default:
              jj_la1[316] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
        }
      }
    }
if (expr != null) {
            if (signed) expr = new SignedExpression('-', expr);
            interval.setExpression(expr);
        } else {
            interval.setParameter((signed?"-":"") + token.image);
        }
    if (jj_2_146(2)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        token = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case K_DATE_LITERAL:{
        token = jj_consume_token(K_DATE_LITERAL);
        break;
        }
      default:
        jj_la1[317] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
interval.setIntervalType(token.image);
    } else {
      ;
    }
return interval;
}

  final public IntervalExpression IntervalExpressionWithoutInterval(Expression expr) throws ParseException {IntervalExpression interval;
    Token token;
    boolean signed = false;
interval = new IntervalExpression(false);
        interval.setExpression(expr);
    token = jj_consume_token(K_DATE_LITERAL);
interval.setIntervalType(token.image);
return interval;
}

  final public KeepExpression KeepExpression() throws ParseException {KeepExpression keep = new KeepExpression();
    Token token;
    List<OrderByElement> list;
    jj_consume_token(K_KEEP);
    jj_consume_token(287);
    token = jj_consume_token(S_IDENTIFIER);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FIRST:{
      jj_consume_token(K_FIRST);
keep.setFirst(true);
      break;
      }
    case K_LAST:{
      jj_consume_token(K_LAST);
keep.setFirst(false);
      break;
      }
    default:
      jj_la1[318] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    list = OrderByElements();
    jj_consume_token(288);
keep.setName(token.image);
        keep.setOrderByElements(list);
        return keep;
}

  final public void windowFun(AnalyticExpression retval) throws ParseException {ExpressionList expressionList = null;
         List<OrderByElement> olist = null;
         WindowElement windowElement = null;
         boolean partitionByBrackets = false;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_OVER:{
      jj_consume_token(K_OVER);
retval.setType(AnalyticType.OVER);
      break;
      }
    case K_WITHIN:{
      jj_consume_token(K_WITHIN);
      jj_consume_token(K_GROUP);
retval.setType(AnalyticType.WITHIN_GROUP);
      break;
      }
    default:
      jj_la1[319] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(287);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_PARTITION:{
      jj_consume_token(K_PARTITION);
      jj_consume_token(K_BY);
      if (jj_2_147(2147483647)) {
        expressionList = ComplexExpressionList();
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 287:{
          jj_consume_token(287);
partitionByBrackets = true;
          expressionList = ComplexExpressionList();
          jj_consume_token(288);
          break;
          }
        default:
          jj_la1[320] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[321] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ORDER:{
      olist = OrderByElements();
      break;
      }
    default:
      jj_la1[322] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_RANGE:
    case K_ROWS:{
      windowElement = WindowElement();
      break;
      }
    default:
      jj_la1[323] = jj_gen;
      ;
    }
retval.setPartitionExpressionList(expressionList, partitionByBrackets);
            retval.setOrderByElements(olist);
            retval.setWindowElement(windowElement);
    jj_consume_token(288);
}

  final public AnalyticExpression AnalyticExpression(Function function) throws ParseException {AnalyticExpression retval = new AnalyticExpression(function);
    Expression filter = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FILTER:{
      jj_consume_token(K_FILTER);
      jj_consume_token(287);
      jj_consume_token(K_WHERE);
retval.setType(AnalyticType.FILTER_ONLY);
      filter = Expression();
      jj_consume_token(288);
      if (jj_2_148(2)) {
        windowFun(retval);
      } else {
        ;
      }
      break;
      }
    case K_OVER:
    case K_WITHIN:{
      windowFun(retval);
      break;
      }
    default:
      jj_la1[324] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
retval.setFilterExpression(filter);
        return retval;
}

  final public WindowElement WindowElement() throws ParseException {WindowElement windowElement = new WindowElement();
    WindowRange range = new WindowRange();
    WindowOffset offset = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ROWS:{
      jj_consume_token(K_ROWS);
windowElement.setType(WindowElement.Type.ROWS);
      break;
      }
    case K_RANGE:{
      jj_consume_token(K_RANGE);
windowElement.setType(WindowElement.Type.RANGE);
      break;
      }
    default:
      jj_la1[325] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_BETWEEN:{
      jj_consume_token(K_BETWEEN);
windowElement.setRange(range);
      offset = WindowOffset();
range.setStart(offset);
      jj_consume_token(K_AND);
      offset = WindowOffset();
range.setEnd(offset);
      break;
      }
    default:
      jj_la1[326] = jj_gen;
      if (jj_2_149(1)) {
        offset = WindowOffset();
windowElement.setOffset(offset);
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return windowElement;
}

  final public WindowOffset WindowOffset() throws ParseException {WindowOffset offset = new WindowOffset();
    Expression expr = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_UNBOUNDED:{
      jj_consume_token(K_UNBOUNDED);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_PRECEDING:{
        jj_consume_token(K_PRECEDING);
offset.setType(WindowOffset.Type.PRECEDING);
        break;
        }
      case K_FOLLOWING:{
        jj_consume_token(K_FOLLOWING);
offset.setType(WindowOffset.Type.FOLLOWING);
        break;
        }
      default:
        jj_la1[327] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[329] = jj_gen;
      if (jj_2_150(2)) {
        jj_consume_token(K_CURRENT);
        jj_consume_token(K_ROW);
offset.setType(WindowOffset.Type.CURRENT);
      } else if (jj_2_151(1)) {
        expr = SimpleExpression();
offset.setType(WindowOffset.Type.EXPR);
                        offset.setExpression(expr);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_PRECEDING:{
          jj_consume_token(K_PRECEDING);
offset.setType(WindowOffset.Type.PRECEDING);
          break;
          }
        case K_FOLLOWING:{
          jj_consume_token(K_FOLLOWING);
offset.setType(WindowOffset.Type.FOLLOWING);
          break;
          }
        default:
          jj_la1[328] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return offset;
}

  final public ExtractExpression ExtractExpression() throws ParseException {ExtractExpression retval = new ExtractExpression();
    String token = null;
    Expression expr = null;
    jj_consume_token(K_EXTRACT);
    jj_consume_token(287);
    token = RelObjectName();
retval.setName(token);
    jj_consume_token(K_FROM);
    expr = SimpleExpression();
retval.setExpression(expr);
    jj_consume_token(288);
return retval;
}

  final public CastExpression CastExpression() throws ParseException {CastExpression retval = new CastExpression();
    ColDataType type = null;
    Expression expression = null;
    boolean    useCastKeyword;
    jj_consume_token(K_CAST);
    jj_consume_token(287);
    expression = SimpleExpression();
    jj_consume_token(K_AS);
    type = ColDataType();
    jj_consume_token(288);
retval.setUseCastKeyword(true);
retval.setLeftExpression(expression);
        retval.setType(type);
        return retval;
}

  final public Expression CaseWhenExpression() throws ParseException {/*@bgen(jjtree) CaseWhenExpression */
    SimpleNode jjtn000 = new SimpleNode(JJTCASEWHENEXPRESSION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));CaseExpression caseExp = new CaseExpression();
    Expression switchExp = null;
    WhenClause clause;
    List<WhenClause> whenClauses = new ArrayList<WhenClause>();
    Expression elseExp = null;
    try {
      jj_consume_token(K_CASE);
caseCounter++;
      if (jj_2_152(1)) {
        switchExp = Condition();
      } else {
        ;
      }
      label_77:
      while (true) {
        clause = WhenThenSearchCondition();
whenClauses.add(clause);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_WHEN:{
          ;
          break;
          }
        default:
          jj_la1[330] = jj_gen;
          break label_77;
        }
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ELSE:{
        jj_consume_token(K_ELSE);
        if (jj_2_153(2147483647)) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 287:{
            jj_consume_token(287);
            break;
            }
          default:
            jj_la1[331] = jj_gen;
            ;
          }
          elseExp = CaseWhenExpression();
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 288:{
            jj_consume_token(288);
((CaseExpression) elseExp).setUsingBrackets(true);
            break;
            }
          default:
            jj_la1[332] = jj_gen;
            ;
          }
        } else if (jj_2_154(1)) {
          elseExp = Condition();
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[333] = jj_gen;
        ;
      }
      jj_consume_token(K_END);
caseCounter--;
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
caseExp.setSwitchExpression(switchExp);
        caseExp.setWhenClauses(whenClauses);
        caseExp.setElseExpression(elseExp);
        return caseExp;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public WhenClause WhenThenSearchCondition() throws ParseException {WhenClause whenThen = new WhenClause();
    Expression whenExp = null;
    Expression thenExp = null;
    jj_consume_token(K_WHEN);
    whenExp = Expression();
    jj_consume_token(K_THEN);
    if (jj_2_155(2147483647)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 287:{
        jj_consume_token(287);
        break;
        }
      default:
        jj_la1[334] = jj_gen;
        ;
      }
      thenExp = CaseWhenExpression();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 288:{
        jj_consume_token(288);
((CaseExpression) thenExp).setUsingBrackets(true);
        break;
        }
      default:
        jj_la1[335] = jj_gen;
        ;
      }
    } else if (jj_2_156(1)) {
      thenExp = Expression();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
whenThen.setWhenExpression(whenExp);
       whenThen.setThenExpression(thenExp);
       return whenThen;
}

/*WhenClause WhenThenValue():
{
    WhenClause whenThen = new WhenClause();
    Expression whenExp = null;
    Expression thenExp = null;
}
{
    <K_WHEN> whenExp=SimpleExpression() <K_THEN> thenExp=SimpleExpression()
    {
       whenThen.setWhenExpression(whenExp);
       whenThen.setThenExpression(thenExp);
       return whenThen;
    }
}*/
  final public 
RowConstructor RowConstructor() throws ParseException {ExpressionList list = null;
    RowConstructor rowConstructor = new RowConstructor();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ROW:{
      jj_consume_token(K_ROW);
rowConstructor.setName("ROW");
      break;
      }
    default:
      jj_la1[336] = jj_gen;
      ;
    }
    jj_consume_token(287);
    list = SimpleExpressionList(true);
    jj_consume_token(288);
rowConstructor.setExprList(list);
        return rowConstructor;
}

/**
TODO: VariableExpression should be a standalone class with more operations available. 
*/
  final public EqualsTo VariableExpression() throws ParseException {Expression left;
    Expression right;
    left = UserVariable();
    jj_consume_token(289);
    right = SimpleExpression();
EqualsTo equals = new EqualsTo();
        equals.setLeftExpression(left);
        equals.setRightExpression(right);
        return equals;
}

  final public Execute Execute() throws ParseException {List<String> funcName;
    ExpressionList expressionList = null;
    Execute execute = new Execute();
    List<Expression> namedExprList;
    Expression expr;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_EXEC:{
      jj_consume_token(K_EXEC);
execute.setExecType(Execute.ExecType.EXEC);
      break;
      }
    case K_EXECUTE:{
      jj_consume_token(K_EXECUTE);
execute.setExecType(Execute.ExecType.EXECUTE);
      break;
      }
    case K_CALL:{
      jj_consume_token(K_CALL);
execute.setExecType(Execute.ExecType.CALL);
      break;
      }
    default:
      jj_la1[337] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    funcName = RelObjectNameList();
execute.setName(funcName);
    if (jj_2_159(1)) {
      if (jj_2_157(3)) {
        expr = VariableExpression();
namedExprList = new ArrayList<Expression>(); namedExprList.add( expr );
        label_78:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_COMMA:{
            ;
            break;
            }
          default:
            jj_la1[338] = jj_gen;
            break label_78;
          }
          jj_consume_token(K_COMMA);
          expr = VariableExpression();
namedExprList.add(expr);
        }
expressionList = new ExpressionList(namedExprList);
      } else if (jj_2_158(3)) {
        expressionList = SimpleExpressionList(true);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 287:{
          jj_consume_token(287);
          expressionList = SimpleExpressionList(true);
          jj_consume_token(288);
execute.setParenthesis(true);
          break;
          }
        default:
          jj_la1[339] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    } else {
      ;
    }
execute.setExprList(expressionList);
        return execute;
}

  final public FullTextSearch FullTextSearch() throws ParseException {Column col;
    Token searchModifier;
    Token againstValue;
    FullTextSearch fs = new FullTextSearch();
    List<Column> matchedColumns = new ArrayList<Column>();
    List<Expression> expList = new ArrayList<Expression>();
    jj_consume_token(K_MATCH);
    jj_consume_token(287);
    col = Column();
matchedColumns.add(col);
    label_79:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[340] = jj_gen;
        break label_79;
      }
      jj_consume_token(K_COMMA);
      col = Column();
matchedColumns.add(col);
    }
    jj_consume_token(288);
    jj_consume_token(K_AGAINST);
    jj_consume_token(287);
    againstValue = jj_consume_token(S_CHAR_LITERAL);
fs.setAgainstValue(new StringValue(againstValue.image));
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 329:
    case 330:
    case 331:
    case 332:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 329:{
        searchModifier = jj_consume_token(329);
        break;
        }
      case 330:{
        searchModifier = jj_consume_token(330);
        break;
        }
      case 331:{
        searchModifier = jj_consume_token(331);
        break;
        }
      case 332:{
        searchModifier = jj_consume_token(332);
        break;
        }
      default:
        jj_la1[341] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
fs.setSearchModifier(searchModifier.image);
      break;
      }
    default:
      jj_la1[342] = jj_gen;
      ;
    }
    jj_consume_token(288);
fs.setMatchColumns(matchedColumns);
        return fs;
}

/* Function FunctionWithCondParams() #Function: {
    Function retval = new Function();
    String funcName = null;
    ExpressionList expressionList = null;
    Token token = null;
}
{
    (token = <K_IF> | token = <K_IIF> | token = <K_CASEWHEN> ) { funcName=token.image; }

    "("
        expressionList=ComplexExpressionList()
	")"

    {
        retval.setParameters(expressionList);
        retval.setName(funcName);
        linkAST(retval,jjtThis);
        return retval;
    }
} */
  final public 

Function Function() throws ParseException {/*@bgen(jjtree) Function */
    SimpleNode jjtn000 = new SimpleNode(JJTFUNCTION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Function retval = new Function();
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 333:{
        jj_consume_token(333);
        jj_consume_token(K_FN);
retval.setEscaped(true);
        InternalFunction(retval);
        jj_consume_token(320);
        break;
        }
      case K_ACTION:
      case K_ALGORITHM:
      case K_ALL:
      case K_ANY:
      case K_ARRAY_LITERAL:
      case K_BYTE:
      case K_CASCADE:
      case K_CASE:
      case K_CASEWHEN:
      case K_CAST:
      case K_CHARACTER:
      case K_CHANGE:
      case K_CHAR:
      case K_COLUMN:
      case K_COLUMNS:
      case K_COMMIT:
      case K_COMMENT:
      case K_COSTS:
      case K_CREATE:
      case K_CYCLE:
      case K_DATETIMELITERAL:
      case K_DATE_LITERAL:
      case K_DESC:
      case K_DESCRIBE:
      case K_DISABLE:
      case K_DIV:
      case K_DO:
      case K_DOUBLE:
      case K_DUPLICATE:
      case K_ENABLE:
      case K_END:
      case K_EXCLUDE:
      case K_EXTRACT:
      case K_FIRST:
      case K_FALSE:
      case K_FOLLOWING:
      case K_FORMAT:
      case K_GROUP:
      case K_IF:
      case K_IIF:
      case K_IN:
      case K_INDEX:
      case K_INSERT:
      case K_INTERVAL:
      case K_ISNULL:
      case K_JSON:
      case K_KEY:
      case K_FN:
      case K_LAST:
      case K_LEADING:
      case K_LEFT:
      case K_LIMIT:
      case K_LOCAL:
      case K_MATERIALIZED:
      case K_NEXTVAL:
      case K_NO:
      case K_NOLOCK:
      case K_NULLS:
      case K_OF:
      case K_OFFSET:
      case K_ON:
      case K_OPEN:
      case K_ORDER:
      case K_OVER:
      case K_OPTIMIZE:
      case K_PARALLEL:
      case K_PARTITION:
      case K_PATH:
      case K_PERCENT:
      case K_PRECISION:
      case K_PRIMARY:
      case K_PRIOR:
      case K_PROCEDURE:
      case K_PUBLIC:
      case K_RANGE:
      case K_READ:
      case K_REPLACE:
      case K_RIGHT:
      case K_ROW:
      case K_ROWS:
      case K_SCHEMA:
      case K_SEQUENCE:
      case K_SEPARATOR:
      case K_SESSION:
      case K_SET:
      case K_SIBLINGS:
      case K_SIZE:
      case K_SKIP:
      case K_START:
      case K_SYNONYM:
      case K_TABLE:
      case K_TABLES:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIMEOUT:
      case K_TO:
      case K_TOP:
      case K_TRUNCATE:
      case K_TRUE:
      case K_TYPE:
      case K_SIGNED:
      case K_UNSIGNED:
      case K_VALIDATE:
      case K_VALUE:
      case K_VALUES:
      case K_VIEW:
      case K_XML:
      case K_ZONE:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:{
        InternalFunction(retval);
        break;
        }
      default:
        jj_la1[343] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
linkAST(retval,jjtn000);
        return retval;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Function InternalFunction(Function retval) throws ParseException {List<String> funcName;
    String tmp = null;
    List<Expression> expressions = new ArrayList<Expression>();
    ExpressionList expressionList = null;
    NamedExpressionList namedExpressionList = null;
    KeepExpression keep = null;
    SubSelect expr = null;
    Token tk1 = null;
    Token tk2 = null;
    Expression expr1 = null;
    List<OrderByElement> orderByList;
    boolean ignoreNulls = false;
    funcName = RelObjectNameList();
    jj_consume_token(287);
    if (jj_2_166(1)) {
      if (jj_2_160(2)) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_DISTINCT:{
          jj_consume_token(K_DISTINCT);
retval.setDistinct(true);
          break;
          }
        case K_ALL:{
          jj_consume_token(K_ALL);
retval.setAllColumns(true);
          break;
          }
        case K_UNIQUE:{
          jj_consume_token(K_UNIQUE);
retval.setUnique(true);
          break;
          }
        default:
          jj_la1[344] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else {
        ;
      }
      if (jj_2_161(4)) {
        jj_consume_token(290);
retval.setAllColumns(true);
      } else if (jj_2_162(2147483647)) {
        namedExpressionList = NamedExpressionList1();
      } else if (jj_2_163(2147483647) && (getAsBoolean(Feature.allowComplexParsing))) {
        namedExpressionList = NamedExpressionListExprFirst();
      } else if (jj_2_164(3) && (getAsBoolean(Feature.allowComplexParsing))) {
        expressionList = ComplexExpressionList();
expressionList.setUsingBrackets(false);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ORDER:{
          orderByList = OrderByElements();
retval.setOrderByElements(orderByList);
          break;
          }
        default:
          jj_la1[345] = jj_gen;
          ;
        }
      } else if (jj_2_165(3)) {
        expressionList = SimpleExpressionList(false);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ORDER:{
          orderByList = OrderByElements();
retval.setOrderByElements(orderByList);
          break;
          }
        default:
          jj_la1[346] = jj_gen;
          ;
        }
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_SELECT:
        case K_VALUES:
        case K_WITH:
        case 287:{
          expr = SubSelect();
expr.setUseBrackets(false); expressionList = new ExpressionList(expr).withUsingBrackets(false);
          break;
          }
        default:
          jj_la1[347] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_IGNORE:{
      jj_consume_token(K_IGNORE);
      jj_consume_token(K_NULLS);
retval.setIgnoreNulls(true);
      break;
      }
    default:
      jj_la1[348] = jj_gen;
      ;
    }
    jj_consume_token(288);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 291:{
      jj_consume_token(291);
      if (jj_2_167(2)) {
        expr1 = Function();
retval.setAttribute(expr1);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ACTION:
        case K_ALGORITHM:
        case K_ANY:
        case K_ARRAY_LITERAL:
        case K_BYTE:
        case K_CASCADE:
        case K_CASE:
        case K_CAST:
        case K_CHARACTER:
        case K_CHANGE:
        case K_CHAR:
        case K_COLUMN:
        case K_COLUMNS:
        case K_COMMIT:
        case K_COMMENT:
        case K_COSTS:
        case K_CREATE:
        case K_CYCLE:
        case K_DATETIMELITERAL:
        case K_DATE_LITERAL:
        case K_DESC:
        case K_DESCRIBE:
        case K_DISABLE:
        case K_DIV:
        case K_DO:
        case K_DUPLICATE:
        case K_ENABLE:
        case K_END:
        case K_EXCLUDE:
        case K_EXTRACT:
        case K_FIRST:
        case K_FALSE:
        case K_FOLLOWING:
        case K_FORMAT:
        case K_GROUP:
        case K_INDEX:
        case K_INSERT:
        case K_INTERVAL:
        case K_ISNULL:
        case K_JSON:
        case K_KEY:
        case K_FN:
        case K_LAST:
        case K_LEADING:
        case K_LOCAL:
        case K_MATERIALIZED:
        case K_NEXTVAL:
        case K_NO:
        case K_NOLOCK:
        case K_NULLS:
        case K_OF:
        case K_ON:
        case K_OPEN:
        case K_ORDER:
        case K_OVER:
        case K_PARALLEL:
        case K_PARTITION:
        case K_PATH:
        case K_PERCENT:
        case K_PRECISION:
        case K_PRIMARY:
        case K_PRIOR:
        case K_RANGE:
        case K_READ:
        case K_REPLACE:
        case K_ROW:
        case K_ROWS:
        case K_SCHEMA:
        case K_SEQUENCE:
        case K_SEPARATOR:
        case K_SESSION:
        case K_SIBLINGS:
        case K_SIZE:
        case K_SKIP:
        case K_START:
        case K_SYNONYM:
        case K_TABLE:
        case K_TABLES:
        case K_TEMP:
        case K_TEMPORARY:
        case K_TIMEOUT:
        case K_TO:
        case K_TOP:
        case K_TRUNCATE:
        case K_TRUE:
        case K_TYPE:
        case K_SIGNED:
        case K_UNSIGNED:
        case K_VALIDATE:
        case K_VALUE:
        case K_VALUES:
        case K_VIEW:
        case K_XML:
        case K_ZONE:
        case S_IDENTIFIER:
        case S_QUOTED_IDENTIFIER:{
          tmp = RelObjectName();
retval.setAttributeName(tmp);
          break;
          }
        default:
          jj_la1[349] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[350] = jj_gen;
      ;
    }
    if (jj_2_168(2)) {
      keep = KeepExpression();
    } else {
      ;
    }
retval.setParameters(expressionList);
        retval.setNamedParameters(namedExpressionList);
        retval.setName(funcName);
        retval.setKeep(keep);
        return retval;
}

  final public XMLSerializeExpr XMLSerializeExpr() throws ParseException {XMLSerializeExpr result;
   Expression expression;
   List<OrderByElement> orderByElements = null;
   ColDataType dataType;
    jj_consume_token(K_XMLSERIALIZE);
    jj_consume_token(287);
    jj_consume_token(K_XMLAGG);
    jj_consume_token(287);
    jj_consume_token(K_XMLTEXT);
    jj_consume_token(287);
    expression = SimpleExpression();
    jj_consume_token(288);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ORDER:{
      orderByElements = OrderByElements();
      break;
      }
    default:
      jj_la1[351] = jj_gen;
      ;
    }
    jj_consume_token(288);
    jj_consume_token(K_AS);
    dataType = ColDataType();
    jj_consume_token(288);
result = new XMLSerializeExpr();
        result.setExpression(expression);
        result.setOrderByElements(orderByElements);
        result.setDataType(dataType);
        return result;
}

  final public MySQLGroupConcat MySQLGroupConcat() throws ParseException {MySQLGroupConcat retval = new MySQLGroupConcat();
    ExpressionList expressionList = null;
    List<OrderByElement> orderByList = null;
    Token t;
    jj_consume_token(K_GROUP_CONCAT);
    jj_consume_token(287);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_DISTINCT:{
      jj_consume_token(K_DISTINCT);
retval.setDistinct(true);
      break;
      }
    default:
      jj_la1[352] = jj_gen;
      ;
    }
    expressionList = SimpleExpressionList(true);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ORDER:{
      orderByList = OrderByElements();
retval.setOrderByElements(orderByList);
      break;
      }
    default:
      jj_la1[353] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_SEPARATOR:{
      jj_consume_token(K_SEPARATOR);
      t = jj_consume_token(S_CHAR_LITERAL);
retval.setSeparator(t.image);
      break;
      }
    default:
      jj_la1[354] = jj_gen;
      ;
    }
    jj_consume_token(288);
retval.setExpressionList(expressionList);
        return retval;
}

  final public ValueListExpression ValueListExpression() throws ParseException {ValueListExpression retval = new ValueListExpression();
    ExpressionList expressionList = null;
    jj_consume_token(287);
    expressionList = SimpleExpressionListAtLeastTwoItems();
    jj_consume_token(288);
retval.setExpressionList(expressionList);
        return retval;
}

  final public TableFunction TableFunction() throws ParseException {Alias alias = null;
    Function function;
    TableFunction functionItem;
    function = Function();
functionItem = new TableFunction().withFunction(function);
    if (jj_2_169(2)) {
      alias = Alias();
functionItem.setAlias(alias);
    } else {
      ;
    }
return functionItem;
}

  final public SubSelect SubSelect() throws ParseException {/*@bgen(jjtree) SubSelect */
    SimpleNode jjtn000 = new SimpleNode(JJTSUBSELECT);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));SelectBody selectBody = null;
    SubSelect subSelect = new SubSelect();
    List<WithItem> with = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_WITH:{
        with = WithList();
subSelect.setWithItemsList(with);
        break;
        }
      default:
        jj_la1[355] = jj_gen;
        ;
      }
      selectBody = SelectBody();
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
subSelect.setSelectBody(selectBody);
        linkAST(subSelect,jjtn000);
        return subSelect;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public List<Index.ColumnParams> ColumnNamesWithParamsList() throws ParseException {List<Index.ColumnParams> colNames = new ArrayList<Index.ColumnParams>();
    String columnName;
    List<String> parameter = null;
    jj_consume_token(287);
    columnName = RelObjectName();
parameter = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ARRAY_LITERAL:
    case K_AS:
    case K_ASC:
    case K_BY:
    case K_CASCADE:
    case K_CHECK:
    case K_COLLATE:
    case K_COMMIT:
    case K_COMMENT:
    case K_CONSTRAINT:
    case K_DEFAULT:
    case K_DELETE:
    case K_DESC:
    case K_DROP:
    case K_EXCLUDE:
    case K_FALSE:
    case K_FOREIGN:
    case K_IN:
    case K_KEY:
    case K_NOT:
    case K_NULL:
    case K_ON:
    case K_PARALLEL:
    case K_PARTITION:
    case K_PRIMARY:
    case K_REFERENCES:
    case K_ROWS:
    case K_TABLESPACE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIME_KEY_EXPR:
    case K_TRUE:
    case K_TYPE:
    case K_UNIQUE:
    case K_UPDATE:
    case K_USING:
    case K_UNSIGNED:
    case K_WHERE:
    case K_WITH:
    case S_DOUBLE:
    case S_LONG:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:
    case 287:
    case 289:
    case 295:
    case 307:
    case 323:{
      parameter = CreateParameter();
      break;
      }
    default:
      jj_la1[356] = jj_gen;
      ;
    }
colNames.add(new Index.ColumnParams(columnName,parameter));
    label_80:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[357] = jj_gen;
        break label_80;
      }
      jj_consume_token(K_COMMA);
      columnName = RelObjectName();
parameter = null;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ARRAY_LITERAL:
      case K_AS:
      case K_ASC:
      case K_BY:
      case K_CASCADE:
      case K_CHECK:
      case K_COLLATE:
      case K_COMMIT:
      case K_COMMENT:
      case K_CONSTRAINT:
      case K_DEFAULT:
      case K_DELETE:
      case K_DESC:
      case K_DROP:
      case K_EXCLUDE:
      case K_FALSE:
      case K_FOREIGN:
      case K_IN:
      case K_KEY:
      case K_NOT:
      case K_NULL:
      case K_ON:
      case K_PARALLEL:
      case K_PARTITION:
      case K_PRIMARY:
      case K_REFERENCES:
      case K_ROWS:
      case K_TABLESPACE:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_TRUE:
      case K_TYPE:
      case K_UNIQUE:
      case K_UPDATE:
      case K_USING:
      case K_UNSIGNED:
      case K_WHERE:
      case K_WITH:
      case S_DOUBLE:
      case S_LONG:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:
      case 287:
      case 289:
      case 295:
      case 307:
      case 323:{
        parameter = CreateParameter();
        break;
        }
      default:
        jj_la1[358] = jj_gen;
        ;
      }
colNames.add(new Index.ColumnParams(columnName,parameter));
    }
    jj_consume_token(288);
return colNames;
}

  final public CreateIndex CreateIndex() throws ParseException {CreateIndex createIndex = new CreateIndex();
    Table table = null;
    List<Index.ColumnParams> colNames;
    //Token columnName;
    Token using;
    Index index = null;
    //String name = null;
    List<String> parameter = new ArrayList<String>();
    List<String> tailParameters = new ArrayList<String>();
    List<String> name;
    jj_consume_token(K_CREATE);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ARRAY_LITERAL:
    case K_AS:
    case K_ASC:
    case K_BY:
    case K_CASCADE:
    case K_CHECK:
    case K_COLLATE:
    case K_COMMIT:
    case K_COMMENT:
    case K_CONSTRAINT:
    case K_DEFAULT:
    case K_DELETE:
    case K_DESC:
    case K_DROP:
    case K_EXCLUDE:
    case K_FALSE:
    case K_FOREIGN:
    case K_IN:
    case K_KEY:
    case K_NOT:
    case K_NULL:
    case K_ON:
    case K_PARALLEL:
    case K_PARTITION:
    case K_PRIMARY:
    case K_REFERENCES:
    case K_ROWS:
    case K_TABLESPACE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIME_KEY_EXPR:
    case K_TRUE:
    case K_TYPE:
    case K_UNIQUE:
    case K_UPDATE:
    case K_USING:
    case K_UNSIGNED:
    case K_WHERE:
    case K_WITH:
    case S_DOUBLE:
    case S_LONG:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:
    case 287:
    case 289:
    case 295:
    case 307:
    case 323:{
      parameter = CreateParameter();
      break;
      }
    default:
      jj_la1[359] = jj_gen;
      ;
    }
    jj_consume_token(K_INDEX);
    name = RelObjectNameList();
index = new Index();
        index.setName(name);
        index.setType(parameter.isEmpty()?null:parameter.get(0));
    jj_consume_token(K_ON);
    table = Table();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_USING:{
      jj_consume_token(K_USING);
      using = jj_consume_token(S_IDENTIFIER);
index.setUsing(using.image);
      break;
      }
    default:
      jj_la1[360] = jj_gen;
      ;
    }
    colNames = ColumnNamesWithParamsList();
    label_81:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ARRAY_LITERAL:
      case K_AS:
      case K_ASC:
      case K_BY:
      case K_CASCADE:
      case K_CHECK:
      case K_COLLATE:
      case K_COMMIT:
      case K_COMMENT:
      case K_CONSTRAINT:
      case K_DEFAULT:
      case K_DELETE:
      case K_DESC:
      case K_DROP:
      case K_EXCLUDE:
      case K_FALSE:
      case K_FOREIGN:
      case K_IN:
      case K_KEY:
      case K_NOT:
      case K_NULL:
      case K_ON:
      case K_PARALLEL:
      case K_PARTITION:
      case K_PRIMARY:
      case K_REFERENCES:
      case K_ROWS:
      case K_TABLESPACE:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_TRUE:
      case K_TYPE:
      case K_UNIQUE:
      case K_UPDATE:
      case K_USING:
      case K_UNSIGNED:
      case K_WHERE:
      case K_WITH:
      case S_DOUBLE:
      case S_LONG:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:
      case 287:
      case 289:
      case 295:
      case 307:
      case 323:{
        ;
        break;
        }
      default:
        jj_la1[361] = jj_gen;
        break label_81;
      }
      parameter = CreateParameter();
tailParameters.addAll(parameter);
    }
index.setColumns(colNames);
        createIndex.setIndex(index);
        createIndex.setTable(table);
        createIndex.setTailParameters(tailParameters);
        return createIndex;
}

  final public ColumnDefinition ColumnDefinition() throws ParseException {ColumnDefinition coldef;
    String columnName;
    ColDataType colDataType;
    List<String> columnSpecs = new ArrayList<String>();
    List<String> parameter;
    columnName = RelObjectName();
    colDataType = ColDataType();
    label_82:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ARRAY_LITERAL:
      case K_AS:
      case K_ASC:
      case K_BY:
      case K_CASCADE:
      case K_CHECK:
      case K_COLLATE:
      case K_COMMIT:
      case K_COMMENT:
      case K_CONSTRAINT:
      case K_DEFAULT:
      case K_DELETE:
      case K_DESC:
      case K_DROP:
      case K_EXCLUDE:
      case K_FALSE:
      case K_FOREIGN:
      case K_IN:
      case K_KEY:
      case K_NOT:
      case K_NULL:
      case K_ON:
      case K_PARALLEL:
      case K_PARTITION:
      case K_PRIMARY:
      case K_REFERENCES:
      case K_ROWS:
      case K_TABLESPACE:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_TRUE:
      case K_TYPE:
      case K_UNIQUE:
      case K_UPDATE:
      case K_USING:
      case K_UNSIGNED:
      case K_WHERE:
      case K_WITH:
      case S_DOUBLE:
      case S_LONG:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:
      case 287:
      case 289:
      case 295:
      case 307:
      case 323:{
        ;
        break;
        }
      default:
        jj_la1[362] = jj_gen;
        break label_82;
      }
      parameter = CreateParameter();
columnSpecs.addAll(parameter);
    }
coldef = new ColumnDefinition();
        coldef.setColumnName(columnName);
        coldef.setColDataType(colDataType);
        if (columnSpecs.size() > 0)
            coldef.setColumnSpecs(columnSpecs);
        return coldef;
}

  final public CreateSchema CreateSchema() throws ParseException {Token tk = null;
    CreateTable table = null;
    CreateView view = null;
    CreateSchema schema = new CreateSchema();
    //schema.setSchemaName(System.getProperty("user.name"));
    //schema.setAuthorization(System.getProperty("user.name"));
    List<String> schemaPath = null;
    List<Statement> statements = new ArrayList<Statement>();
    jj_consume_token(K_CREATE);
    jj_consume_token(K_SCHEMA);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        tk = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case S_QUOTED_IDENTIFIER:{
        tk = jj_consume_token(S_QUOTED_IDENTIFIER);
        break;
        }
      default:
        jj_la1[363] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
schema.setSchemaName(tk.image);
      break;
      }
    default:
      jj_la1[364] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_AUTHORIZATION:{
      jj_consume_token(K_AUTHORIZATION);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        tk = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case S_QUOTED_IDENTIFIER:{
        tk = jj_consume_token(S_QUOTED_IDENTIFIER);
        break;
        }
      default:
        jj_la1[365] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
schema.setAuthorization(tk.image);
      break;
      }
    default:
      jj_la1[366] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_PATH:{
      schemaPath = PathSpecification();
schema.setSchemaPath(schemaPath);
      break;
      }
    default:
      jj_la1[367] = jj_gen;
      ;
    }
    label_83:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_CREATE:{
        ;
        break;
        }
      default:
        jj_la1[368] = jj_gen;
        break label_83;
      }
      if (jj_2_170(3)) {
        table = CreateTable();
table.getTable().setSchemaName(schema.getSchemaName());
            schema.addStatement(table);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_CREATE:{
          view = CreateView();
view.getView().setSchemaName(schema.getSchemaName());
            schema.addStatement(view);
          break;
          }
        default:
          jj_la1[369] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
return schema;
}

  final public List<String> PathSpecification() throws ParseException {Token tk;
    List<String> pathList = new ArrayList<String>();
    jj_consume_token(K_PATH);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_IDENTIFIER:{
      tk = jj_consume_token(S_IDENTIFIER);
      break;
      }
    case S_QUOTED_IDENTIFIER:{
      tk = jj_consume_token(S_QUOTED_IDENTIFIER);
      break;
      }
    default:
      jj_la1[370] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
pathList.add(tk.image);
    label_84:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[371] = jj_gen;
        break label_84;
      }
      jj_consume_token(K_COMMA);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        tk = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case S_QUOTED_IDENTIFIER:{
        tk = jj_consume_token(S_QUOTED_IDENTIFIER);
        break;
        }
      default:
        jj_la1[372] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
pathList.add(tk.image);
    }
return pathList;
}

  final public CreateTable CreateTable() throws ParseException {CreateTable createTable = new CreateTable();
    Table table = null;
    List<ColumnDefinition> columnDefinitions = new ArrayList<ColumnDefinition>();
    List<String> columnSpecs = null;
    List<String> tableOptions = new ArrayList<String>();
    List<String> createOptions = new ArrayList<String>();
    String columnName;
    Token tk = null;
    Token tk2 = null;
    Token tk3 = null;
    String sk3 = null;
    ColDataType colDataType = null;
    String stringList = null;
    ColumnDefinition coldef = null;
    List<Index> indexes = new ArrayList<Index>();
    List<Index.ColumnParams> colNames = null;
    List<String> colNames2 = null;
    Index index = null;
    ForeignKeyIndex fkIndex = null;
    List<String> parameter = new ArrayList<String>();
    List<String> idxSpec = new ArrayList<String>();
    Table fkTable = null;
    Select select = null;
    Table likeTable = null;
    CheckConstraint checkCs = null;
    ExcludeConstraint excludeC = null;
    RowMovement rowMovement = null;
    ReferentialAction.Action action = null;
    String tableColumn = null;
    List<String> columns = new ArrayList<String>();
    jj_consume_token(K_CREATE);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_UNLOGGED:{
      jj_consume_token(K_UNLOGGED);
createTable.setUnlogged(true);
      break;
      }
    default:
      jj_la1[373] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_GLOBAL:{
      tk = jj_consume_token(K_GLOBAL);
createOptions.add(tk.image);
      break;
      }
    default:
      jj_la1[374] = jj_gen;
      ;
    }
    label_85:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ARRAY_LITERAL:
      case K_AS:
      case K_ASC:
      case K_BY:
      case K_CASCADE:
      case K_CHECK:
      case K_COLLATE:
      case K_COMMIT:
      case K_COMMENT:
      case K_CONSTRAINT:
      case K_DEFAULT:
      case K_DELETE:
      case K_DESC:
      case K_DROP:
      case K_EXCLUDE:
      case K_FALSE:
      case K_FOREIGN:
      case K_IN:
      case K_KEY:
      case K_NOT:
      case K_NULL:
      case K_ON:
      case K_PARALLEL:
      case K_PARTITION:
      case K_PRIMARY:
      case K_REFERENCES:
      case K_ROWS:
      case K_TABLESPACE:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_TRUE:
      case K_TYPE:
      case K_UNIQUE:
      case K_UPDATE:
      case K_USING:
      case K_UNSIGNED:
      case K_WHERE:
      case K_WITH:
      case S_DOUBLE:
      case S_LONG:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:
      case 287:
      case 289:
      case 295:
      case 307:
      case 323:{
        ;
        break;
        }
      default:
        jj_la1[375] = jj_gen;
        break label_85;
      }
      parameter = CreateParameter();
createOptions.addAll(parameter);
    }
    jj_consume_token(K_TABLE);
    if (jj_2_171(2)) {
      jj_consume_token(K_IF);
      jj_consume_token(K_NOT);
      jj_consume_token(K_EXISTS);
createTable.setIfNotExists(true);
    } else {
      ;
    }
    table = Table();
    if (jj_2_181(2)) {
      if (jj_2_180(3)) {
        jj_consume_token(287);
        tableColumn = RelObjectName();
columns.add(tableColumn);
        label_86:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_COMMA:{
            ;
            break;
            }
          default:
            jj_la1[376] = jj_gen;
            break label_86;
          }
          jj_consume_token(K_COMMA);
          tableColumn = RelObjectName();
columns.add(tableColumn);
        }
        jj_consume_token(288);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 287:{
          jj_consume_token(287);
          coldef = ColumnDefinition();
columnDefinitions.add(coldef);
          label_87:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_COMMA:{
              ;
              break;
              }
            default:
              jj_la1[377] = jj_gen;
              break label_87;
            }
            jj_consume_token(K_COMMA);
            if (jj_2_174(3)) {
              tk = jj_consume_token(K_INDEX);
              sk3 = RelObjectName();
              /* colNames=ColumnsNamesList() */
                                          colNames = ColumnNamesWithParamsList();
index = new Index().withType(tk.image).withName(sk3).withColumns(colNames);
                                indexes.add(index);
            } else if (jj_2_175(3)) {
index = new NamedConstraint();
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_CONSTRAINT:{
                jj_consume_token(K_CONSTRAINT);
                sk3 = RelObjectName();
index.setName(sk3);
                break;
                }
              default:
                jj_la1[378] = jj_gen;
                ;
              }
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_PRIMARY:{
                tk = jj_consume_token(K_PRIMARY);
                tk2 = jj_consume_token(K_KEY);
index.setType(tk.image + " " + tk2.image);
                break;
                }
              case K_UNIQUE:{
                tk = jj_consume_token(K_UNIQUE);
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case K_KEY:{
                  tk2 = jj_consume_token(K_KEY);
                  break;
                  }
                default:
                  jj_la1[379] = jj_gen;
                  ;
                }
index.setType(tk.image + (tk2!=null?" " + tk2.image:""));
                break;
                }
              default:
                jj_la1[380] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
              /* colNames=ColumnsNamesList() */
                                          colNames = ColumnNamesWithParamsList();
              label_88:
              while (true) {
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case K_ARRAY_LITERAL:
                case K_AS:
                case K_ASC:
                case K_BY:
                case K_CASCADE:
                case K_CHECK:
                case K_COLLATE:
                case K_COMMIT:
                case K_COMMENT:
                case K_CONSTRAINT:
                case K_DEFAULT:
                case K_DELETE:
                case K_DESC:
                case K_DROP:
                case K_EXCLUDE:
                case K_FALSE:
                case K_FOREIGN:
                case K_IN:
                case K_KEY:
                case K_NOT:
                case K_NULL:
                case K_ON:
                case K_PARALLEL:
                case K_PARTITION:
                case K_PRIMARY:
                case K_REFERENCES:
                case K_ROWS:
                case K_TABLESPACE:
                case K_TEMP:
                case K_TEMPORARY:
                case K_TIME_KEY_EXPR:
                case K_TRUE:
                case K_TYPE:
                case K_UNIQUE:
                case K_UPDATE:
                case K_USING:
                case K_UNSIGNED:
                case K_WHERE:
                case K_WITH:
                case S_DOUBLE:
                case S_LONG:
                case S_IDENTIFIER:
                case S_CHAR_LITERAL:
                case S_QUOTED_IDENTIFIER:
                case 287:
                case 289:
                case 295:
                case 307:
                case 323:{
                  ;
                  break;
                  }
                default:
                  jj_la1[381] = jj_gen;
                  break label_88;
                }
                parameter = CreateParameter();
idxSpec.addAll(parameter);
              }
index.withColumns(colNames).withIndexSpec(idxSpec);
                                indexes.add(index);
tk2=null;
            } else if (jj_2_176(3)) {
tk=null;
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_UNIQUE:{
                tk = jj_consume_token(K_UNIQUE);
                break;
                }
              default:
                jj_la1[382] = jj_gen;
                ;
              }
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_FULLTEXT:{
                tk3 = jj_consume_token(K_FULLTEXT);
                break;
                }
              default:
                jj_la1[383] = jj_gen;
                ;
              }
              tk2 = jj_consume_token(K_KEY);
              sk3 = RelObjectName();
              /* colNames=ColumnsNamesList() */
                                          colNames = ColumnNamesWithParamsList();
              label_89:
              while (true) {
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case K_ARRAY_LITERAL:
                case K_AS:
                case K_ASC:
                case K_BY:
                case K_CASCADE:
                case K_CHECK:
                case K_COLLATE:
                case K_COMMIT:
                case K_COMMENT:
                case K_CONSTRAINT:
                case K_DEFAULT:
                case K_DELETE:
                case K_DESC:
                case K_DROP:
                case K_EXCLUDE:
                case K_FALSE:
                case K_FOREIGN:
                case K_IN:
                case K_KEY:
                case K_NOT:
                case K_NULL:
                case K_ON:
                case K_PARALLEL:
                case K_PARTITION:
                case K_PRIMARY:
                case K_REFERENCES:
                case K_ROWS:
                case K_TABLESPACE:
                case K_TEMP:
                case K_TEMPORARY:
                case K_TIME_KEY_EXPR:
                case K_TRUE:
                case K_TYPE:
                case K_UNIQUE:
                case K_UPDATE:
                case K_USING:
                case K_UNSIGNED:
                case K_WHERE:
                case K_WITH:
                case S_DOUBLE:
                case S_LONG:
                case S_IDENTIFIER:
                case S_CHAR_LITERAL:
                case S_QUOTED_IDENTIFIER:
                case 287:
                case 289:
                case 295:
                case 307:
                case 323:{
                  ;
                  break;
                  }
                default:
                  jj_la1[384] = jj_gen;
                  break label_89;
                }
                parameter = CreateParameter();
idxSpec.addAll(parameter);
              }
index = new Index()
                                .withType((tk!=null?tk.image + " ":"") + (tk3!=null?tk3.image + " ":"") + tk2.image)
                                .withName(sk3)
                                .withColumns(colNames)
                                .withIndexSpec(idxSpec);
                                indexes.add(index);
            } else if (jj_2_177(3)) {
fkIndex = new ForeignKeyIndex();
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_CONSTRAINT:{
                jj_consume_token(K_CONSTRAINT);
                sk3 = RelObjectName();
fkIndex.setName(sk3);
                break;
                }
              default:
                jj_la1[385] = jj_gen;
                ;
              }
              tk = jj_consume_token(K_FOREIGN);
              tk2 = jj_consume_token(K_KEY);
              /* colNames=ColumnsNamesList() */
                                          colNames = ColumnNamesWithParamsList();
fkIndex.withType(tk.image + " " + tk2.image).withColumns(colNames);
              jj_consume_token(K_REFERENCES);
              fkTable = Table();
              colNames2 = ColumnsNamesList();
fkIndex.setTable(fkTable);
                                fkIndex.setReferencedColumnNames(colNames2);
                                indexes.add(fkIndex);
              if (jj_2_172(2)) {
                jj_consume_token(K_ON);
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case K_DELETE:{
                  tk = jj_consume_token(K_DELETE);
                  break;
                  }
                case K_UPDATE:{
                  tk = jj_consume_token(K_UPDATE);
                  break;
                  }
                default:
                  jj_la1[386] = jj_gen;
                  jj_consume_token(-1);
                  throw new ParseException();
                }
                action = Action();
fkIndex.setReferentialAction(ReferentialAction.Type.valueOf(tk.image), action);
              } else {
                ;
              }
              if (jj_2_173(2)) {
                jj_consume_token(K_ON);
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case K_DELETE:{
                  tk = jj_consume_token(K_DELETE);
                  break;
                  }
                case K_UPDATE:{
                  tk = jj_consume_token(K_UPDATE);
                  break;
                  }
                default:
                  jj_la1[387] = jj_gen;
                  jj_consume_token(-1);
                  throw new ParseException();
                }
                action = Action();
fkIndex.setReferentialAction(ReferentialAction.Type.valueOf(tk.image), action);
              } else {
                ;
              }
            } else if (jj_2_178(3)) {
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_CONSTRAINT:{
                jj_consume_token(K_CONSTRAINT);
                sk3 = RelObjectName();
                break;
                }
              default:
                jj_la1[388] = jj_gen;
                ;
              }
Expression exp = null;
              jj_consume_token(K_CHECK);
              label_90:
              while (true) {
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case 287:{
                  ;
                  break;
                  }
                default:
                  jj_la1[389] = jj_gen;
                  break label_90;
                }
                jj_consume_token(287);
                exp = Expression();
                jj_consume_token(288);
              }
checkCs = new CheckConstraint().withName(sk3).withExpression(exp);
                           indexes.add(checkCs);
            } else if (jj_2_179(2)) {
              tk = jj_consume_token(K_EXCLUDE);
excludeC = new ExcludeConstraint(); Expression exp = null;
              tk2 = jj_consume_token(K_WHERE);
              label_91:
              while (true) {
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case 287:{
                  ;
                  break;
                  }
                default:
                  jj_la1[390] = jj_gen;
                  break label_91;
                }
                jj_consume_token(287);
                exp = Expression();
                jj_consume_token(288);
              }
excludeC.setExpression(exp);
indexes.add(excludeC);
            } else {
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_ACTION:
              case K_ALGORITHM:
              case K_ANY:
              case K_ARRAY_LITERAL:
              case K_BYTE:
              case K_CASCADE:
              case K_CASE:
              case K_CAST:
              case K_CHARACTER:
              case K_CHANGE:
              case K_CHAR:
              case K_COLUMN:
              case K_COLUMNS:
              case K_COMMIT:
              case K_COMMENT:
              case K_COSTS:
              case K_CREATE:
              case K_CYCLE:
              case K_DATETIMELITERAL:
              case K_DATE_LITERAL:
              case K_DESC:
              case K_DESCRIBE:
              case K_DISABLE:
              case K_DIV:
              case K_DO:
              case K_DUPLICATE:
              case K_ENABLE:
              case K_END:
              case K_EXCLUDE:
              case K_EXTRACT:
              case K_FIRST:
              case K_FALSE:
              case K_FOLLOWING:
              case K_FORMAT:
              case K_GROUP:
              case K_INDEX:
              case K_INSERT:
              case K_INTERVAL:
              case K_ISNULL:
              case K_JSON:
              case K_KEY:
              case K_FN:
              case K_LAST:
              case K_LEADING:
              case K_LOCAL:
              case K_MATERIALIZED:
              case K_NEXTVAL:
              case K_NO:
              case K_NOLOCK:
              case K_NULLS:
              case K_OF:
              case K_ON:
              case K_OPEN:
              case K_ORDER:
              case K_OVER:
              case K_PARALLEL:
              case K_PARTITION:
              case K_PATH:
              case K_PERCENT:
              case K_PRECISION:
              case K_PRIMARY:
              case K_PRIOR:
              case K_RANGE:
              case K_READ:
              case K_REPLACE:
              case K_ROW:
              case K_ROWS:
              case K_SCHEMA:
              case K_SEQUENCE:
              case K_SEPARATOR:
              case K_SESSION:
              case K_SIBLINGS:
              case K_SIZE:
              case K_SKIP:
              case K_START:
              case K_SYNONYM:
              case K_TABLE:
              case K_TABLES:
              case K_TEMP:
              case K_TEMPORARY:
              case K_TIMEOUT:
              case K_TO:
              case K_TOP:
              case K_TRUNCATE:
              case K_TRUE:
              case K_TYPE:
              case K_SIGNED:
              case K_UNSIGNED:
              case K_VALIDATE:
              case K_VALUE:
              case K_VALUES:
              case K_VIEW:
              case K_XML:
              case K_ZONE:
              case S_IDENTIFIER:
              case S_QUOTED_IDENTIFIER:{
                coldef = ColumnDefinition();
columnDefinitions.add(coldef);
                break;
                }
              default:
                jj_la1[391] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
            }
          }
          jj_consume_token(288);
          break;
          }
        default:
          jj_la1[392] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    } else {
      ;
    }
    label_92:
    while (true) {
      if (jj_2_182(2) && (getToken(1).kind != K_AS)) {
        ;
      } else {
        break label_92;
      }
      parameter = CreateParameter();
tableOptions.addAll(parameter);
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_DISABLE:
    case K_ENABLE:{
      rowMovement = RowMovement();
createTable.setRowMovement(rowMovement);
      break;
      }
    default:
      jj_la1[393] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_AS:{
      jj_consume_token(K_AS);
      if (jj_2_183(2147483647)) {
        jj_consume_token(287);
        select = SelectWithWithItems();
createTable.setSelect(select, true);
        jj_consume_token(288);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_SELECT:
        case K_VALUES:
        case K_WITH:
        case 287:{
          select = SelectWithWithItems();
createTable.setSelect(select, false);
          break;
          }
        default:
          jj_la1[394] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[395] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_LIKE:{
      jj_consume_token(K_LIKE);
      if (jj_2_184(2147483647)) {
        jj_consume_token(287);
        likeTable = Table();
createTable.setLikeTable(likeTable, true);
        jj_consume_token(288);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ACTION:
        case K_ALGORITHM:
        case K_ALL:
        case K_ANY:
        case K_ARRAY_LITERAL:
        case K_BYTE:
        case K_CASCADE:
        case K_CASE:
        case K_CASEWHEN:
        case K_CAST:
        case K_CHARACTER:
        case K_CHANGE:
        case K_CHAR:
        case K_COLUMN:
        case K_COLUMNS:
        case K_COMMIT:
        case K_COMMENT:
        case K_COSTS:
        case K_CREATE:
        case K_CYCLE:
        case K_DATETIMELITERAL:
        case K_DATE_LITERAL:
        case K_DESC:
        case K_DESCRIBE:
        case K_DISABLE:
        case K_DIV:
        case K_DO:
        case K_DOUBLE:
        case K_DUPLICATE:
        case K_ENABLE:
        case K_END:
        case K_EXCLUDE:
        case K_EXTRACT:
        case K_FIRST:
        case K_FALSE:
        case K_FOLLOWING:
        case K_FORMAT:
        case K_GROUP:
        case K_IF:
        case K_IIF:
        case K_IN:
        case K_INDEX:
        case K_INSERT:
        case K_INTERVAL:
        case K_ISNULL:
        case K_JSON:
        case K_KEY:
        case K_FN:
        case K_LAST:
        case K_LEADING:
        case K_LEFT:
        case K_LIMIT:
        case K_LOCAL:
        case K_MATERIALIZED:
        case K_NEXTVAL:
        case K_NO:
        case K_NOLOCK:
        case K_NULLS:
        case K_OF:
        case K_OFFSET:
        case K_ON:
        case K_OPEN:
        case K_ORDER:
        case K_OVER:
        case K_OPTIMIZE:
        case K_PARALLEL:
        case K_PARTITION:
        case K_PATH:
        case K_PERCENT:
        case K_PRECISION:
        case K_PRIMARY:
        case K_PRIOR:
        case K_PROCEDURE:
        case K_PUBLIC:
        case K_RANGE:
        case K_READ:
        case K_REPLACE:
        case K_RIGHT:
        case K_ROW:
        case K_ROWS:
        case K_SCHEMA:
        case K_SEQUENCE:
        case K_SEPARATOR:
        case K_SESSION:
        case K_SET:
        case K_SIBLINGS:
        case K_SIZE:
        case K_SKIP:
        case K_START:
        case K_SYNONYM:
        case K_TABLE:
        case K_TABLES:
        case K_TEMP:
        case K_TEMPORARY:
        case K_TIMEOUT:
        case K_TO:
        case K_TOP:
        case K_TRUNCATE:
        case K_TRUE:
        case K_TYPE:
        case K_SIGNED:
        case K_UNSIGNED:
        case K_VALIDATE:
        case K_VALUE:
        case K_VALUES:
        case K_VIEW:
        case K_XML:
        case K_ZONE:
        case S_IDENTIFIER:
        case S_QUOTED_IDENTIFIER:{
          likeTable = Table();
createTable.setLikeTable(likeTable, false);
          break;
          }
        default:
          jj_la1[396] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[397] = jj_gen;
      ;
    }
createTable.setTable(table);
        if (indexes.size() > 0)
            createTable.setIndexes(indexes);
        if (createOptions.size() > 0)
            createTable.setCreateOptionsStrings(createOptions);
        if (tableOptions.size() > 0)
            createTable.setTableOptionsStrings(tableOptions);
        if (columnDefinitions.size() > 0)
            createTable.setColumnDefinitions(columnDefinitions);
        if (columns.size() > 0)
            createTable.setColumns(columns);
        return createTable;
}

  final public ColDataType ColDataType() throws ParseException {ColDataType colDataType = new ColDataType();
    Token tk = null;
    Token tk2 = null;
    List<String> argumentsStringList = new ArrayList<String>();
    List<Integer> array = new ArrayList<Integer>();
    List<String> name;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_BIT:
    case K_CHARACTER:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_CHARACTER:{
        tk = jj_consume_token(K_CHARACTER);
        break;
        }
      case K_BIT:{
        tk = jj_consume_token(K_BIT);
        break;
        }
      default:
        jj_la1[398] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_VARYING:{
        tk2 = jj_consume_token(K_VARYING);
        break;
        }
      default:
        jj_la1[399] = jj_gen;
        ;
      }
colDataType.setDataType(tk.image + (tk2!=null?" " + tk2.image:""));
      break;
      }
    case K_DOUBLE:{
      tk = jj_consume_token(K_DOUBLE);
      if (jj_2_185(2)) {
        tk2 = jj_consume_token(K_PRECISION);
      } else {
        ;
      }
colDataType.setDataType(tk.image + (tk2!=null?" " + tk2.image:""));
      break;
      }
    case K_BINARY:
    case K_CHAR:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_INTERVAL:
    case K_JSON:
    case K_SET:
    case K_XML:
    case DT_ZONE:
    case S_IDENTIFIER:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        tk = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case K_DATETIMELITERAL:{
        tk = jj_consume_token(K_DATETIMELITERAL);
        break;
        }
      case K_DATE_LITERAL:{
        tk = jj_consume_token(K_DATE_LITERAL);
        break;
        }
      case K_XML:{
        tk = jj_consume_token(K_XML);
        break;
        }
      case K_INTERVAL:{
        tk = jj_consume_token(K_INTERVAL);
        break;
        }
      case DT_ZONE:{
        tk = jj_consume_token(DT_ZONE);
        break;
        }
      case K_CHAR:{
        tk = jj_consume_token(K_CHAR);
        break;
        }
      case K_SET:{
        tk = jj_consume_token(K_SET);
        break;
        }
      case K_BINARY:{
        tk = jj_consume_token(K_BINARY);
        break;
        }
      case K_JSON:{
        tk = jj_consume_token(K_JSON);
        break;
        }
      default:
        jj_la1[400] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 291:{
        jj_consume_token(291);
        tk2 = jj_consume_token(S_IDENTIFIER);
        break;
        }
      default:
        jj_la1[401] = jj_gen;
        ;
      }
if (tk2!=null) colDataType.setDataType(tk.image + "." + tk2.image); else colDataType.setDataType(tk.image);
      break;
      }
    case K_UNSIGNED:{
      tk = jj_consume_token(K_UNSIGNED);
      if (jj_2_186(2)) {
        tk2 = jj_consume_token(S_IDENTIFIER);
      } else {
        ;
      }
if (tk2!=null) colDataType.setDataType(tk.image + " " + tk2.image); else colDataType.setDataType(tk.image);
      break;
      }
    default:
      jj_la1[402] = jj_gen;
      if (jj_2_187(2)) {
        tk = jj_consume_token(K_SIGNED);
        tk2 = jj_consume_token(S_IDENTIFIER);
colDataType.setDataType(tk.image + " " + tk2.image);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_SIGNED:{
          tk = jj_consume_token(K_SIGNED);
colDataType.setDataType(tk.image);
          break;
          }
        default:
          jj_la1[403] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    if (jj_2_189(2)) {
      jj_consume_token(287);
tk2 =null;
      label_93:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_CHAR:
        case S_LONG:
        case S_IDENTIFIER:
        case S_CHAR_LITERAL:{
          ;
          break;
          }
        default:
          jj_la1[404] = jj_gen;
          break label_93;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_LONG:{
          tk = jj_consume_token(S_LONG);
          if (jj_2_188(2)) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_BYTE:{
              tk2 = jj_consume_token(K_BYTE);
              break;
              }
            case K_CHAR:{
              tk2 = jj_consume_token(K_CHAR);
              break;
              }
            default:
              jj_la1[405] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          } else {
            ;
          }
          break;
          }
        case S_CHAR_LITERAL:{
          tk = jj_consume_token(S_CHAR_LITERAL);
          break;
          }
        case S_IDENTIFIER:{
          tk = jj_consume_token(S_IDENTIFIER);
          break;
          }
        case K_CHAR:{
          tk = jj_consume_token(K_CHAR);
          break;
          }
        default:
          jj_la1[406] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
argumentsStringList.add(tk.image + (tk2!=null?" " + tk2.image:""));
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          jj_consume_token(K_COMMA);

          break;
          }
        default:
          jj_la1[407] = jj_gen;
          ;
        }
      }
      jj_consume_token(288);
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 317:{
      label_94:
      while (true) {
        jj_consume_token(317);
tk=null;
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_LONG:{
          tk = jj_consume_token(S_LONG);
          break;
          }
        default:
          jj_la1[408] = jj_gen;
          ;
        }
array.add(tk!=null?Integer.valueOf(tk.image):null);
        jj_consume_token(318);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 317:{
          ;
          break;
          }
        default:
          jj_la1[409] = jj_gen;
          break label_94;
        }
      }
colDataType.setArrayData(array);
      break;
      }
    default:
      jj_la1[410] = jj_gen;
      ;
    }
    if (jj_2_190(2)) {
      jj_consume_token(K_CHARACTER);
      jj_consume_token(K_SET);
      tk = jj_consume_token(S_IDENTIFIER);
colDataType.setCharacterSet(tk.image);
    } else {
      ;
    }
if (argumentsStringList.size() > 0)
            colDataType.setArgumentsStringList(argumentsStringList);
        return colDataType;
}

  final public CreateView CreateView() throws ParseException {CreateView createView = new CreateView();
    Table view = null;
    Select select = null;
    List<String> columnNames = null;
    jj_consume_token(K_CREATE);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_OR:{
      jj_consume_token(K_OR);
      jj_consume_token(K_REPLACE);
createView.setOrReplace(true);
      break;
      }
    default:
      jj_la1[411] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FORCE:
    case K_NO:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NO:{
        jj_consume_token(K_NO);
        jj_consume_token(K_FORCE);
createView.setForce(ForceOption.NO_FORCE);
        break;
        }
      case K_FORCE:{
        jj_consume_token(K_FORCE);
createView.setForce(ForceOption.FORCE);
        break;
        }
      default:
        jj_la1[412] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[413] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_TEMP:
    case K_TEMPORARY:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_TEMP:{
        jj_consume_token(K_TEMP);
createView.setTemporary(TemporaryOption.TEMP);
        break;
        }
      case K_TEMPORARY:{
        jj_consume_token(K_TEMPORARY);
createView.setTemporary(TemporaryOption.TEMPORARY);
        break;
        }
      default:
        jj_la1[414] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[415] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_MATERIALIZED:{
      jj_consume_token(K_MATERIALIZED);
createView.setMaterialized(true);
      break;
      }
    default:
      jj_la1[416] = jj_gen;
      ;
    }
    jj_consume_token(K_VIEW);
    view = Table();
createView.setView(view);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 287:{
      columnNames = ColumnsNamesList();
createView.setColumnNames(columnNames);
      break;
      }
    default:
      jj_la1[417] = jj_gen;
      ;
    }
    jj_consume_token(K_AS);
    select = SelectWithWithItems();
createView.setSelect(select);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_WITH:{
      jj_consume_token(K_WITH);
      jj_consume_token(K_READ);
      jj_consume_token(K_ONLY);
createView.setWithReadOnly(true);
      break;
      }
    default:
      jj_la1[418] = jj_gen;
      ;
    }
return createView;
}

  final public ReferentialAction.Action Action() throws ParseException {ReferentialAction.Action action = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_CASCADE:{
      jj_consume_token(K_CASCADE);
action=ReferentialAction.Action.CASCADE;
      break;
      }
    case K_RESTRICT:{
      jj_consume_token(K_RESTRICT);
action=ReferentialAction.Action.RESTRICT;
      break;
      }
    case K_NO:{
      jj_consume_token(K_NO);
      jj_consume_token(K_ACTION);
action=ReferentialAction.Action.NO_ACTION;
      break;
      }
    case K_SET:{
      jj_consume_token(K_SET);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NULL:{
        jj_consume_token(K_NULL);
action=ReferentialAction.Action.SET_NULL;
        break;
        }
      case K_DEFAULT:{
        jj_consume_token(K_DEFAULT);
action=ReferentialAction.Action.SET_DEFAULT;
        break;
        }
      default:
        jj_la1[419] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[420] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return action;
}

  final public AlterView AlterView() throws ParseException {AlterView alterView = new AlterView();
    Table view = null;
    SelectBody select = null;
    List<String> columnNames = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ALTER:{
      jj_consume_token(K_ALTER);
      break;
      }
    case K_REPLACE:{
      jj_consume_token(K_REPLACE);
alterView.setUseReplace(true);
      break;
      }
    default:
      jj_la1[421] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(K_VIEW);
    view = Table();
alterView.setView(view);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 287:{
      columnNames = ColumnsNamesList();
alterView.setColumnNames(columnNames);
      break;
      }
    default:
      jj_la1[422] = jj_gen;
      ;
    }
    jj_consume_token(K_AS);
    select = SelectBody();
alterView.setSelectBody(select);
return alterView;
}

  final public List<String> CreateParameter() throws ParseException {String retval = "";
    Token tk = null;
    Token tk2 = null;
    StringBuilder identifier = new StringBuilder("");
    Expression exp = null;
    List<String> param = new ArrayList<String>();
    ColDataType colDataType;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        tk = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case S_QUOTED_IDENTIFIER:{
        tk = jj_consume_token(S_QUOTED_IDENTIFIER);
        break;
        }
      default:
        jj_la1[423] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
identifier.append(tk.image);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 291:{
        jj_consume_token(291);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_IDENTIFIER:{
          tk2 = jj_consume_token(S_IDENTIFIER);
          break;
          }
        case S_QUOTED_IDENTIFIER:{
          tk2 = jj_consume_token(S_QUOTED_IDENTIFIER);
          break;
          }
        default:
          jj_la1[424] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
identifier.append("."); identifier.append(tk2.image);
        break;
        }
      default:
        jj_la1[425] = jj_gen;
        ;
      }
param.add(identifier.toString());
      break;
      }
    case K_NULL:{
      tk = jj_consume_token(K_NULL);
param.add(tk.image);
      break;
      }
    case K_NOT:{
      tk = jj_consume_token(K_NOT);
param.add(tk.image);
      break;
      }
    case K_PRIMARY:{
      tk = jj_consume_token(K_PRIMARY);
param.add(tk.image);
      break;
      }
    case K_DEFAULT:{
      tk = jj_consume_token(K_DEFAULT);
param.add(tk.image);
      break;
      }
    case K_FOREIGN:{
      tk = jj_consume_token(K_FOREIGN);
param.add(tk.image);
      break;
      }
    case K_REFERENCES:{
      tk = jj_consume_token(K_REFERENCES);
param.add(tk.image);
      break;
      }
    case K_KEY:{
      tk = jj_consume_token(K_KEY);
param.add(tk.image);
      break;
      }
    case S_CHAR_LITERAL:{
      tk = jj_consume_token(S_CHAR_LITERAL);
param.add(tk.image);
      break;
      }
    case S_DOUBLE:
    case S_LONG:
    case 295:
    case 307:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 295:
      case 307:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 295:{
          jj_consume_token(295);
retval = "+";
          break;
          }
        case 307:{
          jj_consume_token(307);
retval = "-";
          break;
          }
        default:
          jj_la1[426] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[427] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_LONG:{
        tk = jj_consume_token(S_LONG);
retval += tk.image;
        break;
        }
      case S_DOUBLE:{
        tk = jj_consume_token(S_DOUBLE);
retval += tk.image;
        break;
        }
      default:
        jj_la1[428] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
param.add(retval);
      break;
      }
    case K_AS:{
      tk = jj_consume_token(K_AS);
param.add(tk.image);
      break;
      }
    case K_ON:{
      tk = jj_consume_token(K_ON);
param.add(tk.image);
      break;
      }
    case K_COMMIT:{
      tk = jj_consume_token(K_COMMIT);
param.add(tk.image);
      break;
      }
    case K_DROP:{
      tk = jj_consume_token(K_DROP);
param.add(tk.image);
      break;
      }
    case K_ROWS:{
      tk = jj_consume_token(K_ROWS);
param.add(tk.image);
      break;
      }
    case K_UNIQUE:{
      tk = jj_consume_token(K_UNIQUE);
param.add(tk.image);
      break;
      }
    case K_CASCADE:{
      tk = jj_consume_token(K_CASCADE);
param.add(tk.image);
      break;
      }
    case K_DELETE:{
      tk = jj_consume_token(K_DELETE);
param.add(tk.image);
      break;
      }
    case K_UPDATE:{
      tk = jj_consume_token(K_UPDATE);
param.add(tk.image);
      break;
      }
    case K_TIME_KEY_EXPR:{
      tk = jj_consume_token(K_TIME_KEY_EXPR);
param.add(new TimeKeyExpression(tk.image).toString());
      break;
      }
    case 289:{
      jj_consume_token(289);
param.add("=");
      break;
      }
    default:
      jj_la1[429] = jj_gen;
      if (jj_2_191(3)) {
        jj_consume_token(K_USING);
        jj_consume_token(K_INDEX);
        jj_consume_token(K_TABLESPACE);
        retval = RelObjectName();
param.add("USING"); param.add("INDEX"); param.add("TABLESPACE"); param.add(retval);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_TABLESPACE:{
          jj_consume_token(K_TABLESPACE);
          retval = RelObjectName();
param.add("TABLESPACE"); param.add(retval);
          break;
          }
        case 287:{
          retval = AList();
param.add(retval);
          break;
          }
        case K_CHECK:{
          jj_consume_token(K_CHECK);
          jj_consume_token(287);
          exp = Expression();
          jj_consume_token(288);
param.add("CHECK"); param.add("(" + exp.toString() + ")");
          break;
          }
        case K_CONSTRAINT:{
          tk = jj_consume_token(K_CONSTRAINT);
param.add(tk.image);
          break;
          }
        case K_WITH:{
          tk = jj_consume_token(K_WITH);
param.add(tk.image);
          break;
          }
        case K_EXCLUDE:{
          tk = jj_consume_token(K_EXCLUDE);
param.add(tk.image);
          break;
          }
        case K_WHERE:{
          tk = jj_consume_token(K_WHERE);
param.add(tk.image);
          break;
          }
        case K_UNSIGNED:{
          tk = jj_consume_token(K_UNSIGNED);
param.add(tk.image);
          break;
          }
        case K_TEMP:{
          tk = jj_consume_token(K_TEMP);
param.add(tk.image);
          break;
          }
        case K_TEMPORARY:{
          tk = jj_consume_token(K_TEMPORARY);
param.add(tk.image);
          break;
          }
        case K_PARTITION:{
          tk = jj_consume_token(K_PARTITION);
param.add(tk.image);
          break;
          }
        case K_BY:{
          tk = jj_consume_token(K_BY);
param.add(tk.image);
          break;
          }
        case K_IN:{
          tk = jj_consume_token(K_IN);
param.add(tk.image);
          break;
          }
        case K_TYPE:{
          tk = jj_consume_token(K_TYPE);
param.add(tk.image);
          break;
          }
        case K_COMMENT:{
          tk = jj_consume_token(K_COMMENT);
param.add(tk.image);
          break;
          }
        case K_USING:{
          tk = jj_consume_token(K_USING);
param.add(tk.image);
          break;
          }
        case K_COLLATE:{
          tk = jj_consume_token(K_COLLATE);
param.add(tk.image);
          break;
          }
        case K_ASC:{
          tk = jj_consume_token(K_ASC);
param.add(tk.image);
          break;
          }
        case K_DESC:{
          tk = jj_consume_token(K_DESC);
param.add(tk.image);
          break;
          }
        case K_TRUE:{
          tk = jj_consume_token(K_TRUE);
param.add(tk.image);
          break;
          }
        case K_FALSE:{
          tk = jj_consume_token(K_FALSE);
param.add(tk.image);
          break;
          }
        case K_PARALLEL:{
          tk = jj_consume_token(K_PARALLEL);
param.add(tk.image);
          break;
          }
        case K_ARRAY_LITERAL:{
          jj_consume_token(K_ARRAY_LITERAL);
          exp = ArrayConstructor(true);
param.add(exp.toString());
          break;
          }
        case 323:{
          tk = jj_consume_token(323);
          colDataType = ColDataType();
param.add(tk.image); param.add(colDataType.toString());
          break;
          }
        default:
          jj_la1[430] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
return param;
}

// row_movement_clause https://docs.oracle.com/cd/B19306_01/server.102/b14200/statements_7002.htm#i2204697
  final public RowMovement RowMovement() throws ParseException {RowMovement rowMovement = new RowMovement();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ENABLE:{
      jj_consume_token(K_ENABLE);
      jj_consume_token(K_ROW);
      jj_consume_token(K_MOVEMENT);
rowMovement.setMode(RowMovementMode.ENABLE);
      break;
      }
    case K_DISABLE:{
      jj_consume_token(K_DISABLE);
      jj_consume_token(K_ROW);
      jj_consume_token(K_MOVEMENT);
rowMovement.setMode(RowMovementMode.DISABLE);
      break;
      }
    default:
      jj_la1[431] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return rowMovement;
}

  final public String AList() throws ParseException {StringBuilder retval = new StringBuilder("(");
    Token tk = null;
    String name = null;
    jj_consume_token(287);
    label_95:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ACTION:
      case K_ALGORITHM:
      case K_ANY:
      case K_ARRAY_LITERAL:
      case K_BYTE:
      case K_CASCADE:
      case K_CASE:
      case K_CAST:
      case K_CHARACTER:
      case K_CHANGE:
      case K_CHAR:
      case K_COLUMN:
      case K_COLUMNS:
      case K_COMMIT:
      case K_COMMENT:
      case K_COSTS:
      case K_CYCLE:
      case K_DATETIMELITERAL:
      case K_DATE_LITERAL:
      case K_DESC:
      case K_DESCRIBE:
      case K_DISABLE:
      case K_DIV:
      case K_DO:
      case K_DUPLICATE:
      case K_ENABLE:
      case K_END:
      case K_EXCLUDE:
      case K_EXTRACT:
      case K_FIRST:
      case K_FALSE:
      case K_FOLLOWING:
      case K_FORMAT:
      case K_INDEX:
      case K_INSERT:
      case K_ISNULL:
      case K_JSON:
      case K_KEY:
      case K_FN:
      case K_LAST:
      case K_LEADING:
      case K_LOCAL:
      case K_MATERIALIZED:
      case K_NEXTVAL:
      case K_NO:
      case K_NOLOCK:
      case K_NULLS:
      case K_OF:
      case K_OPEN:
      case K_OVER:
      case K_PARALLEL:
      case K_PARTITION:
      case K_PATH:
      case K_PERCENT:
      case K_PRECISION:
      case K_PRIMARY:
      case K_PRIOR:
      case K_RANGE:
      case K_READ:
      case K_REPLACE:
      case K_ROW:
      case K_ROWS:
      case K_SCHEMA:
      case K_SEQUENCE:
      case K_SEPARATOR:
      case K_SESSION:
      case K_SIBLINGS:
      case K_SIZE:
      case K_SKIP:
      case K_SYNONYM:
      case K_TABLE:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIMEOUT:
      case K_TO:
      case K_TRUNCATE:
      case K_TRUE:
      case K_TYPE:
      case K_SIGNED:
      case K_UNSIGNED:
      case K_VALIDATE:
      case K_VIEW:
      case K_XML:
      case K_ZONE:
      case S_DOUBLE:
      case S_LONG:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:{
        ;
        break;
        }
      default:
        jj_la1[432] = jj_gen;
        break label_95;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_DOUBLE:
      case S_LONG:
      case S_CHAR_LITERAL:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_LONG:{
          tk = jj_consume_token(S_LONG);
          break;
          }
        case S_DOUBLE:{
          tk = jj_consume_token(S_DOUBLE);
          break;
          }
        case S_CHAR_LITERAL:{
          tk = jj_consume_token(S_CHAR_LITERAL);
          break;
          }
        default:
          jj_la1[433] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
retval.append(tk.image);
        break;
        }
      case K_ACTION:
      case K_ALGORITHM:
      case K_ANY:
      case K_ARRAY_LITERAL:
      case K_BYTE:
      case K_CASCADE:
      case K_CASE:
      case K_CAST:
      case K_CHARACTER:
      case K_CHANGE:
      case K_CHAR:
      case K_COLUMN:
      case K_COLUMNS:
      case K_COMMIT:
      case K_COMMENT:
      case K_COSTS:
      case K_CYCLE:
      case K_DATETIMELITERAL:
      case K_DATE_LITERAL:
      case K_DESC:
      case K_DESCRIBE:
      case K_DISABLE:
      case K_DIV:
      case K_DO:
      case K_DUPLICATE:
      case K_ENABLE:
      case K_END:
      case K_EXCLUDE:
      case K_EXTRACT:
      case K_FIRST:
      case K_FALSE:
      case K_FOLLOWING:
      case K_FORMAT:
      case K_INDEX:
      case K_INSERT:
      case K_ISNULL:
      case K_JSON:
      case K_KEY:
      case K_FN:
      case K_LAST:
      case K_LEADING:
      case K_LOCAL:
      case K_MATERIALIZED:
      case K_NEXTVAL:
      case K_NO:
      case K_NOLOCK:
      case K_NULLS:
      case K_OF:
      case K_OPEN:
      case K_OVER:
      case K_PARALLEL:
      case K_PARTITION:
      case K_PATH:
      case K_PERCENT:
      case K_PRECISION:
      case K_PRIMARY:
      case K_PRIOR:
      case K_RANGE:
      case K_READ:
      case K_REPLACE:
      case K_ROW:
      case K_ROWS:
      case K_SCHEMA:
      case K_SEQUENCE:
      case K_SEPARATOR:
      case K_SESSION:
      case K_SIBLINGS:
      case K_SIZE:
      case K_SKIP:
      case K_SYNONYM:
      case K_TABLE:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIMEOUT:
      case K_TO:
      case K_TRUNCATE:
      case K_TRUE:
      case K_TYPE:
      case K_SIGNED:
      case K_UNSIGNED:
      case K_VALIDATE:
      case K_VIEW:
      case K_XML:
      case K_ZONE:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:{
        name = RelObjectNameWithoutValue();
retval.append(name);
        break;
        }
      default:
        jj_la1[434] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:
      case 289:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          jj_consume_token(K_COMMA);
retval.append(",");
          break;
          }
        case 289:{
          jj_consume_token(289);
retval.append("=");
          break;
          }
        default:
          jj_la1[435] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[436] = jj_gen;
        ;
      }
    }
    jj_consume_token(288);
retval.append(")");
        return retval.toString();
}

  final public String ColumnsNamesListItem() throws ParseException {Token tk = null;
    String item = null;
    item = RelObjectName();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 287:{
      jj_consume_token(287);
      tk = jj_consume_token(S_LONG);
      jj_consume_token(288);
item = item + "(" + tk.image + ")";
      break;
      }
    default:
      jj_la1[437] = jj_gen;
      ;
    }
return item;
}

  final public List<String> ColumnsNamesList() throws ParseException {List<String> retval = new ArrayList<String>();
    String img = null;
    jj_consume_token(287);
    img = ColumnsNamesListItem();
retval.add(img);
    label_96:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[438] = jj_gen;
        break label_96;
      }
      jj_consume_token(K_COMMA);
      img = ColumnsNamesListItem();
retval.add(img);
    }
    jj_consume_token(288);
return retval;
}

  final public Drop Drop() throws ParseException {Drop drop = new Drop();
    Token tk = null;
    Table name;
    List<String> dropArgs = new ArrayList<String>();
    jj_consume_token(K_DROP);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_IDENTIFIER:{
      tk = jj_consume_token(S_IDENTIFIER);
      break;
      }
    case K_TABLE:{
      tk = jj_consume_token(K_TABLE);
      break;
      }
    case K_INDEX:{
      tk = jj_consume_token(K_INDEX);
      break;
      }
    case K_VIEW:{
      tk = jj_consume_token(K_VIEW);
      break;
      }
    case K_SCHEMA:{
      tk = jj_consume_token(K_SCHEMA);
      break;
      }
    case K_SEQUENCE:{
      tk = jj_consume_token(K_SEQUENCE);
      break;
      }
    default:
      jj_la1[439] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
drop.setType(tk.image);
    if (jj_2_192(2)) {
      jj_consume_token(K_IF);
      jj_consume_token(K_EXISTS);
drop.setIfExists(true);
    } else {
      ;
    }
    name = Table();
drop.setName(name);
    label_97:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_CASCADE:
      case K_RESTRICT:
      case S_IDENTIFIER:{
        ;
        break;
        }
      default:
        jj_la1[440] = jj_gen;
        break label_97;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        tk = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case K_CASCADE:{
        tk = jj_consume_token(K_CASCADE);
        break;
        }
      case K_RESTRICT:{
        tk = jj_consume_token(K_RESTRICT);
        break;
        }
      default:
        jj_la1[441] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
dropArgs.add(tk.image);
    }
if (dropArgs.size() > 0)
            drop.setParameters(dropArgs);
        return drop;
}

  final public Truncate Truncate() throws ParseException {Truncate truncate = new Truncate();
    Table table;
    jj_consume_token(K_TRUNCATE);
    jj_consume_token(K_TABLE);
    table = Table();
truncate.setTable(table); truncate.setCascade(false);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_CASCADE:{
      jj_consume_token(K_CASCADE);
truncate.setCascade(true);
      break;
      }
    default:
      jj_la1[442] = jj_gen;
      ;
    }
return truncate;
}

  final public AlterExpression.ColumnDataType AlterExpressionColumnDataType() throws ParseException {String columnName = null;
    boolean withType = false;
    ColDataType dataType = null;
    List<String> columnSpecs = null;
    List<String> parameter = null;
    columnName = RelObjectName();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_TYPE:{
      jj_consume_token(K_TYPE);
withType = true;
      break;
      }
    default:
      jj_la1[443] = jj_gen;
      ;
    }
    dataType = ColDataType();
columnSpecs = new ArrayList<String>();
    label_98:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ARRAY_LITERAL:
      case K_AS:
      case K_ASC:
      case K_BY:
      case K_CASCADE:
      case K_CHECK:
      case K_COLLATE:
      case K_COMMIT:
      case K_COMMENT:
      case K_CONSTRAINT:
      case K_DEFAULT:
      case K_DELETE:
      case K_DESC:
      case K_DROP:
      case K_EXCLUDE:
      case K_FALSE:
      case K_FOREIGN:
      case K_IN:
      case K_KEY:
      case K_NOT:
      case K_NULL:
      case K_ON:
      case K_PARALLEL:
      case K_PARTITION:
      case K_PRIMARY:
      case K_REFERENCES:
      case K_ROWS:
      case K_TABLESPACE:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_TRUE:
      case K_TYPE:
      case K_UNIQUE:
      case K_UPDATE:
      case K_USING:
      case K_UNSIGNED:
      case K_WHERE:
      case K_WITH:
      case S_DOUBLE:
      case S_LONG:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:
      case 287:
      case 289:
      case 295:
      case 307:
      case 323:{
        ;
        break;
        }
      default:
        jj_la1[444] = jj_gen;
        break label_98;
      }
      parameter = CreateParameter();
columnSpecs.addAll(parameter);
    }
return new AlterExpression.ColumnDataType(columnName, withType, dataType, columnSpecs);
}

  final public AlterExpression.ColumnDropNotNull AlterExpressionColumnDropNotNull() throws ParseException {String columnName = null;
    boolean withNot = false;
    ColDataType dataType = null;
    List<String> columnSpecs = null;
    List<String> parameter = null;
    columnName = RelObjectName();
    jj_consume_token(K_DROP);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_NOT:{
      jj_consume_token(K_NOT);
withNot = true;
      break;
      }
    default:
      jj_la1[445] = jj_gen;
      ;
    }
    jj_consume_token(K_NULL);
return new AlterExpression.ColumnDropNotNull(columnName, withNot);
}

  final public List<ConstraintState> AlterExpressionConstraintState() throws ParseException {List<ConstraintState> retval = new ArrayList<ConstraintState>();
    label_99:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_DEFERRABLE:
      case K_DISABLE:
      case K_ENABLE:
      case K_NOT:
      case K_NOVALIDATE:
      case K_VALIDATE:{
        ;
        break;
        }
      default:
        jj_la1[446] = jj_gen;
        break label_99;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_DEFERRABLE:{
        jj_consume_token(K_DEFERRABLE);
retval.add(new DeferrableConstraint(false));
        break;
        }
      case K_NOT:{
        jj_consume_token(K_NOT);
        jj_consume_token(K_DEFERRABLE);
retval.add(new DeferrableConstraint(true));
        break;
        }
      case K_VALIDATE:{
        jj_consume_token(K_VALIDATE);
retval.add(new ValidateConstraint(false));
        break;
        }
      case K_NOVALIDATE:{
        jj_consume_token(K_NOVALIDATE);
retval.add(new ValidateConstraint(true));
        break;
        }
      case K_ENABLE:{
        jj_consume_token(K_ENABLE);
retval.add(new EnableConstraint(false));
        break;
        }
      case K_DISABLE:{
        jj_consume_token(K_DISABLE);
retval.add(new EnableConstraint(true));
        break;
        }
      default:
        jj_la1[447] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return retval;
}

/**
* This production needs refactoring to multiple smaller productions. The target class should
* be splitted as well.
*/
  final public AlterExpression AlterExpression() throws ParseException {AlterExpression alterExp = new AlterExpression();
    Token tk;
    Token tk2 = null;
    String sk3 = null;
    String sk4 = null;
    ColDataType dataType;
    List<String> columnNames = null;
    List<ConstraintState> constraints = null;
    ForeignKeyIndex fkIndex = null;
    Index index = null;
    Table fkTable = null;
    AlterExpression.ColumnDataType alterExpressionColumnDataType = null;
    AlterExpression.ColumnDropNotNull alterExpressionColumnDropNotNull = null;
    ReferentialAction.Action action = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ADD:
    case K_ALTER:
    case K_MODIFY:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ADD:{
        jj_consume_token(K_ADD);
alterExp.setOperation(AlterOperation.ADD);
        break;
        }
      case K_ALTER:{
        jj_consume_token(K_ALTER);
alterExp.setOperation(AlterOperation.ALTER);
        break;
        }
      case K_MODIFY:{
        jj_consume_token(K_MODIFY);
alterExp.setOperation(AlterOperation.MODIFY);
        break;
        }
      default:
        jj_la1[448] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      if (jj_2_199(2)) {
        jj_consume_token(K_PRIMARY);
        jj_consume_token(K_KEY);
        columnNames = ColumnsNamesList();
alterExp.setPkColumns(columnNames);
        constraints = AlterExpressionConstraintState();
alterExp.setConstraints(constraints);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_USING:{
          jj_consume_token(K_USING);
          sk4 = RelObjectName();
alterExp.addParameters("USING", sk4);
          break;
          }
        default:
          jj_la1[449] = jj_gen;
          ;
        }
      } else if (jj_2_200(2)) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_KEY:{
          tk = jj_consume_token(K_KEY);
alterExp.setUk(true);
          break;
          }
        case K_INDEX:{
          tk = jj_consume_token(K_INDEX);
          break;
          }
        default:
          jj_la1[450] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        sk3 = RelObjectName();
        columnNames = ColumnsNamesList();
index = new Index().withType(tk.image).withName(sk3).withColumnsNames(columnNames);
                alterExp.setIndex(index);
        constraints = AlterExpressionConstraintState();
alterExp.setConstraints(constraints);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_USING:{
          jj_consume_token(K_USING);
          sk4 = RelObjectName();
alterExp.addParameters("USING", sk4);
          break;
          }
        default:
          jj_la1[451] = jj_gen;
          ;
        }
      } else if (jj_2_201(3)) {
        if (jj_2_193(2)) {
          jj_consume_token(K_COLUMN);
alterExp.hasColumn(true);
        } else {
          ;
        }
        if (jj_2_194(2)) {
          alterExpressionColumnDataType = AlterExpressionColumnDataType();
alterExp.addColDataType(alterExpressionColumnDataType);
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ACTION:
          case K_ALGORITHM:
          case K_ANY:
          case K_ARRAY_LITERAL:
          case K_BYTE:
          case K_CASCADE:
          case K_CASE:
          case K_CAST:
          case K_CHARACTER:
          case K_CHANGE:
          case K_CHAR:
          case K_COLUMN:
          case K_COLUMNS:
          case K_COMMIT:
          case K_COMMENT:
          case K_COSTS:
          case K_CREATE:
          case K_CYCLE:
          case K_DATETIMELITERAL:
          case K_DATE_LITERAL:
          case K_DESC:
          case K_DESCRIBE:
          case K_DISABLE:
          case K_DIV:
          case K_DO:
          case K_DUPLICATE:
          case K_ENABLE:
          case K_END:
          case K_EXCLUDE:
          case K_EXTRACT:
          case K_FIRST:
          case K_FALSE:
          case K_FOLLOWING:
          case K_FORMAT:
          case K_GROUP:
          case K_INDEX:
          case K_INSERT:
          case K_INTERVAL:
          case K_ISNULL:
          case K_JSON:
          case K_KEY:
          case K_FN:
          case K_LAST:
          case K_LEADING:
          case K_LOCAL:
          case K_MATERIALIZED:
          case K_NEXTVAL:
          case K_NO:
          case K_NOLOCK:
          case K_NULLS:
          case K_OF:
          case K_ON:
          case K_OPEN:
          case K_ORDER:
          case K_OVER:
          case K_PARALLEL:
          case K_PARTITION:
          case K_PATH:
          case K_PERCENT:
          case K_PRECISION:
          case K_PRIMARY:
          case K_PRIOR:
          case K_RANGE:
          case K_READ:
          case K_REPLACE:
          case K_ROW:
          case K_ROWS:
          case K_SCHEMA:
          case K_SEQUENCE:
          case K_SEPARATOR:
          case K_SESSION:
          case K_SIBLINGS:
          case K_SIZE:
          case K_SKIP:
          case K_START:
          case K_SYNONYM:
          case K_TABLE:
          case K_TABLES:
          case K_TEMP:
          case K_TEMPORARY:
          case K_TIMEOUT:
          case K_TO:
          case K_TOP:
          case K_TRUNCATE:
          case K_TRUE:
          case K_TYPE:
          case K_SIGNED:
          case K_UNSIGNED:
          case K_VALIDATE:
          case K_VALUE:
          case K_VALUES:
          case K_VIEW:
          case K_XML:
          case K_ZONE:
          case S_IDENTIFIER:
          case S_QUOTED_IDENTIFIER:{
            alterExpressionColumnDropNotNull = AlterExpressionColumnDropNotNull();
alterExp.addColDropNotNull( alterExpressionColumnDropNotNull);
            break;
            }
          default:
            jj_la1[452] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 287:{
          jj_consume_token(287);
          alterExpressionColumnDataType = AlterExpressionColumnDataType();
alterExp.addColDataType(alterExpressionColumnDataType);
          label_100:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_COMMA:{
              ;
              break;
              }
            default:
              jj_la1[453] = jj_gen;
              break label_100;
            }
            jj_consume_token(K_COMMA);
            alterExpressionColumnDataType = AlterExpressionColumnDataType();
alterExp.addColDataType(alterExpressionColumnDataType);
          }
          jj_consume_token(288);
          break;
          }
        case K_UNIQUE:{
          jj_consume_token(K_UNIQUE);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_INDEX:
          case K_KEY:{
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_KEY:{
              jj_consume_token(K_KEY);
alterExp.setUk(true);
              break;
              }
            case K_INDEX:{
              jj_consume_token(K_INDEX);
              break;
              }
            default:
              jj_la1[454] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case S_IDENTIFIER:{
              tk = jj_consume_token(S_IDENTIFIER);
              break;
              }
            case S_QUOTED_IDENTIFIER:{
              tk = jj_consume_token(S_QUOTED_IDENTIFIER);
              break;
              }
            default:
              jj_la1[455] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
alterExp.setUkName(tk.image);
            break;
            }
          default:
            jj_la1[456] = jj_gen;
            ;
          }
          columnNames = ColumnsNamesList();
alterExp.setUkColumns(columnNames);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_USING:{
            jj_consume_token(K_USING);
            sk4 = RelObjectName();
alterExp.addParameters("USING", sk4);
            break;
            }
          default:
            jj_la1[457] = jj_gen;
            ;
          }
          break;
          }
        case K_FOREIGN:{
          jj_consume_token(K_FOREIGN);
          jj_consume_token(K_KEY);
          columnNames = ColumnsNamesList();
alterExp.setFkColumns(columnNames); columnNames = null;
          jj_consume_token(K_REFERENCES);
          fkTable = Table();
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 287:{
            columnNames = ColumnsNamesList();
            break;
            }
          default:
            jj_la1[458] = jj_gen;
            ;
          }
alterExp.setFkSourceSchema(fkTable.getSchemaName());
                        alterExp.setFkSourceTable(fkTable.getName());
                        alterExp.setFkSourceColumns(columnNames);
          if (jj_2_195(2)) {
            jj_consume_token(K_ON);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_DELETE:{
              tk = jj_consume_token(K_DELETE);
              break;
              }
            case K_UPDATE:{
              tk = jj_consume_token(K_UPDATE);
              break;
              }
            default:
              jj_la1[459] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            action = Action();
alterExp.setReferentialAction(ReferentialAction.Type.valueOf(tk.image), action);
          } else {
            ;
          }
          if (jj_2_196(2)) {
            jj_consume_token(K_ON);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_DELETE:{
              tk = jj_consume_token(K_DELETE);
              break;
              }
            case K_UPDATE:{
              tk = jj_consume_token(K_UPDATE);
              break;
              }
            default:
              jj_la1[460] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            action = Action();
alterExp.setReferentialAction(ReferentialAction.Type.valueOf(tk.image), action);
          } else {
            ;
          }
          break;
          }
        case K_CONSTRAINT:{
          jj_consume_token(K_CONSTRAINT);
          sk3 = RelObjectName();
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_FOREIGN:{
            tk = jj_consume_token(K_FOREIGN);
            tk2 = jj_consume_token(K_KEY);
            columnNames = ColumnsNamesList();
fkIndex = new ForeignKeyIndex()
                        .withName(sk3)
                        .withType(tk.image + " " + tk2.image)
                        .withColumnsNames(columnNames);
                                            columnNames = null;
            jj_consume_token(K_REFERENCES);
            fkTable = Table();
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case 287:{
              columnNames = ColumnsNamesList();
              break;
              }
            default:
              jj_la1[461] = jj_gen;
              ;
            }
fkIndex.withTable(fkTable).withReferencedColumnNames(columnNames);
                        alterExp.setIndex(fkIndex);
            if (jj_2_197(2)) {
              jj_consume_token(K_ON);
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_DELETE:{
                tk = jj_consume_token(K_DELETE);
                break;
                }
              case K_UPDATE:{
                tk = jj_consume_token(K_UPDATE);
                break;
                }
              default:
                jj_la1[462] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
              action = Action();
fkIndex.setReferentialAction(ReferentialAction.Type.valueOf(tk.image), action);
            } else {
              ;
            }
            if (jj_2_198(2)) {
              jj_consume_token(K_ON);
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_DELETE:{
                tk = jj_consume_token(K_DELETE);
                break;
                }
              case K_UPDATE:{
                tk = jj_consume_token(K_UPDATE);
                break;
                }
              default:
                jj_la1[463] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
              action = Action();
fkIndex.setReferentialAction(ReferentialAction.Type.valueOf(tk.image), action);
            } else {
              ;
            }
            constraints = AlterExpressionConstraintState();
alterExp.setConstraints(constraints);
            break;
            }
          case K_PRIMARY:{
            tk = jj_consume_token(K_PRIMARY);
            tk2 = jj_consume_token(K_KEY);
            columnNames = ColumnsNamesList();
index = new NamedConstraint()
                        .withName(sk3)
                        .withType(tk.image + " " + tk2.image)
                        .withColumnsNames(columnNames);
                        alterExp.setIndex(index);
            constraints = AlterExpressionConstraintState();
alterExp.setConstraints(constraints);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_USING:{
              jj_consume_token(K_USING);
              sk4 = RelObjectName();
alterExp.addParameters("USING", sk4);
              break;
              }
            default:
              jj_la1[464] = jj_gen;
              ;
            }
            break;
            }
          case K_CHECK:{
            jj_consume_token(K_CHECK);
Expression exp = null;
            label_101:
            while (true) {
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case 287:{
                ;
                break;
                }
              default:
                jj_la1[465] = jj_gen;
                break label_101;
              }
              jj_consume_token(287);
              exp = Expression();
              jj_consume_token(288);
            }
CheckConstraint checkCs = new CheckConstraint().withName(sk3).withExpression(exp);
                    alterExp.setIndex(checkCs);
            break;
            }
          case K_UNIQUE:{
            tk = jj_consume_token(K_UNIQUE);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_INDEX:
            case K_KEY:{
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_KEY:{
                tk2 = jj_consume_token(K_KEY);
alterExp.setUk(true);
                break;
                }
              case K_INDEX:{
                tk2 = jj_consume_token(K_INDEX);
                break;
                }
              default:
                jj_la1[466] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
              break;
              }
            default:
              jj_la1[467] = jj_gen;
              ;
            }
            columnNames = ColumnsNamesList();
index = new NamedConstraint()
                            .withName(sk3)
                                .withType(tk.image + (tk2!=null?" " + tk2.image:""))
                                .withColumnsNames(columnNames);
                          alterExp.setIndex(index);
            constraints = AlterExpressionConstraintState();
alterExp.setConstraints(constraints);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_USING:{
              jj_consume_token(K_USING);
              sk4 = RelObjectName();
alterExp.addParameters("USING", sk4);
              break;
              }
            default:
              jj_la1[468] = jj_gen;
              ;
            }
            break;
            }
          case K_KEY:{
            tk = jj_consume_token(K_KEY);
            columnNames = ColumnsNamesList();
index = new NamedConstraint()
                                .withName(sk3)
                                .withType(tk.image)
                                                        .withColumnsNames(columnNames);
                          alterExp.setIndex(index);
            constraints = AlterExpressionConstraintState();
alterExp.setConstraints(constraints);
            break;
            }
          default:
            jj_la1[469] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        case K_ACTION:
        case K_ALGORITHM:
        case K_ANY:
        case K_ARRAY_LITERAL:
        case K_BYTE:
        case K_CASCADE:
        case K_CASE:
        case K_CAST:
        case K_CHARACTER:
        case K_CHANGE:
        case K_CHAR:
        case K_COLUMN:
        case K_COLUMNS:
        case K_COMMIT:
        case K_COMMENT:
        case K_COSTS:
        case K_CREATE:
        case K_CYCLE:
        case K_DATETIMELITERAL:
        case K_DATE_LITERAL:
        case K_DESC:
        case K_DESCRIBE:
        case K_DISABLE:
        case K_DIV:
        case K_DO:
        case K_DUPLICATE:
        case K_ENABLE:
        case K_END:
        case K_EXCLUDE:
        case K_EXTRACT:
        case K_FIRST:
        case K_FALSE:
        case K_FOLLOWING:
        case K_FORMAT:
        case K_GROUP:
        case K_INDEX:
        case K_INSERT:
        case K_INTERVAL:
        case K_ISNULL:
        case K_JSON:
        case K_KEY:
        case K_FN:
        case K_LAST:
        case K_LEADING:
        case K_LOCAL:
        case K_MATERIALIZED:
        case K_NEXTVAL:
        case K_NO:
        case K_NOLOCK:
        case K_NULLS:
        case K_OF:
        case K_ON:
        case K_OPEN:
        case K_ORDER:
        case K_OVER:
        case K_PARALLEL:
        case K_PARTITION:
        case K_PATH:
        case K_PERCENT:
        case K_PRECISION:
        case K_PRIMARY:
        case K_PRIOR:
        case K_RANGE:
        case K_READ:
        case K_REPLACE:
        case K_ROW:
        case K_ROWS:
        case K_SCHEMA:
        case K_SEQUENCE:
        case K_SEPARATOR:
        case K_SESSION:
        case K_SIBLINGS:
        case K_SIZE:
        case K_SKIP:
        case K_START:
        case K_SYNONYM:
        case K_TABLE:
        case K_TABLES:
        case K_TEMP:
        case K_TEMPORARY:
        case K_TIMEOUT:
        case K_TO:
        case K_TOP:
        case K_TRUNCATE:
        case K_TRUE:
        case K_TYPE:
        case K_SIGNED:
        case K_UNSIGNED:
        case K_VALIDATE:
        case K_VALUE:
        case K_VALUES:
        case K_VIEW:
        case K_XML:
        case K_ZONE:
        case S_IDENTIFIER:
        case S_QUOTED_IDENTIFIER:{
          sk3 = RelObjectName();
          jj_consume_token(K_COMMENT);
          tk = jj_consume_token(S_CHAR_LITERAL);
alterExp.withColumnName(sk3).withCommentText(tk.image);
          break;
          }
        default:
          jj_la1[470] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    case K_CHANGE:{
      jj_consume_token(K_CHANGE);
alterExp.setOperation(AlterOperation.CHANGE);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COLUMN:{
        jj_consume_token(K_COLUMN);
alterExp.hasColumn(true); alterExp.setOptionalSpecifier("COLUMN");
        break;
        }
      default:
        jj_la1[471] = jj_gen;

      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        tk = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case S_QUOTED_IDENTIFIER:{
        tk = jj_consume_token(S_QUOTED_IDENTIFIER);
        break;
        }
      default:
        jj_la1[472] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      alterExpressionColumnDataType = AlterExpressionColumnDataType();
alterExp.withColumnOldName(tk.image).addColDataType(alterExpressionColumnDataType);
      break;
      }
    case K_DROP:{
      jj_consume_token(K_DROP);
alterExp.setOperation(AlterOperation.DROP);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COLUMN:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:{
        if (jj_2_202(2)) {
          jj_consume_token(K_COLUMN);
alterExp.hasColumn(true);
        } else {
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_IDENTIFIER:{
          tk = jj_consume_token(S_IDENTIFIER);
          break;
          }
        case S_QUOTED_IDENTIFIER:{
          tk = jj_consume_token(S_QUOTED_IDENTIFIER);
          break;
          }
        default:
          jj_la1[473] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
alterExp.setColumnName(tk.image);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_CASCADE:{
          tk = jj_consume_token(K_CASCADE);
alterExp.addParameters(tk.image);
          break;
          }
        default:
          jj_la1[474] = jj_gen;
          ;
        }
        break;
        }
      case K_INDEX:{
        tk = jj_consume_token(K_INDEX);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_IDENTIFIER:{
          tk2 = jj_consume_token(S_IDENTIFIER);
          break;
          }
        case S_QUOTED_IDENTIFIER:{
          tk2 = jj_consume_token(S_QUOTED_IDENTIFIER);
          break;
          }
        default:
          jj_la1[475] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
index = new Index().withType(tk.image).withName(tk2.image);
                           alterExp.setIndex(index);
        break;
        }
      case K_CONSTRAINT:{
        jj_consume_token(K_CONSTRAINT);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_IF:{
          jj_consume_token(K_IF);
          jj_consume_token(K_EXISTS);
alterExp.setConstraintIfExists(true);
          break;
          }
        default:
          jj_la1[476] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_IDENTIFIER:{
          tk = jj_consume_token(S_IDENTIFIER);
          break;
          }
        case S_QUOTED_IDENTIFIER:{
          tk = jj_consume_token(S_QUOTED_IDENTIFIER);
          break;
          }
        default:
          jj_la1[477] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
alterExp.setConstraintName(tk.image);
        break;
        }
      default:
        jj_la1[478] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case K_ALGORITHM:{
      jj_consume_token(K_ALGORITHM);
alterExp.setOperation(AlterOperation.ALGORITHM);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 289:{
        jj_consume_token(289);
alterExp.setUseEqual(true);
        break;
        }
      default:
        jj_la1[479] = jj_gen;
        ;
      }
      sk3 = RelObjectName();
alterExp.addParameters(sk3);
      break;
      }
    case K_RENAME:{
      jj_consume_token(K_RENAME);
alterExp.setOperation(AlterOperation.RENAME);
      jj_consume_token(K_COLUMN);
alterExp.hasColumn(true);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        tk = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case S_QUOTED_IDENTIFIER:{
        tk = jj_consume_token(S_QUOTED_IDENTIFIER);
        break;
        }
      default:
        jj_la1[480] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
alterExp.setColOldName(tk.image);
      jj_consume_token(K_TO);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        tk2 = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case S_QUOTED_IDENTIFIER:{
        tk2 = jj_consume_token(S_QUOTED_IDENTIFIER);
        break;
        }
      default:
        jj_la1[481] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
alterExp.setColumnName(tk2.image);
      break;
      }
    case K_COMMENT:{
      jj_consume_token(K_COMMENT);
alterExp.setOperation(AlterOperation.COMMENT);
      tk = jj_consume_token(S_CHAR_LITERAL);
alterExp.setCommentText(tk.image);
      break;
      }
    default:
      jj_la1[482] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return alterExp;
}

  final public Alter AlterTable() throws ParseException {Alter alter = new Alter();
    Table table;
    AlterExpression alterExp;
    jj_consume_token(K_ALTER);
    jj_consume_token(K_TABLE);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ONLY:{
      jj_consume_token(K_ONLY);
alter.setUseOnly(true);
      break;
      }
    default:
      jj_la1[483] = jj_gen;
      ;
    }
    table = Table();
alter.setTable(table);
    alterExp = AlterExpression();
alter.addAlterExpression(alterExp);
    label_102:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[484] = jj_gen;
        break label_102;
      }
      jj_consume_token(K_COMMA);
      alterExp = AlterExpression();
alter.addAlterExpression(alterExp);
    }
return alter;
}

  final public AlterSession AlterSession() throws ParseException {AlterSessionOperation operation = null;
    List<String> parameters = new ArrayList<String>();
    Token token;
    jj_consume_token(K_ALTER);
    jj_consume_token(K_SESSION);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ADVISE:{
      jj_consume_token(K_ADVISE);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMIT:{
        jj_consume_token(K_COMMIT);
operation = AlterSessionOperation.ADVISE_COMMIT;
        break;
        }
      case K_ROLLBACK:{
        jj_consume_token(K_ROLLBACK);
operation = AlterSessionOperation.ADVISE_ROLLBACK;
        break;
        }
      case K_NOTHING:{
        jj_consume_token(K_NOTHING);
operation = AlterSessionOperation.ADVISE_NOTHING;
        break;
        }
      default:
        jj_la1[485] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case K_CLOSE:{
      jj_consume_token(K_CLOSE);
      jj_consume_token(K_DATABASE);
      jj_consume_token(K_LINK);
operation = AlterSessionOperation.CLOSE_DATABASE_LINK;
      break;
      }
    case K_ENABLE:{
      jj_consume_token(K_ENABLE);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMIT:{
        jj_consume_token(K_COMMIT);
        jj_consume_token(K_IN);
        jj_consume_token(K_PROCEDURE);
operation = AlterSessionOperation.ENABLE_COMMIT_IN_PROCEDURE;
        break;
        }
      case K_GUARD:{
        jj_consume_token(K_GUARD);
operation = AlterSessionOperation.ENABLE_GUARD;
        break;
        }
      case K_PARALLEL:{
        jj_consume_token(K_PARALLEL);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_DML:{
          jj_consume_token(K_DML);
operation = AlterSessionOperation.ENABLE_PARALLEL_DML;
          break;
          }
        case K_DDL:{
          jj_consume_token(K_DDL);
operation = AlterSessionOperation.ENABLE_PARALLEL_DDL;
          break;
          }
        case K_QUERY:{
          jj_consume_token(K_QUERY);
operation = AlterSessionOperation.ENABLE_PARALLEL_QUERY;
          break;
          }
        default:
          jj_la1[486] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case K_RESUMABLE:{
        jj_consume_token(K_RESUMABLE);
operation = AlterSessionOperation.ENABLE_RESUMABLE;
        break;
        }
      default:
        jj_la1[487] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case K_DISABLE:{
      jj_consume_token(K_DISABLE);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMIT:{
        jj_consume_token(K_COMMIT);
        jj_consume_token(K_IN);
        jj_consume_token(K_PROCEDURE);
operation = AlterSessionOperation.DISABLE_COMMIT_IN_PROCEDURE;
        break;
        }
      case K_GUARD:{
        jj_consume_token(K_GUARD);
operation = AlterSessionOperation.DISABLE_GUARD;
        break;
        }
      case K_PARALLEL:{
        jj_consume_token(K_PARALLEL);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_DML:{
          jj_consume_token(K_DML);
operation = AlterSessionOperation.DISABLE_PARALLEL_DML;
          break;
          }
        case K_DDL:{
          jj_consume_token(K_DDL);
operation = AlterSessionOperation.DISABLE_PARALLEL_DDL;
          break;
          }
        case K_QUERY:{
          jj_consume_token(K_QUERY);
operation = AlterSessionOperation.DISABLE_PARALLEL_QUERY;
          break;
          }
        default:
          jj_la1[488] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case K_RESUMABLE:{
        jj_consume_token(K_RESUMABLE);
operation = AlterSessionOperation.DISABLE_RESUMABLE;
        break;
        }
      default:
        jj_la1[489] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case K_FORCE:{
      jj_consume_token(K_FORCE);
      jj_consume_token(K_PARALLEL);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_DML:{
        jj_consume_token(K_DML);
operation = AlterSessionOperation.FORCE_PARALLEL_DML;
        break;
        }
      case K_DDL:{
        jj_consume_token(K_DDL);
operation = AlterSessionOperation.FORCE_PARALLEL_DDL;
        break;
        }
      case K_QUERY:{
        jj_consume_token(K_QUERY);
operation = AlterSessionOperation.FORCE_PARALLEL_QUERY;
        break;
        }
      default:
        jj_la1[490] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case K_SET:{
      jj_consume_token(K_SET);
operation = AlterSessionOperation.SET;
      break;
      }
    default:
      jj_la1[491] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_103:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_PARALLEL:
      case S_LONG:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case 289:{
        ;
        break;
        }
      default:
        jj_la1[492] = jj_gen;
        break label_103;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_CHAR_LITERAL:{
        token = jj_consume_token(S_CHAR_LITERAL);
        break;
        }
      case S_IDENTIFIER:{
        token = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case 289:{
        token = jj_consume_token(289);
        break;
        }
      case S_LONG:{
        token = jj_consume_token(S_LONG);
        break;
        }
      case K_PARALLEL:{
        token = jj_consume_token(K_PARALLEL);
        break;
        }
      default:
        jj_la1[493] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
parameters.add( token.image );
    }
return new AlterSession(operation, parameters);
}

  final public Wait Wait() throws ParseException {Wait wait = new Wait();
    Token token = null;
    jj_consume_token(K_WAIT);
    token = jj_consume_token(S_LONG);
wait.setTimeout(Long.parseLong(token.image));
return wait;
}

  final public SavepointStatement SavepointStatement() throws ParseException {SavepointStatement savepointStatement;
    jj_consume_token(K_SAVEPOINT);
    token = jj_consume_token(S_IDENTIFIER);
savepointStatement = new SavepointStatement(token.image);
return savepointStatement;
}

  final public RollbackStatement RollbackStatement() throws ParseException {RollbackStatement rollbackStatement;
    boolean usingWorkKeyword=false;
    boolean usingSavepointKeyword=false;
    String savepointName=null;
    String forceDistributedTransactionIdentifier=null;
    jj_consume_token(K_ROLLBACK);
rollbackStatement = new RollbackStatement();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_WORK:{
      jj_consume_token(K_WORK);
rollbackStatement.setUsingWorkKeyword(true);
      break;
      }
    default:
      jj_la1[494] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FORCE:
    case K_TO:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_TO:{
        jj_consume_token(K_TO);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_SAVEPOINT:{
          jj_consume_token(K_SAVEPOINT);
rollbackStatement.setUsingSavepointKeyword(true);
          break;
          }
        default:
          jj_la1[495] = jj_gen;
          ;
        }
        token = jj_consume_token(S_IDENTIFIER);
rollbackStatement.setSavepointName(token.image);
        break;
        }
      case K_FORCE:{
        jj_consume_token(K_FORCE);
        token = jj_consume_token(S_CHAR_LITERAL);
rollbackStatement.setForceDistributedTransactionIdentifier(token.image);
        break;
        }
      default:
        jj_la1[496] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[497] = jj_gen;
      ;
    }
return rollbackStatement;
}

  final public Commit Commit() throws ParseException {Commit commit=new Commit();
    jj_consume_token(K_COMMIT);
return commit;
}

  final public Comment Comment() throws ParseException {Comment result = new Comment();
    Table table;
    Table view;
    Column column;
    Token comment;
    jj_consume_token(K_COMMENT);
    jj_consume_token(K_ON);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_TABLE:{
      jj_consume_token(K_TABLE);
      table = Table();
result.setTable(table);
      break;
      }
    case K_COLUMN:{
      jj_consume_token(K_COLUMN);
      column = Column();
result.setColumn(column);
      break;
      }
    case K_VIEW:{
      jj_consume_token(K_VIEW);
      view = Table();
result.setView(view);
      break;
      }
    default:
      jj_la1[498] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(K_IS);
    comment = jj_consume_token(S_CHAR_LITERAL);
result.setComment(new StringValue(comment.image));
return result;
}

  final public Grant Grant() throws ParseException {Grant grant = new Grant();
        ArrayList<String> privileges = new ArrayList<String>();
        List<String> users;
        Token tk = null;
        List<String> objName;
    jj_consume_token(K_GRANT);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ALTER:
    case K_DELETE:
    case K_DROP:
    case K_EXECUTE:
    case K_INSERT:
    case K_ON:
    case K_SELECT:
    case K_UPDATE:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ALTER:
      case K_DELETE:
      case K_DROP:
      case K_EXECUTE:
      case K_INSERT:
      case K_SELECT:
      case K_UPDATE:{
        readGrantTypes(privileges);
        label_104:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_COMMA:{
            ;
            break;
            }
          default:
            jj_la1[499] = jj_gen;
            break label_104;
          }
          jj_consume_token(K_COMMA);
          readGrantTypes(privileges);
        }
        break;
        }
      default:
        jj_la1[500] = jj_gen;
        ;
      }
      jj_consume_token(K_ON);
      objName = RelObjectNameList();
grant.setObjectName(objName);
      break;
      }
    case S_IDENTIFIER:{
      tk = jj_consume_token(S_IDENTIFIER);
grant.setRole(tk.image);
      break;
      }
    default:
      jj_la1[501] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(K_TO);
    users = UsersList();
grant.setUsers(users);
if(privileges.size() > 0) {
                grant.setPrivileges(privileges);
            }
                return grant;
}

  final public List<String> UsersList() throws ParseException {List<String> users = new ArrayList<String>();
    String user = null;
    user = RelObjectName();
users.add(user);
    label_105:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[502] = jj_gen;
        break label_105;
      }
      jj_consume_token(K_COMMA);
      user = ColumnsNamesListItem();
users.add(user);
    }
return users;
}

  final public void readGrantTypes(ArrayList<String> privileges) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_SELECT:{
      jj_consume_token(K_SELECT);
privileges.add("SELECT");
      break;
      }
    case K_INSERT:{
      jj_consume_token(K_INSERT);
privileges.add("INSERT");
      break;
      }
    case K_UPDATE:{
      jj_consume_token(K_UPDATE);
privileges.add("UPDATE");
      break;
      }
    case K_DELETE:{
      jj_consume_token(K_DELETE);
privileges.add("DELETE");
      break;
      }
    case K_EXECUTE:{
      jj_consume_token(K_EXECUTE);
privileges.add("EXECUTE");
      break;
      }
    case K_ALTER:{
      jj_consume_token(K_ALTER);
privileges.add("ALTER");
      break;
      }
    case K_DROP:{
      jj_consume_token(K_DROP);
privileges.add("DROP");
      break;
      }
    default:
      jj_la1[503] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public Sequence Sequence() throws ParseException {/*@bgen(jjtree) Sequence */
    SimpleNode jjtn000 = new SimpleNode(JJTSEQUENCE);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));List<String> data = new ArrayList<String>();
    String serverName = null, databaseName = null, schemaName = null, sequenceName = null;
    try {
      data = RelObjectNameList();
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
Sequence sequence = new Sequence(data);
                linkAST(sequence,jjtn000);
        return sequence;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public List<Sequence.Parameter> SequenceParameters() throws ParseException {List<Sequence.Parameter> sequenceParameters = new ArrayList<Sequence.Parameter>();
  Sequence.Parameter parameter = null;
  Token token = null;
    label_106:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_CACHE:
      case K_CYCLE:
      case K_GLOBAL:
      case K_INCREMENT:
      case K_KEEP:
      case K_MAXVALUE:
      case K_MINVALUE:
      case K_NOCACHE:
      case K_NOCYCLE:
      case K_NOKEEP:
      case K_NOMAXVALUE:
      case K_NOMINVALUE:
      case K_NOORDER:
      case K_ORDER:
      case K_SESSION:
      case K_START:{
        ;
        break;
        }
      default:
        jj_la1[504] = jj_gen;
        break label_106;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_INCREMENT:{
        jj_consume_token(K_INCREMENT);
        jj_consume_token(K_BY);
        token = jj_consume_token(S_LONG);
parameter = new Sequence.Parameter(Sequence.ParameterType.INCREMENT_BY);
        parameter.setValue(Long.parseLong(token.image));
        sequenceParameters.add(parameter);
        break;
        }
      case K_START:{
        jj_consume_token(K_START);
        jj_consume_token(K_WITH);
        token = jj_consume_token(S_LONG);
parameter = new Sequence.Parameter(Sequence.ParameterType.START_WITH);
      parameter.setValue(Long.parseLong(token.image));
      sequenceParameters.add(parameter);
        break;
        }
      case K_MAXVALUE:
      case K_NOMAXVALUE:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_NOMAXVALUE:{
          jj_consume_token(K_NOMAXVALUE);
parameter = new Sequence.Parameter(Sequence.ParameterType.NOMAXVALUE);
      sequenceParameters.add(parameter);
          break;
          }
        case K_MAXVALUE:{
          jj_consume_token(K_MAXVALUE);
          token = jj_consume_token(S_LONG);
parameter = new Sequence.Parameter(Sequence.ParameterType.MAXVALUE);
      parameter.setValue(Long.parseLong(token.image));
      sequenceParameters.add(parameter);
          break;
          }
        default:
          jj_la1[505] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case K_MINVALUE:
      case K_NOMINVALUE:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_NOMINVALUE:{
          jj_consume_token(K_NOMINVALUE);
parameter = new Sequence.Parameter(Sequence.ParameterType.NOMINVALUE);
      sequenceParameters.add(parameter);
          break;
          }
        case K_MINVALUE:{
          jj_consume_token(K_MINVALUE);
          token = jj_consume_token(S_LONG);
parameter = new Sequence.Parameter(Sequence.ParameterType.MINVALUE);
      parameter.setValue(Long.parseLong(token.image));
      sequenceParameters.add(parameter);
          break;
          }
        default:
          jj_la1[506] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case K_CYCLE:
      case K_NOCYCLE:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_NOCYCLE:{
          jj_consume_token(K_NOCYCLE);
sequenceParameters.add(new Sequence.Parameter(Sequence.ParameterType.NOCYCLE));
          break;
          }
        case K_CYCLE:{
          jj_consume_token(K_CYCLE);
sequenceParameters.add(new Sequence.Parameter(Sequence.ParameterType.CYCLE));
          break;
          }
        default:
          jj_la1[507] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case K_CACHE:
      case K_NOCACHE:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_NOCACHE:{
          jj_consume_token(K_NOCACHE);
parameter = new Sequence.Parameter(Sequence.ParameterType.NOCACHE);
      sequenceParameters.add(parameter);
          break;
          }
        case K_CACHE:{
          jj_consume_token(K_CACHE);
          token = jj_consume_token(S_LONG);
parameter = new Sequence.Parameter(Sequence.ParameterType.CACHE);
      parameter.setValue(Long.parseLong(token.image));
      sequenceParameters.add(parameter);
          break;
          }
        default:
          jj_la1[508] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case K_NOORDER:
      case K_ORDER:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ORDER:{
          jj_consume_token(K_ORDER);
sequenceParameters.add(new Sequence.Parameter(Sequence.ParameterType.ORDER));
          break;
          }
        case K_NOORDER:{
          jj_consume_token(K_NOORDER);
sequenceParameters.add(new Sequence.Parameter(Sequence.ParameterType.NOORDER));
          break;
          }
        default:
          jj_la1[509] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case K_KEEP:
      case K_NOKEEP:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_KEEP:{
          jj_consume_token(K_KEEP);
sequenceParameters.add(new Sequence.Parameter(Sequence.ParameterType.KEEP));
          break;
          }
        case K_NOKEEP:{
          jj_consume_token(K_NOKEEP);
sequenceParameters.add(new Sequence.Parameter(Sequence.ParameterType.NOKEEP));
          break;
          }
        default:
          jj_la1[510] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case K_GLOBAL:
      case K_SESSION:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_SESSION:{
          jj_consume_token(K_SESSION);
sequenceParameters.add(new Sequence.Parameter(Sequence.ParameterType.SESSION));
          break;
          }
        case K_GLOBAL:{
          jj_consume_token(K_GLOBAL);
sequenceParameters.add(new Sequence.Parameter(Sequence.ParameterType.GLOBAL));
          break;
          }
        default:
          jj_la1[511] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[512] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return sequenceParameters;
}

  final public CreateSequence CreateSequence() throws ParseException {CreateSequence createSequence = new CreateSequence();
  Sequence sequence;
  List<Sequence.Parameter> sequenceParameters;
    jj_consume_token(K_CREATE);
    jj_consume_token(K_SEQUENCE);
    sequence = Sequence();
createSequence.setSequence(sequence);
    sequenceParameters = SequenceParameters();
sequence.setParameters(sequenceParameters);
return createSequence;
}

  final public AlterSequence AlterSequence() throws ParseException {AlterSequence alterSequence = new AlterSequence();
  Sequence sequence;
  List<Sequence.Parameter> sequenceParameters;
    jj_consume_token(K_ALTER);
    jj_consume_token(K_SEQUENCE);
    sequence = Sequence();
alterSequence.setSequence(sequence);
    sequenceParameters = SequenceParameters();
sequence.setParameters(sequenceParameters);
return alterSequence;
}

  final public CreateFunctionalStatement CreateFunctionStatement() throws ParseException {CreateFunctionalStatement type = null;
  List<String> tokens = new LinkedList<String>();
  String statementType = null;
  boolean orReplace = false;
    jj_consume_token(K_CREATE);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_OR:{
      jj_consume_token(K_OR);
      jj_consume_token(K_REPLACE);
orReplace = true;
      break;
      }
    default:
      jj_la1[513] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FUNCTION:{
      jj_consume_token(K_FUNCTION);
statementType = "FUNCTION";
      break;
      }
    case K_PROCEDURE:{
      jj_consume_token(K_PROCEDURE);
statementType = "PROCEDURE";
      break;
      }
    default:
      jj_la1[514] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    tokens = captureRest();
if(statementType.equals("FUNCTION")) {
      type = new CreateFunction(orReplace, tokens);
    }
    if(statementType.equals("PROCEDURE")) {
      type = new CreateProcedure(orReplace, tokens);
    }

    return type;
}

  final public CreateSynonym CreateSynonym() throws ParseException {CreateSynonym createSynonym = new CreateSynonym();
  Synonym synonym;
  boolean orReplace = false;
  boolean publicSynonym = false;
  List<String> data = new ArrayList<String>();
    jj_consume_token(K_CREATE);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_OR:{
      jj_consume_token(K_OR);
      jj_consume_token(K_REPLACE);
orReplace = true;
      break;
      }
    default:
      jj_la1[515] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_PUBLIC:{
      jj_consume_token(K_PUBLIC);
publicSynonym = true;
      break;
      }
    default:
      jj_la1[516] = jj_gen;
      ;
    }
    jj_consume_token(K_SYNONYM);
    synonym = Synonym();
createSynonym.setSynonym(synonym);
    jj_consume_token(K_FOR);
    data = RelObjectNameList();
createSynonym.setOrReplace(orReplace);
    createSynonym.setPublicSynonym(publicSynonym);
    createSynonym.setForList(data);
    return createSynonym;
}

  final public Synonym Synonym() throws ParseException {/*@bgen(jjtree) Synonym */
    SimpleNode jjtn000 = new SimpleNode(JJTSYNONYM);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));List<String> data = new ArrayList<String>();
    String serverName = null, databaseName = null, schemaName = null, sequenceName = null;
    try {
      data = RelObjectNameList();
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
Synonym synonym = new Synonym(data);
                linkAST(synonym,jjtn000);
        return synonym;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  List<String> captureRest() throws ParseException {List<String> tokens = new LinkedList<String>();
  Token tok;
  while(true) {
    tok = getToken(1);
    if(tok.kind == EOF) {
      break;
    }
    tokens.add(tok.image);
    tok = getNextToken();
  }
  return tokens;
  }

  private boolean jj_2_1(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_1()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_2()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_3()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_4()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_5()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_6()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_7()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_8()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_9()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_2_10(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_10()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  private boolean jj_2_11(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_11()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  private boolean jj_2_12(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_12()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  private boolean jj_2_13(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_13()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  private boolean jj_2_14(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_14()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  private boolean jj_2_15(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_15()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  private boolean jj_2_16(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_16()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  private boolean jj_2_17(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_17()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  private boolean jj_2_18(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_18()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  private boolean jj_2_19(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_19()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  private boolean jj_2_20(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_20()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(19, xla); }
  }

  private boolean jj_2_21(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_21()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(20, xla); }
  }

  private boolean jj_2_22(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_22()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(21, xla); }
  }

  private boolean jj_2_23(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_23()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(22, xla); }
  }

  private boolean jj_2_24(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_24()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(23, xla); }
  }

  private boolean jj_2_25(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_25()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(24, xla); }
  }

  private boolean jj_2_26(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_26()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(25, xla); }
  }

  private boolean jj_2_27(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_27()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(26, xla); }
  }

  private boolean jj_2_28(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_28()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(27, xla); }
  }

  private boolean jj_2_29(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_29()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(28, xla); }
  }

  private boolean jj_2_30(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_30()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(29, xla); }
  }

  private boolean jj_2_31(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_31()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(30, xla); }
  }

  private boolean jj_2_32(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_32()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(31, xla); }
  }

  private boolean jj_2_33(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_33()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(32, xla); }
  }

  private boolean jj_2_34(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_34()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(33, xla); }
  }

  private boolean jj_2_35(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_35()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(34, xla); }
  }

  private boolean jj_2_36(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_36()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(35, xla); }
  }

  private boolean jj_2_37(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_37()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(36, xla); }
  }

  private boolean jj_2_38(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_38()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(37, xla); }
  }

  private boolean jj_2_39(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_39()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(38, xla); }
  }

  private boolean jj_2_40(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_40()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(39, xla); }
  }

  private boolean jj_2_41(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_41()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(40, xla); }
  }

  private boolean jj_2_42(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_42()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(41, xla); }
  }

  private boolean jj_2_43(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_43()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(42, xla); }
  }

  private boolean jj_2_44(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_44()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(43, xla); }
  }

  private boolean jj_2_45(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_45()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(44, xla); }
  }

  private boolean jj_2_46(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_46()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(45, xla); }
  }

  private boolean jj_2_47(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_47()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(46, xla); }
  }

  private boolean jj_2_48(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_48()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(47, xla); }
  }

  private boolean jj_2_49(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_49()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(48, xla); }
  }

  private boolean jj_2_50(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_50()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(49, xla); }
  }

  private boolean jj_2_51(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_51()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(50, xla); }
  }

  private boolean jj_2_52(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_52()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(51, xla); }
  }

  private boolean jj_2_53(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_53()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(52, xla); }
  }

  private boolean jj_2_54(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_54()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(53, xla); }
  }

  private boolean jj_2_55(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_55()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(54, xla); }
  }

  private boolean jj_2_56(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_56()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(55, xla); }
  }

  private boolean jj_2_57(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_57()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(56, xla); }
  }

  private boolean jj_2_58(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_58()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(57, xla); }
  }

  private boolean jj_2_59(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_59()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(58, xla); }
  }

  private boolean jj_2_60(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_60()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(59, xla); }
  }

  private boolean jj_2_61(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_61()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(60, xla); }
  }

  private boolean jj_2_62(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_62()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(61, xla); }
  }

  private boolean jj_2_63(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_63()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(62, xla); }
  }

  private boolean jj_2_64(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_64()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(63, xla); }
  }

  private boolean jj_2_65(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_65()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(64, xla); }
  }

  private boolean jj_2_66(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_66()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(65, xla); }
  }

  private boolean jj_2_67(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_67()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(66, xla); }
  }

  private boolean jj_2_68(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_68()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(67, xla); }
  }

  private boolean jj_2_69(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_69()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(68, xla); }
  }

  private boolean jj_2_70(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_70()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(69, xla); }
  }

  private boolean jj_2_71(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_71()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(70, xla); }
  }

  private boolean jj_2_72(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_72()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(71, xla); }
  }

  private boolean jj_2_73(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_73()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(72, xla); }
  }

  private boolean jj_2_74(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_74()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(73, xla); }
  }

  private boolean jj_2_75(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_75()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(74, xla); }
  }

  private boolean jj_2_76(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_76()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(75, xla); }
  }

  private boolean jj_2_77(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_77()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(76, xla); }
  }

  private boolean jj_2_78(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_78()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(77, xla); }
  }

  private boolean jj_2_79(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_79()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(78, xla); }
  }

  private boolean jj_2_80(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_80()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(79, xla); }
  }

  private boolean jj_2_81(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_81()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(80, xla); }
  }

  private boolean jj_2_82(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_82()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(81, xla); }
  }

  private boolean jj_2_83(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_83()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(82, xla); }
  }

  private boolean jj_2_84(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_84()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(83, xla); }
  }

  private boolean jj_2_85(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_85()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(84, xla); }
  }

  private boolean jj_2_86(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_86()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(85, xla); }
  }

  private boolean jj_2_87(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_87()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(86, xla); }
  }

  private boolean jj_2_88(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_88()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(87, xla); }
  }

  private boolean jj_2_89(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_89()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(88, xla); }
  }

  private boolean jj_2_90(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_90()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(89, xla); }
  }

  private boolean jj_2_91(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_91()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(90, xla); }
  }

  private boolean jj_2_92(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_92()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(91, xla); }
  }

  private boolean jj_2_93(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_93()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(92, xla); }
  }

  private boolean jj_2_94(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_94()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(93, xla); }
  }

  private boolean jj_2_95(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_95()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(94, xla); }
  }

  private boolean jj_2_96(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_96()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(95, xla); }
  }

  private boolean jj_2_97(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_97()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(96, xla); }
  }

  private boolean jj_2_98(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_98()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(97, xla); }
  }

  private boolean jj_2_99(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_99()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(98, xla); }
  }

  private boolean jj_2_100(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_100()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(99, xla); }
  }

  private boolean jj_2_101(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_101()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(100, xla); }
  }

  private boolean jj_2_102(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_102()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(101, xla); }
  }

  private boolean jj_2_103(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_103()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(102, xla); }
  }

  private boolean jj_2_104(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_104()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(103, xla); }
  }

  private boolean jj_2_105(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_105()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(104, xla); }
  }

  private boolean jj_2_106(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_106()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(105, xla); }
  }

  private boolean jj_2_107(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_107()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(106, xla); }
  }

  private boolean jj_2_108(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_108()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(107, xla); }
  }

  private boolean jj_2_109(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_109()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(108, xla); }
  }

  private boolean jj_2_110(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_110()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(109, xla); }
  }

  private boolean jj_2_111(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_111()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(110, xla); }
  }

  private boolean jj_2_112(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_112()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(111, xla); }
  }

  private boolean jj_2_113(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_113()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(112, xla); }
  }

  private boolean jj_2_114(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_114()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(113, xla); }
  }

  private boolean jj_2_115(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_115()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(114, xla); }
  }

  private boolean jj_2_116(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_116()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(115, xla); }
  }

  private boolean jj_2_117(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_117()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(116, xla); }
  }

  private boolean jj_2_118(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_118()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(117, xla); }
  }

  private boolean jj_2_119(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_119()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(118, xla); }
  }

  private boolean jj_2_120(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_120()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(119, xla); }
  }

  private boolean jj_2_121(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_121()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(120, xla); }
  }

  private boolean jj_2_122(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_122()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(121, xla); }
  }

  private boolean jj_2_123(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_123()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(122, xla); }
  }

  private boolean jj_2_124(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_124()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(123, xla); }
  }

  private boolean jj_2_125(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_125()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(124, xla); }
  }

  private boolean jj_2_126(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_126()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(125, xla); }
  }

  private boolean jj_2_127(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_127()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(126, xla); }
  }

  private boolean jj_2_128(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_128()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(127, xla); }
  }

  private boolean jj_2_129(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_129()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(128, xla); }
  }

  private boolean jj_2_130(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_130()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(129, xla); }
  }

  private boolean jj_2_131(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_131()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(130, xla); }
  }

  private boolean jj_2_132(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_132()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(131, xla); }
  }

  private boolean jj_2_133(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_133()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(132, xla); }
  }

  private boolean jj_2_134(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_134()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(133, xla); }
  }

  private boolean jj_2_135(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_135()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(134, xla); }
  }

  private boolean jj_2_136(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_136()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(135, xla); }
  }

  private boolean jj_2_137(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_137()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(136, xla); }
  }

  private boolean jj_2_138(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_138()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(137, xla); }
  }

  private boolean jj_2_139(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_139()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(138, xla); }
  }

  private boolean jj_2_140(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_140()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(139, xla); }
  }

  private boolean jj_2_141(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_141()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(140, xla); }
  }

  private boolean jj_2_142(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_142()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(141, xla); }
  }

  private boolean jj_2_143(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_143()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(142, xla); }
  }

  private boolean jj_2_144(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_144()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(143, xla); }
  }

  private boolean jj_2_145(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_145()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(144, xla); }
  }

  private boolean jj_2_146(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_146()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(145, xla); }
  }

  private boolean jj_2_147(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_147()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(146, xla); }
  }

  private boolean jj_2_148(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_148()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(147, xla); }
  }

  private boolean jj_2_149(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_149()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(148, xla); }
  }

  private boolean jj_2_150(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_150()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(149, xla); }
  }

  private boolean jj_2_151(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_151()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(150, xla); }
  }

  private boolean jj_2_152(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_152()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(151, xla); }
  }

  private boolean jj_2_153(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_153()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(152, xla); }
  }

  private boolean jj_2_154(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_154()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(153, xla); }
  }

  private boolean jj_2_155(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_155()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(154, xla); }
  }

  private boolean jj_2_156(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_156()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(155, xla); }
  }

  private boolean jj_2_157(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_157()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(156, xla); }
  }

  private boolean jj_2_158(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_158()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(157, xla); }
  }

  private boolean jj_2_159(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_159()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(158, xla); }
  }

  private boolean jj_2_160(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_160()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(159, xla); }
  }

  private boolean jj_2_161(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_161()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(160, xla); }
  }

  private boolean jj_2_162(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_162()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(161, xla); }
  }

  private boolean jj_2_163(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_163()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(162, xla); }
  }

  private boolean jj_2_164(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_164()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(163, xla); }
  }

  private boolean jj_2_165(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_165()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(164, xla); }
  }

  private boolean jj_2_166(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_166()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(165, xla); }
  }

  private boolean jj_2_167(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_167()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(166, xla); }
  }

  private boolean jj_2_168(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_168()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(167, xla); }
  }

  private boolean jj_2_169(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_169()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(168, xla); }
  }

  private boolean jj_2_170(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_170()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(169, xla); }
  }

  private boolean jj_2_171(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_171()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(170, xla); }
  }

  private boolean jj_2_172(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_172()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(171, xla); }
  }

  private boolean jj_2_173(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_173()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(172, xla); }
  }

  private boolean jj_2_174(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_174()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(173, xla); }
  }

  private boolean jj_2_175(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_175()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(174, xla); }
  }

  private boolean jj_2_176(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_176()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(175, xla); }
  }

  private boolean jj_2_177(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_177()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(176, xla); }
  }

  private boolean jj_2_178(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_178()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(177, xla); }
  }

  private boolean jj_2_179(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_179()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(178, xla); }
  }

  private boolean jj_2_180(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_180()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(179, xla); }
  }

  private boolean jj_2_181(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_181()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(180, xla); }
  }

  private boolean jj_2_182(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_182()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(181, xla); }
  }

  private boolean jj_2_183(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_183()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(182, xla); }
  }

  private boolean jj_2_184(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_184()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(183, xla); }
  }

  private boolean jj_2_185(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_185()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(184, xla); }
  }

  private boolean jj_2_186(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_186()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(185, xla); }
  }

  private boolean jj_2_187(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_187()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(186, xla); }
  }

  private boolean jj_2_188(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_188()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(187, xla); }
  }

  private boolean jj_2_189(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_189()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(188, xla); }
  }

  private boolean jj_2_190(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_190()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(189, xla); }
  }

  private boolean jj_2_191(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_191()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(190, xla); }
  }

  private boolean jj_2_192(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_192()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(191, xla); }
  }

  private boolean jj_2_193(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_193()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(192, xla); }
  }

  private boolean jj_2_194(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_194()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(193, xla); }
  }

  private boolean jj_2_195(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_195()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(194, xla); }
  }

  private boolean jj_2_196(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_196()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(195, xla); }
  }

  private boolean jj_2_197(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_197()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(196, xla); }
  }

  private boolean jj_2_198(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_198()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(197, xla); }
  }

  private boolean jj_2_199(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_199()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(198, xla); }
  }

  private boolean jj_2_200(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_200()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(199, xla); }
  }

  private boolean jj_2_201(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_201()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(200, xla); }
  }

  private boolean jj_2_202(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_202()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(201, xla); }
  }

  private boolean jj_3R_Action_4585_19_740()
 {
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3R_Action_4587_15_741()
 {
    if (jj_scan_token(K_DEFAULT)) return true;
    return false;
  }

  private boolean jj_3R_TableWithAlias_1522_5_131()
 {
    if (jj_3R_Table_1507_5_251()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_TableWithAlias_1522_20_319()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_ExistsExpression_3051_5_522()
 {
    if (jj_scan_token(K_EXISTS)) return true;
    if (jj_3R_SimpleExpression_3242_5_122()) return true;
    return false;
  }

  private boolean jj_3R_Action_4584_6_717()
 {
    if (jj_scan_token(K_SET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Action_4585_19_740()) {
    jj_scanpos = xsp;
    if (jj_3R_Action_4587_15_741()) return true;
    }
    return false;
  }

  private boolean jj_3R_IsBooleanExpression_3036_19_381()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3_188()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(28)) {
    jj_scanpos = xsp;
    if (jj_scan_token(37)) return true;
    }
    return false;
  }

  private boolean jj_3R_Action_4582_6_716()
 {
    if (jj_scan_token(K_NO)) return true;
    if (jj_scan_token(K_ACTION)) return true;
    return false;
  }

  private boolean jj_3R_Action_4580_6_715()
 {
    if (jj_scan_token(K_RESTRICT)) return true;
    return false;
  }

  private boolean jj_3R_Action_4578_6_714()
 {
    if (jj_scan_token(K_CASCADE)) return true;
    return false;
  }

  private boolean jj_3R_Action_4578_5_678()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Action_4578_6_714()) {
    jj_scanpos = xsp;
    if (jj_3R_Action_4580_6_715()) {
    jj_scanpos = xsp;
    if (jj_3R_Action_4582_6_716()) {
    jj_scanpos = xsp;
    if (jj_3R_Action_4584_6_717()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_Table_1507_5_251()
 {
    if (jj_3R_RelObjectNameList_1383_5_262()) return true;
    return false;
  }

  private boolean jj_3R_IsBooleanExpression_3035_9_184()
 {
    if (jj_scan_token(K_IS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_IsBooleanExpression_3036_19_381()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_IsBooleanExpression_3036_55_382()) {
    jj_scanpos = xsp;
    if (jj_3R_IsBooleanExpression_3036_94_383()) return true;
    }
    return false;
  }

  private boolean jj_3R_LikeExpression_2989_54_385()
 {
    if (jj_scan_token(K_ILIKE)) return true;
    return false;
  }

  private boolean jj_3R_CreateView_4569_7_285()
 {
    if (jj_scan_token(K_WITH)) return true;
    if (jj_scan_token(K_READ)) return true;
    if (jj_scan_token(K_ONLY)) return true;
    return false;
  }

  private boolean jj_3R_ColDataType_4534_40_468()
 {
    if (jj_scan_token(S_LONG)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_188()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_CreateView_4562_11_486()
 {
    if (jj_scan_token(K_TEMPORARY)) return true;
    return false;
  }

  private boolean jj_3R_CreateView_4566_7_284()
 {
    if (jj_3R_ColumnsNamesList_4778_5_487()) return true;
    return false;
  }

  private boolean jj_3R_ColDataType_4534_38_252()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ColDataType_4534_40_468()) {
    jj_scanpos = xsp;
    if (jj_scan_token(284)) {
    jj_scanpos = xsp;
    if (jj_scan_token(281)) {
    jj_scanpos = xsp;
    if (jj_scan_token(37)) return true;
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_ColDataType_4535_90_670()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_RelObjectNameExt2_1494_7_321()
 {
    if (jj_3R_RelObjectNameExt_1476_5_169()) return true;
    return false;
  }

  private boolean jj_3R_CreateView_4564_7_283()
 {
    if (jj_scan_token(K_MATERIALIZED)) return true;
    return false;
  }

  private boolean jj_3R_CreateView_4561_9_485()
 {
    if (jj_scan_token(K_TEMP)) return true;
    return false;
  }

  private boolean jj_3R_CreateView_4561_9_282()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateView_4561_9_485()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateView_4562_11_486()) return true;
    }
    return false;
  }

  private boolean jj_3R_CreateView_4558_11_484()
 {
    if (jj_scan_token(K_FORCE)) return true;
    return false;
  }

  private boolean jj_3R_RelObjectNameExt2_1494_5_135()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_RelObjectNameExt2_1494_7_321()) {
    jj_scanpos = xsp;
    if (jj_scan_token(92)) {
    jj_scanpos = xsp;
    if (jj_scan_token(202)) {
    jj_scanpos = xsp;
    if (jj_scan_token(50)) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_IsNullExpression_3022_10_379()
 {
    if (jj_scan_token(K_ISNULL)) return true;
    return false;
  }

  private boolean jj_3R_CreateView_4557_9_483()
 {
    if (jj_scan_token(K_NO)) return true;
    if (jj_scan_token(K_FORCE)) return true;
    return false;
  }

  private boolean jj_3R_IsNullExpression_3022_9_183()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_IsNullExpression_3022_10_379()) {
    jj_scanpos = xsp;
    if (jj_3R_IsNullExpression_3022_54_380()) return true;
    }
    return false;
  }

  private boolean jj_3R_CreateView_4557_9_281()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateView_4557_9_483()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateView_4558_11_484()) return true;
    }
    return false;
  }

  private boolean jj_3_186()
 {
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_CreateView_4555_7_280()
 {
    if (jj_scan_token(K_OR)) return true;
    if (jj_scan_token(K_REPLACE)) return true;
    return false;
  }

  private boolean jj_3R_CreateView_4554_5_116()
 {
    if (jj_scan_token(K_CREATE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateView_4555_7_280()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateView_4557_9_281()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateView_4561_9_282()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateView_4564_7_283()) jj_scanpos = xsp;
    if (jj_scan_token(K_VIEW)) return true;
    if (jj_3R_Table_1507_5_251()) return true;
    xsp = jj_scanpos;
    if (jj_3R_CreateView_4566_7_284()) jj_scanpos = xsp;
    if (jj_scan_token(K_AS)) return true;
    if (jj_3R_SelectWithWithItems_1532_5_127()) return true;
    xsp = jj_scanpos;
    if (jj_3R_CreateView_4569_7_285()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_185()
 {
    if (jj_scan_token(K_PRECISION)) return true;
    return false;
  }

  private boolean jj_3R_ColDataType_4526_27_636()
 {
    if (jj_scan_token(291)) return true;
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_RelObjectNameExt_1476_7_350()
 {
    if (jj_3R_RelObjectName_1446_5_156()) return true;
    return false;
  }

  private boolean jj_3R_RelObjectNameExt_1476_5_169()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_RelObjectNameExt_1476_7_350()) {
    jj_scanpos = xsp;
    if (jj_scan_token(8)) {
    jj_scanpos = xsp;
    if (jj_scan_token(129)) {
    jj_scanpos = xsp;
    if (jj_scan_token(196)) {
    jj_scanpos = xsp;
    if (jj_scan_token(207)) {
    jj_scanpos = xsp;
    if (jj_scan_token(68)) {
    jj_scanpos = xsp;
    if (jj_scan_token(105)) {
    jj_scanpos = xsp;
    if (jj_scan_token(106)) {
    jj_scanpos = xsp;
    if (jj_scan_token(171)) {
    jj_scanpos = xsp;
    if (jj_scan_token(131)) {
    jj_scanpos = xsp;
    if (jj_scan_token(163)) {
    jj_scanpos = xsp;
    if (jj_scan_token(182)) {
    jj_scanpos = xsp;
    if (jj_scan_token(183)) {
    jj_scanpos = xsp;
    if (jj_scan_token(32)) {
    jj_scanpos = xsp;
    if (jj_scan_token(109)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_ColDataType_4531_19_550()
 {
    if (jj_scan_token(K_SIGNED)) return true;
    return false;
  }

  private boolean jj_3R_SimilarToExpression_3008_6_736()
 {
    if (jj_scan_token(K_ESCAPE)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3_187()
 {
    if (jj_scan_token(K_SIGNED)) return true;
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_ColDataType_4528_19_549()
 {
    if (jj_scan_token(K_UNSIGNED)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_186()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_SimilarToExpression_3005_6_525()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_SimilarToExpression_3005_5_386()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SimilarToExpression_3005_6_525()) jj_scanpos = xsp;
    if (jj_scan_token(K_SIMILAR)) return true;
    if (jj_scan_token(K_TO)) return true;
    if (jj_3R_SimpleExpression_3242_5_122()) return true;
    xsp = jj_scanpos;
    if (jj_3R_SimilarToExpression_3008_6_736()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_ColDataType_4536_8_637()
 {
    if (jj_scan_token(317)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(275)) jj_scanpos = xsp;
    if (jj_scan_token(318)) return true;
    return false;
  }

  private boolean jj_3R_ColDataType_4524_19_548()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(281)) {
    jj_scanpos = xsp;
    if (jj_scan_token(54)) {
    jj_scanpos = xsp;
    if (jj_scan_token(55)) {
    jj_scanpos = xsp;
    if (jj_scan_token(260)) {
    jj_scanpos = xsp;
    if (jj_scan_token(117)) {
    jj_scanpos = xsp;
    if (jj_scan_token(273)) {
    jj_scanpos = xsp;
    if (jj_scan_token(37)) {
    jj_scanpos = xsp;
    if (jj_scan_token(207)) {
    jj_scanpos = xsp;
    if (jj_scan_token(22)) {
    jj_scanpos = xsp;
    if (jj_scan_token(122)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_ColDataType_4526_27_636()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_190()
 {
    if (jj_scan_token(K_CHARACTER)) return true;
    if (jj_scan_token(K_SET)) return true;
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_ColDataType_4536_6_589()
 {
    Token xsp;
    if (jj_3R_ColDataType_4536_8_637()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_ColDataType_4536_8_637()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_ColDataType_4523_19_547()
 {
    if (jj_scan_token(K_DOUBLE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_185()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_189()
 {
    if (jj_scan_token(287)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_ColDataType_4534_38_252()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_ColDataType_4522_17_546()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(34)) {
    jj_scanpos = xsp;
    if (jj_scan_token(23)) return true;
    }
    xsp = jj_scanpos;
    if (jj_scan_token(249)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_RelObjectNameWithoutStart_1459_6_596()
 {
    if (jj_3R_RelObjectNameWithoutValue_1411_5_505()) return true;
    return false;
  }

  private boolean jj_3R_RelObjectNameWithoutStart_1459_5_540()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_RelObjectNameWithoutStart_1459_6_596()) {
    jj_scanpos = xsp;
    if (jj_scan_token(227)) {
    jj_scanpos = xsp;
    if (jj_scan_token(247)) {
    jj_scanpos = xsp;
    if (jj_scan_token(248)) {
    jj_scanpos = xsp;
    if (jj_scan_token(117)) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_LikeExpression_2990_6_735()
 {
    if (jj_scan_token(K_ESCAPE)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_LikeExpression_2989_6_384()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_LikeExpression_2989_5_185()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_LikeExpression_2989_6_384()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(130)) {
    jj_scanpos = xsp;
    if (jj_3R_LikeExpression_2989_54_385()) return true;
    }
    if (jj_3R_SimpleExpression_3242_5_122()) return true;
    xsp = jj_scanpos;
    if (jj_3R_LikeExpression_2990_6_735()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_107()
 {
    if (jj_3R_SimpleExpressionList_3079_5_153()) return true;
    return false;
  }

  private boolean jj_3R_ColDataType_4521_5_470()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ColDataType_4522_17_546()) {
    jj_scanpos = xsp;
    if (jj_3R_ColDataType_4523_19_547()) {
    jj_scanpos = xsp;
    if (jj_3R_ColDataType_4524_19_548()) {
    jj_scanpos = xsp;
    if (jj_3R_ColDataType_4528_19_549()) {
    jj_scanpos = xsp;
    if (jj_3_187()) {
    jj_scanpos = xsp;
    if (jj_3R_ColDataType_4531_19_550()) return true;
    }
    }
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3_189()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_ColDataType_4536_6_589()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_190()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_RelObjectName_1446_6_339()
 {
    if (jj_3R_RelObjectNameWithoutValue_1411_5_505()) return true;
    return false;
  }

  private boolean jj_3R_RelObjectName_1446_5_156()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_RelObjectName_1446_6_339()) {
    jj_scanpos = xsp;
    if (jj_scan_token(98)) {
    jj_scanpos = xsp;
    if (jj_scan_token(117)) {
    jj_scanpos = xsp;
    if (jj_scan_token(164)) {
    jj_scanpos = xsp;
    if (jj_scan_token(168)) {
    jj_scanpos = xsp;
    if (jj_scan_token(216)) {
    jj_scanpos = xsp;
    if (jj_scan_token(227)) {
    jj_scanpos = xsp;
    if (jj_scan_token(247)) {
    jj_scanpos = xsp;
    if (jj_scan_token(248)) {
    jj_scanpos = xsp;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(219)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_184()
 {
    if (jj_scan_token(287)) return true;
    if (jj_3R_Table_1507_5_251()) return true;
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_Between_2972_10_378()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_Between_2972_9_182()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Between_2972_10_378()) jj_scanpos = xsp;
    if (jj_scan_token(K_BETWEEN)) return true;
    if (jj_3R_SimpleExpression_3242_5_122()) return true;
    if (jj_scan_token(K_AND)) return true;
    if (jj_3R_SimpleExpression_3242_5_122()) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_4493_20_482()
 {
    if (jj_3R_Table_1507_5_251()) return true;
    return false;
  }

  private boolean jj_3_183()
 {
    if (jj_scan_token(287)) return true;
    if (jj_3R_SelectWithWithItems_1532_5_127()) return true;
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_4492_16_481()
 {
    if (jj_scan_token(287)) return true;
    if (jj_3R_Table_1507_5_251()) return true;
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_4489_16_480()
 {
    if (jj_3R_SelectWithWithItems_1532_5_127()) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_4488_14_479()
 {
    if (jj_scan_token(287)) return true;
    if (jj_3R_SelectWithWithItems_1532_5_127()) return true;
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_4492_5_279()
 {
    if (jj_scan_token(K_LIKE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateTable_4492_16_481()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateTable_4493_20_482()) return true;
    }
    return false;
  }

  private boolean jj_3R_CreateTable_4486_7_277()
 {
    if (jj_3R_RowMovement_4730_3_478()) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_4488_5_278()
 {
    if (jj_scan_token(K_AS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateTable_4488_14_479()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateTable_4489_16_480()) return true;
    }
    return false;
  }

  private boolean jj_3_113()
 {
    if (jj_scan_token(288)) return true;
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_scan_token(287)) return true;
    if (jj_3R_SimpleExpressionList_3079_5_153()) return true;
    return false;
  }

  private boolean jj_3_182()
 {
    if (jj_3R_CreateParameter_4620_9_250()) return true;
    return false;
  }

  private boolean jj_3R_RelObjectNameList_1384_34_134()
 {
    if (jj_scan_token(291)) return true;
    return false;
  }

  private boolean jj_3R_RelObjectNameWithoutValue_1411_5_505()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(281)) {
    jj_scanpos = xsp;
    if (jj_scan_token(285)) {
    jj_scanpos = xsp;
    if (jj_scan_token(7)) {
    jj_scanpos = xsp;
    if (jj_scan_token(28)) {
    jj_scanpos = xsp;
    if (jj_scan_token(37)) {
    jj_scanpos = xsp;
    if (jj_scan_token(35)) {
    jj_scanpos = xsp;
    if (jj_scan_token(34)) {
    jj_scanpos = xsp;
    if (jj_scan_token(33)) {
    jj_scanpos = xsp;
    if (jj_scan_token(44)) {
    jj_scanpos = xsp;
    if (jj_scan_token(47)) {
    jj_scanpos = xsp;
    if (jj_scan_token(62)) {
    jj_scanpos = xsp;
    if (jj_scan_token(60)) {
    jj_scanpos = xsp;
    if (jj_scan_token(67)) {
    jj_scanpos = xsp;
    if (jj_scan_token(82)) {
    jj_scanpos = xsp;
    if (jj_scan_token(85)) {
    jj_scanpos = xsp;
    if (jj_scan_token(87)) {
    jj_scanpos = xsp;
    if (jj_scan_token(122)) {
    jj_scanpos = xsp;
    if (jj_scan_token(126)) {
    jj_scanpos = xsp;
    if (jj_scan_token(128)) {
    jj_scanpos = xsp;
    if (jj_scan_token(137)) {
    jj_scanpos = xsp;
    if (jj_scan_token(159)) {
    jj_scanpos = xsp;
    if (jj_scan_token(173)) {
    jj_scanpos = xsp;
    if (jj_scan_token(185)) {
    jj_scanpos = xsp;
    if (jj_scan_token(198)) {
    jj_scanpos = xsp;
    if (jj_scan_token(199)) {
    jj_scanpos = xsp;
    if (jj_scan_token(211)) {
    jj_scanpos = xsp;
    if (jj_scan_token(260)) {
    jj_scanpos = xsp;
    if (jj_scan_token(40)) {
    jj_scanpos = xsp;
    if (jj_scan_token(192)) {
    jj_scanpos = xsp;
    if (jj_scan_token(229)) {
    jj_scanpos = xsp;
    if (jj_scan_token(124)) {
    jj_scanpos = xsp;
    if (jj_scan_token(13)) {
    jj_scanpos = xsp;
    if (jj_scan_token(166)) {
    jj_scanpos = xsp;
    if (jj_scan_token(170)) {
    jj_scanpos = xsp;
    if (jj_scan_token(175)) {
    jj_scanpos = xsp;
    if (jj_scan_token(181)) {
    jj_scanpos = xsp;
    if (jj_scan_token(205)) {
    jj_scanpos = xsp;
    if (jj_scan_token(147)) {
    jj_scanpos = xsp;
    if (jj_scan_token(2)) {
    jj_scanpos = xsp;
    if (jj_scan_token(30)) {
    jj_scanpos = xsp;
    if (jj_scan_token(73)) {
    jj_scanpos = xsp;
    if (jj_scan_token(218)) {
    jj_scanpos = xsp;
    if (jj_scan_token(54)) {
    jj_scanpos = xsp;
    if (jj_scan_token(43)) {
    jj_scanpos = xsp;
    if (jj_scan_token(179)) {
    jj_scanpos = xsp;
    if (jj_scan_token(115)) {
    jj_scanpos = xsp;
    if (jj_scan_token(112)) {
    jj_scanpos = xsp;
    if (jj_scan_token(180)) {
    jj_scanpos = xsp;
    if (jj_scan_token(72)) {
    jj_scanpos = xsp;
    if (jj_scan_token(222)) {
    jj_scanpos = xsp;
    if (jj_scan_token(223)) {
    jj_scanpos = xsp;
    if (jj_scan_token(226)) {
    jj_scanpos = xsp;
    if (jj_scan_token(232)) {
    jj_scanpos = xsp;
    if (jj_scan_token(120)) {
    jj_scanpos = xsp;
    if (jj_scan_token(266)) {
    jj_scanpos = xsp;
    if (jj_scan_token(41)) {
    jj_scanpos = xsp;
    if (jj_scan_token(61)) {
    jj_scanpos = xsp;
    if (jj_scan_token(125)) {
    jj_scanpos = xsp;
    if (jj_scan_token(174)) {
    jj_scanpos = xsp;
    if (jj_scan_token(55)) {
    jj_scanpos = xsp;
    if (jj_scan_token(146)) {
    jj_scanpos = xsp;
    if (jj_scan_token(230)) {
    jj_scanpos = xsp;
    if (jj_scan_token(86)) {
    jj_scanpos = xsp;
    if (jj_scan_token(70)) {
    jj_scanpos = xsp;
    if (jj_scan_token(186)) {
    jj_scanpos = xsp;
    if (jj_scan_token(201)) {
    jj_scanpos = xsp;
    if (jj_scan_token(244)) {
    jj_scanpos = xsp;
    if (jj_scan_token(213)) {
    jj_scanpos = xsp;
    if (jj_scan_token(204)) {
    jj_scanpos = xsp;
    if (jj_scan_token(206)) {
    jj_scanpos = xsp;
    if (jj_scan_token(214)) {
    jj_scanpos = xsp;
    if (jj_scan_token(217)) {
    jj_scanpos = xsp;
    if (jj_scan_token(251)) {
    jj_scanpos = xsp;
    if (jj_scan_token(151)) {
    jj_scanpos = xsp;
    if (jj_scan_token(246)) {
    jj_scanpos = xsp;
    if (jj_scan_token(51)) {
    jj_scanpos = xsp;
    if (jj_scan_token(161)) {
    jj_scanpos = xsp;
    if (jj_scan_token(76)) {
    jj_scanpos = xsp;
    if (jj_scan_token(91)) {
    jj_scanpos = xsp;
    if (jj_scan_token(64)) {
    jj_scanpos = xsp;
    if (jj_scan_token(245)) {
    jj_scanpos = xsp;
    if (jj_scan_token(31)) {
    jj_scanpos = xsp;
    if (jj_scan_token(132)) {
    jj_scanpos = xsp;
    if (jj_scan_token(15)) {
    jj_scanpos = xsp;
    if (jj_scan_token(225)) {
    jj_scanpos = xsp;
    if (jj_scan_token(172)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_106()
 {
    if (jj_3R_SubSelect_4142_5_190()) return true;
    return false;
  }

  private boolean jj_3R_MultiInExpressions_2942_3_191()
 {
    if (jj_scan_token(287)) return true;
    if (jj_scan_token(287)) return true;
    if (jj_3R_SimpleExpressionList_3079_5_153()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_113()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(288)) return true;
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_4446_30_649()
 {
    if (jj_scan_token(287)) return true;
    if (jj_3R_Expression_2720_5_226()) return true;
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_4438_37_247()
 {
    if (jj_scan_token(287)) return true;
    if (jj_3R_Expression_2720_5_226()) return true;
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_4451_21_615()
 {
    if (jj_3R_ColumnDefinition_4233_5_422()) return true;
    return false;
  }

  private boolean jj_3R_Column_1396_5_123()
 {
    if (jj_3R_RelObjectNameList_1383_5_262()) return true;
    return false;
  }

  private boolean jj_3_112()
 {
    if (jj_3R_SimpleExpression_3242_5_122()) return true;
    return false;
  }

  private boolean jj_3_179()
 {
    if (jj_scan_token(K_EXCLUDE)) return true;
    if (jj_scan_token(K_WHERE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_CreateTable_4446_30_649()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_111()
 {
    if (jj_scan_token(287)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_106()) {
    jj_scanpos = xsp;
    if (jj_3_107()) return true;
    }
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3_110()
 {
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3_109()
 {
    if (jj_3R_Function_4002_5_192()) return true;
    return false;
  }

  private boolean jj_3_108()
 {
    if (jj_3R_MultiInExpressions_2942_3_191()) return true;
    return false;
  }

  private boolean jj_3R_InExpression_2916_11_387()
 {
    if (jj_scan_token(287)) return true;
    if (jj_scan_token(295)) return true;
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_4436_26_246()
 {
    if (jj_scan_token(K_CONSTRAINT)) return true;
    if (jj_3R_RelObjectName_1446_5_156()) return true;
    return false;
  }

  private boolean jj_3_36()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(291)) {
    jj_scanpos = xsp;
    if (jj_scan_token(292)) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_RelObjectNameList_1384_34_134()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_RelObjectNameExt2_1494_5_135()) return true;
    return false;
  }

  private boolean jj_3R_InExpression_2915_9_189()
 {
    if (jj_3R_SimpleExpression_3242_5_122()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_InExpression_2916_11_387()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_InExpression_2918_6_388()) jj_scanpos = xsp;
    if (jj_scan_token(K_IN)) return true;
    xsp = jj_scanpos;
    if (jj_3_108()) {
    jj_scanpos = xsp;
    if (jj_3_109()) {
    jj_scanpos = xsp;
    if (jj_3_110()) {
    jj_scanpos = xsp;
    if (jj_3_111()) {
    jj_scanpos = xsp;
    if (jj_3_112()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_InExpression_2918_6_388()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_RelObjectNameList_1383_5_262()
 {
    if (jj_3R_RelObjectNameExt_1476_5_169()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_36()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_178()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateTable_4436_26_246()) jj_scanpos = xsp;
    if (jj_scan_token(K_CHECK)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_CreateTable_4438_37_247()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_99()
 {
    if (jj_3R_Between_2972_9_182()) return true;
    return false;
  }

  private boolean jj_3_101()
 {
    if (jj_3R_IsBooleanExpression_3035_9_184()) return true;
    return false;
  }

  private boolean jj_3_173()
 {
    if (jj_scan_token(K_ON)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(59)) {
    jj_scanpos = xsp;
    if (jj_scan_token(238)) return true;
    }
    if (jj_3R_Action_4578_5_678()) return true;
    return false;
  }

  private boolean jj_3_100()
 {
    if (jj_3R_IsNullExpression_3022_9_183()) return true;
    return false;
  }

  private boolean jj_3_172()
 {
    if (jj_scan_token(K_ON)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(59)) {
    jj_scanpos = xsp;
    if (jj_scan_token(238)) return true;
    }
    if (jj_3R_Action_4578_5_678()) return true;
    return false;
  }

  private boolean jj_3R_SQLCondition_2897_12_188()
 {
    if (jj_3R_SimilarToExpression_3005_5_386()) return true;
    return false;
  }

  private boolean jj_3_102()
 {
    if (jj_3R_LikeExpression_2989_5_185()) return true;
    return false;
  }

  private boolean jj_3_104()
 {
    if (jj_3R_InExpression_2915_9_189()) return true;
    return false;
  }

  private boolean jj_3R_SQLCondition_2895_12_187()
 {
    if (jj_3R_IsBooleanExpression_3035_9_184()) return true;
    return false;
  }

  private boolean jj_3R_SQLCondition_2894_12_186()
 {
    if (jj_3R_IsNullExpression_3022_9_183()) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_4414_26_245()
 {
    if (jj_scan_token(K_CONSTRAINT)) return true;
    if (jj_3R_RelObjectName_1446_5_156()) return true;
    return false;
  }

  private boolean jj_3_103()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_99()) {
    jj_scanpos = xsp;
    if (jj_3R_SQLCondition_2894_12_186()) {
    jj_scanpos = xsp;
    if (jj_3R_SQLCondition_2895_12_187()) {
    jj_scanpos = xsp;
    if (jj_3_102()) {
    jj_scanpos = xsp;
    if (jj_3R_SQLCondition_2897_12_188()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_105()
 {
    if (jj_3R_SimpleExpression_3242_5_122()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_103()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_SQLCondition_2891_7_375()
 {
    if (jj_3R_InExpression_2915_9_189()) return true;
    return false;
  }

  private boolean jj_3_177()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateTable_4414_26_245()) jj_scanpos = xsp;
    if (jj_scan_token(K_FOREIGN)) return true;
    if (jj_scan_token(K_KEY)) return true;
    if (jj_3R_ColumnNamesWithParamsList_4157_6_241()) return true;
    if (jj_scan_token(K_REFERENCES)) return true;
    if (jj_3R_Table_1507_5_251()) return true;
    if (jj_3R_ColumnsNamesList_4778_5_487()) return true;
    xsp = jj_scanpos;
    if (jj_3_172()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_173()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_CreateTable_4399_31_648()
 {
    if (jj_3R_CreateParameter_4620_9_250()) return true;
    return false;
  }

  private boolean jj_3R_SQLCondition_2890_5_374()
 {
    if (jj_3R_ExistsExpression_3051_5_522()) return true;
    return false;
  }

  private boolean jj_3R_SQLCondition_2889_5_180()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SQLCondition_2890_5_374()) {
    jj_scanpos = xsp;
    if (jj_3R_SQLCondition_2891_7_375()) {
    jj_scanpos = xsp;
    if (jj_3_105()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_Delete_1284_74_130()
 {
    if (jj_3R_TableWithAlias_1522_5_131()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_Delete_1285_12_318()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(K_FROM)) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_4350_77_248()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_RelObjectName_1446_5_156()) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_2844_45_520()
 {
    if (jj_scan_token(K_BINARY)) return true;
    return false;
  }

  private boolean jj_3R_MergeUpdateClause_1345_3_133()
 {
    if (jj_scan_token(K_WHEN)) return true;
    if (jj_scan_token(K_MATCHED)) return true;
    return false;
  }

  private boolean jj_3_176()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(235)) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(94)) jj_scanpos = xsp;
    if (jj_scan_token(K_KEY)) return true;
    if (jj_3R_RelObjectName_1446_5_156()) return true;
    if (jj_3R_ColumnNamesWithParamsList_4157_6_241()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_CreateTable_4399_31_648()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_CreateTable_4383_31_647()
 {
    if (jj_3R_CreateParameter_4620_9_250()) return true;
    return false;
  }

  private boolean jj_3_33()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Delete_1284_74_130()) {
    jj_scanpos = xsp;
    if (jj_scan_token(92)) return true;
    }
    return false;
  }

  private boolean jj_3R_CreateTable_4379_28_244()
 {
    if (jj_scan_token(K_UNIQUE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(124)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_97()
 {
    if (jj_3R_ComparisonItem_3196_3_181()) return true;
    return false;
  }

  private boolean jj_3_98()
 {
    if (jj_scan_token(287)) return true;
    if (jj_scan_token(295)) return true;
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_4378_26_243()
 {
    if (jj_scan_token(K_PRIMARY)) return true;
    if (jj_scan_token(K_KEY)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_2857_11_373()
 {
    if (jj_scan_token(308)) return true;
    return false;
  }

  private boolean jj_3_35()
 {
    if (jj_3R_MergeUpdateClause_1345_3_133()) return true;
    return false;
  }

  private boolean jj_3_96()
 {
    if (jj_scan_token(K_PRIOR)) return true;
    if (jj_3R_ComparisonItem_3196_3_181()) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_2856_11_372()
 {
    if (jj_scan_token(307)) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_4376_26_242()
 {
    if (jj_scan_token(K_CONSTRAINT)) return true;
    if (jj_3R_RelObjectName_1446_5_156()) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_2855_11_371()
 {
    if (jj_scan_token(OP_CONCAT)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_2854_11_370()
 {
    if (jj_scan_token(306)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_2845_19_521()
 {
    if (jj_scan_token(K_BINARY)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_2853_11_369()
 {
    if (jj_scan_token(305)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_2852_11_368()
 {
    if (jj_scan_token(293)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_2851_11_367()
 {
    if (jj_scan_token(304)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_2850_11_366()
 {
    if (jj_scan_token(303)) return true;
    return false;
  }

  private boolean jj_3_175()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateTable_4376_26_242()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateTable_4378_26_243()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateTable_4379_28_244()) return true;
    }
    if (jj_3R_ColumnNamesWithParamsList_4157_6_241()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_CreateTable_4383_31_647()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_RegularCondition_2848_7_365()
 {
    if (jj_scan_token(302)) return true;
    return false;
  }

  private boolean jj_3R_Condition_2809_45_178()
 {
    if (jj_scan_token(294)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_2847_7_364()
 {
    if (jj_scan_token(301)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_2846_7_363()
 {
    if (jj_scan_token(300)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_2844_8_519()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_2845_7_362()
 {
    if (jj_scan_token(K_RLIKE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_RegularCondition_2845_19_521()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_RegularCondition_2844_7_361()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_RegularCondition_2844_8_519()) jj_scanpos = xsp;
    if (jj_scan_token(K_REGEXP)) return true;
    xsp = jj_scanpos;
    if (jj_3R_RegularCondition_2844_45_520()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_RegularCondition_2843_7_360()
 {
    if (jj_scan_token(299)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_2842_7_359()
 {
    if (jj_scan_token(298)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_2841_7_358()
 {
    if (jj_scan_token(OP_NOTEQUALSBANG)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_2840_7_357()
 {
    if (jj_scan_token(OP_NOTEQUALSSTANDARD)) return true;
    return false;
  }

  private boolean jj_3_174()
 {
    if (jj_scan_token(K_INDEX)) return true;
    if (jj_3R_RelObjectName_1446_5_156()) return true;
    if (jj_3R_ColumnNamesWithParamsList_4157_6_241()) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_2839_7_356()
 {
    if (jj_scan_token(OP_MINORTHANEQUALS)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_2838_7_355()
 {
    if (jj_scan_token(OP_GREATERTHANEQUALS)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_2837_7_354()
 {
    if (jj_scan_token(289)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_2836_7_353()
 {
    if (jj_scan_token(297)) return true;
    return false;
  }

  private boolean jj_3_95()
 {
    if (jj_scan_token(296)) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_4358_17_564()
 {
    if (jj_scan_token(K_COMMA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_174()) {
    jj_scanpos = xsp;
    if (jj_3_175()) {
    jj_scanpos = xsp;
    if (jj_3_176()) {
    jj_scanpos = xsp;
    if (jj_3_177()) {
    jj_scanpos = xsp;
    if (jj_3_178()) {
    jj_scanpos = xsp;
    if (jj_3_179()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateTable_4451_21_615()) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_RegularCondition_2832_7_352()
 {
    if (jj_scan_token(287)) return true;
    if (jj_scan_token(295)) return true;
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3_94()
 {
    if (jj_scan_token(K_PRIOR)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_2829_5_179()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_94()) jj_scanpos = xsp;
    if (jj_3R_ComparisonItem_3196_3_181()) return true;
    xsp = jj_scanpos;
    if (jj_3R_RegularCondition_2832_7_352()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_95()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_2836_7_353()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_2837_7_354()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_2838_7_355()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_2839_7_356()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_2840_7_357()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_2841_7_358()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_2842_7_359()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_2843_7_360()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_2844_7_361()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_2845_7_362()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_2846_7_363()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_2847_7_364()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_2848_7_365()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_2850_11_366()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_2851_11_367()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_2852_11_368()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_2853_11_369()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_2854_11_370()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_2855_11_371()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_2856_11_372()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_2857_11_373()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3_96()) {
    jj_scanpos = xsp;
    if (jj_3_97()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3_98()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_Delete_1285_12_318()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_TableWithAlias_1522_5_131()) return true;
    return false;
  }

  private boolean jj_3_34()
 {
    if (jj_3R_TableWithAlias_1522_5_131()) return true;
    if (jj_3R_JoinsList_2243_5_132()) return true;
    return false;
  }

  private boolean jj_3R_Condition_2809_21_177()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3_92()
 {
    if (jj_3R_RegularCondition_2829_5_179()) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_4352_13_249()
 {
    if (jj_scan_token(287)) return true;
    if (jj_3R_ColumnDefinition_4233_5_422()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_CreateTable_4358_17_564()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_AndExpression_2787_39_753()
 {
    if (jj_scan_token(294)) return true;
    return false;
  }

  private boolean jj_3_93()
 {
    if (jj_3R_SQLCondition_2889_5_180()) return true;
    return false;
  }

  private boolean jj_3_180()
 {
    if (jj_scan_token(287)) return true;
    if (jj_3R_RelObjectName_1446_5_156()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_CreateTable_4350_77_248()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_Condition_2811_9_351()
 {
    if (jj_3R_RegularCondition_2829_5_179()) return true;
    return false;
  }

  private boolean jj_3_181()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_180()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateTable_4352_13_249()) return true;
    }
    return false;
  }

  private boolean jj_3_171()
 {
    if (jj_scan_token(K_IF)) return true;
    if (jj_scan_token(K_NOT)) return true;
    if (jj_scan_token(K_EXISTS)) return true;
    return false;
  }

  private boolean jj_3_91()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Condition_2809_21_177()) {
    jj_scanpos = xsp;
    if (jj_3R_Condition_2809_45_178()) return true;
    }
    return false;
  }

  private boolean jj_3R_Condition_2809_5_176()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_91()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_Condition_2811_9_351()) {
    jj_scanpos = xsp;
    if (jj_3_93()) return true;
    }
    return false;
  }

  private boolean jj_3R_CreateTable_4343_6_276()
 {
    if (jj_3R_CreateParameter_4620_9_250()) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_4339_7_275()
 {
    if (jj_scan_token(K_GLOBAL)) return true;
    return false;
  }

  private boolean jj_3R_AndExpression_2775_35_710()
 {
    if (jj_scan_token(294)) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_4336_7_274()
 {
    if (jj_scan_token(K_UNLOGGED)) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_4335_5_115()
 {
    if (jj_scan_token(K_CREATE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateTable_4336_7_274()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateTable_4339_7_275()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_CreateTable_4343_6_276()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(K_TABLE)) return true;
    xsp = jj_scanpos;
    if (jj_3_171()) jj_scanpos = xsp;
    if (jj_3R_Table_1507_5_251()) return true;
    xsp = jj_scanpos;
    if (jj_3_181()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_182()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_CreateTable_4486_7_277()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateTable_4488_5_278()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateTable_4492_5_279()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_AndExpression_2782_21_706()
 {
    if (jj_scan_token(K_AND_OPERATOR)) return true;
    return false;
  }

  private boolean jj_3_90()
 {
    if (jj_3R_Condition_2809_5_176()) return true;
    return false;
  }

  private boolean jj_3R_AndExpression_2787_15_752()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_AndExpression_2787_15_739()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AndExpression_2787_15_752()) {
    jj_scanpos = xsp;
    if (jj_3R_AndExpression_2787_39_753()) return true;
    }
    return false;
  }

  private boolean jj_3R_AndExpression_2787_13_708()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AndExpression_2787_15_739()) jj_scanpos = xsp;
    if (jj_scan_token(287)) return true;
    if (jj_3R_XorExpression_2730_5_416()) return true;
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_AndExpression_2784_9_707()
 {
    if (jj_3R_Condition_2809_5_176()) return true;
    return false;
  }

  private boolean jj_3_89()
 {
    if (jj_3R_Condition_2809_5_176()) return true;
    return false;
  }

  private boolean jj_3R_AndExpression_2781_9_674()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(11)) {
    jj_scanpos = xsp;
    if (jj_3R_AndExpression_2782_21_706()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_AndExpression_2784_9_707()) {
    jj_scanpos = xsp;
    if (jj_3R_AndExpression_2787_13_708()) return true;
    }
    return false;
  }

  private boolean jj_3R_AndExpression_2775_11_709()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_AndExpression_2775_11_675()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AndExpression_2775_11_709()) {
    jj_scanpos = xsp;
    if (jj_3R_AndExpression_2775_35_710()) return true;
    }
    return false;
  }

  private boolean jj_3R_AndExpression_2775_9_644()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AndExpression_2775_11_675()) jj_scanpos = xsp;
    if (jj_scan_token(287)) return true;
    if (jj_3R_XorExpression_2730_5_416()) return true;
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_AndExpression_2772_9_643()
 {
    if (jj_3R_Condition_2809_5_176()) return true;
    return false;
  }

  private boolean jj_3_31()
 {
    if (jj_scan_token(287)) return true;
    if (jj_3R_SelectWithWithItems_1532_5_127()) return true;
    return false;
  }

  private boolean jj_3R_AndExpression_2771_5_595()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AndExpression_2772_9_643()) {
    jj_scanpos = xsp;
    if (jj_3R_AndExpression_2775_9_644()) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_AndExpression_2781_9_674()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_Upsert_1218_23_129()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(248)) {
    jj_scanpos = xsp;
    if (jj_scan_token(247)) return true;
    }
    return false;
  }

  private boolean jj_3R_PathSpecification_4295_10_554()
 {
    if (jj_scan_token(K_COMMA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(281)) {
    jj_scanpos = xsp;
    if (jj_scan_token(285)) return true;
    }
    return false;
  }

  private boolean jj_3R_PathSpecification_4294_5_475()
 {
    if (jj_scan_token(K_PATH)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(281)) {
    jj_scanpos = xsp;
    if (jj_scan_token(285)) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_PathSpecification_4295_10_554()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_32()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Upsert_1218_23_129()) jj_scanpos = xsp;
    if (jj_scan_token(287)) return true;
    if (jj_3R_SimpleExpression_3242_5_122()) return true;
    return false;
  }

  private boolean jj_3R_OrExpression_2751_9_641()
 {
    if (jj_scan_token(K_OR)) return true;
    if (jj_3R_AndExpression_2771_5_595()) return true;
    return false;
  }

  private boolean jj_3_30()
 {
    if (jj_scan_token(287)) return true;
    if (jj_3R_Column_1396_5_123()) return true;
    return false;
  }

  private boolean jj_3R_OrExpression_2749_5_538()
 {
    if (jj_3R_AndExpression_2771_5_595()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_OrExpression_2751_9_641()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_CreateSchema_4276_11_476()
 {
    if (jj_3R_CreateView_4554_5_116()) return true;
    return false;
  }

  private boolean jj_3_170()
 {
    if (jj_3R_CreateTable_4335_5_115()) return true;
    return false;
  }

  private boolean jj_3R_CreateSchema_4270_9_268()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_170()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateSchema_4276_11_476()) return true;
    }
    return false;
  }

  private boolean jj_3R_XorExpression_2732_9_592()
 {
    if (jj_scan_token(K_XOR)) return true;
    if (jj_3R_OrExpression_2749_5_538()) return true;
    return false;
  }

  private boolean jj_3_87()
 {
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_CreateSchema_4267_6_267()
 {
    if (jj_3R_PathSpecification_4294_5_475()) return true;
    return false;
  }

  private boolean jj_3R_XorExpression_2730_5_416()
 {
    if (jj_3R_OrExpression_2749_5_538()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_XorExpression_2732_9_592()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_CreateSchema_4263_7_266()
 {
    if (jj_scan_token(K_AUTHORIZATION)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(281)) {
    jj_scanpos = xsp;
    if (jj_scan_token(285)) return true;
    }
    return false;
  }

  private boolean jj_3R_CreateSchema_4262_7_265()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(281)) {
    jj_scanpos = xsp;
    if (jj_scan_token(285)) return true;
    }
    return false;
  }

  private boolean jj_3R_CreateSchema_4261_5_112()
 {
    if (jj_scan_token(K_CREATE)) return true;
    if (jj_scan_token(K_SCHEMA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateSchema_4262_7_265()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateSchema_4263_7_266()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateSchema_4267_6_267()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_CreateSchema_4270_9_268()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_Expression_2720_5_226()
 {
    if (jj_3R_XorExpression_2730_5_416()) return true;
    return false;
  }

  private boolean jj_3R_First_2706_19_329()
 {
    if (jj_3R_SimpleJdbcParameter_2489_5_222()) return true;
    return false;
  }

  private boolean jj_3R_First_2705_19_328()
 {
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3_29()
 {
    if (jj_3R_ListExpressionItem_1063_4_124()) return true;
    return false;
  }

  private boolean jj_3R_First_2701_16_326()
 {
    if (jj_scan_token(K_LIMIT)) return true;
    return false;
  }

  private boolean jj_3R_First_2704_10_327()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_ColumnDefinition_4237_7_614()
 {
    if (jj_3R_CreateParameter_4620_9_250()) return true;
    return false;
  }

  private boolean jj_3R_First_2700_7_325()
 {
    if (jj_scan_token(K_FIRST)) return true;
    return false;
  }

  private boolean jj_3R_First_2700_5_137()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_First_2700_7_325()) {
    jj_scanpos = xsp;
    if (jj_3R_First_2701_16_326()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_First_2704_10_327()) {
    jj_scanpos = xsp;
    if (jj_3R_First_2705_19_328()) {
    jj_scanpos = xsp;
    if (jj_3R_First_2706_19_329()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_ColumnDefinition_4233_5_422()
 {
    if (jj_3R_RelObjectName_1446_5_156()) return true;
    if (jj_3R_ColDataType_4521_5_470()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_ColumnDefinition_4237_7_614()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_Skip_2668_19_324()
 {
    if (jj_3R_SimpleJdbcParameter_2489_5_222()) return true;
    return false;
  }

  private boolean jj_3R_CreateIndex_4215_7_264()
 {
    if (jj_3R_CreateParameter_4620_9_250()) return true;
    return false;
  }

  private boolean jj_3R_Skip_2667_19_323()
 {
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_CreateIndex_4209_7_263()
 {
    if (jj_scan_token(K_USING)) return true;
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_Skip_2666_10_322()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3_27()
 {
    if (jj_scan_token(287)) return true;
    if (jj_3R_SelectWithWithItems_1532_5_127()) return true;
    return false;
  }

  private boolean jj_3R_Skip_2664_5_136()
 {
    if (jj_scan_token(K_SKIP)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Skip_2666_10_322()) {
    jj_scanpos = xsp;
    if (jj_3R_Skip_2667_19_323()) {
    jj_scanpos = xsp;
    if (jj_3R_Skip_2668_19_324()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_CreateIndex_4197_7_261()
 {
    if (jj_3R_CreateParameter_4620_9_250()) return true;
    return false;
  }

  private boolean jj_3R_CreateIndex_4196_5_111()
 {
    if (jj_scan_token(K_CREATE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateIndex_4197_7_261()) jj_scanpos = xsp;
    if (jj_scan_token(K_INDEX)) return true;
    if (jj_3R_RelObjectNameList_1383_5_262()) return true;
    if (jj_scan_token(K_ON)) return true;
    if (jj_3R_Table_1507_5_251()) return true;
    xsp = jj_scanpos;
    if (jj_3R_CreateIndex_4209_7_263()) jj_scanpos = xsp;
    if (jj_3R_ColumnNamesWithParamsList_4157_6_241()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_CreateIndex_4215_7_264()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_Insert_1107_23_128()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(248)) {
    jj_scanpos = xsp;
    if (jj_scan_token(247)) return true;
    }
    return false;
  }

  private boolean jj_3R_InternalFunction_4038_157_234()
 {
    if (jj_3R_OrderByElements_2459_5_418()) return true;
    return false;
  }

  private boolean jj_3_88()
 {
    if (jj_scan_token(K_PERCENT)) return true;
    return false;
  }

  private boolean jj_3R_Top_2646_8_333()
 {
    if (jj_scan_token(287)) return true;
    if (jj_3R_AdditiveExpression_3321_5_397()) return true;
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_Offset_2586_66_700()
 {
    if (jj_scan_token(K_ROW)) return true;
    return false;
  }

  private boolean jj_3R_Top_2644_8_332()
 {
    if (jj_scan_token(292)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_87()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_28()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Insert_1107_23_128()) jj_scanpos = xsp;
    if (jj_scan_token(287)) return true;
    if (jj_3R_SimpleExpression_3242_5_122()) return true;
    return false;
  }

  private boolean jj_3R_Top_2641_10_331()
 {
    if (jj_3R_SimpleJdbcParameter_2489_5_222()) return true;
    return false;
  }

  private boolean jj_3R_Top_2639_10_330()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_ColumnNamesWithParamsList_4171_11_553()
 {
    if (jj_3R_CreateParameter_4620_9_250()) return true;
    return false;
  }

  private boolean jj_3_26()
 {
    if (jj_scan_token(287)) return true;
    if (jj_3R_Column_1396_5_123()) return true;
    return false;
  }

  private boolean jj_3R_Top_2637_5_142()
 {
    if (jj_scan_token(K_TOP)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Top_2639_10_330()) {
    jj_scanpos = xsp;
    if (jj_3R_Top_2641_10_331()) {
    jj_scanpos = xsp;
    if (jj_3R_Top_2644_8_332()) {
    jj_scanpos = xsp;
    if (jj_3R_Top_2646_8_333()) return true;
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3_88()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_ColumnNamesWithParamsList_4167_9_474()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_RelObjectName_1446_5_156()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ColumnNamesWithParamsList_4171_11_553()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_ColumnNamesWithParamsList_4161_7_473()
 {
    if (jj_3R_CreateParameter_4620_9_250()) return true;
    return false;
  }

  private boolean jj_3R_ColumnNamesWithParamsList_4157_6_241()
 {
    if (jj_scan_token(287)) return true;
    if (jj_3R_RelObjectName_1446_5_156()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ColumnNamesWithParamsList_4161_7_473()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_ColumnNamesWithParamsList_4167_9_474()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_OptimizeFor_2622_5_727()
 {
    if (jj_scan_token(K_OPTIMIZE)) return true;
    if (jj_scan_token(K_FOR)) return true;
    if (jj_scan_token(S_LONG)) return true;
    if (jj_scan_token(K_ROWS)) return true;
    return false;
  }

  private boolean jj_3R_Fetch_2607_19_660()
 {
    if (jj_scan_token(K_ROWS)) return true;
    return false;
  }

  private boolean jj_3R_Fetch_2606_20_659()
 {
    if (jj_3R_SimpleJdbcParameter_2489_5_222()) return true;
    return false;
  }

  private boolean jj_3R_Fetch_2605_19_658()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_Fetch_2604_20_657()
 {
    if (jj_scan_token(K_FIRST)) return true;
    return false;
  }

  private boolean jj_3_86()
 {
    if (jj_3R_RelObjectNameExt_1476_5_169()) return true;
    return false;
  }

  private boolean jj_3R_SubSelect_4142_7_389()
 {
    if (jj_3R_WithList_1762_5_497()) return true;
    return false;
  }

  private boolean jj_3R_SubSelect_4142_5_190()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SubSelect_4142_7_389()) jj_scanpos = xsp;
    if (jj_3R_SelectBody_1553_5_288()) return true;
    return false;
  }

  private boolean jj_3_169()
 {
    if (jj_3R_Alias_1852_5_240()) return true;
    return false;
  }

  private boolean jj_3R_InternalFunction_4030_113_231()
 {
    if (jj_scan_token(K_UNIQUE)) return true;
    return false;
  }

  private boolean jj_3R_Offset_2586_20_699()
 {
    if (jj_scan_token(K_ROWS)) return true;
    return false;
  }

  private boolean jj_3R_Fetch_2601_5_621()
 {
    if (jj_scan_token(K_FETCH)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Fetch_2604_20_657()) {
    jj_scanpos = xsp;
    if (jj_scan_token(145)) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_Fetch_2605_19_658()) {
    jj_scanpos = xsp;
    if (jj_3R_Fetch_2606_20_659()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_Fetch_2607_19_660()) {
    jj_scanpos = xsp;
    if (jj_scan_token(198)) return true;
    }
    if (jj_scan_token(K_ONLY)) return true;
    return false;
  }

  private boolean jj_3_84()
 {
    if (jj_3R_RelObjectNameExt_1476_5_169()) return true;
    return false;
  }

  private boolean jj_3R_Offset_2586_19_656()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Offset_2586_20_699()) {
    jj_scanpos = xsp;
    if (jj_3R_Offset_2586_66_700()) return true;
    }
    return false;
  }

  private boolean jj_3R_Offset_2585_20_655()
 {
    if (jj_3R_SimpleJdbcNamedParameter_2500_5_698()) return true;
    return false;
  }

  private boolean jj_3R_Offset_2584_20_654()
 {
    if (jj_3R_SimpleJdbcParameter_2489_5_222()) return true;
    return false;
  }

  private boolean jj_3R_Offset_2583_19_653()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_ListExpressionItem_1063_4_124()
 {
    if (jj_3R_SelectExpressionItem_1811_7_155()) return true;
    return false;
  }

  private boolean jj_3_83()
 {
    if (jj_3R_RelObjectNameExt_1476_5_169()) return true;
    return false;
  }

  private boolean jj_3R_TableFunction_4128_5_161()
 {
    if (jj_3R_Function_4002_5_192()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_169()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_Replace_1040_21_472()
 {
    if (jj_3R_SubSelect_4142_5_190()) return true;
    return false;
  }

  private boolean jj_3R_Replace_1028_31_125()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(248)) {
    jj_scanpos = xsp;
    if (jj_scan_token(247)) return true;
    }
    return false;
  }

  private boolean jj_3R_Offset_2579_5_620()
 {
    if (jj_scan_token(K_OFFSET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Offset_2583_19_653()) {
    jj_scanpos = xsp;
    if (jj_3R_Offset_2584_20_654()) {
    jj_scanpos = xsp;
    if (jj_3R_Offset_2585_20_655()) return true;
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_Offset_2586_19_656()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_ValueListExpression_4114_5_195()
 {
    if (jj_scan_token(287)) return true;
    if (jj_3R_SimpleExpressionListAtLeastTwoItems_3184_5_394()) return true;
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3_25()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Replace_1028_31_125()) jj_scanpos = xsp;
    if (jj_scan_token(287)) return true;
    if (jj_3R_PrimaryExpression_3421_5_126()) return true;
    return false;
  }

  private boolean jj_3R_InternalFunction_4040_72_235()
 {
    if (jj_3R_OrderByElements_2459_5_418()) return true;
    return false;
  }

  private boolean jj_3_24()
 {
    if (jj_scan_token(287)) return true;
    if (jj_3R_Column_1396_5_123()) return true;
    return false;
  }

  private boolean jj_3R_MySQLGroupConcat_4100_10_763()
 {
    if (jj_scan_token(K_SEPARATOR)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_MySQLGroupConcat_4099_10_762()
 {
    if (jj_3R_OrderByElements_2459_5_418()) return true;
    return false;
  }

  private boolean jj_3R_PlainLimit_2563_10_734()
 {
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3R_MySQLGroupConcat_4097_9_759()
 {
    if (jj_scan_token(K_DISTINCT)) return true;
    return false;
  }

  private boolean jj_3R_PlainLimit_2561_10_733()
 {
    if (jj_scan_token(K_ALL)) return true;
    return false;
  }

  private boolean jj_3R_Replace_1025_9_257()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_24()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_25()) {
    jj_scanpos = xsp;
    if (jj_3R_Replace_1040_21_472()) return true;
    }
    return false;
  }

  private boolean jj_3R_PlainLimit_2559_9_732()
 {
    if (jj_scan_token(292)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_86()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_23()
 {
    if (jj_scan_token(K_INTO)) return true;
    return false;
  }

  private boolean jj_3R_PlainLimit_2557_10_731()
 {
    if (jj_3R_SimpleJdbcParameter_2489_5_222()) return true;
    return false;
  }

  private boolean jj_3R_MySQLGroupConcat_4096_5_495()
 {
    if (jj_scan_token(K_GROUP_CONCAT)) return true;
    if (jj_scan_token(287)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_MySQLGroupConcat_4097_9_759()) jj_scanpos = xsp;
    if (jj_3R_SimpleExpressionList_3079_5_153()) return true;
    xsp = jj_scanpos;
    if (jj_3R_MySQLGroupConcat_4099_10_762()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_MySQLGroupConcat_4100_10_763()) jj_scanpos = xsp;
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_InternalFunction_4030_71_230()
 {
    if (jj_scan_token(K_ALL)) return true;
    return false;
  }

  private boolean jj_3R_PlainLimit_2555_10_730()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_XMLSerializeExpr_4076_19_764()
 {
    if (jj_3R_OrderByElements_2459_5_418()) return true;
    return false;
  }

  private boolean jj_3R_Replace_1016_9_256()
 {
    if (jj_scan_token(K_SET)) return true;
    return false;
  }

  private boolean jj_3R_PlainLimit_2552_5_697()
 {
    if (jj_scan_token(K_LIMIT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainLimit_2555_10_730()) {
    jj_scanpos = xsp;
    if (jj_3R_PlainLimit_2557_10_731()) {
    jj_scanpos = xsp;
    if (jj_3R_PlainLimit_2559_9_732()) {
    jj_scanpos = xsp;
    if (jj_3R_PlainLimit_2561_10_733()) {
    jj_scanpos = xsp;
    if (jj_3R_PlainLimit_2563_10_734()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_Replace_1013_5_107()
 {
    if (jj_scan_token(K_REPLACE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_23()) jj_scanpos = xsp;
    if (jj_3R_Table_1507_5_251()) return true;
    xsp = jj_scanpos;
    if (jj_3R_Replace_1016_9_256()) {
    jj_scanpos = xsp;
    if (jj_3R_Replace_1025_9_257()) return true;
    }
    return false;
  }

  private boolean jj_3R_LimitWithOffset_2533_18_175()
 {
    if (jj_scan_token(292)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_84()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_LimitWithOffset_2536_13_652()
 {
    if (jj_3R_PlainLimit_2552_5_697()) return true;
    return false;
  }

  private boolean jj_3R_LimitWithOffset_2531_18_174()
 {
    if (jj_3R_SimpleJdbcParameter_2489_5_222()) return true;
    return false;
  }

  private boolean jj_3R_LimitWithOffset_2523_26_172()
 {
    if (jj_scan_token(292)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_83()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_LimitWithOffset_2521_26_171()
 {
    if (jj_3R_SimpleJdbcParameter_2489_5_222()) return true;
    return false;
  }

  private boolean jj_3R_LimitWithOffset_2529_17_173()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_LimitWithOffset_2519_26_170()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_XMLSerializeExpr_4072_5_496()
 {
    if (jj_scan_token(K_XMLSERIALIZE)) return true;
    if (jj_scan_token(287)) return true;
    if (jj_scan_token(K_XMLAGG)) return true;
    if (jj_scan_token(287)) return true;
    if (jj_scan_token(K_XMLTEXT)) return true;
    if (jj_scan_token(287)) return true;
    if (jj_3R_SimpleExpression_3242_5_122()) return true;
    if (jj_scan_token(288)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_XMLSerializeExpr_4076_19_764()) jj_scanpos = xsp;
    if (jj_scan_token(288)) return true;
    if (jj_scan_token(K_AS)) return true;
    if (jj_3R_ColDataType_4521_5_470()) return true;
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3_22()
 {
    if (jj_3R_ListExpressionItem_1063_4_124()) return true;
    return false;
  }

  private boolean jj_3R_InternalFunction_4050_15_638()
 {
    if (jj_3R_RelObjectName_1446_5_156()) return true;
    return false;
  }

  private boolean jj_3_85()
 {
    if (jj_scan_token(K_LIMIT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_LimitWithOffset_2519_26_170()) {
    jj_scanpos = xsp;
    if (jj_3R_LimitWithOffset_2521_26_171()) {
    jj_scanpos = xsp;
    if (jj_3R_LimitWithOffset_2523_26_172()) return true;
    }
    }
    if (jj_scan_token(K_COMMA)) return true;
    xsp = jj_scanpos;
    if (jj_3R_LimitWithOffset_2529_17_173()) {
    jj_scanpos = xsp;
    if (jj_3R_LimitWithOffset_2531_18_174()) {
    jj_scanpos = xsp;
    if (jj_3R_LimitWithOffset_2533_18_175()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_167()
 {
    if (jj_3R_Function_4002_5_192()) return true;
    return false;
  }

  private boolean jj_3_168()
 {
    if (jj_3R_KeepExpression_3696_5_239()) return true;
    return false;
  }

  private boolean jj_3_163()
 {
    if (jj_3R_NamedExpressionListExprFirst_3150_9_233()) return true;
    return false;
  }

  private boolean jj_3_162()
 {
    if (jj_3R_NamedExpressionList1_3114_5_232()) return true;
    return false;
  }

  private boolean jj_3R_InternalFunction_4045_11_588()
 {
    if (jj_scan_token(K_IGNORE)) return true;
    if (jj_scan_token(K_NULLS)) return true;
    return false;
  }

  private boolean jj_3R_InternalFunction_4030_26_229()
 {
    if (jj_scan_token(K_DISTINCT)) return true;
    return false;
  }

  private boolean jj_3R_InternalFunction_4048_7_590()
 {
    if (jj_scan_token(291)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_167()) {
    jj_scanpos = xsp;
    if (jj_3R_InternalFunction_4050_15_638()) return true;
    }
    return false;
  }

  private boolean jj_3R_InternalFunction_4042_13_238()
 {
    if (jj_3R_SubSelect_4142_5_190()) return true;
    return false;
  }

  private boolean jj_3R_LimitWithOffset_2514_5_619()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_85()) {
    jj_scanpos = xsp;
    if (jj_3R_LimitWithOffset_2536_13_652()) return true;
    }
    return false;
  }

  private boolean jj_3_165()
 {
    if (jj_3R_SimpleExpressionList_3079_5_153()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_InternalFunction_4040_72_235()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_164()
 {
    if (jj_3R_ComplexExpressionList_3093_5_223()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_InternalFunction_4038_157_234()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_InternalFunction_4036_13_237()
 {
    if (jj_3R_NamedExpressionListExprFirst_3150_9_233()) return true;
    return false;
  }

  private boolean jj_3R_InternalFunction_4034_13_236()
 {
    if (jj_3R_NamedExpressionList1_3114_5_232()) return true;
    return false;
  }

  private boolean jj_3_82()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3_160()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_InternalFunction_4030_26_229()) {
    jj_scanpos = xsp;
    if (jj_3R_InternalFunction_4030_71_230()) {
    jj_scanpos = xsp;
    if (jj_3R_InternalFunction_4030_113_231()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_161()
 {
    if (jj_scan_token(290)) return true;
    return false;
  }

  private boolean jj_3_166()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_160()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_161()) {
    jj_scanpos = xsp;
    if (jj_3R_InternalFunction_4034_13_236()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = getAsBoolean(Feature.allowComplexParsing);
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_InternalFunction_4036_13_237()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = getAsBoolean(Feature.allowComplexParsing);
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3_164()) {
    jj_scanpos = xsp;
    if (jj_3_165()) {
    jj_scanpos = xsp;
    if (jj_3R_InternalFunction_4042_13_238()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_SimpleJdbcNamedParameter_2500_5_698()
 {
    if (jj_scan_token(292)) return true;
    if (jj_3R_RelObjectNameExt_1476_5_169()) return true;
    return false;
  }

  private boolean jj_3R_Synonym_5564_5_273()
 {
    if (jj_3R_RelObjectNameList_1383_5_262()) return true;
    return false;
  }

  private boolean jj_3R_InternalFunction_4028_5_526()
 {
    if (jj_3R_RelObjectNameList_1383_5_262()) return true;
    if (jj_scan_token(287)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_166()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_InternalFunction_4045_11_588()) jj_scanpos = xsp;
    if (jj_scan_token(288)) return true;
    xsp = jj_scanpos;
    if (jj_3R_InternalFunction_4048_7_590()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_168()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_21()
 {
    if (jj_3R_Column_1396_5_123()) return true;
    if (jj_scan_token(289)) return true;
    if (jj_3R_SimpleExpression_3242_5_122()) return true;
    return false;
  }

  private boolean jj_3R_SimpleJdbcParameter_2489_5_222()
 {
    if (jj_scan_token(293)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_82()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_OrderByElement_2473_19_728()
 {
    if (jj_scan_token(K_DESC)) return true;
    return false;
  }

  private boolean jj_3R_OrderByElement_2476_9_751()
 {
    if (jj_scan_token(K_LAST)) return true;
    return false;
  }

  private boolean jj_3R_ShowTables_897_53_492()
 {
    if (jj_scan_token(K_WHERE)) return true;
    if (jj_3R_Expression_2720_5_226()) return true;
    return false;
  }

  private boolean jj_3R_OrderByElement_2475_9_750()
 {
    if (jj_scan_token(K_FIRST)) return true;
    return false;
  }

  private boolean jj_3R_OrderByElement_2475_9_729()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_OrderByElement_2475_9_750()) {
    jj_scanpos = xsp;
    if (jj_3R_OrderByElement_2476_9_751()) return true;
    }
    return false;
  }

  private boolean jj_3R_FullTextSearch_3957_62_404()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_Column_1396_5_123()) return true;
    return false;
  }

  private boolean jj_3R_CreateSynonym_5547_4_272()
 {
    if (jj_scan_token(K_PUBLIC)) return true;
    return false;
  }

  private boolean jj_3R_OrderByElement_2474_6_696()
 {
    if (jj_scan_token(K_NULLS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_OrderByElement_2475_9_729()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_OrderByElement_2473_7_695()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(18)) {
    jj_scanpos = xsp;
    if (jj_3R_OrderByElement_2473_19_728()) return true;
    }
    return false;
  }

  private boolean jj_3R_Function_4004_11_391()
 {
    if (jj_3R_InternalFunction_4028_5_526()) return true;
    return false;
  }

  private boolean jj_3R_CreateSynonym_5546_4_271()
 {
    if (jj_scan_token(K_OR)) return true;
    if (jj_scan_token(K_REPLACE)) return true;
    return false;
  }

  private boolean jj_3R_CreateSynonym_5545_3_114()
 {
    if (jj_scan_token(K_CREATE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateSynonym_5546_4_271()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateSynonym_5547_4_272()) jj_scanpos = xsp;
    if (jj_scan_token(K_SYNONYM)) return true;
    if (jj_3R_Synonym_5564_5_273()) return true;
    if (jj_scan_token(K_FOR)) return true;
    if (jj_3R_RelObjectNameList_1383_5_262()) return true;
    return false;
  }

  private boolean jj_3R_OrderByElement_2472_5_650()
 {
    if (jj_3R_Expression_2720_5_226()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_OrderByElement_2473_7_695()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_OrderByElement_2474_6_696()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_Function_4003_9_390()
 {
    if (jj_scan_token(333)) return true;
    if (jj_scan_token(K_FN)) return true;
    if (jj_3R_InternalFunction_4028_5_526()) return true;
    if (jj_scan_token(320)) return true;
    return false;
  }

  private boolean jj_3R_Function_4002_5_192()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Function_4003_9_390()) {
    jj_scanpos = xsp;
    if (jj_3R_Function_4004_11_391()) return true;
    }
    return false;
  }

  private boolean jj_3R_OrderByElements_2460_10_651()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_OrderByElement_2472_5_650()) return true;
    return false;
  }

  private boolean jj_3R_OrderByElements_2459_5_418()
 {
    if (jj_scan_token(K_ORDER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(211)) jj_scanpos = xsp;
    if (jj_scan_token(K_BY)) return true;
    if (jj_3R_OrderByElement_2472_5_650()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_OrderByElements_2460_10_651()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_Values_922_5_502()
 {
    if (jj_scan_token(K_VALUES)) return true;
    if (jj_3R_SimpleExpressionList_3079_5_153()) return true;
    return false;
  }

  private boolean jj_3R_CreateFunctionStatement_5517_15_258()
 {
    if (jj_scan_token(K_OR)) return true;
    if (jj_scan_token(K_REPLACE)) return true;
    return false;
  }

  private boolean jj_3R_CreateFunctionStatement_5521_4_260()
 {
    if (jj_scan_token(K_PROCEDURE)) return true;
    return false;
  }

  private boolean jj_3_76()
 {
    if (jj_scan_token(287)) return true;
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3_78()
 {
    if (jj_3R_SimpleExpression_3242_5_122()) return true;
    return false;
  }

  private boolean jj_3R_CreateFunctionStatement_5519_4_259()
 {
    if (jj_scan_token(K_FUNCTION)) return true;
    return false;
  }

  private boolean jj_3R_Having_2447_5_723()
 {
    if (jj_scan_token(K_HAVING)) return true;
    if (jj_3R_Expression_2720_5_226()) return true;
    return false;
  }

  private boolean jj_3_77()
 {
    if (jj_scan_token(287)) return true;
    if (jj_3R_SimpleExpressionList_3079_5_153()) return true;
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_CreateFunctionStatement_5517_3_110()
 {
    if (jj_scan_token(K_CREATE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateFunctionStatement_5517_15_258()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateFunctionStatement_5519_4_259()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateFunctionStatement_5521_4_260()) return true;
    }
    if (true) { jj_la = 0; jj_scanpos = jj_lastpos; return false;}
    return false;
  }

  private boolean jj_3_75()
 {
    if (jj_3R_SimpleExpression_3242_5_122()) return true;
    return false;
  }

  private boolean jj_3_74()
 {
    if (jj_scan_token(287)) return true;
    if (jj_3R_SimpleExpressionList_3079_5_153()) return true;
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_GroupByColumnReferences_2432_15_757()
 {
    if (jj_scan_token(K_COMMA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_76()) {
    jj_scanpos = xsp;
    if (jj_3_77()) {
    jj_scanpos = xsp;
    if (jj_3_78()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_73()
 {
    if (jj_scan_token(287)) return true;
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_ShowTables_897_6_491()
 {
    if (jj_scan_token(K_LIKE)) return true;
    if (jj_3R_SimpleExpression_3242_5_122()) return true;
    return false;
  }

  private boolean jj_3R_FullTextSearch_3960_13_405()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(329)) {
    jj_scanpos = xsp;
    if (jj_scan_token(330)) {
    jj_scanpos = xsp;
    if (jj_scan_token(331)) {
    jj_scanpos = xsp;
    if (jj_scan_token(332)) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_ShowTables_897_5_292()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ShowTables_897_6_491()) {
    jj_scanpos = xsp;
    if (jj_3R_ShowTables_897_53_492()) return true;
    }
    return false;
  }

  private boolean jj_3R_GroupByColumnReferences_2427_9_748()
 {
    if (jj_scan_token(K_GROUPING)) return true;
    if (jj_scan_token(K_SETS)) return true;
    if (jj_scan_token(287)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_73()) {
    jj_scanpos = xsp;
    if (jj_3_74()) {
    jj_scanpos = xsp;
    if (jj_3_75()) return true;
    }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_GroupByColumnReferences_2432_15_757()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_ShowTables_893_7_490()
 {
    if (jj_scan_token(K_IN)) return true;
    return false;
  }

  private boolean jj_3_81()
 {
    if (jj_3R_SimpleExpressionList_3079_5_153()) return true;
    return false;
  }

  private boolean jj_3R_OracleHierarchicalQueryClause_2396_38_755()
 {
    if (jj_scan_token(K_NOCYCLE)) return true;
    return false;
  }

  private boolean jj_3R_ShowTables_892_7_489()
 {
    if (jj_scan_token(K_FROM)) return true;
    return false;
  }

  private boolean jj_3R_AlterSequence_5501_3_118()
 {
    if (jj_scan_token(K_ALTER)) return true;
    if (jj_scan_token(K_SEQUENCE)) return true;
    if (jj_3R_Sequence_5387_5_269()) return true;
    if (jj_3R_SequenceParameters_5402_1_270()) return true;
    return false;
  }

  private boolean jj_3_80()
 {
    if (jj_scan_token(287)) return true;
    if (jj_3R_SimpleExpressionList_3079_5_153()) return true;
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_OracleHierarchicalQueryClause_2393_38_754()
 {
    if (jj_scan_token(K_NOCYCLE)) return true;
    return false;
  }

  private boolean jj_3R_ShowTables_891_5_291()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ShowTables_892_7_489()) {
    jj_scanpos = xsp;
    if (jj_3R_ShowTables_893_7_490()) return true;
    }
    if (jj_3R_RelObjectNameExt_1476_5_169()) return true;
    return false;
  }

  private boolean jj_3R_ShowTables_888_5_290()
 {
    if (jj_scan_token(K_FULL)) return true;
    return false;
  }

  private boolean jj_3_79()
 {
    if (jj_scan_token(287)) return true;
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_ShowTables_887_5_289()
 {
    if (jj_scan_token(K_EXTENDED)) return true;
    return false;
  }

  private boolean jj_3R_FullTextSearch_3957_5_213()
 {
    if (jj_scan_token(K_MATCH)) return true;
    if (jj_scan_token(287)) return true;
    if (jj_3R_Column_1396_5_123()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_FullTextSearch_3957_62_404()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(288)) return true;
    if (jj_scan_token(K_AGAINST)) return true;
    if (jj_scan_token(287)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    xsp = jj_scanpos;
    if (jj_3R_FullTextSearch_3960_13_405()) jj_scanpos = xsp;
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_WhenThenSearchCondition_3862_97_642()
 {
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_ShowTables_886_3_120()
 {
    if (jj_scan_token(K_SHOW)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ShowTables_887_5_289()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_ShowTables_888_5_290()) jj_scanpos = xsp;
    if (jj_scan_token(K_TABLES)) return true;
    xsp = jj_scanpos;
    if (jj_3R_ShowTables_891_5_291()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_ShowTables_897_5_292()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_GroupByColumnReferences_2416_5_722()
 {
    if (jj_scan_token(K_GROUP)) return true;
    if (jj_scan_token(K_BY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_79()) {
    jj_scanpos = xsp;
    if (jj_3_80()) {
    jj_scanpos = xsp;
    if (jj_3_81()) {
    jj_scanpos = xsp;
    if (jj_3R_GroupByColumnReferences_2427_9_748()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_OracleHierarchicalQueryClause_2401_19_756()
 {
    if (jj_scan_token(K_START)) return true;
    if (jj_scan_token(K_WITH)) return true;
    if (jj_3R_AndExpression_2771_5_595()) return true;
    return false;
  }

  private boolean jj_3R_CreateSequence_5486_3_113()
 {
    if (jj_scan_token(K_CREATE)) return true;
    if (jj_scan_token(K_SEQUENCE)) return true;
    if (jj_3R_Sequence_5387_5_269()) return true;
    if (jj_3R_SequenceParameters_5402_1_270()) return true;
    return false;
  }

  private boolean jj_3R_OracleHierarchicalQueryClause_2396_17_747()
 {
    if (jj_scan_token(K_CONNECT)) return true;
    if (jj_scan_token(K_BY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_OracleHierarchicalQueryClause_2396_38_755()) jj_scanpos = xsp;
    if (jj_3R_AndExpression_2771_5_595()) return true;
    xsp = jj_scanpos;
    if (jj_3R_OracleHierarchicalQueryClause_2401_19_756()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_Execute_3939_9_228()
 {
    if (jj_scan_token(287)) return true;
    return false;
  }

  private boolean jj_3_158()
 {
    if (jj_3R_SimpleExpressionList_3079_5_153()) return true;
    return false;
  }

  private boolean jj_3R_ShowColumns_870_5_119()
 {
    if (jj_scan_token(K_SHOW)) return true;
    if (jj_scan_token(K_COLUMNS)) return true;
    if (jj_scan_token(K_FROM)) return true;
    if (jj_3R_RelObjectNameExt_1476_5_169()) return true;
    return false;
  }

  private boolean jj_3R_OracleHierarchicalQueryClause_2392_17_746()
 {
    if (jj_scan_token(K_START)) return true;
    if (jj_scan_token(K_WITH)) return true;
    if (jj_3R_AndExpression_2771_5_595()) return true;
    if (jj_scan_token(K_CONNECT)) return true;
    if (jj_scan_token(K_BY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_OracleHierarchicalQueryClause_2393_38_754()) jj_scanpos = xsp;
    if (jj_3R_AndExpression_2771_5_595()) return true;
    return false;
  }

  private boolean jj_3R_SequenceParameters_5471_6_613()
 {
    if (jj_scan_token(K_GLOBAL)) return true;
    return false;
  }

  private boolean jj_3_159()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_157()) {
    jj_scanpos = xsp;
    if (jj_3_158()) {
    jj_scanpos = xsp;
    if (jj_3R_Execute_3939_9_228()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_157()
 {
    if (jj_3R_VariableExpression_3909_5_227()) return true;
    return false;
  }

  private boolean jj_3R_SequenceParameters_5470_5_612()
 {
    if (jj_scan_token(K_SESSION)) return true;
    return false;
  }

  private boolean jj_3R_CaseWhenExpression_3841_98_594()
 {
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_SequenceParameters_5470_4_563()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SequenceParameters_5470_5_612()) {
    jj_scanpos = xsp;
    if (jj_3R_SequenceParameters_5471_6_613()) return true;
    }
    return false;
  }

  private boolean jj_3R_SequenceParameters_5467_6_611()
 {
    if (jj_scan_token(K_NOKEEP)) return true;
    return false;
  }

  private boolean jj_3R_SequenceParameters_5466_5_610()
 {
    if (jj_scan_token(K_KEEP)) return true;
    return false;
  }

  private boolean jj_3R_SequenceParameters_5466_4_562()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SequenceParameters_5466_5_610()) {
    jj_scanpos = xsp;
    if (jj_3R_SequenceParameters_5467_6_611()) return true;
    }
    return false;
  }

  private boolean jj_3R_SequenceParameters_5463_6_609()
 {
    if (jj_scan_token(K_NOORDER)) return true;
    return false;
  }

  private boolean jj_3R_SequenceParameters_5462_5_608()
 {
    if (jj_scan_token(K_ORDER)) return true;
    return false;
  }

  private boolean jj_3R_OracleHierarchicalQueryClause_2391_5_721()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_OracleHierarchicalQueryClause_2392_17_746()) {
    jj_scanpos = xsp;
    if (jj_3R_OracleHierarchicalQueryClause_2396_17_747()) return true;
    }
    return false;
  }

  private boolean jj_3R_SequenceParameters_5462_4_561()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SequenceParameters_5462_5_608()) {
    jj_scanpos = xsp;
    if (jj_3R_SequenceParameters_5463_6_609()) return true;
    }
    return false;
  }

  private boolean jj_3R_SequenceParameters_5454_5_607()
 {
    if (jj_scan_token(K_CACHE)) return true;
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_WhereClause_2381_5_720()
 {
    if (jj_scan_token(K_WHERE)) return true;
    if (jj_3R_Expression_2720_5_226()) return true;
    return false;
  }

  private boolean jj_3R_SequenceParameters_5449_5_606()
 {
    if (jj_scan_token(K_NOCACHE)) return true;
    return false;
  }

  private boolean jj_3R_SequenceParameters_5449_4_560()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SequenceParameters_5449_5_606()) {
    jj_scanpos = xsp;
    if (jj_3R_SequenceParameters_5454_5_607()) return true;
    }
    return false;
  }

  private boolean jj_3R_SequenceParameters_5446_6_605()
 {
    if (jj_scan_token(K_CYCLE)) return true;
    return false;
  }

  private boolean jj_3R_SequenceParameters_5445_5_604()
 {
    if (jj_scan_token(K_NOCYCLE)) return true;
    return false;
  }

  private boolean jj_3R_SequenceParameters_5445_4_559()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SequenceParameters_5445_5_604()) {
    jj_scanpos = xsp;
    if (jj_3R_SequenceParameters_5446_6_605()) return true;
    }
    return false;
  }

  private boolean jj_3R_VariableExpression_3909_5_227()
 {
    if (jj_3R_UserVariable_3577_5_196()) return true;
    if (jj_scan_token(289)) return true;
    return false;
  }

  private boolean jj_3R_SequenceParameters_5437_6_603()
 {
    if (jj_scan_token(K_MINVALUE)) return true;
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_KSQLWindowClause_2360_9_745()
 {
    if (jj_scan_token(K_TUMBLING)) return true;
    if (jj_scan_token(287)) return true;
    if (jj_scan_token(K_SIZE)) return true;
    if (jj_scan_token(S_LONG)) return true;
    if (jj_scan_token(S_IDENTIFIER)) return true;
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_SequenceParameters_5432_5_602()
 {
    if (jj_scan_token(K_NOMINVALUE)) return true;
    return false;
  }

  private boolean jj_3R_SequenceParameters_5432_4_558()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SequenceParameters_5432_5_602()) {
    jj_scanpos = xsp;
    if (jj_3R_SequenceParameters_5437_6_603()) return true;
    }
    return false;
  }

  private boolean jj_3R_KSQLWindowClause_2356_9_744()
 {
    if (jj_scan_token(K_SESSION)) return true;
    if (jj_scan_token(287)) return true;
    if (jj_scan_token(S_LONG)) return true;
    if (jj_scan_token(S_IDENTIFIER)) return true;
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_RowConstructor_3891_7_586()
 {
    if (jj_scan_token(K_ROW)) return true;
    return false;
  }

  private boolean jj_3R_RowConstructor_3891_5_523()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_RowConstructor_3891_7_586()) jj_scanpos = xsp;
    if (jj_scan_token(287)) return true;
    if (jj_3R_SimpleExpressionList_3079_5_153()) return true;
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_IntervalExpression_3659_237_410()
 {
    if (jj_3R_Column_1396_5_123()) return true;
    return false;
  }

  private boolean jj_3R_SequenceParameters_5424_6_601()
 {
    if (jj_scan_token(K_MAXVALUE)) return true;
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_KSQLWindowClause_2350_9_743()
 {
    if (jj_scan_token(K_HOPPING)) return true;
    if (jj_scan_token(287)) return true;
    if (jj_scan_token(K_SIZE)) return true;
    if (jj_scan_token(S_LONG)) return true;
    if (jj_scan_token(S_IDENTIFIER)) return true;
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_scan_token(K_ADVANCE)) return true;
    if (jj_scan_token(K_BY)) return true;
    if (jj_scan_token(S_LONG)) return true;
    if (jj_scan_token(S_IDENTIFIER)) return true;
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2273_81_702()
 {
    if (jj_scan_token(K_OUTER)) return true;
    return false;
  }

  private boolean jj_3R_SequenceParameters_5419_5_600()
 {
    if (jj_scan_token(K_NOMAXVALUE)) return true;
    return false;
  }

  private boolean jj_3R_SequenceParameters_5419_4_557()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SequenceParameters_5419_5_600()) {
    jj_scanpos = xsp;
    if (jj_3R_SequenceParameters_5424_6_601()) return true;
    }
    return false;
  }

  private boolean jj_3_155()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(287)) jj_scanpos = xsp;
    if (jj_3R_CaseWhenExpression_3838_5_208()) return true;
    xsp = jj_scanpos;
    if (jj_scan_token(288)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_KSQLWindowClause_2342_5_719()
 {
    if (jj_scan_token(K_WINDOW)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_KSQLWindowClause_2350_9_743()) {
    jj_scanpos = xsp;
    if (jj_3R_KSQLWindowClause_2356_9_744()) {
    jj_scanpos = xsp;
    if (jj_3R_KSQLWindowClause_2360_9_745()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_SequenceParameters_5411_4_556()
 {
    if (jj_scan_token(K_START)) return true;
    if (jj_scan_token(K_WITH)) return true;
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3_156()
 {
    if (jj_3R_Expression_2720_5_226()) return true;
    return false;
  }

  private boolean jj_3R_WhenThenSearchCondition_3862_15_593()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(287)) jj_scanpos = xsp;
    if (jj_3R_CaseWhenExpression_3838_5_208()) return true;
    xsp = jj_scanpos;
    if (jj_3R_WhenThenSearchCondition_3862_97_642()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_WindowOffset_3785_91_802()
 {
    if (jj_scan_token(K_FOLLOWING)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2284_57_578()
 {
    if (jj_scan_token(K_APPLY)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2283_55_628()
 {
    if (jj_scan_token(K_OUTER)) return true;
    return false;
  }

  private boolean jj_3R_SequenceParameters_5403_4_555()
 {
    if (jj_scan_token(K_INCREMENT)) return true;
    if (jj_scan_token(K_BY)) return true;
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_SequenceParameters_5403_4_477()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SequenceParameters_5403_4_555()) {
    jj_scanpos = xsp;
    if (jj_3R_SequenceParameters_5411_4_556()) {
    jj_scanpos = xsp;
    if (jj_3R_SequenceParameters_5419_4_557()) {
    jj_scanpos = xsp;
    if (jj_3R_SequenceParameters_5432_4_558()) {
    jj_scanpos = xsp;
    if (jj_3R_SequenceParameters_5445_4_559()) {
    jj_scanpos = xsp;
    if (jj_3R_SequenceParameters_5449_4_560()) {
    jj_scanpos = xsp;
    if (jj_3R_SequenceParameters_5462_4_561()) {
    jj_scanpos = xsp;
    if (jj_3R_SequenceParameters_5466_4_562()) {
    jj_scanpos = xsp;
    if (jj_3R_SequenceParameters_5470_4_563()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_153()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(287)) jj_scanpos = xsp;
    if (jj_3R_CaseWhenExpression_3838_5_208()) return true;
    xsp = jj_scanpos;
    if (jj_scan_token(288)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_SequenceParameters_5402_1_270()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_SequenceParameters_5403_4_477()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_WhenThenSearchCondition_3861_5_532()
 {
    if (jj_scan_token(K_WHEN)) return true;
    if (jj_3R_Expression_2720_5_226()) return true;
    if (jj_scan_token(K_THEN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_WhenThenSearchCondition_3862_15_593()) {
    jj_scanpos = xsp;
    if (jj_3_156()) return true;
    }
    return false;
  }

  private boolean jj_3R_WindowOffset_3776_89_800()
 {
    if (jj_scan_token(K_FOLLOWING)) return true;
    return false;
  }

  private boolean jj_3_145()
 {
    if (jj_3R_Function_4002_5_192()) return true;
    return false;
  }

  private boolean jj_3R_JoinWindow_2316_11_791()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_scan_token(S_LONG)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(281)) {
    jj_scanpos = xsp;
    if (jj_scan_token(55)) return true;
    }
    return false;
  }

  private boolean jj_3_154()
 {
    if (jj_3R_Condition_2809_5_176()) return true;
    return false;
  }

  private boolean jj_3R_CaseWhenExpression_3841_16_537()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(287)) jj_scanpos = xsp;
    if (jj_3R_CaseWhenExpression_3838_5_208()) return true;
    xsp = jj_scanpos;
    if (jj_3R_CaseWhenExpression_3841_98_594()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_Sequence_5387_5_269()
 {
    if (jj_3R_RelObjectNameList_1383_5_262()) return true;
    return false;
  }

  private boolean jj_3R_JoinWindow_2315_5_784()
 {
    if (jj_scan_token(S_LONG)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(281)) {
    jj_scanpos = xsp;
    if (jj_scan_token(55)) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_JoinWindow_2316_11_791()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2273_46_701()
 {
    if (jj_scan_token(K_SEMI)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2273_46_661()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JoinerExpression_2273_46_701()) {
    jj_scanpos = xsp;
    if (jj_3R_JoinerExpression_2273_81_702()) return true;
    }
    return false;
  }

  private boolean jj_3R_IntervalExpression_3659_195_409()
 {
    if (jj_3R_Function_4002_5_192()) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2294_18_777()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_Column_1396_5_123()) return true;
    return false;
  }

  private boolean jj_3R_CaseWhenExpression_3840_7_401()
 {
    if (jj_3R_WhenThenSearchCondition_3861_5_532()) return true;
    return false;
  }

  private boolean jj_3R_CaseWhenExpression_3841_6_415()
 {
    if (jj_scan_token(K_ELSE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CaseWhenExpression_3841_16_537()) {
    jj_scanpos = xsp;
    if (jj_3_154()) return true;
    }
    return false;
  }

  private boolean jj_3R_JoinerExpression_2290_21_349()
 {
    if (jj_scan_token(K_WITHIN)) return true;
    if (jj_scan_token(287)) return true;
    if (jj_3R_JoinWindow_2315_5_784()) return true;
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3_152()
 {
    if (jj_3R_Condition_2809_5_176()) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2290_19_167()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JoinerExpression_2290_21_349()) jj_scanpos = xsp;
    if (jj_scan_token(K_ON)) return true;
    if (jj_3R_Expression_2720_5_226()) return true;
    return false;
  }

  private boolean jj_3R_CaseWhenExpression_3838_5_208()
 {
    if (jj_scan_token(K_CASE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_152()) jj_scanpos = xsp;
    if (jj_3R_CaseWhenExpression_3840_7_401()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_CaseWhenExpression_3840_7_401()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_CaseWhenExpression_3841_6_415()) jj_scanpos = xsp;
    if (jj_scan_token(K_END)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2283_24_576()
 {
    if (jj_scan_token(K_COMMA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JoinerExpression_2283_55_628()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_148()
 {
    if (jj_3R_windowFun_3713_5_224()) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2293_9_168()
 {
    if (jj_scan_token(K_USING)) return true;
    if (jj_scan_token(287)) return true;
    if (jj_3R_Column_1396_5_123()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_JoinerExpression_2294_18_777()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_Set_719_47_293()
 {
    if (jj_scan_token(289)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2284_14_577()
 {
    if (jj_scan_token(K_STRAIGHT)) return true;
    return false;
  }

  private boolean jj_3_72()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JoinerExpression_2290_19_167()) {
    jj_scanpos = xsp;
    if (jj_3R_JoinerExpression_2293_9_168()) return true;
    }
    return false;
  }

  private boolean jj_3R_JoinerExpression_2276_16_664()
 {
    if (jj_scan_token(K_OUTER)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2275_16_663()
 {
    if (jj_scan_token(K_FULL)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2280_11_627()
 {
    if (jj_scan_token(K_OUTER)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2274_16_662()
 {
    if (jj_scan_token(K_RIGHT)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2279_11_626()
 {
    if (jj_scan_token(K_CROSS)) return true;
    return false;
  }

  private boolean jj_3R_CastExpression_3820_5_215()
 {
    if (jj_scan_token(K_CAST)) return true;
    if (jj_scan_token(287)) return true;
    if (jj_3R_SimpleExpression_3242_5_122()) return true;
    if (jj_scan_token(K_AS)) return true;
    if (jj_3R_ColDataType_4521_5_470()) return true;
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2278_11_625()
 {
    if (jj_scan_token(K_NATURAL)) return true;
    return false;
  }

  private boolean jj_3_20()
 {
    if (jj_scan_token(K_DATETIMELITERAL)) return true;
    if (jj_scan_token(K_ZONE)) return true;
    return false;
  }

  private boolean jj_3R_IntervalExpression_3659_165_408()
 {
    if (jj_3R_JdbcNamedParameter_3565_5_209()) return true;
    return false;
  }

  private boolean jj_3R_WindowElement_3752_71_797()
 {
    if (jj_scan_token(K_RANGE)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2277_11_624()
 {
    if (jj_scan_token(K_INNER)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2274_14_623()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JoinerExpression_2274_16_662()) {
    jj_scanpos = xsp;
    if (jj_3R_JoinerExpression_2275_16_663()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_JoinerExpression_2276_16_664()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2273_11_622()
 {
    if (jj_scan_token(K_LEFT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JoinerExpression_2273_46_661()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2273_11_575()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JoinerExpression_2273_11_622()) {
    jj_scanpos = xsp;
    if (jj_3R_JoinerExpression_2274_14_623()) {
    jj_scanpos = xsp;
    if (jj_3R_JoinerExpression_2277_11_624()) {
    jj_scanpos = xsp;
    if (jj_3R_JoinerExpression_2278_11_625()) {
    jj_scanpos = xsp;
    if (jj_3R_JoinerExpression_2279_11_626()) {
    jj_scanpos = xsp;
    if (jj_3R_JoinerExpression_2280_11_627()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_WindowOffset_3775_40_799()
 {
    if (jj_scan_token(K_PRECEDING)) return true;
    return false;
  }

  private boolean jj_3R_WindowOffset_3785_26_801()
 {
    if (jj_scan_token(K_PRECEDING)) return true;
    return false;
  }

  private boolean jj_3_19()
 {
    if (jj_3R_SimpleExpression_3242_5_122()) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2270_5_498()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JoinerExpression_2273_11_575()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(121)) {
    jj_scanpos = xsp;
    if (jj_3R_JoinerExpression_2283_24_576()) {
    jj_scanpos = xsp;
    if (jj_3R_JoinerExpression_2284_14_577()) {
    jj_scanpos = xsp;
    if (jj_3R_JoinerExpression_2284_57_578()) return true;
    }
    }
    }
    if (jj_3R_FromItem_2109_5_158()) return true;
    xsp = jj_scanpos;
    if (jj_3_72()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_Set_719_19_121()
 {
    if (jj_3R_RelObjectNameExt_1476_5_169()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Set_719_47_293()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_ExtractExpression_3801_5_211()
 {
    if (jj_scan_token(K_EXTRACT)) return true;
    if (jj_scan_token(287)) return true;
    if (jj_3R_RelObjectName_1446_5_156()) return true;
    if (jj_scan_token(K_FROM)) return true;
    if (jj_3R_SimpleExpression_3242_5_122()) return true;
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3_17()
 {
    if (jj_scan_token(K_DATETIMELITERAL)) return true;
    if (jj_scan_token(K_ZONE)) return true;
    return false;
  }

  private boolean jj_3_151()
 {
    if (jj_3R_SimpleExpression_3242_5_122()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_WindowOffset_3785_26_801()) {
    jj_scanpos = xsp;
    if (jj_3R_WindowOffset_3785_91_802()) return true;
    }
    return false;
  }

  private boolean jj_3_150()
 {
    if (jj_scan_token(K_CURRENT)) return true;
    if (jj_scan_token(K_ROW)) return true;
    return false;
  }

  private boolean jj_3R_SubJoinsList_2254_6_583()
 {
    if (jj_3R_JoinerExpression_2270_5_498()) return true;
    return false;
  }

  private boolean jj_3_18()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_17()) {
    jj_scanpos = xsp;
    if (jj_3R_Set_719_19_121()) return true;
    }
    if (jj_3R_SimpleExpression_3242_5_122()) return true;
    return false;
  }

  private boolean jj_3R_SubJoinsList_2254_5_513()
 {
    Token xsp;
    if (jj_3R_SubJoinsList_2254_6_583()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_SubJoinsList_2254_6_583()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_WindowOffset_3774_17_414()
 {
    if (jj_scan_token(K_UNBOUNDED)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_WindowOffset_3775_40_799()) {
    jj_scanpos = xsp;
    if (jj_3R_WindowOffset_3776_89_800()) return true;
    }
    return false;
  }

  private boolean jj_3_16()
 {
    if (jj_scan_token(K_DATETIMELITERAL)) return true;
    if (jj_scan_token(K_ZONE)) return true;
    return false;
  }

  private boolean jj_3R_JoinsList_2243_6_320()
 {
    if (jj_3R_JoinerExpression_2270_5_498()) return true;
    return false;
  }

  private boolean jj_3R_JoinsList_2243_5_132()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_JoinsList_2243_6_320()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_15()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(132)) {
    jj_scanpos = xsp;
    if (jj_scan_token(206)) return true;
    }
    return false;
  }

  private boolean jj_3R_WindowOffset_3773_5_225()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_WindowOffset_3774_17_414()) {
    jj_scanpos = xsp;
    if (jj_3_150()) {
    jj_scanpos = xsp;
    if (jj_3_151()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_KeepExpression_3696_79_672()
 {
    if (jj_scan_token(K_LAST)) return true;
    return false;
  }

  private boolean jj_3_144()
 {
    if (jj_3R_SimpleJdbcParameter_2489_5_222()) return true;
    return false;
  }

  private boolean jj_3R_SubJoin_2228_5_344()
 {
    if (jj_3R_SubJoinsList_2254_5_513()) return true;
    return false;
  }

  private boolean jj_3_149()
 {
    if (jj_3R_WindowOffset_3773_5_225()) return true;
    return false;
  }

  private boolean jj_3R_WindowElement_3753_7_798()
 {
    if (jj_scan_token(K_BETWEEN)) return true;
    if (jj_3R_WindowOffset_3773_5_225()) return true;
    if (jj_scan_token(K_AND)) return true;
    if (jj_3R_WindowOffset_3773_5_225()) return true;
    return false;
  }

  private boolean jj_3R_IntervalExpression_3659_101_407()
 {
    if (jj_3R_SimpleJdbcParameter_2489_5_222()) return true;
    return false;
  }

  private boolean jj_3R_WindowElement_3752_6_796()
 {
    if (jj_scan_token(K_ROWS)) return true;
    return false;
  }

  private boolean jj_3R_WindowElement_3752_5_794()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_WindowElement_3752_6_796()) {
    jj_scanpos = xsp;
    if (jj_3R_WindowElement_3752_71_797()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_WindowElement_3753_7_798()) {
    jj_scanpos = xsp;
    if (jj_3_149()) return true;
    }
    return false;
  }

  private boolean jj_3R_LateralSubSelect_2214_5_581()
 {
    if (jj_scan_token(K_LATERAL)) return true;
    if (jj_scan_token(287)) return true;
    if (jj_3R_SubSelect_4142_5_190()) return true;
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_AnalyticExpression_3738_11_400()
 {
    if (jj_3R_windowFun_3713_5_224()) return true;
    return false;
  }

  private boolean jj_3R_ValuesList_2197_15_585()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_RelObjectName_1446_5_156()) return true;
    return false;
  }

  private boolean jj_3R_AnalyticExpression_3737_6_399()
 {
    if (jj_scan_token(K_FILTER)) return true;
    if (jj_scan_token(287)) return true;
    if (jj_scan_token(K_WHERE)) return true;
    if (jj_3R_Expression_2720_5_226()) return true;
    if (jj_scan_token(288)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_148()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_147()
 {
    if (jj_3R_ComplexExpressionList_3093_5_223()) return true;
    return false;
  }

  private boolean jj_3R_AnalyticExpression_3737_5_206()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AnalyticExpression_3737_6_399()) {
    jj_scanpos = xsp;
    if (jj_3R_AnalyticExpression_3738_11_400()) return true;
    }
    return false;
  }

  private boolean jj_3R_ValuesList_2195_11_518()
 {
    if (jj_scan_token(287)) return true;
    if (jj_3R_RelObjectName_1446_5_156()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_ValuesList_2197_15_585()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_ValuesList_2186_18_584()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_SimpleExpression_3242_5_122()) return true;
    return false;
  }

  private boolean jj_3R_KeepExpression_3696_42_671()
 {
    if (jj_scan_token(K_FIRST)) return true;
    return false;
  }

  private boolean jj_3R_FromItem_2145_57_582()
 {
    if (jj_3R_Pivot_2011_5_630()) return true;
    return false;
  }

  private boolean jj_3R_ValuesList_2193_7_348()
 {
    if (jj_3R_Alias_1852_5_240()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ValuesList_2195_11_518()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_windowFun_3719_15_793()
 {
    if (jj_scan_token(287)) return true;
    if (jj_3R_ComplexExpressionList_3093_5_223()) return true;
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_ValuesList_2189_10_517()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_SimpleExpression_3242_5_122()) return true;
    return false;
  }

  private boolean jj_3R_windowFun_3718_14_792()
 {
    if (jj_3R_ComplexExpressionList_3093_5_223()) return true;
    return false;
  }

  private boolean jj_3R_windowFun_3722_10_787()
 {
    if (jj_3R_WindowElement_3752_5_794()) return true;
    return false;
  }

  private boolean jj_3R_ValuesList_2183_14_516()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_scan_token(287)) return true;
    if (jj_3R_SimpleExpression_3242_5_122()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_ValuesList_2186_18_584()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_windowFun_3721_10_786()
 {
    if (jj_3R_OrderByElements_2459_5_418()) return true;
    return false;
  }

  private boolean jj_3R_ValuesList_2181_14_166()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_SimpleExpression_3242_5_122()) return true;
    return false;
  }

  private boolean jj_3_71()
 {
    if (jj_3R_SimpleExpression_3242_5_122()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_ValuesList_2189_10_517()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_windowFun_3717_10_785()
 {
    if (jj_scan_token(K_PARTITION)) return true;
    if (jj_scan_token(K_BY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_windowFun_3718_14_792()) {
    jj_scanpos = xsp;
    if (jj_3R_windowFun_3719_15_793()) return true;
    }
    return false;
  }

  private boolean jj_3R_windowFun_3714_11_413()
 {
    if (jj_scan_token(K_WITHIN)) return true;
    if (jj_scan_token(K_GROUP)) return true;
    return false;
  }

  private boolean jj_3_70()
 {
    if (jj_scan_token(287)) return true;
    if (jj_3R_SimpleExpression_3242_5_122()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_ValuesList_2181_14_166()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(288)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_ValuesList_2183_14_516()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_windowFun_3713_6_412()
 {
    if (jj_scan_token(K_OVER)) return true;
    return false;
  }

  private boolean jj_3R_ValuesList_2178_5_165()
 {
    if (jj_scan_token(287)) return true;
    if (jj_scan_token(K_VALUES)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_70()) {
    jj_scanpos = xsp;
    if (jj_3_71()) return true;
    }
    if (jj_scan_token(288)) return true;
    xsp = jj_scanpos;
    if (jj_3R_ValuesList_2193_7_348()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_windowFun_3713_5_224()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_windowFun_3713_6_412()) {
    jj_scanpos = xsp;
    if (jj_3R_windowFun_3714_11_413()) return true;
    }
    if (jj_scan_token(287)) return true;
    xsp = jj_scanpos;
    if (jj_3R_windowFun_3717_10_785()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_windowFun_3721_10_786()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_windowFun_3722_10_787()) jj_scanpos = xsp;
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_Wait_5240_5_749()
 {
    if (jj_scan_token(K_WAIT)) return true;
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_FromItem_2154_21_164()
 {
    if (jj_3R_SQLServerHints_1877_5_347()) return true;
    return false;
  }

  private boolean jj_3_67()
 {
    if (jj_3R_PivotXml_2039_5_162()) return true;
    return false;
  }

  private boolean jj_3R_FromItem_2145_26_512()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_67()) {
    jj_scanpos = xsp;
    if (jj_3R_FromItem_2145_57_582()) return true;
    }
    return false;
  }

  private boolean jj_3_66()
 {
    if (jj_3R_UnPivot_2068_5_160()) return true;
    return false;
  }

  private boolean jj_3R_FromItem_2149_21_163()
 {
    if (jj_3R_MySQLIndexHint_1891_9_346()) return true;
    return false;
  }

  private boolean jj_3R_KeepExpression_3696_5_239()
 {
    if (jj_scan_token(K_KEEP)) return true;
    if (jj_scan_token(287)) return true;
    if (jj_scan_token(S_IDENTIFIER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_KeepExpression_3696_42_671()) {
    jj_scanpos = xsp;
    if (jj_3R_KeepExpression_3696_79_672()) return true;
    }
    if (jj_3R_OrderByElements_2459_5_418()) return true;
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3_68()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_FromItem_2149_21_163()) {
    jj_scanpos = xsp;
    if (jj_3R_FromItem_2154_21_164()) return true;
    }
    return false;
  }

  private boolean jj_3_65()
 {
    if (jj_3R_TableFunction_4128_5_161()) return true;
    return false;
  }

  private boolean jj_3R_FromItem_2143_15_511()
 {
    if (jj_3R_Alias_1852_5_240()) return true;
    return false;
  }

  private boolean jj_3R_FromItem_2141_17_510()
 {
    if (jj_3R_LateralSubSelect_2214_5_581()) return true;
    return false;
  }

  private boolean jj_3R_FromItem_2139_17_509()
 {
    if (jj_3R_Table_1507_5_251()) return true;
    return false;
  }

  private boolean jj_3_64()
 {
    if (jj_3R_UnPivot_2068_5_160()) return true;
    return false;
  }

  private boolean jj_3R_FromItem_2136_17_508()
 {
    if (jj_3R_TableFunction_4128_5_161()) return true;
    return false;
  }

  private boolean jj_3R_FromItem_2125_27_580()
 {
    if (jj_3R_SetOperationListWithoutIntialSelect_1726_5_629()) return true;
    return false;
  }

  private boolean jj_3R_IntervalExpressionWithoutInterval_3680_5_220()
 {
    if (jj_scan_token(K_DATE_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_FromItem_2123_25_579()
 {
    if (jj_3R_SubSelect_4142_5_190()) return true;
    return false;
  }

  private boolean jj_3R_FromItem_2119_27_159()
 {
    if (jj_3R_SubJoin_2228_5_344()) return true;
    return false;
  }

  private boolean jj_3R_IntoClause_2091_52_742()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_Table_1507_5_251()) return true;
    return false;
  }

  private boolean jj_3R_IntervalExpression_3659_19_406()
 {
    if (jj_scan_token(307)) return true;
    return false;
  }

  private boolean jj_3_63()
 {
    if (jj_3R_FromItem_2109_5_158()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_FromItem_2119_27_159()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_146()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(281)) {
    jj_scanpos = xsp;
    if (jj_scan_token(55)) return true;
    }
    return false;
  }

  private boolean jj_3R_FromItem_2114_17_507()
 {
    if (jj_scan_token(287)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_63()) {
    jj_scanpos = xsp;
    if (jj_3R_FromItem_2123_25_579()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_FromItem_2125_27_580()) jj_scanpos = xsp;
    if (jj_scan_token(288)) return true;
    xsp = jj_scanpos;
    if (jj_3_64()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_ArrayConstructor_3613_52_221()
 {
    if (jj_3R_ArrayConstructor_3612_5_217()) return true;
    return false;
  }

  private boolean jj_3_69()
 {
    if (jj_3R_ValuesList_2178_5_165()) return true;
    return false;
  }

  private boolean jj_3R_IntervalExpression_3658_1_214()
 {
    if (jj_scan_token(K_INTERVAL)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_IntervalExpression_3659_19_406()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(275)) {
    jj_scanpos = xsp;
    if (jj_scan_token(274)) {
    jj_scanpos = xsp;
    if (jj_scan_token(284)) {
    jj_scanpos = xsp;
    if (jj_3R_IntervalExpression_3659_101_407()) {
    jj_scanpos = xsp;
    if (jj_3R_IntervalExpression_3659_165_408()) {
    jj_scanpos = xsp;
    if (jj_3R_IntervalExpression_3659_195_409()) {
    jj_scanpos = xsp;
    if (jj_3R_IntervalExpression_3659_237_410()) return true;
    }
    }
    }
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3_146()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_ArrayConstructor_3615_42_713()
 {
    if (jj_3R_ArrayConstructor_3612_5_217()) return true;
    return false;
  }

  private boolean jj_3R_FromItem_2112_9_343()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_FromItem_2114_17_507()) {
    jj_scanpos = xsp;
    if (jj_3R_FromItem_2136_17_508()) {
    jj_scanpos = xsp;
    if (jj_3R_FromItem_2139_17_509()) {
    jj_scanpos = xsp;
    if (jj_3R_FromItem_2141_17_510()) return true;
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_FromItem_2143_15_511()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_66()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_FromItem_2145_26_512()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_68()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_FromItem_2110_9_342()
 {
    if (jj_3R_ValuesList_2178_5_165()) return true;
    return false;
  }

  private boolean jj_3R_JsonExpression_3642_9_536()
 {
    if (jj_scan_token(328)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_JsonExpression_3641_9_535()
 {
    if (jj_scan_token(327)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_JsonExpression_3640_9_534()
 {
    if (jj_scan_token(326)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(284)) {
    jj_scanpos = xsp;
    if (jj_scan_token(275)) return true;
    }
    return false;
  }

  private boolean jj_3R_FromItem_2109_5_158()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_FromItem_2110_9_342()) {
    jj_scanpos = xsp;
    if (jj_3R_FromItem_2112_9_343()) return true;
    }
    return false;
  }

  private boolean jj_3R_JsonExpression_3639_9_533()
 {
    if (jj_scan_token(325)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(284)) {
    jj_scanpos = xsp;
    if (jj_scan_token(275)) return true;
    }
    return false;
  }

  private boolean jj_3R_JsonExpression_3639_9_403()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonExpression_3639_9_533()) {
    jj_scanpos = xsp;
    if (jj_3R_JsonExpression_3640_9_534()) {
    jj_scanpos = xsp;
    if (jj_3R_JsonExpression_3641_9_535()) {
    jj_scanpos = xsp;
    if (jj_3R_JsonExpression_3642_9_536()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_AlterSession_5172_5_109()
 {
    if (jj_scan_token(K_ALTER)) return true;
    if (jj_scan_token(K_SESSION)) return true;
    return false;
  }

  private boolean jj_3_14()
 {
    if (jj_3R_ShowTables_886_3_120()) return true;
    return false;
  }

  private boolean jj_3R_JsonExpression_3631_7_402()
 {
    if (jj_scan_token(323)) return true;
    if (jj_3R_ColDataType_4521_5_470()) return true;
    return false;
  }

  private boolean jj_3_13()
 {
    if (jj_3R_ShowColumns_870_5_119()) return true;
    return false;
  }

  private boolean jj_3R_JsonExpression_3630_5_212()
 {
    if (jj_3R_Column_1396_5_123()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_JsonExpression_3631_7_402()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_JsonExpression_3639_9_403()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_JsonExpression_3639_9_403()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_IntoClause_2091_5_718()
 {
    if (jj_scan_token(K_INTO)) return true;
    if (jj_3R_Table_1507_5_251()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_IntoClause_2091_52_742()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_142()
 {
    if (jj_3R_SimpleExpression_3242_5_122()) return true;
    return false;
  }

  private boolean jj_3R_ArrayConstructor_3615_10_677()
 {
    if (jj_scan_token(K_COMMA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_142()) {
    jj_scanpos = xsp;
    if (jj_3R_ArrayConstructor_3615_42_713()) return true;
    }
    return false;
  }

  private boolean jj_3_141()
 {
    if (jj_3R_SimpleExpression_3242_5_122()) return true;
    return false;
  }

  private boolean jj_3R_AlterTable_5155_5_108()
 {
    if (jj_scan_token(K_ALTER)) return true;
    if (jj_scan_token(K_TABLE)) return true;
    return false;
  }

  private boolean jj_3_143()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_141()) {
    jj_scanpos = xsp;
    if (jj_3R_ArrayConstructor_3613_52_221()) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_ArrayConstructor_3615_10_677()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_12()
 {
    if (jj_3R_AlterSequence_5501_3_118()) return true;
    return false;
  }

  private boolean jj_3_11()
 {
    if (jj_3R_AlterView_4601_5_117()) return true;
    return false;
  }

  private boolean jj_3R_ArrayConstructor_3612_5_217()
 {
    if (jj_scan_token(317)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_143()) jj_scanpos = xsp;
    if (jj_scan_token(318)) return true;
    return false;
  }

  private boolean jj_3_10()
 {
    if (jj_3R_CreateView_4554_5_116()) return true;
    return false;
  }

  private boolean jj_3R_UnPivot_2069_9_514()
 {
    if (jj_scan_token(K_INCLUDE)) return true;
    if (jj_scan_token(K_NULLS)) return true;
    return false;
  }

  private boolean jj_3_9()
 {
    if (jj_3R_CreateTable_4335_5_115()) return true;
    return false;
  }

  private boolean jj_3R_UnPivot_2070_7_515()
 {
    if (jj_scan_token(K_EXCLUDE)) return true;
    if (jj_scan_token(K_NULLS)) return true;
    return false;
  }

  private boolean jj_3R_UnPivot_2069_7_345()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_UnPivot_2069_9_514()) {
    jj_scanpos = xsp;
    if (jj_3R_UnPivot_2070_7_515()) return true;
    }
    return false;
  }

  private boolean jj_3_8()
 {
    if (jj_3R_CreateSynonym_5545_3_114()) return true;
    return false;
  }

  private boolean jj_3R_UnPivot_2068_5_160()
 {
    if (jj_scan_token(K_UNPIVOT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_UnPivot_2069_7_345()) jj_scanpos = xsp;
    if (jj_scan_token(287)) return true;
    if (jj_3R_Column_1396_5_123()) return true;
    if (jj_scan_token(K_FOR)) return true;
    if (jj_3R_PivotForColumns_1934_5_765()) return true;
    if (jj_scan_token(K_IN)) return true;
    if (jj_scan_token(287)) return true;
    if (jj_3R_PivotSingleInItems_1960_4_157()) return true;
    if (jj_scan_token(288)) return true;
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3_7()
 {
    if (jj_3R_CreateSequence_5486_3_113()) return true;
    return false;
  }

  private boolean jj_3R_DateTimeLiteralExpression_3602_5_216()
 {
    if (jj_scan_token(K_DATETIMELITERAL)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3_6()
 {
    if (jj_3R_CreateSchema_4261_5_112()) return true;
    return false;
  }

  private boolean jj_3_5()
 {
    if (jj_3R_CreateIndex_4196_5_111()) return true;
    return false;
  }

  private boolean jj_3_4()
 {
    if (jj_3R_CreateFunctionStatement_5517_3_110()) return true;
    return false;
  }

  private boolean jj_3R_NumericBind_3591_5_210()
 {
    if (jj_scan_token(292)) return true;
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_PivotXml_2046_9_770()
 {
    if (jj_3R_PivotMultiInItems_1996_4_781()) return true;
    return false;
  }

  private boolean jj_3_62()
 {
    if (jj_3R_PivotSingleInItems_1960_4_157()) return true;
    return false;
  }

  private boolean jj_3R_UserVariable_3577_12_395()
 {
    if (jj_scan_token(298)) return true;
    return false;
  }

  private boolean jj_3R_PivotXml_2044_9_769()
 {
    if (jj_3R_SelectBody_1553_5_288()) return true;
    return false;
  }

  private boolean jj_3_61()
 {
    if (jj_scan_token(K_ANY)) return true;
    return false;
  }

  private boolean jj_3R_UserVariable_3579_7_396()
 {
    if (jj_scan_token(291)) return true;
    if (jj_3R_RelObjectNameExt2_1494_5_135()) return true;
    return false;
  }

  private boolean jj_3_3()
 {
    if (jj_3R_AlterSession_5172_5_109()) return true;
    return false;
  }

  private boolean jj_3_2()
 {
    if (jj_3R_AlterTable_5155_5_108()) return true;
    return false;
  }

  private boolean jj_3R_UserVariable_3577_5_196()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(324)) {
    jj_scanpos = xsp;
    if (jj_3R_UserVariable_3577_12_395()) return true;
    }
    if (jj_3R_RelObjectNameExt2_1494_5_135()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_UserVariable_3579_7_396()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_1()
 {
    if (jj_3R_Replace_1013_5_107()) return true;
    return false;
  }

  private boolean jj_3R_PivotXml_2039_5_162()
 {
    if (jj_scan_token(K_PIVOT)) return true;
    if (jj_scan_token(K_XML)) return true;
    if (jj_scan_token(287)) return true;
    if (jj_3R_PivotFunctionItems_1949_5_768()) return true;
    if (jj_scan_token(K_FOR)) return true;
    if (jj_3R_PivotForColumns_1934_5_765()) return true;
    if (jj_scan_token(K_IN)) return true;
    if (jj_scan_token(287)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_61()) {
    jj_scanpos = xsp;
    if (jj_3R_PivotXml_2044_9_769()) {
    jj_scanpos = xsp;
    if (jj_3_62()) {
    jj_scanpos = xsp;
    if (jj_3R_PivotXml_2046_9_770()) return true;
    }
    }
    }
    if (jj_scan_token(288)) return true;
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3_202()
 {
    if (jj_scan_token(K_COLUMN)) return true;
    return false;
  }

  private boolean jj_3R_JdbcNamedParameter_3565_5_209()
 {
    if (jj_scan_token(292)) return true;
    if (jj_3R_RelObjectNameExt2_1494_5_135()) return true;
    return false;
  }

  private boolean jj_3R_Pivot_2018_7_772()
 {
    if (jj_3R_Alias_1852_5_240()) return true;
    return false;
  }

  private boolean jj_3R_NextValExpression_3554_6_218()
 {
    if (jj_scan_token(K_NEXTVAL)) return true;
    if (jj_3R_RelObjectNameList_1383_5_262()) return true;
    return false;
  }

  private boolean jj_3R_Pivot_2015_7_771()
 {
    if (jj_3R_PivotMultiInItems_1996_4_781()) return true;
    return false;
  }

  private boolean jj_3_60()
 {
    if (jj_3R_PivotSingleInItems_1960_4_157()) return true;
    return false;
  }

  private boolean jj_3R_Pivot_2011_5_630()
 {
    if (jj_scan_token(K_PIVOT)) return true;
    if (jj_scan_token(287)) return true;
    if (jj_3R_PivotFunctionItems_1949_5_768()) return true;
    if (jj_scan_token(K_FOR)) return true;
    if (jj_3R_PivotForColumns_1934_5_765()) return true;
    if (jj_scan_token(K_IN)) return true;
    if (jj_scan_token(287)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_60()) {
    jj_scanpos = xsp;
    if (jj_3R_Pivot_2015_7_771()) return true;
    }
    if (jj_scan_token(288)) return true;
    if (jj_scan_token(288)) return true;
    xsp = jj_scanpos;
    if (jj_3R_Pivot_2018_7_772()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_PivotMultiInItems_1997_5_790()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_ExpressionListItem_1983_5_789()) return true;
    return false;
  }

  private boolean jj_3R_PivotMultiInItems_1996_4_781()
 {
    if (jj_3R_ExpressionListItem_1983_5_789()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_PivotMultiInItems_1997_5_790()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3524_7_669()
 {
    if (jj_scan_token(K_AT)) return true;
    if (jj_scan_token(K_DATETIMELITERAL)) return true;
    if (jj_scan_token(K_ZONE)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_ExpressionListItem_1986_6_795()
 {
    if (jj_3R_Alias_1852_5_240()) return true;
    return false;
  }

  private boolean jj_3R_ExpressionListItem_1983_5_789()
 {
    if (jj_scan_token(287)) return true;
    if (jj_3R_SimpleExpressionList_3079_5_153()) return true;
    if (jj_scan_token(288)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ExpressionListItem_1986_6_795()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3516_7_668()
 {
    if (jj_scan_token(323)) return true;
    if (jj_3R_ColDataType_4521_5_470()) return true;
    return false;
  }

  private boolean jj_3R_PivotSelectExprItem_1973_15_506()
 {
    if (jj_3R_Alias_1852_5_240()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3514_7_667()
 {
    if (jj_3R_ArrayExpression_3396_5_703()) return true;
    return false;
  }

  private boolean jj_3_140()
 {
    if (jj_3R_IntervalExpressionWithoutInterval_3680_5_220()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3507_9_666()
 {
    if (jj_scan_token(K_COLLATE)) return true;
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3502_13_758()
 {
    if (jj_scan_token(291)) return true;
    if (jj_3R_RelObjectNameExt_1476_5_169()) return true;
    return false;
  }

  private boolean jj_3R_PivotSelectExprItem_1972_7_340()
 {
    if (jj_3R_SimpleExpression_3242_5_122()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PivotSelectExprItem_1973_15_506()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3492_19_219()
 {
    if (jj_scan_token(287)) return true;
    if (jj_3R_SimpleExpressionList_3079_5_153()) return true;
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3482_28_207()
 {
    return false;
  }

  private boolean jj_3R_PivotSingleInItems_1961_5_341()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_PivotSelectExprItem_1972_7_340()) return true;
    return false;
  }

  private boolean jj_3_124()
 {
    if (jj_3R_AnalyticExpression_3737_5_206()) return true;
    return false;
  }

  private boolean jj_3_138()
 {
    if (jj_scan_token(287)) return true;
    if (jj_3R_SubSelect_4142_5_190()) return true;
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_PivotSingleInItems_1960_4_157()
 {
    if (jj_3R_PivotSelectExprItem_1972_7_340()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_PivotSingleInItems_1961_5_341()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_125()
 {
    jj_lookingAhead = true;
    jj_semLA = getAsBoolean(Feature.allowComplexParsing);
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_PrimaryExpression_3482_28_207()) return true;
    if (jj_scan_token(287)) return true;
    if (jj_3R_ComplexExpressionList_3093_5_223()) return true;
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3_198()
 {
    if (jj_scan_token(K_ON)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(59)) {
    jj_scanpos = xsp;
    if (jj_scan_token(238)) return true;
    }
    return false;
  }

  private boolean jj_3R_PivotFunctionItems_1950_7_780()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_FunctionItem_1923_5_779()) return true;
    return false;
  }

  private boolean jj_3_139()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_125()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3492_19_219()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_PrimaryExpression_3502_13_758()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3479_11_315()
 {
    if (jj_scan_token(287)) return true;
    if (jj_3R_SubSelect_4142_5_190()) return true;
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3_197()
 {
    if (jj_scan_token(K_ON)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(59)) {
    jj_scanpos = xsp;
    if (jj_scan_token(238)) return true;
    }
    return false;
  }

  private boolean jj_3R_PivotFunctionItems_1949_5_768()
 {
    if (jj_3R_FunctionItem_1923_5_779()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_PivotFunctionItems_1950_7_780()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3477_11_314()
 {
    if (jj_scan_token(322)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    if (jj_scan_token(320)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3475_11_313()
 {
    if (jj_scan_token(321)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    if (jj_scan_token(320)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3473_11_312()
 {
    if (jj_scan_token(319)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    if (jj_scan_token(320)) return true;
    return false;
  }

  private boolean jj_3R_PivotForColumns_1936_11_778()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_Column_1396_5_123()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3471_11_311()
 {
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_PivotForColumns_1938_7_767()
 {
    if (jj_3R_Column_1396_5_123()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3469_11_310()
 {
    if (jj_3R_Column_1396_5_123()) return true;
    return false;
  }

  private boolean jj_3R_PivotForColumns_1935_9_766()
 {
    if (jj_scan_token(287)) return true;
    if (jj_3R_Column_1396_5_123()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_PivotForColumns_1936_11_778()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3_137()
 {
    if (jj_3R_NextValExpression_3554_6_218()) return true;
    return false;
  }

  private boolean jj_3_136()
 {
    if (jj_scan_token(K_ARRAY_LITERAL)) return true;
    if (jj_3R_ArrayConstructor_3612_5_217()) return true;
    return false;
  }

  private boolean jj_3R_FunctionItem_1924_15_788()
 {
    if (jj_3R_Alias_1852_5_240()) return true;
    return false;
  }

  private boolean jj_3R_PivotForColumns_1934_5_765()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PivotForColumns_1935_9_766()) {
    jj_scanpos = xsp;
    if (jj_3R_PivotForColumns_1938_7_767()) return true;
    }
    return false;
  }

  private boolean jj_3_135()
 {
    if (jj_3R_DateTimeLiteralExpression_3602_5_216()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3461_11_309()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(224)) {
    jj_scanpos = xsp;
    if (jj_scan_token(50)) return true;
    }
    return false;
  }

  private boolean jj_3_132()
 {
    if (jj_3R_Function_4002_5_192()) return true;
    return false;
  }

  private boolean jj_3_134()
 {
    if (jj_3R_CastExpression_3820_5_215()) return true;
    return false;
  }

  private boolean jj_3_131()
 {
    if (jj_3R_FullTextSearch_3957_5_213()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3456_11_308()
 {
    if (jj_scan_token(S_HEX)) return true;
    return false;
  }

  private boolean jj_3_196()
 {
    if (jj_scan_token(K_ON)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(59)) {
    jj_scanpos = xsp;
    if (jj_scan_token(238)) return true;
    }
    return false;
  }

  private boolean jj_3R_Alias_1858_72_665()
 {
    if (jj_3R_ColDataType_4521_5_470()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3454_11_307()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3_195()
 {
    if (jj_scan_token(K_ON)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(59)) {
    jj_scanpos = xsp;
    if (jj_scan_token(238)) return true;
    }
    return false;
  }

  private boolean jj_3R_FunctionItem_1923_5_779()
 {
    if (jj_3R_Function_4002_5_192()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_FunctionItem_1924_15_788()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_130()
 {
    if (jj_3R_JsonExpression_3630_5_212()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3452_11_306()
 {
    if (jj_scan_token(S_DOUBLE)) return true;
    return false;
  }

  private boolean jj_3_133()
 {
    if (jj_3R_IntervalExpression_3658_1_214()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3448_11_305()
 {
    if (jj_3R_Function_4002_5_192()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_124()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3446_11_304()
 {
    if (jj_3R_FullTextSearch_3957_5_213()) return true;
    return false;
  }

  private boolean jj_3R_Identifier_1911_9_773()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(281)) {
    jj_scanpos = xsp;
    if (jj_scan_token(285)) return true;
    }
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3442_11_303()
 {
    if (jj_3R_JsonExpression_3630_5_212()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3421_31_494()
 {
    if (jj_scan_token(294)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3440_11_302()
 {
    if (jj_3R_XMLSerializeExpr_4072_5_496()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3438_11_301()
 {
    if (jj_3R_MySQLGroupConcat_4096_5_495()) return true;
    return false;
  }

  private boolean jj_3_129()
 {
    if (jj_3R_ExtractExpression_3801_5_211()) return true;
    return false;
  }

  private boolean jj_3_193()
 {
    if (jj_scan_token(K_COLUMN)) return true;
    return false;
  }

  private boolean jj_3_128()
 {
    if (jj_3R_NumericBind_3591_5_210()) return true;
    return false;
  }

  private boolean jj_3R_SQLServerHints_1878_31_776()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_SQLServerHint_1868_9_775()) return true;
    return false;
  }

  private boolean jj_3R_MySQLIndexHint_1899_10_774()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_Identifier_1911_9_773()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3432_11_300()
 {
    if (jj_3R_UserVariable_3577_5_196()) return true;
    return false;
  }

  private boolean jj_3_127()
 {
    if (jj_3R_JdbcNamedParameter_3565_5_209()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3428_11_299()
 {
    if (jj_3R_SimpleJdbcParameter_2489_5_222()) return true;
    return false;
  }

  private boolean jj_3R_AlterExpression_4956_17_255()
 {
    if (jj_3R_AlterExpressionColumnDropNotNull_4865_5_471()) return true;
    return false;
  }

  private boolean jj_3R_Alias_1857_45_631()
 {
    if (jj_3R_ColDataType_4521_5_470()) return true;
    return false;
  }

  private boolean jj_3_126()
 {
    if (jj_3R_CaseWhenExpression_3838_5_208()) return true;
    return false;
  }

  private boolean jj_3_194()
 {
    if (jj_3R_AlterExpressionColumnDataType_4847_5_253()) return true;
    return false;
  }

  private boolean jj_3R_MySQLIndexHint_1891_9_346()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(240)) {
    jj_scanpos = xsp;
    if (jj_scan_token(210)) {
    jj_scanpos = xsp;
    if (jj_scan_token(107)) {
    jj_scanpos = xsp;
    if (jj_scan_token(89)) return true;
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_scan_token(112)) {
    jj_scanpos = xsp;
    if (jj_scan_token(124)) return true;
    }
    if (jj_scan_token(287)) return true;
    if (jj_3R_Identifier_1911_9_773()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_MySQLIndexHint_1899_10_774()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_Alias_1853_46_421()
 {
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3424_9_298()
 {
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3_201()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_193()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_194()) {
    jj_scanpos = xsp;
    if (jj_3R_AlterExpression_4956_17_255()) return true;
    }
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3421_7_493()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3421_7_296()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PrimaryExpression_3421_7_493()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3421_31_494()) return true;
    }
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3422_6_297()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(295)) {
    jj_scanpos = xsp;
    if (jj_scan_token(307)) {
    jj_scanpos = xsp;
    if (jj_scan_token(299)) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3421_5_126()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PrimaryExpression_3421_7_296()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PrimaryExpression_3422_6_297()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PrimaryExpression_3424_9_298()) {
    jj_scanpos = xsp;
    if (jj_3_126()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3428_11_299()) {
    jj_scanpos = xsp;
    if (jj_3_127()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3432_11_300()) {
    jj_scanpos = xsp;
    if (jj_3_128()) {
    jj_scanpos = xsp;
    if (jj_3_129()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3438_11_301()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3440_11_302()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3442_11_303()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3446_11_304()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3448_11_305()) {
    jj_scanpos = xsp;
    if (jj_3_133()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3452_11_306()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3454_11_307()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3456_11_308()) {
    jj_scanpos = xsp;
    if (jj_3_134()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3461_11_309()) {
    jj_scanpos = xsp;
    if (jj_3_135()) {
    jj_scanpos = xsp;
    if (jj_3_136()) {
    jj_scanpos = xsp;
    if (jj_3_137()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3469_11_310()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3471_11_311()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3473_11_312()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3475_11_313()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3477_11_314()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3479_11_315()) {
    jj_scanpos = xsp;
    if (jj_3_139()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_PrimaryExpression_3507_9_666()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_140()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PrimaryExpression_3514_7_667()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_PrimaryExpression_3516_7_668()) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_PrimaryExpression_3524_7_669()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_AlterExpression_4942_16_254()
 {
    if (jj_scan_token(K_KEY)) return true;
    return false;
  }

  private boolean jj_3_199()
 {
    if (jj_scan_token(K_PRIMARY)) return true;
    if (jj_scan_token(K_KEY)) return true;
    return false;
  }

  private boolean jj_3_200()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AlterExpression_4942_16_254()) {
    jj_scanpos = xsp;
    if (jj_scan_token(112)) return true;
    }
    if (jj_3R_RelObjectName_1446_5_156()) return true;
    return false;
  }

  private boolean jj_3R_SQLServerHints_1877_5_347()
 {
    if (jj_scan_token(K_WITH)) return true;
    if (jj_scan_token(287)) return true;
    if (jj_3R_SQLServerHint_1868_9_775()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_SQLServerHints_1878_31_776()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_SQLServerHint_1870_9_783()
 {
    if (jj_scan_token(K_NOLOCK)) return true;
    return false;
  }

  private boolean jj_3R_SetOperationListWithoutIntialSelect_1741_137_504()
 {
    if (jj_scan_token(K_DISTINCT)) return true;
    return false;
  }

  private boolean jj_3R_SQLServerHint_1868_9_782()
 {
    if (jj_scan_token(K_INDEX)) return true;
    if (jj_scan_token(287)) return true;
    if (jj_3R_RelObjectName_1446_5_156()) return true;
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_SQLServerHint_1868_9_775()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SQLServerHint_1868_9_782()) {
    jj_scanpos = xsp;
    if (jj_3R_SQLServerHint_1870_9_783()) return true;
    }
    return false;
  }

  private boolean jj_3_123()
 {
    if (jj_3R_SimpleExpression_3242_5_122()) return true;
    return false;
  }

  private boolean jj_3R_Alias_1858_18_632()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_RelObjectName_1446_5_156()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Alias_1858_72_665()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_ArrayExpression_3399_11_760()
 {
    if (jj_scan_token(292)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_123()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_122()
 {
    if (jj_3R_SimpleExpression_3242_5_122()) return true;
    return false;
  }

  private boolean jj_3_59()
 {
    if (jj_scan_token(287)) return true;
    if (jj_3R_RelObjectName_1446_5_156()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Alias_1857_45_631()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_Alias_1858_18_632()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_SelectItemsList_1799_67_705()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_SelectItem_1820_5_704()) return true;
    return false;
  }

  private boolean jj_3R_ArrayExpression_3396_5_703()
 {
    if (jj_scan_token(317)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_122()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_ArrayExpression_3399_11_760()) jj_scanpos = xsp;
    if (jj_scan_token(318)) return true;
    return false;
  }

  private boolean jj_3R_Alias_1853_11_420()
 {
    if (jj_3R_RelObjectNameWithoutStart_1459_5_540()) return true;
    return false;
  }

  private boolean jj_3R_Alias_1852_6_419()
 {
    if (jj_scan_token(K_AS)) return true;
    return false;
  }

  private boolean jj_3R_Alias_1852_5_240()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Alias_1852_6_419()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_Alias_1853_11_420()) {
    jj_scanpos = xsp;
    if (jj_3R_Alias_1853_46_421()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3_59()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_MultiplicativeExpression_3353_39_204()
 {
    if (jj_scan_token(315)) return true;
    return false;
  }

  private boolean jj_3R_MultiplicativeExpression_3352_39_203()
 {
    if (jj_scan_token(K_DIV)) return true;
    return false;
  }

  private boolean jj_3R_MultiplicativeExpression_3351_39_202()
 {
    if (jj_scan_token(314)) return true;
    return false;
  }

  private boolean jj_3R_BitwiseXor_3377_9_635()
 {
    if (jj_scan_token(316)) return true;
    if (jj_3R_PrimaryExpression_3421_5_126()) return true;
    return false;
  }

  private boolean jj_3R_BitwiseXor_3375_5_205()
 {
    if (jj_3R_PrimaryExpression_3421_5_126()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_BitwiseXor_3377_9_635()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_SetOperationListWithoutIntialSelect_1741_103_503()
 {
    if (jj_scan_token(K_ALL)) return true;
    return false;
  }

  private boolean jj_3R_SetOperationListWithoutIntialSelect_1741_103_337()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SetOperationListWithoutIntialSelect_1741_103_503()) {
    jj_scanpos = xsp;
    if (jj_3R_SetOperationListWithoutIntialSelect_1741_137_504()) return true;
    }
    return false;
  }

  private boolean jj_3R_AllTableColumns_1836_6_154()
 {
    if (jj_3R_Table_1507_5_251()) return true;
    if (jj_scan_token(291)) return true;
    if (jj_scan_token(290)) return true;
    return false;
  }

  private boolean jj_3R_MultiplicativeExpression_3350_23_201()
 {
    if (jj_scan_token(290)) return true;
    return false;
  }

  private boolean jj_3_57()
 {
    if (jj_3R_AllTableColumns_1836_6_154()) return true;
    return false;
  }

  private boolean jj_3_58()
 {
    if (jj_3R_SelectExpressionItem_1811_7_155()) return true;
    return false;
  }

  private boolean jj_3R_AdditiveExpression_3324_39_199()
 {
    if (jj_scan_token(307)) return true;
    return false;
  }

  private boolean jj_3R_SelectExpressionItem_1812_15_761()
 {
    if (jj_3R_Alias_1852_5_240()) return true;
    return false;
  }

  private boolean jj_3R_SelectItem_1821_5_738()
 {
    if (jj_3R_AllTableColumns_1836_6_154()) return true;
    return false;
  }

  private boolean jj_3R_SelectItem_1819_6_737()
 {
    if (jj_scan_token(290)) return true;
    return false;
  }

  private boolean jj_3R_SelectItem_1820_5_704()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SelectItem_1819_6_737()) {
    jj_scanpos = xsp;
    if (jj_3R_SelectItem_1821_5_738()) {
    jj_scanpos = xsp;
    if (jj_3_58()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_121()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_MultiplicativeExpression_3350_23_201()) {
    jj_scanpos = xsp;
    if (jj_3R_MultiplicativeExpression_3351_39_202()) {
    jj_scanpos = xsp;
    if (jj_3R_MultiplicativeExpression_3352_39_203()) {
    jj_scanpos = xsp;
    if (jj_3R_MultiplicativeExpression_3353_39_204()) return true;
    }
    }
    }
    if (jj_3R_BitwiseXor_3375_5_205()) return true;
    return false;
  }

  private boolean jj_3R_WithList_1762_60_591()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_WithItem_1777_6_587()) return true;
    return false;
  }

  private boolean jj_3R_SelectExpressionItem_1811_7_155()
 {
    if (jj_3R_Condition_2809_5_176()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SelectExpressionItem_1812_15_761()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_MultiplicativeExpression_3345_5_200()
 {
    if (jj_3R_BitwiseXor_3375_5_205()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_121()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_SetOperationList_1674_137_500()
 {
    if (jj_scan_token(K_DISTINCT)) return true;
    return false;
  }

  private boolean jj_3R_SelectItemsList_1799_5_673()
 {
    if (jj_3R_SelectItem_1820_5_704()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_SelectItemsList_1799_67_705()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_AlterExpressionColumnDropNotNull_4867_6_552()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_AlterExpressionColumnDropNotNull_4865_5_471()
 {
    if (jj_3R_RelObjectName_1446_5_156()) return true;
    if (jj_scan_token(K_DROP)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AlterExpressionColumnDropNotNull_4867_6_552()) jj_scanpos = xsp;
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3_56()
 {
    if (jj_scan_token(287)) return true;
    if (jj_scan_token(K_VALUES)) return true;
    if (jj_3R_SimpleExpressionList_3079_5_153()) return true;
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_WithItem_1787_11_640()
 {
    if (jj_scan_token(287)) return true;
    if (jj_3R_SubSelect_4142_5_190()) return true;
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_AdditiveExpression_3323_10_198()
 {
    if (jj_scan_token(295)) return true;
    return false;
  }

  private boolean jj_3_120()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AdditiveExpression_3323_10_198()) {
    jj_scanpos = xsp;
    if (jj_3R_AdditiveExpression_3324_39_199()) return true;
    }
    if (jj_3R_MultiplicativeExpression_3345_5_200()) return true;
    return false;
  }

  private boolean jj_3R_AdditiveExpression_3321_5_397()
 {
    if (jj_3R_MultiplicativeExpression_3345_5_200()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_120()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_WithItem_1781_7_639()
 {
    if (jj_scan_token(287)) return true;
    if (jj_scan_token(K_VALUES)) return true;
    if (jj_3R_SimpleExpressionList_3079_5_153()) return true;
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_BitwiseAndOr_3298_25_531()
 {
    if (jj_scan_token(313)) return true;
    return false;
  }

  private boolean jj_3R_AlterExpressionColumnDataType_4850_7_551()
 {
    if (jj_3R_CreateParameter_4620_9_250()) return true;
    return false;
  }

  private boolean jj_3R_WithItem_1778_8_634()
 {
    if (jj_scan_token(287)) return true;
    if (jj_3R_SelectItemsList_1799_5_673()) return true;
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_BitwiseAndOr_3296_25_530()
 {
    if (jj_scan_token(312)) return true;
    return false;
  }

  private boolean jj_3R_WithItem_1777_8_633()
 {
    if (jj_scan_token(K_RECURSIVE)) return true;
    return false;
  }

  private boolean jj_3R_AlterExpressionColumnDataType_4848_6_469()
 {
    if (jj_scan_token(K_TYPE)) return true;
    return false;
  }

  private boolean jj_3R_WithItem_1777_6_587()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_WithItem_1777_8_633()) jj_scanpos = xsp;
    if (jj_3R_RelObjectName_1446_5_156()) return true;
    xsp = jj_scanpos;
    if (jj_3R_WithItem_1778_8_634()) jj_scanpos = xsp;
    if (jj_scan_token(K_AS)) return true;
    xsp = jj_scanpos;
    if (jj_3R_WithItem_1781_7_639()) {
    jj_scanpos = xsp;
    if (jj_3R_WithItem_1787_11_640()) return true;
    }
    return false;
  }

  private boolean jj_3R_AlterExpressionColumnDataType_4847_5_253()
 {
    if (jj_3R_RelObjectName_1446_5_156()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AlterExpressionColumnDataType_4848_6_469()) jj_scanpos = xsp;
    if (jj_3R_ColDataType_4521_5_470()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_AlterExpressionColumnDataType_4850_7_551()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_SetOperationList_1674_103_499()
 {
    if (jj_scan_token(K_ALL)) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_1674_103_334()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SetOperationList_1674_103_499()) {
    jj_scanpos = xsp;
    if (jj_3R_SetOperationList_1674_137_500()) return true;
    }
    return false;
  }

  private boolean jj_3R_BitwiseAndOr_3294_13_529()
 {
    if (jj_scan_token(311)) return true;
    return false;
  }

  private boolean jj_3R_BitwiseAndOr_3292_13_528()
 {
    if (jj_scan_token(310)) return true;
    return false;
  }

  private boolean jj_3R_WithList_1762_5_497()
 {
    if (jj_scan_token(K_WITH)) return true;
    if (jj_3R_WithItem_1777_6_587()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_WithList_1762_60_591()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_SetOperationList_1680_85_336()
 {
    if (jj_3R_Values_922_5_502()) return true;
    return false;
  }

  private boolean jj_3R_BitwiseAndOr_3291_9_398()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_BitwiseAndOr_3292_13_528()) {
    jj_scanpos = xsp;
    if (jj_3R_BitwiseAndOr_3294_13_529()) {
    jj_scanpos = xsp;
    if (jj_3R_BitwiseAndOr_3296_25_530()) {
    jj_scanpos = xsp;
    if (jj_3R_BitwiseAndOr_3298_25_531()) return true;
    }
    }
    }
    if (jj_3R_AdditiveExpression_3321_5_397()) return true;
    return false;
  }

  private boolean jj_3R_BitwiseAndOr_3289_5_197()
 {
    if (jj_3R_AdditiveExpression_3321_5_397()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_BitwiseAndOr_3291_9_398()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_SetOperationListWithoutIntialSelect_1744_11_152()
 {
    if (jj_scan_token(K_EXCEPT)) return true;
    return false;
  }

  private boolean jj_3R_SetOperationListWithoutIntialSelect_1743_11_151()
 {
    if (jj_scan_token(K_MINUS)) return true;
    return false;
  }

  private boolean jj_3R_SetOperationListWithoutIntialSelect_1742_11_150()
 {
    if (jj_scan_token(K_INTERSECT)) return true;
    return false;
  }

  private boolean jj_3R_SetOperationListWithoutIntialSelect_1741_10_149()
 {
    if (jj_scan_token(K_UNION)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SetOperationListWithoutIntialSelect_1741_103_337()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_192()
 {
    if (jj_scan_token(K_IF)) return true;
    if (jj_scan_token(K_EXISTS)) return true;
    return false;
  }

  private boolean jj_3_55()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SetOperationListWithoutIntialSelect_1741_10_149()) {
    jj_scanpos = xsp;
    if (jj_3R_SetOperationListWithoutIntialSelect_1742_11_150()) {
    jj_scanpos = xsp;
    if (jj_3R_SetOperationListWithoutIntialSelect_1743_11_151()) {
    jj_scanpos = xsp;
    if (jj_3R_SetOperationListWithoutIntialSelect_1744_11_152()) return true;
    }
    }
    }
    if (jj_scan_token(287)) return true;
    if (jj_3R_SelectBody_1553_5_288()) return true;
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_1680_62_335()
 {
    if (jj_3R_PlainSelect_1585_5_501()) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_1680_60_148()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SetOperationList_1680_62_335()) {
    jj_scanpos = xsp;
    if (jj_3R_SetOperationList_1680_85_336()) return true;
    }
    return false;
  }

  private boolean jj_3_119()
 {
    if (jj_scan_token(OP_CONCAT)) return true;
    if (jj_3R_BitwiseAndOr_3289_5_197()) return true;
    return false;
  }

  private boolean jj_3R_ConcatExpression_3266_5_295()
 {
    if (jj_3R_BitwiseAndOr_3289_5_197()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_119()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_AnyComparisonExpression_3228_40_393()
 {
    if (jj_scan_token(K_SOME)) return true;
    return false;
  }

  private boolean jj_3R_SetOperationListWithoutIntialSelect_1726_5_629()
 {
    Token xsp;
    if (jj_3_55()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_55()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_118()
 {
    if (jj_3R_UserVariable_3577_5_196()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(289)) {
    jj_scanpos = xsp;
    if (jj_scan_token(309)) return true;
    }
    return false;
  }

  private boolean jj_3R_ColumnsNamesList_4780_12_568()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_ColumnsNamesListItem_4765_9_567()) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_1672_48_618()
 {
    if (jj_3R_Values_922_5_502()) return true;
    return false;
  }

  private boolean jj_3R_AList_4750_38_712()
 {
    if (jj_scan_token(289)) return true;
    return false;
  }

  private boolean jj_3R_SimpleExpression_3242_7_294()
 {
    if (jj_3R_UserVariable_3577_5_196()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(289)) {
    jj_scanpos = xsp;
    if (jj_scan_token(309)) return true;
    }
    return false;
  }

  private boolean jj_3R_ColumnsNamesList_4778_5_487()
 {
    if (jj_scan_token(287)) return true;
    if (jj_3R_ColumnsNamesListItem_4765_9_567()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_ColumnsNamesList_4780_12_568()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_SimpleExpression_3242_5_122()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SimpleExpression_3242_7_294()) jj_scanpos = xsp;
    if (jj_3R_ConcatExpression_3266_5_295()) return true;
    return false;
  }

  private boolean jj_3R_ColumnsNamesListItem_4766_11_616()
 {
    if (jj_scan_token(287)) return true;
    if (jj_scan_token(S_LONG)) return true;
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_SimpleExpressionListAtLeastTwoItems_3184_57_527()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_SimpleExpression_3242_5_122()) return true;
    return false;
  }

  private boolean jj_3R_ColumnsNamesListItem_4765_9_567()
 {
    if (jj_3R_RelObjectName_1446_5_156()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ColumnsNamesListItem_4766_11_616()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_54()
 {
    if (jj_scan_token(K_FETCH)) return true;
    return false;
  }

  private boolean jj_3_53()
 {
    if (jj_scan_token(K_OFFSET)) return true;
    return false;
  }

  private boolean jj_3_52()
 {
    if (jj_scan_token(K_LIMIT)) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_1672_25_617()
 {
    if (jj_3R_PlainSelect_1585_5_501()) return true;
    return false;
  }

  private boolean jj_3R_AnyComparisonExpression_3228_3_392()
 {
    if (jj_scan_token(K_ANY)) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_1672_23_570()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SetOperationList_1672_25_617()) {
    jj_scanpos = xsp;
    if (jj_3R_SetOperationList_1672_48_618()) return true;
    }
    return false;
  }

  private boolean jj_3R_AnyComparisonExpression_3228_2_194()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AnyComparisonExpression_3228_3_392()) {
    jj_scanpos = xsp;
    if (jj_3R_AnyComparisonExpression_3228_40_393()) return true;
    }
    if (jj_scan_token(287)) return true;
    if (jj_3R_SubSelect_4142_5_190()) return true;
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_1687_6_574()
 {
    if (jj_3R_Fetch_2601_5_621()) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_1686_6_573()
 {
    if (jj_3R_Offset_2579_5_620()) return true;
    return false;
  }

  private boolean jj_3R_AList_4749_12_646()
 {
    if (jj_3R_RelObjectNameWithoutValue_1411_5_505()) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_1685_6_572()
 {
    if (jj_3R_LimitWithOffset_2514_5_619()) return true;
    return false;
  }

  private boolean jj_3R_AList_4750_10_711()
 {
    if (jj_scan_token(K_COMMA)) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_1684_6_571()
 {
    if (jj_3R_OrderByElements_2459_5_418()) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_1680_10_147()
 {
    if (jj_scan_token(287)) return true;
    if (jj_3R_SelectBody_1553_5_288()) return true;
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_AList_4750_9_676()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AList_4750_10_711()) {
    jj_scanpos = xsp;
    if (jj_3R_AList_4750_38_712()) return true;
    }
    return false;
  }

  private boolean jj_3R_AList_4748_10_645()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(275)) {
    jj_scanpos = xsp;
    if (jj_scan_token(274)) {
    jj_scanpos = xsp;
    if (jj_scan_token(284)) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_SetOperationList_1677_11_146()
 {
    if (jj_scan_token(K_EXCEPT)) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_1676_11_145()
 {
    if (jj_scan_token(K_MINUS)) return true;
    return false;
  }

  private boolean jj_3R_AList_4748_8_599()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AList_4748_10_645()) {
    jj_scanpos = xsp;
    if (jj_3R_AList_4749_12_646()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_AList_4750_9_676()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_SetOperationList_1675_11_144()
 {
    if (jj_scan_token(K_INTERSECT)) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_1674_10_143()
 {
    if (jj_scan_token(K_UNION)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SetOperationList_1674_103_334()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_AllComparisonExpression_3215_2_193()
 {
    if (jj_scan_token(K_ALL)) return true;
    if (jj_scan_token(287)) return true;
    if (jj_3R_SubSelect_4142_5_190()) return true;
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_AList_4745_6_545()
 {
    if (jj_scan_token(287)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_AList_4748_8_599()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3_116()
 {
    if (jj_3R_ValueListExpression_4114_5_195()) return true;
    return false;
  }

  private boolean jj_3_51()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SetOperationList_1674_10_143()) {
    jj_scanpos = xsp;
    if (jj_3R_SetOperationList_1675_11_144()) {
    jj_scanpos = xsp;
    if (jj_3R_SetOperationList_1676_11_145()) {
    jj_scanpos = xsp;
    if (jj_3R_SetOperationList_1677_11_146()) return true;
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_SetOperationList_1680_10_147()) {
    jj_scanpos = xsp;
    if (jj_3R_SetOperationList_1680_60_148()) return true;
    }
    return false;
  }

  private boolean jj_3R_SetOperationList_1671_6_569()
 {
    if (jj_scan_token(287)) return true;
    if (jj_3R_SelectBody_1553_5_288()) return true;
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_1671_5_488()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SetOperationList_1671_6_569()) {
    jj_scanpos = xsp;
    if (jj_3R_SetOperationList_1672_23_570()) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_51()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_SetOperationList_1684_6_571()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_SetOperationList_1685_6_572()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_SetOperationList_1686_6_573()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_SetOperationList_1687_6_574()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_ComparisonItem_3201_7_377()
 {
    if (jj_3R_RowConstructor_3891_5_523()) return true;
    return false;
  }

  private boolean jj_3_117()
 {
    if (jj_3R_SimpleExpression_3242_5_122()) return true;
    return false;
  }

  private boolean jj_3R_ComparisonItem_3199_7_376()
 {
    if (jj_3R_ValueListExpression_4114_5_195()) return true;
    return false;
  }

  private boolean jj_3_115()
 {
    if (jj_3R_AnyComparisonExpression_3228_2_194()) return true;
    return false;
  }

  private boolean jj_3R_RowMovement_4733_5_566()
 {
    if (jj_scan_token(K_DISABLE)) return true;
    if (jj_scan_token(K_ROW)) return true;
    if (jj_scan_token(K_MOVEMENT)) return true;
    return false;
  }

  private boolean jj_3_114()
 {
    if (jj_3R_AllComparisonExpression_3215_2_193()) return true;
    return false;
  }

  private boolean jj_3R_RowMovement_4731_5_565()
 {
    if (jj_scan_token(K_ENABLE)) return true;
    if (jj_scan_token(K_ROW)) return true;
    if (jj_scan_token(K_MOVEMENT)) return true;
    return false;
  }

  private boolean jj_3R_ComparisonItem_3196_3_181()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_114()) {
    jj_scanpos = xsp;
    if (jj_3_115()) {
    jj_scanpos = xsp;
    if (jj_3R_ComparisonItem_3199_7_376()) {
    jj_scanpos = xsp;
    if (jj_3_117()) {
    jj_scanpos = xsp;
    if (jj_3R_ComparisonItem_3201_7_377()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_RowMovement_4730_3_478()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_RowMovement_4731_5_565()) {
    jj_scanpos = xsp;
    if (jj_3R_RowMovement_4733_5_566()) return true;
    }
    return false;
  }

  private boolean jj_3_48()
 {
    if (jj_scan_token(K_WAIT)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4719_13_467()
 {
    if (jj_scan_token(323)) return true;
    if (jj_3R_ColDataType_4521_5_470()) return true;
    return false;
  }

  private boolean jj_3R_NamedExpressionListExprFirst_3163_33_539()
 {
    if (jj_scan_token(K_FOR)) return true;
    if (jj_3R_SimpleExpression_3242_5_122()) return true;
    return false;
  }

  private boolean jj_3_50()
 {
    if (jj_scan_token(K_OPTIMIZE)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4717_13_466()
 {
    if (jj_scan_token(K_ARRAY_LITERAL)) return true;
    if (jj_3R_ArrayConstructor_3612_5_217()) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4715_13_465()
 {
    if (jj_scan_token(K_PARALLEL)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4713_13_464()
 {
    if (jj_scan_token(K_FALSE)) return true;
    return false;
  }

  private boolean jj_3_46()
 {
    if (jj_scan_token(K_LIMIT)) return true;
    return false;
  }

  private boolean jj_3R_SimpleExpressionListAtLeastTwoItems_3184_5_394()
 {
    if (jj_3R_SimpleExpression_3242_5_122()) return true;
    Token xsp;
    if (jj_3R_SimpleExpressionListAtLeastTwoItems_3184_57_527()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_SimpleExpressionListAtLeastTwoItems_3184_57_527()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_CreateParameter_4711_13_463()
 {
    if (jj_scan_token(K_TRUE)) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1642_11_726()
 {
    if (jj_scan_token(K_NOWAIT)) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1646_7_694()
 {
    if (jj_scan_token(K_FOR)) return true;
    if (jj_scan_token(K_XML)) return true;
    if (jj_scan_token(K_PATH)) return true;
    if (jj_scan_token(287)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3_47()
 {
    if (jj_scan_token(K_FETCH)) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1641_11_725()
 {
    if (jj_3R_Wait_5240_5_749()) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4709_13_462()
 {
    if (jj_scan_token(K_DESC)) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1640_11_724()
 {
    if (jj_scan_token(K_OF)) return true;
    if (jj_3R_Table_1507_5_251()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1644_6_693()
 {
    if (jj_3R_OptimizeFor_2622_5_727()) return true;
    return false;
  }

  private boolean jj_3_45()
 {
    if (jj_scan_token(K_OFFSET)) return true;
    return false;
  }

  private boolean jj_3R_NamedExpressionListExprFirst_3160_25_417()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(88)) {
    jj_scanpos = xsp;
    if (jj_scan_token(92)) return true;
    }
    if (jj_3R_SimpleExpression_3242_5_122()) return true;
    xsp = jj_scanpos;
    if (jj_3R_NamedExpressionListExprFirst_3163_33_539()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_CreateParameter_4707_13_461()
 {
    if (jj_scan_token(K_ASC)) return true;
    return false;
  }

  private boolean jj_3_44()
 {
    if (jj_scan_token(K_LIMIT)) return true;
    return false;
  }

  private boolean jj_3_43()
 {
    if (jj_scan_token(K_ORDER)) return true;
    if (jj_scan_token(K_BY)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4705_13_460()
 {
    if (jj_scan_token(K_COLLATE)) return true;
    return false;
  }

  private boolean jj_3_42()
 {
    if (jj_scan_token(K_ORDER)) return true;
    if (jj_scan_token(K_SIBLINGS)) return true;
    if (jj_scan_token(K_BY)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4703_13_459()
 {
    if (jj_scan_token(K_USING)) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1635_10_691()
 {
    if (jj_3R_LimitWithOffset_2514_5_619()) return true;
    return false;
  }

  private boolean jj_3_49()
 {
    if (jj_scan_token(K_FOR)) return true;
    if (jj_scan_token(K_UPDATE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1640_11_724()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1641_11_725()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1642_11_726()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_CreateParameter_4701_13_458()
 {
    if (jj_scan_token(K_COMMENT)) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1637_6_692()
 {
    if (jj_3R_Fetch_2601_5_621()) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4699_13_457()
 {
    if (jj_scan_token(K_TYPE)) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1634_6_690()
 {
    if (jj_3R_Offset_2579_5_620()) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4697_13_456()
 {
    if (jj_scan_token(K_IN)) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1633_6_689()
 {
    if (jj_3R_LimitWithOffset_2514_5_619()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1632_6_688()
 {
    if (jj_3R_OrderByElements_2459_5_418()) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4695_13_455()
 {
    if (jj_scan_token(K_BY)) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1631_6_687()
 {
    if (jj_3R_OrderByElements_2459_5_418()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1630_7_686()
 {
    if (jj_3R_Having_2447_5_723()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1629_7_685()
 {
    if (jj_3R_GroupByColumnReferences_2416_5_722()) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4693_13_454()
 {
    if (jj_scan_token(K_PARTITION)) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1628_7_684()
 {
    if (jj_3R_OracleHierarchicalQueryClause_2391_5_721()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1627_7_683()
 {
    if (jj_3R_WhereClause_2381_5_720()) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4691_13_453()
 {
    if (jj_scan_token(K_TEMPORARY)) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1626_7_682()
 {
    if (jj_3R_KSQLWindowClause_2342_5_719()) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4689_13_452()
 {
    if (jj_scan_token(K_TEMP)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4687_13_451()
 {
    if (jj_scan_token(K_UNSIGNED)) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1622_7_681()
 {
    if (jj_scan_token(K_FROM)) return true;
    if (jj_3R_FromItem_2109_5_158()) return true;
    if (jj_3R_JoinsList_2243_5_132()) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4685_13_450()
 {
    if (jj_scan_token(K_WHERE)) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1621_6_680()
 {
    if (jj_3R_IntoClause_2091_5_718()) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4683_13_449()
 {
    if (jj_scan_token(K_EXCLUDE)) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1611_13_141()
 {
    if (jj_scan_token(K_SQL_NO_CACHE)) return true;
    return false;
  }

  private boolean jj_3_41()
 {
    if (jj_3R_Top_2637_5_142()) return true;
    return false;
  }

  private boolean jj_3R_NamedExpressionListExprFirst_3150_9_233()
 {
    if (jj_3R_SimpleExpression_3242_5_122()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(92)) {
    jj_scanpos = xsp;
    if (jj_scan_token(109)) {
    jj_scanpos = xsp;
    if (jj_scan_token(177)) return true;
    }
    }
    if (jj_3R_SimpleExpression_3242_5_122()) return true;
    xsp = jj_scanpos;
    if (jj_3R_NamedExpressionListExprFirst_3160_25_417()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_CreateParameter_4681_13_448()
 {
    if (jj_scan_token(K_WITH)) return true;
    return false;
  }

  private boolean jj_3_39()
 {
    if (jj_scan_token(K_ON)) return true;
    if (jj_scan_token(287)) return true;
    if (jj_3R_SelectItemsList_1799_5_673()) return true;
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4679_13_447()
 {
    if (jj_scan_token(K_CONSTRAINT)) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1607_13_140()
 {
    if (jj_scan_token(K_SQL_CALC_FOUND_ROWS)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4677_13_446()
 {
    if (jj_scan_token(K_CHECK)) return true;
    if (jj_scan_token(287)) return true;
    if (jj_3R_Expression_2720_5_226()) return true;
    if (jj_scan_token(288)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4675_13_445()
 {
    if (jj_3R_AList_4745_6_545()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1603_13_139()
 {
    if (jj_scan_token(K_UNIQUE)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4673_13_444()
 {
    if (jj_scan_token(K_TABLESPACE)) return true;
    if (jj_3R_RelObjectName_1446_5_156()) return true;
    return false;
  }

  private boolean jj_3_191()
 {
    if (jj_scan_token(K_USING)) return true;
    if (jj_scan_token(K_INDEX)) return true;
    if (jj_scan_token(K_TABLESPACE)) return true;
    if (jj_3R_RelObjectName_1446_5_156()) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4669_13_443()
 {
    if (jj_scan_token(289)) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1598_13_138()
 {
    if (jj_scan_token(K_DISTINCT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_39()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_CreateParameter_4667_13_442()
 {
    if (jj_scan_token(K_TIME_KEY_EXPR)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4641_38_598()
 {
    if (jj_scan_token(307)) return true;
    return false;
  }

  private boolean jj_3R_ComplexExpressionList_3093_51_411()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_Expression_2720_5_226()) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4665_13_441()
 {
    if (jj_scan_token(K_UPDATE)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4663_13_440()
 {
    if (jj_scan_token(K_DELETE)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4661_13_439()
 {
    if (jj_scan_token(K_CASCADE)) return true;
    return false;
  }

  private boolean jj_3_40()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(8)) {
    jj_scanpos = xsp;
    if (jj_3R_PlainSelect_1598_13_138()) {
    jj_scanpos = xsp;
    if (jj_3R_PlainSelect_1603_13_139()) {
    jj_scanpos = xsp;
    if (jj_3R_PlainSelect_1607_13_140()) {
    jj_scanpos = xsp;
    if (jj_3R_PlainSelect_1611_13_141()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_CreateParameter_4659_13_438()
 {
    if (jj_scan_token(K_UNIQUE)) return true;
    return false;
  }

  private boolean jj_3R_SimpleExpressionList_3079_57_338()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_SimpleExpression_3242_5_122()) return true;
    return false;
  }

  private boolean jj_3_38()
 {
    if (jj_3R_First_2700_5_137()) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4657_13_437()
 {
    if (jj_scan_token(K_ROWS)) return true;
    return false;
  }

  private boolean jj_3_37()
 {
    if (jj_3R_Skip_2664_5_136()) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4655_13_436()
 {
    if (jj_scan_token(K_DROP)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4653_13_435()
 {
    if (jj_scan_token(K_COMMIT)) return true;
    return false;
  }

  private boolean jj_3R_IsBooleanExpression_3036_94_383()
 {
    if (jj_scan_token(K_FALSE)) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1587_7_679()
 {
    if (jj_scan_token(K_STRAIGHT)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4651_13_434()
 {
    if (jj_scan_token(K_ON)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4649_13_433()
 {
    if (jj_scan_token(K_AS)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4645_16_544()
 {
    if (jj_scan_token(S_DOUBLE)) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1585_5_501()
 {
    if (jj_scan_token(K_SELECT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1587_7_679()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_37()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_38()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_40()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_41()) jj_scanpos = xsp;
    if (jj_3R_SelectItemsList_1799_5_673()) return true;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1621_6_680()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1622_7_681()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1626_7_682()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1627_7_683()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1628_7_684()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1629_7_685()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1630_7_686()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1631_6_687()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1632_6_688()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1633_6_689()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1634_6_690()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1635_10_691()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1637_6_692()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_49()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1644_6_693()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1646_7_694()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_CreateParameter_4643_16_543()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4641_16_597()
 {
    if (jj_scan_token(295)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4641_16_542()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateParameter_4641_16_597()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4641_38_598()) return true;
    }
    return false;
  }

  private boolean jj_3R_CreateParameter_4641_15_432()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateParameter_4641_16_542()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateParameter_4643_16_543()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4645_16_544()) return true;
    }
    return false;
  }

  private boolean jj_3R_NamedExpressionList1_3114_5_232()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(24)) {
    jj_scanpos = xsp;
    if (jj_scan_token(128)) {
    jj_scanpos = xsp;
    if (jj_scan_token(228)) return true;
    }
    }
    if (jj_3R_SimpleExpression_3242_5_122()) return true;
    xsp = jj_scanpos;
    if (jj_scan_token(92)) {
    jj_scanpos = xsp;
    if (jj_scan_token(109)) {
    jj_scanpos = xsp;
    if (jj_scan_token(177)) return true;
    }
    }
    if (jj_3R_SimpleExpression_3242_5_122()) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4639_13_431()
 {
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4637_13_430()
 {
    if (jj_scan_token(K_KEY)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4635_13_429()
 {
    if (jj_scan_token(K_REFERENCES)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4633_13_428()
 {
    if (jj_scan_token(K_FOREIGN)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4631_13_427()
 {
    if (jj_scan_token(K_DEFAULT)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4629_13_426()
 {
    if (jj_scan_token(K_PRIMARY)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4622_18_541()
 {
    if (jj_scan_token(291)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(281)) {
    jj_scanpos = xsp;
    if (jj_scan_token(285)) return true;
    }
    return false;
  }

  private boolean jj_3R_CreateParameter_4627_13_425()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4625_13_424()
 {
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4621_13_423()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(281)) {
    jj_scanpos = xsp;
    if (jj_scan_token(285)) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_CreateParameter_4622_18_541()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_ComplexExpressionList_3093_5_223()
 {
    if (jj_3R_Expression_2720_5_226()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_ComplexExpressionList_3093_51_411()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_CreateParameter_4620_9_250()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateParameter_4621_13_423()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4625_13_424()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4627_13_425()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4629_13_426()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4631_13_427()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4633_13_428()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4635_13_429()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4637_13_430()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4639_13_431()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4641_15_432()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4649_13_433()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4651_13_434()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4653_13_435()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4655_13_436()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4657_13_437()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4659_13_438()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4661_13_439()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4663_13_440()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4665_13_441()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4667_13_442()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4669_13_443()) {
    jj_scanpos = xsp;
    if (jj_3_191()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4673_13_444()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4675_13_445()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4677_13_446()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4679_13_447()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4681_13_448()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4683_13_449()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4685_13_450()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4687_13_451()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4689_13_452()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4691_13_453()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4693_13_454()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4695_13_455()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4697_13_456()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4699_13_457()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4701_13_458()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4703_13_459()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4705_13_460()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4707_13_461()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4709_13_462()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4711_13_463()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4713_13_464()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4715_13_465()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4717_13_466()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4719_13_467()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_SelectBody_1553_5_288()
 {
    if (jj_3R_SetOperationList_1671_5_488()) return true;
    return false;
  }

  private boolean jj_3R_IsBooleanExpression_3036_55_382()
 {
    if (jj_scan_token(K_TRUE)) return true;
    return false;
  }

  private boolean jj_3R_ColDataType_4535_90_670()
 {
    if (jj_scan_token(K_COMMA)) return true;
    return false;
  }

  private boolean jj_3R_AlterView_4601_22_286()
 {
    if (jj_scan_token(K_REPLACE)) return true;
    return false;
  }

  private boolean jj_3R_IsNullExpression_3022_62_524()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_Select_1544_5_317()
 {
    if (jj_3R_SelectBody_1553_5_288()) return true;
    return false;
  }

  private boolean jj_3R_SimpleExpressionList_3079_5_153()
 {
    if (jj_3R_SimpleExpression_3242_5_122()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_SimpleExpressionList_3079_57_338()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_TableWithAlias_1522_20_319()
 {
    if (jj_3R_Alias_1852_5_240()) return true;
    return false;
  }

  private boolean jj_3R_IsNullExpression_3022_54_380()
 {
    if (jj_scan_token(K_IS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_IsNullExpression_3022_62_524()) jj_scanpos = xsp;
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3R_AlterView_4603_7_287()
 {
    if (jj_3R_ColumnsNamesList_4778_5_487()) return true;
    return false;
  }

  private boolean jj_3R_SelectWithWithItems_1532_7_316()
 {
    if (jj_3R_WithList_1762_5_497()) return true;
    return false;
  }

  private boolean jj_3R_SelectWithWithItems_1532_5_127()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SelectWithWithItems_1532_7_316()) jj_scanpos = xsp;
    if (jj_3R_Select_1544_5_317()) return true;
    return false;
  }

  private boolean jj_3R_AlterView_4601_5_117()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(9)) {
    jj_scanpos = xsp;
    if (jj_3R_AlterView_4601_22_286()) return true;
    }
    if (jj_scan_token(K_VIEW)) return true;
    if (jj_3R_Table_1507_5_251()) return true;
    xsp = jj_scanpos;
    if (jj_3R_AlterView_4603_7_287()) jj_scanpos = xsp;
    if (jj_scan_token(K_AS)) return true;
    if (jj_3R_SelectBody_1553_5_288()) return true;
    return false;
  }

  /** Generated Token Manager. */
  public CCJSqlParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  /** Whether we are looking ahead. */
  private boolean jj_lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[517];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static private int[] jj_la1_4;
  static private int[] jj_la1_5;
  static private int[] jj_la1_6;
  static private int[] jj_la1_7;
  static private int[] jj_la1_8;
  static private int[] jj_la1_9;
  static private int[] jj_la1_10;
  static {
	   jj_la1_init_0();
	   jj_la1_init_1();
	   jj_la1_init_2();
	   jj_la1_init_3();
	   jj_la1_init_4();
	   jj_la1_init_5();
	   jj_la1_init_6();
	   jj_la1_init_7();
	   jj_la1_init_8();
	   jj_la1_init_9();
	   jj_la1_init_10();
	}
	private static void jj_la1_init_0() {
	   jj_la1_0 = new int[] {0x0,0x0,0x0,0x0,0x20000000,0x0,0x0,0x20100200,0x20100200,0x20100200,0x0,0x20100200,0x0,0x20100200,0x20100200,0x0,0x0,0x0,0x0,0xc10000,0x0,0x0,0xd000a184,0x0,0x0,0xd000a184,0xd000a184,0x0,0x0,0x0,0x0,0x8000400,0x8000400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xd000a184,0xd000a184,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000,0xd001a084,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xd000a184,0x0,0x0,0x0,0x0,0x0,0xd000a184,0xd001a084,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xd000a084,0xd000a084,0xd000a084,0xd000a184,0xd000a184,0xd001a084,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x100,0x0,0x0,0x0,0x0,0x100,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0xd001a084,0x0,0x10000,0xd000a084,0xc00000,0x0,0xc00000,0x0,0x0,0x0,0x0,0x0,0x0,0xd001a084,0x0,0xd000a184,0x0,0x0,0xd001a084,0xd001a084,0x0,0x0,0xd001a084,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0x0,0x0,0xd000a184,0xd001a084,0x0,0x0,0x0,0xd000a184,0x0,0x0,0x0,0x0,0x0,0x0,0xd001a084,0x4000,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x40000,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1800,0x1800,0x0,0x0,0x0,0x0,0x0,0x0,0x400000,0x400000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xd000a184,0x0,0x0,0x0,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xd000a184,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x0,0x0,0x0,0x0,0x0,0xd000a184,0x100,0x0,0x0,0x0,0x0,0xd000a084,0x0,0x0,0x0,0x0,0x0,0x0,0x42058000,0x0,0x42058000,0x42058000,0x0,0x42058000,0x42058000,0x0,0x0,0x0,0x80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x42058000,0x0,0x0,0x0,0x0,0x0,0x42058000,0x0,0x0,0x42058000,0x0,0x0,0x0,0x0,0x0,0x0,0xd000a084,0x0,0x0,0x0,0x10000,0xd000a184,0x0,0x800000,0x0,0x400000,0x0,0xc00000,0x0,0x0,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000000,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40010000,0x2048000,0x0,0xd000a084,0x0,0xd000a084,0x0,0x0,0x0,0x0,0x0,0x40000000,0x40000000,0x40000000,0x0,0x42058000,0x0,0x0,0x0,0x208,0x0,0x0,0x0,0xd000a084,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xd000a084,0x0,0x0,0x0,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x288,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x200,0x0,0x200,0x4000000,0x0,0x0,0x0,0x4000000,0x0,0x0,0x0,0x4000000,0x0,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_1() {
	   jj_la1_1 = new int[] {0x0,0x0,0x8000000,0x8000000,0x0,0x20201800,0x0,0x28211800,0x28211800,0x28211800,0x0,0x28211800,0x0,0x28211800,0x28211800,0x400,0x0,0x400,0x0,0xc00024,0x0,0x0,0x70c99b2f,0x400,0x0,0x70c99b2f,0x70c99b2e,0x0,0x0,0x0,0x0,0x8000,0x8000,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x400,0x400,0x70c99b2f,0x70c99b2f,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x400,0x0,0x0,0x400,0x400,0x400,0x0,0x0,0x400,0x4000000,0x4000000,0x0,0x0,0x0,0x70c89b2e,0x400,0x0,0x0,0x400,0x400,0x400,0x0,0x400,0x0,0x400,0x0,0x0,0x0,0x0,0x400,0x0,0x0,0x400,0x400,0x400,0x0,0x0,0x400,0x0,0x400,0x70c99b2f,0x400,0x0,0x0,0x0,0x0,0x70c99b2f,0x70c89b2e,0x0,0x0,0x0,0x0,0x400,0x0,0x8000000,0x400,0x0,0x400,0x0,0x0,0x0,0x70c89b2e,0x70c99b2e,0x70c89b2e,0x70c99b2f,0x70cd9b2f,0x70c89b2e,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x2000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x80000000,0x0,0x0,0x0,0x0,0x80000000,0x80000000,0x0,0x400,0x0,0x0,0x0,0x400,0x70c89b2e,0x0,0x0,0x70c89b2e,0xc00024,0x400,0xc00024,0x0,0x400,0x0,0x0,0x400,0x0,0x70c89b2e,0x400,0x70c99b2f,0x400,0x400,0x70c89b2e,0x70c89b2e,0x400,0x0,0x70c89b2e,0x0,0x0,0x0,0x0,0x400,0x20400,0x0,0x0,0x0,0x70c99b2f,0x70c89b2e,0x0,0x0,0x0,0x70c99b2f,0x400,0x400,0x400,0x400,0x400,0x0,0x70c89b2e,0x20400,0x20400,0x0,0x0,0x0,0x0,0x20000,0x20000,0x0,0x400,0x0,0x400,0x0,0x800000,0x800000,0x400,0x0,0x0,0x0,0x0,0x2000,0x400,0x0,0x0,0x400,0x10000000,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x400,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x70c99b2f,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x70c99b2f,0x800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x0,0x400,0x0,0x0,0x70c99b2f,0x80000000,0x0,0x0,0x0,0x0,0x70c99b2e,0x0,0x0,0x80000000,0x0,0x0,0x0,0x19005890,0x400,0x19005890,0x19005890,0x0,0x19005890,0x19005890,0x0,0x0,0x0,0x0,0x0,0x10000,0x10000,0x0,0x400,0x0,0x0,0x0,0x19005890,0x400,0x400,0x4000,0x0,0x0,0x19005890,0x0,0x0,0x19005890,0x4000,0x8000000,0x8000000,0x4000,0x0,0x0,0x70c99b2e,0x0,0x40000000,0x0,0x0,0x70c99b2f,0x0,0x4,0x0,0xc00020,0x0,0xc00024,0x0,0x20,0x20,0x20,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x9000800,0x10005090,0x40000000,0x70c89b2e,0x0,0x70c89b2e,0x400,0x400,0x0,0x400,0x0,0x0,0x0,0x0,0x0,0x19005890,0x0,0x42000000,0x42000000,0x0,0x0,0x0,0x0,0x70c99b2e,0x400,0x0,0x0,0x0,0x0,0x0,0x8000000,0x8000000,0x0,0x8000000,0x8000000,0x0,0x0,0x0,0x0,0x0,0x10,0x70c9db2e,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x4100,0x0,0x0,0x0,0x1008,0x0,0x400,0x800,0x0,0x800,0x0,0x800,0x0,0x40000040,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x400,0x8000000,0x8000000,0x400,0x8000000,0x80000,0x0,0x0,0x80000,0x0,0x0,0x0,0x0,0x80000,0x0,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_2() {
	   jj_la1_2 = new int[] {0x0,0x0,0x0,0x0,0x6020,0x10000,0x0,0x16020,0x16020,0x16020,0x0,0x16020,0x0,0x16020,0x16020,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x8e41359,0x0,0x0,0x8e41359,0x8e41349,0x400000,0x400000,0x0,0x0,0x8000000,0x8000000,0x20000,0x20000000,0x10000000,0x10000000,0x0,0x0,0x0,0x0,0x0,0x8e41359,0x8e41359,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8e41349,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x18e41359,0x0,0x0,0x0,0x0,0x0,0x8e41359,0x8e41349,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8e41349,0x8e41349,0x8e41349,0x8e41359,0x18e41359,0x8e41349,0x0,0x0,0x0,0x0,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x0,0x0,0x0,0x0,0x800,0x0,0x0,0x0,0x0,0x0,0x800,0x0,0x0,0x0,0x0,0x0,0x8e41349,0x0,0x0,0x8e41349,0x10,0x0,0x10,0x0,0x0,0x2000000,0x0,0x0,0x0,0x8e41349,0x0,0x8e41359,0x0,0x0,0x8e41349,0x8e41349,0x0,0x0,0x8e41349,0x0,0x0,0x1000,0x1000,0x0,0x20000000,0x0,0x800,0x0,0x8e41359,0x8e41349,0x0,0x0,0x2000000,0x8e41359,0x0,0x0,0x0,0x0,0x0,0x0,0x8e41349,0x20000000,0x20000000,0x0,0x0,0x20000000,0x0,0x20000000,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x0,0x0,0x0,0x0,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000,0x0,0x0,0x0,0x0,0x0,0x400,0x0,0x400,0x0,0x0,0x0,0x400000,0x0,0x0,0x0,0x0,0x10000000,0x10000000,0x11000000,0x1000000,0x11000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8e41359,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8e41359,0x0,0x200000,0x0,0x0,0x0,0x0,0x0,0x100000,0x0,0x0,0x800000,0x800000,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x6000,0x0,0x0,0x0,0x0,0x0,0x8e41359,0x0,0x0,0x0,0x0,0x0,0x8e41349,0x0,0x0,0x0,0x0,0x0,0x0,0x4401020,0x0,0x4401020,0x4401020,0x0,0x4401020,0x4401020,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4401020,0x0,0x0,0x0,0x0,0x0,0x4401020,0x0,0x40000000,0x4401020,0x0,0x0,0x0,0x0,0x0,0x0,0x8e41349,0x0,0x100,0x0,0x0,0x8e41359,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000020,0x401000,0x100,0x8e41349,0x0,0x8e41349,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4401020,0x0,0x100,0x100,0x0,0x0,0x0,0x0,0x8e41349,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000000,0xce41349,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x0,0x0,0x0,0x6,0x0,0x6,0x0,0x6,0x2000100,0x0,0x0,0x0,0x0,0x2000000,0x2000000,0x0,0x0,0x4020,0x4020,0x0,0x4020,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,};
	}
	private static void jj_la1_init_3() {
	   jj_la1_3 = new int[] {0x0,0x0,0x80000,0x80000,0x0,0x2,0x0,0x80002,0x80002,0x80002,0x0,0x80002,0x0,0x80002,0x80002,0x0,0x0,0x0,0x0,0x4200000,0x0,0x0,0x75292604,0x0,0x0,0x75292604,0x75290004,0x0,0x0,0x4000000,0x4000000,0x0,0x0,0x0,0x0,0x2000,0x2000,0x0,0x0,0x0,0x0,0x0,0x75292604,0x75292604,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x80,0x800,0x400000,0x0,0x75090000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x75292604,0x0,0x0,0x0,0x0,0x0,0x75292604,0x75290000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x75090000,0x75290004,0x75290000,0x75292604,0x75292604,0x75290000,0x0,0x40000,0x0,0x400000,0x0,0x0,0x0,0x0,0x4,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x0,0x0,0x0,0x0,0x0,0x100000,0x0,0x0,0x0,0x0,0x0,0x75290000,0x0,0x0,0x75290000,0x4200000,0x0,0x4200000,0x10000,0x0,0x800,0x10010000,0x0,0x0,0x75290000,0x0,0x75292604,0x0,0x0,0x75290000,0x75290000,0x0,0x0,0x75290000,0x0,0x0,0x4000,0x4000,0x0,0x2060000,0x0,0x100000,0x0,0xf5292604,0x75290000,0x0,0x0,0x800,0xf5292604,0x0,0x0,0x0,0x0,0x0,0x0,0x75290000,0x2060000,0x2060000,0x0,0x0,0x0,0x0,0x20000,0x20000,0x0,0x2040000,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x40000000,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0x0,0x0,0x1800000,0x0,0x0,0x0,0x0,0x0,0x0,0x2000,0x2000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x75292604,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x75292604,0x0,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x75292604,0x0,0x0,0x0,0x0,0x800,0x75290004,0x0,0x0,0x0,0x0,0x0,0x0,0x10002000,0x0,0x10002000,0x10002000,0x0,0x10002000,0x10002000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x10002000,0x0,0x0,0x0,0x10000000,0x0,0x10002000,0x0,0x0,0x10002000,0x0,0x0,0x0,0x0,0x0,0x0,0x75290004,0x0,0x0,0x0,0x0,0x75292604,0x0,0x0,0x0,0x4200000,0x0,0x4200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x2000,0x0,0x75090000,0x0,0x75090000,0x0,0x0,0x0,0x0,0x10000,0x0,0x0,0x0,0x0,0x10002000,0x0,0x0,0x0,0x0,0x0,0x10010000,0x0,0x75290004,0x0,0x10010000,0x0,0x10010000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10010000,0x10010000,0x0,0x10000000,0x75290004,0x0,0x0,0x0,0x0,0x0,0x200,0x0,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x0,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x80000,0x0,0x80000,0x8008001,0x0,0x0,0x0,0x0,0x0,0x8000000,0x1,0x8008001,0x0,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_4() {
	   jj_la1_4 = new int[] {0x0,0x0,0x800,0x800,0x0,0x0,0x0,0x800,0x800,0x800,0x0,0x800,0x0,0x800,0x800,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x808c021b,0x0,0x0,0x808c021b,0x808c0211,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x4,0x0,0x0,0x0,0x808c021b,0x808c021b,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x40,0x0,0x0,0x0,0x808c0211,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x808c021b,0x0,0x0,0x0,0x0,0x8,0x808c021b,0x808c0211,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x808c0211,0x808c0211,0x808c0211,0x808c021b,0x808c021b,0x808c0211,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0x0,0x0,0x0,0x808c0211,0x0,0x0,0x808c0211,0x0,0x0,0x0,0x800000,0x0,0x0,0x0,0x0,0x0,0x808c0211,0x0,0x808c021b,0x0,0x0,0x808c0211,0x808c0211,0x0,0x0,0x808c0211,0x0,0x0,0x0,0x0,0x0,0x10002,0x0,0x1000,0x0,0x808c021b,0x808c0211,0x0,0x0,0x0,0x808c021b,0x0,0x0,0x0,0x0,0x0,0x0,0x808c0211,0x10002,0x10002,0x0,0x0,0x0,0x0,0x10002,0x10002,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x8,0x40000000,0x0,0x0,0x0,0x20000,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x8000000,0x8000000,0x8000000,0x0,0x0,0x8000000,0x8000000,0x8000000,0x8000000,0x0,0x8000000,0x0,0x0,0x8000000,0x8000000,0x0,0x0,0x8000000,0x8000000,0x8000000,0x4,0x0,0x8000000,0x0,0x8000000,0x0,0x8000000,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x8000000,0x0,0x0,0x0,0x0,0x0,0x40000000,0x0,0x0,0x0,0x0,0x0,0x808c021b,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x808c021b,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x808c021b,0x0,0x0,0x0,0x0,0x0,0x808c0211,0x0,0x0,0x0,0x0,0x0,0x0,0x48000000,0x0,0x48000000,0x48000000,0x0,0x48000000,0x48000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x48000000,0x0,0x0,0x0,0x0,0x0,0x48000000,0x0,0x0,0x48000000,0x0,0x0,0x0,0x0,0x0,0x0,0x808c0211,0x0,0x0,0x0,0x0,0x808c021b,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x80000,0x0,0x0,0x200,0x0,0x0,0x40000000,0x80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x48000000,0x0,0x0,0x808c0211,0x0,0x808c0211,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x48000000,0x8000000,0x28000000,0x28000000,0x4000,0x0,0x0,0x0,0x808c0211,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x808c0211,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0x0,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7702400,0x1000400,0x2002000,0x200000,0x100000,0x4000000,0x400000,0x0,0x7702400,0x0,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_5() {
	   jj_la1_5 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6f8fd5a,0x0,0x0,0x6f8fd5a,0x638f552,0x14,0x14,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6f8fd5a,0x6f8fd5a,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x638f442,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x6f8fd5a,0x0,0x0,0x0,0x100,0x0,0x6f8fd5a,0x638f442,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x638f442,0x638f552,0x638f442,0x6f8fd5a,0x6f8fd5a,0x638f442,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x8000000,0x0,0x0,0x0,0x638f442,0x0,0x0,0x638f442,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x638f442,0x0,0x6f8fd5a,0x0,0x0,0x638f442,0x638f442,0x0,0x0,0x638f442,0x0,0x0,0x0,0x0,0x0,0x200,0x0,0x0,0x0,0x6f8fd5a,0x638f442,0x10000,0x10000,0x0,0x6f8fd5a,0x0,0x0,0x0,0x0,0x0,0x0,0x638f442,0x200,0x200,0x200,0x200,0x0,0x200,0x200,0x200,0x200,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x60000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6f8fd5a,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6f8fd5a,0x0,0x0,0x400,0x0,0x2000,0x100,0x2000000,0x400,0x2000000,0x0,0x40000,0x40000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6f8fd5a,0x0,0x100,0x100,0x0,0x0,0x638f552,0x0,0x100,0x0,0x100,0x0,0x0,0x10103010,0x0,0x10103010,0x10103010,0x0,0x10103010,0x10103010,0x0,0x0,0x0,0x0,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10103010,0x0,0x0,0x0,0x0,0x100000,0x10103010,0x0,0x0,0x10103010,0x0,0x0,0x0,0x0,0x0,0x0,0x638f552,0x0,0x0,0x0,0x0,0x6f8fd5a,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10100010,0x3000,0x0,0x638f442,0x0,0x638f442,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10103010,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x638f552,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x638f552,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x20,0x0,0x0,0x1000000,0x1000,0x1000000,0x1000,0x1000000,0x0,0x1000,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x100,0x80,0x400000,0x80,0x800000,};
	}
	private static void jj_la1_init_6() {
	   jj_la1_6 = new int[] {0x0,0x0,0x400,0x400,0x18000,0x40120,0x0,0x58521,0x58521,0x58521,0x0,0x58521,0x0,0x58521,0x58521,0x0,0x0,0x0,0x0,0x4008000,0x4000,0x0,0xcf68f2d1,0x0,0x0,0xcf68f2d1,0xcf6872c1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xcf68f2d1,0xcf68f2d1,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x8400,0x0,0x0,0x0,0x0,0x0,0x0,0xc66872c1,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x0,0x8400,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x400,0x0,0x0,0x0,0xcf68f2d1,0x0,0x0,0x0,0x0,0x0,0xcf68f2d1,0xc66872c1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc66872c1,0xcf6872c1,0xc66872c1,0xcf68f2d1,0xcf68f6d1,0xc66872c1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x0,0x0,0x0,0x0,0x0,0x400,0x400,0x0,0x0,0x0,0x400,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc66872c1,0x0,0x0,0xc66872c1,0x8000,0x0,0x8000,0x0,0x0,0x40000,0x0,0x0,0x0,0xc66872c1,0x0,0xcf68f2d1,0x0,0x0,0xc66872c1,0xc66872c1,0x0,0x0,0xc66872c1,0x400,0x0,0x0,0x0,0x0,0x10,0x400,0x0,0x0,0xcf68f2d1,0xc66872c1,0x0,0x0,0x40000,0xcf68f2d1,0x0,0x0,0x0,0x0,0x0,0x0,0xc66872c1,0x10,0x10,0x800,0x800,0x10,0x0,0x10,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0x0,0x1000000,0x1000000,0x0,0x0,0x80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc0,0xc0,0x0,0x0,0xc0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xcf68f2d1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xcf68f2d1,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0xcf68f2d1,0x0,0x0,0x0,0x400,0x0,0xcf6872c1,0x0,0x0,0x0,0x0,0x2000,0x0,0xd0000080,0x0,0xd0000080,0xd0000080,0x0,0xd0000080,0xd0000080,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xd0000080,0x0,0x0,0x0,0x0,0x0,0xd0000080,0x0,0x0,0xd0000080,0x0,0x0,0x0,0x0,0x0,0x0,0xcf6872c1,0x0,0x0,0x400,0x0,0xcf68f2d1,0x0,0x0,0x0,0x8000,0x0,0x8000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc0000000,0xc0000000,0x0,0x0,0x0,0x0,0x8004,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0xd0000000,0x0,0xc66872c1,0x0,0xc66872c1,0x0,0x0,0x0,0x0,0x4001200,0x4,0x4,0x0,0x0,0xd0000080,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xcf6872c1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xcf6872c1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x0,0x2,0x0,0x2,0x0,0x8000,0x0,0x0,0x0,0x100,0x0,0x0,0x4000000,0x0,0x400,0x400,0x0,0x400,0x1004000,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x1004000,0x0,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_7() {
	   jj_la1_7 = new int[] {0x0,0x0,0x1004000,0x100c000,0x20,0x10000,0x0,0x101c020,0x101c020,0x101c020,0x0,0x101c020,0x0,0x101c020,0x101c020,0x0,0x0,0x0,0x0,0x300000,0x0,0x0,0x9f0016e,0x0,0x0,0x9f0016e,0x9f0016e,0x40,0x40,0x0,0x0,0x4000000,0x4000000,0x0,0x0,0x0,0x0,0x40000000,0x40000000,0x0,0x0,0x0,0x9f0016e,0x9f0016e,0x0,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x1800000,0x1800000,0x0,0x0,0x0,0x1000000,0x1800000,0x0,0x0,0x0,0x0,0x0,0x0,0x8700166,0x0,0x1800000,0x1800000,0x0,0x0,0x0,0x1000000,0x0,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x1800000,0x1800000,0x0,0x0,0x0,0x1000000,0x1000000,0x0,0x0,0x0,0x9f0016e,0x0,0x80000,0x40000000,0x0,0x0,0x9f0016e,0x9f0016e,0x20000000,0x20000000,0x20000000,0x20000000,0x0,0x40000000,0x0,0x0,0x0,0x0,0x40000000,0x0,0x0,0x8700166,0x9f0016e,0x9f0016e,0x9f0016e,0x9f0016e,0x9f0016e,0x0,0x0,0x60800,0x0,0x0,0x80000000,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x1000000,0x0,0x0,0x400,0x1000000,0x1000000,0x0,0x0,0x0,0x400,0x0,0x0,0x0,0x0,0x0,0x9f0016e,0x0,0x0,0x9f0016e,0x300000,0x0,0x300000,0x0,0x0,0x10000,0x0,0x0,0x0,0x9f0016e,0x0,0x9f0016e,0x0,0x0,0x9f0016e,0x9f0016e,0x0,0x0,0x9f0016e,0x1000000,0x0,0x0,0x0,0x0,0x0,0x1000000,0x400,0x0,0x9f0016e,0x9f0016e,0x0,0x0,0x10000,0x9f0016e,0x0,0x0,0x0,0x0,0x0,0x0,0x9f0016e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x9f0016e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x9f0016e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x9f0016e,0x800,0x0,0x0,0x1000000,0x0,0x9f0016e,0x0,0x0,0x0,0x0,0x0,0x0,0x40284941,0x0,0x40284941,0x40284941,0x80000,0x40284941,0x40284941,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x40284941,0x0,0x0,0x0,0x0,0x800,0x40284941,0x800,0x0,0x40284941,0x0,0x4000,0x4000,0x0,0x0,0x0,0x9f0016e,0x0,0x0,0x1000000,0x0,0x9f0016e,0x0,0x0,0x2000000,0x0,0x0,0x200000,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4801,0x40280140,0x0,0x8700166,0x0,0x8700166,0x0,0x0,0x0,0x0,0x8000000,0x0,0x0,0x0,0x100,0x40284941,0x0,0x400000,0x400000,0x0,0x80000,0x0,0x80000,0x9f0016e,0x0,0x0,0x0,0x0,0x80000,0x0,0x4000,0x4000,0x0,0x4000,0x4000,0x80000,0x0,0x0,0x0,0x80000,0x800,0x9f0096e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x4,0x8000000,0x0,0x4000,0x4000,0x0,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_8() {
	   jj_la1_8 = new int[] {0x800,0x1,0x80000000,0x80000001,0x0,0x0,0x800,0x80000001,0x80000001,0x80000001,0x800,0x80000001,0x800,0x80000001,0x80000001,0x0,0x0,0x0,0x0,0x2020010,0x0,0x0,0x22000410,0x0,0x0,0x22000410,0x22000410,0x0,0x0,0x210,0x210,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xa2000410,0xa2000410,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000001,0x80000001,0x0,0x0,0x0,0x0,0x0,0x0,0x22000410,0x0,0x0,0x0,0x0,0x0,0x0,0x80000001,0x0,0x80000001,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000001,0x80000001,0x0,0x0,0x0,0x22000410,0x0,0x0,0x0,0x0,0x0,0xa2000410,0x32000410,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x22000410,0x22000410,0x22000410,0x22000410,0x22000410,0x32000410,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x80000000,0x0,0x32000410,0x0,0x0,0x32000410,0x2020010,0x0,0x2020010,0x0,0x0,0x0,0x0,0x0,0x22000000,0x32000410,0x0,0xa2000410,0x0,0x0,0x32000410,0x32000410,0x0,0x80000000,0x32000410,0x80000000,0x80000000,0x0,0x0,0x0,0x0,0x80000001,0x0,0x80000000,0x22000410,0x32000410,0x0,0x0,0x1,0xa2000410,0x0,0x0,0x0,0x0,0x0,0x80000000,0x32000410,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x2,0x2000000,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x80000,0x0,0x80000,0x80000,0x0,0x0,0x0,0x80000,0x0,0x80080000,0x2080000,0x0,0x2080000,0x20,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x80000000,0x0,0x80000000,0x0,0x0,0x0,0x1f000,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x40,0x2c0000,0x0,0x32000410,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10080000,0x10080000,0x0,0x0,0x0,0x100c0000,0x0,0x22000410,0x2000000,0x0,0x2,0x80000000,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x22000410,0x0,0x0,0x0,0x80000001,0x0,0x22000410,0x0,0x0,0x0,0x0,0x0,0x1,0xb20c0001,0x0,0xb20c0001,0xb20c0001,0x0,0xb20c0001,0xb20c0001,0x22000000,0x22000000,0x22000000,0x0,0x0,0x0,0x0,0x22000000,0x0,0x22000000,0x0,0x0,0xb20c0001,0x0,0x0,0x0,0x0,0x0,0xb20c0001,0x0,0x0,0xb20c0001,0x0,0x0,0x0,0x0,0x80000000,0x80000000,0x22000410,0x80000000,0x0,0x80000001,0x0,0x22000410,0x0,0x0,0x0,0x2020010,0x0,0x2020010,0x0,0x12080000,0x0,0x12080000,0x0,0x80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x1,0x0,0x0,0x0,0x80000000,0x22000000,0x22000000,0x0,0x0,0x0,0xc0000,0x320c0000,0x80000001,0x0,0x320c0410,0x100c0000,0x320c0410,0x0,0x0,0x80000000,0x0,0x2000000,0x2000000,0x2000000,0x0,0x0,0xb20c0001,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x22000410,0x0,0x0,0x22000000,0x0,0x0,0x80000000,0x0,0x0,0x80000000,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0xa2000410,0x0,0x22000000,0x22000000,0x0,0x22000000,0x0,0x22000000,0x22000000,0x0,0x22000000,0x22000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x12080000,0x12080000,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_9() {
	   jj_la1_9 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x2,0x0,0x0,0x2,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x18,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x30,0x30,0x0,0x30,0x30,0x0,0x0,0x0,0x20,0x0,0x30,0x20,0x0,0x20,0x0,0x0,0x40,0x40,0x40,0x0,0x0,0x40,0x40,0x40,0x40,0x0,0x0,0x0,0x0,0x1ffe22,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200002,0x3c00000,0x3c00000,0x80080,0xc000004,0x10000000,0x10,0x40,0x40,0x80880,0x80880,0x0,0x0,0x8,0x0,0x20,0x400,0x0,0x0,0x0,0x80000000,0x0,0x20000000,0x0,0x0,0x400,0x8,0x20000000,0x0,0x20000000,0x0,0x0,0x0,0x0,0x0,0x80000,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x80082,0x0,0x80082,0x80082,0x0,0x80082,0x80082,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80082,0x0,0x0,0x0,0x0,0x0,0x80082,0x0,0x0,0x80082,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x80080,0x80080,0x0,0x80082,0x0,0x0,0x0,0x0,0x0,0x2,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80082,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_10() {
	   jj_la1_10 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x6,0x0,0x0,0x8,0x0,0x10,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x1e0,0x1e0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1e00,0x1e00,0x2000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x8,0x8,0x0,0x8,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
	}
  final private JJCalls[] jj_2_rtns = new JJCalls[202];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor. */
  public CCJSqlParser(Provider stream) {
	 jj_input_stream = new SimpleCharStream(stream, 1, 1);
	 token_source = new CCJSqlParserTokenManager(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 517; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public CCJSqlParser(String dsl) throws ParseException, TokenMgrException {
	   this(new StringProvider(dsl));
  }

  public void ReInit(String s) {
	  ReInit(new StringProvider(s));
  }
  /** Reinitialise. */
  public void ReInit(Provider stream) {
	if (jj_input_stream == null) {
	   jj_input_stream = new SimpleCharStream(stream, 1, 1);
	} else {
	   jj_input_stream.ReInit(stream, 1, 1);
	}
	if (token_source == null) {
 token_source = new CCJSqlParserTokenManager(jj_input_stream);
	}

	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jjtree.reset();
	 jj_gen = 0;
	 for (int i = 0; i < 517; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public CCJSqlParser(CCJSqlParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 517; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(CCJSqlParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jjtree.reset();
	 jj_gen = 0;
	 for (int i = 0; i < 517; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
	 Token oldToken;
	 if ((oldToken = token).next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 if (token.kind == kind) {
	   jj_gen++;
	   if (++jj_gc > 100) {
		 jj_gc = 0;
		 for (int i = 0; i < jj_2_rtns.length; i++) {
		   JJCalls c = jj_2_rtns[i];
		   while (c != null) {
			 if (c.gen < jj_gen) c.first = null;
			 c = c.next;
		   }
		 }
	   }
	   return token;
	 }
	 token = oldToken;
	 jj_kind = kind;
	 throw generateParseException();
  }

  @SuppressWarnings("serial")
  static private final class LookaheadSuccess extends java.lang.RuntimeException {
    @Override
    public Throwable fillInStackTrace() {
      return this;
    }
  }
  static private final LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
	 if (jj_scanpos == jj_lastpos) {
	   jj_la--;
	   if (jj_scanpos.next == null) {
		 jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
	   } else {
		 jj_lastpos = jj_scanpos = jj_scanpos.next;
	   }
	 } else {
	   jj_scanpos = jj_scanpos.next;
	 }
	 if (jj_rescan) {
	   int i = 0; Token tok = token;
	   while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
	   if (tok != null) jj_add_error_token(kind, i);
	 }
	 if (jj_scanpos.kind != kind) return true;
	 if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
	 return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
	 if (token.next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 jj_gen++;
	 return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
	 Token t = jj_lookingAhead ? jj_scanpos : token;
	 for (int i = 0; i < index; i++) {
	   if (t.next != null) t = t.next;
	   else t = t.next = token_source.getNextToken();
	 }
	 return t;
  }

  private int jj_ntk_f() {
	 if ((jj_nt=token.next) == null)
	   return (jj_ntk = (token.next=token_source.getNextToken()).kind);
	 else
	   return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
	 if (pos >= 100) {
		return;
	 }

	 if (pos == jj_endpos + 1) {
	   jj_lasttokens[jj_endpos++] = kind;
	 } else if (jj_endpos != 0) {
	   jj_expentry = new int[jj_endpos];

	   for (int i = 0; i < jj_endpos; i++) {
		 jj_expentry[i] = jj_lasttokens[i];
	   }

	   for (int[] oldentry : jj_expentries) {
		 if (oldentry.length == jj_expentry.length) {
		   boolean isMatched = true;

		   for (int i = 0; i < jj_expentry.length; i++) {
			 if (oldentry[i] != jj_expentry[i]) {
			   isMatched = false;
			   break;
			 }

		   }
		   if (isMatched) {
			 jj_expentries.add(jj_expentry);
			 break;
		   }
		 }
	   }

	   if (pos != 0) {
		 jj_lasttokens[(jj_endpos = pos) - 1] = kind;
	   }
	 }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
	 jj_expentries.clear();
	 boolean[] la1tokens = new boolean[334];
	 if (jj_kind >= 0) {
	   la1tokens[jj_kind] = true;
	   jj_kind = -1;
	 }
	 for (int i = 0; i < 517; i++) {
	   if (jj_la1[i] == jj_gen) {
		 for (int j = 0; j < 32; j++) {
		   if ((jj_la1_0[i] & (1<<j)) != 0) {
			 la1tokens[j] = true;
		   }
		   if ((jj_la1_1[i] & (1<<j)) != 0) {
			 la1tokens[32+j] = true;
		   }
		   if ((jj_la1_2[i] & (1<<j)) != 0) {
			 la1tokens[64+j] = true;
		   }
		   if ((jj_la1_3[i] & (1<<j)) != 0) {
			 la1tokens[96+j] = true;
		   }
		   if ((jj_la1_4[i] & (1<<j)) != 0) {
			 la1tokens[128+j] = true;
		   }
		   if ((jj_la1_5[i] & (1<<j)) != 0) {
			 la1tokens[160+j] = true;
		   }
		   if ((jj_la1_6[i] & (1<<j)) != 0) {
			 la1tokens[192+j] = true;
		   }
		   if ((jj_la1_7[i] & (1<<j)) != 0) {
			 la1tokens[224+j] = true;
		   }
		   if ((jj_la1_8[i] & (1<<j)) != 0) {
			 la1tokens[256+j] = true;
		   }
		   if ((jj_la1_9[i] & (1<<j)) != 0) {
			 la1tokens[288+j] = true;
		   }
		   if ((jj_la1_10[i] & (1<<j)) != 0) {
			 la1tokens[320+j] = true;
		   }
		 }
	   }
	 }
	 for (int i = 0; i < 334; i++) {
	   if (la1tokens[i]) {
		 jj_expentry = new int[1];
		 jj_expentry[0] = i;
		 jj_expentries.add(jj_expentry);
	   }
	 }
	 jj_endpos = 0;
	 jj_rescan_token();
	 jj_add_error_token(0, 0);
	 int[][] exptokseq = new int[jj_expentries.size()][];
	 for (int i = 0; i < jj_expentries.size(); i++) {
	   exptokseq[i] = jj_expentries.get(i);
	 }
	 return new ParseException(token, exptokseq, tokenImage, token_source == null ? null : CCJSqlParserTokenManager.lexStateNames[token_source.curLexState]);
  }

  private boolean trace_enabled;

/** Trace enabled. */
  final public boolean trace_enabled() {
	 return trace_enabled;
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
	 jj_rescan = true;
	 for (int i = 0; i < 202; i++) {
	   try {
		 JJCalls p = jj_2_rtns[i];

		 do {
		   if (p.gen > jj_gen) {
			 jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
			 switch (i) {
			   case 0: jj_3_1(); break;
			   case 1: jj_3_2(); break;
			   case 2: jj_3_3(); break;
			   case 3: jj_3_4(); break;
			   case 4: jj_3_5(); break;
			   case 5: jj_3_6(); break;
			   case 6: jj_3_7(); break;
			   case 7: jj_3_8(); break;
			   case 8: jj_3_9(); break;
			   case 9: jj_3_10(); break;
			   case 10: jj_3_11(); break;
			   case 11: jj_3_12(); break;
			   case 12: jj_3_13(); break;
			   case 13: jj_3_14(); break;
			   case 14: jj_3_15(); break;
			   case 15: jj_3_16(); break;
			   case 16: jj_3_17(); break;
			   case 17: jj_3_18(); break;
			   case 18: jj_3_19(); break;
			   case 19: jj_3_20(); break;
			   case 20: jj_3_21(); break;
			   case 21: jj_3_22(); break;
			   case 22: jj_3_23(); break;
			   case 23: jj_3_24(); break;
			   case 24: jj_3_25(); break;
			   case 25: jj_3_26(); break;
			   case 26: jj_3_27(); break;
			   case 27: jj_3_28(); break;
			   case 28: jj_3_29(); break;
			   case 29: jj_3_30(); break;
			   case 30: jj_3_31(); break;
			   case 31: jj_3_32(); break;
			   case 32: jj_3_33(); break;
			   case 33: jj_3_34(); break;
			   case 34: jj_3_35(); break;
			   case 35: jj_3_36(); break;
			   case 36: jj_3_37(); break;
			   case 37: jj_3_38(); break;
			   case 38: jj_3_39(); break;
			   case 39: jj_3_40(); break;
			   case 40: jj_3_41(); break;
			   case 41: jj_3_42(); break;
			   case 42: jj_3_43(); break;
			   case 43: jj_3_44(); break;
			   case 44: jj_3_45(); break;
			   case 45: jj_3_46(); break;
			   case 46: jj_3_47(); break;
			   case 47: jj_3_48(); break;
			   case 48: jj_3_49(); break;
			   case 49: jj_3_50(); break;
			   case 50: jj_3_51(); break;
			   case 51: jj_3_52(); break;
			   case 52: jj_3_53(); break;
			   case 53: jj_3_54(); break;
			   case 54: jj_3_55(); break;
			   case 55: jj_3_56(); break;
			   case 56: jj_3_57(); break;
			   case 57: jj_3_58(); break;
			   case 58: jj_3_59(); break;
			   case 59: jj_3_60(); break;
			   case 60: jj_3_61(); break;
			   case 61: jj_3_62(); break;
			   case 62: jj_3_63(); break;
			   case 63: jj_3_64(); break;
			   case 64: jj_3_65(); break;
			   case 65: jj_3_66(); break;
			   case 66: jj_3_67(); break;
			   case 67: jj_3_68(); break;
			   case 68: jj_3_69(); break;
			   case 69: jj_3_70(); break;
			   case 70: jj_3_71(); break;
			   case 71: jj_3_72(); break;
			   case 72: jj_3_73(); break;
			   case 73: jj_3_74(); break;
			   case 74: jj_3_75(); break;
			   case 75: jj_3_76(); break;
			   case 76: jj_3_77(); break;
			   case 77: jj_3_78(); break;
			   case 78: jj_3_79(); break;
			   case 79: jj_3_80(); break;
			   case 80: jj_3_81(); break;
			   case 81: jj_3_82(); break;
			   case 82: jj_3_83(); break;
			   case 83: jj_3_84(); break;
			   case 84: jj_3_85(); break;
			   case 85: jj_3_86(); break;
			   case 86: jj_3_87(); break;
			   case 87: jj_3_88(); break;
			   case 88: jj_3_89(); break;
			   case 89: jj_3_90(); break;
			   case 90: jj_3_91(); break;
			   case 91: jj_3_92(); break;
			   case 92: jj_3_93(); break;
			   case 93: jj_3_94(); break;
			   case 94: jj_3_95(); break;
			   case 95: jj_3_96(); break;
			   case 96: jj_3_97(); break;
			   case 97: jj_3_98(); break;
			   case 98: jj_3_99(); break;
			   case 99: jj_3_100(); break;
			   case 100: jj_3_101(); break;
			   case 101: jj_3_102(); break;
			   case 102: jj_3_103(); break;
			   case 103: jj_3_104(); break;
			   case 104: jj_3_105(); break;
			   case 105: jj_3_106(); break;
			   case 106: jj_3_107(); break;
			   case 107: jj_3_108(); break;
			   case 108: jj_3_109(); break;
			   case 109: jj_3_110(); break;
			   case 110: jj_3_111(); break;
			   case 111: jj_3_112(); break;
			   case 112: jj_3_113(); break;
			   case 113: jj_3_114(); break;
			   case 114: jj_3_115(); break;
			   case 115: jj_3_116(); break;
			   case 116: jj_3_117(); break;
			   case 117: jj_3_118(); break;
			   case 118: jj_3_119(); break;
			   case 119: jj_3_120(); break;
			   case 120: jj_3_121(); break;
			   case 121: jj_3_122(); break;
			   case 122: jj_3_123(); break;
			   case 123: jj_3_124(); break;
			   case 124: jj_3_125(); break;
			   case 125: jj_3_126(); break;
			   case 126: jj_3_127(); break;
			   case 127: jj_3_128(); break;
			   case 128: jj_3_129(); break;
			   case 129: jj_3_130(); break;
			   case 130: jj_3_131(); break;
			   case 131: jj_3_132(); break;
			   case 132: jj_3_133(); break;
			   case 133: jj_3_134(); break;
			   case 134: jj_3_135(); break;
			   case 135: jj_3_136(); break;
			   case 136: jj_3_137(); break;
			   case 137: jj_3_138(); break;
			   case 138: jj_3_139(); break;
			   case 139: jj_3_140(); break;
			   case 140: jj_3_141(); break;
			   case 141: jj_3_142(); break;
			   case 142: jj_3_143(); break;
			   case 143: jj_3_144(); break;
			   case 144: jj_3_145(); break;
			   case 145: jj_3_146(); break;
			   case 146: jj_3_147(); break;
			   case 147: jj_3_148(); break;
			   case 148: jj_3_149(); break;
			   case 149: jj_3_150(); break;
			   case 150: jj_3_151(); break;
			   case 151: jj_3_152(); break;
			   case 152: jj_3_153(); break;
			   case 153: jj_3_154(); break;
			   case 154: jj_3_155(); break;
			   case 155: jj_3_156(); break;
			   case 156: jj_3_157(); break;
			   case 157: jj_3_158(); break;
			   case 158: jj_3_159(); break;
			   case 159: jj_3_160(); break;
			   case 160: jj_3_161(); break;
			   case 161: jj_3_162(); break;
			   case 162: jj_3_163(); break;
			   case 163: jj_3_164(); break;
			   case 164: jj_3_165(); break;
			   case 165: jj_3_166(); break;
			   case 166: jj_3_167(); break;
			   case 167: jj_3_168(); break;
			   case 168: jj_3_169(); break;
			   case 169: jj_3_170(); break;
			   case 170: jj_3_171(); break;
			   case 171: jj_3_172(); break;
			   case 172: jj_3_173(); break;
			   case 173: jj_3_174(); break;
			   case 174: jj_3_175(); break;
			   case 175: jj_3_176(); break;
			   case 176: jj_3_177(); break;
			   case 177: jj_3_178(); break;
			   case 178: jj_3_179(); break;
			   case 179: jj_3_180(); break;
			   case 180: jj_3_181(); break;
			   case 181: jj_3_182(); break;
			   case 182: jj_3_183(); break;
			   case 183: jj_3_184(); break;
			   case 184: jj_3_185(); break;
			   case 185: jj_3_186(); break;
			   case 186: jj_3_187(); break;
			   case 187: jj_3_188(); break;
			   case 188: jj_3_189(); break;
			   case 189: jj_3_190(); break;
			   case 190: jj_3_191(); break;
			   case 191: jj_3_192(); break;
			   case 192: jj_3_193(); break;
			   case 193: jj_3_194(); break;
			   case 194: jj_3_195(); break;
			   case 195: jj_3_196(); break;
			   case 196: jj_3_197(); break;
			   case 197: jj_3_198(); break;
			   case 198: jj_3_199(); break;
			   case 199: jj_3_200(); break;
			   case 200: jj_3_201(); break;
			   case 201: jj_3_202(); break;
			 }
		   }
		   p = p.next;
		 } while (p != null);

		 } catch(LookaheadSuccess ls) { }
	 }
	 jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
	 JJCalls p = jj_2_rtns[index];
	 while (p.gen > jj_gen) {
	   if (p.next == null) { p = p.next = new JJCalls(); break; }
	   p = p.next;
	 }

	 p.gen = jj_gen + xla - jj_la; 
	 p.first = token;
	 p.arg = xla;
  }

  static final class JJCalls {
	 int gen;
	 Token first;
	 int arg;
	 JJCalls next;
  }

}
