/*-
 * #%L
 * JSQLParser library
 * %%
 * Copyright (C) 2004 - 2021 JSQLParser
 * %%
 * Dual licensed under GNU LGPL 2.1 or Apache License 2.0
 * #L%
 */
/* CCJSqlParser.java */
/* Generated By:JJTree&JavaCC: Do not edit this line. CCJSqlParser.java */
package net.sf.jsqlparser.parser;

import net.sf.jsqlparser.parser.feature.*;
import net.sf.jsqlparser.expression.*;
import net.sf.jsqlparser.expression.operators.arithmetic.*;
import net.sf.jsqlparser.expression.operators.conditional.*;
import net.sf.jsqlparser.expression.operators.relational.*;
import net.sf.jsqlparser.schema.*;
import net.sf.jsqlparser.statement.*;
import net.sf.jsqlparser.statement.alter.*;
import net.sf.jsqlparser.statement.alter.sequence.*;
import net.sf.jsqlparser.statement.comment.*;
import net.sf.jsqlparser.statement.create.function.*;
import net.sf.jsqlparser.statement.create.index.*;
import net.sf.jsqlparser.statement.create.procedure.*;
import net.sf.jsqlparser.statement.create.schema.*;
import net.sf.jsqlparser.statement.create.synonym.*;
import net.sf.jsqlparser.statement.create.sequence.*;
import net.sf.jsqlparser.statement.create.table.*;
import net.sf.jsqlparser.statement.create.view.*;
import net.sf.jsqlparser.statement.delete.*;
import net.sf.jsqlparser.statement.drop.*;
import net.sf.jsqlparser.statement.insert.*;
import net.sf.jsqlparser.statement.replace.*;
import net.sf.jsqlparser.statement.execute.*;
import net.sf.jsqlparser.statement.select.*;
import net.sf.jsqlparser.statement.show.*;
import net.sf.jsqlparser.statement.truncate.*;
import net.sf.jsqlparser.statement.update.*;
import net.sf.jsqlparser.statement.upsert.*;
import net.sf.jsqlparser.statement.merge.*;
import net.sf.jsqlparser.statement.values.*;
import net.sf.jsqlparser.statement.grant.*;
import java.util.*;

/**
 * The parser generated by JavaCC
 */
public class CCJSqlParser extends AbstractJSqlParser<CCJSqlParser>/*@bgen(jjtree)*/implements CCJSqlParserTreeConstants, CCJSqlParserConstants {/*@bgen(jjtree)*/
  protected JJTCCJSqlParserState jjtree = new JJTCCJSqlParserState();
    public CCJSqlParser withConfiguration(FeatureConfiguration configuration) {
        token_source.configuration = configuration;
        return this;
    }

    public FeatureConfiguration getConfiguration() {
        return token_source.configuration;
    }

    public CCJSqlParser me () {
        return this;
    }

    private void linkAST(ASTNodeAccess access, SimpleNode node) {
        access.setASTNode(node);
        node.jjtSetValue(access);
    }

    public Node getASTRoot() {
        return jjtree.rootNode();
    }

  final public Statement Statement() throws ParseException {/*@bgen(jjtree) Statement */
  SimpleNode jjtn000 = new SimpleNode(JJTSTATEMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));Statement stm = null;
    try {
      try {
        stm = SingleStatement();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case ST_SEMICOLON:{
          jj_consume_token(ST_SEMICOLON);
          break;
          }
        default:
          jj_la1[0] = jj_gen;
          ;
        }
        jj_consume_token(0);
      } catch (ParseException e) {
if (errorRecovery) {
            parseErrors.add(e);
            error_skipto(ST_SEMICOLON);
        }
        else
            {if (true) throw e;}
      }
jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          jjtn000.jjtSetLastToken(getToken(0));
return stm;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Statement SingleStatement() throws ParseException {Statement stm = null;
    try {
      if (jj_2_1(3)) {
        stm = Select();
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_VALUES:{
          stm = Values();
          break;
          }
        case K_UPDATE:{
          stm = Update();
          break;
          }
        case K_INSERT:
        case K_WITH:{
          stm = Insert();
          break;
          }
        case K_UPSERT:{
          stm = Upsert();
          break;
          }
        case K_DELETE:{
          stm = Delete();
          break;
          }
        default:
          jj_la1[1] = jj_gen;
          if (jj_2_2(3)) {
            stm = Replace();
          } else if (jj_2_3(2)) {
            stm = AlterTable();
          } else {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_MERGE:{
              stm = Merge();
              break;
              }
            default:
              jj_la1[2] = jj_gen;
              if (jj_2_4(2147483647)) {
                stm = CreateFunctionStatement();
              } else if (jj_2_5(2147483647)) {
                stm = CreateIndex();
              } else if (jj_2_6(2147483647)) {
                stm = CreateSchema();
              } else if (jj_2_7(2147483647)) {
                stm = CreateSequence();
              } else if (jj_2_8(2147483647)) {
                stm = CreateSynonym();
              } else if (jj_2_9(2147483647)) {
                stm = CreateTable();
              } else if (jj_2_10(2147483647)) {
                stm = CreateView();
              } else if (jj_2_11(2147483647)) {
                stm = AlterView();
              } else if (jj_2_12(2147483647)) {
                stm = AlterSequence();
              } else {
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case K_DROP:{
                  stm = Drop();
                  break;
                  }
                case K_TRUNCATE:{
                  stm = Truncate();
                  break;
                  }
                case K_CALL:
                case K_EXEC:
                case K_EXECUTE:{
                  stm = Execute();
                  break;
                  }
                case K_SET:{
                  stm = Set();
                  break;
                  }
                default:
                  jj_la1[3] = jj_gen;
                  if (jj_2_13(2147483647)) {
                    stm = ShowColumns();
                  } else if (jj_2_14(2147483647)) {
                    stm = ShowTables();
                  } else {
                    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                    case K_SHOW:{
                      stm = Show();
                      break;
                      }
                    case K_USE:{
                      stm = Use();
                      break;
                      }
                    case K_COMMIT:{
                      stm = Commit();
                      break;
                      }
                    case K_COMMENT:{
                      stm = Comment();
                      break;
                      }
                    case K_DESCRIBE:{
                      stm = Describe();
                      break;
                      }
                    case K_EXPLAIN:{
                      stm = Explain();
                      break;
                      }
                    case K_DECLARE:{
                      stm = Declare();
                      break;
                      }
                    case K_GRANT:{
                      stm = Grant();
                      break;
                      }
                    default:
                      jj_la1[4] = jj_gen;
                      jj_consume_token(-1);
                      throw new ParseException();
                    }
                  }
                }
              }
            }
          }
        }
      }
return stm;
    } catch (ParseException e) {
if (errorRecovery) {
            parseErrors.add(e);
            error_skipto(ST_SEMICOLON);
                        return null;
        }
        else
            {if (true) throw e;}
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Block Block() throws ParseException {/*@bgen(jjtree) Block */
    SimpleNode jjtn000 = new SimpleNode(JJTBLOCK);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Statements stmts = new Statements();
    List<Statement> list = new ArrayList<Statement>();
    Statement stm;
    Block block = new Block();
    try {
      jj_consume_token(K_BEGIN);
      label_1:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case ST_SEMICOLON:{
          ;
          break;
          }
        default:
          jj_la1[5] = jj_gen;
          break label_1;
        }
        jj_consume_token(ST_SEMICOLON);
      }
      try {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ALTER:
        case K_CALL:
        case K_COMMIT:
        case K_COMMENT:
        case K_CREATE:
        case K_DECLARE:
        case K_DELETE:
        case K_DESCRIBE:
        case K_DROP:
        case K_EXEC:
        case K_EXECUTE:
        case K_EXPLAIN:
        case K_GRANT:
        case K_INSERT:
        case K_MERGE:
        case K_REPLACE:
        case K_SELECT:
        case K_SET:
        case K_SHOW:
        case K_TRUNCATE:
        case K_UPDATE:
        case K_UPSERT:
        case K_USE:
        case K_VALUES:
        case K_WITH:
        case 266:{
          stm = SingleStatement();
          break;
          }
        case K_BEGIN:{
          stm = Block();
          break;
          }
        default:
          jj_la1[6] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
list.add(stm);
        jj_consume_token(ST_SEMICOLON);
        label_2:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ALTER:
          case K_BEGIN:
          case K_CALL:
          case K_COMMIT:
          case K_COMMENT:
          case K_CREATE:
          case K_DECLARE:
          case K_DELETE:
          case K_DESCRIBE:
          case K_DROP:
          case K_EXEC:
          case K_EXECUTE:
          case K_EXPLAIN:
          case K_GRANT:
          case K_INSERT:
          case K_MERGE:
          case K_REPLACE:
          case K_SELECT:
          case K_SET:
          case K_SHOW:
          case K_TRUNCATE:
          case K_UPDATE:
          case K_UPSERT:
          case K_USE:
          case K_VALUES:
          case K_WITH:
          case 266:{
            ;
            break;
            }
          default:
            jj_la1[7] = jj_gen;
            break label_2;
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ALTER:
          case K_CALL:
          case K_COMMIT:
          case K_COMMENT:
          case K_CREATE:
          case K_DECLARE:
          case K_DELETE:
          case K_DESCRIBE:
          case K_DROP:
          case K_EXEC:
          case K_EXECUTE:
          case K_EXPLAIN:
          case K_GRANT:
          case K_INSERT:
          case K_MERGE:
          case K_REPLACE:
          case K_SELECT:
          case K_SET:
          case K_SHOW:
          case K_TRUNCATE:
          case K_UPDATE:
          case K_UPSERT:
          case K_USE:
          case K_VALUES:
          case K_WITH:
          case 266:{
            stm = SingleStatement();
            break;
            }
          case K_BEGIN:{
            stm = Block();
            break;
            }
          default:
            jj_la1[8] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          jj_consume_token(ST_SEMICOLON);
list.add(stm);
        }
      } catch (ParseException e) {
if (errorRecovery) {
            parseErrors.add(e);
            error_skipto(ST_SEMICOLON);
        } else {
            {if (true) throw e;}
        }
      }
stmts.setStatements(list);
        block.setStatements(stmts);
      jj_consume_token(K_END);
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
return block;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Statements Statements() throws ParseException {/*@bgen(jjtree) Statements */
    SimpleNode jjtn000 = new SimpleNode(JJTSTATEMENTS);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Statements stmts = new Statements();
    List<Statement> list = new ArrayList<Statement>();
    Statement stm;
    try {
      label_3:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case ST_SEMICOLON:{
          ;
          break;
          }
        default:
          jj_la1[9] = jj_gen;
          break label_3;
        }
        jj_consume_token(ST_SEMICOLON);
      }
      try {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ALTER:
        case K_CALL:
        case K_COMMIT:
        case K_COMMENT:
        case K_CREATE:
        case K_DECLARE:
        case K_DELETE:
        case K_DESCRIBE:
        case K_DROP:
        case K_EXEC:
        case K_EXECUTE:
        case K_EXPLAIN:
        case K_GRANT:
        case K_INSERT:
        case K_MERGE:
        case K_REPLACE:
        case K_SELECT:
        case K_SET:
        case K_SHOW:
        case K_TRUNCATE:
        case K_UPDATE:
        case K_UPSERT:
        case K_USE:
        case K_VALUES:
        case K_WITH:
        case 266:{
          stm = SingleStatement();
          break;
          }
        case K_BEGIN:{
          stm = Block();
          break;
          }
        default:
          jj_la1[10] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
list.add(stm);
        label_4:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case ST_SEMICOLON:{
            ;
            break;
            }
          default:
            jj_la1[11] = jj_gen;
            break label_4;
          }
          jj_consume_token(ST_SEMICOLON);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ALTER:
          case K_BEGIN:
          case K_CALL:
          case K_COMMIT:
          case K_COMMENT:
          case K_CREATE:
          case K_DECLARE:
          case K_DELETE:
          case K_DESCRIBE:
          case K_DROP:
          case K_EXEC:
          case K_EXECUTE:
          case K_EXPLAIN:
          case K_GRANT:
          case K_INSERT:
          case K_MERGE:
          case K_REPLACE:
          case K_SELECT:
          case K_SET:
          case K_SHOW:
          case K_TRUNCATE:
          case K_UPDATE:
          case K_UPSERT:
          case K_USE:
          case K_VALUES:
          case K_WITH:
          case 266:{
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_ALTER:
            case K_CALL:
            case K_COMMIT:
            case K_COMMENT:
            case K_CREATE:
            case K_DECLARE:
            case K_DELETE:
            case K_DESCRIBE:
            case K_DROP:
            case K_EXEC:
            case K_EXECUTE:
            case K_EXPLAIN:
            case K_GRANT:
            case K_INSERT:
            case K_MERGE:
            case K_REPLACE:
            case K_SELECT:
            case K_SET:
            case K_SHOW:
            case K_TRUNCATE:
            case K_UPDATE:
            case K_UPSERT:
            case K_USE:
            case K_VALUES:
            case K_WITH:
            case 266:{
              stm = SingleStatement();
              break;
              }
            case K_BEGIN:{
              stm = Block();
              break;
              }
            default:
              jj_la1[12] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
list.add(stm);
            break;
            }
          default:
            jj_la1[13] = jj_gen;
            ;
          }
        }
        jj_consume_token(0);
      } catch (ParseException e) {
if (errorRecovery) {
            parseErrors.add(e);
            error_skipto(ST_SEMICOLON);
        } else {
            {if (true) throw e;}
        }
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
return stmts.withStatements(list);
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  void error_skipto(int kind) throws ParseException {ParseException e = generateParseException();
  Token t;
  do {
    t = getNextToken();
  } while (t.kind != kind && t.kind != EOF);
  }

  final public DeclareStatement Declare() throws ParseException {UserVariable userVariable;
    ColDataType colDataType;
    Expression defaultExpr = null;
    DeclareStatement stmt = new DeclareStatement();
    String typeName;
    String columnName;
    ColumnDefinition colDef;
    jj_consume_token(K_DECLARE);
    userVariable = UserVariable();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_TABLE:{
      jj_consume_token(K_TABLE);
      jj_consume_token(266);
      colDef = ColumnDefinition();
stmt.withUserVariable(userVariable)
        .withDeclareType(DeclareType.TABLE)
        .addColumnDefinition(colDef);
      label_5:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[14] = jj_gen;
          break label_5;
        }
        jj_consume_token(K_COMMA);
        colDef = ColumnDefinition();
stmt.addColumnDefinition(colDef);
      }
      jj_consume_token(267);
      break;
      }
    case K_AS:{
      jj_consume_token(K_AS);
      typeName = RelObjectName();
stmt.withUserVariable(userVariable)
                      .withDeclareType(DeclareType.AS)
                      .withTypeName(typeName);
      break;
      }
    case K_BINARY:
    case K_BIT:
    case K_CHARACTER:
    case K_CHAR:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DOUBLE:
    case K_INTERVAL:
    case K_JSON:
    case K_SET:
    case K_SIGNED:
    case K_UNSIGNED:
    case K_XML:
    case DT_ZONE:
    case S_IDENTIFIER:{
      colDataType = ColDataType();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 268:{
        jj_consume_token(268);
        defaultExpr = Expression();
        break;
        }
      default:
        jj_la1[15] = jj_gen;
        ;
      }
stmt.withDeclareType(DeclareType.TYPE)
                  .addType(userVariable, colDataType, defaultExpr);
      label_6:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[16] = jj_gen;
          break label_6;
        }
        jj_consume_token(K_COMMA);
        userVariable = UserVariable();
        colDataType = ColDataType();
defaultExpr = null;
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 268:{
          jj_consume_token(268);
          defaultExpr = Expression();
          break;
          }
        default:
          jj_la1[17] = jj_gen;
          ;
        }
stmt.addType(userVariable, colDataType, defaultExpr);
      }
      break;
      }
    default:
      jj_la1[18] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return stmt;
}

  final public SetStatement Set() throws ParseException {String name;
    Expression value;
    boolean useEqual = false;
    SetStatement set;
    jj_consume_token(K_SET);
    name = RelObjectNameExt();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 268:{
      jj_consume_token(268);
useEqual=true;
      break;
      }
    default:
      jj_la1[19] = jj_gen;
      ;
    }
    value = SimpleExpression();
set = new SetStatement(name,value).withUseEqual(useEqual);
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[20] = jj_gen;
        break label_7;
      }
useEqual=false;
      jj_consume_token(K_COMMA);
      name = RelObjectNameExt();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 268:{
        jj_consume_token(268);
useEqual=true;
        break;
        }
      default:
        jj_la1[21] = jj_gen;
        ;
      }
      value = SimpleExpression();
set.add(name, value, useEqual);
    }
return set;
}

  final public DescribeStatement Describe() throws ParseException {Table table;
    jj_consume_token(K_DESCRIBE);
    table = Table();
return new DescribeStatement(table);
}

  final public ExplainStatement Explain() throws ParseException {Select select;
    List<ExplainStatement.Option> options = null;
    jj_consume_token(K_EXPLAIN);
    options = ExplainStatementOptions();
    select = Select();
ExplainStatement es = new ExplainStatement(select);
       if(options != null && !options.isEmpty()) {
         for(ExplainStatement.Option o : options) {
           es.addOption(o);
         }
       }
       return es;
}

/**
 * Postgres supports TRUE,ON,1,FALSE,OFF,0 as values
 */
  final public String ExplainOptionBoolean() throws ParseException {Token tk = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FALSE:
    case K_OFF:
    case K_ON:
    case K_TRUE:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_TRUE:{
        tk = jj_consume_token(K_TRUE);
        break;
        }
      case K_FALSE:{
        tk = jj_consume_token(K_FALSE);
        break;
        }
      case K_ON:{
        tk = jj_consume_token(K_ON);
        break;
        }
      case K_OFF:{
        tk = jj_consume_token(K_OFF);
        break;
        }
      default:
        jj_la1[22] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[23] = jj_gen;
      ;
    }
return tk != null ? tk.image : null;
}

/**
 * The output format, which can be TEXT, XML, JSON, or YAML
 */
  final public String ExplainFormatOption() throws ParseException {Token tk = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_JSON:
    case K_XML:
    case K_YAML:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_XML:{
        tk = jj_consume_token(K_XML);
        break;
        }
      case K_JSON:{
        tk = jj_consume_token(K_JSON);
        break;
        }
      case K_YAML:{
        tk = jj_consume_token(K_YAML);
        break;
        }
      default:
        jj_la1[24] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[25] = jj_gen;
      ;
    }
return tk != null ? tk.image : null;
}

/**
 * Options for explain, see https://www.postgresql.org/docs/9.1/sql-explain.html
 */
  final public List<ExplainStatement.Option> ExplainStatementOptions() throws ParseException {List<ExplainStatement.Option> options = new ArrayList<ExplainStatement.Option>();
  ExplainStatement.Option option = null;
  Token token = null;
  String value = null;
    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ANALYZE:
      case K_BUFFERS:
      case K_COSTS:
      case K_FORMAT:
      case K_VERBOSE:{
        ;
        break;
        }
      default:
        jj_la1[26] = jj_gen;
        break label_8;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ANALYZE:{
        jj_consume_token(K_ANALYZE);
        value = ExplainOptionBoolean();
option = new ExplainStatement.Option(ExplainStatement.OptionType.ANALYZE);
       option.setValue(value);
       options.add(option);
        break;
        }
      case K_BUFFERS:{
        jj_consume_token(K_BUFFERS);
        value = ExplainOptionBoolean();
option = new ExplainStatement.Option(ExplainStatement.OptionType.BUFFERS);
        option.setValue(value);
        options.add(option);
        break;
        }
      case K_COSTS:{
        jj_consume_token(K_COSTS);
        value = ExplainOptionBoolean();
option = new ExplainStatement.Option(ExplainStatement.OptionType.COSTS);
        option.setValue(value);
        options.add(option);
        break;
        }
      case K_VERBOSE:{
        jj_consume_token(K_VERBOSE);
        value = ExplainOptionBoolean();
option = new ExplainStatement.Option(ExplainStatement.OptionType.VERBOSE);
        option.setValue(value);
        options.add(option);
        break;
        }
      case K_FORMAT:{
        jj_consume_token(K_FORMAT);
        value = ExplainFormatOption();
option = new ExplainStatement.Option(ExplainStatement.OptionType.FORMAT);
        option.setValue(value);
        options.add(option);
        break;
        }
      default:
        jj_la1[27] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return options;
}

  final public UseStatement Use() throws ParseException {String name;
    jj_consume_token(K_USE);
    name = RelObjectNameExt();
return new UseStatement(name);
}

  final public ShowColumnsStatement ShowColumns() throws ParseException {String tableName;
    jj_consume_token(K_SHOW);
    jj_consume_token(K_COLUMNS);
    jj_consume_token(K_FROM);
    tableName = RelObjectNameExt();
return new ShowColumnsStatement(tableName);
}

// https://dev.mysql.com/doc/refman/8.0/en/show-tables.html
  final public ShowTablesStatement ShowTables() throws ParseException {ShowTablesStatement showTablesStatement;
    EnumSet<ShowTablesStatement.Modifiers> modifiers =  EnumSet.noneOf(ShowTablesStatement.Modifiers.class);
    ShowTablesStatement.SelectionMode selectionMode = null;
    String dbName = null;
    Expression likeExpression = null;
    Expression whereCondition = null;
    jj_consume_token(K_SHOW);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_EXTENDED:{
      jj_consume_token(K_EXTENDED);
modifiers.add(ShowTablesStatement.Modifiers.EXTENDED);
      break;
      }
    default:
      jj_la1[28] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FULL:{
      jj_consume_token(K_FULL);
modifiers.add(ShowTablesStatement.Modifiers.FULL);
      break;
      }
    default:
      jj_la1[29] = jj_gen;
      ;
    }
    jj_consume_token(K_TABLES);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FROM:
    case K_IN:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_FROM:{
        jj_consume_token(K_FROM);
selectionMode = ShowTablesStatement.SelectionMode.FROM;
        break;
        }
      case K_IN:{
        jj_consume_token(K_IN);
selectionMode = ShowTablesStatement.SelectionMode.IN;
        break;
        }
      default:
        jj_la1[30] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      dbName = RelObjectNameExt();
      break;
      }
    default:
      jj_la1[31] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_LIKE:
    case K_WHERE:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_LIKE:{
        jj_consume_token(K_LIKE);
        likeExpression = SimpleExpression();
        break;
        }
      case K_WHERE:{
        jj_consume_token(K_WHERE);
        whereCondition = Expression();
        break;
        }
      default:
        jj_la1[32] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[33] = jj_gen;
      ;
    }
showTablesStatement = new ShowTablesStatement();
    showTablesStatement.setModifiers(modifiers);
    showTablesStatement.setSelectionMode(selectionMode);
    showTablesStatement.setDbName(dbName);
    showTablesStatement.setLikeExpression(likeExpression);
    showTablesStatement.setWhereCondition(whereCondition);
    return showTablesStatement;
}

  final public ShowStatement Show() throws ParseException {String name;
    jj_consume_token(K_SHOW);
    name = RelObjectNameExt();
return new ShowStatement(name);
}

  final public ValuesStatement Values() throws ParseException {List<Expression> expList = new ArrayList<Expression>();
    Expression exp;
    jj_consume_token(K_VALUES);
    jj_consume_token(266);
    exp = PrimaryExpression();
expList.add(exp);
    label_9:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[34] = jj_gen;
        break label_9;
      }
      jj_consume_token(K_COMMA);
      exp = PrimaryExpression();
expList.add(exp);
    }
    jj_consume_token(267);
return new ValuesStatement(expList);
}

  final public Update Update() throws ParseException {Update update = new Update();
    Table table = null;
    List<Join> startJoins = null;
    Expression where = null;
    Column tableColumn = null;
    List<Expression> expList = new ArrayList<Expression>();
    List<Column> columns = new ArrayList<Column>();
    Expression value = null;
    FromItem fromItem = null;
    List<Join> joins = null;
    Select select = null;
    Limit limit = null;
    List<OrderByElement> orderByElements;
    boolean useColumnsBrackets = false;
    List<SelectExpressionItem> returning = null;
    jj_consume_token(K_UPDATE);
    table = TableWithAlias();
    startJoins = JoinsList();
    jj_consume_token(K_SET);
    if (jj_2_15(3)) {
      tableColumn = Column();
      jj_consume_token(268);
      value = SimpleExpression();
columns.add(tableColumn); expList.add(value);
      label_10:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[35] = jj_gen;
          break label_10;
        }
        jj_consume_token(K_COMMA);
        tableColumn = Column();
        jj_consume_token(268);
        value = SimpleExpression();
columns.add(tableColumn); expList.add(value);
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ACTION:
      case K_ANY:
      case K_BYTE:
      case K_CASCADE:
      case K_CAST:
      case K_CHARACTER:
      case K_CHANGE:
      case K_CHAR:
      case K_COLUMN:
      case K_COLUMNS:
      case K_COMMIT:
      case K_COMMENT:
      case K_CREATE:
      case K_CYCLE:
      case K_DATETIMELITERAL:
      case K_DATE_LITERAL:
      case K_DESC:
      case K_DESCRIBE:
      case K_DISABLE:
      case K_DIV:
      case K_DO:
      case K_DOUBLE:
      case K_DUPLICATE:
      case K_ENABLE:
      case K_END:
      case K_EXCLUDE:
      case K_EXTRACT:
      case K_FIRST:
      case K_FALSE:
      case K_FOLLOWING:
      case K_FORMAT:
      case K_GROUP:
      case K_IF:
      case K_INDEX:
      case K_INSERT:
      case K_INTERVAL:
      case K_ISNULL:
      case K_KEY:
      case K_FN:
      case K_LAST:
      case K_LEFT:
      case K_LIMIT:
      case K_MATERIALIZED:
      case K_NEXTVAL:
      case K_NO:
      case K_NOLOCK:
      case K_NULLS:
      case K_OF:
      case K_OFFSET:
      case K_ON:
      case K_OPEN:
      case K_ORDER:
      case K_OVER:
      case K_OPTIMIZE:
      case K_PARTITION:
      case K_PATH:
      case K_PERCENT:
      case K_PRECISION:
      case K_PRIMARY:
      case K_PRIOR:
      case K_PROCEDURE:
      case K_PUBLIC:
      case K_RANGE:
      case K_READ:
      case K_REPLACE:
      case K_RIGHT:
      case K_ROW:
      case K_ROWS:
      case K_SCHEMA:
      case K_SEQUENCE:
      case K_SEPARATOR:
      case K_SESSION:
      case K_SET:
      case K_SIBLINGS:
      case K_SIZE:
      case K_START:
      case K_TABLE:
      case K_TABLES:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TO:
      case K_TOP:
      case K_TRUNCATE:
      case K_TRUE:
      case K_TYPE:
      case K_UNSIGNED:
      case K_VALIDATE:
      case K_VALUE:
      case K_VALUES:
      case K_VIEW:
      case K_XML:
      case K_ZONE:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:
      case 266:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 266:{
          jj_consume_token(266);
useColumnsBrackets = true;
          tableColumn = Column();
columns.add(tableColumn);
          label_11:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_COMMA:{
              ;
              break;
              }
            default:
              jj_la1[36] = jj_gen;
              break label_11;
            }
            jj_consume_token(K_COMMA);
            tableColumn = Column();
columns.add(tableColumn);
          }
          jj_consume_token(267);
          break;
          }
        case K_ACTION:
        case K_ANY:
        case K_BYTE:
        case K_CASCADE:
        case K_CAST:
        case K_CHARACTER:
        case K_CHANGE:
        case K_CHAR:
        case K_COLUMN:
        case K_COLUMNS:
        case K_COMMIT:
        case K_COMMENT:
        case K_CREATE:
        case K_CYCLE:
        case K_DATETIMELITERAL:
        case K_DATE_LITERAL:
        case K_DESC:
        case K_DESCRIBE:
        case K_DISABLE:
        case K_DIV:
        case K_DO:
        case K_DOUBLE:
        case K_DUPLICATE:
        case K_ENABLE:
        case K_END:
        case K_EXCLUDE:
        case K_EXTRACT:
        case K_FIRST:
        case K_FALSE:
        case K_FOLLOWING:
        case K_FORMAT:
        case K_GROUP:
        case K_IF:
        case K_INDEX:
        case K_INSERT:
        case K_INTERVAL:
        case K_ISNULL:
        case K_KEY:
        case K_FN:
        case K_LAST:
        case K_LEFT:
        case K_LIMIT:
        case K_MATERIALIZED:
        case K_NEXTVAL:
        case K_NO:
        case K_NOLOCK:
        case K_NULLS:
        case K_OF:
        case K_OFFSET:
        case K_ON:
        case K_OPEN:
        case K_ORDER:
        case K_OVER:
        case K_OPTIMIZE:
        case K_PARTITION:
        case K_PATH:
        case K_PERCENT:
        case K_PRECISION:
        case K_PRIMARY:
        case K_PRIOR:
        case K_PROCEDURE:
        case K_PUBLIC:
        case K_RANGE:
        case K_READ:
        case K_REPLACE:
        case K_RIGHT:
        case K_ROW:
        case K_ROWS:
        case K_SCHEMA:
        case K_SEQUENCE:
        case K_SEPARATOR:
        case K_SESSION:
        case K_SET:
        case K_SIBLINGS:
        case K_SIZE:
        case K_START:
        case K_TABLE:
        case K_TABLES:
        case K_TEMP:
        case K_TEMPORARY:
        case K_TO:
        case K_TOP:
        case K_TRUNCATE:
        case K_TRUE:
        case K_TYPE:
        case K_UNSIGNED:
        case K_VALIDATE:
        case K_VALUE:
        case K_VALUES:
        case K_VIEW:
        case K_XML:
        case K_ZONE:
        case S_IDENTIFIER:
        case S_QUOTED_IDENTIFIER:{
          tableColumn = Column();
columns.add(tableColumn);
          label_12:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_COMMA:{
              ;
              break;
              }
            default:
              jj_la1[37] = jj_gen;
              break label_12;
            }
            jj_consume_token(K_COMMA);
            tableColumn = Column();
columns.add(tableColumn);
          }
          break;
          }
        default:
          jj_la1[38] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(268);
        jj_consume_token(266);
update.setUseSelect(true);
        select = Select();
        jj_consume_token(267);
        break;
        }
      default:
        jj_la1[39] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FROM:{
      jj_consume_token(K_FROM);
      fromItem = FromItem();
      joins = JoinsList();
      break;
      }
    default:
      jj_la1[40] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_WHERE:{
      where = WhereClause();
update.setWhere(where);
      break;
      }
    default:
      jj_la1[41] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ORDER:{
      orderByElements = OrderByElements();
update.setOrderByElements(orderByElements);
      break;
      }
    default:
      jj_la1[42] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_LIMIT:{
      limit = PlainLimit();
update.setLimit(limit);
      break;
      }
    default:
      jj_la1[43] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_RETURNING:{
      jj_consume_token(K_RETURNING);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 269:{
        jj_consume_token(269);
update.setReturningAllColumns(true);
        break;
        }
      case K_ACTION:
      case K_ALL:
      case K_ANY:
      case K_BYTE:
      case K_CASCADE:
      case K_CASE:
      case K_CAST:
      case K_CHARACTER:
      case K_CHANGE:
      case K_CHAR:
      case K_COLUMN:
      case K_COLUMNS:
      case K_COMMIT:
      case K_COMMENT:
      case K_CREATE:
      case K_CURRENT:
      case K_CYCLE:
      case K_DATETIMELITERAL:
      case K_DATE_LITERAL:
      case K_DESC:
      case K_DESCRIBE:
      case K_DISABLE:
      case K_DIV:
      case K_DO:
      case K_DOUBLE:
      case K_DUPLICATE:
      case K_ENABLE:
      case K_END:
      case K_EXCLUDE:
      case K_EXISTS:
      case K_EXTRACT:
      case K_FIRST:
      case K_FALSE:
      case K_FOLLOWING:
      case K_FORMAT:
      case K_GROUP:
      case K_GROUP_CONCAT:
      case K_IF:
      case K_IIF:
      case K_INDEX:
      case K_INSERT:
      case K_INTERVAL:
      case K_ISNULL:
      case K_KEY:
      case K_FN:
      case K_LAST:
      case K_LEFT:
      case K_LIMIT:
      case K_MATCH:
      case K_MATERIALIZED:
      case K_NEXTVAL:
      case K_NO:
      case K_NOLOCK:
      case K_NOT:
      case K_NULL:
      case K_NULLS:
      case K_OF:
      case K_OFFSET:
      case K_ON:
      case K_OPEN:
      case K_ORDER:
      case K_OVER:
      case K_OPTIMIZE:
      case K_PARTITION:
      case K_PATH:
      case K_PERCENT:
      case K_PRECISION:
      case K_PRIMARY:
      case K_PRIOR:
      case K_PROCEDURE:
      case K_PUBLIC:
      case K_RANGE:
      case K_READ:
      case K_REPLACE:
      case K_RIGHT:
      case K_ROW:
      case K_ROWS:
      case K_SCHEMA:
      case K_SEQUENCE:
      case K_SEPARATOR:
      case K_SESSION:
      case K_SET:
      case K_SIBLINGS:
      case K_SIZE:
      case K_SOME:
      case K_START:
      case K_TABLE:
      case K_TABLES:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_TO:
      case K_TOP:
      case K_TRUNCATE:
      case K_TRUE:
      case K_TYPE:
      case K_UNSIGNED:
      case K_VALIDATE:
      case K_VALUE:
      case K_VALUES:
      case K_VIEW:
      case K_XML:
      case K_XMLSERIALIZE:
      case K_ZONE:
      case S_DOUBLE:
      case S_LONG:
      case S_HEX:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:
      case 266:
      case 271:
      case 272:
      case 273:
      case 274:
      case 277:
      case 278:
      case 286:
      case 296:
      case 298:
      case 299:
      case 303:
      case 312:{
        returning = ListExpressionItem();
        break;
        }
      default:
        jj_la1[44] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[45] = jj_gen;
      ;
    }
return update.withColumns(columns)
                  .withExpressions(expList)
              .withTable(table)
              .withStartJoins(startJoins)
              .withFromItem(fromItem)
              .withJoins(joins)
              .withSelect(select)
              .withUseColumnsBrackets(useColumnsBrackets)
              .withReturningExpressionList(returning);
}

  final public Replace Replace() throws ParseException {Replace replace = new Replace();
    Table table = null;
    Column tableColumn = null;
    Expression value = null;

    List<Column> columns = new ArrayList<Column>();
    List<Expression> expList = new ArrayList<Expression>();
    MultiExpressionList multiExpr = null;
    ItemsList itemsList = null;
    Expression exp = null;
    jj_consume_token(K_REPLACE);
    if (jj_2_16(2)) {
      jj_consume_token(K_INTO);
replace.setUseIntoTables(true);
    } else {
      ;
    }
    table = Table();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_SET:{
      jj_consume_token(K_SET);
      tableColumn = Column();
      jj_consume_token(268);
      value = SimpleExpression();
columns.add(tableColumn); expList.add(value);
      label_13:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[46] = jj_gen;
          break label_13;
        }
        jj_consume_token(K_COMMA);
        tableColumn = Column();
        jj_consume_token(268);
        value = SimpleExpression();
columns.add(tableColumn); expList.add(value);
      }
replace.setExpressions(expList);
      break;
      }
    case K_SELECT:
    case K_VALUE:
    case K_VALUES:
    case K_WITH:
    case 266:{
      if (jj_2_17(2)) {
        jj_consume_token(266);
        tableColumn = Column();
columns.add(tableColumn);
        label_14:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_COMMA:{
            ;
            break;
            }
          default:
            jj_la1[47] = jj_gen;
            break label_14;
          }
          jj_consume_token(K_COMMA);
          tableColumn = Column();
columns.add(tableColumn);
        }
        jj_consume_token(267);
      } else {
        ;
      }
      if (jj_2_18(2)) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_VALUE:
        case K_VALUES:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_VALUES:{
            jj_consume_token(K_VALUES);
            break;
            }
          case K_VALUE:{
            jj_consume_token(K_VALUE);
            break;
            }
          default:
            jj_la1[48] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        default:
          jj_la1[49] = jj_gen;
          ;
        }
        jj_consume_token(266);
        exp = PrimaryExpression();
expList.add(exp);
        label_15:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_COMMA:{
            ;
            break;
            }
          default:
            jj_la1[50] = jj_gen;
            break label_15;
          }
          jj_consume_token(K_COMMA);
          exp = PrimaryExpression();
expList.add(exp);
        }
        jj_consume_token(267);
itemsList = new ExpressionList(expList);
        label_16:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_COMMA:{
            ;
            break;
            }
          default:
            jj_la1[51] = jj_gen;
            break label_16;
          }
          jj_consume_token(K_COMMA);
          jj_consume_token(266);
          exp = SimpleExpression();
if (multiExpr==null) {
                                multiExpr=new MultiExpressionList();
                                multiExpr.addExpressionList((ExpressionList)itemsList);
                                itemsList = multiExpr;
                            }
                            expList = new ArrayList<Expression>();
                            expList.add(exp);
          label_17:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_COMMA:{
              ;
              break;
              }
            default:
              jj_la1[52] = jj_gen;
              break label_17;
            }
            jj_consume_token(K_COMMA);
            exp = SimpleExpression();
expList.add(exp);
          }
          jj_consume_token(267);
multiExpr.addExpressionList(expList);
        }
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_SELECT:
        case K_VALUES:
        case K_WITH:
        case 266:{
replace.setUseValues(false);
          itemsList = SubSelect();
((SubSelect)itemsList).setUseBrackets(false);
          break;
          }
        default:
          jj_la1[53] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
replace.setItemsList(itemsList);
      break;
      }
    default:
      jj_la1[54] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if (!columns.isEmpty()) {
           replace.withColumns(columns);
        }
        return replace.withTable(table);
}

  final public List<SelectExpressionItem> ListExpressionItem() throws ParseException {List<SelectExpressionItem> retval = new ArrayList<SelectExpressionItem>();
   SelectExpressionItem item;
    item = SelectExpressionItem();
retval.add(item);
    label_18:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[55] = jj_gen;
        break label_18;
      }
      jj_consume_token(K_COMMA);
      item = SelectExpressionItem();
retval.add(item);
    }
return retval;
}

  final public Insert Insert() throws ParseException {Insert insert = new Insert();
    Table table = null;
    Column tableColumn = null;
    List<Column> columns = new ArrayList<Column>();
    List<Expression> primaryExpList = new ArrayList<Expression>();
    ItemsList itemsList = null;
    Expression exp = null;
    MultiExpressionList multiExpr = null;
    List<SelectExpressionItem> returning = null;
    Select select = null;
    boolean useValues = true;
    boolean useSelectBrackets = false;
    boolean useDuplicate = false;
    List<Column> duplicateUpdateColumns = null;
    List<Expression> duplicateUpdateExpressionList = null;
    Token tk = null;
    InsertModifierPriority modifierPriority = null;
    boolean modifierIgnore = false;
    boolean useSet = false;
    List<Column> setColumns = new ArrayList<Column>();
    List<Expression> setExpressionList = new ArrayList<Expression>();
    String name = null;
    boolean useAs = false;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_WITH:{
      WithList();
      break;
      }
    default:
      jj_la1[56] = jj_gen;
      ;
    }
    jj_consume_token(K_INSERT);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_DELAYED:
    case K_HIGH_PRIORITY:
    case K_LOW_PRIORITY:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_LOW_PRIORITY:{
        tk = jj_consume_token(K_LOW_PRIORITY);
        break;
        }
      case K_DELAYED:{
        tk = jj_consume_token(K_DELAYED);
        break;
        }
      case K_HIGH_PRIORITY:{
        tk = jj_consume_token(K_HIGH_PRIORITY);
        break;
        }
      default:
        jj_la1[57] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
if (tk!=null)
        modifierPriority = InsertModifierPriority.valueOf(tk.image.toUpperCase());
      break;
      }
    default:
      jj_la1[58] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_IGNORE:{
      jj_consume_token(K_IGNORE);
modifierIgnore = true;
      break;
      }
    default:
      jj_la1[59] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_INTO:{
      jj_consume_token(K_INTO);
      break;
      }
    default:
      jj_la1[60] = jj_gen;
      ;
    }
    table = Table();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ANY:
    case K_AS:
    case K_BYTE:
    case K_CASCADE:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHAR:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_CYCLE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DIV:
    case K_DO:
    case K_DUPLICATE:
    case K_ENABLE:
    case K_END:
    case K_EXCLUDE:
    case K_EXTRACT:
    case K_FIRST:
    case K_FALSE:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_INDEX:
    case K_INSERT:
    case K_ISNULL:
    case K_KEY:
    case K_FN:
    case K_LAST:
    case K_MATERIALIZED:
    case K_NEXTVAL:
    case K_NO:
    case K_NOLOCK:
    case K_NULLS:
    case K_OF:
    case K_OPEN:
    case K_OVER:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_RANGE:
    case K_READ:
    case K_REPLACE:
    case K_ROW:
    case K_ROWS:
    case K_SCHEMA:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SIBLINGS:
    case K_SIZE:
    case K_TABLE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TO:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TYPE:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VIEW:
    case K_XML:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_AS:{
        jj_consume_token(K_AS);
useAs = true;
        break;
        }
      default:
        jj_la1[61] = jj_gen;
        ;
      }
      name = RelObjectNameWithoutValue();
table.setAlias(new Alias(name,useAs));
      break;
      }
    default:
      jj_la1[62] = jj_gen;
      ;
    }
    if (jj_2_19(2)) {
      jj_consume_token(266);
      tableColumn = Column();
columns.add(tableColumn);
      label_19:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[63] = jj_gen;
          break label_19;
        }
        jj_consume_token(K_COMMA);
        tableColumn = Column();
columns.add(tableColumn);
      }
      jj_consume_token(267);
    } else {
      ;
    }
    if (jj_2_21(2)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_VALUE:
      case K_VALUES:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_VALUES:{
          jj_consume_token(K_VALUES);
          break;
          }
        case K_VALUE:{
          jj_consume_token(K_VALUE);
          break;
          }
        default:
          jj_la1[64] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[65] = jj_gen;
        ;
      }
      jj_consume_token(266);
      exp = SimpleExpression();
primaryExpList.add(exp);
      label_20:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[66] = jj_gen;
          break label_20;
        }
        jj_consume_token(K_COMMA);
        exp = SimpleExpression();
primaryExpList.add(exp);
      }
      jj_consume_token(267);
itemsList = new ExpressionList(primaryExpList);
      label_21:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[67] = jj_gen;
          break label_21;
        }
        jj_consume_token(K_COMMA);
        jj_consume_token(266);
        exp = SimpleExpression();
if (multiExpr==null) {
                        multiExpr=new MultiExpressionList();
                        multiExpr.addExpressionList((ExpressionList)itemsList);
                        itemsList = multiExpr;
                    }
                    primaryExpList = new ArrayList<Expression>();
                    primaryExpList.add(exp);
        label_22:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_COMMA:{
            ;
            break;
            }
          default:
            jj_la1[68] = jj_gen;
            break label_22;
          }
          jj_consume_token(K_COMMA);
          exp = SimpleExpression();
primaryExpList.add(exp);
        }
        jj_consume_token(267);
multiExpr.addExpressionList(primaryExpList);
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_SELECT:
      case K_VALUES:
      case K_WITH:
      case 266:{
        if (jj_2_20(2)) {
          jj_consume_token(266);
useSelectBrackets = true;
insert.setUseValues(false);
          select = Select();
          jj_consume_token(267);
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_SELECT:
          case K_VALUES:
          case K_WITH:
          case 266:{
insert.setUseValues(false);
            select = Select();
            break;
            }
          default:
            jj_la1[69] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
        }
      case K_SET:{
        jj_consume_token(K_SET);
useSet = true;
                insert.setUseValues(false);
        tableColumn = Column();
        jj_consume_token(268);
        exp = SimpleExpression();
setColumns = new ArrayList<Column>();
                setExpressionList = new ArrayList<Expression>();
                setColumns.add(tableColumn);
                setExpressionList.add(exp);
        label_23:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_COMMA:{
            ;
            break;
            }
          default:
            jj_la1[70] = jj_gen;
            break label_23;
          }
          jj_consume_token(K_COMMA);
          tableColumn = Column();
          jj_consume_token(268);
          exp = SimpleExpression();
setColumns.add(tableColumn);
                setExpressionList.add(exp);
        }
        break;
        }
      default:
        jj_la1[71] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ON:{
      jj_consume_token(K_ON);
      jj_consume_token(K_DUPLICATE);
      jj_consume_token(K_KEY);
      jj_consume_token(K_UPDATE);
useDuplicate = true;
      tableColumn = Column();
      jj_consume_token(268);
      exp = SimpleExpression();
duplicateUpdateColumns = new ArrayList<Column>();
            duplicateUpdateExpressionList = new ArrayList<Expression>();
            duplicateUpdateColumns.add(tableColumn);
            duplicateUpdateExpressionList.add(exp);
      label_24:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[72] = jj_gen;
          break label_24;
        }
        jj_consume_token(K_COMMA);
        tableColumn = Column();
        jj_consume_token(268);
        exp = SimpleExpression();
duplicateUpdateColumns.add(tableColumn);
        duplicateUpdateExpressionList.add(exp);
      }
      break;
      }
    default:
      jj_la1[73] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_RETURNING:{
      jj_consume_token(K_RETURNING);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 269:{
        jj_consume_token(269);
insert.setReturningAllColumns(true);
        break;
        }
      case K_ACTION:
      case K_ALL:
      case K_ANY:
      case K_BYTE:
      case K_CASCADE:
      case K_CASE:
      case K_CAST:
      case K_CHARACTER:
      case K_CHANGE:
      case K_CHAR:
      case K_COLUMN:
      case K_COLUMNS:
      case K_COMMIT:
      case K_COMMENT:
      case K_CREATE:
      case K_CURRENT:
      case K_CYCLE:
      case K_DATETIMELITERAL:
      case K_DATE_LITERAL:
      case K_DESC:
      case K_DESCRIBE:
      case K_DISABLE:
      case K_DIV:
      case K_DO:
      case K_DOUBLE:
      case K_DUPLICATE:
      case K_ENABLE:
      case K_END:
      case K_EXCLUDE:
      case K_EXISTS:
      case K_EXTRACT:
      case K_FIRST:
      case K_FALSE:
      case K_FOLLOWING:
      case K_FORMAT:
      case K_GROUP:
      case K_GROUP_CONCAT:
      case K_IF:
      case K_IIF:
      case K_INDEX:
      case K_INSERT:
      case K_INTERVAL:
      case K_ISNULL:
      case K_KEY:
      case K_FN:
      case K_LAST:
      case K_LEFT:
      case K_LIMIT:
      case K_MATCH:
      case K_MATERIALIZED:
      case K_NEXTVAL:
      case K_NO:
      case K_NOLOCK:
      case K_NOT:
      case K_NULL:
      case K_NULLS:
      case K_OF:
      case K_OFFSET:
      case K_ON:
      case K_OPEN:
      case K_ORDER:
      case K_OVER:
      case K_OPTIMIZE:
      case K_PARTITION:
      case K_PATH:
      case K_PERCENT:
      case K_PRECISION:
      case K_PRIMARY:
      case K_PRIOR:
      case K_PROCEDURE:
      case K_PUBLIC:
      case K_RANGE:
      case K_READ:
      case K_REPLACE:
      case K_RIGHT:
      case K_ROW:
      case K_ROWS:
      case K_SCHEMA:
      case K_SEQUENCE:
      case K_SEPARATOR:
      case K_SESSION:
      case K_SET:
      case K_SIBLINGS:
      case K_SIZE:
      case K_SOME:
      case K_START:
      case K_TABLE:
      case K_TABLES:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_TO:
      case K_TOP:
      case K_TRUNCATE:
      case K_TRUE:
      case K_TYPE:
      case K_UNSIGNED:
      case K_VALIDATE:
      case K_VALUE:
      case K_VALUES:
      case K_VIEW:
      case K_XML:
      case K_XMLSERIALIZE:
      case K_ZONE:
      case S_DOUBLE:
      case S_LONG:
      case S_HEX:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:
      case 266:
      case 271:
      case 272:
      case 273:
      case 274:
      case 277:
      case 278:
      case 286:
      case 296:
      case 298:
      case 299:
      case 303:
      case 312:{
        returning = ListExpressionItem();
        break;
        }
      default:
        jj_la1[74] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[75] = jj_gen;
      ;
    }
if (!columns.isEmpty()) {
            insert.setColumns(columns);
        }
        return insert.withItemsList(itemsList)
              .withUseSelectBrackets(useSelectBrackets)
              .withSelect(select)
              .withTable(table)
              .withUseDuplicate(useDuplicate)
              .withDuplicateUpdateColumns(duplicateUpdateColumns)
              .withDuplicateUpdateExpressionList(duplicateUpdateExpressionList)
              .withReturningExpressionList(returning)
              .withModifierPriority(modifierPriority)
              .withModifierIgnore(modifierIgnore)
              .withUseSet(useSet)
              .withUseSetColumns(setColumns)
              .withSetExpressionList(setExpressionList);
}

  final public Upsert Upsert() throws ParseException {Upsert upsert = new Upsert();
    Table table = null;
    Column tableColumn = null;
    List<Column> columns = new ArrayList<Column>();
    List<Expression> primaryExpList = new ArrayList<Expression>();
    ItemsList itemsList = null;
    Expression exp = null;
    MultiExpressionList multiExpr = null;
    List<SelectExpressionItem> returning = null;
    Select select = null;
    boolean useSelectBrackets = false;
    boolean useDuplicate = false;
    List<Column> duplicateUpdateColumns = null;
    List<Expression> duplicateUpdateExpressionList = null;
    Token tk = null;
    jj_consume_token(K_UPSERT);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_INTO:{
      jj_consume_token(K_INTO);
      break;
      }
    default:
      jj_la1[76] = jj_gen;
      ;
    }
    table = Table();
    if (jj_2_22(2)) {
      jj_consume_token(266);
      tableColumn = Column();
columns.add(tableColumn);
      label_25:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[77] = jj_gen;
          break label_25;
        }
        jj_consume_token(K_COMMA);
        tableColumn = Column();
columns.add(tableColumn);
      }
      jj_consume_token(267);
    } else {
      ;
    }
    if (jj_2_24(2)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_VALUE:
      case K_VALUES:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_VALUES:{
          jj_consume_token(K_VALUES);
          break;
          }
        case K_VALUE:{
          jj_consume_token(K_VALUE);
          break;
          }
        default:
          jj_la1[78] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[79] = jj_gen;
        ;
      }
      jj_consume_token(266);
      exp = SimpleExpression();
primaryExpList.add(exp);
      label_26:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[80] = jj_gen;
          break label_26;
        }
        jj_consume_token(K_COMMA);
        exp = SimpleExpression();
primaryExpList.add(exp);
      }
      jj_consume_token(267);
itemsList = new ExpressionList(primaryExpList);
      label_27:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[81] = jj_gen;
          break label_27;
        }
        jj_consume_token(K_COMMA);
        jj_consume_token(266);
        exp = SimpleExpression();
if (multiExpr==null) {
                        multiExpr=new MultiExpressionList();
                        multiExpr.addExpressionList((ExpressionList)itemsList);
                        itemsList = multiExpr;
                    }
                    primaryExpList = new ArrayList<Expression>();
                    primaryExpList.add(exp);
        label_28:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_COMMA:{
            ;
            break;
            }
          default:
            jj_la1[82] = jj_gen;
            break label_28;
          }
          jj_consume_token(K_COMMA);
          exp = SimpleExpression();
primaryExpList.add(exp);
        }
        jj_consume_token(267);
multiExpr.addExpressionList(primaryExpList);
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_SELECT:
      case K_VALUES:
      case K_WITH:
      case 266:{
        if (jj_2_23(2)) {
          jj_consume_token(266);
useSelectBrackets = true;
upsert.setUseValues(false);
          select = Select();
          jj_consume_token(267);
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_SELECT:
          case K_VALUES:
          case K_WITH:
          case 266:{
upsert.setUseValues(false);
            select = Select();
            break;
            }
          default:
            jj_la1[83] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
        }
      default:
        jj_la1[84] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ON:{
      jj_consume_token(K_ON);
      jj_consume_token(K_DUPLICATE);
      jj_consume_token(K_KEY);
      jj_consume_token(K_UPDATE);
useDuplicate = true;
      tableColumn = Column();
      jj_consume_token(268);
      exp = SimpleExpression();
duplicateUpdateColumns = new ArrayList<Column>();
            duplicateUpdateExpressionList = new ArrayList<Expression>();
            duplicateUpdateColumns.add(tableColumn);
            duplicateUpdateExpressionList.add(exp);
      label_29:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[85] = jj_gen;
          break label_29;
        }
        jj_consume_token(K_COMMA);
        tableColumn = Column();
        jj_consume_token(268);
        exp = SimpleExpression();
duplicateUpdateColumns.add(tableColumn);
        duplicateUpdateExpressionList.add(exp);
      }
      break;
      }
    default:
      jj_la1[86] = jj_gen;
      ;
    }
if (columns.size() > 0) {
            upsert.setColumns(columns);
        }
        return upsert.withItemsList(itemsList)
              .withUseSelectBrackets(useSelectBrackets)
              .withSelect(select)
              .withTable(table)
              .withUseDuplicate(useDuplicate)
              .withDuplicateUpdateColumns(duplicateUpdateColumns)
              .withDuplicateUpdateExpressionList(duplicateUpdateExpressionList);
}

  final public Delete Delete() throws ParseException {Delete delete = new Delete();
    Table table = null;
    List<Table> tables = new ArrayList<Table>();
    List<Join> joins = null;
    Expression where = null;
    Limit limit = null;
    List<OrderByElement> orderByElements;
    jj_consume_token(K_DELETE);
    if (jj_2_25(2)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ACTION:
      case K_ANY:
      case K_BYTE:
      case K_CASCADE:
      case K_CAST:
      case K_CHARACTER:
      case K_CHANGE:
      case K_CHAR:
      case K_COLUMN:
      case K_COLUMNS:
      case K_COMMIT:
      case K_COMMENT:
      case K_CREATE:
      case K_CYCLE:
      case K_DATETIMELITERAL:
      case K_DATE_LITERAL:
      case K_DESC:
      case K_DESCRIBE:
      case K_DISABLE:
      case K_DIV:
      case K_DO:
      case K_DOUBLE:
      case K_DUPLICATE:
      case K_ENABLE:
      case K_END:
      case K_EXCLUDE:
      case K_EXTRACT:
      case K_FIRST:
      case K_FALSE:
      case K_FOLLOWING:
      case K_FORMAT:
      case K_GROUP:
      case K_IF:
      case K_INDEX:
      case K_INSERT:
      case K_INTERVAL:
      case K_ISNULL:
      case K_KEY:
      case K_FN:
      case K_LAST:
      case K_LEFT:
      case K_LIMIT:
      case K_MATERIALIZED:
      case K_NEXTVAL:
      case K_NO:
      case K_NOLOCK:
      case K_NULLS:
      case K_OF:
      case K_OFFSET:
      case K_ON:
      case K_OPEN:
      case K_ORDER:
      case K_OVER:
      case K_OPTIMIZE:
      case K_PARTITION:
      case K_PATH:
      case K_PERCENT:
      case K_PRECISION:
      case K_PRIMARY:
      case K_PRIOR:
      case K_PROCEDURE:
      case K_PUBLIC:
      case K_RANGE:
      case K_READ:
      case K_REPLACE:
      case K_RIGHT:
      case K_ROW:
      case K_ROWS:
      case K_SCHEMA:
      case K_SEQUENCE:
      case K_SEPARATOR:
      case K_SESSION:
      case K_SET:
      case K_SIBLINGS:
      case K_SIZE:
      case K_START:
      case K_TABLE:
      case K_TABLES:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TO:
      case K_TOP:
      case K_TRUNCATE:
      case K_TRUE:
      case K_TYPE:
      case K_UNSIGNED:
      case K_VALIDATE:
      case K_VALUE:
      case K_VALUES:
      case K_VIEW:
      case K_XML:
      case K_ZONE:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:{
        table = TableWithAlias();
tables.add(table);
        label_30:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_COMMA:{
            ;
            break;
            }
          default:
            jj_la1[87] = jj_gen;
            break label_30;
          }
          jj_consume_token(K_COMMA);
          table = TableWithAlias();
tables.add(table);
        }
        jj_consume_token(K_FROM);
        break;
        }
      case K_FROM:{
        jj_consume_token(K_FROM);
        break;
        }
      default:
        jj_la1[88] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      ;
    }
    if (jj_2_26(3)) {
      table = TableWithAlias();
      joins = JoinsList();
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_WHERE:{
      where = WhereClause();
delete.setWhere(where);
      break;
      }
    default:
      jj_la1[89] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ORDER:{
      orderByElements = OrderByElements();
delete.setOrderByElements(orderByElements);
      break;
      }
    default:
      jj_la1[90] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_LIMIT:{
      limit = PlainLimit();
delete.setLimit(limit);
      break;
      }
    default:
      jj_la1[91] = jj_gen;
      ;
    }
if (joins != null && joins.size() > 0) {
            delete.setJoins(joins);
        }
        return delete.withTables(tables).withTable(table);
}

  final public Statement Merge() throws ParseException {Merge merge = new Merge();
    Table table;
    SubSelect select;
    Alias alias;
    Expression condition;
    MergeUpdate update;
    MergeInsert insert;
    jj_consume_token(K_MERGE);
    jj_consume_token(K_INTO);
    table = TableWithAlias();
merge.setTable(table);
    jj_consume_token(K_USING);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ANY:
    case K_BYTE:
    case K_CASCADE:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHAR:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_CREATE:
    case K_CYCLE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DIV:
    case K_DO:
    case K_DOUBLE:
    case K_DUPLICATE:
    case K_ENABLE:
    case K_END:
    case K_EXCLUDE:
    case K_EXTRACT:
    case K_FIRST:
    case K_FALSE:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_GROUP:
    case K_IF:
    case K_INDEX:
    case K_INSERT:
    case K_INTERVAL:
    case K_ISNULL:
    case K_KEY:
    case K_FN:
    case K_LAST:
    case K_LEFT:
    case K_LIMIT:
    case K_MATERIALIZED:
    case K_NEXTVAL:
    case K_NO:
    case K_NOLOCK:
    case K_NULLS:
    case K_OF:
    case K_OFFSET:
    case K_ON:
    case K_OPEN:
    case K_ORDER:
    case K_OVER:
    case K_OPTIMIZE:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_PROCEDURE:
    case K_PUBLIC:
    case K_RANGE:
    case K_READ:
    case K_REPLACE:
    case K_RIGHT:
    case K_ROW:
    case K_ROWS:
    case K_SCHEMA:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SET:
    case K_SIBLINGS:
    case K_SIZE:
    case K_START:
    case K_TABLE:
    case K_TABLES:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TYPE:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VIEW:
    case K_XML:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      table = Table();
merge.setUsingTable(table);
      break;
      }
    case 266:{
      jj_consume_token(266);
      select = SubSelect();
merge.setUsingSelect(select);
      jj_consume_token(267);
      break;
      }
    default:
      jj_la1[92] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ANY:
    case K_AS:
    case K_BYTE:
    case K_CASCADE:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHAR:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_CYCLE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DIV:
    case K_DO:
    case K_DUPLICATE:
    case K_ENABLE:
    case K_END:
    case K_EXCLUDE:
    case K_EXTRACT:
    case K_FIRST:
    case K_FALSE:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_INDEX:
    case K_INSERT:
    case K_INTERVAL:
    case K_ISNULL:
    case K_KEY:
    case K_FN:
    case K_LAST:
    case K_MATERIALIZED:
    case K_NEXTVAL:
    case K_NO:
    case K_NOLOCK:
    case K_NULLS:
    case K_OF:
    case K_OPEN:
    case K_OVER:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_RANGE:
    case K_READ:
    case K_REPLACE:
    case K_ROW:
    case K_ROWS:
    case K_SCHEMA:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SIBLINGS:
    case K_SIZE:
    case K_TABLE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TYPE:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VIEW:
    case K_XML:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:{
      alias = Alias();
merge.setUsingAlias(alias);
      break;
      }
    default:
      jj_la1[93] = jj_gen;
      ;
    }
    jj_consume_token(K_ON);
    jj_consume_token(266);
    condition = Expression();
merge.setOnCondition(condition);
    jj_consume_token(267);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_WHEN:{
      if (jj_2_27(2)) {
        update = MergeUpdateClause();
merge.setMergeUpdate(update);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_WHEN:{
          insert = MergeInsertClause();
merge.setMergeInsert(insert);
          break;
          }
        default:
          jj_la1[94] = jj_gen;
          ;
        }
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_WHEN:{
          insert = MergeInsertClause();
merge.withMergeInsert(insert).withInsertFirst(true);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_WHEN:{
            update = MergeUpdateClause();
merge.setMergeUpdate(update);
            break;
            }
          default:
            jj_la1[95] = jj_gen;
            ;
          }
          break;
          }
        default:
          jj_la1[96] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[97] = jj_gen;
      ;
    }
return merge;
}

  final public MergeUpdate MergeUpdateClause() throws ParseException {MergeUpdate mu = new MergeUpdate();
    List<Column> columns = new ArrayList<Column>();
    List<Expression> expList = new ArrayList<Expression>();
    Column col;
    Expression exp;
    Expression condition;
    jj_consume_token(K_WHEN);
    jj_consume_token(K_MATCHED);
    jj_consume_token(K_THEN);
    jj_consume_token(K_UPDATE);
    jj_consume_token(K_SET);
    col = Column();
    jj_consume_token(268);
    exp = SimpleExpression();
columns.add(col); expList.add(exp);
    label_31:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[98] = jj_gen;
        break label_31;
      }
      jj_consume_token(K_COMMA);
      col = Column();
      jj_consume_token(268);
      exp = SimpleExpression();
columns.add(col); expList.add(exp);
    }
mu.withColumns(columns).withValues(expList);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_WHERE:{
      jj_consume_token(K_WHERE);
      condition = Expression();
mu.setWhereCondition(condition);
      break;
      }
    default:
      jj_la1[99] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_DELETE:{
      jj_consume_token(K_DELETE);
      jj_consume_token(K_WHERE);
      condition = Expression();
mu.setDeleteWhereCondition(condition);
      break;
      }
    default:
      jj_la1[100] = jj_gen;
      ;
    }
return mu;
}

  final public MergeInsert MergeInsertClause() throws ParseException {MergeInsert mi = new MergeInsert();
    List<Column> columns = new ArrayList<Column>();
    List<Expression> expList = new ArrayList<Expression>();
    Column col;
    Expression exp;
    jj_consume_token(K_WHEN);
    jj_consume_token(K_NOT);
    jj_consume_token(K_MATCHED);
    jj_consume_token(K_THEN);
    jj_consume_token(K_INSERT);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 266:{
      jj_consume_token(266);
      col = Column();
columns.add(col);
      label_32:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[101] = jj_gen;
          break label_32;
        }
        jj_consume_token(K_COMMA);
        col = Column();
columns.add(col);
      }
      jj_consume_token(267);
      break;
      }
    default:
      jj_la1[102] = jj_gen;
      ;
    }
    jj_consume_token(K_VALUES);
    jj_consume_token(266);
    exp = SimpleExpression();
expList.add(exp);
    label_33:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[103] = jj_gen;
        break label_33;
      }
      jj_consume_token(K_COMMA);
      exp = SimpleExpression();
expList.add(exp);
    }
    jj_consume_token(267);
return mi.withColumns(columns).withValues(expList);
}

  final public List<String> RelObjectNameList() throws ParseException {String token = null;
    List<String> data = new ArrayList<String>();
    token = RelObjectNameExt();
data.add(token);
    label_34:
    while (true) {
      if (jj_2_28(2)) {
        ;
      } else {
        break label_34;
      }
      jj_consume_token(270);
      label_35:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 270:{
          ;
          break;
          }
        default:
          jj_la1[104] = jj_gen;
          break label_35;
        }
        jj_consume_token(270);
data.add(null);
      }
      token = RelObjectNameExt2();
data.add(token);
    }
return data;
}

// See: http://technet.microsoft.com/en-us/library/ms187879%28v=sql.105%29.aspx
  final public 
Column Column() throws ParseException {/*@bgen(jjtree) Column */
    SimpleNode jjtn000 = new SimpleNode(JJTCOLUMN);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));List<String> data = new ArrayList<String>();
    try {
      data = RelObjectNameList();
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
Column col = new Column(data);
        linkAST(col,jjtn000);
        return col;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

/*
Not all names should be allowed for aliases.
*/
  final public String RelObjectNameWithoutValue() throws ParseException {Token tk = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_IDENTIFIER:{
      tk = jj_consume_token(S_IDENTIFIER);
      break;
      }
    case S_QUOTED_IDENTIFIER:{
      tk = jj_consume_token(S_QUOTED_IDENTIFIER);
      break;
      }
    case K_BYTE:{
      tk = jj_consume_token(K_BYTE);
      break;
      }
    case K_CHAR:{
      tk = jj_consume_token(K_CHAR);
      break;
      }
    case K_CHANGE:{
      tk = jj_consume_token(K_CHANGE);
      break;
      }
    case K_CHARACTER:{
      tk = jj_consume_token(K_CHARACTER);
      break;
      }
    case K_CAST:{
      tk = jj_consume_token(K_CAST);
      break;
      }
    case K_COMMENT:{
      tk = jj_consume_token(K_COMMENT);
      break;
      }
    case K_DISABLE:{
      tk = jj_consume_token(K_DISABLE);
      break;
      }
    case K_DESC:{
      tk = jj_consume_token(K_DESC);
      break;
      }
    case K_DO:{
      tk = jj_consume_token(K_DO);
      break;
      }
    case K_EXTRACT:{
      tk = jj_consume_token(K_EXTRACT);
      break;
      }
    case K_FIRST:{
      tk = jj_consume_token(K_FIRST);
      break;
      }
    case K_FOLLOWING:{
      tk = jj_consume_token(K_FOLLOWING);
      break;
      }
    case K_LAST:{
      tk = jj_consume_token(K_LAST);
      break;
      }
    case K_MATERIALIZED:{
      tk = jj_consume_token(K_MATERIALIZED);
      break;
      }
    case K_NULLS:{
      tk = jj_consume_token(K_NULLS);
      break;
      }
    case K_PARTITION:{
      tk = jj_consume_token(K_PARTITION);
      break;
      }
    case K_RANGE:{
      tk = jj_consume_token(K_RANGE);
      break;
      }
    case K_ROW:{
      tk = jj_consume_token(K_ROW);
      break;
      }
    case K_ROWS:{
      tk = jj_consume_token(K_ROWS);
      break;
      }
    case K_SIBLINGS:{
      tk = jj_consume_token(K_SIBLINGS);
      break;
      }
    case K_XML:{
      tk = jj_consume_token(K_XML);
      break;
      }
    case K_COLUMN:{
      tk = jj_consume_token(K_COLUMN);
      break;
      }
    case K_REPLACE:{
      tk = jj_consume_token(K_REPLACE);
      break;
      }
    case K_TRUNCATE:{
      tk = jj_consume_token(K_TRUNCATE);
      break;
      }
    case K_KEY:{
      tk = jj_consume_token(K_KEY);
      break;
      }
    case K_ANY:{
      tk = jj_consume_token(K_ANY);
      break;
      }
    case K_OPEN:{
      tk = jj_consume_token(K_OPEN);
      break;
      }
    case K_OVER:{
      tk = jj_consume_token(K_OVER);
      break;
      }
    case K_PERCENT:{
      tk = jj_consume_token(K_PERCENT);
      break;
      }
    case K_PRIOR:{
      tk = jj_consume_token(K_PRIOR);
      break;
      }
    case K_SEPARATOR:{
      tk = jj_consume_token(K_SEPARATOR);
      break;
      }
    case K_NO:{
      tk = jj_consume_token(K_NO);
      break;
      }
    case K_ACTION:{
      tk = jj_consume_token(K_ACTION);
      break;
      }
    case K_CASCADE:{
      tk = jj_consume_token(K_CASCADE);
      break;
      }
    case K_END:{
      tk = jj_consume_token(K_END);
      break;
      }
    case K_TABLE:{
      tk = jj_consume_token(K_TABLE);
      break;
      }
    case K_DATETIMELITERAL:{
      tk = jj_consume_token(K_DATETIMELITERAL);
      break;
      }
    case K_COMMIT:{
      tk = jj_consume_token(K_COMMIT);
      break;
      }
    case K_PRECISION:{
      tk = jj_consume_token(K_PRECISION);
      break;
      }
    case K_INSERT:{
      tk = jj_consume_token(K_INSERT);
      break;
      }
    case K_INDEX:{
      tk = jj_consume_token(K_INDEX);
      break;
      }
    case K_PRIMARY:{
      tk = jj_consume_token(K_PRIMARY);
      break;
      }
    case K_ENABLE:{
      tk = jj_consume_token(K_ENABLE);
      break;
      }
    case K_TEMP:{
      tk = jj_consume_token(K_TEMP);
      break;
      }
    case K_TEMPORARY:{
      tk = jj_consume_token(K_TEMPORARY);
      break;
      }
    case K_TO:{
      tk = jj_consume_token(K_TO);
      break;
      }
    case K_TYPE:{
      tk = jj_consume_token(K_TYPE);
      break;
      }
    case K_ISNULL:{
      tk = jj_consume_token(K_ISNULL);
      break;
      }
    case K_ZONE:{
      tk = jj_consume_token(K_ZONE);
      break;
      }
    case K_COLUMNS:{
      tk = jj_consume_token(K_COLUMNS);
      break;
      }
    case K_DESCRIBE:{
      tk = jj_consume_token(K_DESCRIBE);
      break;
      }
    case K_FN:{
      tk = jj_consume_token(K_FN);
      break;
      }
    case K_PATH:{
      tk = jj_consume_token(K_PATH);
      break;
      }
    case K_DATE_LITERAL:{
      tk = jj_consume_token(K_DATE_LITERAL);
      break;
      }
    case K_NEXTVAL:{
      tk = jj_consume_token(K_NEXTVAL);
      break;
      }
    case K_TRUE:{
      tk = jj_consume_token(K_TRUE);
      break;
      }
    case K_FALSE:{
      tk = jj_consume_token(K_FALSE);
      break;
      }
    case K_DUPLICATE:{
      tk = jj_consume_token(K_DUPLICATE);
      break;
      }
    case K_READ:{
      tk = jj_consume_token(K_READ);
      break;
      }
    case K_SCHEMA:{
      tk = jj_consume_token(K_SCHEMA);
      break;
      }
    case K_SIZE:{
      tk = jj_consume_token(K_SIZE);
      break;
      }
    case K_SEQUENCE:{
      tk = jj_consume_token(K_SEQUENCE);
      break;
      }
    case K_SESSION:{
      tk = jj_consume_token(K_SESSION);
      break;
      }
    case K_VIEW:{
      tk = jj_consume_token(K_VIEW);
      break;
      }
    case K_NOLOCK:{
      tk = jj_consume_token(K_NOLOCK);
      break;
      }
    case K_VALIDATE:{
      tk = jj_consume_token(K_VALIDATE);
      break;
      }
    case K_CYCLE:{
      tk = jj_consume_token(K_CYCLE);
      break;
      }
    case K_OF:{
      tk = jj_consume_token(K_OF);
      break;
      }
    case K_EXCLUDE:{
      tk = jj_consume_token(K_EXCLUDE);
      break;
      }
    case K_FORMAT:{
      tk = jj_consume_token(K_FORMAT);
      break;
      }
    case K_DIV:{
      tk = jj_consume_token(K_DIV);
      break;
      }
    case K_UNSIGNED:{
      tk = jj_consume_token(K_UNSIGNED);
      break;
      }
    default:
      jj_la1[105] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return tk.image;
}

/*
Normal names.
*/
  final public String RelObjectName() throws ParseException {Token tk = null; String result = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ANY:
    case K_BYTE:
    case K_CASCADE:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHAR:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_CYCLE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DIV:
    case K_DO:
    case K_DUPLICATE:
    case K_ENABLE:
    case K_END:
    case K_EXCLUDE:
    case K_EXTRACT:
    case K_FIRST:
    case K_FALSE:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_INDEX:
    case K_INSERT:
    case K_ISNULL:
    case K_KEY:
    case K_FN:
    case K_LAST:
    case K_MATERIALIZED:
    case K_NEXTVAL:
    case K_NO:
    case K_NOLOCK:
    case K_NULLS:
    case K_OF:
    case K_OPEN:
    case K_OVER:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_RANGE:
    case K_READ:
    case K_REPLACE:
    case K_ROW:
    case K_ROWS:
    case K_SCHEMA:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SIBLINGS:
    case K_SIZE:
    case K_TABLE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TO:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TYPE:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VIEW:
    case K_XML:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      result = RelObjectNameWithoutValue();
      break;
      }
    case K_GROUP:{
      tk = jj_consume_token(K_GROUP);
      break;
      }
    case K_INTERVAL:{
      tk = jj_consume_token(K_INTERVAL);
      break;
      }
    case K_ON:{
      tk = jj_consume_token(K_ON);
      break;
      }
    case K_ORDER:{
      tk = jj_consume_token(K_ORDER);
      break;
      }
    case K_START:{
      tk = jj_consume_token(K_START);
      break;
      }
    case K_TOP:{
      tk = jj_consume_token(K_TOP);
      break;
      }
    case K_VALUE:{
      tk = jj_consume_token(K_VALUE);
      break;
      }
    case K_VALUES:{
      tk = jj_consume_token(K_VALUES);
      break;
      }
    case K_CREATE:{
      tk = jj_consume_token(K_CREATE);
      break;
      }
    case K_TABLES:{
      tk = jj_consume_token(K_TABLES);
      break;
      }
    default:
      jj_la1[106] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if (tk!=null) result=tk.image;
                return result;
}

  final public String RelObjectNameWithoutStart() throws ParseException {Token tk = null; String result = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ANY:
    case K_BYTE:
    case K_CASCADE:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHAR:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_CYCLE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DIV:
    case K_DO:
    case K_DUPLICATE:
    case K_ENABLE:
    case K_END:
    case K_EXCLUDE:
    case K_EXTRACT:
    case K_FIRST:
    case K_FALSE:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_INDEX:
    case K_INSERT:
    case K_ISNULL:
    case K_KEY:
    case K_FN:
    case K_LAST:
    case K_MATERIALIZED:
    case K_NEXTVAL:
    case K_NO:
    case K_NOLOCK:
    case K_NULLS:
    case K_OF:
    case K_OPEN:
    case K_OVER:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_RANGE:
    case K_READ:
    case K_REPLACE:
    case K_ROW:
    case K_ROWS:
    case K_SCHEMA:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SIBLINGS:
    case K_SIZE:
    case K_TABLE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TO:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TYPE:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VIEW:
    case K_XML:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      result = RelObjectNameWithoutValue();
      break;
      }
    case K_TOP:{
      tk = jj_consume_token(K_TOP);
      break;
      }
    case K_VALUE:{
      tk = jj_consume_token(K_VALUE);
      break;
      }
    case K_VALUES:{
      tk = jj_consume_token(K_VALUES);
      break;
      }
    case K_INTERVAL:{
      tk = jj_consume_token(K_INTERVAL);
      break;
      }
    default:
      jj_la1[107] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if (tk!=null) result=tk.image;
                return result;
}

/*
Extended version of object names.
*/
  final public String RelObjectNameExt() throws ParseException {Token tk = null;
  String result=null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ANY:
    case K_BYTE:
    case K_CASCADE:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHAR:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_CREATE:
    case K_CYCLE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DIV:
    case K_DO:
    case K_DUPLICATE:
    case K_ENABLE:
    case K_END:
    case K_EXCLUDE:
    case K_EXTRACT:
    case K_FIRST:
    case K_FALSE:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_GROUP:
    case K_INDEX:
    case K_INSERT:
    case K_INTERVAL:
    case K_ISNULL:
    case K_KEY:
    case K_FN:
    case K_LAST:
    case K_MATERIALIZED:
    case K_NEXTVAL:
    case K_NO:
    case K_NOLOCK:
    case K_NULLS:
    case K_OF:
    case K_ON:
    case K_OPEN:
    case K_ORDER:
    case K_OVER:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_RANGE:
    case K_READ:
    case K_REPLACE:
    case K_ROW:
    case K_ROWS:
    case K_SCHEMA:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SIBLINGS:
    case K_SIZE:
    case K_START:
    case K_TABLE:
    case K_TABLES:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TYPE:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VIEW:
    case K_XML:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      result = RelObjectName();
      break;
      }
    case K_LEFT:{
      tk = jj_consume_token(K_LEFT);
      break;
      }
    case K_RIGHT:{
      tk = jj_consume_token(K_RIGHT);
      break;
      }
    case K_SET:{
      tk = jj_consume_token(K_SET);
      break;
      }
    case K_DOUBLE:{
      tk = jj_consume_token(K_DOUBLE);
      break;
      }
    case K_IF:{
      tk = jj_consume_token(K_IF);
      break;
      }
    case K_OPTIMIZE:{
      jj_consume_token(K_OPTIMIZE);
      break;
      }
    case K_LIMIT:{
      tk = jj_consume_token(K_LIMIT);
      break;
      }
    case K_OFFSET:{
      tk = jj_consume_token(K_OFFSET);
      break;
      }
    case K_PROCEDURE:{
      tk = jj_consume_token(K_PROCEDURE);
      break;
      }
    case K_PUBLIC:{
      tk = jj_consume_token(K_PUBLIC);
      break;
      }
    default:
      jj_la1[108] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if (tk!=null) result=tk.image;
        return result;
}

/*
Extended usage of object names - part 2. Using within multipart names as following parts.
*/
  final public String RelObjectNameExt2() throws ParseException {Token tk = null;
  String result=null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ANY:
    case K_BYTE:
    case K_CASCADE:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHAR:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_CREATE:
    case K_CYCLE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DIV:
    case K_DO:
    case K_DOUBLE:
    case K_DUPLICATE:
    case K_ENABLE:
    case K_END:
    case K_EXCLUDE:
    case K_EXTRACT:
    case K_FIRST:
    case K_FALSE:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_GROUP:
    case K_IF:
    case K_INDEX:
    case K_INSERT:
    case K_INTERVAL:
    case K_ISNULL:
    case K_KEY:
    case K_FN:
    case K_LAST:
    case K_LEFT:
    case K_LIMIT:
    case K_MATERIALIZED:
    case K_NEXTVAL:
    case K_NO:
    case K_NOLOCK:
    case K_NULLS:
    case K_OF:
    case K_OFFSET:
    case K_ON:
    case K_OPEN:
    case K_ORDER:
    case K_OVER:
    case K_OPTIMIZE:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_PROCEDURE:
    case K_PUBLIC:
    case K_RANGE:
    case K_READ:
    case K_REPLACE:
    case K_RIGHT:
    case K_ROW:
    case K_ROWS:
    case K_SCHEMA:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SET:
    case K_SIBLINGS:
    case K_SIZE:
    case K_START:
    case K_TABLE:
    case K_TABLES:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TYPE:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VIEW:
    case K_XML:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      result = RelObjectNameExt();
      break;
      }
    case K_FROM:{
      tk = jj_consume_token(K_FROM);
      break;
      }
    case K_SELECT:{
      tk = jj_consume_token(K_SELECT);
      break;
      }
    case K_CURRENT:{
      tk = jj_consume_token(K_CURRENT);
      break;
      }
    default:
      jj_la1[109] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if (tk!=null) result=tk.image;
        return result;
}

  final public Table Table() throws ParseException {/*@bgen(jjtree) Table */
    SimpleNode jjtn000 = new SimpleNode(JJTTABLE);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));//String serverName = null, databaseName = null, schemaName = null, tableName = null;
    List<String> data = new ArrayList<String>();
    try {
      data = RelObjectNameList();
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
Table table = new Table(data);
                linkAST(table,jjtn000);
        return table;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Table TableWithAlias() throws ParseException {Table table = null;
    Alias alias = null;
    table = Table();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ANY:
    case K_AS:
    case K_BYTE:
    case K_CASCADE:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHAR:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_CYCLE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DIV:
    case K_DO:
    case K_DUPLICATE:
    case K_ENABLE:
    case K_END:
    case K_EXCLUDE:
    case K_EXTRACT:
    case K_FIRST:
    case K_FALSE:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_INDEX:
    case K_INSERT:
    case K_INTERVAL:
    case K_ISNULL:
    case K_KEY:
    case K_FN:
    case K_LAST:
    case K_MATERIALIZED:
    case K_NEXTVAL:
    case K_NO:
    case K_NOLOCK:
    case K_NULLS:
    case K_OF:
    case K_OPEN:
    case K_OVER:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_RANGE:
    case K_READ:
    case K_REPLACE:
    case K_ROW:
    case K_ROWS:
    case K_SCHEMA:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SIBLINGS:
    case K_SIZE:
    case K_TABLE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TYPE:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VIEW:
    case K_XML:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:{
      alias = Alias();
table.setAlias(alias);
      break;
      }
    default:
      jj_la1[110] = jj_gen;
      ;
    }
return table;
}

  final public Select Select() throws ParseException {Select select = new Select();
    SelectBody selectBody = null;
    List<WithItem> with = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_WITH:{
      with = WithList();

      break;
      }
    default:
      jj_la1[111] = jj_gen;
      ;
    }
    selectBody = SelectBody();
return select.withWithItemsList(with).withSelectBody(selectBody);
}

  final public SelectBody SelectBody() throws ParseException {SelectBody selectBody = null;
    selectBody = SetOperationList();
return selectBody;
}

  final public PlainSelect PlainSelect() throws ParseException {/*@bgen(jjtree) PlainSelect */
    SimpleNode jjtn000 = new SimpleNode(JJTPLAINSELECT);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));PlainSelect plainSelect = new PlainSelect();
    List<SelectItem> selectItems = null;
    FromItem fromItem = null;
    List<Join> joins = null;
    List<SelectItem> distinctOn = null;
    Expression where = null;
    List<OrderByElement> orderByElements;
    GroupByElement groupBy = null;
    Expression having = null;
    Limit limit = null;
    Offset offset = null;
    Fetch fetch = null;
    OptimizeFor optimize = null;
    Top top = null;
        Skip skip = null;
        First first = null;
    OracleHierarchicalExpression oracleHierarchicalQueryClause = null;
    List<Table> intoTables = null;
    Table updateTable = null;
    Wait wait = null;
    boolean mySqlSqlCalcFoundRows = false;
    Token token;
    KSQLWindow ksqlWindow = null;
    boolean noWait = false;
    try {
      jj_consume_token(K_SELECT);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_STRAIGHT:{
        jj_consume_token(K_STRAIGHT);
plainSelect.setMySqlHintStraightJoin(true);
        break;
        }
      default:
        jj_la1[112] = jj_gen;
        ;
      }
plainSelect.setOracleHint(getOracleHint());
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_SKIP:{
        skip = Skip();
plainSelect.setSkip(skip);
        break;
        }
      default:
        jj_la1[113] = jj_gen;
        ;
      }
      if (jj_2_29(2)) {
        first = First();
plainSelect.setFirst(first);
      } else {
        ;
      }
      if (jj_2_31(2)) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ALL:{
          jj_consume_token(K_ALL);
          break;
          }
        case K_DISTINCT:{
          jj_consume_token(K_DISTINCT);
Distinct distinct = new Distinct(); plainSelect.setDistinct(distinct);
          if (jj_2_30(2)) {
            jj_consume_token(K_ON);
            jj_consume_token(266);
            distinctOn = SelectItemsList();
plainSelect.getDistinct().setOnSelectItems(distinctOn);
            jj_consume_token(267);
          } else {
            ;
          }
          break;
          }
        case K_UNIQUE:{
          jj_consume_token(K_UNIQUE);
Distinct distinct = new Distinct(true); plainSelect.setDistinct(distinct);
          break;
          }
        case K_SQL_CALC_FOUND_ROWS:{
          jj_consume_token(K_SQL_CALC_FOUND_ROWS);
plainSelect.setMySqlSqlCalcFoundRows(true);
          break;
          }
        case K_SQL_NO_CACHE:{
          jj_consume_token(K_SQL_NO_CACHE);
plainSelect.setMySqlSqlNoCache(true);
          break;
          }
        default:
          jj_la1[114] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else {
        ;
      }
      if (jj_2_32(2)) {
        top = Top();
plainSelect.setTop(top);
      } else {
        ;
      }
      selectItems = SelectItemsList();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_INTO:{
        intoTables = IntoClause();
plainSelect.setIntoTables(intoTables);
        break;
        }
      default:
        jj_la1[115] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_FROM:{
        jj_consume_token(K_FROM);
        fromItem = FromItem();
        joins = JoinsList();
        break;
        }
      default:
        jj_la1[116] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_WINDOW:{
        ksqlWindow = KSQLWindowClause();
plainSelect.setKsqlWindow(ksqlWindow);
        break;
        }
      default:
        jj_la1[117] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_WHERE:{
        where = WhereClause();
plainSelect.setWhere(where);
        break;
        }
      default:
        jj_la1[118] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_CONNECT:
      case K_START:{
        oracleHierarchicalQueryClause = OracleHierarchicalQueryClause();
plainSelect.setOracleHierarchical(oracleHierarchicalQueryClause);
        break;
        }
      default:
        jj_la1[119] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_GROUP:{
        groupBy = GroupByColumnReferences();
plainSelect.setGroupByElement(groupBy);
        break;
        }
      default:
        jj_la1[120] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_HAVING:{
        having = Having();
plainSelect.setHaving(having);
        break;
        }
      default:
        jj_la1[121] = jj_gen;
        ;
      }
      if (jj_2_33(2147483647)) {
        orderByElements = OrderByElements();
plainSelect.setOracleSiblings(true); plainSelect.setOrderByElements(orderByElements);
      } else {
        ;
      }
      if (jj_2_34(2147483647)) {
        orderByElements = OrderByElements();
plainSelect.setOrderByElements(orderByElements);
      } else {
        ;
      }
      if (jj_2_35(2147483647)) {
        limit = LimitWithOffset();
plainSelect.setLimit(limit);
      } else {
        ;
      }
      if (jj_2_36(2147483647)) {
        offset = Offset();
plainSelect.setOffset(offset);
      } else {
        ;
      }
      if (jj_2_37(2147483647) && (limit==null)) {
        limit = LimitWithOffset();
plainSelect.setLimit(limit);
      } else {
        ;
      }
      if (jj_2_38(2147483647)) {
        fetch = Fetch();
plainSelect.setFetch(fetch);
      } else {
        ;
      }
      if (jj_2_40(2)) {
        jj_consume_token(K_FOR);
        jj_consume_token(K_UPDATE);
plainSelect.setForUpdate(true);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_OF:{
          jj_consume_token(K_OF);
          updateTable = Table();
plainSelect.setForUpdateTable(updateTable);
          break;
          }
        default:
          jj_la1[122] = jj_gen;
          ;
        }
        if (jj_2_39(2147483647)) {
          wait = Wait();
plainSelect.setWait(wait);
        } else {
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_NOWAIT:{
          jj_consume_token(K_NOWAIT);
plainSelect.setNoWait(true);
          break;
          }
        default:
          jj_la1[123] = jj_gen;
          ;
        }
      } else {
        ;
      }
      if (jj_2_41(2147483647)) {
        optimize = OptimizeFor();
plainSelect.setOptimizeFor(optimize);
      } else {
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_FOR:{
        jj_consume_token(K_FOR);
        jj_consume_token(K_XML);
        jj_consume_token(K_PATH);
        jj_consume_token(266);
        token = jj_consume_token(S_CHAR_LITERAL);
        jj_consume_token(267);
plainSelect.setForXmlPath(token.image);
        break;
        }
      default:
        jj_la1[124] = jj_gen;
        ;
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
plainSelect.setSelectItems(selectItems);
        plainSelect.setFromItem(fromItem);
        if (joins != null && joins.size() > 0)
            plainSelect.setJoins(joins);
        linkAST(plainSelect,jjtn000);
        return plainSelect;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public SelectBody SetOperationList() throws ParseException {/*@bgen(jjtree) SetOperationList */
    SimpleNode jjtn000 = new SimpleNode(JJTSETOPERATIONLIST);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));SetOperationList list = new SetOperationList();
    List<OrderByElement> orderByElements = null;
    Limit limit = null;
    Offset offset = null;
    Fetch fetch = null;
    SelectBody select = null;
    List<SelectBody> selects = new ArrayList<SelectBody>();
    List<SetOperation> operations = new ArrayList<SetOperation>();
    List<Boolean> brackets = new ArrayList<Boolean>();
    boolean bracket;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 266:{
        jj_consume_token(266);
        select = SelectBody();
        jj_consume_token(267);
bracket=true;
        break;
        }
      case K_SELECT:
      case K_VALUES:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_SELECT:{
          select = PlainSelect();
          break;
          }
        case K_VALUES:{
          select = Values();
          break;
          }
        default:
          jj_la1[125] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
bracket=false;
        break;
        }
      default:
        jj_la1[126] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
selects.add(select);brackets.add(bracket);
      label_36:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_EXCEPT:
        case K_INTERSECT:
        case K_MINUS:
        case K_UNION:{
          ;
          break;
          }
        default:
          jj_la1[127] = jj_gen;
          break label_36;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_UNION:{
          jj_consume_token(K_UNION);
UnionOp union = new UnionOp();linkAST(union,jjtn000);operations.add(union);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ALL:
          case K_DISTINCT:{
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_ALL:{
              jj_consume_token(K_ALL);
union.setAll(true);
              break;
              }
            case K_DISTINCT:{
              jj_consume_token(K_DISTINCT);
union.setDistinct(true);
              break;
              }
            default:
              jj_la1[128] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            break;
            }
          default:
            jj_la1[129] = jj_gen;
            ;
          }
          break;
          }
        case K_INTERSECT:{
          jj_consume_token(K_INTERSECT);
operations.add(new IntersectOp());
          break;
          }
        case K_MINUS:{
          jj_consume_token(K_MINUS);
operations.add(new MinusOp());
          break;
          }
        case K_EXCEPT:{
          jj_consume_token(K_EXCEPT);
operations.add(new ExceptOp());
          break;
          }
        default:
          jj_la1[130] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 266:{
          jj_consume_token(266);
          select = SelectBody();
          jj_consume_token(267);
bracket=true;
          break;
          }
        case K_SELECT:
        case K_VALUES:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_SELECT:{
            select = PlainSelect();
            break;
            }
          case K_VALUES:{
            select = Values();
            break;
            }
          default:
            jj_la1[131] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
bracket=false;
          break;
          }
        default:
          jj_la1[132] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
selects.add(select);brackets.add(bracket);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ORDER:{
        orderByElements = OrderByElements();
list.setOrderByElements(orderByElements);
        break;
        }
      default:
        jj_la1[133] = jj_gen;
        ;
      }
      if (jj_2_42(2147483647)) {
        limit = LimitWithOffset();
list.setLimit(limit);
      } else {
        ;
      }
      if (jj_2_43(2147483647)) {
        offset = Offset();
list.setOffset(offset);
      } else {
        ;
      }
      if (jj_2_44(2147483647)) {
        fetch = Fetch();
list.setFetch(fetch);
      } else {
        ;
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
if (selects.size()==1 && selects.get(0) instanceof PlainSelect && orderByElements==null) {
            if (brackets.get(0))
                ((PlainSelect)selects.get(0)).setUseBrackets(true);
            return selects.get(0);
        } else {
            if (selects.size()>1 && selects.get(selects.size()-1) instanceof PlainSelect) {
                PlainSelect ps = (PlainSelect)selects.get(selects.size()-1);
                if (ps.getOrderByElements() != null) {
                    list.setOrderByElements(ps.getOrderByElements());
                    ps.setOrderByElements(null);
                }
            }
            list.setBracketsOpsAndSelects(brackets,selects,operations);
            return list;
        }
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public List<WithItem> WithList() throws ParseException {List<WithItem> withItemsList = new ArrayList<WithItem>();
    WithItem with = null;
    jj_consume_token(K_WITH);
    with = WithItem();
withItemsList.add(with);
    label_37:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[134] = jj_gen;
        break label_37;
      }
      jj_consume_token(K_COMMA);
      with = WithItem();
withItemsList.add(with);
    }
return withItemsList;
}

  final public WithItem WithItem() throws ParseException {/*@bgen(jjtree) WithItem */
    SimpleNode jjtn000 = new SimpleNode(JJTWITHITEM);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));WithItem with = new WithItem();
    String name = null;
    List<SelectItem> selectItems = null;
    SelectBody selectBody = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_RECURSIVE:{
        jj_consume_token(K_RECURSIVE);
with.setRecursive(true);
        break;
        }
      default:
        jj_la1[135] = jj_gen;
        ;
      }
      name = RelObjectName();
with.setName(name);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 266:{
        jj_consume_token(266);
        selectItems = SelectItemsList();
        jj_consume_token(267);
with.setWithItemList(selectItems);
        break;
        }
      default:
        jj_la1[136] = jj_gen;
        ;
      }
      jj_consume_token(K_AS);
      jj_consume_token(266);
      selectBody = SelectBody();
with.setSelectBody(selectBody);
      jj_consume_token(267);
jjtree.closeNodeScope(jjtn000, true);
       jjtc000 = false;
       jjtn000.jjtSetLastToken(getToken(0));
return with;
    } catch (Throwable jjte000) {
if (jjtc000) {
         jjtree.clearNodeScope(jjtn000);
         jjtc000 = false;
       } else {
         jjtree.popNode();
       }
       if (jjte000 instanceof RuntimeException) {
         {if (true) throw (RuntimeException)jjte000;}
       }
       if (jjte000 instanceof ParseException) {
         {if (true) throw (ParseException)jjte000;}
       }
       {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
         jjtree.closeNodeScope(jjtn000, true);
         jjtn000.jjtSetLastToken(getToken(0));
       }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public List<SelectItem> SelectItemsList() throws ParseException {List<SelectItem> selectItemsList = new ArrayList<SelectItem>();
    SelectItem selectItem = null;
    selectItem = SelectItem();
selectItemsList.add(selectItem);
    label_38:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[137] = jj_gen;
        break label_38;
      }
      jj_consume_token(K_COMMA);
      selectItem = SelectItem();
selectItemsList.add(selectItem);
    }
return selectItemsList;
}

  final public SelectExpressionItem SelectExpressionItem() throws ParseException {SelectExpressionItem selectExpressionItem = null;
    Expression expression = null;
    Alias alias = null;
    expression = Condition();
selectExpressionItem = new SelectExpressionItem(); selectExpressionItem.setExpression(expression);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ANY:
    case K_AS:
    case K_BYTE:
    case K_CASCADE:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHAR:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_CYCLE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DIV:
    case K_DO:
    case K_DUPLICATE:
    case K_ENABLE:
    case K_END:
    case K_EXCLUDE:
    case K_EXTRACT:
    case K_FIRST:
    case K_FALSE:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_INDEX:
    case K_INSERT:
    case K_INTERVAL:
    case K_ISNULL:
    case K_KEY:
    case K_FN:
    case K_LAST:
    case K_MATERIALIZED:
    case K_NEXTVAL:
    case K_NO:
    case K_NOLOCK:
    case K_NULLS:
    case K_OF:
    case K_OPEN:
    case K_OVER:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_RANGE:
    case K_READ:
    case K_REPLACE:
    case K_ROW:
    case K_ROWS:
    case K_SCHEMA:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SIBLINGS:
    case K_SIZE:
    case K_TABLE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TYPE:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VIEW:
    case K_XML:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:{
      alias = Alias();
selectExpressionItem.setAlias(alias);
      break;
      }
    default:
      jj_la1[138] = jj_gen;
      ;
    }
return selectExpressionItem;
}

  final public SelectItem SelectItem() throws ParseException {/*@bgen(jjtree) SelectItem */
    SimpleNode jjtn000 = new SimpleNode(JJTSELECTITEM);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));SelectItem selectItem = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 269:{
        jj_consume_token(269);
selectItem = new AllColumns();
        break;
        }
      default:
        jj_la1[139] = jj_gen;
        if (jj_2_45(2147483647)) {
          selectItem = AllTableColumns();
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ACTION:
          case K_ALL:
          case K_ANY:
          case K_BYTE:
          case K_CASCADE:
          case K_CASE:
          case K_CAST:
          case K_CHARACTER:
          case K_CHANGE:
          case K_CHAR:
          case K_COLUMN:
          case K_COLUMNS:
          case K_COMMIT:
          case K_COMMENT:
          case K_CREATE:
          case K_CURRENT:
          case K_CYCLE:
          case K_DATETIMELITERAL:
          case K_DATE_LITERAL:
          case K_DESC:
          case K_DESCRIBE:
          case K_DISABLE:
          case K_DIV:
          case K_DO:
          case K_DOUBLE:
          case K_DUPLICATE:
          case K_ENABLE:
          case K_END:
          case K_EXCLUDE:
          case K_EXISTS:
          case K_EXTRACT:
          case K_FIRST:
          case K_FALSE:
          case K_FOLLOWING:
          case K_FORMAT:
          case K_GROUP:
          case K_GROUP_CONCAT:
          case K_IF:
          case K_IIF:
          case K_INDEX:
          case K_INSERT:
          case K_INTERVAL:
          case K_ISNULL:
          case K_KEY:
          case K_FN:
          case K_LAST:
          case K_LEFT:
          case K_LIMIT:
          case K_MATCH:
          case K_MATERIALIZED:
          case K_NEXTVAL:
          case K_NO:
          case K_NOLOCK:
          case K_NOT:
          case K_NULL:
          case K_NULLS:
          case K_OF:
          case K_OFFSET:
          case K_ON:
          case K_OPEN:
          case K_ORDER:
          case K_OVER:
          case K_OPTIMIZE:
          case K_PARTITION:
          case K_PATH:
          case K_PERCENT:
          case K_PRECISION:
          case K_PRIMARY:
          case K_PRIOR:
          case K_PROCEDURE:
          case K_PUBLIC:
          case K_RANGE:
          case K_READ:
          case K_REPLACE:
          case K_RIGHT:
          case K_ROW:
          case K_ROWS:
          case K_SCHEMA:
          case K_SEQUENCE:
          case K_SEPARATOR:
          case K_SESSION:
          case K_SET:
          case K_SIBLINGS:
          case K_SIZE:
          case K_SOME:
          case K_START:
          case K_TABLE:
          case K_TABLES:
          case K_TEMP:
          case K_TEMPORARY:
          case K_TIME_KEY_EXPR:
          case K_TO:
          case K_TOP:
          case K_TRUNCATE:
          case K_TRUE:
          case K_TYPE:
          case K_UNSIGNED:
          case K_VALIDATE:
          case K_VALUE:
          case K_VALUES:
          case K_VIEW:
          case K_XML:
          case K_XMLSERIALIZE:
          case K_ZONE:
          case S_DOUBLE:
          case S_LONG:
          case S_HEX:
          case S_IDENTIFIER:
          case S_CHAR_LITERAL:
          case S_QUOTED_IDENTIFIER:
          case 266:
          case 271:
          case 272:
          case 273:
          case 274:
          case 277:
          case 278:
          case 286:
          case 296:
          case 298:
          case 299:
          case 303:
          case 312:{
            selectItem = SelectExpressionItem();
            break;
            }
          default:
            jj_la1[140] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
linkAST(selectItem,jjtn000);
        return selectItem;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public AllTableColumns AllTableColumns() throws ParseException {Table table = null;
    table = Table();
    jj_consume_token(270);
    jj_consume_token(269);
return new AllTableColumns(table);
}

  final public Alias Alias() throws ParseException {String name = null;
  Token token = null;
  boolean useAs = false;
  Alias alias;
  String colname;
  ColDataType colDataType = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_AS:{
      jj_consume_token(K_AS);
useAs = true;
      break;
      }
    default:
      jj_la1[141] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ANY:
    case K_BYTE:
    case K_CASCADE:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHAR:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_CYCLE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DIV:
    case K_DO:
    case K_DUPLICATE:
    case K_ENABLE:
    case K_END:
    case K_EXCLUDE:
    case K_EXTRACT:
    case K_FIRST:
    case K_FALSE:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_INDEX:
    case K_INSERT:
    case K_INTERVAL:
    case K_ISNULL:
    case K_KEY:
    case K_FN:
    case K_LAST:
    case K_MATERIALIZED:
    case K_NEXTVAL:
    case K_NO:
    case K_NOLOCK:
    case K_NULLS:
    case K_OF:
    case K_OPEN:
    case K_OVER:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_RANGE:
    case K_READ:
    case K_REPLACE:
    case K_ROW:
    case K_ROWS:
    case K_SCHEMA:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SIBLINGS:
    case K_SIZE:
    case K_TABLE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TYPE:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VIEW:
    case K_XML:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      name = RelObjectNameWithoutStart();
      break;
      }
    case S_CHAR_LITERAL:{
      token = jj_consume_token(S_CHAR_LITERAL);
name=token.image;
      break;
      }
    default:
      jj_la1[142] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
alias = new Alias(name,useAs);
    if (jj_2_46(2)) {
      jj_consume_token(266);
List<Alias.AliasColumn> list = new ArrayList<Alias.AliasColumn>();
      colname = RelObjectName();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_BINARY:
      case K_BIT:
      case K_CHARACTER:
      case K_CHAR:
      case K_DATETIMELITERAL:
      case K_DATE_LITERAL:
      case K_DOUBLE:
      case K_INTERVAL:
      case K_JSON:
      case K_SET:
      case K_SIGNED:
      case K_UNSIGNED:
      case K_XML:
      case DT_ZONE:
      case S_IDENTIFIER:{
        colDataType = ColDataType();
        break;
        }
      default:
        jj_la1[143] = jj_gen;
        ;
      }
list.add(new Alias.AliasColumn(colname, colDataType));
      label_39:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[144] = jj_gen;
          break label_39;
        }
        jj_consume_token(K_COMMA);
colDataType=null;
        colname = RelObjectName();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_BINARY:
        case K_BIT:
        case K_CHARACTER:
        case K_CHAR:
        case K_DATETIMELITERAL:
        case K_DATE_LITERAL:
        case K_DOUBLE:
        case K_INTERVAL:
        case K_JSON:
        case K_SET:
        case K_SIGNED:
        case K_UNSIGNED:
        case K_XML:
        case DT_ZONE:
        case S_IDENTIFIER:{
          colDataType = ColDataType();
          break;
          }
        default:
          jj_la1[145] = jj_gen;
          ;
        }
list.add(new Alias.AliasColumn(colname, colDataType));
      }
      jj_consume_token(267);
alias.setAliasColumns(list);
    } else {
      ;
    }
return alias;
}

  final public void SQLServerHint(SQLServerHints hints) throws ParseException {String str;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_INDEX:{
      jj_consume_token(K_INDEX);
      jj_consume_token(266);
      str = RelObjectName();
      jj_consume_token(267);
hints.setIndexName(str);
      break;
      }
    case K_NOLOCK:{
      jj_consume_token(K_NOLOCK);
hints.withNoLock();
      break;
      }
    default:
      jj_la1[146] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public SQLServerHints SQLServerHints() throws ParseException {SQLServerHints hints = new SQLServerHints();
    jj_consume_token(K_WITH);
    jj_consume_token(266);
    SQLServerHint(hints);
    label_40:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[147] = jj_gen;
        break label_40;
      }
      jj_consume_token(K_COMMA);
      SQLServerHint(hints);
    }
    jj_consume_token(267);
return hints;
}

  final public MySQLIndexHint MySQLIndexHint() throws ParseException {Token actionToken = null;
        Token indexToken = null;
        String indexName = null;
        List<String> indexNameList = new ArrayList<String>();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_USE:{
      actionToken = jj_consume_token(K_USE);
      break;
      }
    case K_SHOW:{
      actionToken = jj_consume_token(K_SHOW);
      break;
      }
    case K_IGNORE:{
      actionToken = jj_consume_token(K_IGNORE);
      break;
      }
    case K_FORCE:{
      actionToken = jj_consume_token(K_FORCE);
      break;
      }
    default:
      jj_la1[148] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_INDEX:{
      indexToken = jj_consume_token(K_INDEX);
      break;
      }
    case K_KEY:{
      indexToken = jj_consume_token(K_KEY);
      break;
      }
    default:
      jj_la1[149] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(266);
    indexName = Identifier();
indexNameList.add(indexName);
    label_41:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[150] = jj_gen;
        break label_41;
      }
      jj_consume_token(K_COMMA);
      indexName = Identifier();
indexNameList.add(indexName);
    }
    jj_consume_token(267);
return new MySQLIndexHint(actionToken.image, indexToken.image, indexNameList);
}

  final public String Identifier() throws ParseException {Token tk = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_IDENTIFIER:{
      tk = jj_consume_token(S_IDENTIFIER);
      break;
      }
    case S_QUOTED_IDENTIFIER:{
      tk = jj_consume_token(S_QUOTED_IDENTIFIER);
      break;
      }
    default:
      jj_la1[151] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return tk.image;
}

  final public FunctionItem FunctionItem() throws ParseException {Alias alias = null;
    Function function;
     FunctionItem functionItem;
    function = Function();
functionItem = new FunctionItem(); functionItem.setFunction(function);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ANY:
    case K_AS:
    case K_BYTE:
    case K_CASCADE:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHAR:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_CYCLE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DIV:
    case K_DO:
    case K_DUPLICATE:
    case K_ENABLE:
    case K_END:
    case K_EXCLUDE:
    case K_EXTRACT:
    case K_FIRST:
    case K_FALSE:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_INDEX:
    case K_INSERT:
    case K_INTERVAL:
    case K_ISNULL:
    case K_KEY:
    case K_FN:
    case K_LAST:
    case K_MATERIALIZED:
    case K_NEXTVAL:
    case K_NO:
    case K_NOLOCK:
    case K_NULLS:
    case K_OF:
    case K_OPEN:
    case K_OVER:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_RANGE:
    case K_READ:
    case K_REPLACE:
    case K_ROW:
    case K_ROWS:
    case K_SCHEMA:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SIBLINGS:
    case K_SIZE:
    case K_TABLE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TYPE:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VIEW:
    case K_XML:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:{
      alias = Alias();
functionItem.setAlias(alias);
      break;
      }
    default:
      jj_la1[152] = jj_gen;
      ;
    }
return functionItem;
}

  final public List<Column> PivotForColumns() throws ParseException {List<Column> columns = new ArrayList<Column>();
    Column column;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 266:{
      jj_consume_token(266);
      column = Column();
columns.add(column);
      label_42:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[153] = jj_gen;
          break label_42;
        }
        jj_consume_token(K_COMMA);
        column = Column();
columns.add(column);
      }
      jj_consume_token(267);
      break;
      }
    case K_ACTION:
    case K_ANY:
    case K_BYTE:
    case K_CASCADE:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHAR:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_CREATE:
    case K_CYCLE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DIV:
    case K_DO:
    case K_DOUBLE:
    case K_DUPLICATE:
    case K_ENABLE:
    case K_END:
    case K_EXCLUDE:
    case K_EXTRACT:
    case K_FIRST:
    case K_FALSE:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_GROUP:
    case K_IF:
    case K_INDEX:
    case K_INSERT:
    case K_INTERVAL:
    case K_ISNULL:
    case K_KEY:
    case K_FN:
    case K_LAST:
    case K_LEFT:
    case K_LIMIT:
    case K_MATERIALIZED:
    case K_NEXTVAL:
    case K_NO:
    case K_NOLOCK:
    case K_NULLS:
    case K_OF:
    case K_OFFSET:
    case K_ON:
    case K_OPEN:
    case K_ORDER:
    case K_OVER:
    case K_OPTIMIZE:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_PROCEDURE:
    case K_PUBLIC:
    case K_RANGE:
    case K_READ:
    case K_REPLACE:
    case K_RIGHT:
    case K_ROW:
    case K_ROWS:
    case K_SCHEMA:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SET:
    case K_SIBLINGS:
    case K_SIZE:
    case K_START:
    case K_TABLE:
    case K_TABLES:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TYPE:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VIEW:
    case K_XML:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      column = Column();
columns.add(column);
      break;
      }
    default:
      jj_la1[154] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return columns;
}

  final public List<FunctionItem> PivotFunctionItems() throws ParseException {List< FunctionItem> functionItems = new ArrayList< FunctionItem>();
    FunctionItem item;
    item = FunctionItem();
functionItems.add(item);
    label_43:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[155] = jj_gen;
        break label_43;
      }
      jj_consume_token(K_COMMA);
      item = FunctionItem();
functionItems.add(item);
    }
return functionItems;
}

  final public List<SelectExpressionItem> PivotSingleInItems() throws ParseException {List<SelectExpressionItem> retval = new ArrayList<SelectExpressionItem>();
   SelectExpressionItem item;
    item = PivotSelectExprItem();
retval.add(item);
    label_44:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[156] = jj_gen;
        break label_44;
      }
      jj_consume_token(K_COMMA);
      item = PivotSelectExprItem();
retval.add(item);
    }
return retval;
}

  final public SelectExpressionItem PivotSelectExprItem() throws ParseException {SelectExpressionItem selectExpressionItem = null;
    Expression expression = null;
    Alias alias = null;
    expression = SimpleExpression();
selectExpressionItem = new SelectExpressionItem(); selectExpressionItem.setExpression(expression);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ANY:
    case K_AS:
    case K_BYTE:
    case K_CASCADE:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHAR:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_CYCLE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DIV:
    case K_DO:
    case K_DUPLICATE:
    case K_ENABLE:
    case K_END:
    case K_EXCLUDE:
    case K_EXTRACT:
    case K_FIRST:
    case K_FALSE:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_INDEX:
    case K_INSERT:
    case K_INTERVAL:
    case K_ISNULL:
    case K_KEY:
    case K_FN:
    case K_LAST:
    case K_MATERIALIZED:
    case K_NEXTVAL:
    case K_NO:
    case K_NOLOCK:
    case K_NULLS:
    case K_OF:
    case K_OPEN:
    case K_OVER:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_RANGE:
    case K_READ:
    case K_REPLACE:
    case K_ROW:
    case K_ROWS:
    case K_SCHEMA:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SIBLINGS:
    case K_SIZE:
    case K_TABLE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TYPE:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VIEW:
    case K_XML:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:{
      alias = Alias();
selectExpressionItem.setAlias(alias);
      break;
      }
    default:
      jj_la1[157] = jj_gen;
      ;
    }
return selectExpressionItem;
}

  final public ExpressionListItem ExpressionListItem() throws ParseException {ExpressionListItem expressionListItem = null;
    ExpressionList expressionList = null;
    Alias alias = null;
    jj_consume_token(266);
    expressionList = SimpleExpressionList();
expressionListItem = new ExpressionListItem(); expressionListItem.setExpressionList(expressionList);
    jj_consume_token(267);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ANY:
    case K_AS:
    case K_BYTE:
    case K_CASCADE:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHAR:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_CYCLE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DIV:
    case K_DO:
    case K_DUPLICATE:
    case K_ENABLE:
    case K_END:
    case K_EXCLUDE:
    case K_EXTRACT:
    case K_FIRST:
    case K_FALSE:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_INDEX:
    case K_INSERT:
    case K_INTERVAL:
    case K_ISNULL:
    case K_KEY:
    case K_FN:
    case K_LAST:
    case K_MATERIALIZED:
    case K_NEXTVAL:
    case K_NO:
    case K_NOLOCK:
    case K_NULLS:
    case K_OF:
    case K_OPEN:
    case K_OVER:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_RANGE:
    case K_READ:
    case K_REPLACE:
    case K_ROW:
    case K_ROWS:
    case K_SCHEMA:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SIBLINGS:
    case K_SIZE:
    case K_TABLE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TYPE:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VIEW:
    case K_XML:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:{
      alias = Alias();
expressionListItem.setAlias(alias);
      break;
      }
    default:
      jj_la1[158] = jj_gen;
      ;
    }
return expressionListItem;
}

  final public List<ExpressionListItem> PivotMultiInItems() throws ParseException {List<ExpressionListItem> retval = new ArrayList<ExpressionListItem>();
   ExpressionListItem item;
    item = ExpressionListItem();
retval.add(item);
    label_45:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[159] = jj_gen;
        break label_45;
      }
      jj_consume_token(K_COMMA);
      item = ExpressionListItem();
retval.add(item);
    }
return retval;
}

  final public Pivot Pivot() throws ParseException {Pivot retval = new Pivot();
    List<FunctionItem> functionItems;
    List<Column> forColumns;
    List<SelectExpressionItem> singleInItems = null;
    List<ExpressionListItem> multiInItems = null;
    Alias alias = null;
    jj_consume_token(K_PIVOT);
    jj_consume_token(266);
    functionItems = PivotFunctionItems();
    jj_consume_token(K_FOR);
    forColumns = PivotForColumns();
    jj_consume_token(K_IN);
    jj_consume_token(266);
    if (jj_2_47(3)) {
      singleInItems = PivotSingleInItems();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 266:{
        multiInItems = PivotMultiInItems();
        break;
        }
      default:
        jj_la1[160] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(267);
    jj_consume_token(267);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ANY:
    case K_AS:
    case K_BYTE:
    case K_CASCADE:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHAR:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_CYCLE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DIV:
    case K_DO:
    case K_DUPLICATE:
    case K_ENABLE:
    case K_END:
    case K_EXCLUDE:
    case K_EXTRACT:
    case K_FIRST:
    case K_FALSE:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_INDEX:
    case K_INSERT:
    case K_INTERVAL:
    case K_ISNULL:
    case K_KEY:
    case K_FN:
    case K_LAST:
    case K_MATERIALIZED:
    case K_NEXTVAL:
    case K_NO:
    case K_NOLOCK:
    case K_NULLS:
    case K_OF:
    case K_OPEN:
    case K_OVER:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_RANGE:
    case K_READ:
    case K_REPLACE:
    case K_ROW:
    case K_ROWS:
    case K_SCHEMA:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SIBLINGS:
    case K_SIZE:
    case K_TABLE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TYPE:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VIEW:
    case K_XML:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:{
      alias = Alias();
      break;
      }
    default:
      jj_la1[161] = jj_gen;
      ;
    }
retval.setFunctionItems(functionItems);
        retval.setForColumns(forColumns);
        retval.setSingleInItems(singleInItems);
        retval.setMultiInItems(multiInItems);
        retval.setAlias(alias);
        return retval;
}

  final public PivotXml PivotXml() throws ParseException {PivotXml retval = new PivotXml();
    List<FunctionItem> functionItems;
    List<Column> forColumns;
    List<SelectExpressionItem> singleInItems = null;
    List<ExpressionListItem> multiInItems = null;
    SelectBody inSelect = null;
    jj_consume_token(K_PIVOT);
    jj_consume_token(K_XML);
    jj_consume_token(266);
    functionItems = PivotFunctionItems();
    jj_consume_token(K_FOR);
    forColumns = PivotForColumns();
    jj_consume_token(K_IN);
    jj_consume_token(266);
    if (jj_2_48(2)) {
      jj_consume_token(K_ANY);
retval.setInAny(true);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_SELECT:
      case K_VALUES:
      case 266:{
        inSelect = SelectBody();
        break;
        }
      default:
        jj_la1[162] = jj_gen;
        if (jj_2_49(2)) {
          singleInItems = PivotSingleInItems();
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 266:{
            multiInItems = PivotMultiInItems();
            break;
            }
          default:
            jj_la1[163] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
    }
    jj_consume_token(267);
    jj_consume_token(267);
retval.setFunctionItems(functionItems);
        retval.setForColumns(forColumns);
        retval.setSingleInItems(singleInItems);
        retval.setMultiInItems(multiInItems);
        retval.setInSelect(inSelect);
        return retval;
}

  final public UnPivot UnPivot() throws ParseException {UnPivot retval = new UnPivot();
    Column unpivotClause;
    List<Column> unpivotForClause;
    List<SelectExpressionItem> unpivotInClause;
    jj_consume_token(K_UNPIVOT);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_EXCLUDE:
    case K_INCLUDE:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_INCLUDE:{
        jj_consume_token(K_INCLUDE);
        jj_consume_token(K_NULLS);
retval.setIncludeNulls(true);
        break;
        }
      case K_EXCLUDE:{
        jj_consume_token(K_EXCLUDE);
        jj_consume_token(K_NULLS);
retval.setIncludeNulls(false);
        break;
        }
      default:
        jj_la1[164] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[165] = jj_gen;
      ;
    }
    jj_consume_token(266);
    unpivotClause = Column();
    jj_consume_token(K_FOR);
    unpivotForClause = PivotForColumns();
    jj_consume_token(K_IN);
    jj_consume_token(266);
    unpivotInClause = PivotSingleInItems();
    jj_consume_token(267);
    jj_consume_token(267);
retval.setUnPivotClause(unpivotClause);
        retval.setUnPivotForClause(unpivotForClause);
        retval.setUnPivotInClause(unpivotInClause);
        return retval;
}

  final public List<Table> IntoClause() throws ParseException {List<Table> tables = new ArrayList<Table>();
    Table table;
    jj_consume_token(K_INTO);
    table = Table();
tables.add(table);
    label_46:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[166] = jj_gen;
        break label_46;
      }
      jj_consume_token(K_COMMA);
      table = Table();
tables.add(table);
    }
return tables;
}

  final public FromItem FromItem() throws ParseException {FromItem fromItem = null;
    FromItem fromItem2 = null;
    Pivot pivot = null;
    UnPivot unpivot = null;
    Alias alias = null;
    MySQLIndexHint indexHint = null;
    SQLServerHints sqlServerHints = null;
    if (jj_2_56(2147483647)) {
      fromItem = ValuesList();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ACTION:
      case K_ANY:
      case K_BYTE:
      case K_CASCADE:
      case K_CAST:
      case K_CHARACTER:
      case K_CHANGE:
      case K_CHAR:
      case K_COLUMN:
      case K_COLUMNS:
      case K_COMMIT:
      case K_COMMENT:
      case K_CREATE:
      case K_CYCLE:
      case K_DATETIMELITERAL:
      case K_DATE_LITERAL:
      case K_DESC:
      case K_DESCRIBE:
      case K_DISABLE:
      case K_DIV:
      case K_DO:
      case K_DOUBLE:
      case K_DUPLICATE:
      case K_ENABLE:
      case K_END:
      case K_EXCLUDE:
      case K_EXTRACT:
      case K_FIRST:
      case K_FALSE:
      case K_FOLLOWING:
      case K_FORMAT:
      case K_GROUP:
      case K_IF:
      case K_INDEX:
      case K_INSERT:
      case K_INTERVAL:
      case K_ISNULL:
      case K_KEY:
      case K_FN:
      case K_LAST:
      case K_LATERAL:
      case K_LEFT:
      case K_LIMIT:
      case K_MATERIALIZED:
      case K_NEXTVAL:
      case K_NO:
      case K_NOLOCK:
      case K_NULLS:
      case K_OF:
      case K_OFFSET:
      case K_ON:
      case K_OPEN:
      case K_ORDER:
      case K_OVER:
      case K_OPTIMIZE:
      case K_PARTITION:
      case K_PATH:
      case K_PERCENT:
      case K_PRECISION:
      case K_PRIMARY:
      case K_PRIOR:
      case K_PROCEDURE:
      case K_PUBLIC:
      case K_RANGE:
      case K_READ:
      case K_REPLACE:
      case K_RIGHT:
      case K_ROW:
      case K_ROWS:
      case K_SCHEMA:
      case K_SEQUENCE:
      case K_SEPARATOR:
      case K_SESSION:
      case K_SET:
      case K_SIBLINGS:
      case K_SIZE:
      case K_START:
      case K_TABLE:
      case K_TABLES:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TO:
      case K_TOP:
      case K_TRUNCATE:
      case K_TRUE:
      case K_TYPE:
      case K_UNSIGNED:
      case K_VALIDATE:
      case K_VALUE:
      case K_VALUES:
      case K_VIEW:
      case K_XML:
      case K_ZONE:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:
      case 266:
      case 312:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 266:{
          jj_consume_token(266);
          if (jj_2_50(3)) {
            fromItem2 = FromItem();
fromItem = new ParenthesisFromItem(fromItem2);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_APPLY:
            case K_COMMA:
            case K_CROSS:
            case K_FULL:
            case K_INNER:
            case K_STRAIGHT:
            case K_JOIN:
            case K_LEFT:
            case K_NATURAL:
            case K_OUTER:
            case K_RIGHT:{
              fromItem = SubJoin(fromItem2);
              break;
              }
            default:
              jj_la1[167] = jj_gen;
              ;
            }
          } else {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_SELECT:
            case K_VALUES:
            case K_WITH:
            case 266:{
              fromItem = SubSelect();
              break;
              }
            default:
              jj_la1[168] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
          jj_consume_token(267);
          if (jj_2_51(2)) {
            unpivot = UnPivot();
fromItem.setUnPivot(unpivot);
          } else {
            ;
          }
          break;
          }
        default:
          jj_la1[169] = jj_gen;
          if (jj_2_52(2147483647)) {
            fromItem = TableFunction();
          } else {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_ACTION:
            case K_ANY:
            case K_BYTE:
            case K_CASCADE:
            case K_CAST:
            case K_CHARACTER:
            case K_CHANGE:
            case K_CHAR:
            case K_COLUMN:
            case K_COLUMNS:
            case K_COMMIT:
            case K_COMMENT:
            case K_CREATE:
            case K_CYCLE:
            case K_DATETIMELITERAL:
            case K_DATE_LITERAL:
            case K_DESC:
            case K_DESCRIBE:
            case K_DISABLE:
            case K_DIV:
            case K_DO:
            case K_DOUBLE:
            case K_DUPLICATE:
            case K_ENABLE:
            case K_END:
            case K_EXCLUDE:
            case K_EXTRACT:
            case K_FIRST:
            case K_FALSE:
            case K_FOLLOWING:
            case K_FORMAT:
            case K_GROUP:
            case K_IF:
            case K_INDEX:
            case K_INSERT:
            case K_INTERVAL:
            case K_ISNULL:
            case K_KEY:
            case K_FN:
            case K_LAST:
            case K_LEFT:
            case K_LIMIT:
            case K_MATERIALIZED:
            case K_NEXTVAL:
            case K_NO:
            case K_NOLOCK:
            case K_NULLS:
            case K_OF:
            case K_OFFSET:
            case K_ON:
            case K_OPEN:
            case K_ORDER:
            case K_OVER:
            case K_OPTIMIZE:
            case K_PARTITION:
            case K_PATH:
            case K_PERCENT:
            case K_PRECISION:
            case K_PRIMARY:
            case K_PRIOR:
            case K_PROCEDURE:
            case K_PUBLIC:
            case K_RANGE:
            case K_READ:
            case K_REPLACE:
            case K_RIGHT:
            case K_ROW:
            case K_ROWS:
            case K_SCHEMA:
            case K_SEQUENCE:
            case K_SEPARATOR:
            case K_SESSION:
            case K_SET:
            case K_SIBLINGS:
            case K_SIZE:
            case K_START:
            case K_TABLE:
            case K_TABLES:
            case K_TEMP:
            case K_TEMPORARY:
            case K_TO:
            case K_TOP:
            case K_TRUNCATE:
            case K_TRUE:
            case K_TYPE:
            case K_UNSIGNED:
            case K_VALIDATE:
            case K_VALUE:
            case K_VALUES:
            case K_VIEW:
            case K_XML:
            case K_ZONE:
            case S_IDENTIFIER:
            case S_QUOTED_IDENTIFIER:{
              fromItem = Table();
              break;
              }
            case K_LATERAL:{
              fromItem = LateralSubSelect();
              break;
              }
            default:
              jj_la1[170] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ACTION:
        case K_ANY:
        case K_AS:
        case K_BYTE:
        case K_CASCADE:
        case K_CAST:
        case K_CHARACTER:
        case K_CHANGE:
        case K_CHAR:
        case K_COLUMN:
        case K_COLUMNS:
        case K_COMMIT:
        case K_COMMENT:
        case K_CYCLE:
        case K_DATETIMELITERAL:
        case K_DATE_LITERAL:
        case K_DESC:
        case K_DESCRIBE:
        case K_DISABLE:
        case K_DIV:
        case K_DO:
        case K_DUPLICATE:
        case K_ENABLE:
        case K_END:
        case K_EXCLUDE:
        case K_EXTRACT:
        case K_FIRST:
        case K_FALSE:
        case K_FOLLOWING:
        case K_FORMAT:
        case K_INDEX:
        case K_INSERT:
        case K_INTERVAL:
        case K_ISNULL:
        case K_KEY:
        case K_FN:
        case K_LAST:
        case K_MATERIALIZED:
        case K_NEXTVAL:
        case K_NO:
        case K_NOLOCK:
        case K_NULLS:
        case K_OF:
        case K_OPEN:
        case K_OVER:
        case K_PARTITION:
        case K_PATH:
        case K_PERCENT:
        case K_PRECISION:
        case K_PRIMARY:
        case K_PRIOR:
        case K_RANGE:
        case K_READ:
        case K_REPLACE:
        case K_ROW:
        case K_ROWS:
        case K_SCHEMA:
        case K_SEQUENCE:
        case K_SEPARATOR:
        case K_SESSION:
        case K_SIBLINGS:
        case K_SIZE:
        case K_TABLE:
        case K_TEMP:
        case K_TEMPORARY:
        case K_TO:
        case K_TOP:
        case K_TRUNCATE:
        case K_TRUE:
        case K_TYPE:
        case K_UNSIGNED:
        case K_VALIDATE:
        case K_VALUE:
        case K_VALUES:
        case K_VIEW:
        case K_XML:
        case K_ZONE:
        case S_IDENTIFIER:
        case S_CHAR_LITERAL:
        case S_QUOTED_IDENTIFIER:{
          alias = Alias();
fromItem.setAlias(alias);
          break;
          }
        default:
          jj_la1[171] = jj_gen;
          ;
        }
        if (jj_2_53(2)) {
          unpivot = UnPivot();
fromItem.setUnPivot(unpivot);
        } else {
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_PIVOT:{
          if (jj_2_54(2)) {
            pivot = PivotXml();
          } else {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_PIVOT:{
              pivot = Pivot();
              break;
              }
            default:
              jj_la1[172] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
fromItem.setPivot(pivot);
          break;
          }
        default:
          jj_la1[173] = jj_gen;
          ;
        }
        if (jj_2_55(2)) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_FORCE:
          case K_IGNORE:
          case K_SHOW:
          case K_USE:{
            indexHint = MySQLIndexHint();
if (fromItem instanceof Table)
                            ((Table) fromItem).setHint(indexHint);
            break;
            }
          case K_WITH:{
            sqlServerHints = SQLServerHints();
if (fromItem instanceof Table)
                            ((Table) fromItem).setSqlServerHints(sqlServerHints);
            break;
            }
          default:
            jj_la1[174] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        } else {
          ;
        }
        break;
        }
      default:
        jj_la1[175] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return fromItem;
}

  final public FromItem ValuesList() throws ParseException {MultiExpressionList exprList = new MultiExpressionList();
    List<Expression> primaryExpList = new ArrayList<Expression>();
    ValuesList valuesList = new ValuesList();
    Expression exp = null;
    List<String> colNames = null;
    String colName;
    Alias alias;
    jj_consume_token(266);
    jj_consume_token(K_VALUES);
    if (jj_2_57(3)) {
      jj_consume_token(266);
      exp = SimpleExpression();
primaryExpList.add(exp);
      label_47:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[176] = jj_gen;
          break label_47;
        }
        jj_consume_token(K_COMMA);
        exp = SimpleExpression();
primaryExpList.add(exp);
      }
      jj_consume_token(267);
exprList.addExpressionList(primaryExpList);
      label_48:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[177] = jj_gen;
          break label_48;
        }
        jj_consume_token(K_COMMA);
        jj_consume_token(266);
        exp = SimpleExpression();
primaryExpList = new ArrayList<Expression>();
                    primaryExpList.add(exp);
        label_49:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_COMMA:{
            ;
            break;
            }
          default:
            jj_la1[178] = jj_gen;
            break label_49;
          }
          jj_consume_token(K_COMMA);
          exp = SimpleExpression();
primaryExpList.add(exp);
        }
        jj_consume_token(267);
exprList.addExpressionList(primaryExpList);
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ACTION:
      case K_ANY:
      case K_BYTE:
      case K_CASCADE:
      case K_CASE:
      case K_CAST:
      case K_CHARACTER:
      case K_CHANGE:
      case K_CHAR:
      case K_COLUMN:
      case K_COLUMNS:
      case K_COMMIT:
      case K_COMMENT:
      case K_CREATE:
      case K_CURRENT:
      case K_CYCLE:
      case K_DATETIMELITERAL:
      case K_DATE_LITERAL:
      case K_DESC:
      case K_DESCRIBE:
      case K_DISABLE:
      case K_DIV:
      case K_DO:
      case K_DOUBLE:
      case K_DUPLICATE:
      case K_ENABLE:
      case K_END:
      case K_EXCLUDE:
      case K_EXTRACT:
      case K_FIRST:
      case K_FALSE:
      case K_FOLLOWING:
      case K_FORMAT:
      case K_GROUP:
      case K_GROUP_CONCAT:
      case K_IF:
      case K_IIF:
      case K_INDEX:
      case K_INSERT:
      case K_INTERVAL:
      case K_ISNULL:
      case K_KEY:
      case K_FN:
      case K_LAST:
      case K_LEFT:
      case K_LIMIT:
      case K_MATCH:
      case K_MATERIALIZED:
      case K_NEXTVAL:
      case K_NO:
      case K_NOLOCK:
      case K_NOT:
      case K_NULL:
      case K_NULLS:
      case K_OF:
      case K_OFFSET:
      case K_ON:
      case K_OPEN:
      case K_ORDER:
      case K_OVER:
      case K_OPTIMIZE:
      case K_PARTITION:
      case K_PATH:
      case K_PERCENT:
      case K_PRECISION:
      case K_PRIMARY:
      case K_PRIOR:
      case K_PROCEDURE:
      case K_PUBLIC:
      case K_RANGE:
      case K_READ:
      case K_REPLACE:
      case K_RIGHT:
      case K_ROW:
      case K_ROWS:
      case K_SCHEMA:
      case K_SEQUENCE:
      case K_SEPARATOR:
      case K_SESSION:
      case K_SET:
      case K_SIBLINGS:
      case K_SIZE:
      case K_START:
      case K_TABLE:
      case K_TABLES:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_TO:
      case K_TOP:
      case K_TRUNCATE:
      case K_TRUE:
      case K_TYPE:
      case K_UNSIGNED:
      case K_VALIDATE:
      case K_VALUE:
      case K_VALUES:
      case K_VIEW:
      case K_XML:
      case K_XMLSERIALIZE:
      case K_ZONE:
      case S_DOUBLE:
      case S_LONG:
      case S_HEX:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:
      case 266:
      case 271:
      case 272:
      case 273:
      case 274:
      case 277:
      case 278:
      case 286:
      case 296:
      case 298:
      case 299:
      case 303:
      case 312:{
        exp = SimpleExpression();
exprList.addExpressionList(exp); valuesList.setNoBrackets(true);
        label_50:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_COMMA:{
            ;
            break;
            }
          default:
            jj_la1[179] = jj_gen;
            break label_50;
          }
          jj_consume_token(K_COMMA);
          exp = SimpleExpression();
exprList.addExpressionList(exp);
        }
        break;
        }
      default:
        jj_la1[180] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(267);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ANY:
    case K_AS:
    case K_BYTE:
    case K_CASCADE:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHAR:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_CYCLE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DIV:
    case K_DO:
    case K_DUPLICATE:
    case K_ENABLE:
    case K_END:
    case K_EXCLUDE:
    case K_EXTRACT:
    case K_FIRST:
    case K_FALSE:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_INDEX:
    case K_INSERT:
    case K_INTERVAL:
    case K_ISNULL:
    case K_KEY:
    case K_FN:
    case K_LAST:
    case K_MATERIALIZED:
    case K_NEXTVAL:
    case K_NO:
    case K_NOLOCK:
    case K_NULLS:
    case K_OF:
    case K_OPEN:
    case K_OVER:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_RANGE:
    case K_READ:
    case K_REPLACE:
    case K_ROW:
    case K_ROWS:
    case K_SCHEMA:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SIBLINGS:
    case K_SIZE:
    case K_TABLE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TYPE:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VIEW:
    case K_XML:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:{
      alias = Alias();
valuesList.setAlias(alias);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 266:{
        jj_consume_token(266);
        colName = RelObjectName();
colNames = new ArrayList<String>(); colNames.add(colName);
        label_51:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_COMMA:{
            ;
            break;
            }
          default:
            jj_la1[181] = jj_gen;
            break label_51;
          }
          jj_consume_token(K_COMMA);
          colName = RelObjectName();
colNames.add(colName);
        }
        jj_consume_token(267);
valuesList.setColumnNames(colNames);
        break;
        }
      default:
        jj_la1[182] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[183] = jj_gen;
      ;
    }
valuesList.setMultiExpressionList(exprList);
        return valuesList;
}

  final public LateralSubSelect LateralSubSelect() throws ParseException {LateralSubSelect specialSubSelect;
    SubSelect subSelect = null;
    jj_consume_token(K_LATERAL);
specialSubSelect = new LateralSubSelect();
    jj_consume_token(266);
    subSelect = SubSelect();
    jj_consume_token(267);
specialSubSelect.setSubSelect(subSelect);
        return specialSubSelect;
}

  final public FromItem SubJoin(FromItem fromItem) throws ParseException {Join join = null;
    List<Join> joinList = null;
    joinList = SubJoinsList();
SubJoin subJoin = new SubJoin();
        subJoin.setLeft(fromItem);
        subJoin.setJoinList(joinList);
        return subJoin;
}

  final public List<Join> JoinsList() throws ParseException {List<Join> joinsList = new ArrayList<Join>();
    Join join = null;
    label_52:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_APPLY:
      case K_COMMA:
      case K_CROSS:
      case K_FULL:
      case K_INNER:
      case K_STRAIGHT:
      case K_JOIN:
      case K_LEFT:
      case K_NATURAL:
      case K_OUTER:
      case K_RIGHT:{
        ;
        break;
        }
      default:
        jj_la1[184] = jj_gen;
        break label_52;
      }
      join = JoinerExpression();
joinsList.add(join);
    }
return joinsList;
}

  final public List<Join> SubJoinsList() throws ParseException {List<Join> joinsList = new ArrayList<Join>();
    Join join = null;
    label_53:
    while (true) {
      join = JoinerExpression();
joinsList.add(join);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_APPLY:
      case K_COMMA:
      case K_CROSS:
      case K_FULL:
      case K_INNER:
      case K_STRAIGHT:
      case K_JOIN:
      case K_LEFT:
      case K_NATURAL:
      case K_OUTER:
      case K_RIGHT:{
        ;
        break;
        }
      default:
        jj_la1[185] = jj_gen;
        break label_53;
      }
    }
return joinsList;
}

  final public Join JoinerExpression() throws ParseException {/*@bgen(jjtree) JoinerExpression */
    SimpleNode jjtn000 = new SimpleNode(JJTJOINEREXPRESSION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Join join = new Join();
    FromItem right = null;
    Expression onExpression = null;
    Column tableColumn;
    List<Column> columns = null;
    KSQLJoinWindow joinWindow = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_CROSS:
      case K_FULL:
      case K_INNER:
      case K_LEFT:
      case K_NATURAL:
      case K_OUTER:
      case K_RIGHT:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_LEFT:{
          jj_consume_token(K_LEFT);
join.setLeft(true);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_OUTER:
          case K_SEMI:{
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_SEMI:{
              jj_consume_token(K_SEMI);
join.setSemi(true);
              break;
              }
            case K_OUTER:{
              jj_consume_token(K_OUTER);
join.setOuter(true);
              break;
              }
            default:
              jj_la1[186] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            break;
            }
          default:
            jj_la1[187] = jj_gen;
            ;
          }
          break;
          }
        case K_FULL:
        case K_RIGHT:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_RIGHT:{
            jj_consume_token(K_RIGHT);
join.setRight(true);
            break;
            }
          case K_FULL:{
            jj_consume_token(K_FULL);
join.setFull(true);
            break;
            }
          default:
            jj_la1[188] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_OUTER:{
            jj_consume_token(K_OUTER);
join.setOuter(true);
            break;
            }
          default:
            jj_la1[189] = jj_gen;
            ;
          }
          break;
          }
        case K_INNER:{
          jj_consume_token(K_INNER);
join.setInner(true);
          break;
          }
        case K_NATURAL:{
          jj_consume_token(K_NATURAL);
join.setNatural(true);
          break;
          }
        case K_CROSS:{
          jj_consume_token(K_CROSS);
join.setCross(true);
          break;
          }
        case K_OUTER:{
          jj_consume_token(K_OUTER);
join.setOuter(true);
          break;
          }
        default:
          jj_la1[190] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[191] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_JOIN:{
        jj_consume_token(K_JOIN);
        break;
        }
      case K_COMMA:{
        jj_consume_token(K_COMMA);
join.setSimple(true);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_OUTER:{
          jj_consume_token(K_OUTER);
join.setOuter(true);
          break;
          }
        default:
          jj_la1[192] = jj_gen;
          ;
        }
        break;
        }
      case K_STRAIGHT:{
        jj_consume_token(K_STRAIGHT);
join.setStraight(true);
        break;
        }
      case K_APPLY:{
        jj_consume_token(K_APPLY);
join.setApply(true);
        break;
        }
      default:
        jj_la1[193] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      right = FromItem();
      if (jj_2_58(2)) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ON:
        case K_WITHIN:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_WITHIN:{
            jj_consume_token(K_WITHIN);
            jj_consume_token(266);
            joinWindow = JoinWindow();
            jj_consume_token(267);
join.setJoinWindow(joinWindow);
            break;
            }
          default:
            jj_la1[194] = jj_gen;
            ;
          }
          jj_consume_token(K_ON);
          onExpression = Expression();
join.setOnExpression(onExpression);
          break;
          }
        case K_USING:{
          jj_consume_token(K_USING);
          jj_consume_token(266);
          tableColumn = Column();
columns = new ArrayList<Column>(); columns.add(tableColumn);
          label_54:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_COMMA:{
              ;
              break;
              }
            default:
              jj_la1[195] = jj_gen;
              break label_54;
            }
            jj_consume_token(K_COMMA);
            tableColumn = Column();
columns.add(tableColumn);
          }
          jj_consume_token(267);
join.setUsingColumns(columns);
          break;
          }
        default:
          jj_la1[196] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else {
        ;
      }
jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.jjtSetLastToken(getToken(0));
linkAST(join,jjtn000);
      join.setRightItem(right);
    return join;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public KSQLJoinWindow JoinWindow() throws ParseException {KSQLJoinWindow retval = new KSQLJoinWindow();
    boolean beforeAfter;
    Token beforeDurationToken = null;
    Token beforeTimeUnitToken = null;
    Token afterDurationToken = null;
    Token afterTimeUnitToken = null;
    beforeDurationToken = jj_consume_token(S_LONG);
    beforeTimeUnitToken = jj_consume_token(S_IDENTIFIER);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_COMMA:{
      jj_consume_token(K_COMMA);
      afterDurationToken = jj_consume_token(S_LONG);
      afterTimeUnitToken = jj_consume_token(S_IDENTIFIER);
      break;
      }
    default:
      jj_la1[197] = jj_gen;
      ;
    }
if (afterDurationToken == null) {
            retval.setDuration(Long.parseLong(beforeDurationToken.image));
            retval.setTimeUnit(KSQLJoinWindow.TimeUnit.valueOf(beforeTimeUnitToken.image));
            retval.setBeforeAfterWindow(false);
            return retval;
        }
        retval.setBeforeDuration(Long.parseLong(beforeDurationToken.image));
        retval.setBeforeTimeUnit(KSQLJoinWindow.TimeUnit.valueOf(beforeTimeUnitToken.image));
        retval.setAfterDuration(Long.parseLong(afterDurationToken.image));
        retval.setAfterTimeUnit(KSQLJoinWindow.TimeUnit.valueOf(afterTimeUnitToken.image));
        retval.setBeforeAfterWindow(true);
        return retval;
}

  final public KSQLWindow KSQLWindowClause() throws ParseException {KSQLWindow retval = null;
    Token sizeDurationToken = null;
    Token sizeTimeUnitToken = null;
    Token advanceDurationToken = null;
    Token advanceTimeUnitToken = null;
    jj_consume_token(K_WINDOW);
retval=new KSQLWindow();
        retval.setHoppingWindow(false);
        retval.setSessionWindow(false);
        retval.setTumblingWindow(false);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_HOPPING:{
      jj_consume_token(K_HOPPING);
      jj_consume_token(266);
      jj_consume_token(K_SIZE);
      sizeDurationToken = jj_consume_token(S_LONG);
      sizeTimeUnitToken = jj_consume_token(S_IDENTIFIER);
      jj_consume_token(K_COMMA);
      jj_consume_token(K_ADVANCE);
      jj_consume_token(K_BY);
      advanceDurationToken = jj_consume_token(S_LONG);
      advanceTimeUnitToken = jj_consume_token(S_IDENTIFIER);
      jj_consume_token(267);
retval.setHoppingWindow(true);
      break;
      }
    case K_SESSION:{
      jj_consume_token(K_SESSION);
      jj_consume_token(266);
      sizeDurationToken = jj_consume_token(S_LONG);
      sizeTimeUnitToken = jj_consume_token(S_IDENTIFIER);
      jj_consume_token(267);
retval.setSessionWindow(true);
      break;
      }
    case K_TUMBLING:{
      jj_consume_token(K_TUMBLING);
      jj_consume_token(266);
      jj_consume_token(K_SIZE);
      sizeDurationToken = jj_consume_token(S_LONG);
      sizeTimeUnitToken = jj_consume_token(S_IDENTIFIER);
      jj_consume_token(267);
retval.setTumblingWindow(true);
      break;
      }
    default:
      jj_la1[198] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
retval.setSizeDuration(Long.parseLong(sizeDurationToken.image));
            retval.setSizeTimeUnit(KSQLWindow.TimeUnit.valueOf(sizeTimeUnitToken.image));
            if (advanceDurationToken != null) {
                retval.setAdvanceDuration(Long.parseLong(advanceDurationToken.image));
                retval.setAdvanceTimeUnit(KSQLWindow.TimeUnit.valueOf(advanceTimeUnitToken.image));
            }
            return retval;
}

  final public Expression WhereClause() throws ParseException {Expression retval = null;
    jj_consume_token(K_WHERE);
    retval = Expression();
return retval;
}

  final public OracleHierarchicalExpression OracleHierarchicalQueryClause() throws ParseException {OracleHierarchicalExpression result = new OracleHierarchicalExpression();
    Expression expr;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_START:{
      jj_consume_token(K_START);
      jj_consume_token(K_WITH);
      expr = AndExpression();
result.setStartExpression(expr);
      jj_consume_token(K_CONNECT);
      jj_consume_token(K_BY);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOCYCLE:{
        jj_consume_token(K_NOCYCLE);
result.setNoCycle(true);
        break;
        }
      default:
        jj_la1[199] = jj_gen;
        ;
      }
      expr = AndExpression();
result.setConnectExpression(expr);
      break;
      }
    case K_CONNECT:{
      jj_consume_token(K_CONNECT);
      jj_consume_token(K_BY);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOCYCLE:{
        jj_consume_token(K_NOCYCLE);
result.setNoCycle(true);
        break;
        }
      default:
        jj_la1[200] = jj_gen;
        ;
      }
      expr = AndExpression();
result.setConnectExpression(expr);
                    result.setConnectFirst(true);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_START:{
        jj_consume_token(K_START);
        jj_consume_token(K_WITH);
        expr = AndExpression();
result.setStartExpression(expr);
        break;
        }
      default:
        jj_la1[201] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[202] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return result;
}

  final public GroupByElement GroupByColumnReferences() throws ParseException {Expression columnReference;
    GroupByElement groupBy = new GroupByElement();
    Expression expr;
    ExpressionList list;
    jj_consume_token(K_GROUP);
    jj_consume_token(K_BY);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ANY:
    case K_BYTE:
    case K_CASCADE:
    case K_CASE:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHAR:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_CREATE:
    case K_CURRENT:
    case K_CYCLE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DIV:
    case K_DO:
    case K_DOUBLE:
    case K_DUPLICATE:
    case K_ENABLE:
    case K_END:
    case K_EXCLUDE:
    case K_EXTRACT:
    case K_FIRST:
    case K_FALSE:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_GROUP:
    case K_GROUP_CONCAT:
    case K_IF:
    case K_IIF:
    case K_INDEX:
    case K_INSERT:
    case K_INTERVAL:
    case K_ISNULL:
    case K_KEY:
    case K_FN:
    case K_LAST:
    case K_LEFT:
    case K_LIMIT:
    case K_MATCH:
    case K_MATERIALIZED:
    case K_NEXTVAL:
    case K_NO:
    case K_NOLOCK:
    case K_NOT:
    case K_NULL:
    case K_NULLS:
    case K_OF:
    case K_OFFSET:
    case K_ON:
    case K_OPEN:
    case K_ORDER:
    case K_OVER:
    case K_OPTIMIZE:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_PROCEDURE:
    case K_PUBLIC:
    case K_RANGE:
    case K_READ:
    case K_REPLACE:
    case K_RIGHT:
    case K_ROW:
    case K_ROWS:
    case K_SCHEMA:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SET:
    case K_SIBLINGS:
    case K_SIZE:
    case K_START:
    case K_TABLE:
    case K_TABLES:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIME_KEY_EXPR:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TYPE:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VIEW:
    case K_XML:
    case K_XMLSERIALIZE:
    case K_ZONE:
    case S_DOUBLE:
    case S_LONG:
    case S_HEX:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:
    case 266:
    case 271:
    case 272:
    case 273:
    case 274:
    case 277:
    case 278:
    case 286:
    case 296:
    case 298:
    case 299:
    case 303:
    case 312:{
      columnReference = SimpleExpression();
groupBy.addGroupByExpression(columnReference);
      label_55:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[203] = jj_gen;
          break label_55;
        }
        jj_consume_token(K_COMMA);
        columnReference = SimpleExpression();
groupBy.addGroupByExpression(columnReference);
      }
      break;
      }
    case K_GROUPING:{
      jj_consume_token(K_GROUPING);
      jj_consume_token(K_SETS);
      jj_consume_token(266);
      if (jj_2_59(2)) {
        jj_consume_token(266);
        jj_consume_token(267);
groupBy.addGroupingSet(new ExpressionList());
      } else if (jj_2_60(3)) {
        jj_consume_token(266);
        list = SimpleExpressionList();
        jj_consume_token(267);
groupBy.addGroupingSet(list);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ACTION:
        case K_ANY:
        case K_BYTE:
        case K_CASCADE:
        case K_CASE:
        case K_CAST:
        case K_CHARACTER:
        case K_CHANGE:
        case K_CHAR:
        case K_COLUMN:
        case K_COLUMNS:
        case K_COMMIT:
        case K_COMMENT:
        case K_CREATE:
        case K_CURRENT:
        case K_CYCLE:
        case K_DATETIMELITERAL:
        case K_DATE_LITERAL:
        case K_DESC:
        case K_DESCRIBE:
        case K_DISABLE:
        case K_DIV:
        case K_DO:
        case K_DOUBLE:
        case K_DUPLICATE:
        case K_ENABLE:
        case K_END:
        case K_EXCLUDE:
        case K_EXTRACT:
        case K_FIRST:
        case K_FALSE:
        case K_FOLLOWING:
        case K_FORMAT:
        case K_GROUP:
        case K_GROUP_CONCAT:
        case K_IF:
        case K_IIF:
        case K_INDEX:
        case K_INSERT:
        case K_INTERVAL:
        case K_ISNULL:
        case K_KEY:
        case K_FN:
        case K_LAST:
        case K_LEFT:
        case K_LIMIT:
        case K_MATCH:
        case K_MATERIALIZED:
        case K_NEXTVAL:
        case K_NO:
        case K_NOLOCK:
        case K_NOT:
        case K_NULL:
        case K_NULLS:
        case K_OF:
        case K_OFFSET:
        case K_ON:
        case K_OPEN:
        case K_ORDER:
        case K_OVER:
        case K_OPTIMIZE:
        case K_PARTITION:
        case K_PATH:
        case K_PERCENT:
        case K_PRECISION:
        case K_PRIMARY:
        case K_PRIOR:
        case K_PROCEDURE:
        case K_PUBLIC:
        case K_RANGE:
        case K_READ:
        case K_REPLACE:
        case K_RIGHT:
        case K_ROW:
        case K_ROWS:
        case K_SCHEMA:
        case K_SEQUENCE:
        case K_SEPARATOR:
        case K_SESSION:
        case K_SET:
        case K_SIBLINGS:
        case K_SIZE:
        case K_START:
        case K_TABLE:
        case K_TABLES:
        case K_TEMP:
        case K_TEMPORARY:
        case K_TIME_KEY_EXPR:
        case K_TO:
        case K_TOP:
        case K_TRUNCATE:
        case K_TRUE:
        case K_TYPE:
        case K_UNSIGNED:
        case K_VALIDATE:
        case K_VALUE:
        case K_VALUES:
        case K_VIEW:
        case K_XML:
        case K_XMLSERIALIZE:
        case K_ZONE:
        case S_DOUBLE:
        case S_LONG:
        case S_HEX:
        case S_IDENTIFIER:
        case S_CHAR_LITERAL:
        case S_QUOTED_IDENTIFIER:
        case 266:
        case 271:
        case 272:
        case 273:
        case 274:
        case 277:
        case 278:
        case 286:
        case 296:
        case 298:
        case 299:
        case 303:
        case 312:{
          expr = SimpleExpression();
groupBy.addGroupingSet(expr);
          break;
          }
        default:
          jj_la1[204] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      label_56:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[205] = jj_gen;
          break label_56;
        }
        jj_consume_token(K_COMMA);
        if (jj_2_61(2)) {
          jj_consume_token(266);
          jj_consume_token(267);
groupBy.addGroupingSet(new ExpressionList());
        } else if (jj_2_62(3)) {
          jj_consume_token(266);
          list = SimpleExpressionList();
          jj_consume_token(267);
groupBy.addGroupingSet(list);
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ACTION:
          case K_ANY:
          case K_BYTE:
          case K_CASCADE:
          case K_CASE:
          case K_CAST:
          case K_CHARACTER:
          case K_CHANGE:
          case K_CHAR:
          case K_COLUMN:
          case K_COLUMNS:
          case K_COMMIT:
          case K_COMMENT:
          case K_CREATE:
          case K_CURRENT:
          case K_CYCLE:
          case K_DATETIMELITERAL:
          case K_DATE_LITERAL:
          case K_DESC:
          case K_DESCRIBE:
          case K_DISABLE:
          case K_DIV:
          case K_DO:
          case K_DOUBLE:
          case K_DUPLICATE:
          case K_ENABLE:
          case K_END:
          case K_EXCLUDE:
          case K_EXTRACT:
          case K_FIRST:
          case K_FALSE:
          case K_FOLLOWING:
          case K_FORMAT:
          case K_GROUP:
          case K_GROUP_CONCAT:
          case K_IF:
          case K_IIF:
          case K_INDEX:
          case K_INSERT:
          case K_INTERVAL:
          case K_ISNULL:
          case K_KEY:
          case K_FN:
          case K_LAST:
          case K_LEFT:
          case K_LIMIT:
          case K_MATCH:
          case K_MATERIALIZED:
          case K_NEXTVAL:
          case K_NO:
          case K_NOLOCK:
          case K_NOT:
          case K_NULL:
          case K_NULLS:
          case K_OF:
          case K_OFFSET:
          case K_ON:
          case K_OPEN:
          case K_ORDER:
          case K_OVER:
          case K_OPTIMIZE:
          case K_PARTITION:
          case K_PATH:
          case K_PERCENT:
          case K_PRECISION:
          case K_PRIMARY:
          case K_PRIOR:
          case K_PROCEDURE:
          case K_PUBLIC:
          case K_RANGE:
          case K_READ:
          case K_REPLACE:
          case K_RIGHT:
          case K_ROW:
          case K_ROWS:
          case K_SCHEMA:
          case K_SEQUENCE:
          case K_SEPARATOR:
          case K_SESSION:
          case K_SET:
          case K_SIBLINGS:
          case K_SIZE:
          case K_START:
          case K_TABLE:
          case K_TABLES:
          case K_TEMP:
          case K_TEMPORARY:
          case K_TIME_KEY_EXPR:
          case K_TO:
          case K_TOP:
          case K_TRUNCATE:
          case K_TRUE:
          case K_TYPE:
          case K_UNSIGNED:
          case K_VALIDATE:
          case K_VALUE:
          case K_VALUES:
          case K_VIEW:
          case K_XML:
          case K_XMLSERIALIZE:
          case K_ZONE:
          case S_DOUBLE:
          case S_LONG:
          case S_HEX:
          case S_IDENTIFIER:
          case S_CHAR_LITERAL:
          case S_QUOTED_IDENTIFIER:
          case 266:
          case 271:
          case 272:
          case 273:
          case 274:
          case 277:
          case 278:
          case 286:
          case 296:
          case 298:
          case 299:
          case 303:
          case 312:{
            expr = SimpleExpression();
groupBy.addGroupingSet(expr);
            break;
            }
          default:
            jj_la1[206] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
      jj_consume_token(267);
      break;
      }
    default:
      jj_la1[207] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return groupBy;
}

  final public Expression Having() throws ParseException {Expression having = null;
    jj_consume_token(K_HAVING);
    having = Expression();
return having;
}

  final public List<OrderByElement> OrderByElements() throws ParseException {List<OrderByElement> orderByList = new ArrayList<OrderByElement>();
    OrderByElement orderByElement = null;
    jj_consume_token(K_ORDER);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_SIBLINGS:{
      jj_consume_token(K_SIBLINGS);
      break;
      }
    default:
      jj_la1[208] = jj_gen;
      ;
    }
    jj_consume_token(K_BY);
    orderByElement = OrderByElement();
orderByList.add(orderByElement);
    label_57:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[209] = jj_gen;
        break label_57;
      }
      jj_consume_token(K_COMMA);
      orderByElement = OrderByElement();
orderByList.add(orderByElement);
    }
return orderByList;
}

  final public OrderByElement OrderByElement() throws ParseException {OrderByElement orderByElement = new OrderByElement();
    Expression columnReference = null;
    columnReference = Expression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ASC:
    case K_DESC:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ASC:{
        jj_consume_token(K_ASC);
        break;
        }
      case K_DESC:{
        jj_consume_token(K_DESC);
orderByElement.setAsc(false);
        break;
        }
      default:
        jj_la1[210] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
orderByElement.setAscDescPresent(true);
      break;
      }
    default:
      jj_la1[211] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_NULLS:{
      jj_consume_token(K_NULLS);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_FIRST:
      case K_LAST:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_FIRST:{
          jj_consume_token(K_FIRST);
orderByElement.setNullOrdering(OrderByElement.NullOrdering.NULLS_FIRST);
          break;
          }
        case K_LAST:{
          jj_consume_token(K_LAST);
orderByElement.setNullOrdering(OrderByElement.NullOrdering.NULLS_LAST);
          break;
          }
        default:
          jj_la1[212] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[213] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[214] = jj_gen;
      ;
    }
orderByElement.setExpression(columnReference);
        return orderByElement;
}

  final public JdbcParameter SimpleJdbcParameter() throws ParseException {JdbcParameter retval;
    jj_consume_token(271);
retval = new JdbcParameter(++jdbcParameterIndex, false);
    if (jj_2_63(2)) {
      token = jj_consume_token(S_LONG);
retval.setUseFixedIndex(true); retval.setIndex(Integer.valueOf(token.image));
    } else {
      ;
    }
return retval;
}

  final public JdbcNamedParameter SimpleJdbcNamedParameter() throws ParseException {String name;
    jj_consume_token(272);
    name = RelObjectNameExt();
return new JdbcNamedParameter(token.image);
}

  final public Limit LimitWithOffset() throws ParseException {/*@bgen(jjtree) LimitWithOffset */
    SimpleNode jjtn000 = new SimpleNode(JJTLIMITWITHOFFSET);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Limit limit = new Limit();
    Token token = null;
    String name;
    JdbcParameter jdbc = null;
    try {
      if (jj_2_66(5)) {
        jj_consume_token(K_LIMIT);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_LONG:{
          token = jj_consume_token(S_LONG);
limit.setOffset(new LongValue(token.image));
          break;
          }
        case 271:{
          jdbc = SimpleJdbcParameter();
limit.setOffset(jdbc);
          break;
          }
        case 272:{
          jj_consume_token(272);
limit.setOffset(new JdbcNamedParameter());
          if (jj_2_64(2)) {
            name = RelObjectNameExt();
((JdbcNamedParameter)limit.getOffset()).setName(name);
          } else {
            ;
          }
          break;
          }
        default:
          jj_la1[215] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(K_COMMA);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_LONG:{
          token = jj_consume_token(S_LONG);
limit.setRowCount(new LongValue(token.image));
          break;
          }
        case 271:{
          jdbc = SimpleJdbcParameter();
limit.setRowCount(jdbc);
          break;
          }
        case 272:{
          jj_consume_token(272);
limit.setRowCount(new JdbcNamedParameter());
          if (jj_2_65(2)) {
            name = RelObjectNameExt();
((JdbcNamedParameter)limit.getRowCount()).setName(name);
          } else {
            ;
          }
          break;
          }
        default:
          jj_la1[216] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_LIMIT:{
          limit = PlainLimit();
          break;
          }
        default:
          jj_la1[217] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
linkAST(limit,jjtn000);
        return limit;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Limit PlainLimit() throws ParseException {/*@bgen(jjtree) PlainLimit */
    SimpleNode jjtn000 = new SimpleNode(JJTPLAINLIMIT);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Limit limit = new Limit();
    Token token = null;
    JdbcParameter jdbc;
    String name;
    try {
      jj_consume_token(K_LIMIT);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_LONG:{
        token = jj_consume_token(S_LONG);
limit.setRowCount(new LongValue(token.image));
        break;
        }
      case 271:{
        jdbc = SimpleJdbcParameter();
limit.setRowCount(jdbc);
        break;
        }
      case 272:{
        jj_consume_token(272);
limit.setRowCount(new JdbcNamedParameter());
        if (jj_2_67(2)) {
          name = RelObjectNameExt();
((JdbcNamedParameter)limit.getRowCount()).setName(name);
        } else {
          ;
        }
        break;
        }
      case K_ALL:{
        jj_consume_token(K_ALL);
limit.setLimitAll(true);
        break;
        }
      case K_NULL:{
        jj_consume_token(K_NULL);
limit.setLimitNull(true);
        break;
        }
      default:
        jj_la1[218] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
linkAST(limit,jjtn000);
        return limit;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Offset Offset() throws ParseException {Offset offset = new Offset();
    Token token = null;
    JdbcParameter jdbc;
    JdbcNamedParameter jdbcNamed;
    jj_consume_token(K_OFFSET);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_LONG:{
      token = jj_consume_token(S_LONG);
offset.setOffset(Long.parseLong(token.image));
      break;
      }
    case 271:{
      jdbc = SimpleJdbcParameter();
offset.setOffsetJdbcParameter(jdbc);
      break;
      }
    case 272:{
      jdbcNamed = SimpleJdbcNamedParameter();
offset.setOffsetJdbcParameter(jdbcNamed);
      break;
      }
    default:
      jj_la1[219] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ROW:
    case K_ROWS:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ROWS:{
        jj_consume_token(K_ROWS);
offset.setOffsetParam("ROWS");
        break;
        }
      case K_ROW:{
        jj_consume_token(K_ROW);
offset.setOffsetParam("ROW");
        break;
        }
      default:
        jj_la1[220] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[221] = jj_gen;
      ;
    }
return offset;
}

  final public Fetch Fetch() throws ParseException {Fetch fetch = new Fetch();
    Token token = null;
    JdbcParameter jdbc;
    jj_consume_token(K_FETCH);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FIRST:{
      jj_consume_token(K_FIRST);
fetch.setFetchParamFirst(true);
      break;
      }
    case K_NEXT:{
      jj_consume_token(K_NEXT);
      break;
      }
    default:
      jj_la1[222] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_LONG:{
      token = jj_consume_token(S_LONG);
fetch.setRowCount(Long.parseLong(token.image));
      break;
      }
    case 271:{
      jdbc = SimpleJdbcParameter();
fetch.setFetchJdbcParameter(jdbc);
      break;
      }
    default:
      jj_la1[223] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ROWS:{
      jj_consume_token(K_ROWS);
fetch.setFetchParam("ROWS");
      break;
      }
    case K_ROW:{
      jj_consume_token(K_ROW);
      break;
      }
    default:
      jj_la1[224] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(K_ONLY);
return fetch;
}

  final public OptimizeFor OptimizeFor() throws ParseException {Token token;
    LongValue value;
    jj_consume_token(K_OPTIMIZE);
    jj_consume_token(K_FOR);
    token = jj_consume_token(S_LONG);
    jj_consume_token(K_ROWS);
value = new LongValue(token.image);
return new OptimizeFor(value.getValue());
}

// according to http://technet.microsoft.com/en-us/library/ms189463.aspx
  final public Top Top() throws ParseException {Top top = new Top();
    Token token = null;
    Expression expr = null;
    JdbcParameter jdbc = null;
    jj_consume_token(K_TOP);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_LONG:{
      token = jj_consume_token(S_LONG);
top.setExpression(new LongValue(token.image));
      break;
      }
    case 271:{
      jdbc = SimpleJdbcParameter();
top.setExpression(jdbc);
      break;
      }
    case 272:{
      jj_consume_token(272);
top.setExpression(new JdbcNamedParameter());
      if (jj_2_68(2)) {
        token = jj_consume_token(S_IDENTIFIER);
((JdbcNamedParameter)top.getExpression()).setName(token.image);
      } else {
        ;
      }
      break;
      }
    case 266:{
      jj_consume_token(266);
      expr = AdditiveExpression();
top.setExpression(expr);
top.setParenthesis(true);
      jj_consume_token(267);
      break;
      }
    default:
      jj_la1[225] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    if (jj_2_69(2)) {
      jj_consume_token(K_PERCENT);
top.setPercentage(true);
    } else {
      ;
    }
return top;
}

// according to http://www-01.ibm.com/support/knowledgecenter/SSGU8G_12.1.0/com.ibm.sqls.doc/ids_sqs_0156.htm
  final public Skip Skip() throws ParseException {Skip skip = new Skip();
    Token token = null;
    JdbcParameter jdbc;
    jj_consume_token(K_SKIP);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_LONG:{
      token = jj_consume_token(S_LONG);
skip.setRowCount(Long.parseLong(token.image));
      break;
      }
    case S_IDENTIFIER:{
      token = jj_consume_token(S_IDENTIFIER);
skip.setVariable(token.image);
      break;
      }
    case 271:{
      jdbc = SimpleJdbcParameter();
skip.setJdbcParameter(jdbc);
      break;
      }
    default:
      jj_la1[226] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return skip;
}

  OracleHint getOracleHint() throws ParseException {OracleHint hint = null;
  Token tok = getToken(1);
  // Retrieve first comment (if any) prior next token
  if (tok.specialToken != null) {
    tok = tok.specialToken;
    while (tok.specialToken != null) tok = tok.specialToken;
    // Check if it matches Hint pattern?
    if (OracleHint.isHintMatch(tok.image)) {
      hint = new OracleHint();
      hint.setComment(tok.image);
    }
  }
  return hint;
  }

  final public First First() throws ParseException {First first = new First();
    Token token = null;
    JdbcParameter jdbc;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FIRST:{
      jj_consume_token(K_FIRST);
first.setKeyword(First.Keyword.FIRST);
      break;
      }
    case K_LIMIT:{
      jj_consume_token(K_LIMIT);
first.setKeyword(First.Keyword.LIMIT);
      break;
      }
    default:
      jj_la1[227] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_LONG:{
      token = jj_consume_token(S_LONG);
first.setRowCount(Long.parseLong(token.image));
      break;
      }
    case S_IDENTIFIER:{
      token = jj_consume_token(S_IDENTIFIER);
first.setVariable(token.image);
      break;
      }
    case 271:{
      jdbc = SimpleJdbcParameter();
first.setJdbcParameter(jdbc);
      break;
      }
    default:
      jj_la1[228] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return first;
}

  final public Expression Expression() throws ParseException {/*@bgen(jjtree) Expression */
    SimpleNode jjtn000 = new SimpleNode(JJTEXPRESSION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Expression retval = null;
    try {
      retval = OrExpression();
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
return retval;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Expression OrExpression() throws ParseException {Expression left, right, result;
    left = AndExpression();
result = left;
    label_58:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_OR:{
        ;
        break;
        }
      default:
        jj_la1[229] = jj_gen;
        break label_58;
      }
      jj_consume_token(K_OR);
      right = AndExpression();
result = new OrExpression(left, right);
            left = result;
    }
return result;
}

  final public Expression AndExpression() throws ParseException {Expression left, right, result;
    boolean not = false;
        boolean exclamationMarkNot=false;
    if (jj_2_70(2147483647)) {
      left = Condition();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOT:
      case 266:
      case 273:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_NOT:
        case 273:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_NOT:{
            jj_consume_token(K_NOT);
not=true;
            break;
            }
          case 273:{
            jj_consume_token(273);
not=true; exclamationMarkNot=true;
            break;
            }
          default:
            jj_la1[230] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        default:
          jj_la1[231] = jj_gen;
          ;
        }
        jj_consume_token(266);
        left = OrExpression();
        jj_consume_token(267);
left = new Parenthesis(left); if (not) { left = new NotExpression(left, exclamationMarkNot); not = false; }
        break;
        }
      default:
        jj_la1[232] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
result = left;
    label_59:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_AND:
      case K_AND_OPERATOR:{
        ;
        break;
        }
      default:
        jj_la1[233] = jj_gen;
        break label_59;
      }
boolean useOperator = false;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_AND:{
        jj_consume_token(K_AND);
        break;
        }
      case K_AND_OPERATOR:{
        jj_consume_token(K_AND_OPERATOR);
useOperator=true;
        break;
        }
      default:
        jj_la1[234] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      if (jj_2_71(2147483647)) {
        right = Condition();
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_NOT:
        case 266:
        case 273:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_NOT:
          case 273:{
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_NOT:{
              jj_consume_token(K_NOT);
not=true;
              break;
              }
            case 273:{
              jj_consume_token(273);
not=true; exclamationMarkNot=true;
              break;
              }
            default:
              jj_la1[235] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            break;
            }
          default:
            jj_la1[236] = jj_gen;
            ;
          }
          jj_consume_token(266);
          right = OrExpression();
          jj_consume_token(267);
right = new Parenthesis(right); if (not) { right = new NotExpression(right, exclamationMarkNot); not = false; }
          break;
          }
        default:
          jj_la1[237] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
result = new AndExpression(left, right);
            ((AndExpression)result).setUseOperator(useOperator);
            left = result;
    }
return result;
}

  final public Expression Condition() throws ParseException {Expression result;
    Token token;
    boolean not = false;
        boolean exclamationMarkNot = false;
    if (jj_2_72(2)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOT:{
        jj_consume_token(K_NOT);
not=true;
        break;
        }
      case 273:{
        jj_consume_token(273);
not=true; exclamationMarkNot=true;
        break;
        }
      default:
        jj_la1[238] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      ;
    }
    if (jj_2_73(2147483647)) {
      result = RegularCondition();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ACTION:
      case K_ANY:
      case K_BYTE:
      case K_CASCADE:
      case K_CASE:
      case K_CAST:
      case K_CHARACTER:
      case K_CHANGE:
      case K_CHAR:
      case K_COLUMN:
      case K_COLUMNS:
      case K_COMMIT:
      case K_COMMENT:
      case K_CREATE:
      case K_CURRENT:
      case K_CYCLE:
      case K_DATETIMELITERAL:
      case K_DATE_LITERAL:
      case K_DESC:
      case K_DESCRIBE:
      case K_DISABLE:
      case K_DIV:
      case K_DO:
      case K_DOUBLE:
      case K_DUPLICATE:
      case K_ENABLE:
      case K_END:
      case K_EXCLUDE:
      case K_EXISTS:
      case K_EXTRACT:
      case K_FIRST:
      case K_FALSE:
      case K_FOLLOWING:
      case K_FORMAT:
      case K_GROUP:
      case K_GROUP_CONCAT:
      case K_IF:
      case K_IIF:
      case K_INDEX:
      case K_INSERT:
      case K_INTERVAL:
      case K_ISNULL:
      case K_KEY:
      case K_FN:
      case K_LAST:
      case K_LEFT:
      case K_LIMIT:
      case K_MATCH:
      case K_MATERIALIZED:
      case K_NEXTVAL:
      case K_NO:
      case K_NOLOCK:
      case K_NOT:
      case K_NULL:
      case K_NULLS:
      case K_OF:
      case K_OFFSET:
      case K_ON:
      case K_OPEN:
      case K_ORDER:
      case K_OVER:
      case K_OPTIMIZE:
      case K_PARTITION:
      case K_PATH:
      case K_PERCENT:
      case K_PRECISION:
      case K_PRIMARY:
      case K_PRIOR:
      case K_PROCEDURE:
      case K_PUBLIC:
      case K_RANGE:
      case K_READ:
      case K_REPLACE:
      case K_RIGHT:
      case K_ROW:
      case K_ROWS:
      case K_SCHEMA:
      case K_SEQUENCE:
      case K_SEPARATOR:
      case K_SESSION:
      case K_SET:
      case K_SIBLINGS:
      case K_SIZE:
      case K_START:
      case K_TABLE:
      case K_TABLES:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_TO:
      case K_TOP:
      case K_TRUNCATE:
      case K_TRUE:
      case K_TYPE:
      case K_UNSIGNED:
      case K_VALIDATE:
      case K_VALUE:
      case K_VALUES:
      case K_VIEW:
      case K_XML:
      case K_XMLSERIALIZE:
      case K_ZONE:
      case S_DOUBLE:
      case S_LONG:
      case S_HEX:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:
      case 266:
      case 271:
      case 272:
      case 273:
      case 274:
      case 277:
      case 278:
      case 286:
      case 296:
      case 298:
      case 299:
      case 303:
      case 312:{
        result = SQLCondition();
        break;
        }
      default:
        jj_la1[239] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return not?new NotExpression(result, exclamationMarkNot):result;
}

  final public Expression RegularCondition() throws ParseException {/*@bgen(jjtree) RegularCondition */
    SimpleNode jjtn000 = new SimpleNode(JJTREGULARCONDITION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Expression result = null;
    Expression leftExpression;
    Expression rightExpression;
    int oracleJoin=EqualsTo.NO_ORACLE_JOIN;
    int oraclePrior=EqualsTo.NO_ORACLE_PRIOR;
    boolean binary = false;
    try {
      if (jj_2_74(2)) {
        jj_consume_token(K_PRIOR);
oraclePrior = EqualsTo.ORACLE_PRIOR_START;
      } else {
        ;
      }
      leftExpression = ComparisonItem();
result = leftExpression;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 266:{
        jj_consume_token(266);
        jj_consume_token(274);
        jj_consume_token(267);
oracleJoin=EqualsTo.ORACLE_JOIN_RIGHT;
        break;
        }
      default:
        jj_la1[240] = jj_gen;
        ;
      }
      if (jj_2_75(2)) {
        jj_consume_token(275);
result = new GreaterThan();
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 276:{
          jj_consume_token(276);
result = new MinorThan();
          break;
          }
        case 268:{
          jj_consume_token(268);
result = new EqualsTo();
          break;
          }
        case OP_GREATERTHANEQUALS:{
          token = jj_consume_token(OP_GREATERTHANEQUALS);
result = new GreaterThanEquals(token.image);
          break;
          }
        case OP_MINORTHANEQUALS:{
          token = jj_consume_token(OP_MINORTHANEQUALS);
result = new MinorThanEquals(token.image);
          break;
          }
        case OP_NOTEQUALSSTANDARD:{
          token = jj_consume_token(OP_NOTEQUALSSTANDARD);
result = new NotEqualsTo(token.image);
          break;
          }
        case OP_NOTEQUALSBANG:{
          token = jj_consume_token(OP_NOTEQUALSBANG);
result = new NotEqualsTo(token.image);
          break;
          }
        case 277:{
          jj_consume_token(277);
result = new Matches();
          break;
          }
        case 278:{
          jj_consume_token(278);
result = new RegExpMatchOperator(RegExpMatchOperatorType.MATCH_CASESENSITIVE);
          break;
          }
        case K_REGEXP:{
          jj_consume_token(K_REGEXP);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_BINARY:{
            jj_consume_token(K_BINARY);
binary=true;
            break;
            }
          default:
            jj_la1[241] = jj_gen;
            ;
          }
result = new RegExpMySQLOperator(binary?RegExpMatchOperatorType.MATCH_CASESENSITIVE:RegExpMatchOperatorType.MATCH_CASEINSENSITIVE);
          break;
          }
        case K_RLIKE:{
          jj_consume_token(K_RLIKE);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_BINARY:{
            jj_consume_token(K_BINARY);
binary=true;
            break;
            }
          default:
            jj_la1[242] = jj_gen;
            ;
          }
result = new RegExpMySQLOperator(binary?RegExpMatchOperatorType.MATCH_CASESENSITIVE:RegExpMatchOperatorType.MATCH_CASEINSENSITIVE).useRLike();
          break;
          }
        case 279:{
          jj_consume_token(279);
result = new RegExpMatchOperator(RegExpMatchOperatorType.MATCH_CASEINSENSITIVE);
          break;
          }
        case 280:{
          jj_consume_token(280);
result = new RegExpMatchOperator(RegExpMatchOperatorType.NOT_MATCH_CASESENSITIVE);
          break;
          }
        case 281:{
          jj_consume_token(281);
result = new RegExpMatchOperator(RegExpMatchOperatorType.NOT_MATCH_CASEINSENSITIVE);
          break;
          }
        case 282:{
          jj_consume_token(282);
result = new JsonOperator("@>");
          break;
          }
        case 283:{
          jj_consume_token(283);
result = new JsonOperator("<@");
          break;
          }
        case 271:{
          jj_consume_token(271);
result = new JsonOperator("?");
          break;
          }
        case 284:{
          jj_consume_token(284);
result = new JsonOperator("?|");
          break;
          }
        case 285:{
          jj_consume_token(285);
result = new JsonOperator("?&");
          break;
          }
        case OP_CONCAT:{
          jj_consume_token(OP_CONCAT);
result = new JsonOperator("||");
          break;
          }
        case 286:{
          jj_consume_token(286);
result = new JsonOperator("-");
          break;
          }
        case 287:{
          jj_consume_token(287);
result = new JsonOperator("-#");
          break;
          }
        default:
          jj_la1[243] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      if (jj_2_76(2)) {
        jj_consume_token(K_PRIOR);
        rightExpression = ComparisonItem();
oraclePrior = EqualsTo.ORACLE_PRIOR_END;
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ACTION:
        case K_ALL:
        case K_ANY:
        case K_BYTE:
        case K_CASCADE:
        case K_CASE:
        case K_CAST:
        case K_CHARACTER:
        case K_CHANGE:
        case K_CHAR:
        case K_COLUMN:
        case K_COLUMNS:
        case K_COMMIT:
        case K_COMMENT:
        case K_CREATE:
        case K_CURRENT:
        case K_CYCLE:
        case K_DATETIMELITERAL:
        case K_DATE_LITERAL:
        case K_DESC:
        case K_DESCRIBE:
        case K_DISABLE:
        case K_DIV:
        case K_DO:
        case K_DOUBLE:
        case K_DUPLICATE:
        case K_ENABLE:
        case K_END:
        case K_EXCLUDE:
        case K_EXTRACT:
        case K_FIRST:
        case K_FALSE:
        case K_FOLLOWING:
        case K_FORMAT:
        case K_GROUP:
        case K_GROUP_CONCAT:
        case K_IF:
        case K_IIF:
        case K_INDEX:
        case K_INSERT:
        case K_INTERVAL:
        case K_ISNULL:
        case K_KEY:
        case K_FN:
        case K_LAST:
        case K_LEFT:
        case K_LIMIT:
        case K_MATCH:
        case K_MATERIALIZED:
        case K_NEXTVAL:
        case K_NO:
        case K_NOLOCK:
        case K_NOT:
        case K_NULL:
        case K_NULLS:
        case K_OF:
        case K_OFFSET:
        case K_ON:
        case K_OPEN:
        case K_ORDER:
        case K_OVER:
        case K_OPTIMIZE:
        case K_PARTITION:
        case K_PATH:
        case K_PERCENT:
        case K_PRECISION:
        case K_PRIMARY:
        case K_PRIOR:
        case K_PROCEDURE:
        case K_PUBLIC:
        case K_RANGE:
        case K_READ:
        case K_REPLACE:
        case K_RIGHT:
        case K_ROW:
        case K_ROWS:
        case K_SCHEMA:
        case K_SEQUENCE:
        case K_SEPARATOR:
        case K_SESSION:
        case K_SET:
        case K_SIBLINGS:
        case K_SIZE:
        case K_SOME:
        case K_START:
        case K_TABLE:
        case K_TABLES:
        case K_TEMP:
        case K_TEMPORARY:
        case K_TIME_KEY_EXPR:
        case K_TO:
        case K_TOP:
        case K_TRUNCATE:
        case K_TRUE:
        case K_TYPE:
        case K_UNSIGNED:
        case K_VALIDATE:
        case K_VALUE:
        case K_VALUES:
        case K_VIEW:
        case K_XML:
        case K_XMLSERIALIZE:
        case K_ZONE:
        case S_DOUBLE:
        case S_LONG:
        case S_HEX:
        case S_IDENTIFIER:
        case S_CHAR_LITERAL:
        case S_QUOTED_IDENTIFIER:
        case 266:
        case 271:
        case 272:
        case 273:
        case 274:
        case 277:
        case 278:
        case 286:
        case 296:
        case 298:
        case 299:
        case 303:
        case 312:{
          rightExpression = ComparisonItem();
          break;
          }
        default:
          jj_la1[244] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 266:{
        jj_consume_token(266);
        jj_consume_token(274);
        jj_consume_token(267);
oracleJoin=EqualsTo.ORACLE_JOIN_LEFT;
        break;
        }
      default:
        jj_la1[245] = jj_gen;
        ;
      }
BinaryExpression regCond = (BinaryExpression) result;
        regCond.setLeftExpression(leftExpression);
        regCond.setRightExpression(rightExpression);

        if (oracleJoin>0)
            ((SupportsOldOracleJoinSyntax)result).setOldOracleJoinSyntax(oracleJoin);

        if (oraclePrior!=EqualsTo.NO_ORACLE_PRIOR)
            ((SupportsOldOracleJoinSyntax)result).setOraclePriorPosition(oraclePrior);
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
linkAST(result,jjtn000);
        return result;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Expression SQLCondition() throws ParseException {Expression result;
    Expression left;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_EXISTS:{
      result = ExistsExpression();
      break;
      }
    default:
      jj_la1[247] = jj_gen;
      if (jj_2_82(2147483647)) {
        result = InExpression();
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ACTION:
        case K_ANY:
        case K_BYTE:
        case K_CASCADE:
        case K_CASE:
        case K_CAST:
        case K_CHARACTER:
        case K_CHANGE:
        case K_CHAR:
        case K_COLUMN:
        case K_COLUMNS:
        case K_COMMIT:
        case K_COMMENT:
        case K_CREATE:
        case K_CURRENT:
        case K_CYCLE:
        case K_DATETIMELITERAL:
        case K_DATE_LITERAL:
        case K_DESC:
        case K_DESCRIBE:
        case K_DISABLE:
        case K_DIV:
        case K_DO:
        case K_DOUBLE:
        case K_DUPLICATE:
        case K_ENABLE:
        case K_END:
        case K_EXCLUDE:
        case K_EXTRACT:
        case K_FIRST:
        case K_FALSE:
        case K_FOLLOWING:
        case K_FORMAT:
        case K_GROUP:
        case K_GROUP_CONCAT:
        case K_IF:
        case K_IIF:
        case K_INDEX:
        case K_INSERT:
        case K_INTERVAL:
        case K_ISNULL:
        case K_KEY:
        case K_FN:
        case K_LAST:
        case K_LEFT:
        case K_LIMIT:
        case K_MATCH:
        case K_MATERIALIZED:
        case K_NEXTVAL:
        case K_NO:
        case K_NOLOCK:
        case K_NOT:
        case K_NULL:
        case K_NULLS:
        case K_OF:
        case K_OFFSET:
        case K_ON:
        case K_OPEN:
        case K_ORDER:
        case K_OVER:
        case K_OPTIMIZE:
        case K_PARTITION:
        case K_PATH:
        case K_PERCENT:
        case K_PRECISION:
        case K_PRIMARY:
        case K_PRIOR:
        case K_PROCEDURE:
        case K_PUBLIC:
        case K_RANGE:
        case K_READ:
        case K_REPLACE:
        case K_RIGHT:
        case K_ROW:
        case K_ROWS:
        case K_SCHEMA:
        case K_SEQUENCE:
        case K_SEPARATOR:
        case K_SESSION:
        case K_SET:
        case K_SIBLINGS:
        case K_SIZE:
        case K_START:
        case K_TABLE:
        case K_TABLES:
        case K_TEMP:
        case K_TEMPORARY:
        case K_TIME_KEY_EXPR:
        case K_TO:
        case K_TOP:
        case K_TRUNCATE:
        case K_TRUE:
        case K_TYPE:
        case K_UNSIGNED:
        case K_VALIDATE:
        case K_VALUE:
        case K_VALUES:
        case K_VIEW:
        case K_XML:
        case K_XMLSERIALIZE:
        case K_ZONE:
        case S_DOUBLE:
        case S_LONG:
        case S_HEX:
        case S_IDENTIFIER:
        case S_CHAR_LITERAL:
        case S_QUOTED_IDENTIFIER:
        case 266:
        case 271:
        case 272:
        case 273:
        case 274:
        case 277:
        case 278:
        case 286:
        case 296:
        case 298:
        case 299:
        case 303:
        case 312:{
          left = SimpleExpression();
result = left;
          if (jj_2_81(2)) {
            if (jj_2_77(2)) {
              result = Between(left);
            } else if (jj_2_78(2147483647)) {
              result = IsNullExpression(left);
            } else if (jj_2_79(2147483647)) {
              result = IsBooleanExpression(left);
            } else if (jj_2_80(2)) {
              result = LikeExpression(left);
            } else {
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_NOT:
              case K_SIMILAR:{
                result = SimilarToExpression(left);
                break;
                }
              default:
                jj_la1[246] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
            }
          } else {
            ;
          }
          break;
          }
        default:
          jj_la1[248] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
return result;
}

  final public Expression InExpression() throws ParseException {/*@bgen(jjtree) InExpression */
    SimpleNode jjtn000 = new SimpleNode(JJTINEXPRESSION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));InExpression result = new InExpression();
    ItemsList leftItemsList = null;
    ItemsList rightItemsList = null;
    Expression leftExpression = null;
    Expression rightExpression = null;
    Token token;
    MultiExpressionList multiExpressionList = null;
    ExpressionList expressionList = null;
    try {
      if (jj_2_84(3)) {
        jj_consume_token(266);
        if (jj_2_83(2147483647)) {
          leftItemsList = SimpleExpressionList();
result.setLeftItemsList(leftItemsList);
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ACTION:
          case K_ANY:
          case K_BYTE:
          case K_CASCADE:
          case K_CASE:
          case K_CAST:
          case K_CHARACTER:
          case K_CHANGE:
          case K_CHAR:
          case K_COLUMN:
          case K_COLUMNS:
          case K_COMMIT:
          case K_COMMENT:
          case K_CREATE:
          case K_CURRENT:
          case K_CYCLE:
          case K_DATETIMELITERAL:
          case K_DATE_LITERAL:
          case K_DESC:
          case K_DESCRIBE:
          case K_DISABLE:
          case K_DIV:
          case K_DO:
          case K_DOUBLE:
          case K_DUPLICATE:
          case K_ENABLE:
          case K_END:
          case K_EXCLUDE:
          case K_EXTRACT:
          case K_FIRST:
          case K_FALSE:
          case K_FOLLOWING:
          case K_FORMAT:
          case K_GROUP:
          case K_GROUP_CONCAT:
          case K_IF:
          case K_IIF:
          case K_INDEX:
          case K_INSERT:
          case K_INTERVAL:
          case K_ISNULL:
          case K_KEY:
          case K_FN:
          case K_LAST:
          case K_LEFT:
          case K_LIMIT:
          case K_MATCH:
          case K_MATERIALIZED:
          case K_NEXTVAL:
          case K_NO:
          case K_NOLOCK:
          case K_NOT:
          case K_NULL:
          case K_NULLS:
          case K_OF:
          case K_OFFSET:
          case K_ON:
          case K_OPEN:
          case K_ORDER:
          case K_OVER:
          case K_OPTIMIZE:
          case K_PARTITION:
          case K_PATH:
          case K_PERCENT:
          case K_PRECISION:
          case K_PRIMARY:
          case K_PRIOR:
          case K_PROCEDURE:
          case K_PUBLIC:
          case K_RANGE:
          case K_READ:
          case K_REPLACE:
          case K_RIGHT:
          case K_ROW:
          case K_ROWS:
          case K_SCHEMA:
          case K_SEQUENCE:
          case K_SEPARATOR:
          case K_SESSION:
          case K_SET:
          case K_SIBLINGS:
          case K_SIZE:
          case K_START:
          case K_TABLE:
          case K_TABLES:
          case K_TEMP:
          case K_TEMPORARY:
          case K_TIME_KEY_EXPR:
          case K_TO:
          case K_TOP:
          case K_TRUNCATE:
          case K_TRUE:
          case K_TYPE:
          case K_UNSIGNED:
          case K_VALIDATE:
          case K_VALUE:
          case K_VALUES:
          case K_VIEW:
          case K_XML:
          case K_XMLSERIALIZE:
          case K_ZONE:
          case S_DOUBLE:
          case S_LONG:
          case S_HEX:
          case S_IDENTIFIER:
          case S_CHAR_LITERAL:
          case S_QUOTED_IDENTIFIER:
          case 266:
          case 271:
          case 272:
          case 273:
          case 274:
          case 277:
          case 278:
          case 286:
          case 296:
          case 298:
          case 299:
          case 303:
          case 312:{
            leftExpression = SimpleExpression();
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case 266:{
              jj_consume_token(266);
              jj_consume_token(274);
              jj_consume_token(267);
result.setOldOracleJoinSyntax(EqualsTo.ORACLE_JOIN_RIGHT);
              break;
              }
            default:
              jj_la1[249] = jj_gen;
              ;
            }
            break;
            }
          default:
            jj_la1[250] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        jj_consume_token(267);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ACTION:
        case K_ANY:
        case K_BYTE:
        case K_CASCADE:
        case K_CASE:
        case K_CAST:
        case K_CHARACTER:
        case K_CHANGE:
        case K_CHAR:
        case K_COLUMN:
        case K_COLUMNS:
        case K_COMMIT:
        case K_COMMENT:
        case K_CREATE:
        case K_CURRENT:
        case K_CYCLE:
        case K_DATETIMELITERAL:
        case K_DATE_LITERAL:
        case K_DESC:
        case K_DESCRIBE:
        case K_DISABLE:
        case K_DIV:
        case K_DO:
        case K_DOUBLE:
        case K_DUPLICATE:
        case K_ENABLE:
        case K_END:
        case K_EXCLUDE:
        case K_EXTRACT:
        case K_FIRST:
        case K_FALSE:
        case K_FOLLOWING:
        case K_FORMAT:
        case K_GROUP:
        case K_GROUP_CONCAT:
        case K_IF:
        case K_IIF:
        case K_INDEX:
        case K_INSERT:
        case K_INTERVAL:
        case K_ISNULL:
        case K_KEY:
        case K_FN:
        case K_LAST:
        case K_LEFT:
        case K_LIMIT:
        case K_MATCH:
        case K_MATERIALIZED:
        case K_NEXTVAL:
        case K_NO:
        case K_NOLOCK:
        case K_NOT:
        case K_NULL:
        case K_NULLS:
        case K_OF:
        case K_OFFSET:
        case K_ON:
        case K_OPEN:
        case K_ORDER:
        case K_OVER:
        case K_OPTIMIZE:
        case K_PARTITION:
        case K_PATH:
        case K_PERCENT:
        case K_PRECISION:
        case K_PRIMARY:
        case K_PRIOR:
        case K_PROCEDURE:
        case K_PUBLIC:
        case K_RANGE:
        case K_READ:
        case K_REPLACE:
        case K_RIGHT:
        case K_ROW:
        case K_ROWS:
        case K_SCHEMA:
        case K_SEQUENCE:
        case K_SEPARATOR:
        case K_SESSION:
        case K_SET:
        case K_SIBLINGS:
        case K_SIZE:
        case K_START:
        case K_TABLE:
        case K_TABLES:
        case K_TEMP:
        case K_TEMPORARY:
        case K_TIME_KEY_EXPR:
        case K_TO:
        case K_TOP:
        case K_TRUNCATE:
        case K_TRUE:
        case K_TYPE:
        case K_UNSIGNED:
        case K_VALIDATE:
        case K_VALUE:
        case K_VALUES:
        case K_VIEW:
        case K_XML:
        case K_XMLSERIALIZE:
        case K_ZONE:
        case S_DOUBLE:
        case S_LONG:
        case S_HEX:
        case S_IDENTIFIER:
        case S_CHAR_LITERAL:
        case S_QUOTED_IDENTIFIER:
        case 266:
        case 271:
        case 272:
        case 273:
        case 274:
        case 277:
        case 278:
        case 286:
        case 296:
        case 298:
        case 299:
        case 303:
        case 312:{
          leftExpression = SimpleExpression();
result.setLeftExpression(leftExpression);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 266:{
            jj_consume_token(266);
            jj_consume_token(274);
            jj_consume_token(267);
result.setOldOracleJoinSyntax(EqualsTo.ORACLE_JOIN_RIGHT);
            break;
            }
          default:
            jj_la1[251] = jj_gen;
            ;
          }
          break;
          }
        default:
          jj_la1[252] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOT:{
        jj_consume_token(K_NOT);
result.setNot(true);
        break;
        }
      default:
        jj_la1[253] = jj_gen;
        ;
      }
      jj_consume_token(K_IN);
      if (jj_2_86(3)) {
        multiExpressionList = MultiInExpressions();
      } else if (jj_2_87(3)) {
        rightExpression = Function();
      } else if (jj_2_88(2)) {
        token = jj_consume_token(S_CHAR_LITERAL);
rightExpression = new StringValue(token.image);
      } else if (jj_2_89(3)) {
        jj_consume_token(266);
        if (jj_2_85(3)) {
          rightItemsList = SubSelect();
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ACTION:
          case K_ANY:
          case K_BYTE:
          case K_CASCADE:
          case K_CASE:
          case K_CAST:
          case K_CHARACTER:
          case K_CHANGE:
          case K_CHAR:
          case K_COLUMN:
          case K_COLUMNS:
          case K_COMMIT:
          case K_COMMENT:
          case K_CREATE:
          case K_CURRENT:
          case K_CYCLE:
          case K_DATETIMELITERAL:
          case K_DATE_LITERAL:
          case K_DESC:
          case K_DESCRIBE:
          case K_DISABLE:
          case K_DIV:
          case K_DO:
          case K_DOUBLE:
          case K_DUPLICATE:
          case K_ENABLE:
          case K_END:
          case K_EXCLUDE:
          case K_EXTRACT:
          case K_FIRST:
          case K_FALSE:
          case K_FOLLOWING:
          case K_FORMAT:
          case K_GROUP:
          case K_GROUP_CONCAT:
          case K_IF:
          case K_IIF:
          case K_INDEX:
          case K_INSERT:
          case K_INTERVAL:
          case K_ISNULL:
          case K_KEY:
          case K_FN:
          case K_LAST:
          case K_LEFT:
          case K_LIMIT:
          case K_MATCH:
          case K_MATERIALIZED:
          case K_NEXTVAL:
          case K_NO:
          case K_NOLOCK:
          case K_NOT:
          case K_NULL:
          case K_NULLS:
          case K_OF:
          case K_OFFSET:
          case K_ON:
          case K_OPEN:
          case K_ORDER:
          case K_OVER:
          case K_OPTIMIZE:
          case K_PARTITION:
          case K_PATH:
          case K_PERCENT:
          case K_PRECISION:
          case K_PRIMARY:
          case K_PRIOR:
          case K_PROCEDURE:
          case K_PUBLIC:
          case K_RANGE:
          case K_READ:
          case K_REPLACE:
          case K_RIGHT:
          case K_ROW:
          case K_ROWS:
          case K_SCHEMA:
          case K_SEQUENCE:
          case K_SEPARATOR:
          case K_SESSION:
          case K_SET:
          case K_SIBLINGS:
          case K_SIZE:
          case K_START:
          case K_TABLE:
          case K_TABLES:
          case K_TEMP:
          case K_TEMPORARY:
          case K_TIME_KEY_EXPR:
          case K_TO:
          case K_TOP:
          case K_TRUNCATE:
          case K_TRUE:
          case K_TYPE:
          case K_UNSIGNED:
          case K_VALIDATE:
          case K_VALUE:
          case K_VALUES:
          case K_VIEW:
          case K_XML:
          case K_XMLSERIALIZE:
          case K_ZONE:
          case S_DOUBLE:
          case S_LONG:
          case S_HEX:
          case S_IDENTIFIER:
          case S_CHAR_LITERAL:
          case S_QUOTED_IDENTIFIER:
          case 266:
          case 271:
          case 272:
          case 273:
          case 274:
          case 277:
          case 278:
          case 286:
          case 296:
          case 298:
          case 299:
          case 303:
          case 312:{
            rightItemsList = SimpleExpressionList();
            break;
            }
          default:
            jj_la1[254] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        jj_consume_token(267);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ACTION:
        case K_ANY:
        case K_BYTE:
        case K_CASCADE:
        case K_CASE:
        case K_CAST:
        case K_CHARACTER:
        case K_CHANGE:
        case K_CHAR:
        case K_COLUMN:
        case K_COLUMNS:
        case K_COMMIT:
        case K_COMMENT:
        case K_CREATE:
        case K_CURRENT:
        case K_CYCLE:
        case K_DATETIMELITERAL:
        case K_DATE_LITERAL:
        case K_DESC:
        case K_DESCRIBE:
        case K_DISABLE:
        case K_DIV:
        case K_DO:
        case K_DOUBLE:
        case K_DUPLICATE:
        case K_ENABLE:
        case K_END:
        case K_EXCLUDE:
        case K_EXTRACT:
        case K_FIRST:
        case K_FALSE:
        case K_FOLLOWING:
        case K_FORMAT:
        case K_GROUP:
        case K_GROUP_CONCAT:
        case K_IF:
        case K_IIF:
        case K_INDEX:
        case K_INSERT:
        case K_INTERVAL:
        case K_ISNULL:
        case K_KEY:
        case K_FN:
        case K_LAST:
        case K_LEFT:
        case K_LIMIT:
        case K_MATCH:
        case K_MATERIALIZED:
        case K_NEXTVAL:
        case K_NO:
        case K_NOLOCK:
        case K_NOT:
        case K_NULL:
        case K_NULLS:
        case K_OF:
        case K_OFFSET:
        case K_ON:
        case K_OPEN:
        case K_ORDER:
        case K_OVER:
        case K_OPTIMIZE:
        case K_PARTITION:
        case K_PATH:
        case K_PERCENT:
        case K_PRECISION:
        case K_PRIMARY:
        case K_PRIOR:
        case K_PROCEDURE:
        case K_PUBLIC:
        case K_RANGE:
        case K_READ:
        case K_REPLACE:
        case K_RIGHT:
        case K_ROW:
        case K_ROWS:
        case K_SCHEMA:
        case K_SEQUENCE:
        case K_SEPARATOR:
        case K_SESSION:
        case K_SET:
        case K_SIBLINGS:
        case K_SIZE:
        case K_START:
        case K_TABLE:
        case K_TABLES:
        case K_TEMP:
        case K_TEMPORARY:
        case K_TIME_KEY_EXPR:
        case K_TO:
        case K_TOP:
        case K_TRUNCATE:
        case K_TRUE:
        case K_TYPE:
        case K_UNSIGNED:
        case K_VALIDATE:
        case K_VALUE:
        case K_VALUES:
        case K_VIEW:
        case K_XML:
        case K_XMLSERIALIZE:
        case K_ZONE:
        case S_DOUBLE:
        case S_LONG:
        case S_HEX:
        case S_IDENTIFIER:
        case S_CHAR_LITERAL:
        case S_QUOTED_IDENTIFIER:
        case 266:
        case 271:
        case 272:
        case 273:
        case 274:
        case 277:
        case 278:
        case 286:
        case 296:
        case 298:
        case 299:
        case 303:
        case 312:{
          rightExpression = SimpleExpression();
          break;
          }
        default:
          jj_la1[255] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
result.setRightItemsList(rightItemsList);
        result.setRightExpression(rightExpression);
        result.setMultiExpressionList(multiExpressionList);
        linkAST(result,jjtn000);
        return result;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public MultiExpressionList MultiInExpressions() throws ParseException {MultiExpressionList multiExpressionList = null;
   ExpressionList expressionList = null;
    jj_consume_token(266);
    jj_consume_token(266);
    expressionList = SimpleExpressionList();
if(multiExpressionList == null) {
         multiExpressionList = new MultiExpressionList();
       }
       multiExpressionList.addExpressionList(expressionList);
    label_60:
    while (true) {
      if (jj_2_90(3)) {
        ;
      } else {
        break label_60;
      }
      jj_consume_token(267);
      jj_consume_token(K_COMMA);
      jj_consume_token(266);
      expressionList = SimpleExpressionList();
if(multiExpressionList == null) {
          multiExpressionList = new MultiExpressionList();
       }
       multiExpressionList.addExpressionList(expressionList);
    }
    jj_consume_token(267);
    jj_consume_token(267);
return multiExpressionList;
}

  final public Expression Between(Expression leftExpression) throws ParseException {Between result = new Between();
    Expression betweenExpressionStart = null;
    Expression betweenExpressionEnd = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_NOT:{
      jj_consume_token(K_NOT);
result.setNot(true);
      break;
      }
    default:
      jj_la1[256] = jj_gen;
      ;
    }
    jj_consume_token(K_BETWEEN);
    betweenExpressionStart = SimpleExpression();
    jj_consume_token(K_AND);
    betweenExpressionEnd = SimpleExpression();
result.setLeftExpression(leftExpression);
        result.setBetweenExpressionStart(betweenExpressionStart);
        result.setBetweenExpressionEnd(betweenExpressionEnd);
        return result;
}

  final public Expression LikeExpression(Expression leftExpression) throws ParseException {/*@bgen(jjtree) LikeExpression */
    SimpleNode jjtn000 = new SimpleNode(JJTLIKEEXPRESSION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));LikeExpression result = new LikeExpression();
    Expression rightExpression = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOT:{
        jj_consume_token(K_NOT);
result.setNot(true);
        break;
        }
      default:
        jj_la1[257] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_LIKE:{
        jj_consume_token(K_LIKE);
        break;
        }
      case K_ILIKE:{
        jj_consume_token(K_ILIKE);
result.setCaseInsensitive(true);
        break;
        }
      default:
        jj_la1[258] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      rightExpression = SimpleExpression();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ESCAPE:{
        jj_consume_token(K_ESCAPE);
        token = jj_consume_token(S_CHAR_LITERAL);
result.setEscape((new StringValue(token.image)).getValue());
        break;
        }
      default:
        jj_la1[259] = jj_gen;
        ;
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
result.setLeftExpression(leftExpression);
        result.setRightExpression(rightExpression);
        linkAST(result,jjtn000);
        return result;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Expression SimilarToExpression(Expression leftExpression) throws ParseException {/*@bgen(jjtree) SimilarToExpression */
    SimpleNode jjtn000 = new SimpleNode(JJTSIMILARTOEXPRESSION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));SimilarToExpression result = new SimilarToExpression();
    Expression rightExpression = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOT:{
        jj_consume_token(K_NOT);
result.setNot(true);
        break;
        }
      default:
        jj_la1[260] = jj_gen;
        ;
      }
      jj_consume_token(K_SIMILAR);
      jj_consume_token(K_TO);
      rightExpression = SimpleExpression();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ESCAPE:{
        jj_consume_token(K_ESCAPE);
        token = jj_consume_token(S_CHAR_LITERAL);
result.setEscape((new StringValue(token.image)).getValue());
        break;
        }
      default:
        jj_la1[261] = jj_gen;
        ;
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
result.setLeftExpression(leftExpression);
        result.setRightExpression(rightExpression);
        linkAST(result,jjtn000);
        return result;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Expression IsNullExpression(Expression leftExpression) throws ParseException {IsNullExpression result = new IsNullExpression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ISNULL:{
      jj_consume_token(K_ISNULL);
result.setUseIsNull(true);
      break;
      }
    case K_IS:{
      jj_consume_token(K_IS);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOT:{
        jj_consume_token(K_NOT);
result.setNot(true);
        break;
        }
      default:
        jj_la1[262] = jj_gen;
        ;
      }
      jj_consume_token(K_NULL);
      break;
      }
    default:
      jj_la1[263] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
result.setLeftExpression(leftExpression);
        return result;
}

  final public Expression IsBooleanExpression(Expression leftExpression) throws ParseException {IsBooleanExpression result = new IsBooleanExpression();
    jj_consume_token(K_IS);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_NOT:{
      jj_consume_token(K_NOT);
result.setNot(true);
      break;
      }
    default:
      jj_la1[264] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_TRUE:{
      jj_consume_token(K_TRUE);
result.setIsTrue(true);
      break;
      }
    case K_FALSE:{
      jj_consume_token(K_FALSE);
result.setIsTrue(false);
      break;
      }
    default:
      jj_la1[265] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
result.setLeftExpression(leftExpression);
        return result;
}

  final public Expression ExistsExpression() throws ParseException {ExistsExpression result = new ExistsExpression();
    Expression rightExpression = null;
    jj_consume_token(K_EXISTS);
    rightExpression = SimpleExpression();
result.setRightExpression(rightExpression);
        return result;
}

  final public ExpressionList SQLExpressionList() throws ParseException {ExpressionList retval = new ExpressionList();
    List<Expression> expressions = new ArrayList<Expression>();
    Expression expr = null;
    expr = Expression();
expressions.add(expr);
    label_61:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[266] = jj_gen;
        break label_61;
      }
      jj_consume_token(K_COMMA);
      expr = Expression();
expressions.add(expr);
    }
retval.setExpressions(expressions);
        return retval;
}

  final public ExpressionList SimpleExpressionList() throws ParseException {/*@bgen(jjtree) ExpressionList */
    SimpleNode jjtn000 = new SimpleNode(JJTEXPRESSIONLIST);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));ExpressionList retval = new ExpressionList();
    List<Expression> expressions = new ArrayList<Expression>();
    Expression expr = null;
    try {
      expr = SimpleExpression();
expressions.add(expr);
      label_62:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[267] = jj_gen;
          break label_62;
        }
        jj_consume_token(K_COMMA);
        expr = SimpleExpression();
expressions.add(expr);
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
retval.setExpressions(expressions);
        return retval;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public ExpressionList ComplexExpressionList() throws ParseException {/*@bgen(jjtree) ExpressionList */
    SimpleNode jjtn000 = new SimpleNode(JJTEXPRESSIONLIST);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));ExpressionList retval = new ExpressionList();
    List<Expression> expressions = new ArrayList<Expression>();
    Expression expr = null;
    try {
      expr = Expression();
expressions.add(expr);
      label_63:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[268] = jj_gen;
          break label_63;
        }
        jj_consume_token(K_COMMA);
        expr = Expression();
expressions.add(expr);
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
retval.setExpressions(expressions);
        return retval;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

// trim( [leading|trailing|both] expr from expr)
// The [leading|trailing|both] token has already been consumed
  final public NamedExpressionList NamedExpressionList1() throws ParseException {NamedExpressionList retval = new NamedExpressionList();
    List<Expression> expressions = new ArrayList<Expression>();
    List<String> names = new ArrayList<String>();
    Expression expr1 = null;
    Expression expr2 = null;
        String name = "";
    Token tk1 = null;
    Token tk2 = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_BOTH:{
      tk1 = jj_consume_token(K_BOTH);
      break;
      }
    case K_LEADING:{
      tk1 = jj_consume_token(K_LEADING);
      break;
      }
    case K_TRAILING:{
      tk1 = jj_consume_token(K_TRAILING);
      break;
      }
    default:
      jj_la1[269] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
names.add(tk1.image);
    expr1 = SimpleExpression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FROM:{
      tk2 = jj_consume_token(K_FROM);
      break;
      }
    case K_IN:{
      tk2 = jj_consume_token(K_IN);
      break;
      }
    case K_PLACING:{
      tk2 = jj_consume_token(K_PLACING);
      break;
      }
    default:
      jj_la1[270] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    expr2 = SimpleExpression();
expressions.add(expr1); names.add(tk2.image); expressions.add(expr2);
retval.setNames(names);
        retval.setExpressions(expressions);
        return retval;
}

// substring(expr1 from expr2)
// substring(expr1 from expr2 for expr3)
// trim(expr1 from expr2)
// position(expr1 in expr2)
// overlay(expr1 placing expr2 from expr3)
// overlay(expr1 placing expr2 from expr3 for expr4)
// expr1 has already been consumed
  final public NamedExpressionList NamedExpressionListExprFirst() throws ParseException {NamedExpressionList retval = new NamedExpressionList();
    List<Expression> expressions = new ArrayList<Expression>();
    List<String> names = new ArrayList<String>();
    Expression expr1 = null;
    Expression expr2 = null;
    Expression expr3 = null;
    Expression expr4 = null;
    Token tk2 = null;
    Token tk3 = null;
    Token tk4 = null;
    expr1 = SimpleExpression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FROM:{
      tk2 = jj_consume_token(K_FROM);
      break;
      }
    case K_IN:{
      tk2 = jj_consume_token(K_IN);
      break;
      }
    case K_PLACING:{
      tk2 = jj_consume_token(K_PLACING);
      break;
      }
    default:
      jj_la1[271] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
names.add("");
                expressions.add(expr1);
                names.add(tk2.image);
    expr2 = SimpleExpression();
expressions.add(expr2);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FOR:
    case K_FROM:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_FOR:{
        tk3 = jj_consume_token(K_FOR);
        break;
        }
      case K_FROM:{
        tk3 = jj_consume_token(K_FROM);
        break;
        }
      default:
        jj_la1[272] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      expr3 = SimpleExpression();
names.add(tk3.image); expressions.add(expr3);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_FOR:{
        tk4 = jj_consume_token(K_FOR);
        expr4 = SimpleExpression();
names.add(tk4.image); expressions.add(expr4);
        break;
        }
      default:
        jj_la1[273] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[274] = jj_gen;
      ;
    }
retval.setNames(names);
        retval.setExpressions(expressions);
        return retval;
}

  final public ExpressionList SimpleExpressionListAtLeastTwoItems() throws ParseException {ExpressionList retval = new ExpressionList();
    List<Expression> expressions = new ArrayList<Expression>();
    Expression expr = null;
    expr = SimpleExpression();
expressions.add(expr);
    label_64:
    while (true) {
      jj_consume_token(K_COMMA);
      expr = SimpleExpression();
expressions.add(expr);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[275] = jj_gen;
        break label_64;
      }
    }
retval.setExpressions(expressions);
        return retval;
}

  final public Expression ComparisonItem() throws ParseException {Expression retval = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ALL:{
      retval = AllComparisonExpression();
      break;
      }
    default:
      jj_la1[276] = jj_gen;
      if (jj_2_91(3)) {
        retval = AnyComparisonExpression();
      } else if (jj_2_92(2147483647)) {
        retval = ValueListExpression();
      } else if (jj_2_93(3)) {
        retval = SimpleExpression();
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ROW:
        case 266:{
          retval = RowConstructor();
          break;
          }
        default:
          jj_la1[277] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
return retval;
}

  final public Expression AllComparisonExpression() throws ParseException {AllComparisonExpression retval = null;
    SubSelect subselect = null;
    jj_consume_token(K_ALL);
    jj_consume_token(266);
    subselect = SubSelect();
    jj_consume_token(267);
retval = new AllComparisonExpression(subselect);
return retval;
}

  final public Expression AnyComparisonExpression() throws ParseException {AnyComparisonExpression retval = null;
    AnyType anyType;
    SubSelect subselect = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ANY:{
      jj_consume_token(K_ANY);
anyType = AnyType.ANY;
      break;
      }
    case K_SOME:{
      jj_consume_token(K_SOME);
anyType = AnyType.SOME;
      break;
      }
    default:
      jj_la1[278] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(266);
    subselect = SubSelect();
    jj_consume_token(267);
retval = new AnyComparisonExpression(anyType, subselect);
return retval;
}

  final public Expression SimpleExpression() throws ParseException {Expression retval = null;
    UserVariable user = null;
    Token operation = null;
    if (jj_2_94(2147483647)) {
      user = UserVariable();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 268:{
        operation = jj_consume_token(268);
        break;
        }
      case 288:{
        operation = jj_consume_token(288);
        break;
        }
      default:
        jj_la1[279] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      ;
    }
    retval = ConcatExpression();
if (user != null) {
            VariableAssignment assignment = new VariableAssignment();
            assignment.setVariable(user);
            assignment.setOperation(operation.image);
            assignment.setExpression(retval);
            return assignment;
        } else
            return retval;
}

  final public Expression ConcatExpression() throws ParseException {Expression result = null;
    Expression leftExpression = null;
    Expression rightExpression = null;
    leftExpression = BitwiseAndOr();
result = leftExpression;
    label_65:
    while (true) {
      if (jj_2_95(3)) {
        ;
      } else {
        break label_65;
      }
      jj_consume_token(OP_CONCAT);
      /* Oracle allows space between the bars. */
              rightExpression = BitwiseAndOr();
Concat binExp = new Concat();
            binExp.setLeftExpression(leftExpression);
            binExp.setRightExpression(rightExpression);
            result = binExp;
            leftExpression = result;
    }
return result;
}

  final public Expression BitwiseAndOr() throws ParseException {Expression result = null;
    Expression leftExpression = null;
    Expression rightExpression = null;
    leftExpression = AdditiveExpression();
result = leftExpression;
    label_66:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 289:
      case 290:
      case 291:
      case 292:{
        ;
        break;
        }
      default:
        jj_la1[280] = jj_gen;
        break label_66;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 289:{
        jj_consume_token(289);
result = new BitwiseOr();
        break;
        }
      case 290:{
        jj_consume_token(290);
result = new BitwiseAnd();
        break;
        }
      case 291:{
        jj_consume_token(291);
result = new BitwiseLeftShift();
        break;
        }
      case 292:{
        jj_consume_token(292);
result = new BitwiseRightShift();
        break;
        }
      default:
        jj_la1[281] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      rightExpression = AdditiveExpression();
BinaryExpression binExp = (BinaryExpression) result;
            binExp.setLeftExpression(leftExpression);
            binExp.setRightExpression(rightExpression);
            leftExpression = result;
    }
return result;
}

  final public Expression AdditiveExpression() throws ParseException {Expression result = null;
    Expression leftExpression = null;
    Expression rightExpression = null;
    leftExpression = MultiplicativeExpression();
result = leftExpression;
    label_67:
    while (true) {
      if (jj_2_96(2)) {
        ;
      } else {
        break label_67;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 274:{
        jj_consume_token(274);
result = new Addition();
        break;
        }
      case 286:{
        jj_consume_token(286);
result = new Subtraction();
        break;
        }
      default:
        jj_la1[282] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      rightExpression = MultiplicativeExpression();
BinaryExpression binExp = (BinaryExpression) result;
            binExp.setLeftExpression(leftExpression);
            binExp.setRightExpression(rightExpression);
            leftExpression = result;
    }
return result;
}

  final public Expression MultiplicativeExpression() throws ParseException {Expression result = null;
    Expression leftExpression = null;
    Expression rightExpression = null;
    leftExpression = BitwiseXor();
result = leftExpression;
    label_68:
    while (true) {
      if (jj_2_97(2)) {
        ;
      } else {
        break label_68;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 269:{
        jj_consume_token(269);
result = new Multiplication();
        break;
        }
      case 293:{
        jj_consume_token(293);
result = new Division();
        break;
        }
      case K_DIV:{
        jj_consume_token(K_DIV);
result = new IntegerDivision();
        break;
        }
      case 294:{
        jj_consume_token(294);
result = new Modulo();
        break;
        }
      default:
        jj_la1[283] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      rightExpression = BitwiseXor();
BinaryExpression binExp = (BinaryExpression) result;
            binExp.setLeftExpression(leftExpression);
            binExp.setRightExpression(rightExpression);
            leftExpression = result;
    }
return result;
}

  final public Expression BitwiseXor() throws ParseException {Expression result = null;
    Expression leftExpression = null;
    Expression rightExpression = null;
    leftExpression = PrimaryExpression();
result = leftExpression;
    label_69:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 295:{
        ;
        break;
        }
      default:
        jj_la1[284] = jj_gen;
        break label_69;
      }
      jj_consume_token(295);
      rightExpression = PrimaryExpression();
BitwiseXor binExp = new BitwiseXor();
            binExp.setLeftExpression(leftExpression);
            binExp.setRightExpression(rightExpression);
            result = binExp;
            leftExpression = result;
    }
return result;
}

  final public Expression PrimaryExpression() throws ParseException {/*@bgen(jjtree) PrimaryExpression */
    SimpleNode jjtn000 = new SimpleNode(JJTPRIMARYEXPRESSION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Expression retval = null;
    CastExpression castExpr = null;
    Token token = null;
    Token sign = null;
    String tmp = "";
    ColDataType type = null;
    boolean not = false;
    boolean exclamationMarkNot = false;
    boolean dateExpressionAllowed = true;
    Expression idxExpr;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOT:
      case 273:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_NOT:{
          jj_consume_token(K_NOT);
not=true;
          break;
          }
        case 273:{
          jj_consume_token(273);
not=true; exclamationMarkNot=true;
          break;
          }
        default:
          jj_la1[285] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[286] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 274:
      case 278:
      case 286:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 274:{
          sign = jj_consume_token(274);
          break;
          }
        case 286:{
          sign = jj_consume_token(286);
          break;
          }
        case 278:{
          sign = jj_consume_token(278);
          break;
          }
        default:
          jj_la1[287] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[288] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NULL:{
        jj_consume_token(K_NULL);
retval = new NullValue();
        break;
        }
      case K_CASE:{
        retval = CaseWhenExpression();
        break;
        }
      case 271:{
        retval = SimpleJdbcParameter();
        break;
        }
      default:
        jj_la1[290] = jj_gen;
        if (jj_2_99(2)) {
          retval = JdbcNamedParameter();
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 277:
          case 303:{
            retval = UserVariable();
            break;
            }
          default:
            jj_la1[291] = jj_gen;
            if (jj_2_100(2)) {
              retval = NumericBind();
            } else if (jj_2_101(3)) {
              retval = ExtractExpression();
            } else {
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_GROUP_CONCAT:{
                retval = MySQLGroupConcat();
                break;
                }
              case K_XMLSERIALIZE:{
                retval = XMLSerializeExpr();
                break;
                }
              default:
                jj_la1[292] = jj_gen;
                if (jj_2_102(2147483647)) {
                  retval = JsonExpression();
                } else if (jj_2_103(2147483647)) {
                  retval = FunctionWithCondParams();
                } else if (jj_2_104(2147483647)) {
                  retval = FullTextSearch();
                } else if (jj_2_105(2147483647)) {
                  retval = Function();
                  if (jj_2_98(2)) {
                    retval = AnalyticExpression((Function)retval);
                  } else {
                    ;
                  }
                } else if (jj_2_106(2)) {
                  retval = IntervalExpression();
dateExpressionAllowed = false;
                } else {
                  switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                  case S_DOUBLE:{
                    token = jj_consume_token(S_DOUBLE);
retval = new DoubleValue(token.image);
                    break;
                    }
                  case S_LONG:{
                    token = jj_consume_token(S_LONG);
retval = new LongValue(token.image);
                    break;
                    }
                  case S_HEX:{
                    token = jj_consume_token(S_HEX);
retval = new HexValue(token.image);
                    break;
                    }
                  default:
                    jj_la1[293] = jj_gen;
                    if (jj_2_107(2)) {
                      retval = CastExpression();
                    } else {
                      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                      case K_CURRENT:
                      case K_TIME_KEY_EXPR:{
                        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                        case K_TIME_KEY_EXPR:{
                          token = jj_consume_token(K_TIME_KEY_EXPR);
                          break;
                          }
                        case K_CURRENT:{
                          token = jj_consume_token(K_CURRENT);
                          break;
                          }
                        default:
                          jj_la1[289] = jj_gen;
                          jj_consume_token(-1);
                          throw new ParseException();
                        }
retval = new TimeKeyExpression(token.image);
                        break;
                        }
                      default:
                        jj_la1[294] = jj_gen;
                        if (jj_2_108(2)) {
                          retval = DateTimeLiteralExpression();
                        } else if (jj_2_109(2)) {
                          retval = NextValExpression();
                        } else {
                          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                          case K_ACTION:
                          case K_ANY:
                          case K_BYTE:
                          case K_CASCADE:
                          case K_CAST:
                          case K_CHARACTER:
                          case K_CHANGE:
                          case K_CHAR:
                          case K_COLUMN:
                          case K_COLUMNS:
                          case K_COMMIT:
                          case K_COMMENT:
                          case K_CREATE:
                          case K_CYCLE:
                          case K_DATETIMELITERAL:
                          case K_DATE_LITERAL:
                          case K_DESC:
                          case K_DESCRIBE:
                          case K_DISABLE:
                          case K_DIV:
                          case K_DO:
                          case K_DOUBLE:
                          case K_DUPLICATE:
                          case K_ENABLE:
                          case K_END:
                          case K_EXCLUDE:
                          case K_EXTRACT:
                          case K_FIRST:
                          case K_FALSE:
                          case K_FOLLOWING:
                          case K_FORMAT:
                          case K_GROUP:
                          case K_IF:
                          case K_INDEX:
                          case K_INSERT:
                          case K_INTERVAL:
                          case K_ISNULL:
                          case K_KEY:
                          case K_FN:
                          case K_LAST:
                          case K_LEFT:
                          case K_LIMIT:
                          case K_MATERIALIZED:
                          case K_NEXTVAL:
                          case K_NO:
                          case K_NOLOCK:
                          case K_NULLS:
                          case K_OF:
                          case K_OFFSET:
                          case K_ON:
                          case K_OPEN:
                          case K_ORDER:
                          case K_OVER:
                          case K_OPTIMIZE:
                          case K_PARTITION:
                          case K_PATH:
                          case K_PERCENT:
                          case K_PRECISION:
                          case K_PRIMARY:
                          case K_PRIOR:
                          case K_PROCEDURE:
                          case K_PUBLIC:
                          case K_RANGE:
                          case K_READ:
                          case K_REPLACE:
                          case K_RIGHT:
                          case K_ROW:
                          case K_ROWS:
                          case K_SCHEMA:
                          case K_SEQUENCE:
                          case K_SEPARATOR:
                          case K_SESSION:
                          case K_SET:
                          case K_SIBLINGS:
                          case K_SIZE:
                          case K_START:
                          case K_TABLE:
                          case K_TABLES:
                          case K_TEMP:
                          case K_TEMPORARY:
                          case K_TO:
                          case K_TOP:
                          case K_TRUNCATE:
                          case K_TRUE:
                          case K_TYPE:
                          case K_UNSIGNED:
                          case K_VALIDATE:
                          case K_VALUE:
                          case K_VALUES:
                          case K_VIEW:
                          case K_XML:
                          case K_ZONE:
                          case S_IDENTIFIER:
                          case S_QUOTED_IDENTIFIER:{
                            retval = Column();
                            break;
                            }
                          case S_CHAR_LITERAL:{
                            token = jj_consume_token(S_CHAR_LITERAL);
retval = new StringValue(token.image); linkAST(retval,jjtn000);
                            break;
                            }
                          case 296:{
                            jj_consume_token(296);
                            token = jj_consume_token(S_CHAR_LITERAL);
                            jj_consume_token(297);
retval = new DateValue(token.image);
                            break;
                            }
                          case 298:{
                            jj_consume_token(298);
                            token = jj_consume_token(S_CHAR_LITERAL);
                            jj_consume_token(297);
retval = new TimeValue(token.image);
                            break;
                            }
                          case 299:{
                            jj_consume_token(299);
                            token = jj_consume_token(S_CHAR_LITERAL);
                            jj_consume_token(297);
retval = new TimestampValue(token.image);
                            break;
                            }
                          default:
                            jj_la1[295] = jj_gen;
                            if (jj_2_110(2147483647)) {
                              jj_consume_token(266);
                              retval = SubSelect();
                              jj_consume_token(267);
                            } else {
                              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                              case 266:{
                                jj_consume_token(266);
                                retval = SimpleExpression();
                                jj_consume_token(267);
retval = new Parenthesis(retval);
                                break;
                                }
                              default:
                                jj_la1[296] = jj_gen;
                                jj_consume_token(-1);
                                throw new ParseException();
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COLLATE:{
        jj_consume_token(K_COLLATE);
        token = jj_consume_token(S_IDENTIFIER);
retval = new CollateExpression(retval, token.image);
        break;
        }
      default:
        jj_la1[297] = jj_gen;
        ;
      }
      if (jj_2_111(2) && (dateExpressionAllowed)) {
        retval = IntervalExpressionWithoutInterval(retval);
      } else {
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 300:{
        jj_consume_token(300);
        idxExpr = SimpleExpression();
        jj_consume_token(301);
retval = new ArrayExpression(retval, idxExpr);
        break;
        }
      default:
        jj_la1[298] = jj_gen;
        ;
      }
      label_70:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 302:{
          ;
          break;
          }
        default:
          jj_la1[299] = jj_gen;
          break label_70;
        }
        jj_consume_token(302);
        type = ColDataType();
castExpr = new CastExpression();
        castExpr.setUseCastKeyword(false);
        castExpr.setLeftExpression(retval);
        castExpr.setType(type);
        retval=castExpr;
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
if (sign != null) {
            retval = new SignedExpression(sign.image.charAt(0), retval);
        }
        if (not) {
            retval = new NotExpression(retval, exclamationMarkNot);
        }
        return retval;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public NextValExpression NextValExpression() throws ParseException {List<String> data = new ArrayList<String>();
    jj_consume_token(K_NEXTVAL);
    jj_consume_token(K_FOR);
    data = RelObjectNameList();
return new NextValExpression(data);
}

  final public JdbcNamedParameter JdbcNamedParameter() throws ParseException {JdbcNamedParameter parameter = new JdbcNamedParameter();
    String name;
    jj_consume_token(272);
    name = RelObjectNameExt2();
parameter.setName(name);
return parameter;
}

  final public UserVariable UserVariable() throws ParseException {UserVariable var = new UserVariable();
    String varName;
    String var2;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 303:{
      jj_consume_token(303);
      break;
      }
    case 277:{
      jj_consume_token(277);
var.setDoubleAdd(true);
      break;
      }
    default:
      jj_la1[300] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    varName = RelObjectNameExt2();
    label_71:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 270:{
        ;
        break;
        }
      default:
        jj_la1[301] = jj_gen;
        break label_71;
      }
      jj_consume_token(270);
      var2 = RelObjectNameExt2();
varName+="." + var2;
    }
var.setName(varName);
        return var;
}

  final public NumericBind NumericBind() throws ParseException {NumericBind var = new NumericBind();
    Token token;
    jj_consume_token(272);
    token = jj_consume_token(S_LONG);
var.setBindId(Integer.valueOf(token.image));
        return var;
}

  final public DateTimeLiteralExpression DateTimeLiteralExpression() throws ParseException {DateTimeLiteralExpression expr = new DateTimeLiteralExpression();
    Token t;
    t = jj_consume_token(K_DATETIMELITERAL);
expr.setType(DateTimeLiteralExpression.DateTime.valueOf(t.image.toUpperCase()));
    t = jj_consume_token(S_CHAR_LITERAL);
expr.setValue(t.image); return expr;
}

  final public JsonExpression JsonExpression() throws ParseException {JsonExpression result = new JsonExpression();
  Column column;
  Token token;
    column = Column();
    label_72:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 304:{
        jj_consume_token(304);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_CHAR_LITERAL:{
          token = jj_consume_token(S_CHAR_LITERAL);
          break;
          }
        case S_LONG:{
          token = jj_consume_token(S_LONG);
          break;
          }
        default:
          jj_la1[302] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
result.addIdent(token.image,"->");
        break;
        }
      case 305:{
        jj_consume_token(305);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_CHAR_LITERAL:{
          token = jj_consume_token(S_CHAR_LITERAL);
          break;
          }
        case S_LONG:{
          token = jj_consume_token(S_LONG);
          break;
          }
        default:
          jj_la1[303] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
result.addIdent(token.image,"->>");
        break;
        }
      case 306:{
        jj_consume_token(306);
        token = jj_consume_token(S_CHAR_LITERAL);
result.addIdent(token.image,"#>");
        break;
        }
      case 307:{
        jj_consume_token(307);
        token = jj_consume_token(S_CHAR_LITERAL);
result.addIdent(token.image,"#>>");
        break;
        }
      default:
        jj_la1[304] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 304:
      case 305:
      case 306:
      case 307:{
        ;
        break;
        }
      default:
        jj_la1[305] = jj_gen;
        break label_72;
      }
    }
result.setColumn(column);
        return result;
}

  final public IntervalExpression IntervalExpression() throws ParseException {IntervalExpression interval;
    Token token = null;
    Expression expr = null;
    boolean signed = false;
interval = new IntervalExpression();
    jj_consume_token(K_INTERVAL);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 286:{
      jj_consume_token(286);
signed=true;
      break;
      }
    default:
      jj_la1[306] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_LONG:{
      token = jj_consume_token(S_LONG);
      break;
      }
    case S_DOUBLE:{
      token = jj_consume_token(S_DOUBLE);
      break;
      }
    case S_CHAR_LITERAL:{
      token = jj_consume_token(S_CHAR_LITERAL);
      break;
      }
    case K_ACTION:
    case K_ANY:
    case K_BYTE:
    case K_CASCADE:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHAR:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_CREATE:
    case K_CYCLE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DIV:
    case K_DO:
    case K_DOUBLE:
    case K_DUPLICATE:
    case K_ENABLE:
    case K_END:
    case K_EXCLUDE:
    case K_EXTRACT:
    case K_FIRST:
    case K_FALSE:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_GROUP:
    case K_IF:
    case K_INDEX:
    case K_INSERT:
    case K_INTERVAL:
    case K_ISNULL:
    case K_KEY:
    case K_FN:
    case K_LAST:
    case K_LEFT:
    case K_LIMIT:
    case K_MATERIALIZED:
    case K_NEXTVAL:
    case K_NO:
    case K_NOLOCK:
    case K_NULLS:
    case K_OF:
    case K_OFFSET:
    case K_ON:
    case K_OPEN:
    case K_ORDER:
    case K_OVER:
    case K_OPTIMIZE:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_PROCEDURE:
    case K_PUBLIC:
    case K_RANGE:
    case K_READ:
    case K_REPLACE:
    case K_RIGHT:
    case K_ROW:
    case K_ROWS:
    case K_SCHEMA:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SET:
    case K_SIBLINGS:
    case K_SIZE:
    case K_START:
    case K_TABLE:
    case K_TABLES:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TYPE:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VIEW:
    case K_XML:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      expr = Column();
      break;
      }
    case 272:{
      expr = JdbcNamedParameter();
      break;
      }
    case 271:{
      expr = SimpleJdbcParameter();
      break;
      }
    default:
      jj_la1[307] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if (expr != null) {
            if (signed) expr = new SignedExpression('-', expr);
            interval.setExpression(expr);
        } else {
            interval.setParameter((signed?"-":"") + token.image);
        }
    if (jj_2_112(2)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        token = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case K_DATE_LITERAL:{
        token = jj_consume_token(K_DATE_LITERAL);
        break;
        }
      default:
        jj_la1[308] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
interval.setIntervalType(token.image);
    } else {
      ;
    }
return interval;
}

  final public IntervalExpression IntervalExpressionWithoutInterval(Expression expr) throws ParseException {IntervalExpression interval;
    Token token;
    boolean signed = false;
interval = new IntervalExpression(false);
        interval.setExpression(expr);
    token = jj_consume_token(K_DATE_LITERAL);
interval.setIntervalType(token.image);
return interval;
}

  final public KeepExpression KeepExpression() throws ParseException {KeepExpression keep = new KeepExpression();
    Token token;
    List<OrderByElement> list;
    jj_consume_token(K_KEEP);
    jj_consume_token(266);
    token = jj_consume_token(S_IDENTIFIER);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FIRST:{
      jj_consume_token(K_FIRST);
keep.setFirst(true);
      break;
      }
    case K_LAST:{
      jj_consume_token(K_LAST);
keep.setFirst(false);
      break;
      }
    default:
      jj_la1[309] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    list = OrderByElements();
    jj_consume_token(267);
keep.setName(token.image);
        keep.setOrderByElements(list);
        return keep;
}

  final public void windowFun(AnalyticExpression retval) throws ParseException {ExpressionList expressionList = null;
         List<OrderByElement> olist = null;
         WindowElement windowElement = null;
         boolean partitionByBrackets = false;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_OVER:{
      jj_consume_token(K_OVER);
retval.setType(AnalyticType.OVER);
      break;
      }
    case K_WITHIN:{
      jj_consume_token(K_WITHIN);
      jj_consume_token(K_GROUP);
retval.setType(AnalyticType.WITHIN_GROUP);
      break;
      }
    default:
      jj_la1[310] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(266);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_PARTITION:{
      jj_consume_token(K_PARTITION);
      jj_consume_token(K_BY);
      if (jj_2_113(2147483647)) {
        expressionList = ComplexExpressionList();
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 266:{
          jj_consume_token(266);
partitionByBrackets = true;
          expressionList = ComplexExpressionList();
          jj_consume_token(267);
          break;
          }
        default:
          jj_la1[311] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[312] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ORDER:{
      olist = OrderByElements();
      break;
      }
    default:
      jj_la1[313] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_RANGE:
    case K_ROWS:{
      windowElement = WindowElement();
      break;
      }
    default:
      jj_la1[314] = jj_gen;
      ;
    }
retval.setPartitionExpressionList(expressionList, partitionByBrackets);
            retval.setOrderByElements(olist);
            retval.setWindowElement(windowElement);
    jj_consume_token(267);
}

  final public AnalyticExpression AnalyticExpression(Function function) throws ParseException {AnalyticExpression retval = new AnalyticExpression(function);
    Expression filter = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FILTER:{
      jj_consume_token(K_FILTER);
      jj_consume_token(266);
      jj_consume_token(K_WHERE);
retval.setType(AnalyticType.FILTER_ONLY);
      filter = Expression();
      jj_consume_token(267);
      if (jj_2_114(2)) {
        windowFun(retval);
      } else {
        ;
      }
      break;
      }
    case K_OVER:
    case K_WITHIN:{
      windowFun(retval);
      break;
      }
    default:
      jj_la1[315] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
retval.setFilterExpression(filter);
        return retval;
}

  final public WindowElement WindowElement() throws ParseException {WindowElement windowElement = new WindowElement();
    WindowRange range = new WindowRange();
    WindowOffset offset = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ROWS:{
      jj_consume_token(K_ROWS);
windowElement.setType(WindowElement.Type.ROWS);
      break;
      }
    case K_RANGE:{
      jj_consume_token(K_RANGE);
windowElement.setType(WindowElement.Type.RANGE);
      break;
      }
    default:
      jj_la1[316] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_BETWEEN:{
      jj_consume_token(K_BETWEEN);
windowElement.setRange(range);
      offset = WindowOffset();
range.setStart(offset);
      jj_consume_token(K_AND);
      offset = WindowOffset();
range.setEnd(offset);
      break;
      }
    case K_ACTION:
    case K_ANY:
    case K_BYTE:
    case K_CASCADE:
    case K_CASE:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHAR:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_CREATE:
    case K_CURRENT:
    case K_CYCLE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DIV:
    case K_DO:
    case K_DOUBLE:
    case K_DUPLICATE:
    case K_ENABLE:
    case K_END:
    case K_EXCLUDE:
    case K_EXTRACT:
    case K_FIRST:
    case K_FALSE:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_GROUP:
    case K_GROUP_CONCAT:
    case K_IF:
    case K_IIF:
    case K_INDEX:
    case K_INSERT:
    case K_INTERVAL:
    case K_ISNULL:
    case K_KEY:
    case K_FN:
    case K_LAST:
    case K_LEFT:
    case K_LIMIT:
    case K_MATCH:
    case K_MATERIALIZED:
    case K_NEXTVAL:
    case K_NO:
    case K_NOLOCK:
    case K_NOT:
    case K_NULL:
    case K_NULLS:
    case K_OF:
    case K_OFFSET:
    case K_ON:
    case K_OPEN:
    case K_ORDER:
    case K_OVER:
    case K_OPTIMIZE:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_PROCEDURE:
    case K_PUBLIC:
    case K_RANGE:
    case K_READ:
    case K_REPLACE:
    case K_RIGHT:
    case K_ROW:
    case K_ROWS:
    case K_SCHEMA:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SET:
    case K_SIBLINGS:
    case K_SIZE:
    case K_START:
    case K_TABLE:
    case K_TABLES:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIME_KEY_EXPR:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TYPE:
    case K_UNBOUNDED:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VIEW:
    case K_XML:
    case K_XMLSERIALIZE:
    case K_ZONE:
    case S_DOUBLE:
    case S_LONG:
    case S_HEX:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:
    case 266:
    case 271:
    case 272:
    case 273:
    case 274:
    case 277:
    case 278:
    case 286:
    case 296:
    case 298:
    case 299:
    case 303:
    case 312:{
      offset = WindowOffset();
windowElement.setOffset(offset);
      break;
      }
    default:
      jj_la1[317] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return windowElement;
}

  final public WindowOffset WindowOffset() throws ParseException {WindowOffset offset = new WindowOffset();
    Expression expr = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_UNBOUNDED:{
      jj_consume_token(K_UNBOUNDED);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_PRECEDING:{
        jj_consume_token(K_PRECEDING);
offset.setType(WindowOffset.Type.PRECEDING);
        break;
        }
      case K_FOLLOWING:{
        jj_consume_token(K_FOLLOWING);
offset.setType(WindowOffset.Type.FOLLOWING);
        break;
        }
      default:
        jj_la1[318] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[320] = jj_gen;
      if (jj_2_115(2)) {
        jj_consume_token(K_CURRENT);
        jj_consume_token(K_ROW);
offset.setType(WindowOffset.Type.CURRENT);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ACTION:
        case K_ANY:
        case K_BYTE:
        case K_CASCADE:
        case K_CASE:
        case K_CAST:
        case K_CHARACTER:
        case K_CHANGE:
        case K_CHAR:
        case K_COLUMN:
        case K_COLUMNS:
        case K_COMMIT:
        case K_COMMENT:
        case K_CREATE:
        case K_CURRENT:
        case K_CYCLE:
        case K_DATETIMELITERAL:
        case K_DATE_LITERAL:
        case K_DESC:
        case K_DESCRIBE:
        case K_DISABLE:
        case K_DIV:
        case K_DO:
        case K_DOUBLE:
        case K_DUPLICATE:
        case K_ENABLE:
        case K_END:
        case K_EXCLUDE:
        case K_EXTRACT:
        case K_FIRST:
        case K_FALSE:
        case K_FOLLOWING:
        case K_FORMAT:
        case K_GROUP:
        case K_GROUP_CONCAT:
        case K_IF:
        case K_IIF:
        case K_INDEX:
        case K_INSERT:
        case K_INTERVAL:
        case K_ISNULL:
        case K_KEY:
        case K_FN:
        case K_LAST:
        case K_LEFT:
        case K_LIMIT:
        case K_MATCH:
        case K_MATERIALIZED:
        case K_NEXTVAL:
        case K_NO:
        case K_NOLOCK:
        case K_NOT:
        case K_NULL:
        case K_NULLS:
        case K_OF:
        case K_OFFSET:
        case K_ON:
        case K_OPEN:
        case K_ORDER:
        case K_OVER:
        case K_OPTIMIZE:
        case K_PARTITION:
        case K_PATH:
        case K_PERCENT:
        case K_PRECISION:
        case K_PRIMARY:
        case K_PRIOR:
        case K_PROCEDURE:
        case K_PUBLIC:
        case K_RANGE:
        case K_READ:
        case K_REPLACE:
        case K_RIGHT:
        case K_ROW:
        case K_ROWS:
        case K_SCHEMA:
        case K_SEQUENCE:
        case K_SEPARATOR:
        case K_SESSION:
        case K_SET:
        case K_SIBLINGS:
        case K_SIZE:
        case K_START:
        case K_TABLE:
        case K_TABLES:
        case K_TEMP:
        case K_TEMPORARY:
        case K_TIME_KEY_EXPR:
        case K_TO:
        case K_TOP:
        case K_TRUNCATE:
        case K_TRUE:
        case K_TYPE:
        case K_UNSIGNED:
        case K_VALIDATE:
        case K_VALUE:
        case K_VALUES:
        case K_VIEW:
        case K_XML:
        case K_XMLSERIALIZE:
        case K_ZONE:
        case S_DOUBLE:
        case S_LONG:
        case S_HEX:
        case S_IDENTIFIER:
        case S_CHAR_LITERAL:
        case S_QUOTED_IDENTIFIER:
        case 266:
        case 271:
        case 272:
        case 273:
        case 274:
        case 277:
        case 278:
        case 286:
        case 296:
        case 298:
        case 299:
        case 303:
        case 312:{
          expr = SimpleExpression();
offset.setType(WindowOffset.Type.EXPR);
                        offset.setExpression(expr);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_PRECEDING:{
            jj_consume_token(K_PRECEDING);
offset.setType(WindowOffset.Type.PRECEDING);
            break;
            }
          case K_FOLLOWING:{
            jj_consume_token(K_FOLLOWING);
offset.setType(WindowOffset.Type.FOLLOWING);
            break;
            }
          default:
            jj_la1[319] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        default:
          jj_la1[321] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
return offset;
}

  final public ExtractExpression ExtractExpression() throws ParseException {ExtractExpression retval = new ExtractExpression();
    String token = null;
    Expression expr = null;
    jj_consume_token(K_EXTRACT);
    jj_consume_token(266);
    token = RelObjectName();
retval.setName(token);
    jj_consume_token(K_FROM);
    expr = SimpleExpression();
retval.setExpression(expr);
    jj_consume_token(267);
return retval;
}

  final public CastExpression CastExpression() throws ParseException {CastExpression retval = new CastExpression();
    ColDataType type = null;
    Expression expression = null;
    boolean    useCastKeyword;
    jj_consume_token(K_CAST);
    jj_consume_token(266);
    expression = SimpleExpression();
    jj_consume_token(K_AS);
    type = ColDataType();
    jj_consume_token(267);
retval.setUseCastKeyword(true);
retval.setLeftExpression(expression);
        retval.setType(type);
        return retval;
}

  final public Expression CaseWhenExpression() throws ParseException {/*@bgen(jjtree) CaseWhenExpression */
    SimpleNode jjtn000 = new SimpleNode(JJTCASEWHENEXPRESSION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));CaseExpression caseExp = new CaseExpression();
    Expression switchExp = null;
    WhenClause clause;
    List<WhenClause> whenClauses = new ArrayList<WhenClause>();
    Expression elseExp = null;
    try {
      jj_consume_token(K_CASE);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ACTION:
      case K_ALL:
      case K_ANY:
      case K_BYTE:
      case K_CASCADE:
      case K_CASE:
      case K_CAST:
      case K_CHARACTER:
      case K_CHANGE:
      case K_CHAR:
      case K_COLUMN:
      case K_COLUMNS:
      case K_COMMIT:
      case K_COMMENT:
      case K_CREATE:
      case K_CURRENT:
      case K_CYCLE:
      case K_DATETIMELITERAL:
      case K_DATE_LITERAL:
      case K_DESC:
      case K_DESCRIBE:
      case K_DISABLE:
      case K_DIV:
      case K_DO:
      case K_DOUBLE:
      case K_DUPLICATE:
      case K_ENABLE:
      case K_END:
      case K_EXCLUDE:
      case K_EXISTS:
      case K_EXTRACT:
      case K_FIRST:
      case K_FALSE:
      case K_FOLLOWING:
      case K_FORMAT:
      case K_GROUP:
      case K_GROUP_CONCAT:
      case K_IF:
      case K_IIF:
      case K_INDEX:
      case K_INSERT:
      case K_INTERVAL:
      case K_ISNULL:
      case K_KEY:
      case K_FN:
      case K_LAST:
      case K_LEFT:
      case K_LIMIT:
      case K_MATCH:
      case K_MATERIALIZED:
      case K_NEXTVAL:
      case K_NO:
      case K_NOLOCK:
      case K_NOT:
      case K_NULL:
      case K_NULLS:
      case K_OF:
      case K_OFFSET:
      case K_ON:
      case K_OPEN:
      case K_ORDER:
      case K_OVER:
      case K_OPTIMIZE:
      case K_PARTITION:
      case K_PATH:
      case K_PERCENT:
      case K_PRECISION:
      case K_PRIMARY:
      case K_PRIOR:
      case K_PROCEDURE:
      case K_PUBLIC:
      case K_RANGE:
      case K_READ:
      case K_REPLACE:
      case K_RIGHT:
      case K_ROW:
      case K_ROWS:
      case K_SCHEMA:
      case K_SEQUENCE:
      case K_SEPARATOR:
      case K_SESSION:
      case K_SET:
      case K_SIBLINGS:
      case K_SIZE:
      case K_SOME:
      case K_START:
      case K_TABLE:
      case K_TABLES:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_TO:
      case K_TOP:
      case K_TRUNCATE:
      case K_TRUE:
      case K_TYPE:
      case K_UNSIGNED:
      case K_VALIDATE:
      case K_VALUE:
      case K_VALUES:
      case K_VIEW:
      case K_XML:
      case K_XMLSERIALIZE:
      case K_ZONE:
      case S_DOUBLE:
      case S_LONG:
      case S_HEX:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:
      case 266:
      case 271:
      case 272:
      case 273:
      case 274:
      case 277:
      case 278:
      case 286:
      case 296:
      case 298:
      case 299:
      case 303:
      case 312:{
        switchExp = Condition();
        break;
        }
      default:
        jj_la1[322] = jj_gen;
        ;
      }
      label_73:
      while (true) {
        clause = WhenThenSearchCondition();
whenClauses.add(clause);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_WHEN:{
          ;
          break;
          }
        default:
          jj_la1[323] = jj_gen;
          break label_73;
        }
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ELSE:{
        jj_consume_token(K_ELSE);
        elseExp = Condition();
        break;
        }
      default:
        jj_la1[324] = jj_gen;
        ;
      }
      jj_consume_token(K_END);
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
caseExp.setSwitchExpression(switchExp);
        caseExp.setWhenClauses(whenClauses);
        caseExp.setElseExpression(elseExp);
        return caseExp;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public WhenClause WhenThenSearchCondition() throws ParseException {WhenClause whenThen = new WhenClause();
    Expression whenExp = null;
    Expression thenExp = null;
    jj_consume_token(K_WHEN);
    if (jj_2_116(2147483647)) {
      whenExp = Expression();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ACTION:
      case K_ANY:
      case K_BYTE:
      case K_CASCADE:
      case K_CASE:
      case K_CAST:
      case K_CHARACTER:
      case K_CHANGE:
      case K_CHAR:
      case K_COLUMN:
      case K_COLUMNS:
      case K_COMMIT:
      case K_COMMENT:
      case K_CREATE:
      case K_CURRENT:
      case K_CYCLE:
      case K_DATETIMELITERAL:
      case K_DATE_LITERAL:
      case K_DESC:
      case K_DESCRIBE:
      case K_DISABLE:
      case K_DIV:
      case K_DO:
      case K_DOUBLE:
      case K_DUPLICATE:
      case K_ENABLE:
      case K_END:
      case K_EXCLUDE:
      case K_EXTRACT:
      case K_FIRST:
      case K_FALSE:
      case K_FOLLOWING:
      case K_FORMAT:
      case K_GROUP:
      case K_GROUP_CONCAT:
      case K_IF:
      case K_IIF:
      case K_INDEX:
      case K_INSERT:
      case K_INTERVAL:
      case K_ISNULL:
      case K_KEY:
      case K_FN:
      case K_LAST:
      case K_LEFT:
      case K_LIMIT:
      case K_MATCH:
      case K_MATERIALIZED:
      case K_NEXTVAL:
      case K_NO:
      case K_NOLOCK:
      case K_NOT:
      case K_NULL:
      case K_NULLS:
      case K_OF:
      case K_OFFSET:
      case K_ON:
      case K_OPEN:
      case K_ORDER:
      case K_OVER:
      case K_OPTIMIZE:
      case K_PARTITION:
      case K_PATH:
      case K_PERCENT:
      case K_PRECISION:
      case K_PRIMARY:
      case K_PRIOR:
      case K_PROCEDURE:
      case K_PUBLIC:
      case K_RANGE:
      case K_READ:
      case K_REPLACE:
      case K_RIGHT:
      case K_ROW:
      case K_ROWS:
      case K_SCHEMA:
      case K_SEQUENCE:
      case K_SEPARATOR:
      case K_SESSION:
      case K_SET:
      case K_SIBLINGS:
      case K_SIZE:
      case K_START:
      case K_TABLE:
      case K_TABLES:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_TO:
      case K_TOP:
      case K_TRUNCATE:
      case K_TRUE:
      case K_TYPE:
      case K_UNSIGNED:
      case K_VALIDATE:
      case K_VALUE:
      case K_VALUES:
      case K_VIEW:
      case K_XML:
      case K_XMLSERIALIZE:
      case K_ZONE:
      case S_DOUBLE:
      case S_LONG:
      case S_HEX:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:
      case 266:
      case 271:
      case 272:
      case 273:
      case 274:
      case 277:
      case 278:
      case 286:
      case 296:
      case 298:
      case 299:
      case 303:
      case 312:{
        whenExp = SimpleExpression();
        break;
        }
      default:
        jj_la1[325] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(K_THEN);
    thenExp = Expression();
whenThen.setWhenExpression(whenExp);
       whenThen.setThenExpression(thenExp);
       return whenThen;
}

/*WhenClause WhenThenValue():
{
    WhenClause whenThen = new WhenClause();
    Expression whenExp = null;
    Expression thenExp = null;
}
{
    <K_WHEN> whenExp=SimpleExpression() <K_THEN> thenExp=SimpleExpression()
    {
       whenThen.setWhenExpression(whenExp);
       whenThen.setThenExpression(thenExp);
       return whenThen;
    }
}*/
  final public 
RowConstructor RowConstructor() throws ParseException {ExpressionList list = null;
    RowConstructor rowConstructor = new RowConstructor();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ROW:{
      jj_consume_token(K_ROW);
rowConstructor.setName("ROW");
      break;
      }
    default:
      jj_la1[326] = jj_gen;
      ;
    }
    jj_consume_token(266);
    list = SimpleExpressionList();
    jj_consume_token(267);
rowConstructor.setExprList(list);
        return rowConstructor;
}

/**
TODO: VariableExpression should be a standalone class with more operations available. 
*/
  final public EqualsTo VariableExpression() throws ParseException {Expression left;
    Expression right;
    left = UserVariable();
    jj_consume_token(268);
    right = SimpleExpression();
EqualsTo equals = new EqualsTo();
        equals.setLeftExpression(left);
        equals.setRightExpression(right);
        return equals;
}

  final public Execute Execute() throws ParseException {List<String> funcName;
    ExpressionList expressionList = null;
    Execute execute = new Execute();
    List<Expression> namedExprList;
    Expression expr;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_EXEC:{
      jj_consume_token(K_EXEC);
execute.setExecType(Execute.EXEC_TYPE.EXEC);
      break;
      }
    case K_EXECUTE:{
      jj_consume_token(K_EXECUTE);
execute.setExecType(Execute.EXEC_TYPE.EXECUTE);
      break;
      }
    case K_CALL:{
      jj_consume_token(K_CALL);
execute.setExecType(Execute.EXEC_TYPE.CALL);
      break;
      }
    default:
      jj_la1[327] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    funcName = RelObjectNameList();
execute.setName(funcName);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ANY:
    case K_BYTE:
    case K_CASCADE:
    case K_CASE:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHAR:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_CREATE:
    case K_CURRENT:
    case K_CYCLE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DIV:
    case K_DO:
    case K_DOUBLE:
    case K_DUPLICATE:
    case K_ENABLE:
    case K_END:
    case K_EXCLUDE:
    case K_EXTRACT:
    case K_FIRST:
    case K_FALSE:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_GROUP:
    case K_GROUP_CONCAT:
    case K_IF:
    case K_IIF:
    case K_INDEX:
    case K_INSERT:
    case K_INTERVAL:
    case K_ISNULL:
    case K_KEY:
    case K_FN:
    case K_LAST:
    case K_LEFT:
    case K_LIMIT:
    case K_MATCH:
    case K_MATERIALIZED:
    case K_NEXTVAL:
    case K_NO:
    case K_NOLOCK:
    case K_NOT:
    case K_NULL:
    case K_NULLS:
    case K_OF:
    case K_OFFSET:
    case K_ON:
    case K_OPEN:
    case K_ORDER:
    case K_OVER:
    case K_OPTIMIZE:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_PROCEDURE:
    case K_PUBLIC:
    case K_RANGE:
    case K_READ:
    case K_REPLACE:
    case K_RIGHT:
    case K_ROW:
    case K_ROWS:
    case K_SCHEMA:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SET:
    case K_SIBLINGS:
    case K_SIZE:
    case K_START:
    case K_TABLE:
    case K_TABLES:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIME_KEY_EXPR:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TYPE:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VIEW:
    case K_XML:
    case K_XMLSERIALIZE:
    case K_ZONE:
    case S_DOUBLE:
    case S_LONG:
    case S_HEX:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:
    case 266:
    case 271:
    case 272:
    case 273:
    case 274:
    case 277:
    case 278:
    case 286:
    case 296:
    case 298:
    case 299:
    case 303:
    case 312:{
      if (jj_2_117(3)) {
        expr = VariableExpression();
namedExprList = new ArrayList<Expression>(); namedExprList.add( expr );
        label_74:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_COMMA:{
            ;
            break;
            }
          default:
            jj_la1[328] = jj_gen;
            break label_74;
          }
          jj_consume_token(K_COMMA);
          expr = VariableExpression();
namedExprList.add(expr);
        }
expressionList = new ExpressionList(namedExprList);
      } else if (jj_2_118(3)) {
        expressionList = SimpleExpressionList();
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 266:{
          jj_consume_token(266);
          expressionList = SimpleExpressionList();
          jj_consume_token(267);
execute.setParenthesis(true);
          break;
          }
        default:
          jj_la1[329] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[330] = jj_gen;
      ;
    }
execute.setExprList(expressionList);
        return execute;
}

  final public FullTextSearch FullTextSearch() throws ParseException {Column col;
    Token searchModifier;
    Token againstValue;
    FullTextSearch fs = new FullTextSearch();
    List<Column> matchedColumns = new ArrayList<Column>();
    List<Expression> expList = new ArrayList<Expression>();
    jj_consume_token(K_MATCH);
    jj_consume_token(266);
    col = Column();
matchedColumns.add(col);
    label_75:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[331] = jj_gen;
        break label_75;
      }
      jj_consume_token(K_COMMA);
      col = Column();
matchedColumns.add(col);
    }
    jj_consume_token(267);
    jj_consume_token(K_AGAINST);
    jj_consume_token(266);
    againstValue = jj_consume_token(S_CHAR_LITERAL);
fs.setAgainstValue(new StringValue(againstValue.image));
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 308:
    case 309:
    case 310:
    case 311:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 308:{
        searchModifier = jj_consume_token(308);
        break;
        }
      case 309:{
        searchModifier = jj_consume_token(309);
        break;
        }
      case 310:{
        searchModifier = jj_consume_token(310);
        break;
        }
      case 311:{
        searchModifier = jj_consume_token(311);
        break;
        }
      default:
        jj_la1[332] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
fs.setSearchModifier(searchModifier.image);
      break;
      }
    default:
      jj_la1[333] = jj_gen;
      ;
    }
    jj_consume_token(267);
fs.setMatchColumns(matchedColumns);
        return fs;
}

  final public Function FunctionWithCondParams() throws ParseException {/*@bgen(jjtree) Function */
    SimpleNode jjtn000 = new SimpleNode(JJTFUNCTION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Function retval = new Function();
    String funcName = null;
    ExpressionList expressionList = null;
    Token token = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_IF:{
        token = jj_consume_token(K_IF);
        break;
        }
      case K_IIF:{
        token = jj_consume_token(K_IIF);
        break;
        }
      default:
        jj_la1[334] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
funcName=token.image;
      jj_consume_token(266);
      expressionList = ComplexExpressionList();
      jj_consume_token(267);
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
retval.setParameters(expressionList);
        retval.setName(funcName);
        linkAST(retval,jjtn000);
        return retval;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Function Function() throws ParseException {/*@bgen(jjtree) Function */
    SimpleNode jjtn000 = new SimpleNode(JJTFUNCTION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Function retval = new Function();
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 312:{
        jj_consume_token(312);
        jj_consume_token(K_FN);
retval.setEscaped(true);
        InternalFunction(retval);
        jj_consume_token(297);
        break;
        }
      case K_ACTION:
      case K_ANY:
      case K_BYTE:
      case K_CASCADE:
      case K_CAST:
      case K_CHARACTER:
      case K_CHANGE:
      case K_CHAR:
      case K_COLUMN:
      case K_COLUMNS:
      case K_COMMIT:
      case K_COMMENT:
      case K_CREATE:
      case K_CYCLE:
      case K_DATETIMELITERAL:
      case K_DATE_LITERAL:
      case K_DESC:
      case K_DESCRIBE:
      case K_DISABLE:
      case K_DIV:
      case K_DO:
      case K_DOUBLE:
      case K_DUPLICATE:
      case K_ENABLE:
      case K_END:
      case K_EXCLUDE:
      case K_EXTRACT:
      case K_FIRST:
      case K_FALSE:
      case K_FOLLOWING:
      case K_FORMAT:
      case K_GROUP:
      case K_IF:
      case K_INDEX:
      case K_INSERT:
      case K_INTERVAL:
      case K_ISNULL:
      case K_KEY:
      case K_FN:
      case K_LAST:
      case K_LEFT:
      case K_LIMIT:
      case K_MATERIALIZED:
      case K_NEXTVAL:
      case K_NO:
      case K_NOLOCK:
      case K_NULLS:
      case K_OF:
      case K_OFFSET:
      case K_ON:
      case K_OPEN:
      case K_ORDER:
      case K_OVER:
      case K_OPTIMIZE:
      case K_PARTITION:
      case K_PATH:
      case K_PERCENT:
      case K_PRECISION:
      case K_PRIMARY:
      case K_PRIOR:
      case K_PROCEDURE:
      case K_PUBLIC:
      case K_RANGE:
      case K_READ:
      case K_REPLACE:
      case K_RIGHT:
      case K_ROW:
      case K_ROWS:
      case K_SCHEMA:
      case K_SEQUENCE:
      case K_SEPARATOR:
      case K_SESSION:
      case K_SET:
      case K_SIBLINGS:
      case K_SIZE:
      case K_START:
      case K_TABLE:
      case K_TABLES:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TO:
      case K_TOP:
      case K_TRUNCATE:
      case K_TRUE:
      case K_TYPE:
      case K_UNSIGNED:
      case K_VALIDATE:
      case K_VALUE:
      case K_VALUES:
      case K_VIEW:
      case K_XML:
      case K_ZONE:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:{
        InternalFunction(retval);
        break;
        }
      default:
        jj_la1[335] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
linkAST(retval,jjtn000);
        return retval;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Function InternalFunction(Function retval) throws ParseException {List<String> funcName;
    String tmp = null;
    List<Expression> expressions = new ArrayList<Expression>();
    ExpressionList expressionList = null;
    NamedExpressionList namedExpressionList = null;
    KeepExpression keep = null;
    SubSelect expr = null;
    Token tk1 = null;
    Token tk2 = null;
    Expression expr1 = null;
    boolean ignoreNulls = false;
    funcName = RelObjectNameList();
    jj_consume_token(266);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ALL:
    case K_ANY:
    case K_BOTH:
    case K_BYTE:
    case K_CASCADE:
    case K_CASE:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHAR:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_CREATE:
    case K_CURRENT:
    case K_CYCLE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DISTINCT:
    case K_DIV:
    case K_DO:
    case K_DOUBLE:
    case K_DUPLICATE:
    case K_ENABLE:
    case K_END:
    case K_EXCLUDE:
    case K_EXTRACT:
    case K_FIRST:
    case K_FALSE:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_GROUP:
    case K_GROUP_CONCAT:
    case K_IF:
    case K_IIF:
    case K_INDEX:
    case K_INSERT:
    case K_INTERVAL:
    case K_ISNULL:
    case K_KEY:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LEFT:
    case K_LIMIT:
    case K_MATCH:
    case K_MATERIALIZED:
    case K_NEXTVAL:
    case K_NO:
    case K_NOLOCK:
    case K_NOT:
    case K_NULL:
    case K_NULLS:
    case K_OF:
    case K_OFFSET:
    case K_ON:
    case K_OPEN:
    case K_ORDER:
    case K_OVER:
    case K_OPTIMIZE:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_PROCEDURE:
    case K_PUBLIC:
    case K_RANGE:
    case K_READ:
    case K_REPLACE:
    case K_RIGHT:
    case K_ROW:
    case K_ROWS:
    case K_SCHEMA:
    case K_SELECT:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SET:
    case K_SIBLINGS:
    case K_SIZE:
    case K_START:
    case K_TABLE:
    case K_TABLES:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIME_KEY_EXPR:
    case K_TO:
    case K_TOP:
    case K_TRAILING:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TYPE:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VIEW:
    case K_WITH:
    case K_XML:
    case K_XMLSERIALIZE:
    case K_ZONE:
    case S_DOUBLE:
    case S_LONG:
    case S_HEX:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:
    case 266:
    case 269:
    case 271:
    case 272:
    case 273:
    case 274:
    case 277:
    case 278:
    case 286:
    case 296:
    case 298:
    case 299:
    case 303:
    case 312:{
      if (jj_2_119(2)) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_DISTINCT:{
          jj_consume_token(K_DISTINCT);
retval.setDistinct(true);
          break;
          }
        case K_ALL:{
          jj_consume_token(K_ALL);
retval.setAllColumns(true);
          break;
          }
        default:
          jj_la1[336] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else {
        ;
      }
      if (jj_2_120(4)) {
        jj_consume_token(269);
retval.setAllColumns(true);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_BOTH:
        case K_LEADING:
        case K_TRAILING:{
          namedExpressionList = NamedExpressionList1();
          break;
          }
        default:
          jj_la1[337] = jj_gen;
          if (jj_2_121(2147483647)) {
            namedExpressionList = NamedExpressionListExprFirst();
          } else if (jj_2_122(3)) {
            expressionList = SimpleExpressionList();
          } else {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_SELECT:
            case K_VALUES:
            case K_WITH:
            case 266:{
              expr = SubSelect();
expr.setUseBrackets(false); expressionList = new ExpressionList(expr);
              break;
              }
            default:
              jj_la1[338] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
        }
      }
      break;
      }
    default:
      jj_la1[339] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_IGNORE:{
      jj_consume_token(K_IGNORE);
      jj_consume_token(K_NULLS);
retval.setIgnoreNulls(true);
      break;
      }
    default:
      jj_la1[340] = jj_gen;
      ;
    }
    jj_consume_token(267);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 270:{
      jj_consume_token(270);
      if (jj_2_123(2)) {
        expr1 = Function();
retval.setAttribute(expr1);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ACTION:
        case K_ANY:
        case K_BYTE:
        case K_CASCADE:
        case K_CAST:
        case K_CHARACTER:
        case K_CHANGE:
        case K_CHAR:
        case K_COLUMN:
        case K_COLUMNS:
        case K_COMMIT:
        case K_COMMENT:
        case K_CREATE:
        case K_CYCLE:
        case K_DATETIMELITERAL:
        case K_DATE_LITERAL:
        case K_DESC:
        case K_DESCRIBE:
        case K_DISABLE:
        case K_DIV:
        case K_DO:
        case K_DUPLICATE:
        case K_ENABLE:
        case K_END:
        case K_EXCLUDE:
        case K_EXTRACT:
        case K_FIRST:
        case K_FALSE:
        case K_FOLLOWING:
        case K_FORMAT:
        case K_GROUP:
        case K_INDEX:
        case K_INSERT:
        case K_INTERVAL:
        case K_ISNULL:
        case K_KEY:
        case K_FN:
        case K_LAST:
        case K_MATERIALIZED:
        case K_NEXTVAL:
        case K_NO:
        case K_NOLOCK:
        case K_NULLS:
        case K_OF:
        case K_ON:
        case K_OPEN:
        case K_ORDER:
        case K_OVER:
        case K_PARTITION:
        case K_PATH:
        case K_PERCENT:
        case K_PRECISION:
        case K_PRIMARY:
        case K_PRIOR:
        case K_RANGE:
        case K_READ:
        case K_REPLACE:
        case K_ROW:
        case K_ROWS:
        case K_SCHEMA:
        case K_SEQUENCE:
        case K_SEPARATOR:
        case K_SESSION:
        case K_SIBLINGS:
        case K_SIZE:
        case K_START:
        case K_TABLE:
        case K_TABLES:
        case K_TEMP:
        case K_TEMPORARY:
        case K_TO:
        case K_TOP:
        case K_TRUNCATE:
        case K_TRUE:
        case K_TYPE:
        case K_UNSIGNED:
        case K_VALIDATE:
        case K_VALUE:
        case K_VALUES:
        case K_VIEW:
        case K_XML:
        case K_ZONE:
        case S_IDENTIFIER:
        case S_QUOTED_IDENTIFIER:{
          tmp = RelObjectName();
retval.setAttributeName(tmp);
          break;
          }
        default:
          jj_la1[341] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[342] = jj_gen;
      ;
    }
    if (jj_2_124(2)) {
      keep = KeepExpression();
    } else {
      ;
    }
retval.setParameters(expressionList);
        retval.setNamedParameters(namedExpressionList);
        retval.setName(funcName);
        retval.setKeep(keep);
        return retval;
}

  final public XMLSerializeExpr XMLSerializeExpr() throws ParseException {XMLSerializeExpr result;
   Expression expression;
   List<OrderByElement> orderByElements = null;
   ColDataType dataType;
    jj_consume_token(K_XMLSERIALIZE);
    jj_consume_token(266);
    jj_consume_token(K_XMLAGG);
    jj_consume_token(266);
    jj_consume_token(K_XMLTEXT);
    jj_consume_token(266);
    expression = SimpleExpression();
    jj_consume_token(267);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ORDER:{
      orderByElements = OrderByElements();
      break;
      }
    default:
      jj_la1[343] = jj_gen;
      ;
    }
    jj_consume_token(267);
    jj_consume_token(K_AS);
    dataType = ColDataType();
    jj_consume_token(267);
result = new XMLSerializeExpr();
        result.setExpression(expression);
        result.setOrderByElements(orderByElements);
        result.setDataType(dataType);
        return result;
}

  final public MySQLGroupConcat MySQLGroupConcat() throws ParseException {MySQLGroupConcat retval = new MySQLGroupConcat();
    ExpressionList expressionList = null;
    List<OrderByElement> orderByList = null;
    Token t;
    jj_consume_token(K_GROUP_CONCAT);
    jj_consume_token(266);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_DISTINCT:{
      jj_consume_token(K_DISTINCT);
retval.setDistinct(true);
      break;
      }
    default:
      jj_la1[344] = jj_gen;
      ;
    }
    expressionList = SimpleExpressionList();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ORDER:{
      orderByList = OrderByElements();
retval.setOrderByElements(orderByList);
      break;
      }
    default:
      jj_la1[345] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_SEPARATOR:{
      jj_consume_token(K_SEPARATOR);
      t = jj_consume_token(S_CHAR_LITERAL);
retval.setSeparator(t.image);
      break;
      }
    default:
      jj_la1[346] = jj_gen;
      ;
    }
    jj_consume_token(267);
retval.setExpressionList(expressionList);
        return retval;
}

  final public ValueListExpression ValueListExpression() throws ParseException {ValueListExpression retval = new ValueListExpression();
    ExpressionList expressionList = null;
    jj_consume_token(266);
    expressionList = SimpleExpressionListAtLeastTwoItems();
    jj_consume_token(267);
retval.setExpressionList(expressionList);
        return retval;
}

  final public TableFunction TableFunction() throws ParseException {Alias alias = null;
    Function function;
    TableFunction functionItem;
    function = Function();
functionItem = new TableFunction().withFunction(function);
    if (jj_2_125(2)) {
      alias = Alias();
functionItem.setAlias(alias);
    } else {
      ;
    }
return functionItem;
}

  final public SubSelect SubSelect() throws ParseException {/*@bgen(jjtree) SubSelect */
    SimpleNode jjtn000 = new SimpleNode(JJTSUBSELECT);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));SelectBody selectBody = null;
    SubSelect subSelect = new SubSelect();
    List<WithItem> with = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_WITH:{
        with = WithList();
subSelect.setWithItemsList(with);
        break;
        }
      default:
        jj_la1[347] = jj_gen;
        ;
      }
      selectBody = SelectBody();
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
subSelect.setSelectBody(selectBody);
        linkAST(subSelect,jjtn000);
        return subSelect;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public List<Index.ColumnParams> ColumnNamesWithParamsList() throws ParseException {List<Index.ColumnParams> colNames = new ArrayList<Index.ColumnParams>();
    String columnName;
    List<String> parameter = null;
    jj_consume_token(266);
    columnName = RelObjectName();
parameter = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ASC:
    case K_BY:
    case K_CASCADE:
    case K_CHECK:
    case K_COLLATE:
    case K_COMMIT:
    case K_COMMENT:
    case K_CONSTRAINT:
    case K_DEFAULT:
    case K_DELETE:
    case K_DESC:
    case K_EXCLUDE:
    case K_FALSE:
    case K_FOREIGN:
    case K_IN:
    case K_KEY:
    case K_NOT:
    case K_NULL:
    case K_ON:
    case K_PARTITION:
    case K_PRIMARY:
    case K_REFERENCES:
    case K_ROWS:
    case K_TABLESPACE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIME_KEY_EXPR:
    case K_TRUE:
    case K_TYPE:
    case K_UNIQUE:
    case K_UPDATE:
    case K_USING:
    case K_UNSIGNED:
    case K_WHERE:
    case K_WITH:
    case S_DOUBLE:
    case S_LONG:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:
    case 266:
    case 268:
    case 274:
    case 286:
    case 302:{
      parameter = CreateParameter();
      break;
      }
    default:
      jj_la1[348] = jj_gen;
      ;
    }
colNames.add(new Index.ColumnParams(columnName,parameter));
    label_76:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[349] = jj_gen;
        break label_76;
      }
      jj_consume_token(K_COMMA);
      columnName = RelObjectName();
parameter = null;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ASC:
      case K_BY:
      case K_CASCADE:
      case K_CHECK:
      case K_COLLATE:
      case K_COMMIT:
      case K_COMMENT:
      case K_CONSTRAINT:
      case K_DEFAULT:
      case K_DELETE:
      case K_DESC:
      case K_EXCLUDE:
      case K_FALSE:
      case K_FOREIGN:
      case K_IN:
      case K_KEY:
      case K_NOT:
      case K_NULL:
      case K_ON:
      case K_PARTITION:
      case K_PRIMARY:
      case K_REFERENCES:
      case K_ROWS:
      case K_TABLESPACE:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_TRUE:
      case K_TYPE:
      case K_UNIQUE:
      case K_UPDATE:
      case K_USING:
      case K_UNSIGNED:
      case K_WHERE:
      case K_WITH:
      case S_DOUBLE:
      case S_LONG:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:
      case 266:
      case 268:
      case 274:
      case 286:
      case 302:{
        parameter = CreateParameter();
        break;
        }
      default:
        jj_la1[350] = jj_gen;
        ;
      }
colNames.add(new Index.ColumnParams(columnName,parameter));
    }
    jj_consume_token(267);
return colNames;
}

  final public CreateIndex CreateIndex() throws ParseException {CreateIndex createIndex = new CreateIndex();
    Table table = null;
    List<Index.ColumnParams> colNames;
    //Token columnName;
    Token using;
    Index index = null;
    //String name = null;
    List<String> parameter = new ArrayList<String>();
    List<String> tailParameter = null;
    List<String> name;
    jj_consume_token(K_CREATE);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ASC:
    case K_BY:
    case K_CASCADE:
    case K_CHECK:
    case K_COLLATE:
    case K_COMMIT:
    case K_COMMENT:
    case K_CONSTRAINT:
    case K_DEFAULT:
    case K_DELETE:
    case K_DESC:
    case K_EXCLUDE:
    case K_FALSE:
    case K_FOREIGN:
    case K_IN:
    case K_KEY:
    case K_NOT:
    case K_NULL:
    case K_ON:
    case K_PARTITION:
    case K_PRIMARY:
    case K_REFERENCES:
    case K_ROWS:
    case K_TABLESPACE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIME_KEY_EXPR:
    case K_TRUE:
    case K_TYPE:
    case K_UNIQUE:
    case K_UPDATE:
    case K_USING:
    case K_UNSIGNED:
    case K_WHERE:
    case K_WITH:
    case S_DOUBLE:
    case S_LONG:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:
    case 266:
    case 268:
    case 274:
    case 286:
    case 302:{
      parameter = CreateParameter();
      break;
      }
    default:
      jj_la1[351] = jj_gen;
      ;
    }
    jj_consume_token(K_INDEX);
    name = RelObjectNameList();
index = new Index();
        index.setName(name);
        index.setType(parameter.isEmpty()?null:parameter.get(0));
    jj_consume_token(K_ON);
    table = Table();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_USING:{
      jj_consume_token(K_USING);
      using = jj_consume_token(S_IDENTIFIER);
index.setUsing(using.image);
      break;
      }
    default:
      jj_la1[352] = jj_gen;
      ;
    }
    colNames = ColumnNamesWithParamsList();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ASC:
    case K_BY:
    case K_CASCADE:
    case K_CHECK:
    case K_COLLATE:
    case K_COMMIT:
    case K_COMMENT:
    case K_CONSTRAINT:
    case K_DEFAULT:
    case K_DELETE:
    case K_DESC:
    case K_EXCLUDE:
    case K_FALSE:
    case K_FOREIGN:
    case K_IN:
    case K_KEY:
    case K_NOT:
    case K_NULL:
    case K_ON:
    case K_PARTITION:
    case K_PRIMARY:
    case K_REFERENCES:
    case K_ROWS:
    case K_TABLESPACE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIME_KEY_EXPR:
    case K_TRUE:
    case K_TYPE:
    case K_UNIQUE:
    case K_UPDATE:
    case K_USING:
    case K_UNSIGNED:
    case K_WHERE:
    case K_WITH:
    case S_DOUBLE:
    case S_LONG:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:
    case 266:
    case 268:
    case 274:
    case 286:
    case 302:{
      tailParameter = CreateParameter();

      break;
      }
    default:
      jj_la1[353] = jj_gen;
      ;
    }
index.setColumns(colNames);
        createIndex.setIndex(index);
        createIndex.setTable(table);
        createIndex.setTailParameters(tailParameter);
        return createIndex;
}

  final public ColumnDefinition ColumnDefinition() throws ParseException {ColumnDefinition coldef;
    String columnName;
    ColDataType colDataType;
    List<String> columnSpecs = new ArrayList<String>();
    List<String> parameter;
    columnName = RelObjectName();
    colDataType = ColDataType();
    label_77:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ASC:
      case K_BY:
      case K_CASCADE:
      case K_CHECK:
      case K_COLLATE:
      case K_COMMIT:
      case K_COMMENT:
      case K_CONSTRAINT:
      case K_DEFAULT:
      case K_DELETE:
      case K_DESC:
      case K_EXCLUDE:
      case K_FALSE:
      case K_FOREIGN:
      case K_IN:
      case K_KEY:
      case K_NOT:
      case K_NULL:
      case K_ON:
      case K_PARTITION:
      case K_PRIMARY:
      case K_REFERENCES:
      case K_ROWS:
      case K_TABLESPACE:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_TRUE:
      case K_TYPE:
      case K_UNIQUE:
      case K_UPDATE:
      case K_USING:
      case K_UNSIGNED:
      case K_WHERE:
      case K_WITH:
      case S_DOUBLE:
      case S_LONG:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:
      case 266:
      case 268:
      case 274:
      case 286:
      case 302:{
        ;
        break;
        }
      default:
        jj_la1[354] = jj_gen;
        break label_77;
      }
      parameter = CreateParameter();
columnSpecs.addAll(parameter);
    }
coldef = new ColumnDefinition();
        coldef.setColumnName(columnName);
        coldef.setColDataType(colDataType);
        if (columnSpecs.size() > 0)
            coldef.setColumnSpecs(columnSpecs);
        return coldef;
}

  final public CreateSchema CreateSchema() throws ParseException {Token tk = null;
    CreateTable table = null;
    CreateView view = null;
    CreateSchema schema = new CreateSchema();
    //schema.setSchemaName(System.getProperty("user.name"));
    //schema.setAuthorization(System.getProperty("user.name"));
    List<String> schemaPath = null;
    List<Statement> statements = new ArrayList<Statement>();
    jj_consume_token(K_CREATE);
    jj_consume_token(K_SCHEMA);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        tk = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case S_QUOTED_IDENTIFIER:{
        tk = jj_consume_token(S_QUOTED_IDENTIFIER);
        break;
        }
      default:
        jj_la1[355] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
schema.setSchemaName(tk.image);
      break;
      }
    default:
      jj_la1[356] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_AUTHORIZATION:{
      jj_consume_token(K_AUTHORIZATION);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        tk = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case S_QUOTED_IDENTIFIER:{
        tk = jj_consume_token(S_QUOTED_IDENTIFIER);
        break;
        }
      default:
        jj_la1[357] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
schema.setAuthorization(tk.image);
      break;
      }
    default:
      jj_la1[358] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_PATH:{
      schemaPath = PathSpecification();
schema.setSchemaPath(schemaPath);
      break;
      }
    default:
      jj_la1[359] = jj_gen;
      ;
    }
    label_78:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_CREATE:{
        ;
        break;
        }
      default:
        jj_la1[360] = jj_gen;
        break label_78;
      }
      if (jj_2_126(3)) {
        table = CreateTable();
table.getTable().setSchemaName(schema.getSchemaName());
            schema.addStatement(table);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_CREATE:{
          view = CreateView();
view.getView().setSchemaName(schema.getSchemaName());
            schema.addStatement(view);
          break;
          }
        default:
          jj_la1[361] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
return schema;
}

  final public List<String> PathSpecification() throws ParseException {Token tk;
    List<String> pathList = new ArrayList<String>();
    jj_consume_token(K_PATH);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_IDENTIFIER:{
      tk = jj_consume_token(S_IDENTIFIER);
      break;
      }
    case S_QUOTED_IDENTIFIER:{
      tk = jj_consume_token(S_QUOTED_IDENTIFIER);
      break;
      }
    default:
      jj_la1[362] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
pathList.add(tk.image);
    label_79:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[363] = jj_gen;
        break label_79;
      }
      jj_consume_token(K_COMMA);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        tk = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case S_QUOTED_IDENTIFIER:{
        tk = jj_consume_token(S_QUOTED_IDENTIFIER);
        break;
        }
      default:
        jj_la1[364] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
pathList.add(tk.image);
    }
return pathList;
}

  final public CreateTable CreateTable() throws ParseException {CreateTable createTable = new CreateTable();
    Table table = null;
    List<ColumnDefinition> columnDefinitions = new ArrayList<ColumnDefinition>();
    List<String> columnSpecs = null;
    List<String> tableOptions = new ArrayList<String>();
    List<String> createOptions = new ArrayList<String>();
    String columnName;
    Token tk = null;
    Token tk2 = null;
    Token tk3 = null;
    String sk3 = null;
    ColDataType colDataType = null;
    String stringList = null;
    ColumnDefinition coldef = null;
    List<Index> indexes = new ArrayList<Index>();
    List<Index.ColumnParams> colNames = null;
    List<String> colNames2 = null;
    Index index = null;
    ForeignKeyIndex fkIndex = null;
    List<String> parameter = new ArrayList<String>();
    List<String> idxSpec = new ArrayList<String>();
    Table fkTable = null;
    Select select = null;
    Table likeTable = null;
    CheckConstraint checkCs = null;
    ExcludeConstraint excludeC = null;
    RowMovement rowMovement = null;
    ReferentialAction.Action action = null;
    jj_consume_token(K_CREATE);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_UNLOGGED:{
      jj_consume_token(K_UNLOGGED);
createTable.setUnlogged(true);
      break;
      }
    default:
      jj_la1[365] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_GLOBAL:{
      tk = jj_consume_token(K_GLOBAL);
createOptions.add(tk.image);
      break;
      }
    default:
      jj_la1[366] = jj_gen;
      ;
    }
    label_80:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ASC:
      case K_BY:
      case K_CASCADE:
      case K_CHECK:
      case K_COLLATE:
      case K_COMMIT:
      case K_COMMENT:
      case K_CONSTRAINT:
      case K_DEFAULT:
      case K_DELETE:
      case K_DESC:
      case K_EXCLUDE:
      case K_FALSE:
      case K_FOREIGN:
      case K_IN:
      case K_KEY:
      case K_NOT:
      case K_NULL:
      case K_ON:
      case K_PARTITION:
      case K_PRIMARY:
      case K_REFERENCES:
      case K_ROWS:
      case K_TABLESPACE:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_TRUE:
      case K_TYPE:
      case K_UNIQUE:
      case K_UPDATE:
      case K_USING:
      case K_UNSIGNED:
      case K_WHERE:
      case K_WITH:
      case S_DOUBLE:
      case S_LONG:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:
      case 266:
      case 268:
      case 274:
      case 286:
      case 302:{
        ;
        break;
        }
      default:
        jj_la1[367] = jj_gen;
        break label_80;
      }
      parameter = CreateParameter();
createOptions.addAll(parameter);
    }
    jj_consume_token(K_TABLE);
    if (jj_2_127(2)) {
      jj_consume_token(K_IF);
      jj_consume_token(K_NOT);
      jj_consume_token(K_EXISTS);
createTable.setIfNotExists(true);
    } else {
      ;
    }
    table = Table();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 266:{
      jj_consume_token(266);
      coldef = ColumnDefinition();
columnDefinitions.add(coldef);
      label_81:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[368] = jj_gen;
          break label_81;
        }
        jj_consume_token(K_COMMA);
        if (jj_2_130(3)) {
          tk = jj_consume_token(K_INDEX);
          sk3 = RelObjectName();
          /* colNames=ColumnsNamesList() */
                                  colNames = ColumnNamesWithParamsList();
index = new Index().withType(tk.image).withName(sk3).withColumns(colNames);
                            indexes.add(index);
        } else if (jj_2_131(3)) {
index = new NamedConstraint();
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_CONSTRAINT:{
            jj_consume_token(K_CONSTRAINT);
            sk3 = RelObjectName();
index.setName(sk3);
            break;
            }
          default:
            jj_la1[369] = jj_gen;
            ;
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_PRIMARY:{
            tk = jj_consume_token(K_PRIMARY);
            tk2 = jj_consume_token(K_KEY);
index.setType(tk.image + " " + tk2.image);
            break;
            }
          case K_UNIQUE:{
            tk = jj_consume_token(K_UNIQUE);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_KEY:{
              tk2 = jj_consume_token(K_KEY);
              break;
              }
            default:
              jj_la1[370] = jj_gen;
              ;
            }
index.setType(tk.image + (tk2!=null?" " + tk2.image:""));
            break;
            }
          default:
            jj_la1[371] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          /* colNames=ColumnsNamesList() */
                                  colNames = ColumnNamesWithParamsList();
          label_82:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_ASC:
            case K_BY:
            case K_CASCADE:
            case K_CHECK:
            case K_COLLATE:
            case K_COMMIT:
            case K_COMMENT:
            case K_CONSTRAINT:
            case K_DEFAULT:
            case K_DELETE:
            case K_DESC:
            case K_EXCLUDE:
            case K_FALSE:
            case K_FOREIGN:
            case K_IN:
            case K_KEY:
            case K_NOT:
            case K_NULL:
            case K_ON:
            case K_PARTITION:
            case K_PRIMARY:
            case K_REFERENCES:
            case K_ROWS:
            case K_TABLESPACE:
            case K_TEMP:
            case K_TEMPORARY:
            case K_TIME_KEY_EXPR:
            case K_TRUE:
            case K_TYPE:
            case K_UNIQUE:
            case K_UPDATE:
            case K_USING:
            case K_UNSIGNED:
            case K_WHERE:
            case K_WITH:
            case S_DOUBLE:
            case S_LONG:
            case S_IDENTIFIER:
            case S_CHAR_LITERAL:
            case S_QUOTED_IDENTIFIER:
            case 266:
            case 268:
            case 274:
            case 286:
            case 302:{
              ;
              break;
              }
            default:
              jj_la1[372] = jj_gen;
              break label_82;
            }
            parameter = CreateParameter();
idxSpec.addAll(parameter);
          }
index.withColumns(colNames).withIndexSpec(idxSpec);
                            indexes.add(index);
        } else if (jj_2_132(3)) {
tk=null;
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_UNIQUE:{
            tk = jj_consume_token(K_UNIQUE);
            break;
            }
          default:
            jj_la1[373] = jj_gen;
            ;
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_FULLTEXT:{
            tk3 = jj_consume_token(K_FULLTEXT);
            break;
            }
          default:
            jj_la1[374] = jj_gen;
            ;
          }
          tk2 = jj_consume_token(K_KEY);
          sk3 = RelObjectName();
          /* colNames=ColumnsNamesList() */
                                  colNames = ColumnNamesWithParamsList();
          label_83:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_ASC:
            case K_BY:
            case K_CASCADE:
            case K_CHECK:
            case K_COLLATE:
            case K_COMMIT:
            case K_COMMENT:
            case K_CONSTRAINT:
            case K_DEFAULT:
            case K_DELETE:
            case K_DESC:
            case K_EXCLUDE:
            case K_FALSE:
            case K_FOREIGN:
            case K_IN:
            case K_KEY:
            case K_NOT:
            case K_NULL:
            case K_ON:
            case K_PARTITION:
            case K_PRIMARY:
            case K_REFERENCES:
            case K_ROWS:
            case K_TABLESPACE:
            case K_TEMP:
            case K_TEMPORARY:
            case K_TIME_KEY_EXPR:
            case K_TRUE:
            case K_TYPE:
            case K_UNIQUE:
            case K_UPDATE:
            case K_USING:
            case K_UNSIGNED:
            case K_WHERE:
            case K_WITH:
            case S_DOUBLE:
            case S_LONG:
            case S_IDENTIFIER:
            case S_CHAR_LITERAL:
            case S_QUOTED_IDENTIFIER:
            case 266:
            case 268:
            case 274:
            case 286:
            case 302:{
              ;
              break;
              }
            default:
              jj_la1[375] = jj_gen;
              break label_83;
            }
            parameter = CreateParameter();
idxSpec.addAll(parameter);
          }
index = new Index()
                            .withType((tk!=null?tk.image + " ":"") + (tk3!=null?tk3.image + " ":"") + tk2.image)
                            .withName(sk3)
                            .withColumns(colNames)
                            .withIndexSpec(idxSpec);
                            indexes.add(index);
        } else if (jj_2_133(3)) {
fkIndex = new ForeignKeyIndex();
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_CONSTRAINT:{
            jj_consume_token(K_CONSTRAINT);
            sk3 = RelObjectName();
fkIndex.setName(sk3);
            break;
            }
          default:
            jj_la1[376] = jj_gen;
            ;
          }
          tk = jj_consume_token(K_FOREIGN);
          tk2 = jj_consume_token(K_KEY);
          /* colNames=ColumnsNamesList() */
                                  colNames = ColumnNamesWithParamsList();
fkIndex.withType(tk.image + " " + tk2.image).withColumns(colNames);
          jj_consume_token(K_REFERENCES);
          fkTable = Table();
          colNames2 = ColumnsNamesList();
fkIndex.setTable(fkTable);
                            fkIndex.setReferencedColumnNames(colNames2);
                            indexes.add(fkIndex);
          if (jj_2_128(2)) {
            jj_consume_token(K_ON);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_DELETE:{
              tk = jj_consume_token(K_DELETE);
              break;
              }
            case K_UPDATE:{
              tk = jj_consume_token(K_UPDATE);
              break;
              }
            default:
              jj_la1[377] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            action = Action();
fkIndex.setReferentialAction(ReferentialAction.Type.valueOf(tk.image), action);
          } else {
            ;
          }
          if (jj_2_129(2)) {
            jj_consume_token(K_ON);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_DELETE:{
              tk = jj_consume_token(K_DELETE);
              break;
              }
            case K_UPDATE:{
              tk = jj_consume_token(K_UPDATE);
              break;
              }
            default:
              jj_la1[378] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            action = Action();
fkIndex.setReferentialAction(ReferentialAction.Type.valueOf(tk.image), action);
          } else {
            ;
          }
        } else if (jj_2_134(3)) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_CONSTRAINT:{
            jj_consume_token(K_CONSTRAINT);
            sk3 = RelObjectName();
            break;
            }
          default:
            jj_la1[379] = jj_gen;
            ;
          }
Expression exp = null;
          jj_consume_token(K_CHECK);
          label_84:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case 266:{
              ;
              break;
              }
            default:
              jj_la1[380] = jj_gen;
              break label_84;
            }
            jj_consume_token(266);
            exp = Expression();
            jj_consume_token(267);
          }
checkCs = new CheckConstraint().withName(sk3).withExpression(exp);
                       indexes.add(checkCs);
        } else if (jj_2_135(2)) {
          tk = jj_consume_token(K_EXCLUDE);
excludeC = new ExcludeConstraint(); Expression exp = null;
          tk2 = jj_consume_token(K_WHERE);
          label_85:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case 266:{
              ;
              break;
              }
            default:
              jj_la1[381] = jj_gen;
              break label_85;
            }
            jj_consume_token(266);
            exp = Expression();
            jj_consume_token(267);
          }
excludeC.setExpression(exp);
indexes.add(excludeC);
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ACTION:
          case K_ANY:
          case K_BYTE:
          case K_CASCADE:
          case K_CAST:
          case K_CHARACTER:
          case K_CHANGE:
          case K_CHAR:
          case K_COLUMN:
          case K_COLUMNS:
          case K_COMMIT:
          case K_COMMENT:
          case K_CREATE:
          case K_CYCLE:
          case K_DATETIMELITERAL:
          case K_DATE_LITERAL:
          case K_DESC:
          case K_DESCRIBE:
          case K_DISABLE:
          case K_DIV:
          case K_DO:
          case K_DUPLICATE:
          case K_ENABLE:
          case K_END:
          case K_EXCLUDE:
          case K_EXTRACT:
          case K_FIRST:
          case K_FALSE:
          case K_FOLLOWING:
          case K_FORMAT:
          case K_GROUP:
          case K_INDEX:
          case K_INSERT:
          case K_INTERVAL:
          case K_ISNULL:
          case K_KEY:
          case K_FN:
          case K_LAST:
          case K_MATERIALIZED:
          case K_NEXTVAL:
          case K_NO:
          case K_NOLOCK:
          case K_NULLS:
          case K_OF:
          case K_ON:
          case K_OPEN:
          case K_ORDER:
          case K_OVER:
          case K_PARTITION:
          case K_PATH:
          case K_PERCENT:
          case K_PRECISION:
          case K_PRIMARY:
          case K_PRIOR:
          case K_RANGE:
          case K_READ:
          case K_REPLACE:
          case K_ROW:
          case K_ROWS:
          case K_SCHEMA:
          case K_SEQUENCE:
          case K_SEPARATOR:
          case K_SESSION:
          case K_SIBLINGS:
          case K_SIZE:
          case K_START:
          case K_TABLE:
          case K_TABLES:
          case K_TEMP:
          case K_TEMPORARY:
          case K_TO:
          case K_TOP:
          case K_TRUNCATE:
          case K_TRUE:
          case K_TYPE:
          case K_UNSIGNED:
          case K_VALIDATE:
          case K_VALUE:
          case K_VALUES:
          case K_VIEW:
          case K_XML:
          case K_ZONE:
          case S_IDENTIFIER:
          case S_QUOTED_IDENTIFIER:{
            coldef = ColumnDefinition();
columnDefinitions.add(coldef);
            break;
            }
          default:
            jj_la1[382] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
      jj_consume_token(267);
      label_86:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ASC:
        case K_BY:
        case K_CASCADE:
        case K_CHECK:
        case K_COLLATE:
        case K_COMMIT:
        case K_COMMENT:
        case K_CONSTRAINT:
        case K_DEFAULT:
        case K_DELETE:
        case K_DESC:
        case K_EXCLUDE:
        case K_FALSE:
        case K_FOREIGN:
        case K_IN:
        case K_KEY:
        case K_NOT:
        case K_NULL:
        case K_ON:
        case K_PARTITION:
        case K_PRIMARY:
        case K_REFERENCES:
        case K_ROWS:
        case K_TABLESPACE:
        case K_TEMP:
        case K_TEMPORARY:
        case K_TIME_KEY_EXPR:
        case K_TRUE:
        case K_TYPE:
        case K_UNIQUE:
        case K_UPDATE:
        case K_USING:
        case K_UNSIGNED:
        case K_WHERE:
        case K_WITH:
        case S_DOUBLE:
        case S_LONG:
        case S_IDENTIFIER:
        case S_CHAR_LITERAL:
        case S_QUOTED_IDENTIFIER:
        case 266:
        case 268:
        case 274:
        case 286:
        case 302:{
          ;
          break;
          }
        default:
          jj_la1[383] = jj_gen;
          break label_86;
        }
        parameter = CreateParameter();
tableOptions.addAll(parameter);
      }
      break;
      }
    default:
      jj_la1[384] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_DISABLE:
    case K_ENABLE:{
      rowMovement = RowMovement();
createTable.setRowMovement(rowMovement);
      break;
      }
    default:
      jj_la1[385] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_AS:{
      jj_consume_token(K_AS);
      if (jj_2_136(2147483647)) {
        jj_consume_token(266);
        select = Select();
createTable.setSelect(select, true);
        jj_consume_token(267);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_SELECT:
        case K_VALUES:
        case K_WITH:
        case 266:{
          select = Select();
createTable.setSelect(select, false);
          break;
          }
        default:
          jj_la1[386] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[387] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_LIKE:{
      jj_consume_token(K_LIKE);
      if (jj_2_137(2147483647)) {
        jj_consume_token(266);
        likeTable = Table();
createTable.setLikeTable(likeTable, true);
        jj_consume_token(267);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ACTION:
        case K_ANY:
        case K_BYTE:
        case K_CASCADE:
        case K_CAST:
        case K_CHARACTER:
        case K_CHANGE:
        case K_CHAR:
        case K_COLUMN:
        case K_COLUMNS:
        case K_COMMIT:
        case K_COMMENT:
        case K_CREATE:
        case K_CYCLE:
        case K_DATETIMELITERAL:
        case K_DATE_LITERAL:
        case K_DESC:
        case K_DESCRIBE:
        case K_DISABLE:
        case K_DIV:
        case K_DO:
        case K_DOUBLE:
        case K_DUPLICATE:
        case K_ENABLE:
        case K_END:
        case K_EXCLUDE:
        case K_EXTRACT:
        case K_FIRST:
        case K_FALSE:
        case K_FOLLOWING:
        case K_FORMAT:
        case K_GROUP:
        case K_IF:
        case K_INDEX:
        case K_INSERT:
        case K_INTERVAL:
        case K_ISNULL:
        case K_KEY:
        case K_FN:
        case K_LAST:
        case K_LEFT:
        case K_LIMIT:
        case K_MATERIALIZED:
        case K_NEXTVAL:
        case K_NO:
        case K_NOLOCK:
        case K_NULLS:
        case K_OF:
        case K_OFFSET:
        case K_ON:
        case K_OPEN:
        case K_ORDER:
        case K_OVER:
        case K_OPTIMIZE:
        case K_PARTITION:
        case K_PATH:
        case K_PERCENT:
        case K_PRECISION:
        case K_PRIMARY:
        case K_PRIOR:
        case K_PROCEDURE:
        case K_PUBLIC:
        case K_RANGE:
        case K_READ:
        case K_REPLACE:
        case K_RIGHT:
        case K_ROW:
        case K_ROWS:
        case K_SCHEMA:
        case K_SEQUENCE:
        case K_SEPARATOR:
        case K_SESSION:
        case K_SET:
        case K_SIBLINGS:
        case K_SIZE:
        case K_START:
        case K_TABLE:
        case K_TABLES:
        case K_TEMP:
        case K_TEMPORARY:
        case K_TO:
        case K_TOP:
        case K_TRUNCATE:
        case K_TRUE:
        case K_TYPE:
        case K_UNSIGNED:
        case K_VALIDATE:
        case K_VALUE:
        case K_VALUES:
        case K_VIEW:
        case K_XML:
        case K_ZONE:
        case S_IDENTIFIER:
        case S_QUOTED_IDENTIFIER:{
          likeTable = Table();
createTable.setLikeTable(likeTable, false);
          break;
          }
        default:
          jj_la1[388] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[389] = jj_gen;
      ;
    }
createTable.setTable(table);
        if (indexes.size() > 0)
            createTable.setIndexes(indexes);
        if (createOptions.size() > 0)
            createTable.setCreateOptionsStrings(createOptions);
        if (tableOptions.size() > 0)
            createTable.setTableOptionsStrings(tableOptions);
        if (columnDefinitions.size() > 0)
            createTable.setColumnDefinitions(columnDefinitions);
        return createTable;
}

  final public ColDataType ColDataType() throws ParseException {ColDataType colDataType = new ColDataType();
    Token tk = null;
    Token tk2 = null;
    List<String> argumentsStringList = new ArrayList<String>();
    List<Integer> array = new ArrayList<Integer>();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_BIT:
    case K_CHARACTER:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_CHARACTER:{
        tk = jj_consume_token(K_CHARACTER);
        break;
        }
      case K_BIT:{
        tk = jj_consume_token(K_BIT);
        break;
        }
      default:
        jj_la1[390] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_VARYING:{
        tk2 = jj_consume_token(K_VARYING);
        break;
        }
      default:
        jj_la1[391] = jj_gen;
        ;
      }
colDataType.setDataType(tk.image + (tk2!=null?" " + tk2.image:""));
      break;
      }
    case K_DOUBLE:{
      tk = jj_consume_token(K_DOUBLE);
      if (jj_2_138(2)) {
        tk2 = jj_consume_token(K_PRECISION);
      } else {
        ;
      }
colDataType.setDataType(tk.image + (tk2!=null?" " + tk2.image:""));
      break;
      }
    case K_BINARY:
    case K_CHAR:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_INTERVAL:
    case K_JSON:
    case K_SET:
    case K_XML:
    case DT_ZONE:
    case S_IDENTIFIER:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        tk = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case K_DATETIMELITERAL:{
        tk = jj_consume_token(K_DATETIMELITERAL);
        break;
        }
      case K_DATE_LITERAL:{
        tk = jj_consume_token(K_DATE_LITERAL);
        break;
        }
      case K_XML:{
        tk = jj_consume_token(K_XML);
        break;
        }
      case K_INTERVAL:{
        tk = jj_consume_token(K_INTERVAL);
        break;
        }
      case DT_ZONE:{
        tk = jj_consume_token(DT_ZONE);
        break;
        }
      case K_CHAR:{
        tk = jj_consume_token(K_CHAR);
        break;
        }
      case K_SET:{
        tk = jj_consume_token(K_SET);
        break;
        }
      case K_BINARY:{
        tk = jj_consume_token(K_BINARY);
        break;
        }
      case K_JSON:{
        tk = jj_consume_token(K_JSON);
        break;
        }
      default:
        jj_la1[392] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
colDataType.setDataType(tk.image);
      break;
      }
    case K_UNSIGNED:{
      tk = jj_consume_token(K_UNSIGNED);
      if (jj_2_139(2)) {
        tk2 = jj_consume_token(S_IDENTIFIER);
      } else {
        ;
      }
if (tk2!=null) colDataType.setDataType(tk.image + " " + tk2.image); else colDataType.setDataType(tk.image);
      break;
      }
    default:
      jj_la1[393] = jj_gen;
      if (jj_2_140(2)) {
        tk = jj_consume_token(K_SIGNED);
        tk2 = jj_consume_token(S_IDENTIFIER);
colDataType.setDataType(tk.image + " " + tk2.image);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_SIGNED:{
          tk = jj_consume_token(K_SIGNED);
colDataType.setDataType(tk.image);
          break;
          }
        default:
          jj_la1[394] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    if (jj_2_141(2)) {
      jj_consume_token(266);
tk2 =null;
      label_87:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_LONG:
        case S_IDENTIFIER:
        case S_CHAR_LITERAL:{
          ;
          break;
          }
        default:
          jj_la1[395] = jj_gen;
          break label_87;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_LONG:{
          tk = jj_consume_token(S_LONG);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_BYTE:
          case K_CHAR:{
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_BYTE:{
              tk2 = jj_consume_token(K_BYTE);
              break;
              }
            case K_CHAR:{
              tk2 = jj_consume_token(K_CHAR);
              break;
              }
            default:
              jj_la1[396] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            break;
            }
          default:
            jj_la1[397] = jj_gen;
            ;
          }
          break;
          }
        case S_CHAR_LITERAL:{
          tk = jj_consume_token(S_CHAR_LITERAL);
          break;
          }
        case S_IDENTIFIER:{
          tk = jj_consume_token(S_IDENTIFIER);
          break;
          }
        default:
          jj_la1[398] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
argumentsStringList.add(tk.image + (tk2!=null?" " + tk2.image:""));
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          jj_consume_token(K_COMMA);

          break;
          }
        default:
          jj_la1[399] = jj_gen;
          ;
        }
      }
      jj_consume_token(267);
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 300:{
      label_88:
      while (true) {
        jj_consume_token(300);
tk=null;
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_LONG:{
          tk = jj_consume_token(S_LONG);
          break;
          }
        default:
          jj_la1[400] = jj_gen;
          ;
        }
array.add(tk!=null?Integer.valueOf(tk.image):null);
        jj_consume_token(301);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 300:{
          ;
          break;
          }
        default:
          jj_la1[401] = jj_gen;
          break label_88;
        }
      }
colDataType.setArrayData(array);
      break;
      }
    default:
      jj_la1[402] = jj_gen;
      ;
    }
    if (jj_2_142(2)) {
      jj_consume_token(K_CHARACTER);
      jj_consume_token(K_SET);
      tk = jj_consume_token(S_IDENTIFIER);
colDataType.setCharacterSet(tk.image);
    } else {
      ;
    }
if (argumentsStringList.size() > 0)
            colDataType.setArgumentsStringList(argumentsStringList);
        return colDataType;
}

  final public CreateView CreateView() throws ParseException {CreateView createView = new CreateView();
    Table view = null;
    Select select = null;
    List<String> columnNames = null;
    jj_consume_token(K_CREATE);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_OR:{
      jj_consume_token(K_OR);
      jj_consume_token(K_REPLACE);
createView.setOrReplace(true);
      break;
      }
    default:
      jj_la1[403] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FORCE:
    case K_NO:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NO:{
        jj_consume_token(K_NO);
        jj_consume_token(K_FORCE);
createView.setForce(ForceOption.NO_FORCE);
        break;
        }
      case K_FORCE:{
        jj_consume_token(K_FORCE);
createView.setForce(ForceOption.FORCE);
        break;
        }
      default:
        jj_la1[404] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[405] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_TEMP:
    case K_TEMPORARY:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_TEMP:{
        jj_consume_token(K_TEMP);
createView.setTemporary(TemporaryOption.TEMP);
        break;
        }
      case K_TEMPORARY:{
        jj_consume_token(K_TEMPORARY);
createView.setTemporary(TemporaryOption.TEMPORARY);
        break;
        }
      default:
        jj_la1[406] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[407] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_MATERIALIZED:{
      jj_consume_token(K_MATERIALIZED);
createView.setMaterialized(true);
      break;
      }
    default:
      jj_la1[408] = jj_gen;
      ;
    }
    jj_consume_token(K_VIEW);
    view = Table();
createView.setView(view);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 266:{
      columnNames = ColumnsNamesList();
createView.setColumnNames(columnNames);
      break;
      }
    default:
      jj_la1[409] = jj_gen;
      ;
    }
    jj_consume_token(K_AS);
    select = Select();
createView.setSelect(select);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_WITH:{
      jj_consume_token(K_WITH);
      jj_consume_token(K_READ);
      jj_consume_token(K_ONLY);
createView.setWithReadOnly(true);
      break;
      }
    default:
      jj_la1[410] = jj_gen;
      ;
    }
return createView;
}

  final public ReferentialAction.Action Action() throws ParseException {ReferentialAction.Action action = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_CASCADE:{
      jj_consume_token(K_CASCADE);
action=ReferentialAction.Action.CASCADE;
      break;
      }
    case K_RESTRICT:{
      jj_consume_token(K_RESTRICT);
action=ReferentialAction.Action.RESTRICT;
      break;
      }
    case K_NO:{
      jj_consume_token(K_NO);
      jj_consume_token(K_ACTION);
action=ReferentialAction.Action.NO_ACTION;
      break;
      }
    case K_SET:{
      jj_consume_token(K_SET);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NULL:{
        jj_consume_token(K_NULL);
action=ReferentialAction.Action.SET_NULL;
        break;
        }
      case K_DEFAULT:{
        jj_consume_token(K_DEFAULT);
action=ReferentialAction.Action.SET_DEFAULT;
        break;
        }
      default:
        jj_la1[411] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[412] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return action;
}

  final public AlterView AlterView() throws ParseException {AlterView alterView = new AlterView();
    Table view = null;
    SelectBody select = null;
    List<String> columnNames = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ALTER:{
      jj_consume_token(K_ALTER);
      break;
      }
    case K_REPLACE:{
      jj_consume_token(K_REPLACE);
alterView.setUseReplace(true);
      break;
      }
    default:
      jj_la1[413] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(K_VIEW);
    view = Table();
alterView.setView(view);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 266:{
      columnNames = ColumnsNamesList();
alterView.setColumnNames(columnNames);
      break;
      }
    default:
      jj_la1[414] = jj_gen;
      ;
    }
    jj_consume_token(K_AS);
    select = SelectBody();
alterView.setSelectBody(select);
return alterView;
}

  final public List<String> CreateParameter() throws ParseException {String retval = "";
    Token tk = null;
    Token tk2 = null;
    StringBuilder identifier = new StringBuilder("");
    Expression exp = null;
    List<String> param = new ArrayList<String>();
    ColDataType colDataType;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        tk = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case S_QUOTED_IDENTIFIER:{
        tk = jj_consume_token(S_QUOTED_IDENTIFIER);
        break;
        }
      default:
        jj_la1[415] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
identifier.append(tk.image);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 270:{
        jj_consume_token(270);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_IDENTIFIER:{
          tk2 = jj_consume_token(S_IDENTIFIER);
          break;
          }
        case S_QUOTED_IDENTIFIER:{
          tk2 = jj_consume_token(S_QUOTED_IDENTIFIER);
          break;
          }
        default:
          jj_la1[416] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
identifier.append("."); identifier.append(tk2.image);
        break;
        }
      default:
        jj_la1[417] = jj_gen;
        ;
      }
param.add(identifier.toString());
      break;
      }
    case K_NULL:{
      tk = jj_consume_token(K_NULL);
param.add(tk.image);
      break;
      }
    case K_NOT:{
      tk = jj_consume_token(K_NOT);
param.add(tk.image);
      break;
      }
    case K_PRIMARY:{
      tk = jj_consume_token(K_PRIMARY);
param.add(tk.image);
      break;
      }
    case K_DEFAULT:{
      tk = jj_consume_token(K_DEFAULT);
param.add(tk.image);
      break;
      }
    case K_FOREIGN:{
      tk = jj_consume_token(K_FOREIGN);
param.add(tk.image);
      break;
      }
    case K_REFERENCES:{
      tk = jj_consume_token(K_REFERENCES);
param.add(tk.image);
      break;
      }
    case K_KEY:{
      tk = jj_consume_token(K_KEY);
param.add(tk.image);
      break;
      }
    case S_CHAR_LITERAL:{
      tk = jj_consume_token(S_CHAR_LITERAL);
param.add(tk.image);
      break;
      }
    case S_DOUBLE:
    case S_LONG:
    case 274:
    case 286:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 274:
      case 286:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 274:{
          jj_consume_token(274);
retval = "+";
          break;
          }
        case 286:{
          jj_consume_token(286);
retval = "-";
          break;
          }
        default:
          jj_la1[418] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[419] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_LONG:{
        tk = jj_consume_token(S_LONG);
retval += tk.image;
        break;
        }
      case S_DOUBLE:{
        tk = jj_consume_token(S_DOUBLE);
retval += tk.image;
        break;
        }
      default:
        jj_la1[420] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
param.add(retval);
      break;
      }
    case K_ON:{
      tk = jj_consume_token(K_ON);
param.add(tk.image);
      break;
      }
    case K_COMMIT:{
      tk = jj_consume_token(K_COMMIT);
param.add(tk.image);
      break;
      }
    case K_ROWS:{
      tk = jj_consume_token(K_ROWS);
param.add(tk.image);
      break;
      }
    case K_UNIQUE:{
      tk = jj_consume_token(K_UNIQUE);
param.add(tk.image);
      break;
      }
    case K_CASCADE:{
      tk = jj_consume_token(K_CASCADE);
param.add(tk.image);
      break;
      }
    case K_DELETE:{
      tk = jj_consume_token(K_DELETE);
param.add(tk.image);
      break;
      }
    case K_UPDATE:{
      tk = jj_consume_token(K_UPDATE);
param.add(tk.image);
      break;
      }
    case K_TIME_KEY_EXPR:{
      tk = jj_consume_token(K_TIME_KEY_EXPR);
param.add(new TimeKeyExpression(tk.image).toString());
      break;
      }
    case 268:{
      jj_consume_token(268);
param.add("=");
      break;
      }
    default:
      jj_la1[421] = jj_gen;
      if (jj_2_143(3)) {
        jj_consume_token(K_USING);
        jj_consume_token(K_INDEX);
        jj_consume_token(K_TABLESPACE);
        retval = RelObjectName();
param.add("USING"); param.add("INDEX"); param.add("TABLESPACE"); param.add(retval);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_TABLESPACE:{
          jj_consume_token(K_TABLESPACE);
          retval = RelObjectName();
param.add("TABLESPACE"); param.add(retval);
          break;
          }
        case 266:{
          retval = AList();
param.add(retval);
          break;
          }
        case K_CHECK:{
          jj_consume_token(K_CHECK);
          jj_consume_token(266);
          exp = Expression();
          jj_consume_token(267);
param.add("CHECK"); param.add("(" + exp.toString() + ")");
          break;
          }
        case K_CONSTRAINT:{
          tk = jj_consume_token(K_CONSTRAINT);
param.add(tk.image);
          break;
          }
        case K_WITH:{
          tk = jj_consume_token(K_WITH);
param.add(tk.image);
          break;
          }
        case K_EXCLUDE:{
          tk = jj_consume_token(K_EXCLUDE);
param.add(tk.image);
          break;
          }
        case K_WHERE:{
          tk = jj_consume_token(K_WHERE);
param.add(tk.image);
          break;
          }
        case K_UNSIGNED:{
          tk = jj_consume_token(K_UNSIGNED);
param.add(tk.image);
          break;
          }
        case K_TEMP:{
          tk = jj_consume_token(K_TEMP);
param.add(tk.image);
          break;
          }
        case K_TEMPORARY:{
          tk = jj_consume_token(K_TEMPORARY);
param.add(tk.image);
          break;
          }
        case K_PARTITION:{
          tk = jj_consume_token(K_PARTITION);
param.add(tk.image);
          break;
          }
        case K_BY:{
          tk = jj_consume_token(K_BY);
param.add(tk.image);
          break;
          }
        case K_IN:{
          tk = jj_consume_token(K_IN);
param.add(tk.image);
          break;
          }
        case K_TYPE:{
          tk = jj_consume_token(K_TYPE);
param.add(tk.image);
          break;
          }
        case K_COMMENT:{
          tk = jj_consume_token(K_COMMENT);
param.add(tk.image);
          break;
          }
        case K_USING:{
          tk = jj_consume_token(K_USING);
param.add(tk.image);
          break;
          }
        case K_COLLATE:{
          tk = jj_consume_token(K_COLLATE);
param.add(tk.image);
          break;
          }
        case K_ASC:{
          tk = jj_consume_token(K_ASC);
param.add(tk.image);
          break;
          }
        case K_DESC:{
          tk = jj_consume_token(K_DESC);
param.add(tk.image);
          break;
          }
        case K_TRUE:{
          tk = jj_consume_token(K_TRUE);
param.add(tk.image);
          break;
          }
        case K_FALSE:{
          tk = jj_consume_token(K_FALSE);
param.add(tk.image);
          break;
          }
        case 302:{
          tk = jj_consume_token(302);
          colDataType = ColDataType();
param.add(tk.image); param.add(colDataType.toString());
          break;
          }
        default:
          jj_la1[422] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
return param;
}

// row_movement_clause https://docs.oracle.com/cd/B19306_01/server.102/b14200/statements_7002.htm#i2204697
  final public RowMovement RowMovement() throws ParseException {RowMovement rowMovement = new RowMovement();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ENABLE:{
      jj_consume_token(K_ENABLE);
      jj_consume_token(K_ROW);
      jj_consume_token(K_MOVEMENT);
rowMovement.setMode(RowMovementMode.ENABLE);
      break;
      }
    case K_DISABLE:{
      jj_consume_token(K_DISABLE);
      jj_consume_token(K_ROW);
      jj_consume_token(K_MOVEMENT);
rowMovement.setMode(RowMovementMode.DISABLE);
      break;
      }
    default:
      jj_la1[423] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return rowMovement;
}

  final public String AList() throws ParseException {StringBuilder retval = new StringBuilder("(");
    Token tk = null;
    Token tk2 = null;
    jj_consume_token(266);
    label_89:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_DOUBLE:
      case S_LONG:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:{
        ;
        break;
        }
      default:
        jj_la1[424] = jj_gen;
        break label_89;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_LONG:{
        tk = jj_consume_token(S_LONG);
        break;
        }
      case S_DOUBLE:{
        tk = jj_consume_token(S_DOUBLE);
        break;
        }
      case S_CHAR_LITERAL:{
        tk = jj_consume_token(S_CHAR_LITERAL);
        break;
        }
      case S_IDENTIFIER:{
        tk = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case S_QUOTED_IDENTIFIER:{
        tk = jj_consume_token(S_QUOTED_IDENTIFIER);
        break;
        }
      default:
        jj_la1[425] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
retval.append(tk.image);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:
      case 268:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          jj_consume_token(K_COMMA);
retval.append(",");
          break;
          }
        case 268:{
          jj_consume_token(268);
retval.append("=");
          break;
          }
        default:
          jj_la1[426] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[427] = jj_gen;
        ;
      }
    }
    jj_consume_token(267);
retval.append(")");
        return retval.toString();
}

  final public String ColumnsNamesListItem() throws ParseException {Token tk = null;
    String item = null;
    item = RelObjectName();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 266:{
      jj_consume_token(266);
      tk = jj_consume_token(S_LONG);
      jj_consume_token(267);
item = item + "(" + tk.image + ")";
      break;
      }
    default:
      jj_la1[428] = jj_gen;
      ;
    }
return item;
}

  final public List<String> ColumnsNamesList() throws ParseException {List<String> retval = new ArrayList<String>();
    String img = null;
    jj_consume_token(266);
    img = ColumnsNamesListItem();
retval.add(img);
    label_90:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[429] = jj_gen;
        break label_90;
      }
      jj_consume_token(K_COMMA);
      img = ColumnsNamesListItem();
retval.add(img);
    }
    jj_consume_token(267);
return retval;
}

  final public Drop Drop() throws ParseException {Drop drop = new Drop();
    Token tk = null;
    Table name;
    List<String> dropArgs = new ArrayList<String>();
    jj_consume_token(K_DROP);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_IDENTIFIER:{
      tk = jj_consume_token(S_IDENTIFIER);
      break;
      }
    case K_TABLE:{
      tk = jj_consume_token(K_TABLE);
      break;
      }
    case K_INDEX:{
      tk = jj_consume_token(K_INDEX);
      break;
      }
    case K_VIEW:{
      tk = jj_consume_token(K_VIEW);
      break;
      }
    case K_SCHEMA:{
      tk = jj_consume_token(K_SCHEMA);
      break;
      }
    case K_SEQUENCE:{
      tk = jj_consume_token(K_SEQUENCE);
      break;
      }
    default:
      jj_la1[430] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
drop.setType(tk.image);
    if (jj_2_144(2)) {
      jj_consume_token(K_IF);
      jj_consume_token(K_EXISTS);
drop.setIfExists(true);
    } else {
      ;
    }
    name = Table();
drop.setName(name);
    label_91:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_CASCADE:
      case K_RESTRICT:
      case S_IDENTIFIER:{
        ;
        break;
        }
      default:
        jj_la1[431] = jj_gen;
        break label_91;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        tk = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case K_CASCADE:{
        tk = jj_consume_token(K_CASCADE);
        break;
        }
      case K_RESTRICT:{
        tk = jj_consume_token(K_RESTRICT);
        break;
        }
      default:
        jj_la1[432] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
dropArgs.add(tk.image);
    }
if (dropArgs.size() > 0)
            drop.setParameters(dropArgs);
        return drop;
}

  final public Truncate Truncate() throws ParseException {Truncate truncate = new Truncate();
    Table table;
    jj_consume_token(K_TRUNCATE);
    jj_consume_token(K_TABLE);
    table = Table();
truncate.setTable(table); truncate.setCascade(false);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_CASCADE:{
      jj_consume_token(K_CASCADE);
truncate.setCascade(true);
      break;
      }
    default:
      jj_la1[433] = jj_gen;
      ;
    }
return truncate;
}

  final public AlterExpression.ColumnDataType AlterExpressionColumnDataType() throws ParseException {String columnName = null;
    boolean withType = false;
    ColDataType dataType = null;
    List<String> columnSpecs = null;
    List<String> parameter = null;
    columnName = RelObjectName();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_TYPE:{
      jj_consume_token(K_TYPE);
withType = true;
      break;
      }
    default:
      jj_la1[434] = jj_gen;
      ;
    }
    dataType = ColDataType();
columnSpecs = new ArrayList<String>();
    label_92:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ASC:
      case K_BY:
      case K_CASCADE:
      case K_CHECK:
      case K_COLLATE:
      case K_COMMIT:
      case K_COMMENT:
      case K_CONSTRAINT:
      case K_DEFAULT:
      case K_DELETE:
      case K_DESC:
      case K_EXCLUDE:
      case K_FALSE:
      case K_FOREIGN:
      case K_IN:
      case K_KEY:
      case K_NOT:
      case K_NULL:
      case K_ON:
      case K_PARTITION:
      case K_PRIMARY:
      case K_REFERENCES:
      case K_ROWS:
      case K_TABLESPACE:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_TRUE:
      case K_TYPE:
      case K_UNIQUE:
      case K_UPDATE:
      case K_USING:
      case K_UNSIGNED:
      case K_WHERE:
      case K_WITH:
      case S_DOUBLE:
      case S_LONG:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:
      case 266:
      case 268:
      case 274:
      case 286:
      case 302:{
        ;
        break;
        }
      default:
        jj_la1[435] = jj_gen;
        break label_92;
      }
      parameter = CreateParameter();
columnSpecs.addAll(parameter);
    }
return new AlterExpression.ColumnDataType(columnName, withType, dataType, columnSpecs);
}

  final public AlterExpression.ColumnDropNotNull AlterExpressionColumnDropNotNull() throws ParseException {String columnName = null;
    boolean withNot = false;
    ColDataType dataType = null;
    List<String> columnSpecs = null;
    List<String> parameter = null;
    columnName = RelObjectName();
    jj_consume_token(K_DROP);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_NOT:{
      jj_consume_token(K_NOT);
withNot = true;
      break;
      }
    default:
      jj_la1[436] = jj_gen;
      ;
    }
    jj_consume_token(K_NULL);
return new AlterExpression.ColumnDropNotNull(columnName, withNot);
}

  final public List<ConstraintState> AlterExpressionConstraintState() throws ParseException {List<ConstraintState> retval = new ArrayList<ConstraintState>();
    label_93:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_DEFERRABLE:
      case K_DISABLE:
      case K_ENABLE:
      case K_NOT:
      case K_NOVALIDATE:
      case K_VALIDATE:{
        ;
        break;
        }
      default:
        jj_la1[437] = jj_gen;
        break label_93;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_DEFERRABLE:{
        jj_consume_token(K_DEFERRABLE);
retval.add(new DeferrableConstraint(false));
        break;
        }
      case K_NOT:{
        jj_consume_token(K_NOT);
        jj_consume_token(K_DEFERRABLE);
retval.add(new DeferrableConstraint(true));
        break;
        }
      case K_VALIDATE:{
        jj_consume_token(K_VALIDATE);
retval.add(new ValidateConstraint(false));
        break;
        }
      case K_NOVALIDATE:{
        jj_consume_token(K_NOVALIDATE);
retval.add(new ValidateConstraint(true));
        break;
        }
      case K_ENABLE:{
        jj_consume_token(K_ENABLE);
retval.add(new EnableConstraint(false));
        break;
        }
      case K_DISABLE:{
        jj_consume_token(K_DISABLE);
retval.add(new EnableConstraint(true));
        break;
        }
      default:
        jj_la1[438] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return retval;
}

/**
* This production needs refactoring to multiple smaller productions. The target class should
* be splitted as well.
*/
  final public AlterExpression AlterExpression() throws ParseException {AlterExpression alterExp = new AlterExpression();
    Token tk;
    Token tk2 = null;
    String sk3 = null;
    String sk4 = null;
    ColDataType dataType;
    List<String> columnNames = null;
    List<ConstraintState> constraints = null;
    ForeignKeyIndex fkIndex = null;
    Index index = null;
    Table fkTable = null;
    AlterExpression.ColumnDataType alterExpressionColumnDataType = null;
    AlterExpression.ColumnDropNotNull alterExpressionColumnDropNotNull = null;
    ReferentialAction.Action action = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ADD:
    case K_ALTER:
    case K_MODIFY:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ADD:{
        jj_consume_token(K_ADD);
alterExp.setOperation(AlterOperation.ADD);
        break;
        }
      case K_ALTER:{
        jj_consume_token(K_ALTER);
alterExp.setOperation(AlterOperation.ALTER);
        break;
        }
      case K_MODIFY:{
        jj_consume_token(K_MODIFY);
alterExp.setOperation(AlterOperation.MODIFY);
        break;
        }
      default:
        jj_la1[439] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      if (jj_2_151(2)) {
        jj_consume_token(K_PRIMARY);
        jj_consume_token(K_KEY);
        columnNames = ColumnsNamesList();
alterExp.setPkColumns(columnNames);
        constraints = AlterExpressionConstraintState();
alterExp.setConstraints(constraints);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_USING:{
          jj_consume_token(K_USING);
          sk4 = RelObjectName();
alterExp.addParameters("USING", sk4);
          break;
          }
        default:
          jj_la1[440] = jj_gen;
          ;
        }
      } else if (jj_2_152(2)) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_KEY:{
          tk = jj_consume_token(K_KEY);
alterExp.setUk(true);
          break;
          }
        case K_INDEX:{
          tk = jj_consume_token(K_INDEX);
          break;
          }
        default:
          jj_la1[441] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        sk3 = RelObjectName();
        columnNames = ColumnsNamesList();
index = new Index().withType(tk.image).withName(sk3).withColumnsNames(columnNames);
                alterExp.setIndex(index);
        constraints = AlterExpressionConstraintState();
alterExp.setConstraints(constraints);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_USING:{
          jj_consume_token(K_USING);
          sk4 = RelObjectName();
alterExp.addParameters("USING", sk4);
          break;
          }
        default:
          jj_la1[442] = jj_gen;
          ;
        }
      } else if (jj_2_153(3)) {
        if (jj_2_145(2)) {
          jj_consume_token(K_COLUMN);
        } else {
          ;
        }
        if (jj_2_146(2)) {
          alterExpressionColumnDataType = AlterExpressionColumnDataType();
alterExp.addColDataType(alterExpressionColumnDataType);
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ACTION:
          case K_ANY:
          case K_BYTE:
          case K_CASCADE:
          case K_CAST:
          case K_CHARACTER:
          case K_CHANGE:
          case K_CHAR:
          case K_COLUMN:
          case K_COLUMNS:
          case K_COMMIT:
          case K_COMMENT:
          case K_CREATE:
          case K_CYCLE:
          case K_DATETIMELITERAL:
          case K_DATE_LITERAL:
          case K_DESC:
          case K_DESCRIBE:
          case K_DISABLE:
          case K_DIV:
          case K_DO:
          case K_DUPLICATE:
          case K_ENABLE:
          case K_END:
          case K_EXCLUDE:
          case K_EXTRACT:
          case K_FIRST:
          case K_FALSE:
          case K_FOLLOWING:
          case K_FORMAT:
          case K_GROUP:
          case K_INDEX:
          case K_INSERT:
          case K_INTERVAL:
          case K_ISNULL:
          case K_KEY:
          case K_FN:
          case K_LAST:
          case K_MATERIALIZED:
          case K_NEXTVAL:
          case K_NO:
          case K_NOLOCK:
          case K_NULLS:
          case K_OF:
          case K_ON:
          case K_OPEN:
          case K_ORDER:
          case K_OVER:
          case K_PARTITION:
          case K_PATH:
          case K_PERCENT:
          case K_PRECISION:
          case K_PRIMARY:
          case K_PRIOR:
          case K_RANGE:
          case K_READ:
          case K_REPLACE:
          case K_ROW:
          case K_ROWS:
          case K_SCHEMA:
          case K_SEQUENCE:
          case K_SEPARATOR:
          case K_SESSION:
          case K_SIBLINGS:
          case K_SIZE:
          case K_START:
          case K_TABLE:
          case K_TABLES:
          case K_TEMP:
          case K_TEMPORARY:
          case K_TO:
          case K_TOP:
          case K_TRUNCATE:
          case K_TRUE:
          case K_TYPE:
          case K_UNSIGNED:
          case K_VALIDATE:
          case K_VALUE:
          case K_VALUES:
          case K_VIEW:
          case K_XML:
          case K_ZONE:
          case S_IDENTIFIER:
          case S_QUOTED_IDENTIFIER:{
            alterExpressionColumnDropNotNull = AlterExpressionColumnDropNotNull();
alterExp.addColDropNotNull( alterExpressionColumnDropNotNull);
            break;
            }
          default:
            jj_la1[443] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 266:{
          jj_consume_token(266);
          alterExpressionColumnDataType = AlterExpressionColumnDataType();
alterExp.addColDataType(alterExpressionColumnDataType);
          label_94:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_COMMA:{
              ;
              break;
              }
            default:
              jj_la1[444] = jj_gen;
              break label_94;
            }
            jj_consume_token(K_COMMA);
            alterExpressionColumnDataType = AlterExpressionColumnDataType();
alterExp.addColDataType(alterExpressionColumnDataType);
          }
          jj_consume_token(267);
          break;
          }
        case K_UNIQUE:{
          jj_consume_token(K_UNIQUE);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_INDEX:
          case K_KEY:{
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_KEY:{
              jj_consume_token(K_KEY);
alterExp.setUk(true);
              break;
              }
            case K_INDEX:{
              jj_consume_token(K_INDEX);
              break;
              }
            default:
              jj_la1[445] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case S_IDENTIFIER:{
              tk = jj_consume_token(S_IDENTIFIER);
              break;
              }
            case S_QUOTED_IDENTIFIER:{
              tk = jj_consume_token(S_QUOTED_IDENTIFIER);
              break;
              }
            default:
              jj_la1[446] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
alterExp.setUkName(tk.image);
            break;
            }
          default:
            jj_la1[447] = jj_gen;
            ;
          }
          columnNames = ColumnsNamesList();
alterExp.setUkColumns(columnNames);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_USING:{
            jj_consume_token(K_USING);
            sk4 = RelObjectName();
alterExp.addParameters("USING", sk4);
            break;
            }
          default:
            jj_la1[448] = jj_gen;
            ;
          }
          break;
          }
        case K_FOREIGN:{
          jj_consume_token(K_FOREIGN);
          jj_consume_token(K_KEY);
          columnNames = ColumnsNamesList();
alterExp.setFkColumns(columnNames); columnNames = null;
          jj_consume_token(K_REFERENCES);
          tk = jj_consume_token(S_IDENTIFIER);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 266:{
            columnNames = ColumnsNamesList();
            break;
            }
          default:
            jj_la1[449] = jj_gen;
            ;
          }
alterExp.setFkSourceTable(tk.image); alterExp.setFkSourceColumns(columnNames);
          if (jj_2_147(2)) {
            jj_consume_token(K_ON);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_DELETE:{
              tk = jj_consume_token(K_DELETE);
              break;
              }
            case K_UPDATE:{
              tk = jj_consume_token(K_UPDATE);
              break;
              }
            default:
              jj_la1[450] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            action = Action();
alterExp.setReferentialAction(ReferentialAction.Type.valueOf(tk.image), action);
          } else {
            ;
          }
          if (jj_2_148(2)) {
            jj_consume_token(K_ON);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_DELETE:{
              tk = jj_consume_token(K_DELETE);
              break;
              }
            case K_UPDATE:{
              tk = jj_consume_token(K_UPDATE);
              break;
              }
            default:
              jj_la1[451] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            action = Action();
alterExp.setReferentialAction(ReferentialAction.Type.valueOf(tk.image), action);
          } else {
            ;
          }
          break;
          }
        case K_CONSTRAINT:{
          jj_consume_token(K_CONSTRAINT);
          sk3 = RelObjectName();
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_FOREIGN:{
            tk = jj_consume_token(K_FOREIGN);
            tk2 = jj_consume_token(K_KEY);
            columnNames = ColumnsNamesList();
fkIndex = new ForeignKeyIndex()
                        .withName(sk3)
                        .withType(tk.image + " " + tk2.image)
                        .withColumnsNames(columnNames);
                                            columnNames = null;
            jj_consume_token(K_REFERENCES);
            fkTable = Table();
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case 266:{
              columnNames = ColumnsNamesList();
              break;
              }
            default:
              jj_la1[452] = jj_gen;
              ;
            }
fkIndex.withTable(fkTable).withReferencedColumnNames(columnNames);
                        alterExp.setIndex(fkIndex);
            if (jj_2_149(2)) {
              jj_consume_token(K_ON);
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_DELETE:{
                tk = jj_consume_token(K_DELETE);
                break;
                }
              case K_UPDATE:{
                tk = jj_consume_token(K_UPDATE);
                break;
                }
              default:
                jj_la1[453] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
              action = Action();
fkIndex.setReferentialAction(ReferentialAction.Type.valueOf(tk.image), action);
            } else {
              ;
            }
            if (jj_2_150(2)) {
              jj_consume_token(K_ON);
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_DELETE:{
                tk = jj_consume_token(K_DELETE);
                break;
                }
              case K_UPDATE:{
                tk = jj_consume_token(K_UPDATE);
                break;
                }
              default:
                jj_la1[454] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
              action = Action();
fkIndex.setReferentialAction(ReferentialAction.Type.valueOf(tk.image), action);
            } else {
              ;
            }
            constraints = AlterExpressionConstraintState();
alterExp.setConstraints(constraints);
            break;
            }
          case K_PRIMARY:{
            tk = jj_consume_token(K_PRIMARY);
            tk2 = jj_consume_token(K_KEY);
            columnNames = ColumnsNamesList();
index = new NamedConstraint()
                        .withName(sk3)
                        .withType(tk.image + " " + tk2.image)
                        .withColumnsNames(columnNames);
                        alterExp.setIndex(index);
            constraints = AlterExpressionConstraintState();
alterExp.setConstraints(constraints);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_USING:{
              jj_consume_token(K_USING);
              sk4 = RelObjectName();
alterExp.addParameters("USING", sk4);
              break;
              }
            default:
              jj_la1[455] = jj_gen;
              ;
            }
            break;
            }
          case K_CHECK:{
            jj_consume_token(K_CHECK);
Expression exp = null;
            label_95:
            while (true) {
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case 266:{
                ;
                break;
                }
              default:
                jj_la1[456] = jj_gen;
                break label_95;
              }
              jj_consume_token(266);
              exp = Expression();
              jj_consume_token(267);
            }
CheckConstraint checkCs = new CheckConstraint().withName(sk3).withExpression(exp);
                    alterExp.setIndex(checkCs);
            break;
            }
          case K_UNIQUE:{
            tk = jj_consume_token(K_UNIQUE);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_INDEX:
            case K_KEY:{
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_KEY:{
                tk2 = jj_consume_token(K_KEY);
alterExp.setUk(true);
                break;
                }
              case K_INDEX:{
                tk2 = jj_consume_token(K_INDEX);
                break;
                }
              default:
                jj_la1[457] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
              break;
              }
            default:
              jj_la1[458] = jj_gen;
              ;
            }
            columnNames = ColumnsNamesList();
index = new NamedConstraint()
                            .withName(sk3)
                                .withType(tk.image + (tk2!=null?" " + tk2.image:""))
                                .withColumnsNames(columnNames);
                          alterExp.setIndex(index);
            constraints = AlterExpressionConstraintState();
alterExp.setConstraints(constraints);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_USING:{
              jj_consume_token(K_USING);
              sk4 = RelObjectName();
alterExp.addParameters("USING", sk4);
              break;
              }
            default:
              jj_la1[459] = jj_gen;
              ;
            }
            break;
            }
          case K_KEY:{
            tk = jj_consume_token(K_KEY);
            columnNames = ColumnsNamesList();
index = new NamedConstraint()
                                .withName(sk3)
                                .withType(tk.image)
                                                        .withColumnsNames(columnNames);
                          alterExp.setIndex(index);
            constraints = AlterExpressionConstraintState();
alterExp.setConstraints(constraints);
            break;
            }
          default:
            jj_la1[460] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        case K_ACTION:
        case K_ANY:
        case K_BYTE:
        case K_CASCADE:
        case K_CAST:
        case K_CHARACTER:
        case K_CHANGE:
        case K_CHAR:
        case K_COLUMN:
        case K_COLUMNS:
        case K_COMMIT:
        case K_COMMENT:
        case K_CREATE:
        case K_CYCLE:
        case K_DATETIMELITERAL:
        case K_DATE_LITERAL:
        case K_DESC:
        case K_DESCRIBE:
        case K_DISABLE:
        case K_DIV:
        case K_DO:
        case K_DUPLICATE:
        case K_ENABLE:
        case K_END:
        case K_EXCLUDE:
        case K_EXTRACT:
        case K_FIRST:
        case K_FALSE:
        case K_FOLLOWING:
        case K_FORMAT:
        case K_GROUP:
        case K_INDEX:
        case K_INSERT:
        case K_INTERVAL:
        case K_ISNULL:
        case K_KEY:
        case K_FN:
        case K_LAST:
        case K_MATERIALIZED:
        case K_NEXTVAL:
        case K_NO:
        case K_NOLOCK:
        case K_NULLS:
        case K_OF:
        case K_ON:
        case K_OPEN:
        case K_ORDER:
        case K_OVER:
        case K_PARTITION:
        case K_PATH:
        case K_PERCENT:
        case K_PRECISION:
        case K_PRIMARY:
        case K_PRIOR:
        case K_RANGE:
        case K_READ:
        case K_REPLACE:
        case K_ROW:
        case K_ROWS:
        case K_SCHEMA:
        case K_SEQUENCE:
        case K_SEPARATOR:
        case K_SESSION:
        case K_SIBLINGS:
        case K_SIZE:
        case K_START:
        case K_TABLE:
        case K_TABLES:
        case K_TEMP:
        case K_TEMPORARY:
        case K_TO:
        case K_TOP:
        case K_TRUNCATE:
        case K_TRUE:
        case K_TYPE:
        case K_UNSIGNED:
        case K_VALIDATE:
        case K_VALUE:
        case K_VALUES:
        case K_VIEW:
        case K_XML:
        case K_ZONE:
        case S_IDENTIFIER:
        case S_QUOTED_IDENTIFIER:{
          sk3 = RelObjectName();
          jj_consume_token(K_COMMENT);
          tk = jj_consume_token(S_CHAR_LITERAL);
alterExp.withColumnName(sk3).withCommentText(tk.image);
          break;
          }
        default:
          jj_la1[461] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    case K_CHANGE:{
      jj_consume_token(K_CHANGE);
alterExp.setOperation(AlterOperation.CHANGE);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COLUMN:{
        jj_consume_token(K_COLUMN);
alterExp.setOptionalSpecifier("COLUMN");
        break;
        }
      default:
        jj_la1[462] = jj_gen;

      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        tk = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case S_QUOTED_IDENTIFIER:{
        tk = jj_consume_token(S_QUOTED_IDENTIFIER);
        break;
        }
      default:
        jj_la1[463] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      alterExpressionColumnDataType = AlterExpressionColumnDataType();
alterExp.withColumnOldName(tk.image).addColDataType(alterExpressionColumnDataType);
      break;
      }
    case K_DROP:{
      jj_consume_token(K_DROP);
alterExp.setOperation(AlterOperation.DROP);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COLUMN:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:{
        if (jj_2_154(2)) {
          jj_consume_token(K_COLUMN);
        } else {
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_IDENTIFIER:{
          tk = jj_consume_token(S_IDENTIFIER);
          break;
          }
        case S_QUOTED_IDENTIFIER:{
          tk = jj_consume_token(S_QUOTED_IDENTIFIER);
          break;
          }
        default:
          jj_la1[464] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
alterExp.setColumnName(tk.image);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_CASCADE:{
          tk = jj_consume_token(K_CASCADE);
alterExp.addParameters(tk.image);
          break;
          }
        default:
          jj_la1[465] = jj_gen;
          ;
        }
        break;
        }
      case K_INDEX:{
        tk = jj_consume_token(K_INDEX);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_IDENTIFIER:{
          tk2 = jj_consume_token(S_IDENTIFIER);
          break;
          }
        case S_QUOTED_IDENTIFIER:{
          tk2 = jj_consume_token(S_QUOTED_IDENTIFIER);
          break;
          }
        default:
          jj_la1[466] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
index = new Index().withType(tk.image).withName(tk2.image);
                           alterExp.setIndex(index);
        break;
        }
      case K_CONSTRAINT:{
        jj_consume_token(K_CONSTRAINT);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_IF:{
          jj_consume_token(K_IF);
          jj_consume_token(K_EXISTS);
alterExp.setConstraintIfExists(true);
          break;
          }
        default:
          jj_la1[467] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_IDENTIFIER:{
          tk = jj_consume_token(S_IDENTIFIER);
          break;
          }
        case S_QUOTED_IDENTIFIER:{
          tk = jj_consume_token(S_QUOTED_IDENTIFIER);
          break;
          }
        default:
          jj_la1[468] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
alterExp.setConstraintName(tk.image);
        break;
        }
      default:
        jj_la1[469] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case K_ALGORITHM:{
      jj_consume_token(K_ALGORITHM);
alterExp.setOperation(AlterOperation.ALGORITHM);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 268:{
        jj_consume_token(268);
alterExp.setUseEqual(true);
        break;
        }
      default:
        jj_la1[470] = jj_gen;
        ;
      }
      sk3 = RelObjectName();
alterExp.addParameters(sk3);
      break;
      }
    case K_RENAME:{
      jj_consume_token(K_RENAME);
alterExp.setOperation(AlterOperation.RENAME);
      jj_consume_token(K_COLUMN);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        tk = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case S_QUOTED_IDENTIFIER:{
        tk = jj_consume_token(S_QUOTED_IDENTIFIER);
        break;
        }
      default:
        jj_la1[471] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
alterExp.setColOldName(tk.image);
      jj_consume_token(K_TO);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        tk2 = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case S_QUOTED_IDENTIFIER:{
        tk2 = jj_consume_token(S_QUOTED_IDENTIFIER);
        break;
        }
      default:
        jj_la1[472] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
alterExp.setColumnName(tk2.image);
      break;
      }
    case K_COMMENT:{
      jj_consume_token(K_COMMENT);
alterExp.setOperation(AlterOperation.COMMENT);
      tk = jj_consume_token(S_CHAR_LITERAL);
alterExp.setCommentText(tk.image);
      break;
      }
    default:
      jj_la1[473] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return alterExp;
}

  final public Alter AlterTable() throws ParseException {Alter alter = new Alter();
    Table table;
    AlterExpression alterExp;
    jj_consume_token(K_ALTER);
    jj_consume_token(K_TABLE);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ONLY:{
      jj_consume_token(K_ONLY);
alter.setUseOnly(true);
      break;
      }
    default:
      jj_la1[474] = jj_gen;
      ;
    }
    table = Table();
alter.setTable(table);
    alterExp = AlterExpression();
alter.addAlterExpression(alterExp);
    label_96:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[475] = jj_gen;
        break label_96;
      }
      jj_consume_token(K_COMMA);
      alterExp = AlterExpression();
alter.addAlterExpression(alterExp);
    }
return alter;
}

  final public Wait Wait() throws ParseException {Wait wait = new Wait();
    Token token = null;
    jj_consume_token(K_WAIT);
    token = jj_consume_token(S_LONG);
wait.setTimeout(Long.parseLong(token.image));
return wait;
}

  final public Commit Commit() throws ParseException {Commit commit=new Commit();
    jj_consume_token(K_COMMIT);
return commit;
}

  final public Comment Comment() throws ParseException {Comment result = new Comment();
    Table table;
    Table view;
    Column column;
    Token comment;
    jj_consume_token(K_COMMENT);
    jj_consume_token(K_ON);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_TABLE:{
      jj_consume_token(K_TABLE);
      table = Table();
result.setTable(table);
      break;
      }
    case K_COLUMN:{
      jj_consume_token(K_COLUMN);
      column = Column();
result.setColumn(column);
      break;
      }
    case K_VIEW:{
      jj_consume_token(K_VIEW);
      view = Table();
result.setView(view);
      break;
      }
    default:
      jj_la1[476] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(K_IS);
    comment = jj_consume_token(S_CHAR_LITERAL);
result.setComment(new StringValue(comment.image));
return result;
}

  final public Grant Grant() throws ParseException {Grant grant = new Grant();
        ArrayList<String> privileges = new ArrayList<String>();
        List<String> users;
        Token tk = null;
        List<String> objName;
    jj_consume_token(K_GRANT);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ALTER:
    case K_DELETE:
    case K_DROP:
    case K_EXECUTE:
    case K_INSERT:
    case K_ON:
    case K_SELECT:
    case K_UPDATE:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ALTER:
      case K_DELETE:
      case K_DROP:
      case K_EXECUTE:
      case K_INSERT:
      case K_SELECT:
      case K_UPDATE:{
        readGrantTypes(privileges);
        label_97:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_COMMA:{
            ;
            break;
            }
          default:
            jj_la1[477] = jj_gen;
            break label_97;
          }
          jj_consume_token(K_COMMA);
          readGrantTypes(privileges);
        }
        break;
        }
      default:
        jj_la1[478] = jj_gen;
        ;
      }
      jj_consume_token(K_ON);
      objName = RelObjectNameList();
grant.setObjectName(objName);
      break;
      }
    case S_IDENTIFIER:{
      tk = jj_consume_token(S_IDENTIFIER);
grant.setRole(tk.image);
      break;
      }
    default:
      jj_la1[479] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(K_TO);
    users = UsersList();
grant.setUsers(users);
if(privileges.size() > 0) {
                grant.setPrivileges(privileges);
            }
                return grant;
}

  final public List<String> UsersList() throws ParseException {List<String> users = new ArrayList<String>();
    String user = null;
    user = RelObjectName();
users.add(user);
    label_98:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[480] = jj_gen;
        break label_98;
      }
      jj_consume_token(K_COMMA);
      user = ColumnsNamesListItem();
users.add(user);
    }
return users;
}

  final public void readGrantTypes(ArrayList<String> privileges) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_SELECT:{
      jj_consume_token(K_SELECT);
privileges.add("SELECT");
      break;
      }
    case K_INSERT:{
      jj_consume_token(K_INSERT);
privileges.add("INSERT");
      break;
      }
    case K_UPDATE:{
      jj_consume_token(K_UPDATE);
privileges.add("UPDATE");
      break;
      }
    case K_DELETE:{
      jj_consume_token(K_DELETE);
privileges.add("DELETE");
      break;
      }
    case K_EXECUTE:{
      jj_consume_token(K_EXECUTE);
privileges.add("EXECUTE");
      break;
      }
    case K_ALTER:{
      jj_consume_token(K_ALTER);
privileges.add("ALTER");
      break;
      }
    case K_DROP:{
      jj_consume_token(K_DROP);
privileges.add("DROP");
      break;
      }
    default:
      jj_la1[481] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public Sequence Sequence() throws ParseException {/*@bgen(jjtree) Sequence */
    SimpleNode jjtn000 = new SimpleNode(JJTSEQUENCE);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));List<String> data = new ArrayList<String>();
    String serverName = null, databaseName = null, schemaName = null, sequenceName = null;
    try {
      data = RelObjectNameList();
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
Sequence sequence = new Sequence(data);
                linkAST(sequence,jjtn000);
        return sequence;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public List<Sequence.Parameter> SequenceParameters() throws ParseException {List<Sequence.Parameter> sequenceParameters = new ArrayList<Sequence.Parameter>();
  Sequence.Parameter parameter = null;
  Token token = null;
    label_99:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_CACHE:
      case K_CYCLE:
      case K_GLOBAL:
      case K_INCREMENT:
      case K_KEEP:
      case K_MAXVALUE:
      case K_MINVALUE:
      case K_NOCACHE:
      case K_NOCYCLE:
      case K_NOKEEP:
      case K_NOMAXVALUE:
      case K_NOMINVALUE:
      case K_NOORDER:
      case K_ORDER:
      case K_SESSION:
      case K_START:{
        ;
        break;
        }
      default:
        jj_la1[482] = jj_gen;
        break label_99;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_INCREMENT:{
        jj_consume_token(K_INCREMENT);
        jj_consume_token(K_BY);
        token = jj_consume_token(S_LONG);
parameter = new Sequence.Parameter(Sequence.ParameterType.INCREMENT_BY);
        parameter.setValue(Long.parseLong(token.image));
        sequenceParameters.add(parameter);
        break;
        }
      case K_START:{
        jj_consume_token(K_START);
        jj_consume_token(K_WITH);
        token = jj_consume_token(S_LONG);
parameter = new Sequence.Parameter(Sequence.ParameterType.START_WITH);
      parameter.setValue(Long.parseLong(token.image));
      sequenceParameters.add(parameter);
        break;
        }
      case K_MAXVALUE:
      case K_NOMAXVALUE:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_NOMAXVALUE:{
          jj_consume_token(K_NOMAXVALUE);
parameter = new Sequence.Parameter(Sequence.ParameterType.NOMAXVALUE);
      sequenceParameters.add(parameter);
          break;
          }
        case K_MAXVALUE:{
          jj_consume_token(K_MAXVALUE);
          token = jj_consume_token(S_LONG);
parameter = new Sequence.Parameter(Sequence.ParameterType.MAXVALUE);
      parameter.setValue(Long.parseLong(token.image));
      sequenceParameters.add(parameter);
          break;
          }
        default:
          jj_la1[483] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case K_MINVALUE:
      case K_NOMINVALUE:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_NOMINVALUE:{
          jj_consume_token(K_NOMINVALUE);
parameter = new Sequence.Parameter(Sequence.ParameterType.NOMINVALUE);
      sequenceParameters.add(parameter);
          break;
          }
        case K_MINVALUE:{
          jj_consume_token(K_MINVALUE);
          token = jj_consume_token(S_LONG);
parameter = new Sequence.Parameter(Sequence.ParameterType.MINVALUE);
      parameter.setValue(Long.parseLong(token.image));
      sequenceParameters.add(parameter);
          break;
          }
        default:
          jj_la1[484] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case K_CYCLE:
      case K_NOCYCLE:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_NOCYCLE:{
          jj_consume_token(K_NOCYCLE);
sequenceParameters.add(new Sequence.Parameter(Sequence.ParameterType.NOCYCLE));
          break;
          }
        case K_CYCLE:{
          jj_consume_token(K_CYCLE);
sequenceParameters.add(new Sequence.Parameter(Sequence.ParameterType.CYCLE));
          break;
          }
        default:
          jj_la1[485] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case K_CACHE:
      case K_NOCACHE:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_NOCACHE:{
          jj_consume_token(K_NOCACHE);
parameter = new Sequence.Parameter(Sequence.ParameterType.NOCACHE);
      sequenceParameters.add(parameter);
          break;
          }
        case K_CACHE:{
          jj_consume_token(K_CACHE);
          token = jj_consume_token(S_LONG);
parameter = new Sequence.Parameter(Sequence.ParameterType.CACHE);
      parameter.setValue(Long.parseLong(token.image));
      sequenceParameters.add(parameter);
          break;
          }
        default:
          jj_la1[486] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case K_NOORDER:
      case K_ORDER:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ORDER:{
          jj_consume_token(K_ORDER);
sequenceParameters.add(new Sequence.Parameter(Sequence.ParameterType.ORDER));
          break;
          }
        case K_NOORDER:{
          jj_consume_token(K_NOORDER);
sequenceParameters.add(new Sequence.Parameter(Sequence.ParameterType.NOORDER));
          break;
          }
        default:
          jj_la1[487] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case K_KEEP:
      case K_NOKEEP:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_KEEP:{
          jj_consume_token(K_KEEP);
sequenceParameters.add(new Sequence.Parameter(Sequence.ParameterType.KEEP));
          break;
          }
        case K_NOKEEP:{
          jj_consume_token(K_NOKEEP);
sequenceParameters.add(new Sequence.Parameter(Sequence.ParameterType.NOKEEP));
          break;
          }
        default:
          jj_la1[488] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case K_GLOBAL:
      case K_SESSION:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_SESSION:{
          jj_consume_token(K_SESSION);
sequenceParameters.add(new Sequence.Parameter(Sequence.ParameterType.SESSION));
          break;
          }
        case K_GLOBAL:{
          jj_consume_token(K_GLOBAL);
sequenceParameters.add(new Sequence.Parameter(Sequence.ParameterType.GLOBAL));
          break;
          }
        default:
          jj_la1[489] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[490] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return sequenceParameters;
}

  final public CreateSequence CreateSequence() throws ParseException {CreateSequence createSequence = new CreateSequence();
  Sequence sequence;
  List<Sequence.Parameter> sequenceParameters;
    jj_consume_token(K_CREATE);
    jj_consume_token(K_SEQUENCE);
    sequence = Sequence();
createSequence.setSequence(sequence);
    sequenceParameters = SequenceParameters();
sequence.setParameters(sequenceParameters);
return createSequence;
}

  final public AlterSequence AlterSequence() throws ParseException {AlterSequence alterSequence = new AlterSequence();
  Sequence sequence;
  List<Sequence.Parameter> sequenceParameters;
    jj_consume_token(K_ALTER);
    jj_consume_token(K_SEQUENCE);
    sequence = Sequence();
alterSequence.setSequence(sequence);
    sequenceParameters = SequenceParameters();
sequence.setParameters(sequenceParameters);
return alterSequence;
}

  final public CreateFunctionalStatement CreateFunctionStatement() throws ParseException {CreateFunctionalStatement type = null;
  List<String> tokens = new LinkedList<String>();
  String statementType = null;
  boolean orReplace = false;
    jj_consume_token(K_CREATE);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_OR:{
      jj_consume_token(K_OR);
      jj_consume_token(K_REPLACE);
orReplace = true;
      break;
      }
    default:
      jj_la1[491] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FUNCTION:{
      jj_consume_token(K_FUNCTION);
statementType = "FUNCTION";
      break;
      }
    case K_PROCEDURE:{
      jj_consume_token(K_PROCEDURE);
statementType = "PROCEDURE";
      break;
      }
    default:
      jj_la1[492] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    tokens = captureRest();
if(statementType.equals("FUNCTION")) {
      type = new CreateFunction(orReplace, tokens);
    }
    if(statementType.equals("PROCEDURE")) {
      type = new CreateProcedure(orReplace, tokens);
    }

    return type;
}

  final public CreateSynonym CreateSynonym() throws ParseException {CreateSynonym createSynonym = new CreateSynonym();
  Synonym synonym;
  boolean orReplace = false;
  boolean publicSynonym = false;
  List<String> data = new ArrayList<String>();
    jj_consume_token(K_CREATE);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_OR:{
      jj_consume_token(K_OR);
      jj_consume_token(K_REPLACE);
orReplace = true;
      break;
      }
    default:
      jj_la1[493] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_PUBLIC:{
      jj_consume_token(K_PUBLIC);
publicSynonym = true;
      break;
      }
    default:
      jj_la1[494] = jj_gen;
      ;
    }
    jj_consume_token(K_SYNONYM);
    synonym = Synonym();
createSynonym.setSynonym(synonym);
    jj_consume_token(K_FOR);
    data = RelObjectNameList();
createSynonym.setOrReplace(orReplace);
    createSynonym.setPublicSynonym(publicSynonym);
    createSynonym.setForList(data);
    return createSynonym;
}

  final public Synonym Synonym() throws ParseException {/*@bgen(jjtree) Synonym */
    SimpleNode jjtn000 = new SimpleNode(JJTSYNONYM);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));List<String> data = new ArrayList<String>();
    String serverName = null, databaseName = null, schemaName = null, sequenceName = null;
    try {
      data = RelObjectNameList();
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
Synonym synonym = new Synonym(data);
                linkAST(synonym,jjtn000);
        return synonym;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  List<String> captureRest() throws ParseException {List<String> tokens = new LinkedList<String>();
  Token tok;
  while(true) {
    tok = getToken(1);
    if(tok.kind == EOF) {
      break;
    }
    tokens.add(tok.image);
    tok = getNextToken();
  }
  return tokens;
  }

  private boolean jj_2_1(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_1()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_2()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_3()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_4()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_5()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_6()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_7()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_8()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_9()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_2_10(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_10()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  private boolean jj_2_11(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_11()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  private boolean jj_2_12(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_12()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  private boolean jj_2_13(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_13()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  private boolean jj_2_14(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_14()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  private boolean jj_2_15(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_15()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  private boolean jj_2_16(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_16()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  private boolean jj_2_17(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_17()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  private boolean jj_2_18(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_18()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  private boolean jj_2_19(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_19()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  private boolean jj_2_20(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_20()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(19, xla); }
  }

  private boolean jj_2_21(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_21()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(20, xla); }
  }

  private boolean jj_2_22(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_22()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(21, xla); }
  }

  private boolean jj_2_23(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_23()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(22, xla); }
  }

  private boolean jj_2_24(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_24()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(23, xla); }
  }

  private boolean jj_2_25(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_25()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(24, xla); }
  }

  private boolean jj_2_26(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_26()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(25, xla); }
  }

  private boolean jj_2_27(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_27()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(26, xla); }
  }

  private boolean jj_2_28(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_28()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(27, xla); }
  }

  private boolean jj_2_29(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_29()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(28, xla); }
  }

  private boolean jj_2_30(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_30()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(29, xla); }
  }

  private boolean jj_2_31(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_31()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(30, xla); }
  }

  private boolean jj_2_32(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_32()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(31, xla); }
  }

  private boolean jj_2_33(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_33()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(32, xla); }
  }

  private boolean jj_2_34(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_34()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(33, xla); }
  }

  private boolean jj_2_35(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_35()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(34, xla); }
  }

  private boolean jj_2_36(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_36()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(35, xla); }
  }

  private boolean jj_2_37(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_37()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(36, xla); }
  }

  private boolean jj_2_38(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_38()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(37, xla); }
  }

  private boolean jj_2_39(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_39()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(38, xla); }
  }

  private boolean jj_2_40(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_40()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(39, xla); }
  }

  private boolean jj_2_41(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_41()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(40, xla); }
  }

  private boolean jj_2_42(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_42()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(41, xla); }
  }

  private boolean jj_2_43(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_43()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(42, xla); }
  }

  private boolean jj_2_44(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_44()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(43, xla); }
  }

  private boolean jj_2_45(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_45()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(44, xla); }
  }

  private boolean jj_2_46(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_46()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(45, xla); }
  }

  private boolean jj_2_47(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_47()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(46, xla); }
  }

  private boolean jj_2_48(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_48()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(47, xla); }
  }

  private boolean jj_2_49(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_49()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(48, xla); }
  }

  private boolean jj_2_50(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_50()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(49, xla); }
  }

  private boolean jj_2_51(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_51()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(50, xla); }
  }

  private boolean jj_2_52(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_52()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(51, xla); }
  }

  private boolean jj_2_53(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_53()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(52, xla); }
  }

  private boolean jj_2_54(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_54()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(53, xla); }
  }

  private boolean jj_2_55(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_55()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(54, xla); }
  }

  private boolean jj_2_56(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_56()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(55, xla); }
  }

  private boolean jj_2_57(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_57()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(56, xla); }
  }

  private boolean jj_2_58(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_58()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(57, xla); }
  }

  private boolean jj_2_59(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_59()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(58, xla); }
  }

  private boolean jj_2_60(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_60()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(59, xla); }
  }

  private boolean jj_2_61(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_61()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(60, xla); }
  }

  private boolean jj_2_62(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_62()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(61, xla); }
  }

  private boolean jj_2_63(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_63()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(62, xla); }
  }

  private boolean jj_2_64(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_64()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(63, xla); }
  }

  private boolean jj_2_65(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_65()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(64, xla); }
  }

  private boolean jj_2_66(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_66()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(65, xla); }
  }

  private boolean jj_2_67(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_67()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(66, xla); }
  }

  private boolean jj_2_68(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_68()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(67, xla); }
  }

  private boolean jj_2_69(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_69()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(68, xla); }
  }

  private boolean jj_2_70(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_70()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(69, xla); }
  }

  private boolean jj_2_71(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_71()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(70, xla); }
  }

  private boolean jj_2_72(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_72()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(71, xla); }
  }

  private boolean jj_2_73(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_73()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(72, xla); }
  }

  private boolean jj_2_74(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_74()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(73, xla); }
  }

  private boolean jj_2_75(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_75()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(74, xla); }
  }

  private boolean jj_2_76(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_76()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(75, xla); }
  }

  private boolean jj_2_77(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_77()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(76, xla); }
  }

  private boolean jj_2_78(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_78()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(77, xla); }
  }

  private boolean jj_2_79(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_79()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(78, xla); }
  }

  private boolean jj_2_80(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_80()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(79, xla); }
  }

  private boolean jj_2_81(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_81()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(80, xla); }
  }

  private boolean jj_2_82(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_82()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(81, xla); }
  }

  private boolean jj_2_83(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_83()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(82, xla); }
  }

  private boolean jj_2_84(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_84()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(83, xla); }
  }

  private boolean jj_2_85(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_85()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(84, xla); }
  }

  private boolean jj_2_86(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_86()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(85, xla); }
  }

  private boolean jj_2_87(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_87()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(86, xla); }
  }

  private boolean jj_2_88(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_88()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(87, xla); }
  }

  private boolean jj_2_89(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_89()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(88, xla); }
  }

  private boolean jj_2_90(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_90()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(89, xla); }
  }

  private boolean jj_2_91(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_91()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(90, xla); }
  }

  private boolean jj_2_92(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_92()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(91, xla); }
  }

  private boolean jj_2_93(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_93()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(92, xla); }
  }

  private boolean jj_2_94(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_94()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(93, xla); }
  }

  private boolean jj_2_95(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_95()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(94, xla); }
  }

  private boolean jj_2_96(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_96()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(95, xla); }
  }

  private boolean jj_2_97(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_97()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(96, xla); }
  }

  private boolean jj_2_98(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_98()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(97, xla); }
  }

  private boolean jj_2_99(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_99()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(98, xla); }
  }

  private boolean jj_2_100(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_100()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(99, xla); }
  }

  private boolean jj_2_101(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_101()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(100, xla); }
  }

  private boolean jj_2_102(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_102()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(101, xla); }
  }

  private boolean jj_2_103(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_103()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(102, xla); }
  }

  private boolean jj_2_104(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_104()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(103, xla); }
  }

  private boolean jj_2_105(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_105()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(104, xla); }
  }

  private boolean jj_2_106(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_106()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(105, xla); }
  }

  private boolean jj_2_107(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_107()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(106, xla); }
  }

  private boolean jj_2_108(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_108()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(107, xla); }
  }

  private boolean jj_2_109(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_109()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(108, xla); }
  }

  private boolean jj_2_110(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_110()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(109, xla); }
  }

  private boolean jj_2_111(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_111()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(110, xla); }
  }

  private boolean jj_2_112(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_112()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(111, xla); }
  }

  private boolean jj_2_113(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_113()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(112, xla); }
  }

  private boolean jj_2_114(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_114()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(113, xla); }
  }

  private boolean jj_2_115(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_115()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(114, xla); }
  }

  private boolean jj_2_116(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_116()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(115, xla); }
  }

  private boolean jj_2_117(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_117()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(116, xla); }
  }

  private boolean jj_2_118(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_118()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(117, xla); }
  }

  private boolean jj_2_119(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_119()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(118, xla); }
  }

  private boolean jj_2_120(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_120()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(119, xla); }
  }

  private boolean jj_2_121(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_121()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(120, xla); }
  }

  private boolean jj_2_122(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_122()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(121, xla); }
  }

  private boolean jj_2_123(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_123()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(122, xla); }
  }

  private boolean jj_2_124(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_124()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(123, xla); }
  }

  private boolean jj_2_125(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_125()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(124, xla); }
  }

  private boolean jj_2_126(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_126()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(125, xla); }
  }

  private boolean jj_2_127(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_127()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(126, xla); }
  }

  private boolean jj_2_128(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_128()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(127, xla); }
  }

  private boolean jj_2_129(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_129()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(128, xla); }
  }

  private boolean jj_2_130(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_130()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(129, xla); }
  }

  private boolean jj_2_131(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_131()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(130, xla); }
  }

  private boolean jj_2_132(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_132()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(131, xla); }
  }

  private boolean jj_2_133(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_133()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(132, xla); }
  }

  private boolean jj_2_134(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_134()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(133, xla); }
  }

  private boolean jj_2_135(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_135()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(134, xla); }
  }

  private boolean jj_2_136(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_136()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(135, xla); }
  }

  private boolean jj_2_137(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_137()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(136, xla); }
  }

  private boolean jj_2_138(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_138()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(137, xla); }
  }

  private boolean jj_2_139(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_139()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(138, xla); }
  }

  private boolean jj_2_140(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_140()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(139, xla); }
  }

  private boolean jj_2_141(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_141()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(140, xla); }
  }

  private boolean jj_2_142(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_142()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(141, xla); }
  }

  private boolean jj_2_143(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_143()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(142, xla); }
  }

  private boolean jj_2_144(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_144()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(143, xla); }
  }

  private boolean jj_2_145(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_145()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(144, xla); }
  }

  private boolean jj_2_146(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_146()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(145, xla); }
  }

  private boolean jj_2_147(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_147()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(146, xla); }
  }

  private boolean jj_2_148(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_148()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(147, xla); }
  }

  private boolean jj_2_149(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_149()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(148, xla); }
  }

  private boolean jj_2_150(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_150()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(149, xla); }
  }

  private boolean jj_2_151(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_151()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(150, xla); }
  }

  private boolean jj_2_152(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_152()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(151, xla); }
  }

  private boolean jj_2_153(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_153()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(152, xla); }
  }

  private boolean jj_2_154(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_154()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(153, xla); }
  }

  private boolean jj_3R_PlainSelect_1526_6_652()
 {
    if (jj_3R_Offset_2403_5_557()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1525_6_651()
 {
    if (jj_3R_LimitWithOffset_2338_5_556()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1524_6_650()
 {
    if (jj_3R_OrderByElements_2283_5_555()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1523_6_649()
 {
    if (jj_3R_OrderByElements_2283_5_555()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1522_7_648()
 {
    if (jj_3R_Having_2271_5_684()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1521_7_647()
 {
    if (jj_3R_GroupByColumnReferences_2246_5_683()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1520_7_646()
 {
    if (jj_3R_OracleHierarchicalQueryClause_2221_5_682()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1519_7_645()
 {
    if (jj_3R_WhereClause_2211_5_681()) return true;
    return false;
  }

  private boolean jj_3R_SimpleExpression_3054_7_257()
 {
    if (jj_3R_UserVariable_3334_5_175()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(268)) {
    jj_scanpos = xsp;
    if (jj_scan_token(288)) return true;
    }
    return false;
  }

  private boolean jj_3R_PlainSelect_1518_7_644()
 {
    if (jj_3R_KSQLWindowClause_2172_5_680()) return true;
    return false;
  }

  private boolean jj_3R_SimpleExpression_3054_5_115()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SimpleExpression_3054_7_257()) jj_scanpos = xsp;
    if (jj_3R_ConcatExpression_3078_5_258()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1514_7_643()
 {
    if (jj_scan_token(K_FROM)) return true;
    if (jj_3R_FromItem_1946_5_135()) return true;
    if (jj_3R_JoinsList_2073_5_122()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1513_6_642()
 {
    if (jj_3R_IntoClause_1929_5_679()) return true;
    return false;
  }

  private boolean jj_3R_SimpleExpressionListAtLeastTwoItems_2996_57_438()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_SimpleExpression_3054_5_115()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1503_13_130()
 {
    if (jj_scan_token(K_SQL_NO_CACHE)) return true;
    return false;
  }

  private boolean jj_3_32()
 {
    if (jj_3R_Top_2461_5_131()) return true;
    return false;
  }

  private boolean jj_3_30()
 {
    if (jj_scan_token(K_ON)) return true;
    if (jj_scan_token(266)) return true;
    if (jj_3R_SelectItemsList_1637_5_636()) return true;
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1499_13_129()
 {
    if (jj_scan_token(K_SQL_CALC_FOUND_ROWS)) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1495_13_128()
 {
    if (jj_scan_token(K_UNIQUE)) return true;
    return false;
  }

  private boolean jj_3R_AnyComparisonExpression_3040_3_355()
 {
    if (jj_scan_token(K_ANY)) return true;
    return false;
  }

  private boolean jj_3R_AnyComparisonExpression_3040_2_173()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AnyComparisonExpression_3040_3_355()) {
    jj_scanpos = xsp;
    if (jj_3R_AnyComparisonExpression_3040_40_356()) return true;
    }
    if (jj_scan_token(266)) return true;
    if (jj_3R_SubSelect_3865_5_169()) return true;
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1490_13_127()
 {
    if (jj_scan_token(K_DISTINCT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_30()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_AlterExpressionColumnDropNotNull_4565_6_457()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_AlterExpressionColumnDropNotNull_4563_5_382()
 {
    if (jj_3R_RelObjectName_1350_5_133()) return true;
    if (jj_scan_token(K_DROP)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AlterExpressionColumnDropNotNull_4565_6_457()) jj_scanpos = xsp;
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3_31()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(7)) {
    jj_scanpos = xsp;
    if (jj_3R_PlainSelect_1490_13_127()) {
    jj_scanpos = xsp;
    if (jj_3R_PlainSelect_1495_13_128()) {
    jj_scanpos = xsp;
    if (jj_3R_PlainSelect_1499_13_129()) {
    jj_scanpos = xsp;
    if (jj_3R_PlainSelect_1503_13_130()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_AllComparisonExpression_3027_2_432()
 {
    if (jj_scan_token(K_ALL)) return true;
    if (jj_scan_token(266)) return true;
    if (jj_3R_SubSelect_3865_5_169()) return true;
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3_92()
 {
    if (jj_3R_ValueListExpression_3837_5_174()) return true;
    return false;
  }

  private boolean jj_3_29()
 {
    if (jj_3R_First_2524_5_126()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1483_6_641()
 {
    if (jj_3R_Skip_2488_5_678()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1479_7_640()
 {
    if (jj_scan_token(K_STRAIGHT)) return true;
    return false;
  }

  private boolean jj_3R_ComparisonItem_3013_7_338()
 {
    if (jj_3R_RowConstructor_3618_5_433()) return true;
    return false;
  }

  private boolean jj_3R_AlterExpressionColumnDataType_4548_7_456()
 {
    if (jj_3R_CreateParameter_4328_9_386()) return true;
    return false;
  }

  private boolean jj_3_93()
 {
    if (jj_3R_SimpleExpression_3054_5_115()) return true;
    return false;
  }

  private boolean jj_3R_ComparisonItem_3011_7_337()
 {
    if (jj_3R_ValueListExpression_3837_5_174()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1477_5_605()
 {
    if (jj_scan_token(K_SELECT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1479_7_640()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1483_6_641()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_29()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_31()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_32()) jj_scanpos = xsp;
    if (jj_3R_SelectItemsList_1637_5_636()) return true;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1513_6_642()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1514_7_643()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1518_7_644()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1519_7_645()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1520_7_646()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1521_7_647()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1522_7_648()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1523_6_649()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1524_6_650()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1525_6_651()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1526_6_652()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1527_10_653()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1529_6_654()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_40()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1536_6_655()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1538_7_656()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_91()
 {
    if (jj_3R_AnyComparisonExpression_3040_2_173()) return true;
    return false;
  }

  private boolean jj_3R_AlterExpressionColumnDataType_4546_6_380()
 {
    if (jj_scan_token(K_TYPE)) return true;
    return false;
  }

  private boolean jj_3R_AlterExpressionColumnDataType_4545_5_215()
 {
    if (jj_3R_RelObjectName_1350_5_133()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AlterExpressionColumnDataType_4546_6_380()) jj_scanpos = xsp;
    if (jj_3R_ColDataType_4230_5_381()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_AlterExpressionColumnDataType_4548_7_456()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_ComparisonItem_3009_5_336()
 {
    if (jj_3R_AllComparisonExpression_3027_2_432()) return true;
    return false;
  }

  private boolean jj_3R_ComparisonItem_3008_3_158()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ComparisonItem_3009_5_336()) {
    jj_scanpos = xsp;
    if (jj_3_91()) {
    jj_scanpos = xsp;
    if (jj_3R_ComparisonItem_3011_7_337()) {
    jj_scanpos = xsp;
    if (jj_3_93()) {
    jj_scanpos = xsp;
    if (jj_3R_ComparisonItem_3013_7_338()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_NamedExpressionListExprFirst_2975_33_449()
 {
    if (jj_scan_token(K_FOR)) return true;
    if (jj_3R_SimpleExpression_3054_5_115()) return true;
    return false;
  }

  private boolean jj_3R_SimpleExpressionListAtLeastTwoItems_2996_5_357()
 {
    if (jj_3R_SimpleExpression_3054_5_115()) return true;
    Token xsp;
    if (jj_3R_SimpleExpressionListAtLeastTwoItems_2996_57_438()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_SimpleExpressionListAtLeastTwoItems_2996_57_438()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_NamedExpressionListExprFirst_2972_25_375()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(80)) {
    jj_scanpos = xsp;
    if (jj_scan_token(84)) return true;
    }
    if (jj_3R_SimpleExpression_3054_5_115()) return true;
    xsp = jj_scanpos;
    if (jj_3R_NamedExpressionListExprFirst_2975_33_449()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_SelectBody_1445_5_219()
 {
    if (jj_3R_SetOperationList_1564_5_384()) return true;
    return false;
  }

  private boolean jj_3_144()
 {
    if (jj_scan_token(K_IF)) return true;
    if (jj_scan_token(K_EXISTS)) return true;
    return false;
  }

  private boolean jj_3R_TableWithAlias_1425_20_283()
 {
    if (jj_3R_Alias_1690_5_205()) return true;
    return false;
  }

  private boolean jj_3R_Select_1436_7_218()
 {
    if (jj_3R_WithList_1611_5_383()) return true;
    return false;
  }

  private boolean jj_3R_Select_1436_5_100()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Select_1436_7_218()) jj_scanpos = xsp;
    if (jj_3R_SelectBody_1445_5_219()) return true;
    return false;
  }

  private boolean jj_3R_NamedExpressionListExprFirst_2962_9_203()
 {
    if (jj_3R_SimpleExpression_3054_5_115()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(84)) {
    jj_scanpos = xsp;
    if (jj_scan_token(100)) {
    jj_scanpos = xsp;
    if (jj_scan_token(164)) return true;
    }
    }
    if (jj_3R_SimpleExpression_3054_5_115()) return true;
    xsp = jj_scanpos;
    if (jj_3R_NamedExpressionListExprFirst_2972_25_375()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_TableWithAlias_1425_5_121()
 {
    if (jj_3R_Table_1410_5_213()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_TableWithAlias_1425_20_283()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_ComplexExpressionList_2905_51_371()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_Expression_2544_5_199()) return true;
    return false;
  }

  private boolean jj_3R_ColumnsNamesList_4478_12_523()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_ColumnsNamesListItem_4463_9_522()) return true;
    return false;
  }

  private boolean jj_3R_AList_4448_38_687()
 {
    if (jj_scan_token(268)) return true;
    return false;
  }

  private boolean jj_3R_Table_1410_5_213()
 {
    if (jj_3R_RelObjectNameList_1294_5_226()) return true;
    return false;
  }

  private boolean jj_3R_SimpleExpressionList_2891_57_307()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_SimpleExpression_3054_5_115()) return true;
    return false;
  }

  private boolean jj_3R_ColumnsNamesList_4476_5_404()
 {
    if (jj_scan_token(266)) return true;
    if (jj_3R_ColumnsNamesListItem_4463_9_522()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_ColumnsNamesList_4478_12_523()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_IsBooleanExpression_2848_94_344()
 {
    if (jj_scan_token(K_FALSE)) return true;
    return false;
  }

  private boolean jj_3R_ColumnsNamesListItem_4464_11_581()
 {
    if (jj_scan_token(266)) return true;
    if (jj_scan_token(S_LONG)) return true;
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_RelObjectNameExt2_1397_7_285()
 {
    if (jj_3R_RelObjectNameExt_1380_5_147()) return true;
    return false;
  }

  private boolean jj_3R_ColumnsNamesListItem_4463_9_522()
 {
    if (jj_3R_RelObjectName_1350_5_133()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ColumnsNamesListItem_4464_11_581()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_RelObjectNameExt2_1397_5_125()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_RelObjectNameExt2_1397_7_285()) {
    jj_scanpos = xsp;
    if (jj_scan_token(84)) {
    jj_scanpos = xsp;
    if (jj_scan_token(185)) {
    jj_scanpos = xsp;
    if (jj_scan_token(45)) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_NamedExpressionList1_2926_5_630()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(21)) {
    jj_scanpos = xsp;
    if (jj_scan_token(119)) {
    jj_scanpos = xsp;
    if (jj_scan_token(209)) return true;
    }
    }
    if (jj_3R_SimpleExpression_3054_5_115()) return true;
    xsp = jj_scanpos;
    if (jj_scan_token(84)) {
    jj_scanpos = xsp;
    if (jj_scan_token(100)) {
    jj_scanpos = xsp;
    if (jj_scan_token(164)) return true;
    }
    }
    if (jj_3R_SimpleExpression_3054_5_115()) return true;
    return false;
  }

  private boolean jj_3R_AList_4448_10_686()
 {
    if (jj_scan_token(K_COMMA)) return true;
    return false;
  }

  private boolean jj_3R_AList_4448_9_658()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AList_4448_10_686()) {
    jj_scanpos = xsp;
    if (jj_3R_AList_4448_38_687()) return true;
    }
    return false;
  }

  private boolean jj_3R_RelObjectNameExt_1380_7_308()
 {
    if (jj_3R_RelObjectName_1350_5_133()) return true;
    return false;
  }

  private boolean jj_3R_AList_4447_8_610()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(254)) {
    jj_scanpos = xsp;
    if (jj_scan_token(253)) {
    jj_scanpos = xsp;
    if (jj_scan_token(263)) {
    jj_scanpos = xsp;
    if (jj_scan_token(260)) {
    jj_scanpos = xsp;
    if (jj_scan_token(264)) return true;
    }
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_AList_4448_9_658()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_RelObjectNameExt_1380_5_147()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_RelObjectNameExt_1380_7_308()) {
    jj_scanpos = xsp;
    if (jj_scan_token(120)) {
    jj_scanpos = xsp;
    if (jj_scan_token(181)) {
    jj_scanpos = xsp;
    if (jj_scan_token(190)) {
    jj_scanpos = xsp;
    if (jj_scan_token(60)) {
    jj_scanpos = xsp;
    if (jj_scan_token(96)) {
    jj_scanpos = xsp;
    if (jj_scan_token(159)) {
    jj_scanpos = xsp;
    if (jj_scan_token(122)) {
    jj_scanpos = xsp;
    if (jj_scan_token(151)) {
    jj_scanpos = xsp;
    if (jj_scan_token(169)) {
    jj_scanpos = xsp;
    if (jj_scan_token(170)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_AList_4445_6_563()
 {
    if (jj_scan_token(266)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_AList_4447_8_610()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_ComplexExpressionList_2905_5_197()
 {
    if (jj_3R_Expression_2544_5_199()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_ComplexExpressionList_2905_51_371()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_RelObjectNameWithoutStart_1363_6_545()
 {
    if (jj_3R_RelObjectNameWithoutValue_1322_5_415()) return true;
    return false;
  }

  private boolean jj_3R_RowMovement_4433_5_521()
 {
    if (jj_scan_token(K_DISABLE)) return true;
    if (jj_scan_token(K_ROW)) return true;
    if (jj_scan_token(K_MOVEMENT)) return true;
    return false;
  }

  private boolean jj_3R_RelObjectNameWithoutStart_1363_5_450()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_RelObjectNameWithoutStart_1363_6_545()) {
    jj_scanpos = xsp;
    if (jj_scan_token(208)) {
    jj_scanpos = xsp;
    if (jj_scan_token(228)) {
    jj_scanpos = xsp;
    if (jj_scan_token(229)) {
    jj_scanpos = xsp;
    if (jj_scan_token(108)) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_IsBooleanExpression_2848_55_343()
 {
    if (jj_scan_token(K_TRUE)) return true;
    return false;
  }

  private boolean jj_3R_RowMovement_4431_5_520()
 {
    if (jj_scan_token(K_ENABLE)) return true;
    if (jj_scan_token(K_ROW)) return true;
    if (jj_scan_token(K_MOVEMENT)) return true;
    return false;
  }

  private boolean jj_3R_RowMovement_4430_3_395()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_RowMovement_4431_5_520()) {
    jj_scanpos = xsp;
    if (jj_3R_RowMovement_4433_5_521()) return true;
    }
    return false;
  }

  private boolean jj_3R_CreateParameter_4419_13_506()
 {
    if (jj_scan_token(302)) return true;
    if (jj_3R_ColDataType_4230_5_381()) return true;
    return false;
  }

  private boolean jj_3R_SimpleExpressionList_2891_5_146()
 {
    if (jj_3R_SimpleExpression_3054_5_115()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_SimpleExpressionList_2891_57_307()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_IsNullExpression_2834_62_434()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4417_13_505()
 {
    if (jj_scan_token(K_FALSE)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4415_13_504()
 {
    if (jj_scan_token(K_TRUE)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4413_13_503()
 {
    if (jj_scan_token(K_DESC)) return true;
    return false;
  }

  private boolean jj_3R_RelObjectName_1350_6_295()
 {
    if (jj_3R_RelObjectNameWithoutValue_1322_5_415()) return true;
    return false;
  }

  private boolean jj_3R_RelObjectName_1350_5_133()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_RelObjectName_1350_6_295()) {
    jj_scanpos = xsp;
    if (jj_scan_token(90)) {
    jj_scanpos = xsp;
    if (jj_scan_token(108)) {
    jj_scanpos = xsp;
    if (jj_scan_token(152)) {
    jj_scanpos = xsp;
    if (jj_scan_token(156)) {
    jj_scanpos = xsp;
    if (jj_scan_token(198)) {
    jj_scanpos = xsp;
    if (jj_scan_token(208)) {
    jj_scanpos = xsp;
    if (jj_scan_token(228)) {
    jj_scanpos = xsp;
    if (jj_scan_token(229)) {
    jj_scanpos = xsp;
    if (jj_scan_token(43)) {
    jj_scanpos = xsp;
    if (jj_scan_token(201)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_CreateParameter_4411_13_502()
 {
    if (jj_scan_token(K_ASC)) return true;
    return false;
  }

  private boolean jj_3R_IsNullExpression_2834_54_341()
 {
    if (jj_scan_token(K_IS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_IsNullExpression_2834_62_434()) jj_scanpos = xsp;
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4409_13_501()
 {
    if (jj_scan_token(K_COLLATE)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4407_13_500()
 {
    if (jj_scan_token(K_USING)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4405_13_499()
 {
    if (jj_scan_token(K_COMMENT)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4403_13_498()
 {
    if (jj_scan_token(K_TYPE)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4401_13_497()
 {
    if (jj_scan_token(K_IN)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4399_13_496()
 {
    if (jj_scan_token(K_BY)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4397_13_495()
 {
    if (jj_scan_token(K_PARTITION)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4395_13_494()
 {
    if (jj_scan_token(K_TEMPORARY)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4393_13_493()
 {
    if (jj_scan_token(K_TEMP)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4391_13_492()
 {
    if (jj_scan_token(K_UNSIGNED)) return true;
    return false;
  }

  private boolean jj_3R_ExistsExpression_2863_5_594()
 {
    if (jj_scan_token(K_EXISTS)) return true;
    if (jj_3R_SimpleExpression_3054_5_115()) return true;
    return false;
  }

  private boolean jj_3R_IsBooleanExpression_2848_19_342()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4389_13_491()
 {
    if (jj_scan_token(K_WHERE)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4387_13_490()
 {
    if (jj_scan_token(K_EXCLUDE)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4385_13_489()
 {
    if (jj_scan_token(K_WITH)) return true;
    return false;
  }

  private boolean jj_3R_RelObjectNameWithoutValue_1322_5_415()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(260)) {
    jj_scanpos = xsp;
    if (jj_scan_token(264)) {
    jj_scanpos = xsp;
    if (jj_scan_token(25)) {
    jj_scanpos = xsp;
    if (jj_scan_token(33)) {
    jj_scanpos = xsp;
    if (jj_scan_token(31)) {
    jj_scanpos = xsp;
    if (jj_scan_token(30)) {
    jj_scanpos = xsp;
    if (jj_scan_token(29)) {
    jj_scanpos = xsp;
    if (jj_scan_token(39)) {
    jj_scanpos = xsp;
    if (jj_scan_token(56)) {
    jj_scanpos = xsp;
    if (jj_scan_token(54)) {
    jj_scanpos = xsp;
    if (jj_scan_token(59)) {
    jj_scanpos = xsp;
    if (jj_scan_token(74)) {
    jj_scanpos = xsp;
    if (jj_scan_token(77)) {
    jj_scanpos = xsp;
    if (jj_scan_token(79)) {
    jj_scanpos = xsp;
    if (jj_scan_token(117)) {
    jj_scanpos = xsp;
    if (jj_scan_token(126)) {
    jj_scanpos = xsp;
    if (jj_scan_token(147)) {
    jj_scanpos = xsp;
    if (jj_scan_token(160)) {
    jj_scanpos = xsp;
    if (jj_scan_token(171)) {
    jj_scanpos = xsp;
    if (jj_scan_token(182)) {
    jj_scanpos = xsp;
    if (jj_scan_token(183)) {
    jj_scanpos = xsp;
    if (jj_scan_token(193)) {
    jj_scanpos = xsp;
    if (jj_scan_token(240)) {
    jj_scanpos = xsp;
    if (jj_scan_token(35)) {
    jj_scanpos = xsp;
    if (jj_scan_token(178)) {
    jj_scanpos = xsp;
    if (jj_scan_token(210)) {
    jj_scanpos = xsp;
    if (jj_scan_token(115)) {
    jj_scanpos = xsp;
    if (jj_scan_token(12)) {
    jj_scanpos = xsp;
    if (jj_scan_token(154)) {
    jj_scanpos = xsp;
    if (jj_scan_token(158)) {
    jj_scanpos = xsp;
    if (jj_scan_token(162)) {
    jj_scanpos = xsp;
    if (jj_scan_token(168)) {
    jj_scanpos = xsp;
    if (jj_scan_token(188)) {
    jj_scanpos = xsp;
    if (jj_scan_token(136)) {
    jj_scanpos = xsp;
    if (jj_scan_token(2)) {
    jj_scanpos = xsp;
    if (jj_scan_token(27)) {
    jj_scanpos = xsp;
    if (jj_scan_token(65)) {
    jj_scanpos = xsp;
    if (jj_scan_token(200)) {
    jj_scanpos = xsp;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(38)) {
    jj_scanpos = xsp;
    if (jj_scan_token(166)) {
    jj_scanpos = xsp;
    if (jj_scan_token(106)) {
    jj_scanpos = xsp;
    if (jj_scan_token(103)) {
    jj_scanpos = xsp;
    if (jj_scan_token(167)) {
    jj_scanpos = xsp;
    if (jj_scan_token(64)) {
    jj_scanpos = xsp;
    if (jj_scan_token(204)) {
    jj_scanpos = xsp;
    if (jj_scan_token(205)) {
    jj_scanpos = xsp;
    if (jj_scan_token(207)) {
    jj_scanpos = xsp;
    if (jj_scan_token(213)) {
    jj_scanpos = xsp;
    if (jj_scan_token(111)) {
    jj_scanpos = xsp;
    if (jj_scan_token(245)) {
    jj_scanpos = xsp;
    if (jj_scan_token(36)) {
    jj_scanpos = xsp;
    if (jj_scan_token(55)) {
    jj_scanpos = xsp;
    if (jj_scan_token(116)) {
    jj_scanpos = xsp;
    if (jj_scan_token(161)) {
    jj_scanpos = xsp;
    if (jj_scan_token(49)) {
    jj_scanpos = xsp;
    if (jj_scan_token(135)) {
    jj_scanpos = xsp;
    if (jj_scan_token(211)) {
    jj_scanpos = xsp;
    if (jj_scan_token(78)) {
    jj_scanpos = xsp;
    if (jj_scan_token(62)) {
    jj_scanpos = xsp;
    if (jj_scan_token(172)) {
    jj_scanpos = xsp;
    if (jj_scan_token(184)) {
    jj_scanpos = xsp;
    if (jj_scan_token(195)) {
    jj_scanpos = xsp;
    if (jj_scan_token(187)) {
    jj_scanpos = xsp;
    if (jj_scan_token(189)) {
    jj_scanpos = xsp;
    if (jj_scan_token(232)) {
    jj_scanpos = xsp;
    if (jj_scan_token(140)) {
    jj_scanpos = xsp;
    if (jj_scan_token(227)) {
    jj_scanpos = xsp;
    if (jj_scan_token(46)) {
    jj_scanpos = xsp;
    if (jj_scan_token(149)) {
    jj_scanpos = xsp;
    if (jj_scan_token(68)) {
    jj_scanpos = xsp;
    if (jj_scan_token(83)) {
    jj_scanpos = xsp;
    if (jj_scan_token(58)) {
    jj_scanpos = xsp;
    if (jj_scan_token(226)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_CreateParameter_4383_13_488()
 {
    if (jj_scan_token(K_CONSTRAINT)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4381_13_487()
 {
    if (jj_scan_token(K_CHECK)) return true;
    if (jj_scan_token(266)) return true;
    if (jj_3R_Expression_2544_5_199()) return true;
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4379_13_486()
 {
    if (jj_3R_AList_4445_6_563()) return true;
    return false;
  }

  private boolean jj_3R_RelObjectNameList_1295_26_124()
 {
    if (jj_scan_token(270)) return true;
    return false;
  }

  private boolean jj_3R_IsBooleanExpression_2847_9_161()
 {
    if (jj_scan_token(K_IS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_IsBooleanExpression_2848_19_342()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_IsBooleanExpression_2848_55_343()) {
    jj_scanpos = xsp;
    if (jj_3R_IsBooleanExpression_2848_94_344()) return true;
    }
    return false;
  }

  private boolean jj_3R_LikeExpression_2801_54_346()
 {
    if (jj_scan_token(K_ILIKE)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4377_13_485()
 {
    if (jj_scan_token(K_TABLESPACE)) return true;
    if (jj_3R_RelObjectName_1350_5_133()) return true;
    return false;
  }

  private boolean jj_3_143()
 {
    if (jj_scan_token(K_USING)) return true;
    if (jj_scan_token(K_INDEX)) return true;
    if (jj_scan_token(K_TABLESPACE)) return true;
    if (jj_3R_RelObjectName_1350_5_133()) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4349_38_609()
 {
    if (jj_scan_token(286)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4373_13_484()
 {
    if (jj_scan_token(268)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4371_13_483()
 {
    if (jj_scan_token(K_TIME_KEY_EXPR)) return true;
    return false;
  }

  private boolean jj_3R_Column_1307_5_114()
 {
    if (jj_3R_RelObjectNameList_1294_5_226()) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4369_13_482()
 {
    if (jj_scan_token(K_UPDATE)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4367_13_481()
 {
    if (jj_scan_token(K_DELETE)) return true;
    return false;
  }

  private boolean jj_3R_IsNullExpression_2834_10_340()
 {
    if (jj_scan_token(K_ISNULL)) return true;
    return false;
  }

  private boolean jj_3R_IsNullExpression_2834_9_160()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_IsNullExpression_2834_10_340()) {
    jj_scanpos = xsp;
    if (jj_3R_IsNullExpression_2834_54_341()) return true;
    }
    return false;
  }

  private boolean jj_3R_CreateParameter_4365_13_480()
 {
    if (jj_scan_token(K_CASCADE)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4363_13_479()
 {
    if (jj_scan_token(K_UNIQUE)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4361_13_478()
 {
    if (jj_scan_token(K_ROWS)) return true;
    return false;
  }

  private boolean jj_3_28()
 {
    if (jj_scan_token(270)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_RelObjectNameList_1295_26_124()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_RelObjectNameExt2_1397_5_125()) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4359_13_477()
 {
    if (jj_scan_token(K_COMMIT)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4357_13_476()
 {
    if (jj_scan_token(K_ON)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4353_16_562()
 {
    if (jj_scan_token(S_DOUBLE)) return true;
    return false;
  }

  private boolean jj_3R_RelObjectNameList_1294_5_226()
 {
    if (jj_3R_RelObjectNameExt_1380_5_147()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_28()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_CreateParameter_4351_16_561()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4349_16_608()
 {
    if (jj_scan_token(274)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4349_16_560()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateParameter_4349_16_608()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4349_38_609()) return true;
    }
    return false;
  }

  private boolean jj_3R_CreateParameter_4349_15_475()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateParameter_4349_16_560()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateParameter_4351_16_561()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4353_16_562()) return true;
    }
    return false;
  }

  private boolean jj_3R_SimilarToExpression_2820_6_702()
 {
    if (jj_scan_token(K_ESCAPE)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4347_13_474()
 {
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_SimilarToExpression_2817_6_435()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4345_13_473()
 {
    if (jj_scan_token(K_KEY)) return true;
    return false;
  }

  private boolean jj_3R_SimilarToExpression_2817_5_347()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SimilarToExpression_2817_6_435()) jj_scanpos = xsp;
    if (jj_scan_token(K_SIMILAR)) return true;
    if (jj_scan_token(K_TO)) return true;
    if (jj_3R_SimpleExpression_3054_5_115()) return true;
    xsp = jj_scanpos;
    if (jj_3R_SimilarToExpression_2820_6_702()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_CreateParameter_4343_13_472()
 {
    if (jj_scan_token(K_REFERENCES)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4341_13_471()
 {
    if (jj_scan_token(K_FOREIGN)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4339_13_470()
 {
    if (jj_scan_token(K_DEFAULT)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4337_13_469()
 {
    if (jj_scan_token(K_PRIMARY)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4330_18_559()
 {
    if (jj_scan_token(270)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(260)) {
    jj_scanpos = xsp;
    if (jj_scan_token(264)) return true;
    }
    return false;
  }

  private boolean jj_3R_CreateParameter_4335_13_468()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4333_13_467()
 {
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3R_LikeExpression_2802_6_701()
 {
    if (jj_scan_token(K_ESCAPE)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_LikeExpression_2801_6_345()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4329_13_466()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(260)) {
    jj_scanpos = xsp;
    if (jj_scan_token(264)) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_CreateParameter_4330_18_559()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_LikeExpression_2801_5_162()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_LikeExpression_2801_6_345()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(121)) {
    jj_scanpos = xsp;
    if (jj_3R_LikeExpression_2801_54_346()) return true;
    }
    if (jj_3R_SimpleExpression_3054_5_115()) return true;
    xsp = jj_scanpos;
    if (jj_3R_LikeExpression_2802_6_701()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_InExpression_2736_69_172()
 {
    if (jj_3R_SimpleExpressionList_2891_5_146()) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_4328_9_386()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateParameter_4329_13_466()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4333_13_467()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4335_13_468()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4337_13_469()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4339_13_470()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4341_13_471()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4343_13_472()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4345_13_473()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4347_13_474()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4349_15_475()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4357_13_476()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4359_13_477()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4361_13_478()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4363_13_479()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4365_13_480()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4367_13_481()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4369_13_482()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4371_13_483()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4373_13_484()) {
    jj_scanpos = xsp;
    if (jj_3_143()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4377_13_485()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4379_13_486()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4381_13_487()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4383_13_488()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4385_13_489()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4387_13_490()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4389_13_491()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4391_13_492()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4393_13_493()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4395_13_494()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4397_13_495()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4399_13_496()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4401_13_497()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4403_13_498()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4405_13_499()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4407_13_500()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4409_13_501()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4411_13_502()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4413_13_503()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4415_13_504()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4417_13_505()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_4419_13_506()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_ColDataType_4243_90_659()
 {
    if (jj_scan_token(K_COMMA)) return true;
    return false;
  }

  private boolean jj_3R_MergeUpdateClause_1260_3_123()
 {
    if (jj_scan_token(K_WHEN)) return true;
    if (jj_scan_token(K_MATCHED)) return true;
    return false;
  }

  private boolean jj_3R_AlterView_4309_22_251()
 {
    if (jj_scan_token(K_REPLACE)) return true;
    return false;
  }

  private boolean jj_3R_Between_2784_10_339()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_Between_2784_9_159()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Between_2784_10_339()) jj_scanpos = xsp;
    if (jj_scan_token(K_BETWEEN)) return true;
    if (jj_3R_SimpleExpression_3054_5_115()) return true;
    if (jj_scan_token(K_AND)) return true;
    if (jj_3R_SimpleExpression_3054_5_115()) return true;
    return false;
  }

  private boolean jj_3R_AlterView_4311_7_252()
 {
    if (jj_3R_ColumnsNamesList_4476_5_404()) return true;
    return false;
  }

  private boolean jj_3_27()
 {
    if (jj_3R_MergeUpdateClause_1260_3_123()) return true;
    return false;
  }

  private boolean jj_3R_AlterView_4309_5_110()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(8)) {
    jj_scanpos = xsp;
    if (jj_3R_AlterView_4309_22_251()) return true;
    }
    if (jj_scan_token(K_VIEW)) return true;
    if (jj_3R_Table_1410_5_213()) return true;
    xsp = jj_scanpos;
    if (jj_3R_AlterView_4311_7_252()) jj_scanpos = xsp;
    if (jj_scan_token(K_AS)) return true;
    if (jj_3R_SelectBody_1445_5_219()) return true;
    return false;
  }

  private boolean jj_3R_Action_4293_19_689()
 {
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3R_Action_4295_15_690()
 {
    if (jj_scan_token(K_DEFAULT)) return true;
    return false;
  }

  private boolean jj_3R_Delete_1202_31_120()
 {
    if (jj_3R_TableWithAlias_1425_5_121()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_Delete_1203_12_282()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(K_FROM)) return true;
    return false;
  }

  private boolean jj_3_90()
 {
    if (jj_scan_token(267)) return true;
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_scan_token(266)) return true;
    if (jj_3R_SimpleExpressionList_2891_5_146()) return true;
    return false;
  }

  private boolean jj_3R_Action_4292_6_663()
 {
    if (jj_scan_token(K_SET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Action_4293_19_689()) {
    jj_scanpos = xsp;
    if (jj_3R_Action_4295_15_690()) return true;
    }
    return false;
  }

  private boolean jj_3_85()
 {
    if (jj_3R_SubSelect_3865_5_169()) return true;
    return false;
  }

  private boolean jj_3R_Action_4290_6_662()
 {
    if (jj_scan_token(K_NO)) return true;
    if (jj_scan_token(K_ACTION)) return true;
    return false;
  }

  private boolean jj_3R_ColDataType_4242_53_688()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(25)) {
    jj_scanpos = xsp;
    if (jj_scan_token(33)) return true;
    }
    return false;
  }

  private boolean jj_3R_Action_4288_6_661()
 {
    if (jj_scan_token(K_RESTRICT)) return true;
    return false;
  }

  private boolean jj_3R_Action_4286_6_660()
 {
    if (jj_scan_token(K_CASCADE)) return true;
    return false;
  }

  private boolean jj_3R_MultiInExpressions_2754_3_170()
 {
    if (jj_scan_token(266)) return true;
    if (jj_scan_token(266)) return true;
    if (jj_3R_SimpleExpressionList_2891_5_146()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_90()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(267)) return true;
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_Action_4286_5_611()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Action_4286_6_660()) {
    jj_scanpos = xsp;
    if (jj_3R_Action_4288_6_661()) {
    jj_scanpos = xsp;
    if (jj_3R_Action_4290_6_662()) {
    jj_scanpos = xsp;
    if (jj_3R_Action_4292_6_663()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3_25()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Delete_1202_31_120()) {
    jj_scanpos = xsp;
    if (jj_scan_token(84)) return true;
    }
    return false;
  }

  private boolean jj_3R_Delete_1203_12_282()
 {
    if (jj_scan_token(K_COMMA)) return true;
    return false;
  }

  private boolean jj_3R_CreateView_4277_7_250()
 {
    if (jj_scan_token(K_WITH)) return true;
    if (jj_scan_token(K_READ)) return true;
    if (jj_scan_token(K_ONLY)) return true;
    return false;
  }

  private boolean jj_3_26()
 {
    if (jj_3R_TableWithAlias_1425_5_121()) return true;
    if (jj_3R_JoinsList_2073_5_122()) return true;
    return false;
  }

  private boolean jj_3R_InExpression_2737_9_350()
 {
    if (jj_3R_SimpleExpression_3054_5_115()) return true;
    return false;
  }

  private boolean jj_3R_CreateView_4274_7_249()
 {
    if (jj_3R_ColumnsNamesList_4476_5_404()) return true;
    return false;
  }

  private boolean jj_3R_ColDataType_4242_39_379()
 {
    if (jj_scan_token(S_LONG)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ColDataType_4242_53_688()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_CreateView_4270_11_403()
 {
    if (jj_scan_token(K_TEMPORARY)) return true;
    return false;
  }

  private boolean jj_3_89()
 {
    if (jj_scan_token(266)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_85()) {
    jj_scanpos = xsp;
    if (jj_3R_InExpression_2736_69_172()) return true;
    }
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_ColDataType_4242_38_214()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ColDataType_4242_39_379()) {
    jj_scanpos = xsp;
    if (jj_scan_token(263)) {
    jj_scanpos = xsp;
    if (jj_scan_token(260)) return true;
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_ColDataType_4243_90_659()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_88()
 {
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_CreateView_4272_7_248()
 {
    if (jj_scan_token(K_MATERIALIZED)) return true;
    return false;
  }

  private boolean jj_3_83()
 {
    if (jj_3R_SimpleExpressionList_2891_5_146()) return true;
    return false;
  }

  private boolean jj_3_87()
 {
    if (jj_3R_Function_3729_5_171()) return true;
    return false;
  }

  private boolean jj_3R_CreateView_4269_9_247()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateView_4269_9_402()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateView_4270_11_403()) return true;
    }
    return false;
  }

  private boolean jj_3R_CreateView_4269_9_402()
 {
    if (jj_scan_token(K_TEMP)) return true;
    return false;
  }

  private boolean jj_3R_CreateView_4266_11_401()
 {
    if (jj_scan_token(K_FORCE)) return true;
    return false;
  }

  private boolean jj_3_86()
 {
    if (jj_3R_MultiInExpressions_2754_3_170()) return true;
    return false;
  }

  private boolean jj_3R_InExpression_2728_11_436()
 {
    if (jj_scan_token(266)) return true;
    if (jj_scan_token(274)) return true;
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_CreateView_4265_9_246()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateView_4265_9_400()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateView_4266_11_401()) return true;
    }
    return false;
  }

  private boolean jj_3R_CreateView_4265_9_400()
 {
    if (jj_scan_token(K_NO)) return true;
    if (jj_scan_token(K_FORCE)) return true;
    return false;
  }

  private boolean jj_3R_InExpression_2723_15_351()
 {
    if (jj_scan_token(266)) return true;
    if (jj_scan_token(274)) return true;
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3_139()
 {
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_InExpression_2727_9_348()
 {
    if (jj_3R_SimpleExpression_3054_5_115()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_InExpression_2728_11_436()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_InExpression_2730_6_349()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_InExpression_2722_13_168()
 {
    if (jj_3R_SimpleExpression_3054_5_115()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_InExpression_2723_15_351()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_CreateView_4263_7_245()
 {
    if (jj_scan_token(K_OR)) return true;
    if (jj_scan_token(K_REPLACE)) return true;
    return false;
  }

  private boolean jj_3R_InExpression_2720_13_167()
 {
    if (jj_3R_SimpleExpressionList_2891_5_146()) return true;
    return false;
  }

  private boolean jj_3R_CreateView_4262_5_109()
 {
    if (jj_scan_token(K_CREATE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateView_4263_7_245()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateView_4265_9_246()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateView_4269_9_247()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateView_4272_7_248()) jj_scanpos = xsp;
    if (jj_scan_token(K_VIEW)) return true;
    if (jj_3R_Table_1410_5_213()) return true;
    xsp = jj_scanpos;
    if (jj_3R_CreateView_4274_7_249()) jj_scanpos = xsp;
    if (jj_scan_token(K_AS)) return true;
    if (jj_3R_Select_1436_5_100()) return true;
    xsp = jj_scanpos;
    if (jj_3R_CreateView_4277_7_250()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_138()
 {
    if (jj_scan_token(K_PRECISION)) return true;
    return false;
  }

  private boolean jj_3_84()
 {
    if (jj_scan_token(266)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_InExpression_2720_13_167()) {
    jj_scanpos = xsp;
    if (jj_3R_InExpression_2722_13_168()) return true;
    }
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_InExpression_2719_5_166()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_84()) {
    jj_scanpos = xsp;
    if (jj_3R_InExpression_2727_9_348()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_InExpression_2730_6_349()) jj_scanpos = xsp;
    if (jj_scan_token(K_IN)) return true;
    xsp = jj_scanpos;
    if (jj_3_86()) {
    jj_scanpos = xsp;
    if (jj_3_87()) {
    jj_scanpos = xsp;
    if (jj_3_88()) {
    jj_scanpos = xsp;
    if (jj_3_89()) {
    jj_scanpos = xsp;
    if (jj_3R_InExpression_2737_9_350()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_77()
 {
    if (jj_3R_Between_2784_9_159()) return true;
    return false;
  }

  private boolean jj_3R_ColDataType_4239_19_455()
 {
    if (jj_scan_token(K_SIGNED)) return true;
    return false;
  }

  private boolean jj_3_140()
 {
    if (jj_scan_token(K_SIGNED)) return true;
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3_79()
 {
    if (jj_3R_IsBooleanExpression_2847_9_161()) return true;
    return false;
  }

  private boolean jj_3_78()
 {
    if (jj_3R_IsNullExpression_2834_9_160()) return true;
    return false;
  }

  private boolean jj_3R_ColDataType_4236_19_454()
 {
    if (jj_scan_token(K_UNSIGNED)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_139()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_ColDataType_4244_8_604()
 {
    if (jj_scan_token(300)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(254)) jj_scanpos = xsp;
    if (jj_scan_token(301)) return true;
    return false;
  }

  private boolean jj_3R_ColDataType_4233_19_453()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(260)) {
    jj_scanpos = xsp;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(49)) {
    jj_scanpos = xsp;
    if (jj_scan_token(240)) {
    jj_scanpos = xsp;
    if (jj_scan_token(108)) {
    jj_scanpos = xsp;
    if (jj_scan_token(252)) {
    jj_scanpos = xsp;
    if (jj_scan_token(33)) {
    jj_scanpos = xsp;
    if (jj_scan_token(190)) {
    jj_scanpos = xsp;
    if (jj_scan_token(19)) {
    jj_scanpos = xsp;
    if (jj_scan_token(113)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_142()
 {
    if (jj_scan_token(K_CHARACTER)) return true;
    if (jj_scan_token(K_SET)) return true;
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_ColDataType_4232_19_452()
 {
    if (jj_scan_token(K_DOUBLE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_138()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_ColDataType_4244_6_546()
 {
    Token xsp;
    if (jj_3R_ColDataType_4244_8_604()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_ColDataType_4244_8_604()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_SQLCondition_2701_12_165()
 {
    if (jj_3R_SimilarToExpression_2817_5_347()) return true;
    return false;
  }

  private boolean jj_3_141()
 {
    if (jj_scan_token(266)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_ColDataType_4242_38_214()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_ColDataType_4231_17_451()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(30)) {
    jj_scanpos = xsp;
    if (jj_scan_token(20)) return true;
    }
    xsp = jj_scanpos;
    if (jj_scan_token(230)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_80()
 {
    if (jj_3R_LikeExpression_2801_5_162()) return true;
    return false;
  }

  private boolean jj_3_82()
 {
    if (jj_3R_InExpression_2719_5_166()) return true;
    return false;
  }

  private boolean jj_3R_SQLCondition_2699_12_164()
 {
    if (jj_3R_IsBooleanExpression_2847_9_161()) return true;
    return false;
  }

  private boolean jj_3R_SQLCondition_2698_12_163()
 {
    if (jj_3R_IsNullExpression_2834_9_160()) return true;
    return false;
  }

  private boolean jj_3_81()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_77()) {
    jj_scanpos = xsp;
    if (jj_3R_SQLCondition_2698_12_163()) {
    jj_scanpos = xsp;
    if (jj_3R_SQLCondition_2699_12_164()) {
    jj_scanpos = xsp;
    if (jj_3_80()) {
    jj_scanpos = xsp;
    if (jj_3R_SQLCondition_2701_12_165()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_SQLCondition_2696_7_536()
 {
    if (jj_3R_SimpleExpression_3054_5_115()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_81()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_SQLCondition_2695_7_535()
 {
    if (jj_3R_InExpression_2719_5_166()) return true;
    return false;
  }

  private boolean jj_3_23()
 {
    if (jj_scan_token(266)) return true;
    if (jj_3R_Select_1436_5_100()) return true;
    return false;
  }

  private boolean jj_3R_ColDataType_4230_5_381()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ColDataType_4231_17_451()) {
    jj_scanpos = xsp;
    if (jj_3R_ColDataType_4232_19_452()) {
    jj_scanpos = xsp;
    if (jj_3R_ColDataType_4233_19_453()) {
    jj_scanpos = xsp;
    if (jj_3R_ColDataType_4236_19_454()) {
    jj_scanpos = xsp;
    if (jj_3_140()) {
    jj_scanpos = xsp;
    if (jj_3R_ColDataType_4239_19_455()) return true;
    }
    }
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3_141()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_ColDataType_4244_6_546()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_142()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_SQLCondition_2694_5_534()
 {
    if (jj_3R_ExistsExpression_2863_5_594()) return true;
    return false;
  }

  private boolean jj_3R_SQLCondition_2693_5_429()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SQLCondition_2694_5_534()) {
    jj_scanpos = xsp;
    if (jj_3R_SQLCondition_2695_7_535()) {
    jj_scanpos = xsp;
    if (jj_3R_SQLCondition_2696_7_536()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_Upsert_1139_23_119()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(229)) {
    jj_scanpos = xsp;
    if (jj_scan_token(228)) return true;
    }
    return false;
  }

  private boolean jj_3_137()
 {
    if (jj_scan_token(266)) return true;
    if (jj_3R_Table_1410_5_213()) return true;
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_4205_20_399()
 {
    if (jj_3R_Table_1410_5_213()) return true;
    return false;
  }

  private boolean jj_3_136()
 {
    if (jj_scan_token(266)) return true;
    if (jj_3R_Select_1436_5_100()) return true;
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_4204_16_398()
 {
    if (jj_scan_token(266)) return true;
    if (jj_3R_Table_1410_5_213()) return true;
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3_24()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Upsert_1139_23_119()) jj_scanpos = xsp;
    if (jj_scan_token(266)) return true;
    if (jj_3R_SimpleExpression_3054_5_115()) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_4201_16_397()
 {
    if (jj_3R_Select_1436_5_100()) return true;
    return false;
  }

  private boolean jj_3_22()
 {
    if (jj_scan_token(266)) return true;
    if (jj_3R_Column_1307_5_114()) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_4200_14_396()
 {
    if (jj_scan_token(266)) return true;
    if (jj_3R_Select_1436_5_100()) return true;
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_2665_9_334()
 {
    if (jj_3R_ComparisonItem_3008_3_158()) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_2667_7_335()
 {
    if (jj_scan_token(266)) return true;
    if (jj_scan_token(274)) return true;
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_4204_5_244()
 {
    if (jj_scan_token(K_LIKE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateTable_4204_16_398()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateTable_4205_20_399()) return true;
    }
    return false;
  }

  private boolean jj_3R_CreateTable_4193_15_394()
 {
    if (jj_3R_CreateParameter_4328_9_386()) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_2661_11_333()
 {
    if (jj_scan_token(287)) return true;
    return false;
  }

  private boolean jj_3_76()
 {
    if (jj_scan_token(K_PRIOR)) return true;
    if (jj_3R_ComparisonItem_3008_3_158()) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_2660_11_332()
 {
    if (jj_scan_token(286)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_2659_11_331()
 {
    if (jj_scan_token(OP_CONCAT)) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_4198_7_242()
 {
    if (jj_3R_RowMovement_4430_3_395()) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_4200_5_243()
 {
    if (jj_scan_token(K_AS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateTable_4200_14_396()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateTable_4201_16_397()) return true;
    }
    return false;
  }

  private boolean jj_3R_RegularCondition_2658_11_330()
 {
    if (jj_scan_token(285)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_2657_11_329()
 {
    if (jj_scan_token(284)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_2648_20_430()
 {
    if (jj_scan_token(K_BINARY)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_2649_19_431()
 {
    if (jj_scan_token(K_BINARY)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_2656_11_328()
 {
    if (jj_scan_token(271)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_2655_11_327()
 {
    if (jj_scan_token(283)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_2654_11_326()
 {
    if (jj_scan_token(282)) return true;
    return false;
  }

  private boolean jj_3R_Condition_2614_45_156()
 {
    if (jj_scan_token(273)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_2652_7_325()
 {
    if (jj_scan_token(281)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_2651_7_324()
 {
    if (jj_scan_token(280)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_2650_7_323()
 {
    if (jj_scan_token(279)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_2649_7_322()
 {
    if (jj_scan_token(K_RLIKE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_RegularCondition_2649_19_431()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_RegularCondition_2648_7_321()
 {
    if (jj_scan_token(K_REGEXP)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_RegularCondition_2648_20_430()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_RegularCondition_2647_7_320()
 {
    if (jj_scan_token(278)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_2646_7_319()
 {
    if (jj_scan_token(277)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_2645_7_318()
 {
    if (jj_scan_token(OP_NOTEQUALSBANG)) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_4160_26_580()
 {
    if (jj_scan_token(266)) return true;
    if (jj_3R_Expression_2544_5_199()) return true;
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_2644_7_317()
 {
    if (jj_scan_token(OP_NOTEQUALSSTANDARD)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_2643_7_316()
 {
    if (jj_scan_token(OP_MINORTHANEQUALS)) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_4152_33_212()
 {
    if (jj_scan_token(266)) return true;
    if (jj_3R_Expression_2544_5_199()) return true;
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_2642_7_315()
 {
    if (jj_scan_token(OP_GREATERTHANEQUALS)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_2641_7_314()
 {
    if (jj_scan_token(268)) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_4165_17_519()
 {
    if (jj_3R_ColumnDefinition_3954_5_392()) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_2640_7_313()
 {
    if (jj_scan_token(276)) return true;
    return false;
  }

  private boolean jj_3_75()
 {
    if (jj_scan_token(275)) return true;
    return false;
  }

  private boolean jj_3_135()
 {
    if (jj_scan_token(K_EXCLUDE)) return true;
    if (jj_scan_token(K_WHERE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_CreateTable_4160_26_580()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_RegularCondition_2636_7_312()
 {
    if (jj_scan_token(266)) return true;
    if (jj_scan_token(274)) return true;
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3_74()
 {
    if (jj_scan_token(K_PRIOR)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_2633_5_157()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_74()) jj_scanpos = xsp;
    if (jj_3R_ComparisonItem_3008_3_158()) return true;
    xsp = jj_scanpos;
    if (jj_3R_RegularCondition_2636_7_312()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_75()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_2640_7_313()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_2641_7_314()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_2642_7_315()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_2643_7_316()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_2644_7_317()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_2645_7_318()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_2646_7_319()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_2647_7_320()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_2648_7_321()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_2649_7_322()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_2650_7_323()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_2651_7_324()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_2652_7_325()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_2654_11_326()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_2655_11_327()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_2656_11_328()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_2657_11_329()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_2658_11_330()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_2659_11_331()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_2660_11_332()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_2661_11_333()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3_76()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_2665_9_334()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_RegularCondition_2667_7_335()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_CreateTable_4150_22_211()
 {
    if (jj_scan_token(K_CONSTRAINT)) return true;
    if (jj_3R_RelObjectName_1350_5_133()) return true;
    return false;
  }

  private boolean jj_3R_Condition_2614_21_155()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3_73()
 {
    if (jj_3R_RegularCondition_2633_5_157()) return true;
    return false;
  }

  private boolean jj_3_134()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateTable_4150_22_211()) jj_scanpos = xsp;
    if (jj_scan_token(K_CHECK)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_CreateTable_4152_33_212()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_AndExpression_2592_39_677()
 {
    if (jj_scan_token(273)) return true;
    return false;
  }

  private boolean jj_3R_Condition_2617_11_311()
 {
    if (jj_3R_SQLCondition_2693_5_429()) return true;
    return false;
  }

  private boolean jj_3_129()
 {
    if (jj_scan_token(K_ON)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(53)) {
    jj_scanpos = xsp;
    if (jj_scan_token(219)) return true;
    }
    if (jj_3R_Action_4286_5_611()) return true;
    return false;
  }

  private boolean jj_3R_Condition_2616_9_310()
 {
    if (jj_3R_RegularCondition_2633_5_157()) return true;
    return false;
  }

  private boolean jj_3_128()
 {
    if (jj_scan_token(K_ON)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(53)) {
    jj_scanpos = xsp;
    if (jj_scan_token(219)) return true;
    }
    if (jj_3R_Action_4286_5_611()) return true;
    return false;
  }

  private boolean jj_3_72()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Condition_2614_21_155()) {
    jj_scanpos = xsp;
    if (jj_3R_Condition_2614_45_156()) return true;
    }
    return false;
  }

  private boolean jj_3R_Condition_2614_5_154()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_72()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_Condition_2616_9_310()) {
    jj_scanpos = xsp;
    if (jj_3R_Condition_2617_11_311()) return true;
    }
    return false;
  }

  private boolean jj_3R_AndExpression_2580_35_638()
 {
    if (jj_scan_token(273)) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_4128_22_210()
 {
    if (jj_scan_token(K_CONSTRAINT)) return true;
    if (jj_3R_RelObjectName_1350_5_133()) return true;
    return false;
  }

  private boolean jj_3R_AndExpression_2587_21_601()
 {
    if (jj_scan_token(K_AND_OPERATOR)) return true;
    return false;
  }

  private boolean jj_3_71()
 {
    if (jj_3R_Condition_2614_5_154()) return true;
    return false;
  }

  private boolean jj_3R_AndExpression_2592_15_676()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_AndExpression_2592_15_639()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AndExpression_2592_15_676()) {
    jj_scanpos = xsp;
    if (jj_3R_AndExpression_2592_39_677()) return true;
    }
    return false;
  }

  private boolean jj_3_133()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateTable_4128_22_210()) jj_scanpos = xsp;
    if (jj_scan_token(K_FOREIGN)) return true;
    if (jj_scan_token(K_KEY)) return true;
    if (jj_3R_ColumnNamesWithParamsList_3880_6_206()) return true;
    if (jj_scan_token(K_REFERENCES)) return true;
    if (jj_3R_Table_1410_5_213()) return true;
    if (jj_3R_ColumnsNamesList_4476_5_404()) return true;
    xsp = jj_scanpos;
    if (jj_3_128()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_129()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_AndExpression_2592_13_603()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AndExpression_2592_15_639()) jj_scanpos = xsp;
    if (jj_scan_token(266)) return true;
    if (jj_3R_OrExpression_2554_5_374()) return true;
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_4113_27_579()
 {
    if (jj_3R_CreateParameter_4328_9_386()) return true;
    return false;
  }

  private boolean jj_3R_AndExpression_2589_9_602()
 {
    if (jj_3R_Condition_2614_5_154()) return true;
    return false;
  }

  private boolean jj_3_70()
 {
    if (jj_3R_Condition_2614_5_154()) return true;
    return false;
  }

  private boolean jj_3R_AndExpression_2586_9_544()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(10)) {
    jj_scanpos = xsp;
    if (jj_3R_AndExpression_2587_21_601()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_AndExpression_2589_9_602()) {
    jj_scanpos = xsp;
    if (jj_3R_AndExpression_2592_13_603()) return true;
    }
    return false;
  }

  private boolean jj_3R_CreateTable_4101_27_578()
 {
    if (jj_3R_CreateParameter_4328_9_386()) return true;
    return false;
  }

  private boolean jj_3_20()
 {
    if (jj_scan_token(266)) return true;
    if (jj_3R_Select_1436_5_100()) return true;
    return false;
  }

  private boolean jj_3R_AndExpression_2580_11_637()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_AndExpression_2580_11_600()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AndExpression_2580_11_637()) {
    jj_scanpos = xsp;
    if (jj_3R_AndExpression_2580_35_638()) return true;
    }
    return false;
  }

  private boolean jj_3_132()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(216)) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(86)) jj_scanpos = xsp;
    if (jj_scan_token(K_KEY)) return true;
    if (jj_3R_RelObjectName_1350_5_133()) return true;
    if (jj_3R_ColumnNamesWithParamsList_3880_6_206()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_CreateTable_4113_27_579()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_AndExpression_2580_9_543()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AndExpression_2580_11_600()) jj_scanpos = xsp;
    if (jj_scan_token(266)) return true;
    if (jj_3R_OrExpression_2554_5_374()) return true;
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_Insert_1029_23_118()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(229)) {
    jj_scanpos = xsp;
    if (jj_scan_token(228)) return true;
    }
    return false;
  }

  private boolean jj_3R_AndExpression_2577_9_542()
 {
    if (jj_3R_Condition_2614_5_154()) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_4097_24_209()
 {
    if (jj_scan_token(K_UNIQUE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(115)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_CreateTable_4096_22_208()
 {
    if (jj_scan_token(K_PRIMARY)) return true;
    if (jj_scan_token(K_KEY)) return true;
    return false;
  }

  private boolean jj_3R_AndExpression_2576_5_447()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AndExpression_2577_9_542()) {
    jj_scanpos = xsp;
    if (jj_3R_AndExpression_2580_9_543()) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_AndExpression_2586_9_544()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_CreateTable_4094_22_207()
 {
    if (jj_scan_token(K_CONSTRAINT)) return true;
    if (jj_3R_RelObjectName_1350_5_133()) return true;
    return false;
  }

  private boolean jj_3_21()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Insert_1029_23_118()) jj_scanpos = xsp;
    if (jj_scan_token(266)) return true;
    if (jj_3R_SimpleExpression_3054_5_115()) return true;
    return false;
  }

  private boolean jj_3_131()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateTable_4094_22_207()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateTable_4096_22_208()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateTable_4097_24_209()) return true;
    }
    if (jj_3R_ColumnNamesWithParamsList_3880_6_206()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_CreateTable_4101_27_578()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_19()
 {
    if (jj_scan_token(266)) return true;
    if (jj_3R_Column_1307_5_114()) return true;
    return false;
  }

  private boolean jj_3R_OrExpression_2556_9_448()
 {
    if (jj_scan_token(K_OR)) return true;
    if (jj_3R_AndExpression_2576_5_447()) return true;
    return false;
  }

  private boolean jj_3_68()
 {
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3_130()
 {
    if (jj_scan_token(K_INDEX)) return true;
    if (jj_3R_RelObjectName_1350_5_133()) return true;
    if (jj_3R_ColumnNamesWithParamsList_3880_6_206()) return true;
    return false;
  }

  private boolean jj_3R_OrExpression_2554_5_374()
 {
    if (jj_3R_AndExpression_2576_5_447()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_OrExpression_2556_9_448()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_CreateTable_4076_13_393()
 {
    if (jj_scan_token(K_COMMA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_130()) {
    jj_scanpos = xsp;
    if (jj_3_131()) {
    jj_scanpos = xsp;
    if (jj_3_132()) {
    jj_scanpos = xsp;
    if (jj_3_133()) {
    jj_scanpos = xsp;
    if (jj_3_134()) {
    jj_scanpos = xsp;
    if (jj_3_135()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateTable_4165_17_519()) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_Expression_2544_5_199()
 {
    if (jj_3R_OrExpression_2554_5_374()) return true;
    return false;
  }

  private boolean jj_3R_First_2530_19_290()
 {
    if (jj_3R_SimpleJdbcParameter_2313_5_309()) return true;
    return false;
  }

  private boolean jj_3R_First_2529_19_289()
 {
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_4070_9_241()
 {
    if (jj_scan_token(266)) return true;
    if (jj_3R_ColumnDefinition_3954_5_392()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_CreateTable_4076_13_393()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(267)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_CreateTable_4193_15_394()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_First_2525_16_287()
 {
    if (jj_scan_token(K_LIMIT)) return true;
    return false;
  }

  private boolean jj_3_127()
 {
    if (jj_scan_token(K_IF)) return true;
    if (jj_scan_token(K_NOT)) return true;
    if (jj_scan_token(K_EXISTS)) return true;
    return false;
  }

  private boolean jj_3R_First_2528_10_288()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_4064_6_240()
 {
    if (jj_3R_CreateParameter_4328_9_386()) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_4060_7_239()
 {
    if (jj_scan_token(K_GLOBAL)) return true;
    return false;
  }

  private boolean jj_3R_First_2524_7_286()
 {
    if (jj_scan_token(K_FIRST)) return true;
    return false;
  }

  private boolean jj_3R_First_2524_5_126()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_First_2524_7_286()) {
    jj_scanpos = xsp;
    if (jj_3R_First_2525_16_287()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_First_2528_10_288()) {
    jj_scanpos = xsp;
    if (jj_3R_First_2529_19_289()) {
    jj_scanpos = xsp;
    if (jj_3R_First_2530_19_290()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_CreateTable_4057_7_238()
 {
    if (jj_scan_token(K_UNLOGGED)) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_4056_5_108()
 {
    if (jj_scan_token(K_CREATE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateTable_4057_7_238()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateTable_4060_7_239()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_CreateTable_4064_6_240()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(K_TABLE)) return true;
    xsp = jj_scanpos;
    if (jj_3_127()) jj_scanpos = xsp;
    if (jj_3R_Table_1410_5_213()) return true;
    xsp = jj_scanpos;
    if (jj_3R_CreateTable_4070_9_241()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateTable_4198_7_242()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateTable_4200_5_243()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateTable_4204_5_244()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_Replace_961_21_385()
 {
    if (jj_3R_SubSelect_3865_5_169()) return true;
    return false;
  }

  private boolean jj_3R_Replace_949_31_116()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(229)) {
    jj_scanpos = xsp;
    if (jj_scan_token(228)) return true;
    }
    return false;
  }

  private boolean jj_3R_Skip_2492_19_710()
 {
    if (jj_3R_SimpleJdbcParameter_2313_5_309()) return true;
    return false;
  }

  private boolean jj_3R_Skip_2491_19_709()
 {
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3_18()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Replace_949_31_116()) jj_scanpos = xsp;
    if (jj_scan_token(266)) return true;
    if (jj_3R_PrimaryExpression_3217_5_117()) return true;
    return false;
  }

  private boolean jj_3R_Skip_2490_10_708()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3_17()
 {
    if (jj_scan_token(266)) return true;
    if (jj_3R_Column_1307_5_114()) return true;
    return false;
  }

  private boolean jj_3R_Skip_2488_5_678()
 {
    if (jj_scan_token(K_SKIP)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Skip_2490_10_708()) {
    jj_scanpos = xsp;
    if (jj_3R_Skip_2491_19_709()) {
    jj_scanpos = xsp;
    if (jj_3R_Skip_2492_19_710()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_PathSpecification_4018_10_508()
 {
    if (jj_scan_token(K_COMMA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(260)) {
    jj_scanpos = xsp;
    if (jj_scan_token(264)) return true;
    }
    return false;
  }

  private boolean jj_3R_Replace_946_9_221()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_17()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_18()) {
    jj_scanpos = xsp;
    if (jj_3R_Replace_961_21_385()) return true;
    }
    return false;
  }

  private boolean jj_3_16()
 {
    if (jj_scan_token(K_INTO)) return true;
    return false;
  }

  private boolean jj_3R_PathSpecification_4017_5_389()
 {
    if (jj_scan_token(K_PATH)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(260)) {
    jj_scanpos = xsp;
    if (jj_scan_token(264)) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_PathSpecification_4018_10_508()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_69()
 {
    if (jj_scan_token(K_PERCENT)) return true;
    return false;
  }

  private boolean jj_3R_Replace_937_9_220()
 {
    if (jj_scan_token(K_SET)) return true;
    return false;
  }

  private boolean jj_3R_Top_2470_8_294()
 {
    if (jj_scan_token(266)) return true;
    if (jj_3R_AdditiveExpression_3133_5_360()) return true;
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_Offset_2410_66_671()
 {
    if (jj_scan_token(K_ROW)) return true;
    return false;
  }

  private boolean jj_3R_Top_2468_8_293()
 {
    if (jj_scan_token(272)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_68()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_Top_2465_10_292()
 {
    if (jj_3R_SimpleJdbcParameter_2313_5_309()) return true;
    return false;
  }

  private boolean jj_3R_CreateSchema_3999_11_390()
 {
    if (jj_3R_CreateView_4262_5_109()) return true;
    return false;
  }

  private boolean jj_3R_Replace_934_5_101()
 {
    if (jj_scan_token(K_REPLACE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_16()) jj_scanpos = xsp;
    if (jj_3R_Table_1410_5_213()) return true;
    xsp = jj_scanpos;
    if (jj_3R_Replace_937_9_220()) {
    jj_scanpos = xsp;
    if (jj_3R_Replace_946_9_221()) return true;
    }
    return false;
  }

  private boolean jj_3R_Top_2463_10_291()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_CreateSchema_3993_9_232()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_126()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateSchema_3999_11_390()) return true;
    }
    return false;
  }

  private boolean jj_3_126()
 {
    if (jj_3R_CreateTable_4056_5_108()) return true;
    return false;
  }

  private boolean jj_3R_Top_2461_5_131()
 {
    if (jj_scan_token(K_TOP)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Top_2463_10_291()) {
    jj_scanpos = xsp;
    if (jj_3R_Top_2465_10_292()) {
    jj_scanpos = xsp;
    if (jj_3R_Top_2468_8_293()) {
    jj_scanpos = xsp;
    if (jj_3R_Top_2470_8_294()) return true;
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3_69()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_CreateSchema_3990_6_231()
 {
    if (jj_3R_PathSpecification_4017_5_389()) return true;
    return false;
  }

  private boolean jj_3R_CreateSchema_3984_7_230()
 {
    if (jj_scan_token(K_AUTHORIZATION)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(260)) {
    jj_scanpos = xsp;
    if (jj_scan_token(264)) return true;
    }
    return false;
  }

  private boolean jj_3R_CreateSchema_3983_7_229()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(260)) {
    jj_scanpos = xsp;
    if (jj_scan_token(264)) return true;
    }
    return false;
  }

  private boolean jj_3R_CreateSchema_3982_5_105()
 {
    if (jj_scan_token(K_CREATE)) return true;
    if (jj_scan_token(K_SCHEMA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateSchema_3983_7_229()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateSchema_3984_7_230()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateSchema_3990_6_231()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_CreateSchema_3993_9_232()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_OptimizeFor_2446_5_685()
 {
    if (jj_scan_token(K_OPTIMIZE)) return true;
    if (jj_scan_token(K_FOR)) return true;
    if (jj_scan_token(S_LONG)) return true;
    if (jj_scan_token(K_ROWS)) return true;
    return false;
  }

  private boolean jj_3R_Fetch_2431_19_624()
 {
    if (jj_scan_token(K_ROWS)) return true;
    return false;
  }

  private boolean jj_3R_Fetch_2430_20_623()
 {
    if (jj_3R_SimpleJdbcParameter_2313_5_309()) return true;
    return false;
  }

  private boolean jj_3R_Fetch_2429_19_622()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_Fetch_2428_20_621()
 {
    if (jj_scan_token(K_FIRST)) return true;
    return false;
  }

  private boolean jj_3_67()
 {
    if (jj_3R_RelObjectNameExt_1380_5_147()) return true;
    return false;
  }

  private boolean jj_3R_Offset_2410_20_670()
 {
    if (jj_scan_token(K_ROWS)) return true;
    return false;
  }

  private boolean jj_3R_Fetch_2425_5_558()
 {
    if (jj_scan_token(K_FETCH)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Fetch_2428_20_621()) {
    jj_scanpos = xsp;
    if (jj_scan_token(134)) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_Fetch_2429_19_622()) {
    jj_scanpos = xsp;
    if (jj_3R_Fetch_2430_20_623()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_Fetch_2431_19_624()) {
    jj_scanpos = xsp;
    if (jj_scan_token(182)) return true;
    }
    if (jj_scan_token(K_ONLY)) return true;
    return false;
  }

  private boolean jj_3R_ColumnDefinition_3958_7_518()
 {
    if (jj_3R_CreateParameter_4328_9_386()) return true;
    return false;
  }

  private boolean jj_3_65()
 {
    if (jj_3R_RelObjectNameExt_1380_5_147()) return true;
    return false;
  }

  private boolean jj_3R_Offset_2410_19_620()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Offset_2410_20_670()) {
    jj_scanpos = xsp;
    if (jj_3R_Offset_2410_66_671()) return true;
    }
    return false;
  }

  private boolean jj_3R_Offset_2409_20_619()
 {
    if (jj_3R_SimpleJdbcNamedParameter_2324_5_669()) return true;
    return false;
  }

  private boolean jj_3R_Offset_2408_20_618()
 {
    if (jj_3R_SimpleJdbcParameter_2313_5_309()) return true;
    return false;
  }

  private boolean jj_3R_Offset_2407_19_617()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3_64()
 {
    if (jj_3R_RelObjectNameExt_1380_5_147()) return true;
    return false;
  }

  private boolean jj_3R_ColumnDefinition_3954_5_392()
 {
    if (jj_3R_RelObjectName_1350_5_133()) return true;
    if (jj_3R_ColDataType_4230_5_381()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_ColumnDefinition_3958_7_518()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_15()
 {
    if (jj_3R_Column_1307_5_114()) return true;
    if (jj_scan_token(268)) return true;
    if (jj_3R_SimpleExpression_3054_5_115()) return true;
    return false;
  }

  private boolean jj_3R_Offset_2403_5_557()
 {
    if (jj_scan_token(K_OFFSET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Offset_2407_19_617()) {
    jj_scanpos = xsp;
    if (jj_3R_Offset_2408_20_618()) {
    jj_scanpos = xsp;
    if (jj_3R_Offset_2409_20_619()) return true;
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_Offset_2410_19_620()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_CreateIndex_3936_7_228()
 {
    if (jj_3R_CreateParameter_4328_9_386()) return true;
    return false;
  }

  private boolean jj_3R_Values_846_26_664()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_PrimaryExpression_3217_5_117()) return true;
    return false;
  }

  private boolean jj_3R_ShowTables_817_53_408()
 {
    if (jj_scan_token(K_WHERE)) return true;
    if (jj_3R_Expression_2544_5_199()) return true;
    return false;
  }

  private boolean jj_3R_CreateIndex_3932_7_227()
 {
    if (jj_scan_token(K_USING)) return true;
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_PlainLimit_2387_10_700()
 {
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3R_PlainLimit_2385_10_699()
 {
    if (jj_scan_token(K_ALL)) return true;
    return false;
  }

  private boolean jj_3R_PlainLimit_2383_9_698()
 {
    if (jj_scan_token(272)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_67()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_CreateIndex_3920_7_225()
 {
    if (jj_3R_CreateParameter_4328_9_386()) return true;
    return false;
  }

  private boolean jj_3R_PlainLimit_2381_10_697()
 {
    if (jj_3R_SimpleJdbcParameter_2313_5_309()) return true;
    return false;
  }

  private boolean jj_3R_PlainLimit_2379_10_696()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_CreateIndex_3919_5_104()
 {
    if (jj_scan_token(K_CREATE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateIndex_3920_7_225()) jj_scanpos = xsp;
    if (jj_scan_token(K_INDEX)) return true;
    if (jj_3R_RelObjectNameList_1294_5_226()) return true;
    if (jj_scan_token(K_ON)) return true;
    if (jj_3R_Table_1410_5_213()) return true;
    xsp = jj_scanpos;
    if (jj_3R_CreateIndex_3932_7_227()) jj_scanpos = xsp;
    if (jj_3R_ColumnNamesWithParamsList_3880_6_206()) return true;
    xsp = jj_scanpos;
    if (jj_3R_CreateIndex_3936_7_228()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_Values_843_5_606()
 {
    if (jj_scan_token(K_VALUES)) return true;
    if (jj_scan_token(266)) return true;
    if (jj_3R_PrimaryExpression_3217_5_117()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_Values_846_26_664()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_PlainLimit_2376_5_657()
 {
    if (jj_scan_token(K_LIMIT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainLimit_2379_10_696()) {
    jj_scanpos = xsp;
    if (jj_3R_PlainLimit_2381_10_697()) {
    jj_scanpos = xsp;
    if (jj_3R_PlainLimit_2383_9_698()) {
    jj_scanpos = xsp;
    if (jj_3R_PlainLimit_2385_10_699()) {
    jj_scanpos = xsp;
    if (jj_3R_PlainLimit_2387_10_700()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_LimitWithOffset_2357_18_153()
 {
    if (jj_scan_token(272)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_65()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_LimitWithOffset_2360_13_607()
 {
    if (jj_3R_PlainLimit_2376_5_657()) return true;
    return false;
  }

  private boolean jj_3R_LimitWithOffset_2355_18_152()
 {
    if (jj_3R_SimpleJdbcParameter_2313_5_309()) return true;
    return false;
  }

  private boolean jj_3R_LimitWithOffset_2347_26_150()
 {
    if (jj_scan_token(272)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_64()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_LimitWithOffset_2345_26_149()
 {
    if (jj_3R_SimpleJdbcParameter_2313_5_309()) return true;
    return false;
  }

  private boolean jj_3R_ColumnNamesWithParamsList_3894_11_507()
 {
    if (jj_3R_CreateParameter_4328_9_386()) return true;
    return false;
  }

  private boolean jj_3R_LimitWithOffset_2353_17_151()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_LimitWithOffset_2343_26_148()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_ColumnNamesWithParamsList_3890_9_388()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_RelObjectName_1350_5_133()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ColumnNamesWithParamsList_3894_11_507()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_ShowTables_817_6_407()
 {
    if (jj_scan_token(K_LIKE)) return true;
    if (jj_3R_SimpleExpression_3054_5_115()) return true;
    return false;
  }

  private boolean jj_3R_ShowTables_817_5_256()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ShowTables_817_6_407()) {
    jj_scanpos = xsp;
    if (jj_3R_ShowTables_817_53_408()) return true;
    }
    return false;
  }

  private boolean jj_3R_ColumnNamesWithParamsList_3884_7_387()
 {
    if (jj_3R_CreateParameter_4328_9_386()) return true;
    return false;
  }

  private boolean jj_3R_ShowTables_813_7_406()
 {
    if (jj_scan_token(K_IN)) return true;
    return false;
  }

  private boolean jj_3R_ShowTables_812_7_405()
 {
    if (jj_scan_token(K_FROM)) return true;
    return false;
  }

  private boolean jj_3_66()
 {
    if (jj_scan_token(K_LIMIT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_LimitWithOffset_2343_26_148()) {
    jj_scanpos = xsp;
    if (jj_3R_LimitWithOffset_2345_26_149()) {
    jj_scanpos = xsp;
    if (jj_3R_LimitWithOffset_2347_26_150()) return true;
    }
    }
    if (jj_scan_token(K_COMMA)) return true;
    xsp = jj_scanpos;
    if (jj_3R_LimitWithOffset_2353_17_151()) {
    jj_scanpos = xsp;
    if (jj_3R_LimitWithOffset_2355_18_152()) {
    jj_scanpos = xsp;
    if (jj_3R_LimitWithOffset_2357_18_153()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_ShowTables_811_5_255()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ShowTables_812_7_405()) {
    jj_scanpos = xsp;
    if (jj_3R_ShowTables_813_7_406()) return true;
    }
    if (jj_3R_RelObjectNameExt_1380_5_147()) return true;
    return false;
  }

  private boolean jj_3R_ColumnNamesWithParamsList_3880_6_206()
 {
    if (jj_scan_token(266)) return true;
    if (jj_3R_RelObjectName_1350_5_133()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ColumnNamesWithParamsList_3884_7_387()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_ColumnNamesWithParamsList_3890_9_388()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_ShowTables_808_5_254()
 {
    if (jj_scan_token(K_FULL)) return true;
    return false;
  }

  private boolean jj_3R_ShowTables_807_5_253()
 {
    if (jj_scan_token(K_EXTENDED)) return true;
    return false;
  }

  private boolean jj_3R_ShowTables_806_3_113()
 {
    if (jj_scan_token(K_SHOW)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ShowTables_807_5_253()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_ShowTables_808_5_254()) jj_scanpos = xsp;
    if (jj_scan_token(K_TABLES)) return true;
    xsp = jj_scanpos;
    if (jj_3R_ShowTables_811_5_255()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_ShowTables_817_5_256()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_LimitWithOffset_2338_5_556()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_66()) {
    jj_scanpos = xsp;
    if (jj_3R_LimitWithOffset_2360_13_607()) return true;
    }
    return false;
  }

  private boolean jj_3R_SubSelect_3865_7_352()
 {
    if (jj_3R_WithList_1611_5_383()) return true;
    return false;
  }

  private boolean jj_3R_SubSelect_3865_5_169()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SubSelect_3865_7_352()) jj_scanpos = xsp;
    if (jj_3R_SelectBody_1445_5_219()) return true;
    return false;
  }

  private boolean jj_3_125()
 {
    if (jj_3R_Alias_1690_5_205()) return true;
    return false;
  }

  private boolean jj_3_63()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_ShowColumns_790_5_112()
 {
    if (jj_scan_token(K_SHOW)) return true;
    if (jj_scan_token(K_COLUMNS)) return true;
    if (jj_scan_token(K_FROM)) return true;
    if (jj_3R_RelObjectNameExt_1380_5_147()) return true;
    return false;
  }

  private boolean jj_3R_SimpleJdbcNamedParameter_2324_5_669()
 {
    if (jj_scan_token(272)) return true;
    if (jj_3R_RelObjectNameExt_1380_5_147()) return true;
    return false;
  }

  private boolean jj_3R_TableFunction_3851_5_138()
 {
    if (jj_3R_Function_3729_5_171()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_125()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_SimpleJdbcParameter_2313_5_309()
 {
    if (jj_scan_token(271)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_63()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_OrderByElement_2297_19_694()
 {
    if (jj_scan_token(K_DESC)) return true;
    return false;
  }

  private boolean jj_3R_OrderByElement_2300_9_721()
 {
    if (jj_scan_token(K_LAST)) return true;
    return false;
  }

  private boolean jj_3R_OrderByElement_2299_9_720()
 {
    if (jj_scan_token(K_FIRST)) return true;
    return false;
  }

  private boolean jj_3R_OrderByElement_2299_9_695()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_OrderByElement_2299_9_720()) {
    jj_scanpos = xsp;
    if (jj_3R_OrderByElement_2300_9_721()) return true;
    }
    return false;
  }

  private boolean jj_3R_ValueListExpression_3837_5_174()
 {
    if (jj_scan_token(266)) return true;
    if (jj_3R_SimpleExpressionListAtLeastTwoItems_2996_5_357()) return true;
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_OrderByElement_2298_6_668()
 {
    if (jj_scan_token(K_NULLS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_OrderByElement_2299_9_695()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_OrderByElement_2297_7_667()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(15)) {
    jj_scanpos = xsp;
    if (jj_3R_OrderByElement_2297_19_694()) return true;
    }
    return false;
  }

  private boolean jj_3R_OrderByElement_2296_5_615()
 {
    if (jj_3R_Expression_2544_5_199()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_OrderByElement_2297_7_667()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_OrderByElement_2298_6_668()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_MySQLGroupConcat_3823_10_733()
 {
    if (jj_scan_token(K_SEPARATOR)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_MySQLGroupConcat_3822_10_732()
 {
    if (jj_3R_OrderByElements_2283_5_555()) return true;
    return false;
  }

  private boolean jj_3R_MySQLGroupConcat_3820_9_731()
 {
    if (jj_scan_token(K_DISTINCT)) return true;
    return false;
  }

  private boolean jj_3R_OrderByElements_2284_10_616()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_OrderByElement_2296_5_615()) return true;
    return false;
  }

  private boolean jj_3R_InternalFunction_3756_71_202()
 {
    if (jj_scan_token(K_ALL)) return true;
    return false;
  }

  private boolean jj_3R_MySQLGroupConcat_3819_5_412()
 {
    if (jj_scan_token(K_GROUP_CONCAT)) return true;
    if (jj_scan_token(266)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_MySQLGroupConcat_3820_9_731()) jj_scanpos = xsp;
    if (jj_3R_SimpleExpressionList_2891_5_146()) return true;
    xsp = jj_scanpos;
    if (jj_3R_MySQLGroupConcat_3822_10_732()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_MySQLGroupConcat_3823_10_733()) jj_scanpos = xsp;
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_OrderByElements_2283_5_555()
 {
    if (jj_scan_token(K_ORDER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(193)) jj_scanpos = xsp;
    if (jj_scan_token(K_BY)) return true;
    if (jj_3R_OrderByElement_2296_5_615()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_OrderByElements_2284_10_616()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_XMLSerializeExpr_3799_19_734()
 {
    if (jj_3R_OrderByElements_2283_5_555()) return true;
    return false;
  }

  private boolean jj_3R_GroupByColumnReferences_2258_19_736()
 {
    if (jj_3R_SimpleExpression_3054_5_115()) return true;
    return false;
  }

  private boolean jj_3_61()
 {
    if (jj_scan_token(266)) return true;
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_Having_2271_5_684()
 {
    if (jj_scan_token(K_HAVING)) return true;
    if (jj_3R_Expression_2544_5_199()) return true;
    return false;
  }

  private boolean jj_3_62()
 {
    if (jj_scan_token(266)) return true;
    if (jj_3R_SimpleExpressionList_2891_5_146()) return true;
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_GroupByColumnReferences_2254_19_728()
 {
    if (jj_3R_SimpleExpression_3054_5_115()) return true;
    return false;
  }

  private boolean jj_3_60()
 {
    if (jj_scan_token(266)) return true;
    if (jj_3R_SimpleExpressionList_2891_5_146()) return true;
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_GroupByColumnReferences_2256_15_729()
 {
    if (jj_scan_token(K_COMMA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_61()) {
    jj_scanpos = xsp;
    if (jj_3_62()) {
    jj_scanpos = xsp;
    if (jj_3R_GroupByColumnReferences_2258_19_736()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_59()
 {
    if (jj_scan_token(266)) return true;
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_XMLSerializeExpr_3795_5_413()
 {
    if (jj_scan_token(K_XMLSERIALIZE)) return true;
    if (jj_scan_token(266)) return true;
    if (jj_scan_token(K_XMLAGG)) return true;
    if (jj_scan_token(266)) return true;
    if (jj_scan_token(K_XMLTEXT)) return true;
    if (jj_scan_token(266)) return true;
    if (jj_3R_SimpleExpression_3054_5_115()) return true;
    if (jj_scan_token(267)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_XMLSerializeExpr_3799_19_734()) jj_scanpos = xsp;
    if (jj_scan_token(267)) return true;
    if (jj_scan_token(K_AS)) return true;
    if (jj_3R_ColDataType_4230_5_381()) return true;
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_OracleHierarchicalQueryClause_2226_38_725()
 {
    if (jj_scan_token(K_NOCYCLE)) return true;
    return false;
  }

  private boolean jj_3_121()
 {
    if (jj_3R_NamedExpressionListExprFirst_2962_9_203()) return true;
    return false;
  }

  private boolean jj_3R_OracleHierarchicalQueryClause_2223_38_724()
 {
    if (jj_scan_token(K_NOCYCLE)) return true;
    return false;
  }

  private boolean jj_3R_GroupByColumnReferences_2251_9_718()
 {
    if (jj_scan_token(K_GROUPING)) return true;
    if (jj_scan_token(K_SETS)) return true;
    if (jj_scan_token(266)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_59()) {
    jj_scanpos = xsp;
    if (jj_3_60()) {
    jj_scanpos = xsp;
    if (jj_3R_GroupByColumnReferences_2254_19_728()) return true;
    }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_GroupByColumnReferences_2256_15_729()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_GroupByColumnReferences_2249_10_727()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_SimpleExpression_3054_5_115()) return true;
    return false;
  }

  private boolean jj_3R_GroupByColumnReferences_2248_9_717()
 {
    if (jj_3R_SimpleExpression_3054_5_115()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_GroupByColumnReferences_2249_10_727()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_InternalFunction_3766_25_597()
 {
    if (jj_3R_SubSelect_3865_5_169()) return true;
    return false;
  }

  private boolean jj_3R_InternalFunction_3773_15_599()
 {
    if (jj_3R_RelObjectName_1350_5_133()) return true;
    return false;
  }

  private boolean jj_3R_InternalFunction_3762_25_596()
 {
    if (jj_3R_NamedExpressionListExprFirst_2962_9_203()) return true;
    return false;
  }

  private boolean jj_3R_GroupByColumnReferences_2246_5_683()
 {
    if (jj_scan_token(K_GROUP)) return true;
    if (jj_scan_token(K_BY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_GroupByColumnReferences_2248_9_717()) {
    jj_scanpos = xsp;
    if (jj_3R_GroupByColumnReferences_2251_9_718()) return true;
    }
    return false;
  }

  private boolean jj_3R_OracleHierarchicalQueryClause_2231_19_726()
 {
    if (jj_scan_token(K_START)) return true;
    if (jj_scan_token(K_WITH)) return true;
    if (jj_3R_AndExpression_2576_5_447()) return true;
    return false;
  }

  private boolean jj_3R_InternalFunction_3760_25_595()
 {
    if (jj_3R_NamedExpressionList1_2926_5_630()) return true;
    return false;
  }

  private boolean jj_3_123()
 {
    if (jj_3R_Function_3729_5_171()) return true;
    return false;
  }

  private boolean jj_3_124()
 {
    if (jj_3R_KeepExpression_3428_5_204()) return true;
    return false;
  }

  private boolean jj_3R_InternalFunction_3756_26_201()
 {
    if (jj_scan_token(K_DISTINCT)) return true;
    return false;
  }

  private boolean jj_3R_InternalFunction_3768_11_539()
 {
    if (jj_scan_token(K_IGNORE)) return true;
    if (jj_scan_token(K_NULLS)) return true;
    return false;
  }

  private boolean jj_3R_OracleHierarchicalQueryClause_2226_17_712()
 {
    if (jj_scan_token(K_CONNECT)) return true;
    if (jj_scan_token(K_BY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_OracleHierarchicalQueryClause_2226_38_725()) jj_scanpos = xsp;
    if (jj_3R_AndExpression_2576_5_447()) return true;
    xsp = jj_scanpos;
    if (jj_3R_OracleHierarchicalQueryClause_2231_19_726()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_InternalFunction_3771_7_540()
 {
    if (jj_scan_token(270)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_123()) {
    jj_scanpos = xsp;
    if (jj_3R_InternalFunction_3773_15_599()) return true;
    }
    return false;
  }

  private boolean jj_3_122()
 {
    if (jj_3R_SimpleExpressionList_2891_5_146()) return true;
    return false;
  }

  private boolean jj_3R_OracleHierarchicalQueryClause_2222_17_711()
 {
    if (jj_scan_token(K_START)) return true;
    if (jj_scan_token(K_WITH)) return true;
    if (jj_3R_AndExpression_2576_5_447()) return true;
    if (jj_scan_token(K_CONNECT)) return true;
    if (jj_scan_token(K_BY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_OracleHierarchicalQueryClause_2223_38_724()) jj_scanpos = xsp;
    if (jj_3R_AndExpression_2576_5_447()) return true;
    return false;
  }

  private boolean jj_3_119()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_InternalFunction_3756_26_201()) {
    jj_scanpos = xsp;
    if (jj_3R_InternalFunction_3756_71_202()) return true;
    }
    return false;
  }

  private boolean jj_3_120()
 {
    if (jj_scan_token(269)) return true;
    return false;
  }

  private boolean jj_3R_InternalFunction_3756_11_538()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_119()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_120()) {
    jj_scanpos = xsp;
    if (jj_3R_InternalFunction_3760_25_595()) {
    jj_scanpos = xsp;
    if (jj_3R_InternalFunction_3762_25_596()) {
    jj_scanpos = xsp;
    if (jj_3_122()) {
    jj_scanpos = xsp;
    if (jj_3R_InternalFunction_3766_25_597()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_OracleHierarchicalQueryClause_2221_5_682()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_OracleHierarchicalQueryClause_2222_17_711()) {
    jj_scanpos = xsp;
    if (jj_3R_OracleHierarchicalQueryClause_2226_17_712()) return true;
    }
    return false;
  }

  private boolean jj_3R_InternalFunction_3754_5_437()
 {
    if (jj_3R_RelObjectNameList_1294_5_226()) return true;
    if (jj_scan_token(266)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_InternalFunction_3756_11_538()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_InternalFunction_3768_11_539()) jj_scanpos = xsp;
    if (jj_scan_token(267)) return true;
    xsp = jj_scanpos;
    if (jj_3R_InternalFunction_3771_7_540()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_124()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_WhereClause_2211_5_681()
 {
    if (jj_scan_token(K_WHERE)) return true;
    if (jj_3R_Expression_2544_5_199()) return true;
    return false;
  }

  private boolean jj_3R_FullTextSearch_3684_62_365()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_Column_1307_5_114()) return true;
    return false;
  }

  private boolean jj_3R_Function_3731_11_354()
 {
    if (jj_3R_InternalFunction_3754_5_437()) return true;
    return false;
  }

  private boolean jj_3R_Function_3730_9_353()
 {
    if (jj_scan_token(312)) return true;
    if (jj_scan_token(K_FN)) return true;
    if (jj_3R_InternalFunction_3754_5_437()) return true;
    if (jj_scan_token(297)) return true;
    return false;
  }

  private boolean jj_3R_KSQLWindowClause_2190_9_716()
 {
    if (jj_scan_token(K_TUMBLING)) return true;
    if (jj_scan_token(266)) return true;
    if (jj_scan_token(K_SIZE)) return true;
    if (jj_scan_token(S_LONG)) return true;
    if (jj_scan_token(S_IDENTIFIER)) return true;
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_Function_3729_5_171()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Function_3730_9_353()) {
    jj_scanpos = xsp;
    if (jj_3R_Function_3731_11_354()) return true;
    }
    return false;
  }

  private boolean jj_3R_KSQLWindowClause_2186_9_715()
 {
    if (jj_scan_token(K_SESSION)) return true;
    if (jj_scan_token(266)) return true;
    if (jj_scan_token(S_LONG)) return true;
    if (jj_scan_token(S_IDENTIFIER)) return true;
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_KSQLWindowClause_2180_9_714()
 {
    if (jj_scan_token(K_HOPPING)) return true;
    if (jj_scan_token(266)) return true;
    if (jj_scan_token(K_SIZE)) return true;
    if (jj_scan_token(S_LONG)) return true;
    if (jj_scan_token(S_IDENTIFIER)) return true;
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_scan_token(K_ADVANCE)) return true;
    if (jj_scan_token(K_BY)) return true;
    if (jj_scan_token(S_LONG)) return true;
    if (jj_scan_token(S_IDENTIFIER)) return true;
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2103_81_673()
 {
    if (jj_scan_token(K_OUTER)) return true;
    return false;
  }

  private boolean jj_3R_FunctionWithCondParams_3709_5_190()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(96)) {
    jj_scanpos = xsp;
    if (jj_scan_token(97)) return true;
    }
    if (jj_scan_token(266)) return true;
    if (jj_3R_ComplexExpressionList_2905_5_197()) return true;
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_KSQLWindowClause_2172_5_680()
 {
    if (jj_scan_token(K_WINDOW)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_KSQLWindowClause_2180_9_714()) {
    jj_scanpos = xsp;
    if (jj_3R_KSQLWindowClause_2186_9_715()) {
    jj_scanpos = xsp;
    if (jj_3R_KSQLWindowClause_2190_9_716()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_JoinerExpression_2114_57_527()
 {
    if (jj_scan_token(K_APPLY)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2113_55_590()
 {
    if (jj_scan_token(K_OUTER)) return true;
    return false;
  }

  private boolean jj_3R_FullTextSearch_3687_13_366()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(308)) {
    jj_scanpos = xsp;
    if (jj_scan_token(309)) {
    jj_scanpos = xsp;
    if (jj_scan_token(310)) {
    jj_scanpos = xsp;
    if (jj_scan_token(311)) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_JoinWindow_2146_11_768()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_scan_token(S_LONG)) return true;
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_FullTextSearch_3684_5_191()
 {
    if (jj_scan_token(K_MATCH)) return true;
    if (jj_scan_token(266)) return true;
    if (jj_3R_Column_1307_5_114()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_FullTextSearch_3684_62_365()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(267)) return true;
    if (jj_scan_token(K_AGAINST)) return true;
    if (jj_scan_token(266)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    xsp = jj_scanpos;
    if (jj_3R_FullTextSearch_3687_13_366()) jj_scanpos = xsp;
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_JoinWindow_2145_5_761()
 {
    if (jj_scan_token(S_LONG)) return true;
    if (jj_scan_token(S_IDENTIFIER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JoinWindow_2146_11_768()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2103_46_672()
 {
    if (jj_scan_token(K_SEMI)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2103_46_625()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JoinerExpression_2103_46_672()) {
    jj_scanpos = xsp;
    if (jj_3R_JoinerExpression_2103_81_673()) return true;
    }
    return false;
  }

  private boolean jj_3R_JoinerExpression_2124_18_751()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_Column_1307_5_114()) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2120_21_306()
 {
    if (jj_scan_token(K_WITHIN)) return true;
    if (jj_scan_token(266)) return true;
    if (jj_3R_JoinWindow_2145_5_761()) return true;
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2120_19_144()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JoinerExpression_2120_21_306()) jj_scanpos = xsp;
    if (jj_scan_token(K_ON)) return true;
    if (jj_3R_Expression_2544_5_199()) return true;
    return false;
  }

  private boolean jj_3_118()
 {
    if (jj_3R_SimpleExpressionList_2891_5_146()) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2113_24_525()
 {
    if (jj_scan_token(K_COMMA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JoinerExpression_2113_55_590()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_117()
 {
    if (jj_3R_VariableExpression_3636_5_200()) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2123_9_145()
 {
    if (jj_scan_token(K_USING)) return true;
    if (jj_scan_token(266)) return true;
    if (jj_3R_Column_1307_5_114()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_JoinerExpression_2124_18_751()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2114_14_526()
 {
    if (jj_scan_token(K_STRAIGHT)) return true;
    return false;
  }

  private boolean jj_3_58()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JoinerExpression_2120_19_144()) {
    jj_scanpos = xsp;
    if (jj_3R_JoinerExpression_2123_9_145()) return true;
    }
    return false;
  }

  private boolean jj_3R_JoinerExpression_2106_16_628()
 {
    if (jj_scan_token(K_OUTER)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2105_16_627()
 {
    if (jj_scan_token(K_FULL)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2110_11_589()
 {
    if (jj_scan_token(K_OUTER)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2104_16_626()
 {
    if (jj_scan_token(K_RIGHT)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2109_11_588()
 {
    if (jj_scan_token(K_CROSS)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2108_11_587()
 {
    if (jj_scan_token(K_NATURAL)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2107_11_586()
 {
    if (jj_scan_token(K_INNER)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2104_14_585()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JoinerExpression_2104_16_626()) {
    jj_scanpos = xsp;
    if (jj_3R_JoinerExpression_2105_16_627()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_JoinerExpression_2106_16_628()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_WhenThenSearchCondition_3590_62_739()
 {
    if (jj_3R_SimpleExpression_3054_5_115()) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2103_11_584()
 {
    if (jj_scan_token(K_LEFT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JoinerExpression_2103_46_625()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2103_11_524()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JoinerExpression_2103_11_584()) {
    jj_scanpos = xsp;
    if (jj_3R_JoinerExpression_2104_14_585()) {
    jj_scanpos = xsp;
    if (jj_3R_JoinerExpression_2107_11_586()) {
    jj_scanpos = xsp;
    if (jj_3R_JoinerExpression_2108_11_587()) {
    jj_scanpos = xsp;
    if (jj_3R_JoinerExpression_2109_11_588()) {
    jj_scanpos = xsp;
    if (jj_3R_JoinerExpression_2110_11_589()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_VariableExpression_3636_5_200()
 {
    if (jj_3R_UserVariable_3334_5_175()) return true;
    if (jj_scan_token(268)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2100_5_414()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JoinerExpression_2103_11_524()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(112)) {
    jj_scanpos = xsp;
    if (jj_3R_JoinerExpression_2113_24_525()) {
    jj_scanpos = xsp;
    if (jj_3R_JoinerExpression_2114_14_526()) {
    jj_scanpos = xsp;
    if (jj_3R_JoinerExpression_2114_57_527()) return true;
    }
    }
    }
    if (jj_3R_FromItem_1946_5_135()) return true;
    xsp = jj_scanpos;
    if (jj_3_58()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_RowConstructor_3618_7_537()
 {
    if (jj_scan_token(K_ROW)) return true;
    return false;
  }

  private boolean jj_3R_SubJoinsList_2084_6_531()
 {
    if (jj_3R_JoinerExpression_2100_5_414()) return true;
    return false;
  }

  private boolean jj_3R_SubJoinsList_2084_5_423()
 {
    Token xsp;
    if (jj_3R_SubJoinsList_2084_6_531()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_SubJoinsList_2084_6_531()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_RowConstructor_3618_5_433()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_RowConstructor_3618_7_537()) jj_scanpos = xsp;
    if (jj_scan_token(266)) return true;
    if (jj_3R_SimpleExpressionList_2891_5_146()) return true;
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_Synonym_5151_5_237()
 {
    if (jj_3R_RelObjectNameList_1294_5_226()) return true;
    return false;
  }

  private boolean jj_3_116()
 {
    if (jj_3R_Expression_2544_5_199()) return true;
    return false;
  }

  private boolean jj_3R_JoinsList_2073_6_284()
 {
    if (jj_3R_JoinerExpression_2100_5_414()) return true;
    return false;
  }

  private boolean jj_3R_JoinsList_2073_5_122()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_JoinsList_2073_6_284()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_WindowOffset_3517_91_780()
 {
    if (jj_scan_token(K_FOLLOWING)) return true;
    return false;
  }

  private boolean jj_3R_WhenThenSearchCondition_3590_15_738()
 {
    if (jj_3R_Expression_2544_5_199()) return true;
    return false;
  }

  private boolean jj_3R_CreateSynonym_5134_4_236()
 {
    if (jj_scan_token(K_PUBLIC)) return true;
    return false;
  }

  private boolean jj_3R_CreateSynonym_5133_4_235()
 {
    if (jj_scan_token(K_OR)) return true;
    if (jj_scan_token(K_REPLACE)) return true;
    return false;
  }

  private boolean jj_3R_CreateSynonym_5132_3_107()
 {
    if (jj_scan_token(K_CREATE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateSynonym_5133_4_235()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateSynonym_5134_4_236()) jj_scanpos = xsp;
    if (jj_scan_token(K_SYNONYM)) return true;
    if (jj_3R_Synonym_5151_5_237()) return true;
    if (jj_scan_token(K_FOR)) return true;
    if (jj_3R_RelObjectNameList_1294_5_226()) return true;
    return false;
  }

  private boolean jj_3_14()
 {
    if (jj_3R_ShowTables_806_3_113()) return true;
    return false;
  }

  private boolean jj_3R_SubJoin_2058_5_300()
 {
    if (jj_3R_SubJoinsList_2084_5_423()) return true;
    return false;
  }

  private boolean jj_3R_WindowOffset_3508_89_778()
 {
    if (jj_scan_token(K_FOLLOWING)) return true;
    return false;
  }

  private boolean jj_3_13()
 {
    if (jj_3R_ShowColumns_790_5_112()) return true;
    return false;
  }

  private boolean jj_3R_WhenThenSearchCondition_3590_5_722()
 {
    if (jj_scan_token(K_WHEN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_WhenThenSearchCondition_3590_15_738()) {
    jj_scanpos = xsp;
    if (jj_3R_WhenThenSearchCondition_3590_62_739()) return true;
    }
    if (jj_scan_token(K_THEN)) return true;
    if (jj_3R_Expression_2544_5_199()) return true;
    return false;
  }

  private boolean jj_3_12()
 {
    if (jj_3R_AlterSequence_5088_3_111()) return true;
    return false;
  }

  private boolean jj_3R_LateralSubSelect_2044_5_529()
 {
    if (jj_scan_token(K_LATERAL)) return true;
    if (jj_scan_token(266)) return true;
    if (jj_3R_SubSelect_3865_5_169()) return true;
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_CreateFunctionStatement_5104_15_222()
 {
    if (jj_scan_token(K_OR)) return true;
    if (jj_scan_token(K_REPLACE)) return true;
    return false;
  }

  private boolean jj_3_11()
 {
    if (jj_3R_AlterView_4309_5_110()) return true;
    return false;
  }

  private boolean jj_3R_CaseWhenExpression_3573_6_730()
 {
    if (jj_scan_token(K_ELSE)) return true;
    if (jj_3R_Condition_2614_5_154()) return true;
    return false;
  }

  private boolean jj_3R_CaseWhenExpression_3572_7_704()
 {
    if (jj_3R_WhenThenSearchCondition_3590_5_722()) return true;
    return false;
  }

  private boolean jj_3_10()
 {
    if (jj_3R_CreateView_4262_5_109()) return true;
    return false;
  }

  private boolean jj_3R_CaseWhenExpression_3571_7_703()
 {
    if (jj_3R_Condition_2614_5_154()) return true;
    return false;
  }

  private boolean jj_3R_ValuesList_2027_15_533()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_RelObjectName_1350_5_133()) return true;
    return false;
  }

  private boolean jj_3R_CreateFunctionStatement_5108_4_224()
 {
    if (jj_scan_token(K_PROCEDURE)) return true;
    return false;
  }

  private boolean jj_3_9()
 {
    if (jj_3R_CreateTable_4056_5_108()) return true;
    return false;
  }

  private boolean jj_3R_CaseWhenExpression_3570_5_411()
 {
    if (jj_scan_token(K_CASE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CaseWhenExpression_3571_7_703()) jj_scanpos = xsp;
    if (jj_3R_CaseWhenExpression_3572_7_704()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_CaseWhenExpression_3572_7_704()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_CaseWhenExpression_3573_6_730()) jj_scanpos = xsp;
    if (jj_scan_token(K_END)) return true;
    return false;
  }

  private boolean jj_3R_CreateFunctionStatement_5106_4_223()
 {
    if (jj_scan_token(K_FUNCTION)) return true;
    return false;
  }

  private boolean jj_3_8()
 {
    if (jj_3R_CreateSynonym_5132_3_107()) return true;
    return false;
  }

  private boolean jj_3_114()
 {
    if (jj_3R_windowFun_3445_5_198()) return true;
    return false;
  }

  private boolean jj_3R_CreateFunctionStatement_5104_3_103()
 {
    if (jj_scan_token(K_CREATE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateFunctionStatement_5104_15_222()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateFunctionStatement_5106_4_223()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateFunctionStatement_5108_4_224()) return true;
    }
    if (true) { jj_la = 0; jj_scanpos = jj_lastpos; return false;}
    return false;
  }

  private boolean jj_3R_ValuesList_2025_11_428()
 {
    if (jj_scan_token(266)) return true;
    if (jj_3R_RelObjectName_1350_5_133()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_ValuesList_2027_15_533()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3_7()
 {
    if (jj_3R_CreateSequence_5073_3_106()) return true;
    return false;
  }

  private boolean jj_3R_ValuesList_2016_18_532()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_SimpleExpression_3054_5_115()) return true;
    return false;
  }

  private boolean jj_3R_FromItem_1975_57_530()
 {
    if (jj_3R_Pivot_1849_5_591()) return true;
    return false;
  }

  private boolean jj_3_6()
 {
    if (jj_3R_CreateSchema_3982_5_105()) return true;
    return false;
  }

  private boolean jj_3R_ValuesList_2023_7_305()
 {
    if (jj_3R_Alias_1690_5_205()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ValuesList_2025_11_428()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_5()
 {
    if (jj_3R_CreateIndex_3919_5_104()) return true;
    return false;
  }

  private boolean jj_3R_ValuesList_2019_10_427()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_SimpleExpression_3054_5_115()) return true;
    return false;
  }

  private boolean jj_3R_ValuesList_2013_14_426()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_scan_token(266)) return true;
    if (jj_3R_SimpleExpression_3054_5_115()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_ValuesList_2016_18_532()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3_4()
 {
    if (jj_3R_CreateFunctionStatement_5104_3_103()) return true;
    return false;
  }

  private boolean jj_3R_ValuesList_2011_14_143()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_SimpleExpression_3054_5_115()) return true;
    return false;
  }

  private boolean jj_3R_ValuesList_2018_5_304()
 {
    if (jj_3R_SimpleExpression_3054_5_115()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_ValuesList_2019_10_427()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_CastExpression_3552_5_193()
 {
    if (jj_scan_token(K_CAST)) return true;
    if (jj_scan_token(266)) return true;
    if (jj_3R_SimpleExpression_3054_5_115()) return true;
    if (jj_scan_token(K_AS)) return true;
    if (jj_3R_ColDataType_4230_5_381()) return true;
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_AlterSequence_5088_3_111()
 {
    if (jj_scan_token(K_ALTER)) return true;
    if (jj_scan_token(K_SEQUENCE)) return true;
    if (jj_3R_Sequence_4974_5_233()) return true;
    if (jj_3R_SequenceParameters_4989_1_234()) return true;
    return false;
  }

  private boolean jj_3R_WindowElement_3484_71_770()
 {
    if (jj_scan_token(K_RANGE)) return true;
    return false;
  }

  private boolean jj_3_57()
 {
    if (jj_scan_token(266)) return true;
    if (jj_3R_SimpleExpression_3054_5_115()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_ValuesList_2011_14_143()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(267)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_ValuesList_2013_14_426()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_ValuesList_2008_5_142()
 {
    if (jj_scan_token(266)) return true;
    if (jj_scan_token(K_VALUES)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_57()) {
    jj_scanpos = xsp;
    if (jj_3R_ValuesList_2018_5_304()) return true;
    }
    if (jj_scan_token(267)) return true;
    xsp = jj_scanpos;
    if (jj_3R_ValuesList_2023_7_305()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_WindowOffset_3507_40_777()
 {
    if (jj_scan_token(K_PRECEDING)) return true;
    return false;
  }

  private boolean jj_3_3()
 {
    if (jj_3R_AlterTable_4845_5_102()) return true;
    return false;
  }

  private boolean jj_3R_WindowOffset_3517_26_779()
 {
    if (jj_scan_token(K_PRECEDING)) return true;
    return false;
  }

  private boolean jj_3_2()
 {
    if (jj_3R_Replace_934_5_101()) return true;
    return false;
  }

  private boolean jj_3R_CreateSequence_5073_3_106()
 {
    if (jj_scan_token(K_CREATE)) return true;
    if (jj_scan_token(K_SEQUENCE)) return true;
    if (jj_3R_Sequence_4974_5_233()) return true;
    if (jj_3R_SequenceParameters_4989_1_234()) return true;
    return false;
  }

  private boolean jj_3R_FromItem_1984_21_141()
 {
    if (jj_3R_SQLServerHints_1715_5_303()) return true;
    return false;
  }

  private boolean jj_3R_IntervalExpression_3391_149_370()
 {
    if (jj_3R_SimpleJdbcParameter_2313_5_309()) return true;
    return false;
  }

  private boolean jj_3R_ExtractExpression_3533_5_188()
 {
    if (jj_scan_token(K_EXTRACT)) return true;
    if (jj_scan_token(266)) return true;
    if (jj_3R_RelObjectName_1350_5_133()) return true;
    if (jj_scan_token(K_FROM)) return true;
    if (jj_3R_SimpleExpression_3054_5_115()) return true;
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3_54()
 {
    if (jj_3R_PivotXml_1877_5_139()) return true;
    return false;
  }

  private boolean jj_3_53()
 {
    if (jj_3R_UnPivot_1906_5_137()) return true;
    return false;
  }

  private boolean jj_3R_FromItem_1975_26_422()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_54()) {
    jj_scanpos = xsp;
    if (jj_3R_FromItem_1975_57_530()) return true;
    }
    return false;
  }

  private boolean jj_3R_FromItem_1979_21_140()
 {
    if (jj_3R_MySQLIndexHint_1729_9_302()) return true;
    return false;
  }

  private boolean jj_3R_WindowOffset_3513_17_776()
 {
    if (jj_3R_SimpleExpression_3054_5_115()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_WindowOffset_3517_26_779()) {
    jj_scanpos = xsp;
    if (jj_3R_WindowOffset_3517_91_780()) return true;
    }
    return false;
  }

  private boolean jj_3_1()
 {
    if (jj_3R_Select_1436_5_100()) return true;
    return false;
  }

  private boolean jj_3R_SequenceParameters_5058_6_577()
 {
    if (jj_scan_token(K_GLOBAL)) return true;
    return false;
  }

  private boolean jj_3_55()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_FromItem_1979_21_140()) {
    jj_scanpos = xsp;
    if (jj_3R_FromItem_1984_21_141()) return true;
    }
    return false;
  }

  private boolean jj_3_52()
 {
    if (jj_3R_TableFunction_3851_5_138()) return true;
    return false;
  }

  private boolean jj_3_115()
 {
    if (jj_scan_token(K_CURRENT)) return true;
    if (jj_scan_token(K_ROW)) return true;
    return false;
  }

  private boolean jj_3R_SequenceParameters_5057_5_576()
 {
    if (jj_scan_token(K_SESSION)) return true;
    return false;
  }

  private boolean jj_3R_SequenceParameters_5057_4_517()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SequenceParameters_5057_5_576()) {
    jj_scanpos = xsp;
    if (jj_3R_SequenceParameters_5058_6_577()) return true;
    }
    return false;
  }

  private boolean jj_3R_SequenceParameters_5054_6_575()
 {
    if (jj_scan_token(K_NOKEEP)) return true;
    return false;
  }

  private boolean jj_3R_WindowOffset_3506_17_775()
 {
    if (jj_scan_token(K_UNBOUNDED)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_WindowOffset_3507_40_777()) {
    jj_scanpos = xsp;
    if (jj_3R_WindowOffset_3508_89_778()) return true;
    }
    return false;
  }

  private boolean jj_3R_SequenceParameters_5053_5_574()
 {
    if (jj_scan_token(K_KEEP)) return true;
    return false;
  }

  private boolean jj_3R_FromItem_1971_17_420()
 {
    if (jj_3R_LateralSubSelect_2044_5_529()) return true;
    return false;
  }

  private boolean jj_3R_FromItem_1973_15_421()
 {
    if (jj_3R_Alias_1690_5_205()) return true;
    return false;
  }

  private boolean jj_3R_SequenceParameters_5053_4_516()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SequenceParameters_5053_5_574()) {
    jj_scanpos = xsp;
    if (jj_3R_SequenceParameters_5054_6_575()) return true;
    }
    return false;
  }

  private boolean jj_3R_SequenceParameters_5050_6_573()
 {
    if (jj_scan_token(K_NOORDER)) return true;
    return false;
  }

  private boolean jj_3_51()
 {
    if (jj_3R_UnPivot_1906_5_137()) return true;
    return false;
  }

  private boolean jj_3R_FromItem_1969_17_419()
 {
    if (jj_3R_Table_1410_5_213()) return true;
    return false;
  }

  private boolean jj_3R_FromItem_1960_25_528()
 {
    if (jj_3R_SubSelect_3865_5_169()) return true;
    return false;
  }

  private boolean jj_3R_SequenceParameters_5049_5_572()
 {
    if (jj_scan_token(K_ORDER)) return true;
    return false;
  }

  private boolean jj_3R_SequenceParameters_5049_4_515()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SequenceParameters_5049_5_572()) {
    jj_scanpos = xsp;
    if (jj_3R_SequenceParameters_5050_6_573()) return true;
    }
    return false;
  }

  private boolean jj_3R_FromItem_1956_27_136()
 {
    if (jj_3R_SubJoin_2058_5_300()) return true;
    return false;
  }

  private boolean jj_3R_FromItem_1966_17_418()
 {
    if (jj_3R_TableFunction_3851_5_138()) return true;
    return false;
  }

  private boolean jj_3R_IntoClause_1929_52_713()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_Table_1410_5_213()) return true;
    return false;
  }

  private boolean jj_3_50()
 {
    if (jj_3R_FromItem_1946_5_135()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_FromItem_1956_27_136()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_SequenceParameters_5041_5_571()
 {
    if (jj_scan_token(K_CACHE)) return true;
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_WindowOffset_3505_5_774()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_WindowOffset_3506_17_775()) {
    jj_scanpos = xsp;
    if (jj_3_115()) {
    jj_scanpos = xsp;
    if (jj_3R_WindowOffset_3513_17_776()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_IntervalExpression_3391_119_369()
 {
    if (jj_3R_JdbcNamedParameter_3322_5_186()) return true;
    return false;
  }

  private boolean jj_3R_KeepExpression_3428_79_635()
 {
    if (jj_scan_token(K_LAST)) return true;
    return false;
  }

  private boolean jj_3R_SequenceParameters_5036_5_570()
 {
    if (jj_scan_token(K_NOCACHE)) return true;
    return false;
  }

  private boolean jj_3R_SequenceParameters_5036_4_514()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SequenceParameters_5036_5_570()) {
    jj_scanpos = xsp;
    if (jj_3R_SequenceParameters_5041_5_571()) return true;
    }
    return false;
  }

  private boolean jj_3R_SequenceParameters_5033_6_569()
 {
    if (jj_scan_token(K_CYCLE)) return true;
    return false;
  }

  private boolean jj_3R_FromItem_1951_17_417()
 {
    if (jj_scan_token(266)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_50()) {
    jj_scanpos = xsp;
    if (jj_3R_FromItem_1960_25_528()) return true;
    }
    if (jj_scan_token(267)) return true;
    xsp = jj_scanpos;
    if (jj_3_51()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_SequenceParameters_5032_5_568()
 {
    if (jj_scan_token(K_NOCYCLE)) return true;
    return false;
  }

  private boolean jj_3R_SequenceParameters_5032_4_513()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SequenceParameters_5032_5_568()) {
    jj_scanpos = xsp;
    if (jj_3R_SequenceParameters_5033_6_569()) return true;
    }
    return false;
  }

  private boolean jj_3_56()
 {
    if (jj_3R_ValuesList_2008_5_142()) return true;
    return false;
  }

  private boolean jj_3R_WindowElement_3491_7_772()
 {
    if (jj_3R_WindowOffset_3505_5_774()) return true;
    return false;
  }

  private boolean jj_3R_SequenceParameters_5024_6_567()
 {
    if (jj_scan_token(K_MINVALUE)) return true;
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_FromItem_1949_9_299()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_FromItem_1951_17_417()) {
    jj_scanpos = xsp;
    if (jj_3R_FromItem_1966_17_418()) {
    jj_scanpos = xsp;
    if (jj_3R_FromItem_1969_17_419()) {
    jj_scanpos = xsp;
    if (jj_3R_FromItem_1971_17_420()) return true;
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_FromItem_1973_15_421()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_53()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_FromItem_1975_26_422()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_55()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_WindowElement_3485_7_771()
 {
    if (jj_scan_token(K_BETWEEN)) return true;
    if (jj_3R_WindowOffset_3505_5_774()) return true;
    if (jj_scan_token(K_AND)) return true;
    if (jj_3R_WindowOffset_3505_5_774()) return true;
    return false;
  }

  private boolean jj_3R_IntervalExpression_3391_101_368()
 {
    if (jj_3R_Column_1307_5_114()) return true;
    return false;
  }

  private boolean jj_3R_FromItem_1947_9_298()
 {
    if (jj_3R_ValuesList_2008_5_142()) return true;
    return false;
  }

  private boolean jj_3R_WindowElement_3484_6_769()
 {
    if (jj_scan_token(K_ROWS)) return true;
    return false;
  }

  private boolean jj_3R_WindowElement_3484_5_764()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_WindowElement_3484_6_769()) {
    jj_scanpos = xsp;
    if (jj_3R_WindowElement_3484_71_770()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_WindowElement_3485_7_771()) {
    jj_scanpos = xsp;
    if (jj_3R_WindowElement_3491_7_772()) return true;
    }
    return false;
  }

  private boolean jj_3R_SequenceParameters_5019_5_566()
 {
    if (jj_scan_token(K_NOMINVALUE)) return true;
    return false;
  }

  private boolean jj_3R_SequenceParameters_5019_4_512()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SequenceParameters_5019_5_566()) {
    jj_scanpos = xsp;
    if (jj_3R_SequenceParameters_5024_6_567()) return true;
    }
    return false;
  }

  private boolean jj_3R_FromItem_1946_5_135()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_FromItem_1947_9_298()) {
    jj_scanpos = xsp;
    if (jj_3R_FromItem_1949_9_299()) return true;
    }
    return false;
  }

  private boolean jj_3R_SequenceParameters_5011_6_565()
 {
    if (jj_scan_token(K_MAXVALUE)) return true;
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_AnalyticExpression_3470_11_363()
 {
    if (jj_3R_windowFun_3445_5_198()) return true;
    return false;
  }

  private boolean jj_3R_SequenceParameters_5006_5_564()
 {
    if (jj_scan_token(K_NOMAXVALUE)) return true;
    return false;
  }

  private boolean jj_3R_SequenceParameters_5006_4_511()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SequenceParameters_5006_5_564()) {
    jj_scanpos = xsp;
    if (jj_3R_SequenceParameters_5011_6_565()) return true;
    }
    return false;
  }

  private boolean jj_3R_AnalyticExpression_3469_6_362()
 {
    if (jj_scan_token(K_FILTER)) return true;
    if (jj_scan_token(266)) return true;
    if (jj_scan_token(K_WHERE)) return true;
    if (jj_3R_Expression_2544_5_199()) return true;
    if (jj_scan_token(267)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_114()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_AnalyticExpression_3469_5_185()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AnalyticExpression_3469_6_362()) {
    jj_scanpos = xsp;
    if (jj_3R_AnalyticExpression_3470_11_363()) return true;
    }
    return false;
  }

  private boolean jj_3_113()
 {
    if (jj_3R_ComplexExpressionList_2905_5_197()) return true;
    return false;
  }

  private boolean jj_3R_KeepExpression_3428_42_634()
 {
    if (jj_scan_token(K_FIRST)) return true;
    return false;
  }

  private boolean jj_3R_IntoClause_1929_5_679()
 {
    if (jj_scan_token(K_INTO)) return true;
    if (jj_3R_Table_1410_5_213()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_IntoClause_1929_52_713()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_SequenceParameters_4998_4_510()
 {
    if (jj_scan_token(K_START)) return true;
    if (jj_scan_token(K_WITH)) return true;
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_windowFun_3451_15_763()
 {
    if (jj_scan_token(266)) return true;
    if (jj_3R_ComplexExpressionList_2905_5_197()) return true;
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_windowFun_3450_14_762()
 {
    if (jj_3R_ComplexExpressionList_2905_5_197()) return true;
    return false;
  }

  private boolean jj_3R_windowFun_3454_10_754()
 {
    if (jj_3R_WindowElement_3484_5_764()) return true;
    return false;
  }

  private boolean jj_3R_windowFun_3453_10_753()
 {
    if (jj_3R_OrderByElements_2283_5_555()) return true;
    return false;
  }

  private boolean jj_3R_windowFun_3449_10_752()
 {
    if (jj_scan_token(K_PARTITION)) return true;
    if (jj_scan_token(K_BY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_windowFun_3450_14_762()) {
    jj_scanpos = xsp;
    if (jj_3R_windowFun_3451_15_763()) return true;
    }
    return false;
  }

  private boolean jj_3R_SequenceParameters_4990_4_509()
 {
    if (jj_scan_token(K_INCREMENT)) return true;
    if (jj_scan_token(K_BY)) return true;
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_SequenceParameters_4990_4_391()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SequenceParameters_4990_4_509()) {
    jj_scanpos = xsp;
    if (jj_3R_SequenceParameters_4998_4_510()) {
    jj_scanpos = xsp;
    if (jj_3R_SequenceParameters_5006_4_511()) {
    jj_scanpos = xsp;
    if (jj_3R_SequenceParameters_5019_4_512()) {
    jj_scanpos = xsp;
    if (jj_3R_SequenceParameters_5032_4_513()) {
    jj_scanpos = xsp;
    if (jj_3R_SequenceParameters_5036_4_514()) {
    jj_scanpos = xsp;
    if (jj_3R_SequenceParameters_5049_4_515()) {
    jj_scanpos = xsp;
    if (jj_3R_SequenceParameters_5053_4_516()) {
    jj_scanpos = xsp;
    if (jj_3R_SequenceParameters_5057_4_517()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_windowFun_3446_11_373()
 {
    if (jj_scan_token(K_WITHIN)) return true;
    if (jj_scan_token(K_GROUP)) return true;
    return false;
  }

  private boolean jj_3R_SequenceParameters_4989_1_234()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_SequenceParameters_4990_4_391()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_UnPivot_1907_9_424()
 {
    if (jj_scan_token(K_INCLUDE)) return true;
    if (jj_scan_token(K_NULLS)) return true;
    return false;
  }

  private boolean jj_3R_windowFun_3445_6_372()
 {
    if (jj_scan_token(K_OVER)) return true;
    return false;
  }

  private boolean jj_3R_UnPivot_1908_7_425()
 {
    if (jj_scan_token(K_EXCLUDE)) return true;
    if (jj_scan_token(K_NULLS)) return true;
    return false;
  }

  private boolean jj_3R_windowFun_3445_5_198()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_windowFun_3445_6_372()) {
    jj_scanpos = xsp;
    if (jj_3R_windowFun_3446_11_373()) return true;
    }
    if (jj_scan_token(266)) return true;
    xsp = jj_scanpos;
    if (jj_3R_windowFun_3449_10_752()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_windowFun_3453_10_753()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_windowFun_3454_10_754()) jj_scanpos = xsp;
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_UnPivot_1907_7_301()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_UnPivot_1907_9_424()) {
    jj_scanpos = xsp;
    if (jj_3R_UnPivot_1908_7_425()) return true;
    }
    return false;
  }

  private boolean jj_3R_UnPivot_1906_5_137()
 {
    if (jj_scan_token(K_UNPIVOT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_UnPivot_1907_7_301()) jj_scanpos = xsp;
    if (jj_scan_token(266)) return true;
    if (jj_3R_Column_1307_5_114()) return true;
    if (jj_scan_token(K_FOR)) return true;
    if (jj_3R_PivotForColumns_1772_5_737()) return true;
    if (jj_scan_token(K_IN)) return true;
    if (jj_scan_token(266)) return true;
    if (jj_3R_PivotSingleInItems_1798_4_134()) return true;
    if (jj_scan_token(267)) return true;
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_Sequence_4974_5_233()
 {
    if (jj_3R_RelObjectNameList_1294_5_226()) return true;
    return false;
  }

  private boolean jj_3R_KeepExpression_3428_5_204()
 {
    if (jj_scan_token(K_KEEP)) return true;
    if (jj_scan_token(266)) return true;
    if (jj_scan_token(S_IDENTIFIER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_KeepExpression_3428_42_634()) {
    jj_scanpos = xsp;
    if (jj_3R_KeepExpression_3428_79_635()) return true;
    }
    if (jj_3R_OrderByElements_2283_5_555()) return true;
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_PivotXml_1884_9_744()
 {
    if (jj_3R_PivotMultiInItems_1834_4_758()) return true;
    return false;
  }

  private boolean jj_3_49()
 {
    if (jj_3R_PivotSingleInItems_1798_4_134()) return true;
    return false;
  }

  private boolean jj_3R_PivotXml_1882_9_743()
 {
    if (jj_3R_SelectBody_1445_5_219()) return true;
    return false;
  }

  private boolean jj_3_48()
 {
    if (jj_scan_token(K_ANY)) return true;
    return false;
  }

  private boolean jj_3R_PivotXml_1877_5_139()
 {
    if (jj_scan_token(K_PIVOT)) return true;
    if (jj_scan_token(K_XML)) return true;
    if (jj_scan_token(266)) return true;
    if (jj_3R_PivotFunctionItems_1787_5_742()) return true;
    if (jj_scan_token(K_FOR)) return true;
    if (jj_3R_PivotForColumns_1772_5_737()) return true;
    if (jj_scan_token(K_IN)) return true;
    if (jj_scan_token(266)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_48()) {
    jj_scanpos = xsp;
    if (jj_3R_PivotXml_1882_9_743()) {
    jj_scanpos = xsp;
    if (jj_3_49()) {
    jj_scanpos = xsp;
    if (jj_3R_PivotXml_1884_9_744()) return true;
    }
    }
    }
    if (jj_scan_token(267)) return true;
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_IntervalExpressionWithoutInterval_3412_5_196()
 {
    if (jj_scan_token(K_DATE_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_IntervalExpression_3391_19_367()
 {
    if (jj_scan_token(286)) return true;
    return false;
  }

  private boolean jj_3_112()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(260)) {
    jj_scanpos = xsp;
    if (jj_scan_token(49)) return true;
    }
    return false;
  }

  private boolean jj_3R_Pivot_1856_7_746()
 {
    if (jj_3R_Alias_1690_5_205()) return true;
    return false;
  }

  private boolean jj_3R_Pivot_1853_7_745()
 {
    if (jj_3R_PivotMultiInItems_1834_4_758()) return true;
    return false;
  }

  private boolean jj_3_47()
 {
    if (jj_3R_PivotSingleInItems_1798_4_134()) return true;
    return false;
  }

  private boolean jj_3R_IntervalExpression_3390_1_192()
 {
    if (jj_scan_token(K_INTERVAL)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_IntervalExpression_3391_19_367()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(254)) {
    jj_scanpos = xsp;
    if (jj_scan_token(253)) {
    jj_scanpos = xsp;
    if (jj_scan_token(263)) {
    jj_scanpos = xsp;
    if (jj_3R_IntervalExpression_3391_101_368()) {
    jj_scanpos = xsp;
    if (jj_3R_IntervalExpression_3391_119_369()) {
    jj_scanpos = xsp;
    if (jj_3R_IntervalExpression_3391_149_370()) return true;
    }
    }
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3_112()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_Pivot_1849_5_591()
 {
    if (jj_scan_token(K_PIVOT)) return true;
    if (jj_scan_token(266)) return true;
    if (jj_3R_PivotFunctionItems_1787_5_742()) return true;
    if (jj_scan_token(K_FOR)) return true;
    if (jj_3R_PivotForColumns_1772_5_737()) return true;
    if (jj_scan_token(K_IN)) return true;
    if (jj_scan_token(266)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_47()) {
    jj_scanpos = xsp;
    if (jj_3R_Pivot_1853_7_745()) return true;
    }
    if (jj_scan_token(267)) return true;
    if (jj_scan_token(267)) return true;
    xsp = jj_scanpos;
    if (jj_3R_Pivot_1856_7_746()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_JsonExpression_3374_9_446()
 {
    if (jj_scan_token(307)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_JsonExpression_3373_9_445()
 {
    if (jj_scan_token(306)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_JsonExpression_3372_9_444()
 {
    if (jj_scan_token(305)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(263)) {
    jj_scanpos = xsp;
    if (jj_scan_token(254)) return true;
    }
    return false;
  }

  private boolean jj_3R_JsonExpression_3371_9_364()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonExpression_3371_9_443()) {
    jj_scanpos = xsp;
    if (jj_3R_JsonExpression_3372_9_444()) {
    jj_scanpos = xsp;
    if (jj_3R_JsonExpression_3373_9_445()) {
    jj_scanpos = xsp;
    if (jj_3R_JsonExpression_3374_9_446()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_JsonExpression_3371_9_443()
 {
    if (jj_scan_token(304)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(263)) {
    jj_scanpos = xsp;
    if (jj_scan_token(254)) return true;
    }
    return false;
  }

  private boolean jj_3R_PivotMultiInItems_1835_5_767()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_ExpressionListItem_1821_5_766()) return true;
    return false;
  }

  private boolean jj_3R_JsonExpression_3370_5_189()
 {
    if (jj_3R_Column_1307_5_114()) return true;
    Token xsp;
    if (jj_3R_JsonExpression_3371_9_364()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_JsonExpression_3371_9_364()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_PivotMultiInItems_1834_4_758()
 {
    if (jj_3R_ExpressionListItem_1821_5_766()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_PivotMultiInItems_1835_5_767()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_ExpressionListItem_1824_6_773()
 {
    if (jj_3R_Alias_1690_5_205()) return true;
    return false;
  }

  private boolean jj_3R_DateTimeLiteralExpression_3359_5_194()
 {
    if (jj_scan_token(K_DATETIMELITERAL)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_ExpressionListItem_1821_5_766()
 {
    if (jj_scan_token(266)) return true;
    if (jj_3R_SimpleExpressionList_2891_5_146()) return true;
    if (jj_scan_token(267)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ExpressionListItem_1824_6_773()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_PivotSelectExprItem_1811_15_416()
 {
    if (jj_3R_Alias_1690_5_205()) return true;
    return false;
  }

  private boolean jj_3R_NumericBind_3348_5_187()
 {
    if (jj_scan_token(272)) return true;
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_PivotSelectExprItem_1810_7_296()
 {
    if (jj_3R_SimpleExpression_3054_5_115()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PivotSelectExprItem_1811_15_416()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_UserVariable_3334_12_358()
 {
    if (jj_scan_token(277)) return true;
    return false;
  }

  private boolean jj_3R_UserVariable_3336_7_359()
 {
    if (jj_scan_token(270)) return true;
    if (jj_3R_RelObjectNameExt2_1397_5_125()) return true;
    return false;
  }

  private boolean jj_3R_PivotSingleInItems_1799_5_297()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_PivotSelectExprItem_1810_7_296()) return true;
    return false;
  }

  private boolean jj_3R_UserVariable_3334_5_175()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(303)) {
    jj_scanpos = xsp;
    if (jj_3R_UserVariable_3334_12_358()) return true;
    }
    if (jj_3R_RelObjectNameExt2_1397_5_125()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_UserVariable_3336_7_359()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_PivotSingleInItems_1798_4_134()
 {
    if (jj_3R_PivotSelectExprItem_1810_7_296()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_PivotSingleInItems_1799_5_297()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_Wait_4863_5_719()
 {
    if (jj_scan_token(K_WAIT)) return true;
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_PivotFunctionItems_1788_7_757()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_FunctionItem_1761_5_756()) return true;
    return false;
  }

  private boolean jj_3R_PivotFunctionItems_1787_5_742()
 {
    if (jj_3R_FunctionItem_1761_5_756()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_PivotFunctionItems_1788_7_757()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_JdbcNamedParameter_3322_5_186()
 {
    if (jj_scan_token(272)) return true;
    if (jj_3R_RelObjectNameExt2_1397_5_125()) return true;
    return false;
  }

  private boolean jj_3R_PivotForColumns_1774_11_755()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_Column_1307_5_114()) return true;
    return false;
  }

  private boolean jj_3R_PivotForColumns_1776_7_741()
 {
    if (jj_3R_Column_1307_5_114()) return true;
    return false;
  }

  private boolean jj_3R_PivotForColumns_1773_9_740()
 {
    if (jj_scan_token(266)) return true;
    if (jj_3R_Column_1307_5_114()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_PivotForColumns_1774_11_755()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_NextValExpression_3311_5_195()
 {
    if (jj_scan_token(K_NEXTVAL)) return true;
    if (jj_scan_token(K_FOR)) return true;
    if (jj_3R_RelObjectNameList_1294_5_226()) return true;
    return false;
  }

  private boolean jj_3R_AlterTable_4845_5_102()
 {
    if (jj_scan_token(K_ALTER)) return true;
    if (jj_scan_token(K_TABLE)) return true;
    return false;
  }

  private boolean jj_3R_FunctionItem_1762_15_765()
 {
    if (jj_3R_Alias_1690_5_205()) return true;
    return false;
  }

  private boolean jj_3R_PivotForColumns_1772_5_737()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PivotForColumns_1773_9_740()) {
    jj_scanpos = xsp;
    if (jj_3R_PivotForColumns_1776_7_741()) return true;
    }
    return false;
  }

  private boolean jj_3R_Alias_1696_72_629()
 {
    if (jj_3R_ColDataType_4230_5_381()) return true;
    return false;
  }

  private boolean jj_3R_FunctionItem_1761_5_756()
 {
    if (jj_3R_Function_3729_5_171()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_FunctionItem_1762_15_765()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_98()
 {
    if (jj_3R_AnalyticExpression_3469_5_185()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3288_7_633()
 {
    if (jj_scan_token(302)) return true;
    if (jj_3R_ColDataType_4230_5_381()) return true;
    return false;
  }

  private boolean jj_3_110()
 {
    if (jj_scan_token(266)) return true;
    if (jj_3R_SubSelect_3865_5_169()) return true;
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_Identifier_1749_9_747()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(260)) {
    jj_scanpos = xsp;
    if (jj_scan_token(264)) return true;
    }
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3286_7_632()
 {
    if (jj_scan_token(300)) return true;
    if (jj_3R_SimpleExpression_3054_5_115()) return true;
    if (jj_scan_token(301)) return true;
    return false;
  }

  private boolean jj_3_111()
 {
    if (jj_3R_IntervalExpressionWithoutInterval_3412_5_196()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3279_9_631()
 {
    if (jj_scan_token(K_COLLATE)) return true;
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3275_11_281()
 {
    if (jj_scan_token(266)) return true;
    if (jj_3R_SimpleExpression_3054_5_115()) return true;
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3273_11_280()
 {
    if (jj_scan_token(266)) return true;
    if (jj_3R_SubSelect_3865_5_169()) return true;
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_SQLServerHints_1716_31_750()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_SQLServerHint_1706_9_749()) return true;
    return false;
  }

  private boolean jj_3R_MySQLIndexHint_1737_10_748()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_Identifier_1749_9_747()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3271_11_279()
 {
    if (jj_scan_token(299)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    if (jj_scan_token(297)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3269_11_278()
 {
    if (jj_scan_token(298)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    if (jj_scan_token(297)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3267_11_277()
 {
    if (jj_scan_token(296)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    if (jj_scan_token(297)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3265_11_276()
 {
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_Alias_1695_45_592()
 {
    if (jj_3R_ColDataType_4230_5_381()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3263_11_275()
 {
    if (jj_3R_Column_1307_5_114()) return true;
    return false;
  }

  private boolean jj_3R_MySQLIndexHint_1729_9_302()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(221)) {
    jj_scanpos = xsp;
    if (jj_scan_token(192)) {
    jj_scanpos = xsp;
    if (jj_scan_token(98)) {
    jj_scanpos = xsp;
    if (jj_scan_token(81)) return true;
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_scan_token(103)) {
    jj_scanpos = xsp;
    if (jj_scan_token(115)) return true;
    }
    if (jj_scan_token(266)) return true;
    if (jj_3R_Identifier_1749_9_747()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_MySQLIndexHint_1737_10_748()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_Alias_1691_46_378()
 {
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3_109()
 {
    if (jj_3R_NextValExpression_3311_5_195()) return true;
    return false;
  }

  private boolean jj_3_108()
 {
    if (jj_3R_DateTimeLiteralExpression_3359_5_194()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3257_11_274()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(206)) {
    jj_scanpos = xsp;
    if (jj_scan_token(45)) return true;
    }
    return false;
  }

  private boolean jj_3_154()
 {
    if (jj_scan_token(K_COLUMN)) return true;
    return false;
  }

  private boolean jj_3_105()
 {
    if (jj_3R_Function_3729_5_171()) return true;
    return false;
  }

  private boolean jj_3_107()
 {
    if (jj_3R_CastExpression_3552_5_193()) return true;
    return false;
  }

  private boolean jj_3_104()
 {
    if (jj_3R_FullTextSearch_3684_5_191()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3252_11_273()
 {
    if (jj_scan_token(S_HEX)) return true;
    return false;
  }

  private boolean jj_3_103()
 {
    if (jj_3R_FunctionWithCondParams_3709_5_190()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3250_11_272()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3_102()
 {
    if (jj_3R_JsonExpression_3370_5_189()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3248_11_271()
 {
    if (jj_scan_token(S_DOUBLE)) return true;
    return false;
  }

  private boolean jj_3_106()
 {
    if (jj_3R_IntervalExpression_3390_1_192()) return true;
    return false;
  }

  private boolean jj_3R_SQLServerHints_1715_5_303()
 {
    if (jj_scan_token(K_WITH)) return true;
    if (jj_scan_token(266)) return true;
    if (jj_3R_SQLServerHint_1706_9_749()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_SQLServerHints_1716_31_750()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3244_11_270()
 {
    if (jj_3R_Function_3729_5_171()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_98()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3242_11_269()
 {
    if (jj_3R_FullTextSearch_3684_5_191()) return true;
    return false;
  }

  private boolean jj_3R_SQLServerHint_1708_9_760()
 {
    if (jj_scan_token(K_NOLOCK)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3240_11_268()
 {
    if (jj_3R_FunctionWithCondParams_3709_5_190()) return true;
    return false;
  }

  private boolean jj_3R_SQLServerHint_1706_9_759()
 {
    if (jj_scan_token(K_INDEX)) return true;
    if (jj_scan_token(266)) return true;
    if (jj_3R_RelObjectName_1350_5_133()) return true;
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_SQLServerHint_1706_9_749()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SQLServerHint_1706_9_759()) {
    jj_scanpos = xsp;
    if (jj_3R_SQLServerHint_1708_9_760()) return true;
    }
    return false;
  }

  private boolean jj_3R_SetOperationList_1570_145_666()
 {
    if (jj_scan_token(K_DISTINCT)) return true;
    return false;
  }

  private boolean jj_3R_Alias_1696_18_593()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_RelObjectName_1350_5_133()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Alias_1696_72_629()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3238_11_267()
 {
    if (jj_3R_JsonExpression_3370_5_189()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3217_31_410()
 {
    if (jj_scan_token(273)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3236_11_266()
 {
    if (jj_3R_XMLSerializeExpr_3795_5_413()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3234_11_265()
 {
    if (jj_3R_MySQLGroupConcat_3819_5_412()) return true;
    return false;
  }

  private boolean jj_3_101()
 {
    if (jj_3R_ExtractExpression_3533_5_188()) return true;
    return false;
  }

  private boolean jj_3_100()
 {
    if (jj_3R_NumericBind_3348_5_187()) return true;
    return false;
  }

  private boolean jj_3_46()
 {
    if (jj_scan_token(266)) return true;
    if (jj_3R_RelObjectName_1350_5_133()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Alias_1695_45_592()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_Alias_1696_18_593()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_SelectItemsList_1637_67_675()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_SelectItem_1658_5_674()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3228_11_264()
 {
    if (jj_3R_UserVariable_3334_5_175()) return true;
    return false;
  }

  private boolean jj_3R_Alias_1691_11_377()
 {
    if (jj_3R_RelObjectNameWithoutStart_1363_5_450()) return true;
    return false;
  }

  private boolean jj_3_99()
 {
    if (jj_3R_JdbcNamedParameter_3322_5_186()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3224_11_263()
 {
    if (jj_3R_SimpleJdbcParameter_2313_5_309()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3222_11_262()
 {
    if (jj_3R_CaseWhenExpression_3570_5_411()) return true;
    return false;
  }

  private boolean jj_3R_Alias_1690_6_376()
 {
    if (jj_scan_token(K_AS)) return true;
    return false;
  }

  private boolean jj_3R_Alias_1690_5_205()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Alias_1690_6_376()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_Alias_1691_11_377()) {
    jj_scanpos = xsp;
    if (jj_3R_Alias_1691_46_378()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3_46()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3220_9_261()
 {
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3217_7_259()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PrimaryExpression_3217_7_409()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3217_31_410()) return true;
    }
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3218_6_260()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(274)) {
    jj_scanpos = xsp;
    if (jj_scan_token(286)) {
    jj_scanpos = xsp;
    if (jj_scan_token(278)) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3217_7_409()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3217_5_117()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PrimaryExpression_3217_7_259()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PrimaryExpression_3218_6_260()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PrimaryExpression_3220_9_261()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3222_11_262()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3224_11_263()) {
    jj_scanpos = xsp;
    if (jj_3_99()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3228_11_264()) {
    jj_scanpos = xsp;
    if (jj_3_100()) {
    jj_scanpos = xsp;
    if (jj_3_101()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3234_11_265()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3236_11_266()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3238_11_267()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3240_11_268()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3242_11_269()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3244_11_270()) {
    jj_scanpos = xsp;
    if (jj_3_106()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3248_11_271()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3250_11_272()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3252_11_273()) {
    jj_scanpos = xsp;
    if (jj_3_107()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3257_11_274()) {
    jj_scanpos = xsp;
    if (jj_3_108()) {
    jj_scanpos = xsp;
    if (jj_3_109()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3263_11_275()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3265_11_276()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3267_11_277()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3269_11_278()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3271_11_279()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3273_11_280()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3275_11_281()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_PrimaryExpression_3279_9_631()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_111()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PrimaryExpression_3286_7_632()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_PrimaryExpression_3288_7_633()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_SetOperationList_1570_111_665()
 {
    if (jj_scan_token(K_ALL)) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_1570_111_612()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SetOperationList_1570_111_665()) {
    jj_scanpos = xsp;
    if (jj_3R_SetOperationList_1570_145_666()) return true;
    }
    return false;
  }

  private boolean jj_3R_AllTableColumns_1674_6_132()
 {
    if (jj_3R_Table_1410_5_213()) return true;
    if (jj_scan_token(270)) return true;
    if (jj_scan_token(269)) return true;
    return false;
  }

  private boolean jj_3_45()
 {
    if (jj_3R_AllTableColumns_1674_6_132()) return true;
    return false;
  }

  private boolean jj_3R_WithList_1611_60_541()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_WithItem_1624_6_458()) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_1576_93_614()
 {
    if (jj_3R_Values_843_5_606()) return true;
    return false;
  }

  private boolean jj_3R_MultiplicativeExpression_3165_39_183()
 {
    if (jj_scan_token(294)) return true;
    return false;
  }

  private boolean jj_3R_MultiplicativeExpression_3164_39_182()
 {
    if (jj_scan_token(K_DIV)) return true;
    return false;
  }

  private boolean jj_3R_MultiplicativeExpression_3163_39_181()
 {
    if (jj_scan_token(293)) return true;
    return false;
  }

  private boolean jj_3R_SelectItem_1661_5_707()
 {
    if (jj_3R_SelectExpressionItem_1649_7_723()) return true;
    return false;
  }

  private boolean jj_3R_SelectExpressionItem_1650_15_735()
 {
    if (jj_3R_Alias_1690_5_205()) return true;
    return false;
  }

  private boolean jj_3R_SelectItem_1659_5_706()
 {
    if (jj_3R_AllTableColumns_1674_6_132()) return true;
    return false;
  }

  private boolean jj_3R_SelectItem_1657_6_705()
 {
    if (jj_scan_token(269)) return true;
    return false;
  }

  private boolean jj_3R_SelectItem_1658_5_674()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SelectItem_1657_6_705()) {
    jj_scanpos = xsp;
    if (jj_3R_SelectItem_1659_5_706()) {
    jj_scanpos = xsp;
    if (jj_3R_SelectItem_1661_5_707()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_BitwiseXor_3189_9_598()
 {
    if (jj_scan_token(295)) return true;
    if (jj_3R_PrimaryExpression_3217_5_117()) return true;
    return false;
  }

  private boolean jj_3R_BitwiseXor_3187_5_184()
 {
    if (jj_3R_PrimaryExpression_3217_5_117()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_BitwiseXor_3189_9_598()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_SelectExpressionItem_1649_7_723()
 {
    if (jj_3R_Condition_2614_5_154()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SelectExpressionItem_1650_15_735()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_MultiplicativeExpression_3162_23_180()
 {
    if (jj_scan_token(269)) return true;
    return false;
  }

  private boolean jj_3_150()
 {
    if (jj_scan_token(K_ON)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(53)) {
    jj_scanpos = xsp;
    if (jj_scan_token(219)) return true;
    }
    return false;
  }

  private boolean jj_3R_SetOperationList_1576_70_613()
 {
    if (jj_3R_PlainSelect_1477_5_605()) return true;
    return false;
  }

  private boolean jj_3_149()
 {
    if (jj_scan_token(K_ON)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(53)) {
    jj_scanpos = xsp;
    if (jj_scan_token(219)) return true;
    }
    return false;
  }

  private boolean jj_3R_SetOperationList_1576_68_583()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SetOperationList_1576_70_613()) {
    jj_scanpos = xsp;
    if (jj_3R_SetOperationList_1576_93_614()) return true;
    }
    return false;
  }

  private boolean jj_3R_SelectItemsList_1637_5_636()
 {
    if (jj_3R_SelectItem_1658_5_674()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_SelectItemsList_1637_67_675()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_AdditiveExpression_3136_39_178()
 {
    if (jj_scan_token(286)) return true;
    return false;
  }

  private boolean jj_3_97()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_MultiplicativeExpression_3162_23_180()) {
    jj_scanpos = xsp;
    if (jj_3R_MultiplicativeExpression_3163_39_181()) {
    jj_scanpos = xsp;
    if (jj_3R_MultiplicativeExpression_3164_39_182()) {
    jj_scanpos = xsp;
    if (jj_3R_MultiplicativeExpression_3165_39_183()) return true;
    }
    }
    }
    if (jj_3R_BitwiseXor_3187_5_184()) return true;
    return false;
  }

  private boolean jj_3R_WithItem_1625_8_548()
 {
    if (jj_scan_token(266)) return true;
    if (jj_3R_SelectItemsList_1637_5_636()) return true;
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_WithItem_1624_8_547()
 {
    if (jj_scan_token(K_RECURSIVE)) return true;
    return false;
  }

  private boolean jj_3R_WithItem_1624_6_458()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_WithItem_1624_8_547()) jj_scanpos = xsp;
    if (jj_3R_RelObjectName_1350_5_133()) return true;
    xsp = jj_scanpos;
    if (jj_3R_WithItem_1625_8_548()) jj_scanpos = xsp;
    if (jj_scan_token(K_AS)) return true;
    if (jj_scan_token(266)) return true;
    if (jj_3R_SelectBody_1445_5_219()) return true;
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_MultiplicativeExpression_3157_5_179()
 {
    if (jj_3R_BitwiseXor_3187_5_184()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_97()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_148()
 {
    if (jj_scan_token(K_ON)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(53)) {
    jj_scanpos = xsp;
    if (jj_scan_token(219)) return true;
    }
    return false;
  }

  private boolean jj_3_147()
 {
    if (jj_scan_token(K_ON)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(53)) {
    jj_scanpos = xsp;
    if (jj_scan_token(219)) return true;
    }
    return false;
  }

  private boolean jj_3R_SetOperationList_1568_48_550()
 {
    if (jj_3R_Values_843_5_606()) return true;
    return false;
  }

  private boolean jj_3R_WithList_1611_5_383()
 {
    if (jj_scan_token(K_WITH)) return true;
    if (jj_3R_WithItem_1624_6_458()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_WithList_1611_60_541()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_AdditiveExpression_3135_10_177()
 {
    if (jj_scan_token(274)) return true;
    return false;
  }

  private boolean jj_3_145()
 {
    if (jj_scan_token(K_COLUMN)) return true;
    return false;
  }

  private boolean jj_3_96()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AdditiveExpression_3135_10_177()) {
    jj_scanpos = xsp;
    if (jj_3R_AdditiveExpression_3136_39_178()) return true;
    }
    if (jj_3R_MultiplicativeExpression_3157_5_179()) return true;
    return false;
  }

  private boolean jj_3_44()
 {
    if (jj_scan_token(K_FETCH)) return true;
    return false;
  }

  private boolean jj_3R_AdditiveExpression_3133_5_360()
 {
    if (jj_3R_MultiplicativeExpression_3157_5_179()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_96()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_43()
 {
    if (jj_scan_token(K_OFFSET)) return true;
    return false;
  }

  private boolean jj_3_42()
 {
    if (jj_scan_token(K_LIMIT)) return true;
    return false;
  }

  private boolean jj_3R_AlterExpression_4654_17_217()
 {
    if (jj_3R_AlterExpressionColumnDropNotNull_4563_5_382()) return true;
    return false;
  }

  private boolean jj_3R_BitwiseAndOr_3110_25_442()
 {
    if (jj_scan_token(292)) return true;
    return false;
  }

  private boolean jj_3_146()
 {
    if (jj_3R_AlterExpressionColumnDataType_4545_5_215()) return true;
    return false;
  }

  private boolean jj_3R_BitwiseAndOr_3108_25_441()
 {
    if (jj_scan_token(291)) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_1576_18_582()
 {
    if (jj_scan_token(266)) return true;
    if (jj_3R_SelectBody_1445_5_219()) return true;
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3_153()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_145()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_146()) {
    jj_scanpos = xsp;
    if (jj_3R_AlterExpression_4654_17_217()) return true;
    }
    return false;
  }

  private boolean jj_3R_SetOperationList_1568_25_549()
 {
    if (jj_3R_PlainSelect_1477_5_605()) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_1583_10_465()
 {
    if (jj_3R_Fetch_2425_5_558()) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_1573_19_554()
 {
    if (jj_scan_token(K_EXCEPT)) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_1582_10_464()
 {
    if (jj_3R_Offset_2403_5_557()) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_1572_19_553()
 {
    if (jj_scan_token(K_MINUS)) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_1568_23_460()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SetOperationList_1568_25_549()) {
    jj_scanpos = xsp;
    if (jj_3R_SetOperationList_1568_48_550()) return true;
    }
    return false;
  }

  private boolean jj_3R_SetOperationList_1581_10_463()
 {
    if (jj_3R_LimitWithOffset_2338_5_556()) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_1571_19_552()
 {
    if (jj_scan_token(K_INTERSECT)) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_1580_10_462()
 {
    if (jj_3R_OrderByElements_2283_5_555()) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_1570_18_551()
 {
    if (jj_scan_token(K_UNION)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SetOperationList_1570_111_612()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_SetOperationList_1570_17_461()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SetOperationList_1570_18_551()) {
    jj_scanpos = xsp;
    if (jj_3R_SetOperationList_1571_19_552()) {
    jj_scanpos = xsp;
    if (jj_3R_SetOperationList_1572_19_553()) {
    jj_scanpos = xsp;
    if (jj_3R_SetOperationList_1573_19_554()) return true;
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_SetOperationList_1576_18_582()) {
    jj_scanpos = xsp;
    if (jj_3R_SetOperationList_1576_68_583()) return true;
    }
    return false;
  }

  private boolean jj_3R_AlterExpression_4640_16_216()
 {
    if (jj_scan_token(K_KEY)) return true;
    return false;
  }

  private boolean jj_3R_BitwiseAndOr_3106_13_440()
 {
    if (jj_scan_token(290)) return true;
    return false;
  }

  private boolean jj_3_151()
 {
    if (jj_scan_token(K_PRIMARY)) return true;
    if (jj_scan_token(K_KEY)) return true;
    return false;
  }

  private boolean jj_3R_BitwiseAndOr_3104_13_439()
 {
    if (jj_scan_token(289)) return true;
    return false;
  }

  private boolean jj_3_152()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AlterExpression_4640_16_216()) {
    jj_scanpos = xsp;
    if (jj_scan_token(103)) return true;
    }
    if (jj_3R_RelObjectName_1350_5_133()) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_1567_14_459()
 {
    if (jj_scan_token(266)) return true;
    if (jj_3R_SelectBody_1445_5_219()) return true;
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3R_BitwiseAndOr_3103_9_361()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_BitwiseAndOr_3104_13_439()) {
    jj_scanpos = xsp;
    if (jj_3R_BitwiseAndOr_3106_13_440()) {
    jj_scanpos = xsp;
    if (jj_3R_BitwiseAndOr_3108_25_441()) {
    jj_scanpos = xsp;
    if (jj_3R_BitwiseAndOr_3110_25_442()) return true;
    }
    }
    }
    if (jj_3R_AdditiveExpression_3133_5_360()) return true;
    return false;
  }

  private boolean jj_3R_BitwiseAndOr_3101_5_176()
 {
    if (jj_3R_AdditiveExpression_3133_5_360()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_BitwiseAndOr_3103_9_361()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_SetOperationList_1564_5_384()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SetOperationList_1567_14_459()) {
    jj_scanpos = xsp;
    if (jj_3R_SetOperationList_1568_23_460()) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_SetOperationList_1570_17_461()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_SetOperationList_1580_10_462()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_SetOperationList_1581_10_463()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_SetOperationList_1582_10_464()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_SetOperationList_1583_10_465()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_39()
 {
    if (jj_scan_token(K_WAIT)) return true;
    return false;
  }

  private boolean jj_3_41()
 {
    if (jj_scan_token(K_OPTIMIZE)) return true;
    return false;
  }

  private boolean jj_3_95()
 {
    if (jj_scan_token(OP_CONCAT)) return true;
    if (jj_3R_BitwiseAndOr_3101_5_176()) return true;
    return false;
  }

  private boolean jj_3R_ConcatExpression_3078_5_258()
 {
    if (jj_3R_BitwiseAndOr_3101_5_176()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_95()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_37()
 {
    if (jj_scan_token(K_LIMIT)) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1534_11_693()
 {
    if (jj_scan_token(K_NOWAIT)) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1538_7_656()
 {
    if (jj_scan_token(K_FOR)) return true;
    if (jj_scan_token(K_XML)) return true;
    if (jj_scan_token(K_PATH)) return true;
    if (jj_scan_token(266)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    if (jj_scan_token(267)) return true;
    return false;
  }

  private boolean jj_3_38()
 {
    if (jj_scan_token(K_FETCH)) return true;
    return false;
  }

  private boolean jj_3R_AnyComparisonExpression_3040_40_356()
 {
    if (jj_scan_token(K_SOME)) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1533_11_692()
 {
    if (jj_3R_Wait_4863_5_719()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1532_11_691()
 {
    if (jj_scan_token(K_OF)) return true;
    if (jj_3R_Table_1410_5_213()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1536_6_655()
 {
    if (jj_3R_OptimizeFor_2446_5_685()) return true;
    return false;
  }

  private boolean jj_3_36()
 {
    if (jj_scan_token(K_OFFSET)) return true;
    return false;
  }

  private boolean jj_3_35()
 {
    if (jj_scan_token(K_LIMIT)) return true;
    return false;
  }

  private boolean jj_3_34()
 {
    if (jj_scan_token(K_ORDER)) return true;
    if (jj_scan_token(K_BY)) return true;
    return false;
  }

  private boolean jj_3_33()
 {
    if (jj_scan_token(K_ORDER)) return true;
    if (jj_scan_token(K_SIBLINGS)) return true;
    if (jj_scan_token(K_BY)) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1527_10_653()
 {
    if (jj_3R_LimitWithOffset_2338_5_556()) return true;
    return false;
  }

  private boolean jj_3_40()
 {
    if (jj_scan_token(K_FOR)) return true;
    if (jj_scan_token(K_UPDATE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1532_11_691()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1533_11_692()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1534_11_693()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_94()
 {
    if (jj_3R_UserVariable_3334_5_175()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(268)) {
    jj_scanpos = xsp;
    if (jj_scan_token(288)) return true;
    }
    return false;
  }

  private boolean jj_3R_PlainSelect_1529_6_654()
 {
    if (jj_3R_Fetch_2425_5_558()) return true;
    return false;
  }

  /** Generated Token Manager. */
  public CCJSqlParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[495];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static private int[] jj_la1_4;
  static private int[] jj_la1_5;
  static private int[] jj_la1_6;
  static private int[] jj_la1_7;
  static private int[] jj_la1_8;
  static private int[] jj_la1_9;
  static {
	   jj_la1_init_0();
	   jj_la1_init_1();
	   jj_la1_init_2();
	   jj_la1_init_3();
	   jj_la1_init_4();
	   jj_la1_init_5();
	   jj_la1_init_6();
	   jj_la1_init_7();
	   jj_la1_init_8();
	   jj_la1_init_9();
	}
	private static void jj_la1_init_0() {
	   jj_la1_0 = new int[] {0x0,0x0,0x0,0x4000000,0x0,0x0,0x4020100,0x4020100,0x4020100,0x0,0x4020100,0x0,0x4020100,0x4020100,0x0,0x0,0x0,0x0,0x40184000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000200,0x1000200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xea001004,0xea001004,0x0,0x0,0x0,0x0,0xfa001084,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0xea005004,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfa001084,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xea001004,0x0,0x0,0x0,0xea001004,0xea005004,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xea001004,0xea001004,0xea001004,0xea001004,0xea001004,0xea005004,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xea005004,0x0,0xfa001084,0x4000,0xea001004,0x40180000,0x0,0x40180000,0x0,0x0,0x0,0x0,0x0,0x0,0xea005004,0x0,0xea001004,0x0,0x0,0xea005004,0xea005004,0x0,0x0,0xea005004,0x0,0x0,0x0,0x0,0x0,0x2000,0x0,0x0,0xea001004,0xea005004,0x0,0x0,0x0,0xea001004,0x0,0x0,0x0,0x0,0xfa001004,0x0,0x0,0xea005004,0x2000,0x2000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfa001004,0x0,0xfa001004,0xfa001004,0x0,0x0,0x8000,0x8000,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc00,0xc00,0x0,0x0,0x0,0x0,0xfa001004,0x0,0x80000,0x80000,0x0,0xfa001084,0x0,0x0,0x0,0xfa001004,0x0,0xfa001004,0x0,0xfa001004,0x0,0xfa001004,0xfa001004,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x0,0x0,0x0,0x0,0xea001004,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xea001004,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfa041004,0x0,0x0,0x0,0xfa001004,0xfa001084,0x0,0x0,0xfa001004,0x0,0x4000000,0x0,0x0,0xfa001004,0x0,0x0,0x0,0x0,0xea001004,0x80,0x200000,0x0,0xfa201084,0x0,0xea001004,0x0,0x0,0x0,0x0,0x0,0x0,0x8408000,0x0,0x8408000,0x8408000,0x0,0x8408000,0x8408000,0x0,0x0,0x0,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8408000,0x0,0x0,0x0,0x0,0x8408000,0x0,0x0,0x8408000,0x0,0x0,0x0,0x0,0x0,0x0,0xea001004,0x8408000,0x0,0x0,0x0,0x4000,0xea001004,0x0,0x40100000,0x0,0x80000,0x40180000,0x0,0x0,0x2000000,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x408000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x8000000,0x8000000,0x0,0x8408000,0x0,0x0,0x0,0x108,0x0,0x0,0x0,0xea001004,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xea001004,0x0,0x0,0x0,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000148,0x0,0x0,0x0,0x0,0x100,0x100,0x0,0x100,0x800000,0x0,0x0,0x0,0x800000,0x0,0x0,0x0,0x800000,0x0,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_1() {
	   jj_la1_1 = new int[] {0x0,0x200000,0x0,0x20000000,0x8080c0,0x0,0x20a088c0,0x20a088c0,0x20a088c0,0x0,0x20a088c0,0x0,0x20a088c0,0x20a088c0,0x20,0x0,0x20,0x0,0x10030002,0x0,0x20,0x0,0x0,0x0,0x0,0x0,0x400,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x20,0x20,0x20,0x5dc348da,0x5dc348da,0x0,0x0,0x0,0x0,0x5dc368da,0x0,0x20,0x20,0x0,0x0,0x20,0x20,0x20,0x0,0x0,0x20,0x0,0x100000,0x100000,0x0,0x0,0x0,0x4dc340da,0x20,0x0,0x0,0x20,0x20,0x20,0x0,0x20,0x0,0x20,0x0,0x5dc368da,0x0,0x0,0x20,0x0,0x0,0x20,0x20,0x20,0x0,0x0,0x20,0x0,0x20,0x5dc348da,0x0,0x0,0x0,0x5dc348da,0x4dc340da,0x0,0x0,0x0,0x0,0x20,0x0,0x200000,0x20,0x0,0x20,0x0,0x4dc340da,0x4dc348da,0x4dc340da,0x5dc348da,0x5dc368da,0x4dc340da,0x0,0x0,0x0,0x2000000,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x2000000,0x0,0x0,0x0,0x0,0x20,0x0,0x0,0x20,0x4dc340da,0x0,0x5dc368da,0x0,0x4dc340da,0x10030002,0x20,0x10030002,0x0,0x20,0x0,0x0,0x20,0x0,0x4dc340da,0x20,0x5dc348da,0x20,0x20,0x4dc340da,0x4dc340da,0x20,0x0,0x4dc340da,0x0,0x0,0x0,0x0,0x20,0x1020,0x0,0x0,0x5dc348da,0x4dc340da,0x0,0x0,0x0,0x5dc348da,0x20,0x20,0x20,0x20,0x5dc368da,0x20,0x0,0x4dc340da,0x1020,0x1020,0x0,0x0,0x0,0x0,0x1000,0x1000,0x0,0x20,0x0,0x20,0x0,0x20,0x0,0x0,0x0,0x0,0x100,0x20,0x5dc368da,0x20,0x5dc368da,0x5dc368da,0x0,0x20,0x400000,0x400000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x5dc368da,0x0,0x0,0x0,0x0,0x5dc368da,0x0,0x0,0x0,0x5dc368da,0x0,0x5dc368da,0x0,0x5dc368da,0x0,0x5dc368da,0x5dc368da,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x20,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000000,0x0,0x0,0x0,0x0,0x0,0x2000,0x0,0x0,0x0,0x0,0x2000,0x5dc348da,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x5dc348da,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x5dc368da,0x0,0x0,0x0,0x5dc368da,0x5dc368da,0x0,0x80000000,0x5dc368da,0x0,0x0,0x20,0x0,0x5dc368da,0x20,0x0,0x0,0x0,0x5dc348da,0x2000000,0x0,0x0,0x5fc368da,0x0,0x4dc348da,0x0,0x0,0x2000000,0x0,0x0,0x0,0x6402c5,0x20,0x6402c5,0x6402c5,0x0,0x6402c5,0x6402c5,0x0,0x0,0x0,0x0,0x0,0x800,0x800,0x0,0x20,0x0,0x0,0x0,0x6402c5,0x20,0x200,0x0,0x0,0x6402c5,0x0,0x0,0x6402c5,0x200,0x200000,0x200000,0x200,0x0,0x0,0x4dc348da,0x6402c5,0x0,0x1000000,0x0,0x0,0x5dc348da,0x0,0x0,0x0,0x30002,0x10030002,0x0,0x0,0x2,0x2,0x0,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x240040,0x400285,0x1000000,0x0,0x0,0x20,0x20,0x0,0x20,0x0,0x0,0x0,0x0,0x0,0x6402c5,0x0,0x1080000,0x1080000,0x0,0x0,0x0,0x0,0x4dc348da,0x20,0x0,0x0,0x0,0x0,0x0,0x200000,0x200000,0x0,0x200000,0x200000,0x0,0x0,0x0,0x0,0x0,0x1,0x4dc34ada,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x208,0x0,0x0,0x0,0x20000080,0x0,0x20,0x8,0x20,0x20200000,0x20200000,0x20,0x20200000,0x4000,0x0,0x0,0x4000,0x0,0x0,0x0,0x0,0x4000,0x0,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_2() {
	   jj_la1_2 = new int[] {0x0,0x0,0x0,0x60,0x2000100,0x0,0x2000160,0x2000160,0x2000160,0x0,0x2000160,0x0,0x2000160,0x2000160,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x4000,0x0,0x0,0x80000,0x80000,0x200,0x200000,0x100000,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x408e413,0x408e413,0x100000,0x0,0x0,0x0,0x1408e493,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000000,0x40000000,0x0,0x0,0x0,0x8e413,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1408e493,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x418e413,0x0,0x0,0x0,0x408e413,0x8e413,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8e413,0x408e413,0x8e413,0x408e413,0x418e413,0x8e413,0x0,0x0,0x0,0x0,0x0,0x100000,0x0,0x0,0x0,0x4000000,0x20000000,0x0,0x0,0x10000,0x0,0x0,0x8,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8e413,0x0,0x1408e493,0x0,0x8e413,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x0,0x0,0x8e413,0x0,0x408e413,0x0,0x0,0x8e413,0x8e413,0x0,0x0,0x8e413,0x0,0x0,0x10,0x10,0x0,0x200000,0x0,0x0,0x408e413,0x8e413,0x0,0x0,0x20000,0x408e413,0x0,0x0,0x0,0x0,0x1408e413,0x0,0x0,0x8e413,0x200000,0x200000,0x0,0x0,0x200000,0x0,0x200000,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x1408e413,0x0,0x1408e413,0x1c08e413,0x0,0x0,0x0,0x0,0x2000,0x2000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000,0x0,0x0,0x0,0x0,0x2000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1408e493,0x0,0x0,0x0,0x0,0x1408e413,0x0,0x0,0x80,0x1408e413,0x0,0x1408e413,0x0,0x1408e413,0x0,0x1408e413,0x1408e413,0x0,0x0,0x0,0x4,0x0,0x4,0x0,0x0,0x0,0x4000,0x0,0x0,0x0,0x0,0x100000,0x100000,0x110000,0x10000,0x110000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x0,0x0,0x408e413,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x408e413,0x0,0x2000,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x1408e413,0x8000,0x8000,0x0,0x1408e413,0x1408e493,0x0,0x0,0x1408e413,0x0,0x60,0x0,0x0,0x1408e413,0x0,0x0,0x0,0x0,0x408e413,0x0,0x0,0x0,0x1408e413,0x0,0x408e413,0x0,0x0,0x0,0x0,0x0,0x0,0x44010,0x0,0x44010,0x44010,0x0,0x44010,0x44010,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x44010,0x0,0x0,0x0,0x0,0x44010,0x0,0x400000,0x44010,0x0,0x0,0x0,0x0,0x0,0x0,0x408e413,0x44010,0x0,0x1,0x0,0x0,0x408e413,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x4010,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x44010,0x0,0x1,0x1,0x0,0x0,0x0,0x0,0x408e413,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x40ce413,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x40,0x0,0x40,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x1000000,0x0,0x800000,0x0,0x0,};
	}
	private static void jj_la1_init_3() {
	   jj_la1_3 = new int[] {0x0,0x400,0x0,0x0,0x0,0x0,0x400,0x400,0x400,0x0,0x400,0x0,0x400,0x400,0x0,0x0,0x0,0x0,0x21000,0x0,0x0,0x0,0x0,0x0,0x20000,0x20000,0x0,0x0,0x0,0x0,0x10,0x10,0x2000000,0x2000000,0x0,0x0,0x0,0x0,0x45389481,0x45389481,0x0,0x0,0x0,0x4000000,0x55389483,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x8000000,0x4,0x2000,0x0,0x40388480,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x55389483,0x0,0x2000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x45389481,0x0,0x0,0x4000000,0x45389481,0x40389480,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40388480,0x40389480,0x40389480,0x45389481,0x45389481,0x40389480,0x0,0x200,0x0,0x0,0x2000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800,0x0,0x0,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40389480,0x0,0x55389483,0x0,0x40389480,0x21000,0x0,0x21000,0x80,0x0,0x4,0x80080,0x0,0x0,0x40389480,0x0,0x45389481,0x0,0x0,0x40389480,0x40389480,0x0,0x0,0x40389480,0x0,0x0,0x20,0x20,0x0,0x1010300,0x0,0x0,0x45789481,0x40389480,0x0,0x0,0x4,0x45789481,0x0,0x0,0x0,0x0,0x55389483,0x0,0x0,0x40389480,0x1010300,0x1010300,0x0,0x0,0x0,0x0,0x1000100,0x1000100,0x0,0x10200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x55389483,0x0,0x55389483,0x55389483,0x0,0x0,0x0,0x0,0x200000,0x200000,0x0,0x0,0x0,0x4000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x55389483,0x0,0x0,0x0,0x0,0x55389483,0x0,0x0,0x0,0x55389483,0x0,0x55389483,0x0,0x55389483,0x0,0x55389483,0x55389483,0x0,0x0,0x2000008,0x0,0x0,0x0,0x0,0xc000,0x0,0x0,0x0,0x0,0x0,0x800000,0x10,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x45389481,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x45389481,0x0,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x55389483,0x0,0x0,0x0,0x55389483,0x55389483,0x0,0x0,0x55389483,0x0,0x0,0x0,0x0,0x55389483,0x0,0x0,0x0,0x3,0x45389481,0x0,0x800000,0x0,0x55b89483,0x4,0x40389480,0x0,0x0,0x0,0x0,0x0,0x0,0x80010,0x0,0x80010,0x80010,0x0,0x80010,0x80010,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80010,0x0,0x0,0x80000,0x0,0x80010,0x0,0x0,0x80010,0x0,0x0,0x0,0x0,0x0,0x0,0x40389480,0x80010,0x0,0x0,0x0,0x0,0x45389481,0x2000000,0x0,0x0,0x21000,0x21000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x80010,0x0,0x0,0x0,0x0,0x0,0x80080,0x0,0x40389480,0x0,0x80080,0x0,0x80080,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80080,0x80080,0x0,0x80000,0x40389480,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x400,0x0,0x400,0x80040040,0x80000000,0x0,0x0,0x0,0x0,0x40000,0x0,0x80040040,0x0,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_4() {
	   jj_la1_4 = new int[] {0x0,0x0,0x1,0x0,0x0,0x0,0x1,0x1,0x1,0x0,0x1,0x0,0x1,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1400000,0x1400000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xd5a81180,0xd5a81180,0x0,0x0,0x10000000,0x0,0xd5ad1180,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x44281180,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0xd5ad1180,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x0,0xd5a81180,0x0,0x10000000,0x0,0xd5a81180,0x44281180,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x44281180,0x55281180,0x44281180,0xd5a81180,0xd5a81180,0x44281180,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x100000,0x0,0x0,0x0,0x2,0x0,0x0,0x2,0x0,0x0,0x10000000,0x0,0x0,0x0,0x0,0x44281180,0x0,0xd5ad1180,0x0,0x44281180,0x0,0x0,0x0,0x1000,0x0,0x0,0x0,0x0,0x0,0x44281180,0x0,0xd5a81180,0x0,0x0,0x44281180,0x44281180,0x0,0x0,0x44281180,0x0,0x0,0x0,0x0,0x0,0x20000020,0x0,0x0,0xd5a81180,0x44281180,0x0,0x0,0x0,0xd5a81180,0x0,0x0,0x0,0x0,0xd5ad1180,0x0,0x0,0x44281180,0x20000020,0x20000020,0x20000000,0x20000000,0x0,0x20000000,0x20000020,0x20000020,0x20000000,0x0,0x0,0x0,0x1000000,0x0,0x0,0x400,0x400,0x0,0x0,0x0,0xd5ad1180,0x0,0xd5ad1180,0xd5ad1180,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x0,0x0,0x0,0x40000,0x0,0x0,0x0,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x10000,0x10000,0x10000,0x0,0x0,0x10000,0x10000,0x10000,0x10000,0xd5ad1180,0x0,0x0,0x0,0x0,0xd5ad1180,0x0,0x10000,0x0,0xd5ad1180,0x0,0xd5ad1180,0x0,0xd5ad1180,0x10000,0xd5ad1180,0xd5ad1180,0x10000,0x10000,0x0,0x0,0x10000,0x0,0x10000,0x0,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000,0x10000,0x0,0x0,0x0,0x40000,0x0,0x0,0x0,0x0,0xd5a81180,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xd5a81180,0x0,0x0,0x40000000,0x0,0x0,0x10000000,0x0,0x40000000,0x0,0xd5ad1180,0x0,0x0,0x0,0xd5ad1180,0xd5ad1180,0x0,0x0,0xd5ad1180,0x0,0x0,0x0,0x0,0xd5ad1180,0x0,0x0,0x0,0x0,0xd5a81180,0x0,0x0,0x0,0xd5ad1180,0x0,0x55281180,0x0,0x10000000,0x0,0x10000000,0x0,0x0,0x1050000,0x0,0x1050000,0x1050000,0x0,0x1050000,0x1050000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1050000,0x0,0x0,0x0,0x0,0x1050000,0x0,0x0,0x1050000,0x0,0x0,0x0,0x0,0x0,0x0,0x55281180,0x1050000,0x0,0x0,0x0,0x0,0xd5a81180,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x100,0x100,0x0,0x0,0x0,0x0,0x0,0x40000,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1050000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1050000,0x10000,0x30000,0x30000,0x8,0x0,0x0,0x0,0x55281180,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x55281180,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x2000000,0x0,0x0,0x0,0x0,0x1000000,0x0,0x0,0x1000ee04,0x2000,0x4004,0x400,0x200,0x10008000,0x800,0x0,0x1000ee04,0x8000000,0x0,0x8000000,0x0,};
	}
	private static void jj_la1_init_5() {
	   jj_la1_5 = new int[] {0x0,0x0,0x0,0x40000000,0x0,0x0,0x42040000,0x42040000,0x42040000,0x0,0x42040000,0x0,0x42040000,0x42040000,0x0,0x0,0x0,0x0,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x79e41fc7,0x79e41fc7,0x0,0x0,0x0,0x0,0x79e41fc7,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x42000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x39c419c7,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x0,0x42000000,0x0,0x0,0x79e41fc7,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x2000000,0x0,0x0,0x0,0x79e41fc7,0x0,0x0,0x0,0x79e41fc7,0x39c419c7,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x39c419c7,0x39c419c7,0x39c419c7,0x79e41fc7,0x7be41fc7,0x39c419c7,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x2000000,0x0,0x0,0x0,0x0,0x2000000,0x2000000,0x0,0x0,0x2000,0x0,0x0,0x39c419c7,0x0,0x79e41fc7,0x0,0x39c419c7,0x40000000,0x0,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x39c419c7,0x0,0x79e41fc7,0x0,0x0,0x39c419c7,0x39c419c7,0x0,0x0,0x39c419c7,0x2000000,0x0,0x0,0x0,0x0,0x200000,0x2000000,0x0,0x79e41fc7,0x39c419c7,0x8,0x8,0x0,0x79e41fc7,0x0,0x0,0x0,0x0,0x79e41fc7,0x0,0x0,0x39c419c7,0x200000,0x200000,0x4000000,0x4000000,0x200000,0x0,0x200000,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x0,0x0,0x0,0x0,0x0,0x79e41fc7,0x0,0x79e41fc7,0x79e41fc7,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc00000,0xc00000,0x0,0x0,0xc00000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x79e41fc7,0x0,0x0,0x0,0x18000,0x79e41fc7,0x0,0x0,0x0,0x79e41fc7,0x0,0x79e41fc7,0x0,0x79e41fc7,0x0,0x79e41fc7,0x79e41fc7,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x10,0x0,0x0,0x0,0x0,0x0,0x400000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x79e41fc7,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x79e41fc7,0x0,0x0,0x0,0x0,0x1,0x0,0x800800,0x0,0x800800,0x79e41fc7,0x20,0x20,0x0,0x79e41fc7,0x79e41fc7,0x0,0x0,0x79e41fc7,0x400000,0x0,0x0,0x0,0x79e41fc7,0x0,0x0,0x0,0x0,0x79e41fc7,0x0,0x0,0x2000000,0x7be41fc7,0x0,0x39c419c7,0x0,0x0,0x0,0x0,0x10000000,0x0,0x804081,0x0,0x804081,0x804081,0x0,0x804081,0x804081,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x804081,0x0,0x0,0x0,0x80,0x804081,0x0,0x0,0x804081,0x0,0x0,0x0,0x0,0x0,0x0,0x39c419c7,0x804081,0x0,0x0,0x2000000,0x0,0x79e41fc7,0x0,0x0,0x0,0x40000000,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40080000,0x40000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x804080,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x9000000,0x80000,0x80000,0x0,0x0,0x804081,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x39c419c7,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x39c419c7,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x0,0x0,0x0,0x2000000,0x2000000,0x0,0x2000000,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x20000000,0x0,0x200,0x0,0x400,};
	}
	private static void jj_la1_init_6() {
	   jj_la1_6 = new int[] {0x0,0x18000000,0x0,0x40000,0x20000001,0x0,0x38040001,0x38040001,0x38040001,0x0,0x38040001,0x0,0x38040001,0x38040001,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x0,0x80000,0x80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2db34a,0x2db34a,0x0,0x0,0x0,0x0,0x2df36a,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2cb10a,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2df36a,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2db34a,0x0,0x0,0x0,0x2db34a,0x2db10a,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2cb10a,0x2db34a,0x2db10a,0x2db34a,0x2db34a,0x2db10a,0x0,0x0,0x10,0xc1000000,0x0,0x0,0x0,0x0,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800000,0x0,0x0,0x800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2db10a,0x0,0x2df36a,0x0,0x2db10a,0x0,0x0,0x0,0x0,0x0,0x20000001,0x0,0x0,0x0,0x2db10a,0x0,0x2db34a,0x0,0x0,0x2db10a,0x2db10a,0x0,0x0,0x2db10a,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2db34a,0x2db10a,0x0,0x0,0x20000001,0x2db34a,0x0,0x0,0x0,0x0,0x2df34a,0x0,0x0,0x2db10a,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x0,0x0,0x40,0x40,0x0,0x2df34a,0x0,0x2df34a,0x2df34a,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2df34a,0x0,0x0,0x0,0x0,0x2df36a,0x0,0x4,0x0,0x2df34a,0x0,0x2df34a,0x0,0x2df34a,0x0,0x2df34a,0x2df34a,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x0,0x0,0x0,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0x0,0x0,0x0,0x4000,0x2db34a,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2db34a,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6df34a,0x0,0x0,0x400000,0x2df34a,0x2df36a,0x0,0x0,0x2df34a,0x0,0x0,0x0,0x0,0x2df34a,0x0,0x0,0x0,0x0,0x2db34a,0x0,0x20000,0x0,0x2ff34a,0x0,0x2db34a,0x0,0x0,0x0,0x0,0x0,0x0,0x9287400,0x0,0x9287400,0x9287400,0x0,0x9287400,0x9287400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x0,0x9287400,0x0,0x0,0x0,0x1000000,0x9287400,0x1000000,0x0,0x9287400,0x0,0x8000000,0x8000000,0x0,0x0,0x0,0x2db34a,0x9287400,0x0,0x0,0x0,0x0,0x2db34a,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3000,0x3000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x9004000,0x283400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x0,0x200000,0x9287400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2db34a,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x8000000,0x0,0x8000000,0x8000000,0x0,0x0,0x0,0x0,0x0,0x1000000,0x12db34a,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x8000000,0x8000000,0x0,0x8000000,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x0,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_7() {
	   jj_la1_7 = new int[] {0x400000,0x2020,0x0,0x0,0x0,0x400000,0x2020,0x2020,0x2020,0x400000,0x2020,0x400000,0x2020,0x2020,0x0,0x0,0x0,0x0,0x10010006,0x0,0x0,0x0,0x0,0x0,0x110000,0x110000,0x80,0x80,0x0,0x0,0x0,0x0,0x800,0x800,0x0,0x0,0x0,0x0,0x21013c,0x21013c,0x0,0x800,0x0,0x0,0x6023013c,0x0,0x0,0x0,0x30,0x30,0x0,0x0,0x0,0x2020,0x2030,0x0,0x2000,0x0,0x0,0x0,0x0,0x0,0x21010c,0x0,0x30,0x30,0x0,0x0,0x0,0x2020,0x0,0x2020,0x0,0x0,0x6023013c,0x0,0x0,0x0,0x30,0x30,0x0,0x0,0x0,0x2020,0x2020,0x0,0x0,0x0,0x21013c,0x800,0x0,0x0,0x21013c,0x21013c,0x400,0x400,0x400,0x400,0x0,0x800,0x0,0x0,0x0,0x0,0x0,0x21010c,0x21013c,0x21013c,0x21013c,0x21013c,0x21013c,0x2000,0x0,0x0,0x0,0x0,0x0,0x1000,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x20,0x0,0x0,0x0,0x0,0x20,0x20,0x0,0x0,0x0,0x0,0x0,0x21013c,0x0,0x6023013c,0x0,0x21013c,0x10010006,0x0,0x10010006,0x0,0x0,0x0,0x0,0x0,0x0,0x21013c,0x0,0x21013c,0x0,0x0,0x21013c,0x21013c,0x0,0x0,0x21013c,0x20,0x0,0x0,0x0,0x0,0x0,0x2020,0x0,0x21013c,0x21013c,0x0,0x0,0x2000,0x21013c,0x0,0x0,0x0,0x0,0x6023013c,0x0,0x0,0x21013c,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0x4001,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6023013c,0x0,0x6023013c,0x6023013c,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000000,0x40000000,0x0,0x40000000,0x40000000,0x0,0x0,0x0,0x40000000,0x0,0x40000000,0x40000000,0x0,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6023013c,0x0,0x0,0x0,0xf800000,0x6023013c,0x0,0x0,0x0,0x6023013c,0x0,0x6023013c,0x0,0x6023013c,0x0,0x6023013c,0x6023013c,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x60000000,0x0,0x21013c,0x0,0x0,0x0,0x0,0x0,0x0,0x40000000,0x40000000,0x0,0x0,0x0,0x6021013c,0x0,0x0,0x4000,0x0,0x0,0x0,0x0,0x4000,0x0,0x6023013c,0x0,0x0,0x0,0x6023013c,0x6023013c,0x400,0x0,0x6023013c,0x0,0x0,0x0,0x0,0x6023013c,0x0,0x0,0x0,0x0,0x21013c,0x0,0x0,0x2020,0x6023213c,0x0,0x21013c,0x0,0x0,0x0,0x0,0x0,0x2000,0x60002805,0x0,0x60002805,0x60002805,0x1,0x60002805,0x60002805,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x60002805,0x0,0x0,0x0,0x0,0x60002805,0x0,0x0,0x60002805,0x0,0x0,0x0,0x0,0x0,0x0,0x21013c,0x60002805,0x0,0x0,0x2020,0x0,0x21013c,0x0,0x0,0x40,0x10010000,0x10010004,0x2,0x40000000,0x0,0x0,0x40000000,0x0,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x60000000,0x60000000,0x2805,0x0,0x60000000,0x60000000,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x60002805,0x0,0x8,0x8,0x0,0x1,0x0,0x1,0x21013c,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x1,0x0,0x21013c,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_8() {
	   jj_la1_8 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x400,0x400,0x0,0x400,0x0,0x400,0x400,0x0,0x1000,0x0,0x1000,0x10,0x1000,0x0,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x510,0x510,0x0,0x0,0x0,0x0,0x4067a591,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x110,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x0,0x400,0x0,0x0,0x4067a591,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x400,0x0,0x0,0x0,0x110,0x0,0x0,0x0,0x510,0x190,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x0,0x4000,0x110,0x110,0x110,0x110,0x110,0x190,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x0,0x0,0x0,0x0,0x0,0x400,0x0,0x0,0x0,0x400,0x0,0x190,0x2000,0x40678591,0x0,0x190,0x10,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x110,0x190,0x0,0x510,0x0,0x0,0x190,0x190,0x0,0x400,0x190,0x400,0x400,0x0,0x0,0x0,0x0,0x400,0x400,0x110,0x190,0x0,0x0,0x0,0x510,0x0,0x0,0x0,0x0,0x40678591,0x0,0x400,0x190,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40678591,0x0,0x40678591,0x40678591,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x18000,0x18000,0x0,0x18000,0x18000,0x0,0x0,0x0,0x8000,0x0,0x18400,0x8010,0x0,0x8010,0x0,0x20000,0x20000,0x20400,0x0,0x0,0x20000,0x20000,0x20400,0x20000,0x40678591,0x400,0x0,0x0,0xfff09000,0x40678591,0x400,0x0,0x0,0x40678591,0x400,0x40678591,0x400,0x40678591,0x0,0x40678591,0x40678591,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x0,0x1000,0x0,0x0,0x40040000,0x2000,0x0,0x20000,0x20000,0x40440000,0x40440000,0x0,0x8000,0x200000,0x0,0x1,0x0,0x190,0x400,0x0,0x0,0x0,0x200000,0x4000,0x80,0x80,0x0,0x0,0x40000000,0x18190,0x10,0x0,0x0,0x400,0x0,0x0,0x0,0x0,0x0,0x40678591,0x0,0x0,0x0,0x40678591,0x40678591,0x0,0x0,0x40678591,0x0,0x0,0x0,0x400,0x40678591,0x0,0x0,0x0,0x0,0x110,0x0,0x0,0x400,0x4067a591,0x0,0x110,0x4000,0x0,0x0,0x0,0x0,0x0,0x40041590,0x0,0x40041590,0x40041590,0x0,0x40041590,0x40041590,0x110,0x110,0x110,0x0,0x0,0x0,0x0,0x110,0x0,0x110,0x0,0x0,0x40041590,0x0,0x0,0x0,0x0,0x40041590,0x0,0x0,0x40041590,0x0,0x0,0x0,0x0,0x400,0x400,0x110,0x40041590,0x400,0x0,0x400,0x0,0x110,0x0,0x0,0x0,0x10,0x10,0x0,0x90,0x0,0x0,0x90,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x0,0x0,0x0,0x0,0x400,0x110,0x110,0x4000,0x40040000,0x40040000,0x0,0x40041190,0x400,0x0,0x190,0x190,0x1000,0x1000,0x400,0x0,0x10,0x10,0x10,0x0,0x0,0x40041590,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x110,0x0,0x0,0x110,0x0,0x0,0x400,0x0,0x0,0x400,0x0,0x0,0x0,0x400,0x0,0x0,0x0,0x0,0x510,0x0,0x110,0x110,0x0,0x110,0x0,0x110,0x110,0x1000,0x110,0x110,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_9() {
	   jj_la1_9 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1008d00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1008d00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1008d00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x0,0x0,0x0,0x0,0x1008d00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1008d00,0x0,0x1008d00,0x1008d00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1008d00,0x0,0x0,0x0,0x0,0x1008d00,0x0,0x0,0x0,0x1008d00,0x0,0x1008d00,0x0,0x1008d00,0x0,0x1008d00,0x1008d00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x1e,0x1e,0x0,0x60,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x8000,0x0,0x0,0x0,0xd00,0x0,0x0,0x1000,0x4000,0x8000,0x0,0x0,0x0,0xf0000,0xf0000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1008d00,0x0,0x0,0x0,0x1008d00,0x1008d00,0x0,0x0,0x1008d00,0x0,0x0,0x0,0x0,0x1008d00,0x0,0xf00000,0xf00000,0x0,0x1000000,0x0,0x0,0x0,0x1008d00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0x4000,0x4000,0x0,0x4000,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0x0,0x0,0x0,0x4000,0x0,0x0,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
	}
  final private JJCalls[] jj_2_rtns = new JJCalls[154];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor. */
  public CCJSqlParser(Provider stream) {
	 jj_input_stream = new SimpleCharStream(stream, 1, 1);
	 token_source = new CCJSqlParserTokenManager(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 495; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public CCJSqlParser(String dsl) throws ParseException, TokenMgrException {
	   this(new StringProvider(dsl));
  }

  public void ReInit(String s) {
	  ReInit(new StringProvider(s));
  }
  /** Reinitialise. */
  public void ReInit(Provider stream) {
	if (jj_input_stream == null) {
	   jj_input_stream = new SimpleCharStream(stream, 1, 1);
	} else {
	   jj_input_stream.ReInit(stream, 1, 1);
	}
	if (token_source == null) {
 token_source = new CCJSqlParserTokenManager(jj_input_stream);
	}

	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jjtree.reset();
	 jj_gen = 0;
	 for (int i = 0; i < 495; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public CCJSqlParser(CCJSqlParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 495; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(CCJSqlParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jjtree.reset();
	 jj_gen = 0;
	 for (int i = 0; i < 495; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
	 Token oldToken;
	 if ((oldToken = token).next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 if (token.kind == kind) {
	   jj_gen++;
	   if (++jj_gc > 100) {
		 jj_gc = 0;
		 for (int i = 0; i < jj_2_rtns.length; i++) {
		   JJCalls c = jj_2_rtns[i];
		   while (c != null) {
			 if (c.gen < jj_gen) c.first = null;
			 c = c.next;
		   }
		 }
	   }
	   return token;
	 }
	 token = oldToken;
	 jj_kind = kind;
	 throw generateParseException();
  }

  @SuppressWarnings("serial")
  static private final class LookaheadSuccess extends java.lang.RuntimeException {
    @Override
    public Throwable fillInStackTrace() {
      return this;
    }
  }
  static private final LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
	 if (jj_scanpos == jj_lastpos) {
	   jj_la--;
	   if (jj_scanpos.next == null) {
		 jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
	   } else {
		 jj_lastpos = jj_scanpos = jj_scanpos.next;
	   }
	 } else {
	   jj_scanpos = jj_scanpos.next;
	 }
	 if (jj_rescan) {
	   int i = 0; Token tok = token;
	   while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
	   if (tok != null) jj_add_error_token(kind, i);
	 }
	 if (jj_scanpos.kind != kind) return true;
	 if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
	 return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
	 if (token.next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 jj_gen++;
	 return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
	 Token t = token;
	 for (int i = 0; i < index; i++) {
	   if (t.next != null) t = t.next;
	   else t = t.next = token_source.getNextToken();
	 }
	 return t;
  }

  private int jj_ntk_f() {
	 if ((jj_nt=token.next) == null)
	   return (jj_ntk = (token.next=token_source.getNextToken()).kind);
	 else
	   return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
	 if (pos >= 100) {
		return;
	 }

	 if (pos == jj_endpos + 1) {
	   jj_lasttokens[jj_endpos++] = kind;
	 } else if (jj_endpos != 0) {
	   jj_expentry = new int[jj_endpos];

	   for (int i = 0; i < jj_endpos; i++) {
		 jj_expentry[i] = jj_lasttokens[i];
	   }

	   for (int[] oldentry : jj_expentries) {
		 if (oldentry.length == jj_expentry.length) {
		   boolean isMatched = true;

		   for (int i = 0; i < jj_expentry.length; i++) {
			 if (oldentry[i] != jj_expentry[i]) {
			   isMatched = false;
			   break;
			 }

		   }
		   if (isMatched) {
			 jj_expentries.add(jj_expentry);
			 break;
		   }
		 }
	   }

	   if (pos != 0) {
		 jj_lasttokens[(jj_endpos = pos) - 1] = kind;
	   }
	 }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
	 jj_expentries.clear();
	 boolean[] la1tokens = new boolean[313];
	 if (jj_kind >= 0) {
	   la1tokens[jj_kind] = true;
	   jj_kind = -1;
	 }
	 for (int i = 0; i < 495; i++) {
	   if (jj_la1[i] == jj_gen) {
		 for (int j = 0; j < 32; j++) {
		   if ((jj_la1_0[i] & (1<<j)) != 0) {
			 la1tokens[j] = true;
		   }
		   if ((jj_la1_1[i] & (1<<j)) != 0) {
			 la1tokens[32+j] = true;
		   }
		   if ((jj_la1_2[i] & (1<<j)) != 0) {
			 la1tokens[64+j] = true;
		   }
		   if ((jj_la1_3[i] & (1<<j)) != 0) {
			 la1tokens[96+j] = true;
		   }
		   if ((jj_la1_4[i] & (1<<j)) != 0) {
			 la1tokens[128+j] = true;
		   }
		   if ((jj_la1_5[i] & (1<<j)) != 0) {
			 la1tokens[160+j] = true;
		   }
		   if ((jj_la1_6[i] & (1<<j)) != 0) {
			 la1tokens[192+j] = true;
		   }
		   if ((jj_la1_7[i] & (1<<j)) != 0) {
			 la1tokens[224+j] = true;
		   }
		   if ((jj_la1_8[i] & (1<<j)) != 0) {
			 la1tokens[256+j] = true;
		   }
		   if ((jj_la1_9[i] & (1<<j)) != 0) {
			 la1tokens[288+j] = true;
		   }
		 }
	   }
	 }
	 for (int i = 0; i < 313; i++) {
	   if (la1tokens[i]) {
		 jj_expentry = new int[1];
		 jj_expentry[0] = i;
		 jj_expentries.add(jj_expentry);
	   }
	 }
	 jj_endpos = 0;
	 jj_rescan_token();
	 jj_add_error_token(0, 0);
	 int[][] exptokseq = new int[jj_expentries.size()][];
	 for (int i = 0; i < jj_expentries.size(); i++) {
	   exptokseq[i] = jj_expentries.get(i);
	 }
	 return new ParseException(token, exptokseq, tokenImage, token_source == null ? null : CCJSqlParserTokenManager.lexStateNames[token_source.curLexState]);
  }

  private boolean trace_enabled;

/** Trace enabled. */
  final public boolean trace_enabled() {
	 return trace_enabled;
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
	 jj_rescan = true;
	 for (int i = 0; i < 154; i++) {
	   try {
		 JJCalls p = jj_2_rtns[i];

		 do {
		   if (p.gen > jj_gen) {
			 jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
			 switch (i) {
			   case 0: jj_3_1(); break;
			   case 1: jj_3_2(); break;
			   case 2: jj_3_3(); break;
			   case 3: jj_3_4(); break;
			   case 4: jj_3_5(); break;
			   case 5: jj_3_6(); break;
			   case 6: jj_3_7(); break;
			   case 7: jj_3_8(); break;
			   case 8: jj_3_9(); break;
			   case 9: jj_3_10(); break;
			   case 10: jj_3_11(); break;
			   case 11: jj_3_12(); break;
			   case 12: jj_3_13(); break;
			   case 13: jj_3_14(); break;
			   case 14: jj_3_15(); break;
			   case 15: jj_3_16(); break;
			   case 16: jj_3_17(); break;
			   case 17: jj_3_18(); break;
			   case 18: jj_3_19(); break;
			   case 19: jj_3_20(); break;
			   case 20: jj_3_21(); break;
			   case 21: jj_3_22(); break;
			   case 22: jj_3_23(); break;
			   case 23: jj_3_24(); break;
			   case 24: jj_3_25(); break;
			   case 25: jj_3_26(); break;
			   case 26: jj_3_27(); break;
			   case 27: jj_3_28(); break;
			   case 28: jj_3_29(); break;
			   case 29: jj_3_30(); break;
			   case 30: jj_3_31(); break;
			   case 31: jj_3_32(); break;
			   case 32: jj_3_33(); break;
			   case 33: jj_3_34(); break;
			   case 34: jj_3_35(); break;
			   case 35: jj_3_36(); break;
			   case 36: jj_3_37(); break;
			   case 37: jj_3_38(); break;
			   case 38: jj_3_39(); break;
			   case 39: jj_3_40(); break;
			   case 40: jj_3_41(); break;
			   case 41: jj_3_42(); break;
			   case 42: jj_3_43(); break;
			   case 43: jj_3_44(); break;
			   case 44: jj_3_45(); break;
			   case 45: jj_3_46(); break;
			   case 46: jj_3_47(); break;
			   case 47: jj_3_48(); break;
			   case 48: jj_3_49(); break;
			   case 49: jj_3_50(); break;
			   case 50: jj_3_51(); break;
			   case 51: jj_3_52(); break;
			   case 52: jj_3_53(); break;
			   case 53: jj_3_54(); break;
			   case 54: jj_3_55(); break;
			   case 55: jj_3_56(); break;
			   case 56: jj_3_57(); break;
			   case 57: jj_3_58(); break;
			   case 58: jj_3_59(); break;
			   case 59: jj_3_60(); break;
			   case 60: jj_3_61(); break;
			   case 61: jj_3_62(); break;
			   case 62: jj_3_63(); break;
			   case 63: jj_3_64(); break;
			   case 64: jj_3_65(); break;
			   case 65: jj_3_66(); break;
			   case 66: jj_3_67(); break;
			   case 67: jj_3_68(); break;
			   case 68: jj_3_69(); break;
			   case 69: jj_3_70(); break;
			   case 70: jj_3_71(); break;
			   case 71: jj_3_72(); break;
			   case 72: jj_3_73(); break;
			   case 73: jj_3_74(); break;
			   case 74: jj_3_75(); break;
			   case 75: jj_3_76(); break;
			   case 76: jj_3_77(); break;
			   case 77: jj_3_78(); break;
			   case 78: jj_3_79(); break;
			   case 79: jj_3_80(); break;
			   case 80: jj_3_81(); break;
			   case 81: jj_3_82(); break;
			   case 82: jj_3_83(); break;
			   case 83: jj_3_84(); break;
			   case 84: jj_3_85(); break;
			   case 85: jj_3_86(); break;
			   case 86: jj_3_87(); break;
			   case 87: jj_3_88(); break;
			   case 88: jj_3_89(); break;
			   case 89: jj_3_90(); break;
			   case 90: jj_3_91(); break;
			   case 91: jj_3_92(); break;
			   case 92: jj_3_93(); break;
			   case 93: jj_3_94(); break;
			   case 94: jj_3_95(); break;
			   case 95: jj_3_96(); break;
			   case 96: jj_3_97(); break;
			   case 97: jj_3_98(); break;
			   case 98: jj_3_99(); break;
			   case 99: jj_3_100(); break;
			   case 100: jj_3_101(); break;
			   case 101: jj_3_102(); break;
			   case 102: jj_3_103(); break;
			   case 103: jj_3_104(); break;
			   case 104: jj_3_105(); break;
			   case 105: jj_3_106(); break;
			   case 106: jj_3_107(); break;
			   case 107: jj_3_108(); break;
			   case 108: jj_3_109(); break;
			   case 109: jj_3_110(); break;
			   case 110: jj_3_111(); break;
			   case 111: jj_3_112(); break;
			   case 112: jj_3_113(); break;
			   case 113: jj_3_114(); break;
			   case 114: jj_3_115(); break;
			   case 115: jj_3_116(); break;
			   case 116: jj_3_117(); break;
			   case 117: jj_3_118(); break;
			   case 118: jj_3_119(); break;
			   case 119: jj_3_120(); break;
			   case 120: jj_3_121(); break;
			   case 121: jj_3_122(); break;
			   case 122: jj_3_123(); break;
			   case 123: jj_3_124(); break;
			   case 124: jj_3_125(); break;
			   case 125: jj_3_126(); break;
			   case 126: jj_3_127(); break;
			   case 127: jj_3_128(); break;
			   case 128: jj_3_129(); break;
			   case 129: jj_3_130(); break;
			   case 130: jj_3_131(); break;
			   case 131: jj_3_132(); break;
			   case 132: jj_3_133(); break;
			   case 133: jj_3_134(); break;
			   case 134: jj_3_135(); break;
			   case 135: jj_3_136(); break;
			   case 136: jj_3_137(); break;
			   case 137: jj_3_138(); break;
			   case 138: jj_3_139(); break;
			   case 139: jj_3_140(); break;
			   case 140: jj_3_141(); break;
			   case 141: jj_3_142(); break;
			   case 142: jj_3_143(); break;
			   case 143: jj_3_144(); break;
			   case 144: jj_3_145(); break;
			   case 145: jj_3_146(); break;
			   case 146: jj_3_147(); break;
			   case 147: jj_3_148(); break;
			   case 148: jj_3_149(); break;
			   case 149: jj_3_150(); break;
			   case 150: jj_3_151(); break;
			   case 151: jj_3_152(); break;
			   case 152: jj_3_153(); break;
			   case 153: jj_3_154(); break;
			 }
		   }
		   p = p.next;
		 } while (p != null);

		 } catch(LookaheadSuccess ls) { }
	 }
	 jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
	 JJCalls p = jj_2_rtns[index];
	 while (p.gen > jj_gen) {
	   if (p.next == null) { p = p.next = new JJCalls(); break; }
	   p = p.next;
	 }

	 p.gen = jj_gen + xla - jj_la; 
	 p.first = token;
	 p.arg = xla;
  }

  static final class JJCalls {
	 int gen;
	 Token first;
	 int arg;
	 JJCalls next;
  }

}
