/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.util.internal;

public final class SettingsUtil {
    protected static final String PROPERTY_PREFIX = "uuidcreator";
    public static final String PROPERTY_NODE = "node";
    public static final String PROPERTY_SECURERANDOM = "securerandom";

    protected SettingsUtil() {
    }

    public static Long getNodeIdentifier() {
        String value = SettingsUtil.getProperty(PROPERTY_NODE);
        if (value == null) {
            return null;
        }
        try {
            return Long.decode(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static void setNodeIdentifier(Long nodeid) {
        String value = Long.toString(nodeid);
        SettingsUtil.setProperty(PROPERTY_NODE, value);
    }

    public static String getSecureRandom() {
        return SettingsUtil.getProperty(PROPERTY_SECURERANDOM);
    }

    public static void setSecureRandom(String random) {
        SettingsUtil.setProperty(PROPERTY_SECURERANDOM, random);
    }

    public static String getProperty(String name) {
        String fullName = SettingsUtil.getPropertyName(name);
        String value = System.getProperty(fullName);
        if (!SettingsUtil.isEmpty(value)) {
            return value;
        }
        fullName = SettingsUtil.getEnvinronmentName(name);
        value = System.getenv(fullName);
        if (!SettingsUtil.isEmpty(value)) {
            return value;
        }
        return null;
    }

    public static void setProperty(String key, String value) {
        System.setProperty(SettingsUtil.getPropertyName(key), value);
    }

    public static void clearProperty(String key) {
        System.clearProperty(SettingsUtil.getPropertyName(key));
    }

    protected static String getPropertyName(String key) {
        return String.join((CharSequence)".", PROPERTY_PREFIX, key);
    }

    protected static String getEnvinronmentName(String key) {
        return String.join((CharSequence)"_", PROPERTY_PREFIX, key).toUpperCase().replace(".", "_");
    }

    private static boolean isEmpty(String value) {
        return value == null || value.isEmpty();
    }
}

