/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.hengboy.mybatis.enhance.provider.base;

import com.gitee.hengboy.mybatis.enhance.common.enums.PlaceholderEnum;
import com.gitee.hengboy.mybatis.enhance.common.helper.StatementHelper;
import com.gitee.hengboy.mybatis.enhance.common.helper.TableHelper;
import com.gitee.hengboy.mybatis.enhance.common.struct.ColumnStruct;
import com.gitee.hengboy.mybatis.enhance.common.struct.TableStruct;
import com.gitee.hengboy.mybatis.enhance.exception.EnhanceFrameworkException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.scripting.xmltags.XMLLanguageDriver;
import org.springframework.util.ObjectUtils;

public class BaseProvider {
    private final String NAMED_PROVIDER_METHOD_NAME = "build";
    private static final XMLLanguageDriver languageDriver = new XMLLanguageDriver();
    private Class<?> mapperClass;
    private Class<?> entityClass;
    private Method method;
    private TableStruct tableStruct;
    private List<ColumnStruct> columnStruct;
    private Map<String, ColumnStruct> columnStructMap;

    public BaseProvider(Class<?> mapperClass, Class<?> entityClass, Method method) {
        this.method = method;
        this.mapperClass = mapperClass;
        this.entityClass = entityClass;
        this.tableStruct = TableHelper.getTableStruct(entityClass);
        this.columnStruct = TableHelper.getColumnStruct(entityClass);
    }

    public String empty() {
        return "this is empty sql";
    }

    public void invokeProviderMethod(MappedStatement ms) {
        String methodName = StatementHelper.getMethodName(ms.getId());
        this.invokeProviderMethod(methodName, ms);
    }

    public void invokeNamedProviderMethod(MappedStatement ms) {
        this.invokeProviderMethod("build", ms);
    }

    private void invokeProviderMethod(String methodName, MappedStatement ms) {
        try {
            Method method = this.getClass().getMethod(methodName, MappedStatement.class);
            method.invoke((Object)this, ms);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new EnhanceFrameworkException("MappedStatement\uff1a[" + ms.getId() + "]\uff0c\u6267\u884c\u91cd\u8f7dSqlSource\u5931\u8d25.");
        }
    }

    public void reloadSqlSource(MappedStatement statement, String sql) {
        SqlSource sqlSource = languageDriver.createSqlSource(statement.getConfiguration(), sql, null);
        this.reloadSqlSource(statement, sqlSource);
    }

    protected void reloadSqlSource(MappedStatement statement, SqlSource sqlSource) {
        MetaObject msObject = SystemMetaObject.forObject((Object)statement);
        msObject.setValue("sqlSource", (Object)sqlSource);
    }

    protected void reloadEntityResultType(MappedStatement statement) {
        ArrayList<ResultMapping> resultMappings = new ArrayList<ResultMapping>();
        for (ColumnStruct column : this.columnStruct) {
            String columnName = column.getColumnName();
            if (columnName.indexOf("`") >= 0) {
                columnName = columnName.replace("`", "");
            }
            ResultMapping.Builder builder = new ResultMapping.Builder(statement.getConfiguration(), column.getFieldName(), columnName, column.getJavaType());
            resultMappings.add(builder.build());
        }
        ResultMap.Builder builder = new ResultMap.Builder(statement.getConfiguration(), statement.getId() + "-Inline", this.entityClass, resultMappings, Boolean.valueOf(true));
        ResultMap resultMap = builder.build();
        MetaObject metaObject = SystemMetaObject.forObject((Object)statement);
        metaObject.setValue("resultMaps", Collections.unmodifiableList(Arrays.asList(resultMap)));
    }

    protected void reloadSingleResultType(MappedStatement statement, Class<?> singleClass) {
        ResultMap.Builder builder = new ResultMap.Builder(statement.getConfiguration(), statement.getId() + "-Inline", singleClass, new ArrayList(), Boolean.valueOf(true));
        ResultMap resultMap = builder.build();
        MetaObject metaObject = SystemMetaObject.forObject((Object)statement);
        metaObject.setValue("resultMaps", Collections.unmodifiableList(Arrays.asList(resultMap)));
    }

    protected void reloadKeyGenerator(MappedStatement statement, KeyGenerator keyGenerator, String keyFieldName, String keyColumnName) {
        if (!ObjectUtils.isEmpty((Object)keyGenerator)) {
            MetaObject metaObject = SystemMetaObject.forObject((Object)statement);
            metaObject.setValue("keyProperties", (Object)new String[]{keyFieldName});
            metaObject.setValue("keyColumns", (Object)new String[]{keyColumnName});
            metaObject.setValue("keyGenerator", (Object)keyGenerator);
        }
    }

    protected String getBeanPkWhere() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.tableStruct.getIdName());
        buffer.append(PlaceholderEnum.EQ.getValue());
        buffer.append("#{bean.");
        buffer.append(this.tableStruct.getIdFieldName());
        buffer.append("}");
        return buffer.toString();
    }

    protected String getSinglePkWhere() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.tableStruct.getIdName());
        buffer.append(PlaceholderEnum.EQ.getValue());
        buffer.append("#{");
        buffer.append("id");
        buffer.append("}");
        return buffer.toString();
    }

    protected Map<String, ColumnStruct> getColumnStructMap() {
        this.columnStructMap = new ConcurrentHashMap<String, ColumnStruct>(this.columnStruct.size());
        for (ColumnStruct struct : this.columnStruct) {
            this.columnStructMap.put(struct.getFieldName(), struct);
        }
        return this.columnStructMap;
    }

    public String getNAMED_PROVIDER_METHOD_NAME() {
        return this.NAMED_PROVIDER_METHOD_NAME;
    }

    public Class<?> getMapperClass() {
        return this.mapperClass;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public Method getMethod() {
        return this.method;
    }

    public TableStruct getTableStruct() {
        return this.tableStruct;
    }

    public List<ColumnStruct> getColumnStruct() {
        return this.columnStruct;
    }

    public void setMapperClass(Class<?> mapperClass) {
        this.mapperClass = mapperClass;
    }

    public void setEntityClass(Class<?> entityClass) {
        this.entityClass = entityClass;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public void setTableStruct(TableStruct tableStruct) {
        this.tableStruct = tableStruct;
    }

    public void setColumnStruct(List<ColumnStruct> columnStruct) {
        this.columnStruct = columnStruct;
    }

    public void setColumnStructMap(Map<String, ColumnStruct> columnStructMap) {
        this.columnStructMap = columnStructMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseProvider)) {
            return false;
        }
        BaseProvider other = (BaseProvider)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$NAMED_PROVIDER_METHOD_NAME = this.getNAMED_PROVIDER_METHOD_NAME();
        String other$NAMED_PROVIDER_METHOD_NAME = other.getNAMED_PROVIDER_METHOD_NAME();
        if (this$NAMED_PROVIDER_METHOD_NAME == null ? other$NAMED_PROVIDER_METHOD_NAME != null : !this$NAMED_PROVIDER_METHOD_NAME.equals(other$NAMED_PROVIDER_METHOD_NAME)) {
            return false;
        }
        Class<?> this$mapperClass = this.getMapperClass();
        Class<?> other$mapperClass = other.getMapperClass();
        if (this$mapperClass == null ? other$mapperClass != null : !this$mapperClass.equals(other$mapperClass)) {
            return false;
        }
        Class<?> this$entityClass = this.getEntityClass();
        Class<?> other$entityClass = other.getEntityClass();
        if (this$entityClass == null ? other$entityClass != null : !this$entityClass.equals(other$entityClass)) {
            return false;
        }
        Method this$method = this.getMethod();
        Method other$method = other.getMethod();
        if (this$method == null ? other$method != null : !((Object)this$method).equals(other$method)) {
            return false;
        }
        TableStruct this$tableStruct = this.getTableStruct();
        TableStruct other$tableStruct = other.getTableStruct();
        if (this$tableStruct == null ? other$tableStruct != null : !((Object)this$tableStruct).equals(other$tableStruct)) {
            return false;
        }
        List<ColumnStruct> this$columnStruct = this.getColumnStruct();
        List<ColumnStruct> other$columnStruct = other.getColumnStruct();
        if (this$columnStruct == null ? other$columnStruct != null : !((Object)this$columnStruct).equals(other$columnStruct)) {
            return false;
        }
        Map<String, ColumnStruct> this$columnStructMap = this.getColumnStructMap();
        Map<String, ColumnStruct> other$columnStructMap = other.getColumnStructMap();
        return !(this$columnStructMap == null ? other$columnStructMap != null : !((Object)this$columnStructMap).equals(other$columnStructMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseProvider;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $NAMED_PROVIDER_METHOD_NAME = this.getNAMED_PROVIDER_METHOD_NAME();
        result = result * 59 + ($NAMED_PROVIDER_METHOD_NAME == null ? 43 : $NAMED_PROVIDER_METHOD_NAME.hashCode());
        Class<?> $mapperClass = this.getMapperClass();
        result = result * 59 + ($mapperClass == null ? 43 : $mapperClass.hashCode());
        Class<?> $entityClass = this.getEntityClass();
        result = result * 59 + ($entityClass == null ? 43 : $entityClass.hashCode());
        Method $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : ((Object)$method).hashCode());
        TableStruct $tableStruct = this.getTableStruct();
        result = result * 59 + ($tableStruct == null ? 43 : ((Object)$tableStruct).hashCode());
        List<ColumnStruct> $columnStruct = this.getColumnStruct();
        result = result * 59 + ($columnStruct == null ? 43 : ((Object)$columnStruct).hashCode());
        Map<String, ColumnStruct> $columnStructMap = this.getColumnStructMap();
        result = result * 59 + ($columnStructMap == null ? 43 : ((Object)$columnStructMap).hashCode());
        return result;
    }

    public String toString() {
        return "BaseProvider(NAMED_PROVIDER_METHOD_NAME=" + this.getNAMED_PROVIDER_METHOD_NAME() + ", mapperClass=" + this.getMapperClass() + ", entityClass=" + this.getEntityClass() + ", method=" + this.getMethod() + ", tableStruct=" + this.getTableStruct() + ", columnStruct=" + this.getColumnStruct() + ", columnStructMap=" + this.getColumnStructMap() + ")";
    }
}

