/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.hengboy.mybatis.enhance.named.helper;

import com.gitee.hengboy.mybatis.enhance.common.struct.ColumnStruct;
import com.gitee.hengboy.mybatis.enhance.exception.EnhanceFrameworkException;
import com.gitee.hengboy.mybatis.enhance.named.OrPart;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public final class NamedMethodHelper {
    private static final String KEYWORD_TEMPLATE = "(%s)(?=(\\p{Lu}|\\P{InBASIC_LATIN}))";
    private static final String QUERY_PATTERN = "find";
    private static final String COUNT_PATTERN = "count";
    private static final String DELETE_PATTERN = "remove";
    public static final Pattern PREFIX_TEMPLATE = Pattern.compile("^(find|count|remove)((\\p{Lu}.*?))??By");
    public static final String PLACEHOLDER_AND = "And";
    public static final String PLACEHOLDER_OR = "Or";

    public static boolean isMatchNamed(String methodName) {
        return NamedMethodHelper.matches(methodName, PREFIX_TEMPLATE);
    }

    public static boolean isMatchFindNamed(String methodName) {
        return NamedMethodHelper.matches(methodName, Pattern.compile(QUERY_PATTERN));
    }

    public static boolean isMatchDeleteNamed(String methodName) {
        return NamedMethodHelper.matches(methodName, Pattern.compile(DELETE_PATTERN));
    }

    public static boolean isMatchCountNamed(String methodName) {
        return NamedMethodHelper.matches(methodName, Pattern.compile(COUNT_PATTERN));
    }

    private static boolean matches(String subject, Pattern pattern) {
        return subject == null ? false : pattern.matcher(subject).find();
    }

    public static String[] split(String text, String keyword) {
        Pattern pattern = Pattern.compile(String.format(KEYWORD_TEMPLATE, keyword));
        return pattern.split(text);
    }

    public static List<OrPart> getNamedWhereSql(String methodName, Map<String, ColumnStruct> mappings) {
        String[] orParts;
        ArrayList<OrPart> orPartList = new ArrayList<OrPart>();
        Matcher matcher = PREFIX_TEMPLATE.matcher(methodName);
        if (!matcher.find()) {
            return null;
        }
        String subjects = methodName.substring(matcher.group().length());
        for (String orPart : orParts = NamedMethodHelper.split(subjects, PLACEHOLDER_OR)) {
            String[] andParts;
            if (StringUtils.isEmpty((Object)orPart)) continue;
            OrPart part = new OrPart();
            for (String andPart : andParts = NamedMethodHelper.split(orPart, PLACEHOLDER_AND)) {
                StringBuffer buffer = new StringBuffer();
                ColumnStruct struct = mappings.get(andPart = andPart.substring(0, 1).toLowerCase() + andPart.substring(1));
                if (ObjectUtils.isEmpty((Object)struct)) {
                    throw new EnhanceFrameworkException("\u672a\u627e\u5230\u3010" + andPart + "\u3011\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5Mapper\u6cdb\u578b\u5b9e\u4f53\u7c7b\u5185\u662f\u5426\u521b\u5efa\u8be5\u5b57\u6bb5!");
                }
                buffer.append(struct.getColumnName());
                buffer.append(" = ");
                buffer.append(" #{" + andPart + "} ");
                String orSql = buffer.toString();
                if (StringUtils.isEmpty((Object)orSql)) continue;
                part.getPredicates().add(orSql);
            }
            orPartList.add(part);
        }
        return orPartList;
    }
}

