/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.hengboy.mybatis.enhance.common.mapping;

import com.gitee.hengboy.mybatis.enhance.common.enums.KeyGeneratorTypeEnum;
import com.gitee.hengboy.mybatis.enhance.common.mapping.ColumnMappingFilterBuilder;
import com.gitee.hengboy.mybatis.enhance.common.struct.ColumnStruct;
import com.gitee.hengboy.mybatis.enhance.exception.EnhanceFrameworkException;
import com.gitee.hengboy.mybatis.enhance.key.generator.SelectAutoKeyGenerator;
import com.gitee.hengboy.mybatis.enhance.key.generator.UUIDKeyGenerator;
import java.util.ArrayList;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.executor.keygen.NoKeyGenerator;
import org.springframework.util.ObjectUtils;

public class ColumnMappingFilter {
    private ColumnMappingFilterBuilder mappingFilterBuilder;
    private ColumnStruct idColumnStruct;

    public ColumnMappingFilter(ColumnMappingFilterBuilder mappingFilterBuilder) {
        this.mappingFilterBuilder = mappingFilterBuilder;
    }

    public ColumnStruct getIdColumnStruct() {
        for (ColumnStruct columnStruct : this.mappingFilterBuilder.getColumnStructList()) {
            if (!columnStruct.isPk()) continue;
            this.idColumnStruct = columnStruct;
            return columnStruct;
        }
        throw new EnhanceFrameworkException("\u5e76\u672a\u67e5\u8be2\u5230\u914d\u7f6e\u4e86@Id\u7684\u5b57\u6bb5.");
    }

    public KeyGenerator getKeyGenerator() {
        Object keyGenerator;
        KeyGeneratorTypeEnum keyGeneratorTypeEnum;
        if (ObjectUtils.isEmpty((Object)this.idColumnStruct)) {
            this.getIdColumnStruct();
        }
        if (ObjectUtils.isEmpty((Object)((Object)(keyGeneratorTypeEnum = this.idColumnStruct.getGeneratorType())))) {
            throw new EnhanceFrameworkException("\u5e76\u672a\u67e5\u8be2\u5230@Id\u5185\u914d\u7f6e\u7684generatorType\u4e3b\u952e\u7b56\u7565.");
        }
        switch (keyGeneratorTypeEnum) {
            case UUID: {
                keyGenerator = new UUIDKeyGenerator();
                break;
            }
            case AUTO: {
                keyGenerator = new SelectAutoKeyGenerator();
                break;
            }
            default: {
                keyGenerator = new NoKeyGenerator();
            }
        }
        return keyGenerator;
    }

    public String[] getColumnNames() {
        ArrayList<String> columnNames = new ArrayList<String>();
        for (ColumnStruct columnStruct : this.mappingFilterBuilder.getColumnStructList()) {
            if (!this.isAddToList(columnStruct)) continue;
            columnNames.add(columnStruct.getColumnName());
        }
        return columnNames.toArray(new String[columnNames.size()]);
    }

    public String[] getColumnValues() {
        ArrayList<String> columnValues = new ArrayList<String>();
        for (ColumnStruct columnStruct : this.mappingFilterBuilder.getColumnStructList()) {
            if (!this.isAddToList(columnStruct)) continue;
            columnValues.add("#{bean." + columnStruct.getFieldName() + "}");
        }
        return columnValues.toArray(new String[columnValues.size()]);
    }

    private boolean isAddToList(ColumnStruct columnStruct) {
        boolean isAddToList = false;
        switch (this.mappingFilterBuilder.getMappingType()) {
            case SELECT: {
                isAddToList = this.selectIsAddToList(columnStruct);
                break;
            }
            case INSERT: {
                isAddToList = this.insertIsAddToList(columnStruct);
                break;
            }
            case DELETE: {
                isAddToList = this.deleteIsAddToList(columnStruct);
                break;
            }
            case UPDATE: {
                isAddToList = this.updateIsAddToList(columnStruct);
            }
        }
        return isAddToList;
    }

    private boolean selectIsAddToList(ColumnStruct columnStruct) {
        return columnStruct.isMapping();
    }

    private boolean insertIsAddToList(ColumnStruct columnStruct) {
        if (!columnStruct.isMapping() || !columnStruct.isInsertable()) {
            return false;
        }
        KeyGeneratorTypeEnum keyGeneratorTypeEnum = columnStruct.getGeneratorType();
        if (!ObjectUtils.isEmpty((Object)((Object)keyGeneratorTypeEnum))) {
            switch (keyGeneratorTypeEnum) {
                case AUTO: {
                    return false;
                }
            }
        }
        return true;
    }

    private boolean updateIsAddToList(ColumnStruct columnStruct) {
        return columnStruct.isMapping() && columnStruct.isUpdateable() && !columnStruct.isPk();
    }

    private boolean deleteIsAddToList(ColumnStruct columnStruct) {
        return columnStruct.isMapping() && columnStruct.isPk();
    }
}

