/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.hengboy.mybatis.enhance.common.helper;

import com.gitee.hengboy.mybatis.enhance.common.helper.SqlSourceHelper;
import com.gitee.hengboy.mybatis.enhance.common.helper.StatckTraceElementHelper;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.cache.Cache;
import org.apache.ibatis.cache.decorators.SoftCache;
import org.apache.ibatis.cache.impl.PerpetualCache;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.session.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StatementHelper {
    static Logger logger = LoggerFactory.getLogger(StatementHelper.class);
    public static final Hashtable<String, MappedStatement> STATEMENT_CACHE = new Hashtable();
    public static final List<String> STATEMENT_SQL_RELOAD_CACHE = new ArrayList<String>();
    private static String SPLIT = ".";
    private static String SELECT_KEY_SUFFIX = ".selectKey";
    private static Cache MAPPER_CLASS_CACHE = new SoftCache((Cache)new PerpetualCache("MAPPER_CLASS_CACHE"));

    public static MappedStatement createSelectKeyStatement(Configuration configuration, String insertStatementId, String sql) {
        SqlSource sqlSource = SqlSourceHelper.createMapSqlSource(configuration, sql);
        MappedStatement statement = new MappedStatement.Builder(configuration, insertStatementId + SELECT_KEY_SUFFIX, sqlSource, SqlCommandType.SELECT).build();
        return statement;
    }

    public static synchronized MappedStatement createOrGetDslStatement(Configuration configuration, String sql, Map parameters, SqlCommandType sqlCommandType) {
        String msId = StatementHelper.getDslStatementId(sql.hashCode());
        MappedStatement statement = STATEMENT_CACHE.get(msId);
        if (statement != null) {
            return statement;
        }
        SqlSource sqlSource = SqlSourceHelper.createMapSqlSource(configuration, sql);
        statement = new MappedStatement.Builder(configuration, msId, sqlSource, sqlCommandType).build();
        STATEMENT_CACHE.put(msId, statement);
        configuration.addMappedStatement(statement);
        return statement;
    }

    private static String getDslStatementId(int sqlHashCode) {
        StackTraceElement stackTraceElement = StatckTraceElementHelper.getDslStackElement();
        StringBuilder builder = new StringBuilder();
        builder.append(stackTraceElement.getClassName());
        builder.append(SPLIT);
        builder.append(sqlHashCode < 0 ? -sqlHashCode : sqlHashCode);
        builder.append(SPLIT);
        builder.append(stackTraceElement.getMethodName());
        return builder.toString();
    }

    public static String getMethodName(String msId) {
        if (msId.indexOf(SPLIT) == -1) {
            throw new RuntimeException("\u5f53\u524dMappedStatement\u7684id=" + msId + ",\u4e0d\u7b26\u5408MappedStatement\u7684\u89c4\u5219!");
        }
        return msId.substring(msId.lastIndexOf(SPLIT) + 1);
    }

    public static Class<?> getMapperClass(String msId) {
        ClassLoader[] classLoader;
        if (msId.indexOf(SPLIT) == -1) {
            throw new RuntimeException("\u5f53\u524dMappedStatement\u7684id=" + msId + ",\u4e0d\u7b26\u5408MappedStatement\u7684\u89c4\u5219!");
        }
        String mapperClassStr = msId.substring(0, msId.lastIndexOf(SPLIT));
        Class<?> mapperClass = (Class<?>)MAPPER_CLASS_CACHE.getObject((Object)mapperClassStr);
        if (mapperClass != null) {
            return mapperClass;
        }
        for (ClassLoader cl : classLoader = StatementHelper.getClassLoaders()) {
            if (null == cl) continue;
            try {
                mapperClass = Class.forName(mapperClassStr, true, cl);
                if (mapperClass == null) continue;
                break;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (mapperClass == null) {
            throw new RuntimeException("class loaders failed to locate the class " + mapperClassStr);
        }
        MAPPER_CLASS_CACHE.putObject((Object)mapperClassStr, (Object)mapperClass);
        return mapperClass;
    }

    private static ClassLoader[] getClassLoaders() {
        return new ClassLoader[]{Thread.currentThread().getContextClassLoader(), StatementHelper.class.getClassLoader()};
    }
}

