/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.hengboy.mybatis.enhance.common.helper;

import com.gitee.hengboy.mybatis.enhance.exception.EnhanceFrameworkException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.List;

public class ReflectionHelper {
    public static Method[] getMethods(Class<?> clazz) {
        return clazz.getDeclaredMethods();
    }

    public static List<Method> getAllMethods(Class<?> clazz) {
        Class<?>[] interfaces = clazz.getInterfaces();
        if (interfaces != null && interfaces.length > 0) {
            for (Class<?> anInterface : interfaces) {
                ReflectionHelper.getAllMethods(anInterface);
            }
        }
        return null;
    }

    public static List<Field> getAllFields(Class<?> clazz) {
        Field[] fields;
        LinkedList<Field> result = new LinkedList<Field>();
        for (Field field : fields = clazz.getDeclaredFields()) {
            result.add(field);
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass.equals(Object.class)) {
            return result;
        }
        result.addAll(ReflectionHelper.getAllFields(superClass));
        return result;
    }

    public static List<Field> getAllFieldsExcludeTransient(Class<?> clazz) {
        LinkedList<Field> result = new LinkedList<Field>();
        List<Field> list = ReflectionHelper.getAllFields(clazz);
        for (Field field : list) {
            if (Modifier.isTransient(field.getModifiers())) continue;
            result.add(field);
        }
        return result;
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        Field field = null;
        try {
            field = clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            try {
                field = clazz.getSuperclass().getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e1) {
                try {
                    field = clazz.getSuperclass().getSuperclass().getDeclaredField(fieldName);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
            }
        }
        if (field == null) {
            throw new EnhanceFrameworkException("Not Found Field\uff1a" + fieldName + " in Class " + clazz.getName() + " and super Class.");
        }
        return field;
    }
}

