/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.hengboy.mybatis.enhance.common.helper;

import com.gitee.hengboy.mybatis.enhance.common.helper.EntityHelper;
import com.gitee.hengboy.mybatis.enhance.common.helper.MapperHelper;
import com.gitee.hengboy.mybatis.enhance.common.helper.StatementHelper;
import com.gitee.hengboy.mybatis.enhance.exception.EnhanceFrameworkException;
import com.gitee.hengboy.mybatis.enhance.named.helper.NamedMethodHelper;
import com.gitee.hengboy.mybatis.enhance.provider.base.BaseProvider;
import com.gitee.hengboy.mybatis.enhance.provider.named.MethodNamedCountProvider;
import com.gitee.hengboy.mybatis.enhance.provider.named.MethodNamedDeleteProvider;
import com.gitee.hengboy.mybatis.enhance.provider.named.MethodNamedFindProvider;
import java.lang.reflect.Method;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.UpdateProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

public class ProviderHelper {
    static Logger logger = LoggerFactory.getLogger(ProviderHelper.class);

    public static BaseProvider getMethodProvider(String statementId) throws EnhanceFrameworkException {
        BaseProvider provider;
        Class<?> providerClass;
        String methodName = StatementHelper.getMethodName(statementId);
        Class<?> mapperClass = StatementHelper.getMapperClass(statementId);
        Class<?> entityClass = EntityHelper.getEntityClass(mapperClass);
        Method method = MapperHelper.getMethod(methodName, mapperClass);
        Class<?> clazz = providerClass = NamedMethodHelper.isMatchNamed(methodName) ? ProviderHelper.findNamedProvider(methodName) : ProviderHelper.findProviderClass(method);
        if (ObjectUtils.isEmpty(providerClass)) {
            throw new EnhanceFrameworkException("\u63a5\u53e3\u65b9\u6cd5\uff1a" + mapperClass.getName() + "." + method.getName() + "\uff0c\u5e76\u672a\u914d\u7f6e@XxxProvider\u6ce8\u89e3\uff0c\u65e0\u6cd5\u8fdb\u884c\u751f\u6210Provider\u5177\u4f53\u7c7b\u578b\u7684\u5b9e\u4f8b.");
        }
        try {
            provider = (BaseProvider)providerClass.getConstructor(Class.class, Class.class, Method.class).newInstance(mapperClass, entityClass, method);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new EnhanceFrameworkException("\u5b9e\u4f8b\u5316\uff1a" + providerClass.getName() + " , \u5931\u8d25.");
        }
        return provider;
    }

    public static Class<?> findProviderClass(Method method) {
        Class providerClass = null;
        if (method.isAnnotationPresent(SelectProvider.class)) {
            SelectProvider selectProvider = method.getAnnotation(SelectProvider.class);
            providerClass = selectProvider.type();
        } else if (method.isAnnotationPresent(UpdateProvider.class)) {
            UpdateProvider updateProvider = method.getAnnotation(UpdateProvider.class);
            providerClass = updateProvider.type();
        } else if (method.isAnnotationPresent(DeleteProvider.class)) {
            DeleteProvider deleteProvider = method.getAnnotation(DeleteProvider.class);
            providerClass = deleteProvider.type();
        } else if (method.isAnnotationPresent(InsertProvider.class)) {
            InsertProvider insertProvider = method.getAnnotation(InsertProvider.class);
            providerClass = insertProvider.type();
        }
        return providerClass;
    }

    public static Class<?> findNamedProvider(String methodName) {
        if (NamedMethodHelper.isMatchFindNamed(methodName)) {
            return MethodNamedFindProvider.class;
        }
        if (NamedMethodHelper.isMatchCountNamed(methodName)) {
            return MethodNamedCountProvider.class;
        }
        if (NamedMethodHelper.isMatchDeleteNamed(methodName)) {
            return MethodNamedDeleteProvider.class;
        }
        return null;
    }
}

