/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.starter.common.validator;

import com.gccloud.starter.common.validator.annotation.UUID;
import java.util.regex.Pattern;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;

public class UuidValidator
implements ConstraintValidator<UUID, String> {
    public static final Pattern UUID_PATTERN = Pattern.compile("[a-zA-Z0-9-]{36}");

    public boolean isValid(String uuid, ConstraintValidatorContext context) {
        if (StringUtils.isBlank((CharSequence)uuid)) {
            return true;
        }
        return UUID_PATTERN.matcher(uuid).matches();
    }

    public static boolean isValid(String uuid) {
        if (StringUtils.isBlank((CharSequence)uuid)) {
            return false;
        }
        return UUID_PATTERN.matcher(uuid).matches();
    }
}

