/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.starter.common.utils.excel;

import com.alibaba.excel.write.handler.SheetWriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteWorkbookHolder;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.POIXMLRelation;
import org.apache.poi.xssf.usermodel.XSSFRelation;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaterMarkSheetWriteHandler
implements SheetWriteHandler {
    private static final Logger log = LoggerFactory.getLogger(WaterMarkSheetWriteHandler.class);
    private String text;

    public WaterMarkSheetWriteHandler(String text) {
        this.text = text;
    }

    public static ByteArrayOutputStream createWaterMark(String content) throws IOException {
        int width = 200;
        int height = 150;
        BufferedImage image = new BufferedImage(width, height, 1);
        int fontStyle = 1;
        int fontSize = 20;
        Font font = new Font(null, fontStyle, fontSize);
        Graphics2D g2d = image.createGraphics();
        image = g2d.getDeviceConfiguration().createCompatibleImage(width, height, 3);
        g2d.dispose();
        g2d = image.createGraphics();
        g2d.setColor(new Color(0, 0, 0, 20));
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.setFont(font);
        g2d.rotate(-0.5, (double)image.getWidth() / 2.0, (double)image.getHeight() / 2.0);
        FontRenderContext context = g2d.getFontRenderContext();
        Rectangle2D bounds = font.getStringBounds(content, context);
        double x = ((double)width - bounds.getWidth()) / 2.0;
        double y = ((double)height - bounds.getHeight()) / 2.0;
        double ascent = -bounds.getY();
        double baseY = y + ascent;
        g2d.drawString(content, (int)x, (int)baseY);
        g2d.setComposite(AlphaComposite.getInstance(3));
        g2d.dispose();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "png", os);
        return os;
    }

    public static void putWaterRemarkToExcel(XSSFSheet sheet, byte[] bytes) {
        XSSFWorkbook workbook = sheet.getWorkbook();
        int pictureIdx = workbook.addPicture(bytes, 6);
        String rID = sheet.addRelation(null, (POIXMLRelation)XSSFRelation.IMAGES, (POIXMLDocumentPart)workbook.getAllPictures().get(pictureIdx)).getRelationship().getId();
        sheet.getCTWorksheet().addNewPicture().setId(rID);
    }

    public void beforeSheetCreate(WriteWorkbookHolder writeWorkbookHolder, WriteSheetHolder writeSheetHolder) {
    }

    public void afterSheetCreate(WriteWorkbookHolder writeWorkbookHolder, WriteSheetHolder writeSheetHolder) {
        log.info("\u8bbe\u7f6eExcel\u6c34\u5370:{}", (Object)this.text);
        log.warn("\u8bbe\u7f6e\u6c34\u5370\u6bd4\u8f83\u8017\u65f6\u95f4\uff0c\u5fc5\u987b\u91c7\u7528 inMemory(true) \u65b9\u5f0f\u8fdb\u884c\uff0c\u5426\u5219\u4f1a\u51fa\u73b0\u7c7b\u8f6c\u6362\u5931\u8d25\u5f02\u5e38");
        try (ByteArrayOutputStream waterMark = WaterMarkSheetWriteHandler.createWaterMark(this.text);){
            XSSFSheet sheet = (XSSFSheet)writeSheetHolder.getSheet();
            WaterMarkSheetWriteHandler.putWaterRemarkToExcel(sheet, waterMark.toByteArray());
        }
    }
}

