/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.starter.common.utils;

import com.gccloud.starter.common.entity.SysMenuEntity;
import com.gccloud.starter.common.exception.GlobalException;
import com.gccloud.starter.common.vo.CurrentUserBase;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserUtils {
    private static final Logger log = LoggerFactory.getLogger(UserUtils.class);
    private static final ThreadLocal<CurrentUserBase> ANON_USER_CONTEXT = new ThreadLocal();
    private static final ThreadLocal<List<SysMenuEntity>> DATA_RULE_CONTEXT = new ThreadLocal();

    public UserUtils() {
        throw new IllegalStateException("\u4e0d\u5141\u8bb8\u521b\u5efa");
    }

    public static void put(CurrentUserBase user) {
        ANON_USER_CONTEXT.set(user);
    }

    public static void remove() {
        ANON_USER_CONTEXT.remove();
    }

    public static void putDataRule(List<SysMenuEntity> dataRuleList) {
        DATA_RULE_CONTEXT.set(dataRuleList);
    }

    public static void removeDataRule() {
        DATA_RULE_CONTEXT.remove();
    }

    public static List<SysMenuEntity> getDataRule() {
        return DATA_RULE_CONTEXT.get();
    }

    public static String getTenantId() {
        return UserUtils.getCurrentUser().getTenantId();
    }

    public static String tryGetTenantId() {
        CurrentUserBase currentUser = UserUtils.getCurrentUser();
        return currentUser.getTenantId();
    }

    public static CurrentUserBase getCurrentUser() {
        return UserUtils.getCurrentUser(true);
    }

    public static CurrentUserBase getCurrentUser(boolean nullThrowException) {
        Subject subject = null;
        try {
            subject = SecurityUtils.getSubject();
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        if (subject == null) {
            CurrentUserBase user = ANON_USER_CONTEXT.get();
            if (user == null && nullThrowException) {
                throw new GlobalException("\u672a\u83b7\u53d6\u5230\u7528\u6237\u4fe1\u606f");
            }
            return user;
        }
        Object principal = subject.getPrincipal();
        if (principal == null && nullThrowException) {
            throw new GlobalException("\u672a\u83b7\u53d6\u5230\u7528\u6237\u4fe1\u606f");
        }
        return (CurrentUserBase)principal;
    }

    public static String getCurrentUserId() {
        CurrentUserBase currentUser = UserUtils.getCurrentUser();
        return currentUser.getId();
    }

    public static String getCurrentUserName() {
        CurrentUserBase currentUser = UserUtils.getCurrentUser();
        return currentUser.getName();
    }
}

