/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.starter.common.utils;

import com.gccloud.starter.common.config.bean.Jwt;
import com.gccloud.starter.common.utils.CookieUtils;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class TokenUtils {
    public TokenUtils() {
        throw new IllegalStateException("\u4e0d\u5141\u8bb8\u521b\u5efa");
    }

    public static String getToken(HttpServletRequest request, Jwt jwt) {
        return TokenUtils.getToken(request, jwt.getTokenKey(), jwt);
    }

    public static String getToken(HttpServletRequest request, String tokenKey, Jwt jwt) {
        String token;
        if (jwt == null) {
            String token2 = CookieUtils.getValue(request, tokenKey);
            if (StringUtils.isBlank((CharSequence)token2)) {
                token2 = request.getHeader(tokenKey);
            }
            if (StringUtils.isBlank((CharSequence)token2)) {
                token2 = request.getParameter(tokenKey);
            }
            return token2;
        }
        Set<String> allowTakeMethod = jwt.getAllowTakeMethod();
        if (allowTakeMethod.contains("cookies") && StringUtils.isNotBlank((CharSequence)(token = CookieUtils.getValue(request, tokenKey)))) {
            return token;
        }
        if (allowTakeMethod.contains("header") && StringUtils.isNotBlank((CharSequence)(token = request.getHeader(tokenKey)))) {
            return token;
        }
        if (allowTakeMethod.contains("parameter") && StringUtils.isNotBlank((CharSequence)(token = request.getParameter(tokenKey)))) {
            return token;
        }
        return null;
    }

    public static String getToken(HttpServletRequest request, String tokenKey) {
        return TokenUtils.getToken(request, tokenKey, null);
    }
}

