/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.starter.common.utils;

import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableUtils {
    private static final Logger log = LoggerFactory.getLogger(TableUtils.class);
    protected static final Map<String, Map<String, TableFieldInfo>> FIELD_NAME_MAP = Maps.newHashMap();

    public TableUtils() {
        throw new IllegalStateException("\u4e0d\u5141\u8bb8\u521b\u5efa");
    }

    public static String getAllColumn(TableInfo tableInfo) {
        ArrayList columnList = Lists.newArrayList();
        List fieldList = tableInfo.getFieldList();
        columnList.add(tableInfo.getKeyColumn());
        for (TableFieldInfo field : fieldList) {
            columnList.add(field.getColumn());
        }
        return Joiner.on((String)",").join((Iterable)columnList);
    }

    public static <T> String getColumnName(Class<T> entity, String fieldName) {
        Map entityFieldMap = FIELD_NAME_MAP.computeIfAbsent(entity.getName(), k -> {
            HashMap innerEntityFieldMap = Maps.newHashMap();
            TableInfo tableInfo = TableInfoHelper.getTableInfo((Class)entity);
            List fieldList = tableInfo.getFieldList();
            fieldList.forEach(field -> innerEntityFieldMap.put(field.getProperty(), field));
            return innerEntityFieldMap;
        });
        TableFieldInfo tableFieldInfo = (TableFieldInfo)entityFieldMap.get(fieldName);
        return tableFieldInfo.getColumn();
    }
}

