/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.starter.common.utils;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPUtils {
    private static final Logger log = LoggerFactory.getLogger(IPUtils.class);
    public static final Set<String> IP_HEADER_SET = Sets.newHashSet((Object[])new String[]{"browser-ip", "X-Real-IP", "browser", "X-Forwarded-For", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"});

    public static String getIp(HttpServletRequest request) {
        JSONObject ipObj = IPUtils.getIpObj(request);
        return ipObj.toJSONString();
    }

    public static String getIp(HttpServletRequest request, String separator) {
        JSONObject ipObj = IPUtils.getIpObj(request);
        String ip = Joiner.on((String)separator).join((Iterable)ipObj.values());
        return ip;
    }

    public static JSONObject getIpObj(HttpServletRequest request) {
        String ip = null;
        JSONObject ipObj = new JSONObject();
        try {
            for (String name : IP_HEADER_SET) {
                ip = request.getHeader(name);
                if (!StringUtils.isNotBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) continue;
                ipObj.put(name, (Object)ip);
            }
            ip = request.getRemoteAddr();
            if (StringUtils.isNotBlank((CharSequence)ip) && !"unknown".equalsIgnoreCase(ip)) {
                ipObj.put("RemoteAddr", (Object)ip);
            }
            if (StringUtils.isNotBlank((CharSequence)(ip = request.getRemoteHost())) && !"unknown".equalsIgnoreCase(ip)) {
                ipObj.put("RemoteHost", (Object)ip);
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6IP\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
        return ipObj;
    }
}

