/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.starter.common.utils;

import com.gccloud.starter.common.exception.GlobalException;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpUtils.class);
    private static SSLContext SSL_CONTEXT = null;
    private static final String DEFAULT_CONTENT_TYPE = "application/json;charset=UTF-8";
    private static final int READ_TIME_OUT = 30;
    private static final int CONNECT_TIME_OUT = 30;
    public static final X509TrustManager X509_TRUST_MANAGER = new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            X509Certificate[] x509Certificates = new X509Certificate[]{};
            return x509Certificates;
        }
    };
    private static final HostnameVerifier HOSTNAME_VERIFIER = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };

    private static void addHeader(Request.Builder builder, Map<String, String> header) {
        if (header != null && header.size() > 0) {
            Set<Map.Entry<String, String>> entrySet = header.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                builder.addHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    private static Request.Builder createBuilder(String url, Map<String, String> header) {
        Request.Builder builder = new Request.Builder().url(url);
        HttpUtils.addHeader(builder, header);
        return builder;
    }

    private static OkHttpClient createClient(String url, int readTimeOut, int connectTimeOut) {
        if (url.startsWith("https")) {
            OkHttpClient client = new OkHttpClient.Builder().readTimeout((long)readTimeOut, TimeUnit.SECONDS).connectTimeout((long)connectTimeOut, TimeUnit.SECONDS).sslSocketFactory(SSL_CONTEXT.getSocketFactory(), X509_TRUST_MANAGER).hostnameVerifier(HOSTNAME_VERIFIER).build();
            return client;
        }
        OkHttpClient client = new OkHttpClient.Builder().readTimeout((long)readTimeOut, TimeUnit.SECONDS).connectTimeout((long)connectTimeOut, TimeUnit.SECONDS).build();
        return client;
    }

    public static Response post(String url, String contentType, Map<String, String> header, String body) {
        MediaType type = MediaType.parse((String)(StringUtils.isBlank((CharSequence)contentType) ? DEFAULT_CONTENT_TYPE : contentType));
        return HttpUtils.post(url, type, header, body);
    }

    public static Response post(String url, String contentType, int readTimeOut, int connectTimeOut, Map<String, String> header, String body) {
        MediaType type = MediaType.parse((String)(StringUtils.isBlank((CharSequence)contentType) ? DEFAULT_CONTENT_TYPE : contentType));
        return HttpUtils.post(url, type, readTimeOut, connectTimeOut, header, body);
    }

    public static Response post(String url, MediaType mediaType, Map<String, String> header, String body) {
        return HttpUtils.post(url, mediaType, 30, 30, header, body);
    }

    public static Response post(String url, MediaType mediaType, int readTimeOut, int connectTimeOut, Map<String, String> header, String body) {
        try {
            OkHttpClient client = HttpUtils.createClient(url, readTimeOut, connectTimeOut);
            Request.Builder builder = HttpUtils.createBuilder(url, header);
            Request request = builder.post(RequestBody.create((MediaType)mediaType, (String)body)).build();
            Response response = client.newCall(request).execute();
            return response;
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new GlobalException("\u53d1\u9001\u8bf7\u6c42\u5931\u8d25: " + url);
        }
    }

    public static void postAsync(String url, String contentType, Map<String, String> header, String body) {
        MediaType type = MediaType.parse((String)(StringUtils.isBlank((CharSequence)contentType) ? DEFAULT_CONTENT_TYPE : contentType));
        HttpUtils.postAsync(url, type, header, body);
    }

    public static void postAsync(String url, String contentType, int readTimeOut, int connectTimeOut, Map<String, String> header, String body) {
        MediaType type = MediaType.parse((String)(StringUtils.isBlank((CharSequence)contentType) ? DEFAULT_CONTENT_TYPE : contentType));
        HttpUtils.postAsync(url, type, readTimeOut, connectTimeOut, header, body);
    }

    public static void postAsync(String url, MediaType mediaType, Map<String, String> header, String body) {
        HttpUtils.postAsync(url, mediaType, 30, 30, header, body);
    }

    public static void postAsync(String url, MediaType mediaType, int readTimeOut, int connectTimeOut, Map<String, String> header, String body) {
        try {
            OkHttpClient client = HttpUtils.createClient(url, readTimeOut, connectTimeOut);
            Request.Builder builder = HttpUtils.createBuilder(url, header);
            Request request = builder.post(RequestBody.create((MediaType)mediaType, (String)body)).build();
            Call call = client.newCall(request);
            call.enqueue(new Callback(){

                public void onFailure(Call call, IOException e) {
                }

                public void onResponse(Call call, Response response) throws IOException {
                }
            });
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new GlobalException("\u53d1\u9001\u8bf7\u6c42\u5931\u8d25: " + url);
        }
    }

    public static Response get(String url, int readTimeOut, int connectTimeOut, Map<String, String> header) {
        try {
            OkHttpClient client = HttpUtils.createClient(url, readTimeOut, connectTimeOut);
            Request.Builder builder = new Request.Builder().url(url);
            HttpUtils.addHeader(builder, header);
            Request request = builder.build();
            return client.newCall(request).execute();
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new GlobalException("\u53d1\u9001\u8bf7\u6c42\u5931\u8d25: " + url);
        }
    }

    public static Response get(String url, Map<String, String> header) {
        return HttpUtils.get(url, 30, 30, header);
    }

    public static void getAsync(String url, int readTimeOut, int connectTimeOut, Map<String, String> header) {
        try {
            OkHttpClient client = HttpUtils.createClient(url, readTimeOut, connectTimeOut);
            Request.Builder builder = new Request.Builder().url(url);
            HttpUtils.addHeader(builder, header);
            Request request = builder.build();
            Call call = client.newCall(request);
            call.enqueue(new Callback(){

                public void onFailure(Call call, IOException e) {
                }

                public void onResponse(Call call, Response response) throws IOException {
                }
            });
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new GlobalException("\u53d1\u9001\u8bf7\u6c42\u5931\u8d25: " + url);
        }
    }

    public static void getAsync(String url, Map<String, String> header) {
        HttpUtils.getAsync(url, 30, 30, header);
    }

    static {
        try {
            SSL_CONTEXT = SSLContext.getInstance("SSL");
            SSL_CONTEXT.init(null, new TrustManager[]{X509_TRUST_MANAGER}, new SecureRandom());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
    }
}

