/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.starter.common.utils;

import com.gccloud.starter.common.exception.GlobalException;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.Script;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroovyUtils {
    private static final Logger log = LoggerFactory.getLogger(GroovyUtils.class);
    static final Cache<String, Class> CACHE_CLASS = Caffeine.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build();

    public static Object run(String groovyScript, Map<String, Object> params) {
        Class clazz = GroovyUtils.buildClass(groovyScript);
        if (clazz == null) {
            return null;
        }
        Binding binding = new Binding();
        Map variables = binding.getVariables();
        if (params != null) {
            variables.putAll(params);
        }
        try {
            Script script = InvokerHelper.createScript((Class)clazz, (Binding)binding);
            Object result = script.run();
            return result;
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new GlobalException("\u811a\u672c\u6267\u884c\u5931\u8d25", e);
        }
    }

    public static Class buildClass(String groovyScript) {
        if (StringUtils.isBlank((CharSequence)groovyScript)) {
            return null;
        }
        Class clazz = (Class)CACHE_CLASS.get((Object)groovyScript, script -> {
            ClassLoader parent = Thread.currentThread().getContextClassLoader();
            GroovyClassLoader loader = null;
            try {
                loader = new GroovyClassLoader(parent);
                Class clazz = loader.parseClass(script);
                return clazz;
            }
            catch (Exception e) {
                log.error("\u811a\u672c {} \u7f16\u8bd1\u5931\u8d25:{}", script, (Object)e);
            }
            finally {
                if (loader != null) {
                    try {
                        loader.close();
                    }
                    catch (Exception e) {
                        log.error(ExceptionUtils.getStackTrace((Throwable)e));
                    }
                }
            }
            return null;
        });
        return clazz;
    }

    public static void main(String[] args) {
        Object result = GroovyUtils.run("println('hello');", null);
        System.out.println(result);
    }
}

