/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.starter.common.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CookieUtils {
    private static final Logger log = LoggerFactory.getLogger(CookieUtils.class);

    public static String getValue(HttpServletRequest request, String cookieName) {
        return CookieUtils.getValue(request, cookieName, false);
    }

    public static String getValue(HttpServletRequest request, String cookieName, boolean isDecoder) {
        if (StringUtils.isBlank((CharSequence)cookieName)) {
            return null;
        }
        Cookie[] cookieList = request.getCookies();
        if (cookieList == null || cookieList.length == 0) {
            return null;
        }
        try {
            for (Cookie cookie : cookieList) {
                if (!cookieName.equals(cookie.getName())) continue;
                if (isDecoder) {
                    return URLDecoder.decode(cookie.getValue(), "UTF-8");
                }
                return cookie.getValue();
            }
        }
        catch (UnsupportedEncodingException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return null;
    }

    public static String getValue(HttpServletRequest request, String cookieName, String encodeString) {
        String value = CookieUtils.getValue(request, cookieName);
        if (StringUtils.isBlank((CharSequence)value)) {
            return value;
        }
        if (StringUtils.isBlank((CharSequence)encodeString)) {
            return value;
        }
        try {
            return URLDecoder.decode(value, encodeString);
        }
        catch (UnsupportedEncodingException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    public static void setCookie(HttpServletRequest request, HttpServletResponse response, String cookieName, String cookieValue) {
        CookieUtils.setCookie(request, response, cookieName, cookieValue, -1);
    }

    public static void setCookie(HttpServletRequest request, HttpServletResponse response, String cookieName, String cookieValue, int cookieMaxage) {
        CookieUtils.setCookie(request, response, cookieName, cookieValue, cookieMaxage, false);
    }

    public static void setCookie(HttpServletRequest request, HttpServletResponse response, String cookieName, String cookieValue, boolean isEncode) {
        CookieUtils.setCookie(request, response, cookieName, cookieValue, -1, isEncode);
    }

    public static void setCookie(HttpServletRequest request, HttpServletResponse response, String cookieName, String cookieValue, int cookieMaxage, boolean isEncode) {
        CookieUtils.doSetCookie(request, response, cookieName, cookieValue, cookieMaxage, isEncode);
    }

    public static void setCookie(HttpServletRequest request, HttpServletResponse response, String cookieName, String cookieValue, int cookieMaxage, String encodeString) {
        CookieUtils.doSetCookie(request, response, cookieName, cookieValue, cookieMaxage, encodeString);
    }

    public static void deleteCookie(HttpServletRequest request, HttpServletResponse response, String cookieName) {
        CookieUtils.doSetCookie(request, response, cookieName, null, -1, false);
    }

    private static final void doSetCookie(HttpServletRequest request, HttpServletResponse response, String cookieName, String cookieValue, int cookieMaxage, boolean isEncode) {
        try {
            String domainName;
            if (cookieValue == null) {
                cookieValue = "";
            } else if (isEncode) {
                cookieValue = URLEncoder.encode(cookieValue, "utf-8");
            }
            Cookie cookie = new Cookie(cookieName, cookieValue);
            if (cookieMaxage > 0) {
                cookie.setMaxAge(cookieMaxage);
            }
            if (null != request && !"localhost".equals(domainName = CookieUtils.getDomainName(request))) {
                cookie.setDomain(domainName);
            }
            cookie.setPath("/");
            response.addCookie(cookie);
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    private static final void doSetCookie(HttpServletRequest request, HttpServletResponse response, String cookieName, String cookieValue, int cookieMaxage, String encodeString) {
        try {
            String domainName;
            cookieValue = cookieValue == null ? "" : URLEncoder.encode(cookieValue, encodeString);
            Cookie cookie = new Cookie(cookieName, cookieValue);
            if (cookieMaxage > 0) {
                cookie.setMaxAge(cookieMaxage);
            }
            if (null != request && !"localhost".equals(domainName = CookieUtils.getDomainName(request))) {
                cookie.setDomain(domainName);
            }
            cookie.setPath("/");
            response.addCookie(cookie);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final String getDomainName(HttpServletRequest request) {
        String domainName = null;
        String serverName = request.getRequestURL().toString();
        if (StringUtils.isBlank((CharSequence)serverName)) {
            domainName = "";
        } else {
            String[] domains;
            int len;
            serverName = serverName.toLowerCase();
            serverName = serverName.substring(7);
            int end = serverName.indexOf("/");
            if ((serverName = serverName.substring(0, end)).indexOf(":") > 0) {
                String[] ary = serverName.split("\\:");
                serverName = ary[0];
            }
            domainName = (len = (domains = serverName.split("\\.")).length) > 3 && !CookieUtils.isIp(serverName) ? "." + domains[len - 3] + "." + domains[len - 2] + "." + domains[len - 1] : (len <= 3 && len > 1 ? "." + domains[len - 2] + "." + domains[len - 1] : serverName);
        }
        return domainName;
    }

    public static String trimSpaces(String IP) {
        while (IP.startsWith(" ")) {
            IP = IP.substring(1, IP.length()).trim();
        }
        while (IP.endsWith(" ")) {
            IP = IP.substring(0, IP.length() - 1).trim();
        }
        return IP;
    }

    public static boolean isIp(String IP) {
        String[] s;
        boolean b = false;
        if ((IP = CookieUtils.trimSpaces(IP)).matches("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}") && Integer.parseInt((s = IP.split("\\."))[0]) < 255 && Integer.parseInt(s[1]) < 255 && Integer.parseInt(s[2]) < 255 && Integer.parseInt(s[3]) < 255) {
            b = true;
        }
        return b;
    }
}

