/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.starter.common.mybatis.utils;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.LambdaUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.gccloud.starter.common.dto.SearchDTO;
import com.gccloud.starter.common.dto.SortField;
import com.gccloud.starter.common.utils.TableUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class QueryWrapperUtils {
    public static Map<String, Map<String, SFunction>> SORT_FUNCTION = Maps.newHashMap();

    public static <T> List<SortField> getSortFieldList(Class<T> entityClass, SearchDTO searchDTO, Map<String, String> aliasMap, SFunction<T, ?> ... sortNameList) {
        return QueryWrapperUtils.getSortFieldList(null, entityClass, searchDTO, aliasMap, sortNameList);
    }

    public static <T> List<SortField> getSortFieldList(String prefix, Class<T> entityClass, SearchDTO searchDTO, Map<String, String> aliasMap, SFunction<T, ?> ... sortNameList) {
        Map<String, String> sortFieldMap = searchDTO.getSortFieldMap();
        if (sortFieldMap == null || sortFieldMap.size() == 0) {
            return null;
        }
        List<String> sortFieldOrderList = searchDTO.getSortFieldOrderList();
        if (sortFieldOrderList == null || sortFieldOrderList.size() == 0) {
            return null;
        }
        String className = entityClass.getName();
        if (StringUtils.isNotBlank((CharSequence)prefix)) {
            className = prefix + className;
        }
        Map cachedSortFunctionMap = SORT_FUNCTION.computeIfAbsent(className, k -> {
            HashMap sortFunctionMap = Maps.newHashMap();
            for (SFunction sortFunction : sortNameList) {
                String implMethodName = LambdaUtils.resolve((SFunction)sortFunction).getImplMethodName();
                String name = null;
                if (implMethodName.startsWith("get")) {
                    name = implMethodName.substring(3);
                } else if (implMethodName.startsWith("is")) {
                    name = implMethodName.substring(2);
                }
                name = org.springframework.util.StringUtils.uncapitalize((String)name);
                sortFunctionMap.put(name, sortFunction);
            }
            return sortFunctionMap;
        });
        ArrayList sortFieldList = Lists.newArrayList();
        for (String fieldName : sortFieldOrderList) {
            String alias;
            if (aliasMap != null && StringUtils.isNotBlank((CharSequence)(alias = aliasMap.get(fieldName)))) {
                sortFieldMap.put(alias, sortFieldMap.get(fieldName));
                fieldName = alias;
            }
            SFunction orderFunction = (SFunction)cachedSortFunctionMap.get(fieldName);
            String order = sortFieldMap.get(fieldName);
            if (orderFunction == null) continue;
            SortField sortField = new SortField();
            String columnName = TableUtils.getColumnName(entityClass, fieldName);
            sortField.setFieldName(columnName);
            if ("descending".equals(order) || "desc".equals(order)) {
                sortField.setOrder("DESC");
            } else {
                if (!"ascending".equals(order) && !"asc".equals(order)) continue;
                sortField.setOrder("ASC");
            }
            sortFieldList.add(sortField);
        }
        return sortFieldList;
    }

    public static <T> LambdaQueryWrapper<T> wrapperSort(String prefix, Class<T> entityClass, LambdaQueryWrapper<T> queryWrapper, SearchDTO searchDTO, Map<String, String> aliasMap, SFunction<T, ?> ... sortNameList) {
        Map<String, String> sortFieldMap = searchDTO.getSortFieldMap();
        if (sortFieldMap == null || sortFieldMap.size() == 0) {
            return queryWrapper;
        }
        List<String> sortFieldOrderList = searchDTO.getSortFieldOrderList();
        if (sortFieldOrderList == null || sortFieldOrderList.size() == 0) {
            return queryWrapper;
        }
        String className = entityClass.getName();
        if (StringUtils.isNotBlank((CharSequence)prefix)) {
            className = prefix + className;
        }
        Map cachedSortFunctionMap = SORT_FUNCTION.computeIfAbsent(className, k -> {
            HashMap sortFunctionMap = Maps.newHashMap();
            for (SFunction sortFunction : sortNameList) {
                String implMethodName = LambdaUtils.resolve((SFunction)sortFunction).getImplMethodName();
                String name = null;
                if (implMethodName.startsWith("get")) {
                    name = implMethodName.substring(3);
                } else if (implMethodName.startsWith("is")) {
                    name = implMethodName.substring(2);
                }
                name = org.springframework.util.StringUtils.uncapitalize((String)name);
                sortFunctionMap.put(name, sortFunction);
            }
            return sortFunctionMap;
        });
        for (String fieldName : sortFieldOrderList) {
            String alias;
            if (aliasMap != null && StringUtils.isNotBlank((CharSequence)(alias = aliasMap.get(fieldName)))) {
                sortFieldMap.put(alias, sortFieldMap.get(fieldName));
                fieldName = alias;
            }
            SFunction orderFunction = (SFunction)cachedSortFunctionMap.get(fieldName);
            String order = sortFieldMap.get(fieldName);
            if (orderFunction == null) continue;
            if ("descending".equals(order) || "desc".equals(order)) {
                queryWrapper.orderByDesc((Object)orderFunction);
                continue;
            }
            if (!"ascending".equals(order) && !"asc".equals(order)) continue;
            queryWrapper.orderByAsc((Object)orderFunction);
        }
        return queryWrapper;
    }

    public static <T> LambdaQueryWrapper<T> wrapperLike(LambdaQueryWrapper<T> queryWrapper, String searchKey, SFunction<T, ?> ... fieldNames) {
        String[] searchKeyArr;
        if (fieldNames == null || fieldNames.length == 0 || StringUtils.isBlank((CharSequence)searchKey)) {
            return queryWrapper;
        }
        for (String key : searchKeyArr = searchKey.split(" ")) {
            if (StringUtils.isBlank((CharSequence)key)) continue;
            String newKey = key.replace("\\", "\\\\").replace("%", "\\%").replace("_", "\\_");
            queryWrapper.and(wrapper -> {
                for (int i = 0; i < fieldNames.length; ++i) {
                    if (StringUtils.isBlank((CharSequence)newKey)) continue;
                    ((LambdaQueryWrapper)wrapper.or()).like((Object)fieldNames[i], (Object)newKey);
                }
            });
        }
        return queryWrapper;
    }

    public static <T> QueryWrapper wrapperLike(QueryWrapper<T> ew, String searchKey, String ... columNames) {
        if (columNames == null || columNames.length == 0) {
            return ew;
        }
        if (StringUtils.isNotBlank((CharSequence)searchKey)) {
            String[] searchKeyArr;
            for (String key : searchKeyArr = searchKey.split(" ")) {
                if (StringUtils.isBlank((CharSequence)key)) continue;
                ew.and(wrapper -> {
                    for (int i = 0; i < columNames.length; ++i) {
                        String column = columNames[i];
                        ((QueryWrapper)wrapper.or()).like(StringUtils.isNotBlank((CharSequence)key), (Object)column, (Object)key);
                    }
                });
            }
        }
        return ew;
    }
}

