/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.starter.common.mybatis.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.LambdaUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.core.toolkit.support.SerializedLambda;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.gccloud.starter.common.constant.GlobalConst;
import com.gccloud.starter.common.dto.SearchDTO;
import com.gccloud.starter.common.exception.GlobalException;
import com.gccloud.starter.common.mybatis.dao.BaseDao;
import com.gccloud.starter.common.mybatis.page.PageVO;
import com.gccloud.starter.common.mybatis.utils.QueryWrapperUtils;
import com.gccloud.starter.common.mybatis.utils.WrapperUtils;
import com.gccloud.starter.common.utils.UserUtils;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.reflection.property.PropertyNamer;
import org.apache.logging.log4j.util.Strings;

public interface ISuperService<T>
extends IService<T> {
    public static final Map<String, String> PROPERTY_COLUMN_MAP = Maps.newHashMap();

    default public BaseDao<T> getBaseDao() {
        return (BaseDao)this.getBaseMapper();
    }

    default public boolean updateByIdWithDp(T entity) {
        return SqlHelper.retBool((Integer)this.getBaseDao().updateByIdWithDp(entity));
    }

    default public boolean updateWithDp(Wrapper<T> updateWrapper) {
        return this.updateWithDp(null, updateWrapper);
    }

    default public boolean updateWithDp(T entity, Wrapper<T> updateWrapper) {
        return SqlHelper.retBool((Integer)this.getBaseDao().updateWithDp(entity, updateWrapper));
    }

    default public int deleteById(Serializable id) {
        return this.getBaseMapper().deleteById(id);
    }

    default public int delete(Wrapper<T> wrapper) {
        return this.getBaseMapper().delete(wrapper);
    }

    default public int deleteByIdWithDp(Serializable id) {
        return this.getBaseDao().deleteByIdWithDp(id);
    }

    default public int deleteWithDp(QueryWrapper<T> wrapper) {
        return this.getBaseDao().delete((Wrapper)wrapper);
    }

    default public int deleteWithDp(LambdaQueryWrapper<T> wrapper) {
        return this.getBaseDao().delete((Wrapper)wrapper);
    }

    default public T getByIdWithDp(Serializable id) {
        T entity = this.getBaseDao().selectByIdWithDp(id);
        return entity;
    }

    default public List<T> listWithDp() {
        QueryWrapper query = Wrappers.query();
        List<T> list = this.listWithDp(query);
        return list;
    }

    default public List<T> listWithDp(QueryWrapper<T> queryWrapper) {
        List<T> list = this.getBaseDao().selectListWithDp((Wrapper<T>)queryWrapper);
        return list;
    }

    default public List<T> listWithDp(LambdaQueryWrapper<T> queryWrapper) {
        List<T> list = this.getBaseDao().selectListWithDp((Wrapper<T>)queryWrapper);
        return list;
    }

    default public <E extends IPage<T>> E pageWithDp(E page, QueryWrapper<T> queryWrapper) {
        return this.getBaseDao().selectPageWithDp(page, (Wrapper<T>)queryWrapper);
    }

    default public <E extends IPage<T>> E pageWithDp(E page, LambdaQueryWrapper<T> queryWrapper) {
        return this.getBaseDao().selectPageWithDp(page, (Wrapper<T>)queryWrapper);
    }

    default public <E extends IPage<T>> E pageWithDp(E page) {
        QueryWrapper query = Wrappers.query();
        return this.pageWithDp(page, query);
    }

    default public PageVO<T> page(SearchDTO searchDTO, LambdaQueryWrapper<T> queryWrapper) {
        Page<T> searchPage = this.packSearchPage(searchDTO);
        Page page = (Page)this.page((IPage)searchPage, (Wrapper)queryWrapper);
        return new PageVO(page);
    }

    default public PageVO<T> pageWithDp(SearchDTO searchDTO, LambdaQueryWrapper<T> queryWrapper) {
        Page<T> searchPage = this.packSearchPage(searchDTO);
        Page<T> page = this.pageWithDp((IPage)searchPage, queryWrapper);
        return new PageVO<T>(page);
    }

    default public PageVO<T> page(SearchDTO searchDTO, SFunction<T, ?> ... fieldNames) {
        LambdaQueryWrapper<T> queryWrapper = this.packQueryWrapper(searchDTO, fieldNames);
        return this.page(searchDTO, queryWrapper);
    }

    default public PageVO<T> pageWithDp(SearchDTO searchDTO, SFunction<T, ?> ... fieldNames) {
        LambdaQueryWrapper<T> queryWrapper = this.packQueryWrapper(searchDTO, fieldNames);
        return this.pageWithDp(searchDTO, queryWrapper);
    }

    default public LambdaQueryWrapper<T> packQueryWrapper(SearchDTO searchDTO, SFunction<T, ?> ... fieldNames) {
        LambdaQueryWrapper<T> queryWrapper = QueryWrapperUtils.wrapperLike(new LambdaQueryWrapper(), searchDTO.getSearchKey(), fieldNames);
        return queryWrapper;
    }

    default public Page<T> packSearchPage(SearchDTO searchDTO) {
        Integer size;
        Page searchPage = new Page();
        if (searchDTO.getCurrent() == null || searchDTO.getCurrent() <= 0) {
            searchPage.setCurrent(1L);
        } else {
            searchPage.setCurrent((long)searchDTO.getCurrent().intValue());
        }
        Integer current = searchDTO.getCurrent();
        if (current == null) {
            current = 1;
        }
        if ((size = searchDTO.getSize()) == null || size <= 0) {
            size = 10;
        }
        if (size > 500) {
            size = 500;
        }
        searchPage.setSize((long)size.intValue());
        searchPage.setCurrent((long)current.intValue());
        return searchPage;
    }

    default public boolean repeatGlobal(SFunction<T, ?> id, Serializable idValue, SFunction<T, ?> field, Object value) {
        return this.repeat(id, idValue, field, value, GlobalConst.RepeatStrategy.GLOBAL);
    }

    default public boolean repeatTenant(SFunction<T, ?> id, Serializable idValue, SFunction<T, ?> field, Object value) {
        return this.repeat(id, idValue, field, value, GlobalConst.RepeatStrategy.TENANT);
    }

    default public boolean repeatTenant(SFunction<T, ?> field, Object value) {
        return this.repeat(null, null, field, value, GlobalConst.RepeatStrategy.TENANT);
    }

    default public boolean repeatGlobal(SFunction<T, ?> field, Object value) {
        return this.repeat(null, null, field, value, GlobalConst.RepeatStrategy.GLOBAL);
    }

    default public boolean repeatOrg(SFunction<T, ?> id, Serializable idValue, SFunction<T, ?> field, Object value) {
        return this.repeat(id, idValue, field, value, GlobalConst.RepeatStrategy.ORG);
    }

    default public boolean repeatCreateBy(SFunction<T, ?> id, Serializable idValue, SFunction<T, ?> field, Object value) {
        return this.repeat(id, idValue, field, value, GlobalConst.RepeatStrategy.CREATE_BY);
    }

    default public boolean repeat(SFunction<T, ?> id, Serializable idValue, SFunction<T, ?> field, Object value, GlobalConst.RepeatStrategy repeatStrategy) {
        SerializedLambda fieldResolve = LambdaUtils.resolve(field);
        String fieldName = PropertyNamer.methodToProperty((String)fieldResolve.getImplMethodName());
        String column = PROPERTY_COLUMN_MAP.computeIfAbsent(fieldName, key -> com.baomidou.mybatisplus.core.toolkit.StringUtils.camelToUnderline((String)fieldName));
        return this.repeat(idValue, column, value, repeatStrategy);
    }

    default public boolean repeat(Serializable idValue, String field, Object value, GlobalConst.RepeatStrategy repeatStrategy) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)field, value);
        if (idValue != null) {
            queryWrapper.ne((Object)"id", (Object)idValue);
        }
        if (GlobalConst.RepeatStrategy.TENANT == repeatStrategy) {
            queryWrapper.eq((Object)"tenant_id", (Object)UserUtils.getCurrentUser().getTenantId());
        } else if (GlobalConst.RepeatStrategy.ORG == repeatStrategy) {
            queryWrapper.eq((Object)"org_id", (Object)UserUtils.getCurrentUser().getOrgId());
        } else if (GlobalConst.RepeatStrategy.CREATE_BY == repeatStrategy) {
            queryWrapper.eq((Object)"create_by", (Object)UserUtils.getCurrentUser().getId());
        }
        int count = this.count((Wrapper)queryWrapper);
        return count > 0;
    }

    default public boolean repeat(Serializable idValue, String field, Object value, String tenantId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)field, value);
        if (idValue != null) {
            queryWrapper.ne((Object)"id", (Object)idValue);
        }
        queryWrapper.eq((Object)"tenant_id", (Object)tenantId);
        int count = this.count((Wrapper)queryWrapper);
        return count > 0;
    }

    default public boolean repeatGlobal(Serializable idValue, String field, Object value) {
        return this.repeat(idValue, field, value, GlobalConst.RepeatStrategy.GLOBAL);
    }

    default public boolean repeatGlobal(String field, Object value) {
        return this.repeat(null, field, value, GlobalConst.RepeatStrategy.GLOBAL);
    }

    default public boolean repeatTenant(Serializable idValue, String field, Object value) {
        return this.repeat(idValue, field, value, GlobalConst.RepeatStrategy.TENANT);
    }

    default public boolean repeatTenant(String field, Object value) {
        return this.repeat(null, field, value, GlobalConst.RepeatStrategy.TENANT);
    }

    default public boolean repeatOrg(Serializable idValue, String field, Object value) {
        return this.repeat(idValue, field, value, GlobalConst.RepeatStrategy.ORG);
    }

    default public boolean repeatCreteBy(Serializable idValue, String field, Object value) {
        return this.repeat(idValue, field, value, GlobalConst.RepeatStrategy.CREATE_BY);
    }

    default public List<String> convert(String idStr) {
        if (Strings.isBlank((String)idStr)) {
            throw new GlobalException("id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        String[] idStrArr = StringUtils.split((String)idStr, (String)"-");
        return Arrays.stream(idStrArr).map(id -> id).collect(Collectors.toList());
    }

    default public T getEntityByField(SFunction<T, ?> field, Object val) {
        LambdaUpdateWrapper query = new LambdaUpdateWrapper();
        query.eq(field, val);
        List list = this.list((Wrapper)query);
        if (list == null || list.size() == 0) {
            return null;
        }
        return (T)list.get(0);
    }

    default public T getEntityByFieldTenant(SFunction<T, ?> field, Object val) {
        LambdaUpdateWrapper query = new LambdaUpdateWrapper();
        query.eq(field, val);
        query.eq(WrapperUtils.TENANT_ID, (Object)UserUtils.tryGetTenantId());
        List list = this.list((Wrapper)query);
        if (list == null || list.size() == 0) {
            return null;
        }
        return (T)list.get(0);
    }

    default public List<T> getEntitiesByField(SFunction<T, ?> field, Object val) {
        LambdaUpdateWrapper query = new LambdaUpdateWrapper();
        query.eq(field, val);
        List list = this.list((Wrapper)query);
        return list;
    }

    default public List<T> getEntitiesByFieldTenant(SFunction<T, ?> field, Object val) {
        LambdaUpdateWrapper query = new LambdaUpdateWrapper();
        query.eq(field, val);
        query.eq(WrapperUtils.TENANT_ID, (Object)UserUtils.tryGetTenantId());
        List list = this.list((Wrapper)query);
        return list;
    }
}

