/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.starter.common.mybatis.parser;

import com.baomidou.mybatisplus.autoconfigure.MybatisPlusProperties;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.parser.SqlInfo;
import com.baomidou.mybatisplus.extension.plugins.pagination.optimize.JsqlParserCountOptimize;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.ibatis.reflection.MetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="mybatis-plus.configuration.variables.udal", name={"countSqlParserEnable"}, havingValue="true", matchIfMissing=false)
public class UdalCountSqlParser
extends JsqlParserCountOptimize {
    private static final Logger log = LoggerFactory.getLogger(UdalCountSqlParser.class);
    @Resource
    private MybatisPlusProperties mybatisPlusProperties;
    private String shardingCommentHint;

    public UdalCountSqlParser() {
        log.info("----------------------------------------");
        log.info("\u542f\u52a8UDAL\u81ea\u5b9a\u4e49\u5206\u9875count\u89e3\u6790\u5668\u586b\u5145\u6ce8\u89e3");
        log.info("----------------------------------------");
    }

    @PostConstruct
    public void init() {
        MybatisConfiguration configuration = this.mybatisPlusProperties.getConfiguration();
        this.shardingCommentHint = configuration.getVariables().getProperty("udal.shardingCommentHint");
    }

    public SqlInfo parser(MetaObject metaObject, String orgSql) {
        SqlInfo sqlInfo = super.parser(metaObject, orgSql);
        String newSql = sqlInfo.getSql();
        if (orgSql.startsWith(this.shardingCommentHint) && !newSql.startsWith(this.shardingCommentHint)) {
            sqlInfo.setSql(this.shardingCommentHint + " \n" + newSql);
        }
        return sqlInfo;
    }
}

