/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.starter.common.module.secure.service.impl;

import com.gccloud.starter.common.module.secure.service.IWeakPwdService;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.shiro.crypto.hash.Sha256Hash;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="gc.starter.component", name={"IWeakPwdService"}, havingValue="WeakPwdServiceImpl", matchIfMissing=true)
public class WeakPwdServiceImpl
implements IWeakPwdService {
    private static final Logger log = LoggerFactory.getLogger(WeakPwdServiceImpl.class);
    protected static final Set<String> LIB = new HashSet<String>(17800);
    public static final String PWD_FILE_NAME = "weakPwdLib.txt";
    public static final String PWD_FILE_PATH = "src/main/resources";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void init() {
        log.info("----------------------------------------");
        log.info("\u5f00\u59cb\u52a0\u8f7d\u5f31\u5bc6\u7801\u6587\u4ef6:{}/{},\u540e\u9762\u4e0d\u5141\u8bb8\u8fdb\u884c\u5f31\u5bc6\u7801\u8bbf\u95ee\u3001\u8bbe\u7f6e", (Object)PWD_FILE_PATH, (Object)PWD_FILE_NAME);
        try (InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(PWD_FILE_NAME);){
            if (inputStream == null) {
                log.error("\u4e22\u5931\u5f31\u5bc6\u7801\u5e93\u6587\u4ef6 {} \u8bf7\u5728 {} \u76ee\u5f55\u4e0b\u6dfb\u52a0\uff0c\u4ee5\u660e\u6587\u5f62\u5f0f\uff0c\u6bcf\u884c\u4e00\u4e2a", (Object)PWD_FILE_NAME, (Object)PWD_FILE_PATH);
                return;
            }
            List lineList = IOUtils.readLines((InputStream)inputStream, (String)StandardCharsets.UTF_8.name());
            for (String pwd : lineList) {
                if (StringUtils.isBlank((CharSequence)pwd)) continue;
                String encryptPassword = new Sha256Hash((Object)(new Sha256Hash((Object)pwd).toHex() + pwd)).toHex();
                LIB.add(encryptPassword);
            }
            log.info("\u5171\u52a0\u8f7d\u5f31\u5bc6\u7801:{} \u6761", (Object)LIB.size());
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            log.info("----------------------------------------");
        }
    }

    @Override
    public boolean exist(String encryptPassword) {
        if (StringUtils.isBlank((CharSequence)encryptPassword)) {
            return false;
        }
        return LIB.contains(encryptPassword);
    }
}

