/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.starter.common.module.monitor.vo;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.NumberUtil;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.util.Date;

public class JvmVo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private double total;
    private double max;
    private double free;
    private String version;
    private String home;

    public double getTotal() {
        return NumberUtil.div((double)this.total, (float)1048576.0f, (int)2);
    }

    public double getMax() {
        return NumberUtil.div((double)this.max, (float)1048576.0f, (int)2);
    }

    public double getFree() {
        return NumberUtil.div((double)this.free, (float)1048576.0f, (int)2);
    }

    public double getUsed() {
        return NumberUtil.div((double)(this.total - this.free), (float)1048576.0f, (int)2);
    }

    public double getUsage() {
        return NumberUtil.mul((double)NumberUtil.div((double)(this.total - this.free), (double)this.total, (int)4), (float)100.0f);
    }

    public String getName() {
        return ManagementFactory.getRuntimeMXBean().getVmName();
    }

    public String getStartTime() {
        long time = ManagementFactory.getRuntimeMXBean().getStartTime();
        Date date = new Date(time);
        return DateUtil.formatDateTime((Date)date);
    }

    public String getRunTime() {
        long time = ManagementFactory.getRuntimeMXBean().getStartTime();
        Date date = new Date(time);
        long runMS = DateUtil.between((Date)date, (Date)new Date(), (DateUnit)DateUnit.MS);
        long nd = 86400000L;
        long nh = 3600000L;
        long nm = 60000L;
        long day = runMS / nd;
        long hour = runMS % nd / nh;
        long min = runMS % nd % nh / nm;
        return day + "\u5929" + hour + "\u5c0f\u65f6" + min + "\u5206\u949f";
    }

    public String getVersion() {
        return this.version;
    }

    public String getHome() {
        return this.home;
    }

    public void setTotal(double total) {
        this.total = total;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public void setFree(double free) {
        this.free = free;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setHome(String home) {
        this.home = home;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JvmVo)) {
            return false;
        }
        JvmVo other = (JvmVo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getTotal(), other.getTotal()) != 0) {
            return false;
        }
        if (Double.compare(this.getMax(), other.getMax()) != 0) {
            return false;
        }
        if (Double.compare(this.getFree(), other.getFree()) != 0) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$home = this.getHome();
        String other$home = other.getHome();
        return !(this$home == null ? other$home != null : !this$home.equals(other$home));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JvmVo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $total = Double.doubleToLongBits(this.getTotal());
        result = result * 59 + (int)($total >>> 32 ^ $total);
        long $max = Double.doubleToLongBits(this.getMax());
        result = result * 59 + (int)($max >>> 32 ^ $max);
        long $free = Double.doubleToLongBits(this.getFree());
        result = result * 59 + (int)($free >>> 32 ^ $free);
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $home = this.getHome();
        result = result * 59 + ($home == null ? 43 : $home.hashCode());
        return result;
    }

    public String toString() {
        return "JvmVo(total=" + this.getTotal() + ", max=" + this.getMax() + ", free=" + this.getFree() + ", version=" + this.getVersion() + ", home=" + this.getHome() + ")";
    }
}

