/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.starter.common.module.monitor.service.impl;

import cn.hutool.core.net.NetUtil;
import cn.hutool.core.util.NumberUtil;
import com.gccloud.starter.common.module.monitor.service.ISysMonitorService;
import com.gccloud.starter.common.module.monitor.vo.CpuVo;
import com.gccloud.starter.common.module.monitor.vo.FileSystemVo;
import com.gccloud.starter.common.module.monitor.vo.JvmVo;
import com.gccloud.starter.common.module.monitor.vo.MemoryVo;
import com.gccloud.starter.common.module.monitor.vo.MonitorVo;
import com.gccloud.starter.common.module.monitor.vo.SystemVo;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.software.os.FileSystem;
import oshi.software.os.OSFileStore;
import oshi.software.os.OperatingSystem;
import oshi.util.Util;

@Service
public class SysMonitorServiceImpl
implements ISysMonitorService {
    private static final Logger log = LoggerFactory.getLogger(SysMonitorServiceImpl.class);
    private static final int OSHI_WAIT_SECOND = 1000;

    @Override
    public MonitorVo getData() {
        MonitorVo monitorVo = new MonitorVo();
        SystemInfo si = new SystemInfo();
        HardwareAbstractionLayer hal = si.getHardware();
        this.setCpuInfo(monitorVo, hal.getProcessor());
        this.setMemInfo(monitorVo, hal.getMemory());
        this.setSysInfo(monitorVo);
        this.setJvmInfo(monitorVo);
        this.setFileSystem(monitorVo, si.getOperatingSystem());
        return monitorVo;
    }

    private void setCpuInfo(MonitorVo monitorVo, CentralProcessor processor) {
        long[] prevTicks = processor.getSystemCpuLoadTicks();
        Util.sleep((long)1000L);
        long[] ticks = processor.getSystemCpuLoadTicks();
        long nice = ticks[CentralProcessor.TickType.NICE.getIndex()] - prevTicks[CentralProcessor.TickType.NICE.getIndex()];
        long irq = ticks[CentralProcessor.TickType.IRQ.getIndex()] - prevTicks[CentralProcessor.TickType.IRQ.getIndex()];
        long softirq = ticks[CentralProcessor.TickType.SOFTIRQ.getIndex()] - prevTicks[CentralProcessor.TickType.SOFTIRQ.getIndex()];
        long steal = ticks[CentralProcessor.TickType.STEAL.getIndex()] - prevTicks[CentralProcessor.TickType.STEAL.getIndex()];
        long cSys = ticks[CentralProcessor.TickType.SYSTEM.getIndex()] - prevTicks[CentralProcessor.TickType.SYSTEM.getIndex()];
        long user = ticks[CentralProcessor.TickType.USER.getIndex()] - prevTicks[CentralProcessor.TickType.USER.getIndex()];
        long iowait = ticks[CentralProcessor.TickType.IOWAIT.getIndex()] - prevTicks[CentralProcessor.TickType.IOWAIT.getIndex()];
        long idle = ticks[CentralProcessor.TickType.IDLE.getIndex()] - prevTicks[CentralProcessor.TickType.IDLE.getIndex()];
        long totalCpu = user + nice + cSys + idle + iowait + irq + softirq + steal;
        CpuVo cpu = monitorVo.getCpu();
        cpu.setCpuNum(processor.getLogicalProcessorCount());
        cpu.setTotal(totalCpu);
        cpu.setSys(cSys);
        cpu.setUsed(user);
        cpu.setWait(iowait);
        cpu.setFree(idle);
    }

    private void setMemInfo(MonitorVo monitorVo, GlobalMemory memory) {
        MemoryVo mem = monitorVo.getMemory();
        mem.setTotal(memory.getTotal());
        mem.setUsed(memory.getTotal() - memory.getAvailable());
        mem.setFree(memory.getAvailable());
    }

    private void setSysInfo(MonitorVo monitorVo) {
        SystemVo sys = monitorVo.getSystem();
        Properties props = System.getProperties();
        try {
            InetAddress addr = InetAddress.getLocalHost();
            String hostName = addr.getHostName();
            sys.setComputerName(hostName);
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            sys.setComputerName("\u672a\u77e5");
        }
        sys.setComputerIp(NetUtil.getLocalhostStr());
        sys.setOsName(props.getProperty("os.name"));
        sys.setOsArch(props.getProperty("os.arch"));
        sys.setUserDir(props.getProperty("user.dir"));
    }

    private void setJvmInfo(MonitorVo monitorVo) {
        JvmVo jvm = monitorVo.getJvm();
        Properties props = System.getProperties();
        jvm.setTotal(Runtime.getRuntime().totalMemory());
        jvm.setMax(Runtime.getRuntime().maxMemory());
        jvm.setFree(Runtime.getRuntime().freeMemory());
        jvm.setVersion(props.getProperty("java.version"));
        jvm.setHome(props.getProperty("java.home"));
    }

    private void setFileSystem(MonitorVo monitorVo, OperatingSystem os) {
        List<FileSystemVo> sysFiles = monitorVo.getFileSystemList();
        FileSystem fileSystem = os.getFileSystem();
        List fsList = fileSystem.getFileStores();
        for (OSFileStore fs : fsList) {
            long free = fs.getUsableSpace();
            long total = fs.getTotalSpace();
            long used = total - free;
            FileSystemVo sysFile = new FileSystemVo();
            sysFile.setDirName(fs.getMount());
            sysFile.setSysTypeName(fs.getType());
            sysFile.setTypeName(fs.getName());
            sysFile.setTotal(this.convertFileSize(total));
            sysFile.setFree(this.convertFileSize(free));
            sysFile.setUsed(this.convertFileSize(used));
            sysFile.setUsage(NumberUtil.round((double)((double)used * 1.0 / (double)total * 100.0), (int)2).doubleValue());
            sysFiles.add(sysFile);
        }
    }

    public String convertFileSize(long size) {
        long kb = 1024L;
        long mb = kb * 1024L;
        long gb = mb * 1024L;
        if (size >= gb) {
            return String.format("%.1f GB", Float.valueOf((float)size / (float)gb));
        }
        if (size >= mb) {
            float f = (float)size / (float)mb;
            return String.format(f > 100.0f ? "%.0f MB" : "%.1f MB", Float.valueOf(f));
        }
        if (size >= kb) {
            float f = (float)size / (float)kb;
            return String.format(f > 100.0f ? "%.0f KB" : "%.1f KB", Float.valueOf(f));
        }
        return String.format("%d B", size);
    }

    public static void main(String[] args) throws Exception {
        long total = 250790436864L;
        long used = 222992535552L;
        System.out.println((double)used * 1.0 / (double)total);
        System.out.println(NumberUtil.round((double)((double)used * 1.0 / (double)total * 100.0), (int)2));
        System.out.println(NumberUtil.mul((Number[])new Number[]{used, total, 2}));
        System.out.println(NumberUtil.round((BigDecimal)NumberUtil.mul((Number[])new Number[]{used, total, 2}), (int)2).doubleValue());
    }
}

