/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.starter.common.module.file.vo;

import com.gccloud.starter.common.entity.SysFileEntity;
import java.io.Serializable;
import java.text.DecimalFormat;

public class SysFileVO
extends SysFileEntity
implements Serializable {
    private String space;

    public String getSpace() {
        long size = this.getSize();
        if (size <= 0L) {
            return "0";
        }
        String[] units = new String[]{"B", "KB", "MB", "GB", "TB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1000.0));
        return new DecimalFormat("#,##0.##").format((double)size / Math.pow(1000.0, digitGroups)) + " " + units[digitGroups];
    }

    public void setSpace(String space) {
        this.space = space;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SysFileVO)) {
            return false;
        }
        SysFileVO other = (SysFileVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$space = this.getSpace();
        String other$space = other.getSpace();
        return !(this$space == null ? other$space != null : !this$space.equals(other$space));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SysFileVO;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $space = this.getSpace();
        result = result * 59 + ($space == null ? 43 : $space.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "SysFileVO(space=" + this.getSpace() + ")";
    }
}

