/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.starter.common.init;

import java.io.InputStream;
import java.net.InetAddress;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Component;

@Order(value=1)
@Component
@ConditionalOnProperty(prefix="gc.starter.component", name={"SuccessCommandLineRunner"}, havingValue="SuccessCommandLineRunner", matchIfMissing=true)
public class SuccessCommandLineRunner
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(SuccessCommandLineRunner.class);
    @Resource
    ResourceLoader resourceLoader;
    @Resource
    private Environment env;

    public void run(String ... args) throws Exception {
        try {
            org.springframework.core.io.Resource resource = this.resourceLoader.getResource("classpath:success.txt");
            List successLineList = IOUtils.readLines((InputStream)resource.getInputStream());
            for (String line : successLineList) {
                System.out.println(line);
            }
        }
        catch (Exception e) {
            System.out.println("\u542f\u52a8\u6210\u529f\uff0c\u5982\u679c\u60a8\u60f3\u81ea\u5b9a\u4e49\u542f\u52a8\u6210\u529f\u6807\u8bc6\uff0c\u60a8\u53ef\u4ee5\u5728\u5de5\u7a0bsrc/resources\u4e0b\u521b\u5efasuccess.txt\u6587\u4ef6\uff0c\u5e76\u5199\u5165\u542f\u52a8\u6210\u529f\u8f93\u51fa\u7684\u4fe1\u606f");
        }
        String ip = InetAddress.getLocalHost().getHostAddress();
        String port = this.env.getProperty("server.port", "8080");
        String path = this.env.getProperty("server.servlet.context-path", "/");
        System.out.println("\n");
        System.out.println(String.format("\u672c\u5730\u670d\u52a1\u5730\u5740: http://localhost:%s%s", port, path));
        System.out.println(String.format("\u672c\u5730\u670d\u52a1\u5730\u5740: http://127.0.0.1:%s%s", port, path));
        System.out.println(String.format("\u751f\u4ea7\u670d\u52a1\u5730\u5740: http://%s:%s%s", ip, port, path));
        System.out.println(String.format("Swagger\u63a5\u53e3\u6587\u6863\u5730\u5740: http://%s:%s%s/doc.html", ip, port, path));
        try {
            org.springframework.core.io.Resource resource = this.resourceLoader.getResource("classpath:StarterVersion");
            List lines = IOUtils.readLines((InputStream)resource.getInputStream());
            if (lines != null && lines.size() > 0) {
                System.out.println(String.format("\u5343\u884c\u5f00\u53d1\u6846\u67b6\u7248\u672c: %s", lines.get(0)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("----------------------------------------");
    }
}

