/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.starter.common.filter;

import com.alibaba.fastjson.JSONObject;
import com.gccloud.starter.common.config.GlobalConfig;
import com.gccloud.starter.common.config.ResponseEncrypt;
import com.gccloud.starter.common.utils.AesEncryptUtil;
import com.gccloud.starter.common.vo.R;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.stereotype.Component;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@Component
@RestControllerAdvice
public class ResponseEncryptAdvice
implements ResponseBodyAdvice {
    private static final Logger log = LoggerFactory.getLogger(ResponseEncryptAdvice.class);
    @Resource
    private GlobalConfig globalConfig;

    public Object beforeBodyWrite(Object o, MethodParameter methodParameter, MediaType mediaType, Class aClass, ServerHttpRequest serverHttpRequest, ServerHttpResponse serverHttpResponse) {
        if (ObjectUtils.isEmpty((Object)o)) {
            return o;
        }
        String feignRequestSign = ((ServletServerHttpRequest)serverHttpRequest).getServletRequest().getHeader("feignRequestSign");
        if ("feignRequestSign".equals(feignRequestSign)) {
            return o;
        }
        try {
            String returnName = methodParameter.getMethod().getReturnType().getName();
            ResponseEncrypt responseEncrypt = this.globalConfig.getResponseEncrypt();
            Object returnObject = Class.forName(returnName).newInstance();
            if (!(returnObject instanceof R)) {
                return o;
            }
            String path = ((ServletServerHttpRequest)serverHttpRequest).getServletRequest().getServletPath();
            ResponseEncrypt encryptConfig = this.globalConfig.getResponseEncrypt();
            if (encryptConfig == null || StringUtils.isBlank((CharSequence)encryptConfig.getPath())) {
                return o;
            }
            String[] pathArr = encryptConfig.getPath().split(",");
            List<String> strings = Arrays.asList(pathArr);
            Boolean aBoolean = this.pathMatcher(strings, path);
            if (aBoolean.booleanValue()) {
                R res = (R)o;
                Object data = res.getData();
                if (!ObjectUtils.isEmpty(data)) {
                    String encrypt = AesEncryptUtil.encrypt(JSONObject.toJSONString(data), responseEncrypt.getKey(), responseEncrypt.getIv());
                    res.setData(encrypt);
                }
                res.setEncry(true);
                return res;
            }
        }
        catch (InstantiationException e) {
            return o;
        }
        catch (Exception e) {
            log.info("\u54cd\u5e94\u8bf7\u6c42\u52a0\u5bc6\u5931\u8d25:{}", (Throwable)e);
            e.printStackTrace();
            return o;
        }
        return o;
    }

    public boolean supports(MethodParameter methodParameter, Class aClass) {
        return true;
    }

    private Boolean pathMatcher(List<String> configPath, String requestPath) {
        AntPathMatcher pathMatcher = new AntPathMatcher();
        Boolean matchFlag = false;
        for (String s : configPath) {
            if (!pathMatcher.match(s, requestPath)) continue;
            matchFlag = true;
        }
        return matchFlag;
    }
}

