/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.starter.common.filter;

import com.gccloud.starter.common.config.GlobalConfig;
import com.gccloud.starter.common.config.bean.DemoEnv;
import com.gccloud.starter.common.vo.R;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import java.io.IOException;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestMethod;

@Order(value=2)
@Component
@ConditionalOnProperty(prefix="gc.starter.demoEnv", name={"enable"}, havingValue="true")
public class DemoEnvFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(DemoEnvFilter.class);
    @Resource
    private GlobalConfig globalConfig;
    private static final Set<String> POST_URL_PASS_SET = Sets.newHashSet((Object[])new String[]{"/sys/login", "/sys/user/repeat", "/sys/dict/repeat", "/sys/dict-item/repeat", "/sys/category/repeat/name", "/sys/category/repeat/code", "/sys/config/repeat", "/sys/org/list/byId"});
    private static final Set<String> DELETE_URL_PASS_SET = Sets.newHashSet((Object[])new String[]{"/sys/logout"});

    @PostConstruct
    public void init() {
        log.info("----------------------------------------");
        log.info("\u542f\u52a8\u6f14\u793a\u73af\u5883\u8fc7\u6ee4\u5668\uff0c\u7528\u4e8e\u4fdd\u8bc1\u6f14\u793a\u73af\u5883\u7684\u7a33\u5b9a\u6027\uff0c\u4ec5\u5141\u8bb8\u6307\u5b9a\u7684\u4e00\u4e9b\u63a5\u53e3\u8bf7\u6c42\u8bbf\u95ee\uff0c\u53ef\u901a\u8fc7gc.starter.demoEnv.enable \u8bbe\u7f6e\u662f\u5426\u7981\u7528");
        log.info("----------------------------------------");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        String method = request.getMethod();
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)RequestMethod.GET.toString(), (CharSequence[])new CharSequence[]{method}) || StringUtils.equalsAnyIgnoreCase((CharSequence)RequestMethod.OPTIONS.toString(), (CharSequence[])new CharSequence[]{method})) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        String uri = request.getServletPath();
        DemoEnv demoEnv = this.globalConfig.getDemoEnv();
        for (String startWithUrl : demoEnv.getStartWithUrlPassSet()) {
            if (!uri.startsWith(startWithUrl)) continue;
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)RequestMethod.POST.toString(), (CharSequence[])new CharSequence[]{method}) && (demoEnv.getPostUrlPassSet().contains(uri) || POST_URL_PASS_SET.contains(uri))) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)RequestMethod.PUT.toString(), (CharSequence[])new CharSequence[]{method}) && demoEnv.getPutUrlPassSet().contains(uri)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)RequestMethod.DELETE.toString(), (CharSequence[])new CharSequence[]{method}) && (demoEnv.getDeleteUrlPassSet().contains(uri) || DELETE_URL_PASS_SET.contains(uri))) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        log.error("\u6f14\u793a\u73af\u5883\uff0c\u4e0d\u5141\u8bb8\u53d1\u9001 {} \u7684 {} \u8bf7\u6c42", (Object)uri, (Object)request.getMethod());
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        response.setHeader("Access-Control-Allow-Credentials", "true");
        response.setContentType("application/json;charset=UTF-8");
        response.setHeader("Access-Control-Allow-Origin", request.getHeader("Origin"));
        String json = new Gson().toJson((Object)R.error(500, demoEnv.getTip()));
        response.getWriter().print(json);
    }
}

