/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.starter.common.filter;

import com.gccloud.starter.common.config.GlobalConfig;
import com.gccloud.starter.common.config.bean.Csrf;
import com.gccloud.starter.common.vo.R;
import com.google.gson.Gson;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=1)
@Component
@ConditionalOnProperty(prefix="gc.starter.component", name={"CsrfSecureFilter"}, havingValue="CsrfSecureFilter", matchIfMissing=true)
public class CsrfSecureFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(CsrfSecureFilter.class);
    @Resource
    private GlobalConfig globalConfig;

    @PostConstruct
    public void init() {
        log.info("----------------------------------------");
        log.info("\u542f\u52a8Csrf\u9a8c\u8bc1Referer\u62e6\u622a\u5668");
        log.info("----------------------------------------");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        Csrf csrf = this.globalConfig.getCsrf();
        Map<Thread, StackTraceElement[]> allStackTraces = Thread.getAllStackTraces();
        String referer = request.getHeader("Referer");
        if (!csrf.getAllowedEmpty().booleanValue() && StringUtils.isBlank((CharSequence)referer)) {
            log.error("\u7981\u6b62 Referer \u4e3a\u7a7a\u7684\u8bbf\u95ee");
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            response.setHeader("Access-Control-Allow-Credentials", "true");
            response.setContentType("application/json;charset=UTF-8");
            response.setHeader("Access-Control-Allow-Origin", request.getHeader("Origin"));
            response.setStatus(500);
            String json = new Gson().toJson((Object)R.error(500, "\u975e\u6cd5\u8bbf\u95ee"));
            response.getWriter().print(json);
            return;
        }
        if (StringUtils.isBlank((CharSequence)referer)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        List<String> allowedReferers = csrf.getAllowedReferers();
        if (allowedReferers.size() == 0) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        boolean allowed = false;
        for (String allowedReferer : allowedReferers) {
            if (!referer.startsWith(allowedReferer)) continue;
            allowed = true;
            break;
        }
        if (allowed) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        log.error("\u7981\u6b62 Referer = {} \u7684\u8bbf\u95ee", (Object)referer);
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        response.setHeader("Access-Control-Allow-Credentials", "true");
        response.setContentType("application/json;charset=UTF-8");
        response.setHeader("Access-Control-Allow-Origin", request.getHeader("Origin"));
        response.setStatus(500);
        String json = new Gson().toJson((Object)R.error(500, "\u975e\u6cd5\u8bbf\u95ee"));
        response.getWriter().print(json);
    }
}

