/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.starter.common.filter;

import com.gccloud.starter.common.exception.GlobalException;
import com.gccloud.starter.common.vo.R;
import com.google.gson.Gson;
import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=1)
@Component
@ConditionalOnProperty(prefix="gc.starter.component", name={"BugSecureFilter"}, havingValue="BugSecureFilter", matchIfMissing=true)
public class BugSecureFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(BugSecureFilter.class);

    @PostConstruct
    public void init() {
        log.info("----------------------------------------");
        log.info("\u542f\u52a8\u6f0f\u6d1e\u4fee\u590d\u62e6\u622a\u5668");
        log.info("----------------------------------------");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        String servletPath = request.getServletPath();
        if (StringUtils.isBlank((CharSequence)servletPath)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        try {
            if (servletPath.contains("/owa_util.")) {
                throw new GlobalException("\u7981\u7528Oracle Application Server PL/SQL \u672a\u6388\u6743\u8bbf\u95ee");
            }
            if (servletPath.contains("/sqlnet.")) {
                throw new GlobalException("\u7981\u7528Oracle \u65e5\u5fd7\u6587\u4ef6\u4fe1\u606f\u6cc4\u9732");
            }
            if (servletPath.endsWith(".lzma")) {
                throw new GlobalException("\u7981\u7528\u4e34\u65f6\u6587\u4ef6\u4e0b\u8f7d");
            }
        }
        catch (Exception e) {
            log.error("\u7591\u4f3c\u6f0f\u6d1e\u62e6\u622a: ", (Throwable)e);
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            response.setHeader("Access-Control-Allow-Credentials", "true");
            response.setContentType("application/json;charset=UTF-8");
            response.setHeader("Access-Control-Allow-Origin", request.getHeader("Origin"));
            response.setStatus(500);
            String json = new Gson().toJson((Object)R.error(500, "\u975e\u6cd5\u8bbf\u95ee"));
            response.getWriter().print(json);
            return;
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }
}

