/*
 * Decompiled with CFR 0.152.
 */
package sqlj.javac;

import sqlj.framework.JSClass;
import sqlj.javac.JavaParserImpl;
import sqlj.javac.NameNode;
import sqlj.javac.SimpleNameNode;
import sqlj.javac.Token;

public class DottedNameNode
extends NameNode {
    NameNode prefix;
    String dotText;
    SimpleNameNode member;
    private JSClass type;

    DottedNameNode(JavaParserImpl javaParserImpl, NameNode nameNode, Token token, SimpleNameNode simpleNameNode) {
        super(javaParserImpl);
        this.prefix = nameNode;
        this.dotText = token.getText();
        this.member = simpleNameNode;
    }

    @Override
    int getRow() {
        return this.prefix.getRow();
    }

    @Override
    int getColumn() {
        return this.prefix.getColumn();
    }

    @Override
    public String getText() {
        return this.prefix.getText() + "." + this.member.getText();
    }

    @Override
    JSClass getType() {
        if (this.type == null) {
            this.type = this.prefix.getType() == null ? this.lookupField() : this.prefix.lookupField(this.member.getText());
            if (this.type == null) {
                this.type = this.resolveType();
            }
        }
        return this.type;
    }

    @Override
    void scopeChanged() {
        this.prefix.setScope(this.getScope());
        this.member.setScope(this.getScope());
    }

    @Override
    public final void getTextTo(StringBuffer stringBuffer) {
        this.prefix.getTextTo(stringBuffer);
        stringBuffer.append(this.dotText);
        this.member.getTextTo(stringBuffer);
    }

    @Override
    JSClass getBaseType() {
        return this.prefix.getType();
    }

    @Override
    String getSimpleName() {
        return this.member.getSimpleName();
    }

    @Override
    boolean isFinal() {
        boolean bl;
        try {
            bl = (this.prefix.getField(this.member.getText()).getModifiers() & 0x10) != 0;
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl = false;
        }
        catch (NullPointerException nullPointerException) {
            bl = false;
        }
        return bl;
    }

    @Override
    public Object getValue() {
        Object object;
        try {
            object = this.prefix.getField(this.member.getText()).get();
        }
        catch (ClassNotFoundException classNotFoundException) {
            object = null;
        }
        catch (IllegalAccessException illegalAccessException) {
            object = null;
        }
        catch (NullPointerException nullPointerException) {
            object = null;
        }
        return object;
    }
}

