/*
 * Decompiled with CFR 0.152.
 */
package com.fhs.core.trans.vo;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fhs.core.trans.util.ReflectUtils;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public interface VO {
    @TableField(exist=false)
    @JsonIgnore
    public static final Map<Class<?>, Field> ID_FIELD_CACHE_MAP = new HashMap();
    public static final Set<Class> ID_ANNO = new HashSet<Class>();
    public static final ThreadLocal<Map<String, Map<String, String>>> TRANS_MAP_CACHE = new ThreadLocal();

    default public void clearTransCache() {
        Caffeine builder = Caffeine.newBuilder();
        builder.expireAfterWrite(60L, TimeUnit.SECONDS);
        TRANS_MAP_CACHE.set(builder.build().asMap());
    }

    default public Map<String, String> getTransMap() {
        String cacheKey;
        Map<String, Map<String, String>> cache;
        if (TRANS_MAP_CACHE.get() == null) {
            this.clearTransCache();
        }
        if ((cache = TRANS_MAP_CACHE.get()).containsKey(cacheKey = this.getClass().getName() + "_" + this.getPkey())) {
            return cache.get(cacheKey);
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        cache.put(cacheKey, result);
        return result;
    }

    @JsonIgnore
    @JSONField(serialize=false)
    default public Object getPkey() {
        Field idField = ReflectUtils.getIdField(this.getClass(), true);
        try {
            return idField.get(this);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }
}

