/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.classloader;

import com.facebook.presto.spi.ConnectorColumnHandle;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.ConnectorIndexHandle;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.classloader.ThreadContextClassLoader;
import java.util.Objects;

public class ClassLoaderSafeConnectorHandleResolver
implements ConnectorHandleResolver {
    private final ConnectorHandleResolver delegate;
    private final ClassLoader classLoader;

    public ClassLoaderSafeConnectorHandleResolver(ConnectorHandleResolver delegate, ClassLoader classLoader) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    @Override
    public boolean canHandle(ConnectorTableHandle tableHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            boolean bl = this.delegate.canHandle(tableHandle);
            return bl;
        }
    }

    @Override
    public boolean canHandle(ConnectorColumnHandle columnHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            boolean bl = this.delegate.canHandle(columnHandle);
            return bl;
        }
    }

    @Override
    public boolean canHandle(ConnectorSplit split) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            boolean bl = this.delegate.canHandle(split);
            return bl;
        }
    }

    @Override
    public boolean canHandle(ConnectorIndexHandle indexHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            boolean bl = this.delegate.canHandle(indexHandle);
            return bl;
        }
    }

    @Override
    public boolean canHandle(ConnectorOutputTableHandle tableHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            boolean bl = this.delegate.canHandle(tableHandle);
            return bl;
        }
    }

    @Override
    public boolean canHandle(ConnectorInsertTableHandle tableHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            boolean bl = this.delegate.canHandle(tableHandle);
            return bl;
        }
    }

    @Override
    public Class<? extends ConnectorTableHandle> getTableHandleClass() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Class<? extends ConnectorTableHandle> clazz = this.delegate.getTableHandleClass();
            return clazz;
        }
    }

    @Override
    public Class<? extends ConnectorColumnHandle> getColumnHandleClass() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Class<? extends ConnectorColumnHandle> clazz = this.delegate.getColumnHandleClass();
            return clazz;
        }
    }

    @Override
    public Class<? extends ConnectorSplit> getSplitClass() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Class<? extends ConnectorSplit> clazz = this.delegate.getSplitClass();
            return clazz;
        }
    }

    public String toString() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            String string = this.delegate.toString();
            return string;
        }
    }

    @Override
    public Class<? extends ConnectorIndexHandle> getIndexHandleClass() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Class<? extends ConnectorIndexHandle> clazz = this.delegate.getIndexHandleClass();
            return clazz;
        }
    }

    @Override
    public Class<? extends ConnectorOutputTableHandle> getOutputTableHandleClass() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Class<? extends ConnectorOutputTableHandle> clazz = this.delegate.getOutputTableHandleClass();
            return clazz;
        }
    }

    @Override
    public Class<? extends ConnectorInsertTableHandle> getInsertTableHandleClass() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Class<? extends ConnectorInsertTableHandle> clazz = this.delegate.getInsertTableHandleClass();
            return clazz;
        }
    }
}

