/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi;

import com.facebook.presto.spi.Marker;
import com.facebook.presto.spi.Range;
import com.facebook.presto.spi.SortedRangeSet;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class Domain {
    private final SortedRangeSet ranges;
    private final boolean nullAllowed;

    @JsonCreator
    public Domain(@JsonProperty(value="ranges") SortedRangeSet ranges, @JsonProperty(value="nullAllowed") boolean nullAllowed) {
        this.ranges = Objects.requireNonNull(ranges, "ranges is null");
        this.nullAllowed = nullAllowed;
        if (ranges.getType().isPrimitive()) {
            throw new IllegalArgumentException("Primitive types not supported: " + ranges.getType());
        }
    }

    public static Domain create(SortedRangeSet ranges, boolean nullAllowed) {
        return new Domain(ranges, nullAllowed);
    }

    public static Domain none(Class<?> type) {
        return new Domain(SortedRangeSet.none(type), false);
    }

    public static Domain all(Class<?> type) {
        return new Domain(SortedRangeSet.of(Range.all(type), new Range[0]), true);
    }

    public static Domain onlyNull(Class<?> type) {
        return new Domain(SortedRangeSet.none(type), true);
    }

    public static Domain notNull(Class<?> type) {
        return new Domain(SortedRangeSet.all(type), false);
    }

    public static Domain singleValue(Comparable<?> value) {
        return new Domain(SortedRangeSet.of(Range.equal(value), new Range[0]), false);
    }

    @JsonIgnore
    public Class<?> getType() {
        return this.ranges.getType();
    }

    @JsonProperty
    public SortedRangeSet getRanges() {
        return this.ranges;
    }

    @JsonProperty
    public boolean isNullAllowed() {
        return this.nullAllowed;
    }

    @JsonIgnore
    public boolean isNone() {
        return this.equals(Domain.none(this.getType()));
    }

    @JsonIgnore
    public boolean isAll() {
        return this.equals(Domain.all(this.getType()));
    }

    @JsonIgnore
    public boolean isSingleValue() {
        return !this.nullAllowed && this.ranges.isSingleValue();
    }

    @JsonIgnore
    public Comparable<?> getSingleValue() {
        if (!this.isSingleValue()) {
            throw new IllegalStateException("Domain is not a single value");
        }
        return this.ranges.getSingleValue();
    }

    public boolean includesValue(Comparable<?> value) {
        Objects.requireNonNull(value, "value is null");
        return this.ranges.includesMarker(Marker.exactly(value));
    }

    public boolean overlaps(Domain other) {
        this.checkTypeCompatibility(other);
        return !this.intersect(other).isNone();
    }

    public boolean contains(Domain other) {
        this.checkTypeCompatibility(other);
        return this.union(other).equals(this);
    }

    public Domain intersect(Domain other) {
        this.checkTypeCompatibility(other);
        SortedRangeSet intersectedRanges = this.getRanges().intersect(other.getRanges());
        boolean nullAllowed = this.isNullAllowed() && other.isNullAllowed();
        return new Domain(intersectedRanges, nullAllowed);
    }

    public Domain union(Domain other) {
        this.checkTypeCompatibility(other);
        SortedRangeSet unionRanges = this.getRanges().union(other.getRanges());
        boolean nullAllowed = this.isNullAllowed() || other.isNullAllowed();
        return new Domain(unionRanges, nullAllowed);
    }

    public static Domain union(List<Domain> domains) {
        if (domains.size() == 1) {
            return domains.get(0);
        }
        boolean nullAllowed = false;
        ArrayList<SortedRangeSet> ranges = new ArrayList<SortedRangeSet>();
        for (Domain domain : domains) {
            ranges.add(domain.getRanges());
            nullAllowed = nullAllowed || domain.nullAllowed;
        }
        return new Domain(SortedRangeSet.union(ranges), nullAllowed);
    }

    public Domain complement() {
        return new Domain(this.ranges.complement(), !this.nullAllowed);
    }

    public Domain subtract(Domain other) {
        this.checkTypeCompatibility(other);
        SortedRangeSet subtractedRanges = this.getRanges().subtract(other.getRanges());
        boolean nullAllowed = this.isNullAllowed() && !other.isNullAllowed();
        return new Domain(subtractedRanges, nullAllowed);
    }

    private void checkTypeCompatibility(Domain domain) {
        if (!this.getType().equals(domain.getType())) {
            throw new IllegalArgumentException(String.format("Mismatched Domain types: %s vs %s", this.getType(), domain.getType()));
        }
    }

    public int hashCode() {
        return Objects.hash(this.ranges, this.nullAllowed);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Domain other = (Domain)obj;
        return Objects.equals(this.ranges, other.ranges) && Objects.equals(this.nullAllowed, other.nullAllowed);
    }

    public String toString() {
        ArrayList<Object> values = new ArrayList<Object>();
        if (this.nullAllowed) {
            values.add("NULL");
        }
        for (Range range : this.ranges) {
            values.add(range);
        }
        return ((Object)values).toString();
    }
}

