/*
 * Decompiled with CFR 0.152.
 */
package com.documents4j.job;

import com.documents4j.api.IFileConsumer;
import com.documents4j.api.IInputStreamConsumer;
import com.documents4j.job.DeleteFileOnCloseInputStream;
import com.documents4j.throwables.FileSystemInteractionException;
import com.google.common.base.MoreObjects;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InputStreamConsumerToFileConsumer
implements IFileConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(InputStreamConsumerToFileConsumer.class);
    private final IInputStreamConsumer inputStreamConsumer;

    public InputStreamConsumerToFileConsumer(IInputStreamConsumer inputStreamConsumer) {
        this.inputStreamConsumer = inputStreamConsumer;
    }

    public void onComplete(File file) {
        try {
            this.inputStreamConsumer.onComplete((InputStream)new DeleteFileOnCloseInputStream(file));
        }
        catch (IOException e) {
            throw new FileSystemInteractionException(String.format("Could not process file: %s", file), (Throwable)e);
        }
    }

    public void onCancel(File file) {
        try {
            this.inputStreamConsumer.onCancel();
        }
        finally {
            InputStreamConsumerToFileConsumer.tryDelete(file);
        }
    }

    public void onException(File file, Exception e) {
        try {
            this.inputStreamConsumer.onException(e);
        }
        finally {
            InputStreamConsumerToFileConsumer.tryDelete(file);
        }
    }

    private static void tryDelete(File file) {
        if (file.exists() && !file.delete()) {
            LOGGER.warn("Could not delete target file {} after unsuccessful conversion", (Object)file);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(InputStreamConsumerToFileConsumer.class).add("inputStreamConsumer", (Object)this.inputStreamConsumer).toString();
    }
}

