/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.formsfx.view.util;

import java.util.List;

public interface ViewMixin {
    public List<String> getStylesheets();

    default public void init() {
        this.initializeSelf();
        this.initializeParts();
        this.layoutParts();
        this.setupEventHandlers();
        this.setupValueChangedListeners();
        this.setupBindings();
    }

    default public void initializeSelf() {
    }

    public void initializeParts();

    public void layoutParts();

    default public void setupEventHandlers() {
    }

    default public void setupValueChangedListeners() {
    }

    default public void setupBindings() {
    }

    default public void addStylesheetFiles(String ... stylesheetFile) {
        for (String file : stylesheetFile) {
            String stylesheet = this.getClass().getResource(file).toExternalForm();
            this.getStylesheets().add(stylesheet);
        }
    }
}

